/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.beans.Beans;
import java.beans.PropertyEditor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public abstract class PropertySupport
extends Node.Property {
    private boolean canR;
    private boolean canW;

    public PropertySupport(String name, Class type, String displayName, String shortDescription, boolean canR, boolean canW) {
        super(type);
        this.setName(name);
        this.setDisplayName(displayName);
        this.setShortDescription(shortDescription);
        this.canR = canR;
        this.canW = canW;
    }

    public boolean canRead() {
        return this.canR;
    }

    public boolean canWrite() {
        return this.canW;
    }

    public static final class Name
    extends PropertySupport {
        private final Node node;
        static /* synthetic */ Class class$org$openide$nodes$PropertySupport;
        static /* synthetic */ Class class$java$lang$String;

        public Name(Node node) {
            this(node, NbBundle.getBundle(class$org$openide$nodes$PropertySupport == null ? (class$org$openide$nodes$PropertySupport = Name.class$("org.openide.nodes.PropertySupport")) : class$org$openide$nodes$PropertySupport).getString("CTL_StandardName"), NbBundle.getBundle(class$org$openide$nodes$PropertySupport == null ? (class$org$openide$nodes$PropertySupport = Name.class$("org.openide.nodes.PropertySupport")) : class$org$openide$nodes$PropertySupport).getString("CTL_StandardHint"));
        }

        public Name(Node node, String propName, String hint) {
            super("name", class$java$lang$String == null ? (class$java$lang$String = Name.class$("java.lang.String")) : class$java$lang$String, propName, hint, true, node.canRename());
            this.node = node;
        }

        public Object getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.node.getName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (!(val instanceof String)) {
                throw new IllegalAccessException();
            }
            String oldName = this.node.getName();
            this.node.setName((String)val);
            this.node.firePropertyChange("name", oldName, val);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static abstract class WriteOnly
    extends PropertySupport {
        public WriteOnly(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription, false, true);
        }

        public Object getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new IllegalAccessException("Cannod read from WriteOnly property");
        }
    }

    public static abstract class ReadOnly
    extends PropertySupport {
        public ReadOnly(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription, true, false);
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new IllegalAccessException("Cannot write to ReadOnly property");
        }
    }

    public static abstract class ReadWrite
    extends PropertySupport {
        public ReadWrite(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription, true, true);
        }
    }

    public static class Reflection
    extends Node.Property {
        protected Object instance;
        private Method setter;
        private Method getter;
        private Class propertyEditorClass;
        static /* synthetic */ Class class$java$lang$Object;

        public Reflection(Object instance, Class valueType, Method getter, Method setter) {
            super(valueType);
            if (getter != null && !Modifier.isPublic(getter.getModifiers())) {
                throw new IllegalArgumentException("Cannot use a non-public getter " + getter);
            }
            if (setter != null && !Modifier.isPublic(setter.getModifiers())) {
                throw new IllegalArgumentException("Cannot use a non-public setter " + setter);
            }
            this.instance = instance;
            this.setter = setter;
            this.getter = getter;
        }

        public Reflection(Object instance, Class valueType, String getter, String setter) throws NoSuchMethodException {
            this(instance, valueType, getter == null ? null : Reflection.findAccessibleClass(instance.getClass()).getMethod(getter, new Class[0]), setter == null ? null : Reflection.findAccessibleClass(instance.getClass()).getMethod(setter, valueType));
        }

        private static Class findAccessibleClass(Class clazz) {
            if (Modifier.isPublic(clazz.getModifiers())) {
                return clazz;
            }
            Class sup = clazz.getSuperclass();
            if (sup == null) {
                return class$java$lang$Object == null ? (class$java$lang$Object = Reflection.class$("java.lang.Object")) : class$java$lang$Object;
            }
            return Reflection.findAccessibleClass(sup);
        }

        public Reflection(Object instance, Class valueType, String property) throws NoSuchMethodException {
            this(instance, valueType, Reflection.firstLetterToUpperCase(property, "get"), Reflection.firstLetterToUpperCase(property, "set"));
        }

        private static String firstLetterToUpperCase(String s, String pref) {
            switch (s.length()) {
                case 0: {
                    return pref;
                }
                case 1: {
                    return pref + Character.toUpperCase(s.charAt(0));
                }
            }
            return pref + Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }

        public boolean canRead() {
            return this.getter != null;
        }

        public Object getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.getter == null) {
                throw new IllegalAccessException();
            }
            Object valideInstance = Beans.getInstanceOf(this.instance, this.getter.getDeclaringClass());
            try {
                return this.getter.invoke(valideInstance, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                try {
                    ((AccessibleObject)this.getter).setAccessible(true);
                    Object object = this.getter.invoke(valideInstance, new Object[0]);
                    Object var5_4 = null;
                    ((AccessibleObject)this.getter).setAccessible(false);
                    return object;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    ((AccessibleObject)this.getter).setAccessible(false);
                    throw throwable;
                }
            }
        }

        public boolean canWrite() {
            return this.setter != null;
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.setter == null) {
                throw new IllegalAccessException();
            }
            Object valideInstance = Beans.getInstanceOf(this.instance, this.setter.getDeclaringClass());
            try {
                this.setter.invoke(valideInstance, val);
            }
            catch (IllegalAccessException ex) {
                try {
                    ((AccessibleObject)this.setter).setAccessible(true);
                    this.setter.invoke(valideInstance, val);
                    Object var5_4 = null;
                    ((AccessibleObject)this.setter).setAccessible(false);
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    ((AccessibleObject)this.setter).setAccessible(false);
                    throw throwable;
                }
            }
        }

        public PropertyEditor getPropertyEditor() {
            if (this.propertyEditorClass != null) {
                try {
                    return (PropertyEditor)this.propertyEditorClass.newInstance();
                }
                catch (InstantiationException ex) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return super.getPropertyEditor();
        }

        public void setPropertyEditorClass(Class clazz) {
            this.propertyEditorClass = clazz;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

