/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.enum.FilterEnumeration;

public class FileSystemCapability {
    public static final FileSystemCapability ALL = new FileSystemCapability(){

        public boolean capableOf(FileSystemCapability c) {
            return true;
        }
    };
    public static final FileSystemCapability COMPILE = new FileSystemCapability();
    public static final FileSystemCapability EXECUTE = new FileSystemCapability();
    public static final FileSystemCapability DEBUG = new FileSystemCapability();
    public static final FileSystemCapability DOC = new FileSystemCapability();

    public boolean capableOf(FileSystemCapability c) {
        return c == this;
    }

    public Enumeration fileSystems() {
        return new FilterEnumeration(ExternalUtil.getRepository().fileSystems()){

            public boolean accept(Object o) {
                FileSystem fs = (FileSystem)o;
                return fs.getCapability().capableOf(FileSystemCapability.this);
            }
        };
    }

    public FileObject findResource(String resName) {
        Enumeration en = this.fileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            FileObject fo = fs.findResource(resName);
            if (fo == null) continue;
            return fo;
        }
        return null;
    }

    public Enumeration findAllResources(String name) {
        Vector<FileObject> v = new Vector<FileObject>(8);
        Enumeration en = this.fileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            FileObject fo = fs.findResource(name);
            if (fo == null) continue;
            v.addElement(fo);
        }
        return v.elements();
    }

    public final FileObject find(String aPackage, String name, String ext) {
        Enumeration en = this.fileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            FileObject fo = fs.find(aPackage, name, ext);
            if (fo == null) continue;
            return fo;
        }
        return null;
    }

    public final Enumeration findAll(String aPackage, String name, String ext) {
        Enumeration en = this.fileSystems();
        Vector<FileObject> ret = new Vector<FileObject>();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            FileObject fo = fs.find(aPackage, name, ext);
            if (fo == null) continue;
            ret.addElement(fo);
        }
        return ret.elements();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    public static class Bean
    extends FileSystemCapability
    implements Serializable {
        private transient PropertyChangeSupport supp;
        private boolean compilation = true;
        private boolean execution = true;
        private boolean debug = true;
        private boolean doc = false;
        static final long serialVersionUID = 627905674809532736L;

        public boolean capableOf(FileSystemCapability c) {
            if (c == COMPILE) {
                return this.compilation;
            }
            if (c == EXECUTE) {
                return this.execution;
            }
            if (c == DEBUG) {
                return this.debug;
            }
            if (c == DOC) {
                return this.doc;
            }
            if (c == ALL) {
                return true;
            }
            if (!(c instanceof Bean)) {
                return false;
            }
            Bean b = (Bean)c;
            return this.compilation == b.compilation && this.execution == b.execution && this.debug == b.debug && this.doc == b.doc;
        }

        public boolean getCompile() {
            return this.compilation;
        }

        public void setCompile(boolean val) {
            if (val != this.compilation) {
                this.compilation = val;
                if (this.supp != null) {
                    this.supp.firePropertyChange("compile", !val ? Boolean.TRUE : Boolean.FALSE, val ? Boolean.TRUE : Boolean.FALSE);
                }
            }
        }

        public boolean getExecute() {
            return this.execution;
        }

        public void setExecute(boolean val) {
            if (val != this.execution) {
                this.execution = val;
                if (this.supp != null) {
                    this.supp.firePropertyChange("execute", !val ? Boolean.TRUE : Boolean.FALSE, val ? Boolean.TRUE : Boolean.FALSE);
                }
            }
        }

        public boolean getDebug() {
            return this.debug;
        }

        public void setDebug(boolean val) {
            if (val != this.debug) {
                this.debug = val;
                if (this.supp != null) {
                    this.supp.firePropertyChange("debug", !val ? Boolean.TRUE : Boolean.FALSE, val ? Boolean.TRUE : Boolean.FALSE);
                }
            }
        }

        public boolean getDoc() {
            return this.doc;
        }

        public void setDoc(boolean val) {
            if (val != this.doc) {
                this.doc = val;
                if (this.supp != null) {
                    this.supp.firePropertyChange("doc", !val ? Boolean.TRUE : Boolean.FALSE, val ? Boolean.TRUE : Boolean.FALSE);
                }
            }
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
            if (this.supp == null) {
                this.supp = new PropertyChangeSupport(this);
            }
            this.supp.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            if (this.supp != null) {
                this.supp.removePropertyChangeListener(l);
            }
        }
    }
}

