/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.explorer.view.ListView;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

final class ListViewDropSupport
implements DropTargetListener,
Runnable {
    boolean active = false;
    boolean dropTargetPopupAllowed;
    DropTarget dropTarget;
    int lastIndex = -1;
    protected ListView view;
    protected JList list;
    protected NodeRenderer.List cellRenderer;

    public ListViewDropSupport(ListView view, JList list) {
        this(view, list, true);
    }

    public ListViewDropSupport(ListView view, JList list, boolean dropTargetPopupAllowed) {
        this.view = view;
        this.list = list;
        this.dropTargetPopupAllowed = dropTargetPopupAllowed;
    }

    public void setDropTargetPopupAllowed(boolean value) {
        this.dropTargetPopupAllowed = value;
    }

    public boolean isDropTargetPopupAllowed() {
        return this.dropTargetPopupAllowed;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        this.lastIndex = this.indexWithCheck(dtde);
        if (this.lastIndex < 0) {
            dtde.rejectDrag();
        } else {
            dtde.acceptDrag(dtde.getDropAction());
            NodeRenderer.dragEnter(this.list.getModel().getElementAt(this.lastIndex));
            this.list.repaint(this.list.getCellBounds(this.lastIndex, this.lastIndex));
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        int index = this.indexWithCheck(dtde);
        if (index < 0) {
            dtde.rejectDrag();
            if (this.lastIndex >= 0) {
                NodeRenderer.dragExit();
                this.list.repaint(this.list.getCellBounds(this.lastIndex, this.lastIndex));
                this.lastIndex = -1;
            }
        } else {
            dtde.acceptDrag(dtde.getDropAction());
            if (this.lastIndex != index) {
                if (this.lastIndex < 0) {
                    this.lastIndex = index;
                }
                NodeRenderer.dragExit();
                NodeRenderer.dragEnter(this.list.getModel().getElementAt(index));
                this.list.repaint(this.list.getCellBounds(this.lastIndex, index));
                this.lastIndex = index;
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
        if (this.lastIndex >= 0) {
            NodeRenderer.dragExit();
            this.list.repaint(this.list.getCellBounds(this.lastIndex, this.lastIndex));
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        int index = this.list.locationToIndex(dtde.getLocation());
        Object obj = this.list.getModel().getElementAt(index);
        Node dropNode = null;
        if (obj instanceof VisualizerNode) {
            dropNode = ((VisualizerNode)obj).node;
        }
        int dropAction = dtde.getDropAction();
        if (index < 0 || !this.canDrop(dropNode, dropAction)) {
            dtde.rejectDrop();
            return;
        }
        PasteType[] pt = DragDropUtilities.getPasteTypes((Node)obj, ExplorerDnDManager.getDefault().getDraggedTransferable(2 == dropAction));
        if (pt == null || pt.length <= 0) {
            dtde.dropComplete(false);
            RequestProcessor.getDefault().post(this, 500);
            return;
        }
        dtde.acceptDrop(dropAction);
        if (dropAction != 0x40000000) {
            DragDropUtilities.performDrop(pt[0]);
        }
    }

    private boolean canDrop(Node n, int dropAction) {
        Transferable trans;
        if (n == null) {
            return false;
        }
        if (ExplorerDnDManager.getDefault().getAllowedDragActions() == 0) {
            return false;
        }
        if (2 == dropAction) {
            Node[] nodes = ExplorerDnDManager.getDefault().getDraggedNodes();
            int i = 0;
            while (i < nodes.length) {
                if (n.equals(nodes[i].getParentNode())) {
                    return false;
                }
                ++i;
            }
        }
        if ((trans = ExplorerDnDManager.getDefault().getDraggedTransferable(2 == dropAction)) == null) {
            return false;
        }
        PasteType[] pt = DragDropUtilities.getPasteTypes(n, trans);
        return pt != null && pt.length != 0;
    }

    public void activate(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        this.getDropTarget().setActive(active);
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        DragDropUtilities.dropNotSuccesfull();
    }

    int indexWithCheck(DropTargetDragEvent dtde) {
        int dropAction = dtde.getDropAction();
        if ((dropAction & this.view.getAllowedDropActions()) == 0) {
            return -1;
        }
        int index = this.list.locationToIndex(dtde.getLocation());
        Object obj = this.list.getModel().getElementAt(index);
        if (obj instanceof VisualizerNode) {
            obj = ((VisualizerNode)obj).node;
        }
        if (index < 0) {
            return -1;
        }
        if (!(obj instanceof Node)) {
            return -1;
        }
        return index;
    }

    DropTarget getDropTarget() {
        if (this.dropTarget == null) {
            this.dropTarget = new DropTarget(this.list, this.view.getAllowedDropActions(), this, false);
        }
        return this.dropTarget;
    }

    NodeRenderer.List getCellRenderer() {
        if (this.cellRenderer == null) {
            this.cellRenderer = (NodeRenderer.List)this.list.getCellRenderer();
        }
        return this.cellRenderer;
    }
}

