/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.core.ui.panels;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.DBElement;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.forte4j.modules.dbmodel.util.SQLTypeUtil;
import com.sun.jdo.api.persistence.mapping.core.FieldHolderState;
import com.sun.jdo.api.persistence.mapping.core.PairState;
import com.sun.jdo.api.persistence.mapping.core.SecondaryTableState;
import com.sun.jdo.api.persistence.mapping.core.TableState;
import com.sun.jdo.modules.persistence.mapping.core.ui.panels.MappingContextPanel;
import com.sun.jdo.modules.persistence.mapping.core.util.DBListElement;
import com.sun.jdo.modules.persistence.mapping.core.util.MappingContext;
import com.sun.jdo.modules.persistence.mapping.core.util.Util;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.ui.ComboBoxTableCellEditor;
import com.sun.jdo.spi.persistence.utility.ui.CustomListCellRenderer;
import com.sun.jdo.spi.persistence.utility.ui.CustomTableCellRenderer;
import com.sun.jdo.spi.persistence.utility.ui.IconWrapper;
import com.sun.jdo.spi.persistence.utility.ui.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;

public class SecondaryTableSelectorPanel
extends MappingContextPanel {
    public static final int PRIMARY_TABLE_NAME_COLUMN = 0;
    public static final int PRIMARY_TABLE_TYPE_COLUMN = 1;
    public static final int SECONDARY_TABLE_NAME_COLUMN = 2;
    public static final int SECONDARY_TABLE_TYPE_COLUMN = 3;
    private JButton AddButton;
    private JComboBox SecondaryTableComboBox;
    private JButton RemoveButton;
    private JTextField PrimaryTableNameField;
    private JTextField SchemaNameField;
    private JTable ReferenceKeyTable;
    private JScrollPane ReferenceKeyTableScrollPane;
    private DefaultTableModel ReferenceKeyTableModel;
    private TableElement secondaryTable;
    private TableState tableStateObject;
    private boolean _listenersDisabled = false;

    public SecondaryTableSelectorPanel(MappingContext mappingContext) {
        super(mappingContext);
        this.initComponents();
        this.ReferenceKeyTableScrollPane.getViewport().setBackground(this.ReferenceKeyTable.getBackground());
        SwingUtils.autosizeTable(this.ReferenceKeyTable);
        this.setButtonStates();
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.getMappingContext().getString("ACSD_Secondary_Table_Setup"));
    }

    private void initComponents() {
        MappingContext mappingContext = this.getMappingContext();
        JLabel schemaNameLabel = new JLabel();
        this.SchemaNameField = new JTextField();
        JLabel primaryTableNameLabel = new JLabel();
        this.PrimaryTableNameField = new JTextField();
        JLabel secondaryTableLabel = new JLabel();
        this.SecondaryTableComboBox = new JComboBox();
        JLabel referenceKeyTableLabel = new JLabel();
        this.ReferenceKeyTableScrollPane = new JScrollPane();
        this.ReferenceKeyTable = new JTable();
        JPanel tableButtonsPanel = new JPanel();
        this.AddButton = new JButton();
        this.RemoveButton = new JButton();
        this.setLayout(new GridBagLayout());
        schemaNameLabel.setText(mappingContext.getString("LBL_Schema"));
        schemaNameLabel.setHorizontalAlignment(4);
        schemaNameLabel.setDisplayedMnemonic(mappingContext.getMnemonic("LBL_Mnemonic_Schema"));
        schemaNameLabel.setLabelFor(this.SchemaNameField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(50, 30, 10, 10);
        this.add((Component)schemaNameLabel, gridBagConstraints);
        this.SchemaNameField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(50, 0, 10, 30);
        this.add((Component)this.SchemaNameField, gridBagConstraints);
        primaryTableNameLabel.setText(mappingContext.getString("LBL_Primary_Table"));
        primaryTableNameLabel.setDisplayedMnemonic(mappingContext.getMnemonic("LBL_Mnemonic_Primary_Table"));
        primaryTableNameLabel.setLabelFor(this.PrimaryTableNameField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 30, 10, 10);
        this.add((Component)primaryTableNameLabel, gridBagConstraints);
        this.PrimaryTableNameField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 30);
        this.add((Component)this.PrimaryTableNameField, gridBagConstraints);
        secondaryTableLabel.setText(mappingContext.getString("LBL_Secondary_Table"));
        secondaryTableLabel.setDisplayedMnemonic(mappingContext.getMnemonic("LBL_Mnemonic_Secondary_Table"));
        secondaryTableLabel.setLabelFor(this.SecondaryTableComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 30, 10, 10);
        this.add((Component)secondaryTableLabel, gridBagConstraints);
        this.SecondaryTableComboBox.setModel(new DefaultComboBoxModel());
        this.SecondaryTableComboBox.setPreferredSize(new Dimension(300, 25));
        SwingUtils.makeLightWeight(this.SecondaryTableComboBox);
        this.SecondaryTableComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SecondaryTableSelectorPanel.this.SecondaryTableComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 30);
        this.add((Component)this.SecondaryTableComboBox, gridBagConstraints);
        referenceKeyTableLabel.setText(mappingContext.getString("LBL_REFKEY"));
        referenceKeyTableLabel.setDisplayedMnemonic(mappingContext.getMnemonic("LBL_Mnemonic_REFKEY"));
        referenceKeyTableLabel.setLabelFor(this.ReferenceKeyTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 30, 10, 10);
        this.add((Component)referenceKeyTableLabel, gridBagConstraints);
        this.ReferenceKeyTableScrollPane.setPreferredSize(new Dimension(450, 100));
        this.ReferenceKeyTableScrollPane.setMinimumSize(new Dimension(450, 100));
        this.ReferenceKeyTable.setPreferredSize(new Dimension(450, 100));
        this.ReferenceKeyTable.setRowHeight(18);
        this.ReferenceKeyTable.setPreferredScrollableViewportSize(new Dimension(450, 100));
        this.ReferenceKeyTableScrollPane.setViewportView(this.ReferenceKeyTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 10, 30);
        this.add((Component)this.ReferenceKeyTableScrollPane, gridBagConstraints);
        tableButtonsPanel.setLayout(new FlowLayout(0, 10, 3));
        tableButtonsPanel.setPreferredSize(new Dimension(80, 100));
        tableButtonsPanel.setMinimumSize(new Dimension(80, 100));
        this.AddButton.setMnemonic(mappingContext.getMnemonic("CTL_Mnemonic_ADD_PAIR"));
        this.AddButton.setText(mappingContext.getString("CTL_ADD_PAIR"));
        this.AddButton.setMargin(new Insets(2, 2, 2, 14));
        this.AddButton.setMinimumSize(new Dimension(77, 27));
        this.AddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SecondaryTableSelectorPanel.this.AddButtonActionPerformed(evt);
            }
        });
        tableButtonsPanel.add(this.AddButton);
        this.RemoveButton.setMnemonic(mappingContext.getMnemonic("CTL_Mnemonic_REMOVE"));
        this.RemoveButton.setText(mappingContext.getString("CTL_REMOVE"));
        this.RemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SecondaryTableSelectorPanel.this.RemoveButtonActionPerformed(evt);
            }
        });
        tableButtonsPanel.add(this.RemoveButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 30);
        this.add((Component)tableButtonsPanel, gridBagConstraints);
    }

    private String[] getColumnNames() {
        MappingContext context = this.getMappingContext();
        return new String[]{context.getString("HD_Primary_Table_Column"), context.getString("HD_Type"), context.getString("HD_Secondary_Table_Column"), context.getString("HD_Type")};
    }

    private void SecondaryTableComboBoxItemStateChanged(ItemEvent evt) {
        if (!this.areListenersDisabled() && 1 == evt.getStateChange()) {
            this.SecondaryTableComboBoxSelected();
        }
    }

    private void RemoveButtonActionPerformed(ActionEvent evt) {
        PairState pairState;
        int[] rows = this.ReferenceKeyTable.getSelectedRows();
        int count = rows != null ? rows.length : 0;
        TableElement mySecondaryTable = this.getSecondaryTable();
        SecondaryTableState secondaryState = this.tableStateObject.editSecondaryTable(mySecondaryTable.getName().getName());
        boolean wasValid = SecondaryTableSelectorPanel.isValidMapping(secondaryState);
        PairState pairState2 = pairState = secondaryState != null ? secondaryState.getPairState() : null;
        if (this.ReferenceKeyTable.isEditing()) {
            this.ReferenceKeyTable.editingStopped(new ChangeEvent(this));
        }
        this.ReferenceKeyTable.clearSelection();
        for (int i = count - 1; i >= 0; --i) {
            int row = rows[i];
            Object lValue = this.ReferenceKeyTableModel.getValueAt(row, 0);
            if ((lValue instanceof DBListElement || lValue instanceof IconWrapper) && pairState != null) {
                pairState.removeColumnPair(row);
            }
            this.ReferenceKeyTableModel.removeRow(row);
        }
        if (rows != null && rows.length > 0) {
            SwingUtils.autosizeTable(this.ReferenceKeyTable);
            SwingUtils.selectNearestRow(this.ReferenceKeyTable, rows[0]);
            SwingUtils.scrollSelectedToVisible(this.ReferenceKeyTable);
        }
        this.firePropertyChange("valid", JavaTypeHelper.valueOf((boolean)wasValid), JavaTypeHelper.valueOf((boolean)SecondaryTableSelectorPanel.isValidMapping(secondaryState)));
    }

    private void AddButtonActionPerformed(ActionEvent evt) {
        this.ReferenceKeyTableModel.addRow(new Object[]{new String()});
        this.insertElementToTable();
        this.setButtonStates();
        SwingUtils.autosizeTable(this.ReferenceKeyTable);
        int idx = this.ReferenceKeyTable.getRowCount() - 1;
        this.ReferenceKeyTable.setRowSelectionInterval(idx, idx);
        SwingUtils.scrollSelectedToVisible(this.ReferenceKeyTable);
        this.ReferenceKeyTable.requestFocus();
    }

    public void requestFocus() {
        if (this.secondaryTable == null) {
            this.SecondaryTableComboBox.requestFocus();
        } else if (this.ReferenceKeyTable.getRowCount() > 0) {
            this.ReferenceKeyTable.requestFocus();
        }
    }

    private boolean areListenersDisabled() {
        return this._listenersDisabled;
    }

    private void setListenersDisabled(boolean flag) {
        this._listenersDisabled = flag;
    }

    public static TableState launchWindow(TableState initialState, TableElement currentTable, MappingContext mappingContext) {
        TableState lNewState = null;
        if (initialState != null) {
            SecondaryTableSelectorPanel lSelectorPanel = new SecondaryTableSelectorPanel(mappingContext);
            TableState lCloneState = (TableState)initialState.clone();
            MessageFormat titleFormat = new MessageFormat(mappingContext.getString("TITLE_Select_Secondary_Table"));
            String className = lCloneState.getMappingClassElement().getName();
            int index = className.lastIndexOf(".");
            final DialogDescriptor descriptor = new DialogDescriptor(lSelectorPanel, titleFormat.format(new Object[]{className.substring(index + 1)}));
            descriptor.setHelpCtx(HelpCtx.findHelp(lSelectorPanel));
            lSelectorPanel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("valid".equals(evt.getPropertyName())) {
                        descriptor.setValid((Boolean)evt.getNewValue());
                    }
                }
            });
            lSelectorPanel.setTableStateObject(lCloneState, currentTable);
            if (currentTable == null) {
                descriptor.setValid(false);
            }
            DialogDisplayer.getDefault().createDialog(descriptor).setVisible(true);
            if (NotifyDescriptor.OK_OPTION == descriptor.getValue()) {
                try {
                    SecondaryTableState secondaryState = null;
                    TableElement secondaryTable = lSelectorPanel.secondaryTable;
                    lNewState = lSelectorPanel.tableStateObject;
                    secondaryState = lNewState.getCurrentStateForTable(lNewState.getCurrentPrimaryTable(), secondaryTable != null ? secondaryTable.getName().getName() : null);
                    if (secondaryState != null) {
                        secondaryState.getPairState().removeDuplicatePairs();
                    }
                }
                catch (IllegalStateException lError) {
                    lError.printStackTrace();
                }
            }
        }
        return lNewState;
    }

    private static boolean isValidMapping(SecondaryTableState secondaryState) {
        if (secondaryState != null) {
            PairState pairState = secondaryState.getPairState();
            return pairState == null || !pairState.hasInvalidPairs() && pairState.hasCompleteRows();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableStateObject(TableState state, TableElement secondaryTable) {
        DefaultComboBoxModel comboModel = (DefaultComboBoxModel)this.SecondaryTableComboBox.getModel();
        DBListElement[] lTableList = null;
        MappingContext context = this.getMappingContext();
        String unmapped = context.getString("VALUE_unmapped");
        this.tableStateObject = state;
        this.buildReferenceKeyTable();
        this.PrimaryTableNameField.setText(this.tableStateObject.getCurrentPrimaryTableName());
        this.SchemaNameField.setText(new DBListElement((DBElement)this.tableStateObject.getCurrentSchema(), true, unmapped).toString());
        this.setListenersDisabled(true);
        try {
            if (secondaryTable == null) {
                List tableList = this.tableStateObject.getSortedUnusedSchemaTables();
                if (tableList != null && tableList.size() > 0) {
                    lTableList = DBListElement.convertArray(tableList, context.getString("VALUE_table"), false);
                }
            } else {
                this.secondaryTable = secondaryTable;
                this.populateTableFromState(this.tableStateObject.getCurrentStateForTable(this.tableStateObject.getCurrentPrimaryTable(), secondaryTable.getName().getName()));
                lTableList = new DBListElement[]{new DBListElement((DBElement)secondaryTable, unmapped)};
                this.SecondaryTableComboBox.setEnabled(false);
            }
            SwingUtils.replaceItems(comboModel, Arrays.asList(lTableList));
            if (secondaryTable != null) {
                this.setButtonStates();
            }
        }
        finally {
            this.setListenersDisabled(false);
        }
    }

    private void populateTableFromState(SecondaryTableState state) {
        if (state != null) {
            PairState pairState = state.getPairState();
            TableState tableState = pairState.getTableState();
            Iterator iterator = pairState.getCompletePairs().iterator();
            this.secondaryTable = this.secondaryTable;
            while (iterator.hasNext()) {
                String[] nextPair = (String[])iterator.next();
                String localName = nextPair[0];
                ColumnElement localColumn = tableState.getColumn(localName);
                String foreignName = nextPair[1];
                ColumnElement foreignColumn = tableState.getColumn(foreignName);
                this.ReferenceKeyTableModel.addRow(new Object[]{this.getValueForColumn(localName, localColumn), this.getTypeForColumn(localName, localColumn), this.getValueForColumn(foreignName, foreignColumn), this.getTypeForColumn(foreignName, foreignColumn)});
            }
            SwingUtils.autosizeTable(this.ReferenceKeyTable);
            if (this.ReferenceKeyTable.getRowCount() > 0) {
                SwingUtils.selectNearestRow(this.ReferenceKeyTable, 0);
            }
        }
        this.firePropertyChange("valid", null, JavaTypeHelper.valueOf((boolean)SecondaryTableSelectorPanel.isValidMapping(state)));
    }

    private Object getValueForColumn(String columnName, ColumnElement column) {
        return column != null ? new DBListElement((DBElement)column, this.getMappingContext().getString("VALUE_unmapped")) : new IconWrapper(columnName.substring(columnName.indexOf(46) + 1), Util.getIllegalIcon());
    }

    private Object getTypeForColumn(String columnName, ColumnElement column) {
        return column != null ? SQLTypeUtil.getSqlTypeString((int)column.getType()) : null;
    }

    private ColumnElement getColumnElementAt(int row, int column) {
        Object value = this.ReferenceKeyTableModel.getValueAt(row, column);
        DBListElement listElement = value instanceof DBListElement ? (DBListElement)value : null;
        return listElement != null ? (ColumnElement)listElement.getFirstElement() : null;
    }

    private Object[] getChoicesForValue(Object[] choices, Object value) {
        if (value instanceof IconWrapper) {
            int length = choices != null ? choices.length : 0;
            Object[] newChoices = new Object[length + 1];
            newChoices[0] = value;
            System.arraycopy(choices, 0, newChoices, 1, length);
            return newChoices;
        }
        return choices;
    }

    public void buildReferenceKeyTable() {
        final MappingContext context = this.getMappingContext();
        this.ReferenceKeyTableModel = new DefaultTableModel(this.getColumnNames(), 0){

            public boolean isCellEditable(int row, int column) {
                return column != 1 && column != 3;
            }
        };
        this.ReferenceKeyTable.setModel(this.ReferenceKeyTableModel);
        this.ReferenceKeyTable.getTableHeader().setReorderingAllowed(false);
        if (this.tableStateObject.getCurrentPrimaryTable() != null) {
            TableColumn column = this.ReferenceKeyTable.getColumn(context.getString("HD_Primary_Table_Column"));
            final String columnString = context.getString("VALUE_column");
            column.setCellRenderer(new CustomTableCellRenderer());
            column.setCellEditor(new ComboBoxTableCellEditor(new CustomListCellRenderer()){

                public final Component getEditorComponent(JTable table, Object value, boolean selected, int row, int col) {
                    List primaryColumns = FieldHolderState.getSortedAllColumns(SecondaryTableSelectorPanel.this.tableStateObject.getCurrentPrimaryTable());
                    Object[] items = DBListElement.convertArray(primaryColumns, columnString, false);
                    this.setItems(SecondaryTableSelectorPanel.this.getChoicesForValue(items, value));
                    return super.getEditorComponent(table, value, selected, row, col);
                }
            });
            column = this.ReferenceKeyTable.getColumn(context.getString("HD_Secondary_Table_Column"));
            column.setCellRenderer(new CustomTableCellRenderer());
            column.setCellEditor(new ComboBoxTableCellEditor(new CustomListCellRenderer()){

                public final Component getEditorComponent(JTable table, Object value, boolean selected, int row, int col) {
                    Object[] objectArray;
                    List compatibleColumns = SecondaryTableSelectorPanel.this.getCompatibleColumns(FieldHolderState.getSortedAllColumns(SecondaryTableSelectorPanel.this.secondaryTable), SecondaryTableSelectorPanel.this.getColumnElementAt(row, 0));
                    if (compatibleColumns.size() > 0) {
                        objectArray = DBListElement.convertArray(compatibleColumns, columnString, false);
                    } else {
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = new DBListElement(columnString);
                        objectArray = objectArray2;
                        objectArray2[1] = new DBListElement(context.getString("VALUE_no_compatible_column"));
                    }
                    Object[] items = objectArray;
                    this.setItems(SecondaryTableSelectorPanel.this.getChoicesForValue(items, value));
                    return super.getEditorComponent(table, value, selected, row, col);
                }
            });
        }
        SwingUtils.autosizeTableColumnWidths(this.ReferenceKeyTable);
        this.ReferenceKeyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                SecondaryTableSelectorPanel.this.setButtonStates();
            }
        });
        this.ReferenceKeyTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent evt) {
                int column = evt.getColumn();
                boolean primaryChanged = column == 0;
                boolean secondaryChanged = column == 2;
                DBListElement chooseElement = new DBListElement(SecondaryTableSelectorPanel.this.getMappingContext().getString("VALUE_column"));
                if (evt.getType() == 0 && (primaryChanged || secondaryChanged)) {
                    TableElement lSecondaryTable = SecondaryTableSelectorPanel.this.getSecondaryTable();
                    int lFirstRow = evt.getFirstRow();
                    int lLastRow = evt.getLastRow();
                    if (lSecondaryTable != null) {
                        SecondaryTableState lState = SecondaryTableSelectorPanel.this.tableStateObject.editSecondaryTable(SecondaryTableSelectorPanel.this.secondaryTable.getName().getName());
                        if (lState != null) {
                            PairState pairState = lState.getPairState();
                            for (int i = lFirstRow; i <= lLastRow; ++i) {
                                ColumnElement local = SecondaryTableSelectorPanel.this.getColumnElementAt(i, 0);
                                ColumnElement foreign = SecondaryTableSelectorPanel.this.getColumnElementAt(i, 2);
                                ColumnElement test = primaryChanged ? local : foreign;
                                String typeString = null;
                                if (test != null) {
                                    ColumnElement otherColumn;
                                    ColumnElement columnElement = otherColumn = primaryChanged ? foreign : local;
                                    if (otherColumn != null && !SQLTypeUtil.isCompatibleType((int)test.getType(), (int)otherColumn.getType())) {
                                        int otherIndex = primaryChanged ? 2 : 0;
                                        int otherType = primaryChanged ? 3 : 1;
                                        SecondaryTableSelectorPanel.this.ReferenceKeyTableModel.setValueAt(chooseElement, i, otherIndex);
                                        SecondaryTableSelectorPanel.this.ReferenceKeyTableModel.setValueAt(null, i, otherType);
                                        if (primaryChanged) {
                                            foreign = null;
                                        } else {
                                            local = null;
                                        }
                                    }
                                    typeString = SQLTypeUtil.getSqlTypeString((int)test.getType());
                                }
                                pairState.editColumnPair(i, local, foreign);
                                SecondaryTableSelectorPanel.this.ReferenceKeyTableModel.setValueAt(typeString, i, primaryChanged ? 1 : 3);
                                if (!primaryChanged || foreign != null) continue;
                                SecondaryTableSelectorPanel.this.ReferenceKeyTableModel.setValueAt(chooseElement, i, 2);
                            }
                        }
                        SecondaryTableSelectorPanel.this.firePropertyChange("valid", null, JavaTypeHelper.valueOf((boolean)SecondaryTableSelectorPanel.isValidMapping(lState)));
                    }
                }
            }
        });
    }

    private void SecondaryTableComboBoxSelected() {
        DBListElement lListElement = this.getSelectedTableElement();
        if (this.secondaryTable != null) {
            this.tableStateObject.removeSecondaryTable(this.secondaryTable.getName().getName());
        }
        this.clearTable();
        if (lListElement != null && lListElement.getFirstElement() != null) {
            this.secondaryTable = (TableElement)lListElement.getFirstElement();
            if (this.secondaryTable != null) {
                SecondaryTableState defaultState = this.tableStateObject.addDefaultStateForTable(this.tableStateObject.getCurrentPrimaryTable(), this.secondaryTable);
                if (defaultState != null && defaultState.getPairState().hasCompleteRows()) {
                    this.populateTableFromState(defaultState);
                    this.ReferenceKeyTable.requestFocus();
                    this.setButtonStates();
                } else {
                    this.tableStateObject.addSecondaryTable(this.secondaryTable);
                    this.AddButtonActionPerformed(new ActionEvent(this.AddButton, 0, ""));
                }
            }
        } else {
            this.firePropertyChange("valid", null, Boolean.FALSE);
        }
        this.setButtonStates();
    }

    public TableElement getSecondaryTable() {
        return this.secondaryTable;
    }

    private void setButtonStates() {
        DBListElement lListElement = this.getSelectedTableElement();
        if (lListElement != null) {
            if (lListElement.getFirstElement() != null) {
                this.AddButton.setEnabled(true);
            } else {
                this.AddButton.setEnabled(false);
            }
        } else {
            this.AddButton.setEnabled(false);
        }
        this.RemoveButton.setEnabled(this.ReferenceKeyTable.getRowCount() > 0 && this.ReferenceKeyTable.getSelectedRowCount() > 0);
    }

    private void clearTable() {
        if (this.ReferenceKeyTable.isEditing()) {
            this.ReferenceKeyTable.editingStopped(new ChangeEvent(this));
        }
        int rowCount = this.ReferenceKeyTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.ReferenceKeyTableModel.removeRow(0);
        }
    }

    private void insertElementToTable() {
        DBListElement lListElement = this.getSelectedTableElement();
        if (lListElement != null && lListElement.getFirstElement() != null) {
            int row = this.ReferenceKeyTableModel.getRowCount() - 1;
            this.secondaryTable = (TableElement)lListElement.getFirstElement();
            if (this.secondaryTable != null) {
                SecondaryTableState lState = this.tableStateObject.editSecondaryTable(this.secondaryTable.getName().getName());
                DBListElement chooseElement = new DBListElement(this.getMappingContext().getString("VALUE_column"));
                if (lState != null) {
                    lState.getPairState().addColumnPair(null, null);
                }
                this.ReferenceKeyTableModel.setValueAt(chooseElement, row, 0);
                this.ReferenceKeyTableModel.setValueAt(chooseElement, row, 2);
            }
        }
    }

    private DBListElement getSelectedTableElement() {
        DBListElement lListElement = null;
        Object lListObject = this.SecondaryTableComboBox.getSelectedItem();
        if (lListObject != null && lListObject instanceof DBListElement) {
            lListElement = (DBListElement)lListObject;
        }
        return lListElement;
    }

    private List getCompatibleColumns(List originals, ColumnElement column) {
        ArrayList returnList = new ArrayList(originals);
        if (column != null) {
            Iterator iterator = returnList.iterator();
            int testType = column.getType();
            while (iterator.hasNext()) {
                ColumnElement nextColumn = (ColumnElement)iterator.next();
                if (SQLTypeUtil.isCompatibleType((int)testType, (int)nextColumn.getType())) continue;
                iterator.remove();
            }
        }
        return returnList;
    }
}

