/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.core.ui.panels;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.DBElement;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.forte4j.modules.dbmodel.util.NameUtil;
import com.sun.jdo.api.persistence.mapping.core.FieldHolderState;
import com.sun.jdo.api.persistence.mapping.core.FieldState;
import com.sun.jdo.api.persistence.mapping.core.MappingStrategy;
import com.sun.jdo.api.persistence.mapping.core.TableState;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.modules.persistence.mapping.core.ui.IFieldMappingEditor;
import com.sun.jdo.modules.persistence.mapping.core.ui.panels.MappingContextPanel;
import com.sun.jdo.modules.persistence.mapping.core.util.DBListElement;
import com.sun.jdo.modules.persistence.mapping.core.util.MappingContext;
import com.sun.jdo.modules.persistence.mapping.core.util.Util;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import com.sun.jdo.spi.persistence.utility.ui.CustomTableCellRenderer;
import com.sun.jdo.spi.persistence.utility.ui.IconWrapper;
import com.sun.jdo.spi.persistence.utility.ui.SortedTableModel;
import com.sun.jdo.spi.persistence.utility.ui.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.UserCancelException;

public class FieldMappingPanel
extends MappingContextPanel
implements IFieldMappingEditor {
    private static final int UP = -1;
    private static final int DOWN = 1;
    private JPanel columnsPanel;
    private JTable ColumnsTable;
    private JButton AddButton;
    private JScrollPane ColumnsTableScrollPane;
    private JButton moveUpButton;
    private JButton RemoveButton;
    private JButton moveDownButton;
    private JTable AvailableColumnsTable;
    private JScrollPane AvailableColumnsTableScrollPane;
    private SortedTableModel availableColumnsTableModel;
    private DefaultTableModel columnsTableModel;
    private PersistenceFieldElement field;
    private FieldHolderState holderState;

    public FieldMappingPanel(MappingContext mappingContext) {
        super(mappingContext);
        this.initComponents();
        this.AvailableColumnsTableScrollPane.getViewport().setBackground(this.AvailableColumnsTable.getBackground());
        this.ColumnsTableScrollPane.getViewport().setBackground(this.ColumnsTable.getBackground());
        this.initAccessibility();
    }

    private void initAccessibility() {
        MappingContext context = this.getMappingContext();
        this.getAccessibleContext().setAccessibleDescription(context.getString("ACSD_Field_Mapping"));
        this.columnsPanel.getAccessibleContext().setAccessibleDescription(context.getString("MSG_FieldMap"));
    }

    private void initComponents() {
        MappingContext mappingContext = this.getMappingContext();
        JTextArea instructionTextArea = new JTextArea();
        JPanel availableColumnsPanel = new JPanel();
        JLabel availableColumnsLabel = new JLabel();
        this.AvailableColumnsTableScrollPane = new JScrollPane();
        this.AvailableColumnsTable = new JTable();
        JPanel buttonPanel = new JPanel();
        this.AddButton = new JButton();
        this.RemoveButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.columnsPanel = new JPanel();
        JLabel columnsLabel = new JLabel();
        this.ColumnsTableScrollPane = new JScrollPane();
        this.ColumnsTable = new JTable();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(530, 250));
        instructionTextArea.setWrapStyleWord(true);
        instructionTextArea.setLineWrap(true);
        instructionTextArea.setEditable(false);
        instructionTextArea.setColumns(60);
        instructionTextArea.setRows(2);
        instructionTextArea.setForeground((Color)UIManager.getDefaults().get("Label.foreground"));
        instructionTextArea.setFont(UIManager.getFont("Label.font"));
        instructionTextArea.setText(mappingContext.getString("MSG_FieldMap"));
        instructionTextArea.setBackground((Color)UIManager.getDefaults().get("Label.background"));
        instructionTextArea.setDisabledTextColor((Color)UIManager.getDefaults().get("Label.foreground"));
        instructionTextArea.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 4.0;
        this.add((Component)instructionTextArea, gridBagConstraints);
        availableColumnsPanel.setLayout(new GridBagLayout());
        availableColumnsPanel.setPreferredSize(new Dimension(200, 130));
        availableColumnsPanel.setMinimumSize(new Dimension(192, 100));
        availableColumnsLabel.setText(mappingContext.getString("LBL_Available_Columns"));
        availableColumnsLabel.setDisplayedMnemonic(mappingContext.getMnemonic("LBL_Mnemonic_Available_Columns"));
        availableColumnsLabel.setLabelFor(this.AvailableColumnsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        availableColumnsPanel.add((Component)availableColumnsLabel, gridBagConstraints);
        this.AvailableColumnsTableScrollPane.setPreferredSize(new Dimension(70, 100));
        this.AvailableColumnsTable.setPreferredSize(new Dimension(70, 100));
        this.AvailableColumnsTable.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.AvailableColumnsTable.setPreferredScrollableViewportSize(new Dimension(70, 100));
        this.AvailableColumnsTable.setMinimumSize(new Dimension(70, 100));
        this.AvailableColumnsTableScrollPane.setViewportView(this.AvailableColumnsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        availableColumnsPanel.add((Component)this.AvailableColumnsTableScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        this.add((Component)availableColumnsPanel, gridBagConstraints);
        buttonPanel.setLayout(new GridBagLayout());
        buttonPanel.setPreferredSize(new Dimension(120, 130));
        buttonPanel.setMinimumSize(new Dimension(120, 100));
        this.AddButton.setMnemonic(mappingContext.getMnemonic("CTL_Mnemonic_ADD"));
        this.AddButton.setText(mappingContext.getString("CTL_ADD_TO"));
        this.AddButton.setMinimumSize(new Dimension(99, 27));
        this.AddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldMappingPanel.this.AddButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 100.0;
        buttonPanel.add((Component)this.AddButton, gridBagConstraints);
        this.RemoveButton.setMnemonic(mappingContext.getMnemonic("CTL_Mnemonic_REMOVE"));
        this.RemoveButton.setText(mappingContext.getString("CTL_REMOVE_TO"));
        this.RemoveButton.setMinimumSize(new Dimension(99, 27));
        this.RemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldMappingPanel.this.RemoveButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        buttonPanel.add((Component)this.RemoveButton, gridBagConstraints);
        this.moveUpButton.setMnemonic(mappingContext.getMnemonic("CTL_Mnemonic_MOVE_UP"));
        this.moveUpButton.setText(mappingContext.getString("CTL_MOVE_UP"));
        this.moveUpButton.setMinimumSize(new Dimension(99, 27));
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldMappingPanel.this.moveUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        buttonPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveDownButton.setMnemonic(mappingContext.getMnemonic("CTL_Mnemonic_MOVE_DOWN"));
        this.moveDownButton.setText(mappingContext.getString("CTL_MOVE_DOWN"));
        this.moveDownButton.setMinimumSize(new Dimension(99, 27));
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldMappingPanel.this.moveDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        buttonPanel.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.weightx = 25.0;
        gridBagConstraints.weighty = 100.0;
        this.add((Component)buttonPanel, gridBagConstraints);
        this.columnsPanel.setLayout(new GridBagLayout());
        this.columnsPanel.setPreferredSize(new Dimension(200, 130));
        this.columnsPanel.setMinimumSize(new Dimension(192, 100));
        columnsLabel.setText(mappingContext.getString("LBL_Col_in_Mapping"));
        columnsLabel.setDisplayedMnemonic(mappingContext.getMnemonic("LBL_Mnemonic_Col_in_Mapping"));
        columnsLabel.setLabelFor(this.ColumnsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.columnsPanel.add((Component)columnsLabel, gridBagConstraints);
        this.ColumnsTableScrollPane.setPreferredSize(new Dimension(70, 100));
        this.ColumnsTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.ColumnsTable.setPreferredSize(new Dimension(70, 100));
        this.ColumnsTable.setMaximumSize(new Dimension(Integer.MAX_VALUE, 10000));
        this.ColumnsTable.setPreferredScrollableViewportSize(new Dimension(70, 100));
        this.ColumnsTable.setMinimumSize(new Dimension(70, 100));
        this.ColumnsTableScrollPane.setViewportView(this.ColumnsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.columnsPanel.add((Component)this.ColumnsTableScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        this.add((Component)this.columnsPanel, gridBagConstraints);
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        this.moveRow(1);
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        this.moveRow(-1);
    }

    private void RemoveButtonActionPerformed(ActionEvent evt) {
        this.RemoveButton.setEnabled(false);
        if (this.ColumnsTable.getSelectedRowCount() > 0) {
            this.removeRows();
        }
        this.RemoveButton.requestFocus();
    }

    private void AddButtonActionPerformed(ActionEvent evt) {
        this.AddButton.setEnabled(false);
        if (this.AvailableColumnsTable.getSelectedRowCount() > 0) {
            this.addRows();
        }
        this.AddButton.requestFocus();
    }

    public static FieldHolderState launchWindow(FieldHolderState lState, PersistenceFieldElement fieldElement, MappingContext mappingContext) throws UserCancelException {
        if (lState != null && fieldElement != null) {
            FieldMappingPanel lFieldPanel = new FieldMappingPanel(mappingContext);
            String className = fieldElement.getDeclaringClass().getName();
            int index = className.lastIndexOf(".");
            String fullFieldName = className.substring(index + 1) + "." + fieldElement;
            Logger logger = mappingContext.getLogger();
            logger.finest("mapping.module.state.before_state", (Object)(lState != null ? lState.getDebugInfo() : "null"));
            lFieldPanel.setStateObject((FieldHolderState)lState.clone(), fieldElement);
            MessageFormat titleFormat = new MessageFormat(mappingContext.getString("Title_Field_Mapping"));
            final DialogDescriptor descriptor = new DialogDescriptor(lFieldPanel, titleFormat.format(new Object[]{fullFieldName}));
            Object ret = null;
            descriptor.setHelpCtx(HelpCtx.findHelp(lFieldPanel));
            lFieldPanel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("valid".equals(evt.getPropertyName())) {
                        descriptor.setValid((Boolean)evt.getNewValue());
                    }
                }
            });
            descriptor.setValid(FieldMappingPanel.isValidMapping(lState, fieldElement));
            DialogDisplayer.getDefault().createDialog(descriptor).setVisible(true);
            ret = descriptor.getValue();
            if (ret == NotifyDescriptor.OK_OPTION) {
                try {
                    FieldHolderState lNewState = (FieldHolderState)lFieldPanel.getPropertyValue();
                    MappingStrategy strategy = new MappingStrategy(mappingContext.getBrandedBundle("com.sun.jdo.api.persistence.mapping.core.Bundle"));
                    logger.finest("mapping.module.state.after_state", (Object)(lNewState != null ? lNewState.getDebugInfo() : "null"));
                    if (Util.checkForWarning(strategy.prepareAttach(lState, lNewState))) {
                        return lNewState;
                    }
                }
                catch (IllegalStateException lError) {
                    lError.printStackTrace();
                }
            } else if (ret == NotifyDescriptor.CANCEL_OPTION || ret == NotifyDescriptor.CLOSED_OPTION) {
                throw new UserCancelException();
            }
        }
        return lState;
    }

    private void buildTables() {
        FieldHolderState holder = this.holderState;
        TableState tableState = holder.getTableState();
        List lMappedColumns = holder.getCurrentMapping(this.field);
        ArrayList lColumns = new ArrayList(holder.getSortedAllColumns());
        ArrayList mappedArray = lMappedColumns != null ? new ArrayList(lMappedColumns) : new ArrayList();
        MappingContext context = this.getMappingContext();
        String unmapped = context.getString("VALUE_unmapped");
        String columnHeader = context.getString("HD_Column");
        Object[] lColumnList = new String[]{context.getString("HD_Table"), columnHeader};
        Icon illegalIcon = Util.getIllegalIcon();
        int i = 0;
        int count = mappedArray.size();
        for (i = 0; i < count; ++i) {
            String mappedName = (String)mappedArray.get(i);
            Iterator iterator = lColumns.iterator();
            while (iterator.hasNext()) {
                String testName = NameUtil.getRelativeMemberName((String)((ColumnElement)iterator.next()).getName().getFullName());
                if (!mappedName.equals(testName)) continue;
                iterator.remove();
            }
        }
        int colCount = lColumns.size();
        Object[][] lRowData = new Object[colCount][2];
        for (i = 0; i < colCount; ++i) {
            ColumnElement lElement = (ColumnElement)lColumns.get(i);
            lRowData[i][0] = new DBListElement((DBElement)lElement.getDeclaringTable(), unmapped);
            lRowData[i][1] = new DBListElement((DBElement)lElement, unmapped);
        }
        this.availableColumnsTableModel = new SortedTableModel(new TableComparator(holder.getTableState().getCurrentPrimaryTable())){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.availableColumnsTableModel.setDataVector(lRowData, lColumnList);
        lRowData = new Object[count][2];
        for (i = 0; i < count; ++i) {
            String mappedName = (String)mappedArray.get(i);
            ColumnElement lElement = tableState.getColumn(mappedName);
            boolean foundColumn = lElement != null;
            lRowData[i][0] = foundColumn ? new DBListElement((DBElement)lElement.getDeclaringTable(), unmapped) : new DBListElement(NameUtil.getTableName((String)mappedName));
            lRowData[i][1] = foundColumn ? new DBListElement((DBElement)lElement, unmapped) : new IconWrapper(mappedName.substring(mappedName.indexOf(46) + 1), illegalIcon);
        }
        this.columnsTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.columnsTableModel.setDataVector(lRowData, lColumnList);
        this.AvailableColumnsTable.setModel(this.availableColumnsTableModel);
        this.ColumnsTable.setModel(this.columnsTableModel);
        this.ColumnsTable.getColumn(columnHeader).setCellRenderer(new CustomTableCellRenderer());
        this.checkTables();
        SwingUtils.autosizeTableColumnWidths(this.AvailableColumnsTable);
        SwingUtils.autosizeTableColumnWidths(this.ColumnsTable);
        if (this.AvailableColumnsTable.getRowCount() > 0) {
            SwingUtils.selectNearestRow(this.AvailableColumnsTable, 0);
        }
        if (this.ColumnsTable.getRowCount() > 0) {
            SwingUtils.selectNearestRow(this.ColumnsTable, 0);
        }
        this.setButtonStates();
        this.AvailableColumnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                FieldMappingPanel.this.setAddButtonState();
            }
        });
        this.ColumnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                FieldMappingPanel.this.setThreeButtonStates();
            }
        });
    }

    public void setStateObject(FieldHolderState state, PersistenceFieldElement field) {
        this.holderState = state;
        this.setField(field);
        this.buildTables();
    }

    private void setField(PersistenceFieldElement field) {
        this.field = field;
    }

    public void addRows() {
        int[] lRowNos = this.AvailableColumnsTable.getSelectedRows();
        this.ColumnsTable.clearSelection();
        for (int i = 0; i < lRowNos.length; ++i) {
            int lRowNo = lRowNos[i] - i;
            if (lRowNo == -1) continue;
            Object[] lRowData = new Object[]{this.availableColumnsTableModel.getValueAt(lRowNo, 0), this.availableColumnsTableModel.getValueAt(lRowNo, 1)};
            this.getMappingContext().getLogger().finer("mapping.module.fieldmapping.add_column", lRowData[0], lRowData[1]);
            this.availableColumnsTableModel.removeRow(lRowNo);
            this.columnsTableModel.addRow(lRowData);
            int rowIndex = this.columnsTableModel.getRowCount() - 1;
            this.ColumnsTable.addRowSelectionInterval(rowIndex, rowIndex);
        }
        this.checkTables();
        SwingUtils.scrollSelectedToVisible(this.ColumnsTable);
        this.updateStateObject();
    }

    public void removeRows() {
        int[] lRowNos = this.ColumnsTable.getSelectedRows();
        this.AvailableColumnsTable.clearSelection();
        for (int i = 0; i < lRowNos.length; ++i) {
            int lRowNo = lRowNos[i] - i;
            if (lRowNo == -1) continue;
            Object[] lRowData = new Object[]{this.columnsTableModel.getValueAt(lRowNo, 0), this.columnsTableModel.getValueAt(lRowNo, 1)};
            this.getMappingContext().getLogger().finer("mapping.module.fieldmapping.remove_column", lRowData[0], lRowData[1]);
            this.columnsTableModel.removeRow(lRowNo);
            if (!(lRowData[1] instanceof DBListElement)) continue;
            int rowIndex = this.availableColumnsTableModel.mergeRow(lRowData);
            this.AvailableColumnsTable.addRowSelectionInterval(rowIndex, rowIndex);
        }
        this.checkTables();
        SwingUtils.scrollSelectedToVisible(this.AvailableColumnsTable);
        this.updateStateObject();
        this.setThreeButtonStates();
    }

    private void moveRow(int direction) {
        int lRowNo = this.ColumnsTable.getSelectedRow();
        if (lRowNo != -1) {
            int newIndex = lRowNo + 1 * direction;
            this.getMappingContext().getLogger().finer("mapping.module.fieldmapping.move_column", this.columnsTableModel.getValueAt(lRowNo, 0), this.columnsTableModel.getValueAt(lRowNo, 1));
            this.columnsTableModel.moveRow(lRowNo, lRowNo, newIndex);
            this.ColumnsTable.addRowSelectionInterval(newIndex, newIndex);
        }
        SwingUtils.scrollSelectedToVisible(this.ColumnsTable);
        this.updateStateObject();
    }

    private static boolean isValidMapping(FieldHolderState testHolderState, PersistenceFieldElement aField) {
        FieldState fieldState;
        if (testHolderState != null && (fieldState = testHolderState.getCurrentStateForField(aField)) != null) {
            return !fieldState.hasInvalidMapping();
        }
        return true;
    }

    private void updateStateObject() {
        boolean wasValid = FieldMappingPanel.isValidMapping(this.holderState, this.field);
        int count = this.ColumnsTable.getRowCount();
        ArrayList<Object> columns = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            Object value = this.columnsTableModel.getValueAt(i, 1);
            if (value instanceof IconWrapper) {
                columns.add(this.columnsTableModel.getValueAt(i, 0) + "." + value);
                continue;
            }
            if (!(value instanceof DBListElement)) continue;
            columns.add(((DBListElement)value).getFirstElement());
        }
        this.holderState.setCurrentMapping(this.field, columns);
        this.firePropertyChange("valid", JavaTypeHelper.valueOf((boolean)wasValid), JavaTypeHelper.valueOf((boolean)FieldMappingPanel.isValidMapping(this.holderState, this.field)));
    }

    private void setAddButtonState() {
        this.AddButton.setEnabled(this.AvailableColumnsTable.getRowCount() > 0 && this.AvailableColumnsTable.getSelectedRowCount() > 0);
    }

    private void setThreeButtonStates() {
        int selectedRowCount = this.ColumnsTable.getSelectedRowCount();
        int firstSelectedRow = this.ColumnsTable.getSelectedRow();
        boolean hasSelection = this.ColumnsTable.getRowCount() > 0 && selectedRowCount > 0;
        boolean singleSelection = hasSelection && selectedRowCount == 1;
        this.RemoveButton.setEnabled(hasSelection);
        this.moveUpButton.setEnabled(singleSelection && firstSelectedRow > 0);
        this.moveDownButton.setEnabled(singleSelection && firstSelectedRow < this.ColumnsTable.getRowCount() - 1);
    }

    private void setButtonStates() {
        this.setAddButtonState();
        this.setThreeButtonStates();
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.holderState;
    }

    public Component getComponent() {
        return this;
    }

    private final void checkTables() {
        SwingUtils.autosizeTable(this.AvailableColumnsTable);
        SwingUtils.autosizeTable(this.ColumnsTable);
    }

    private static class TableComparator
    implements Comparator {
        private TableElement primaryTable = null;

        public TableComparator(TableElement pt) {
            this.setPrimaryTable(pt);
        }

        public int compare(Object o1, Object o2) {
            TableElement t2;
            if (!(o1 instanceof List) || !(o2 instanceof List)) {
                throw new ClassCastException();
            }
            Object oc1 = ((List)o1).get(1);
            Object oc2 = ((List)o2).get(1);
            if (!(oc1 instanceof DBListElement) || !(oc2 instanceof DBListElement)) {
                throw new ClassCastException();
            }
            ColumnElement c1 = (ColumnElement)((DBListElement)oc1).getFirstElement();
            ColumnElement c2 = (ColumnElement)((DBListElement)oc2).getFirstElement();
            TableElement t1 = c1.getDeclaringTable();
            if (t1.equals((Object)(t2 = c2.getDeclaringTable()))) {
                return c1.compareTo((Object)c2);
            }
            if (t1.equals((Object)this.primaryTable)) {
                return -1;
            }
            if (t2.equals((Object)this.primaryTable)) {
                return 1;
            }
            return t1.compareTo((Object)t2);
        }

        public boolean equals(Object o) {
            if (this.primaryTable == null || !(o instanceof TableComparator)) {
                return false;
            }
            return this.primaryTable.equals((Object)((TableComparator)o).primaryTable);
        }

        public void setPrimaryTable(TableElement pt) {
            this.primaryTable = pt;
        }
    }
}

