/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.websrv.wizard;

import com.sun.enterprise.tools.deployment.ui.shared.WSDLParser;
import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledHTMLText;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.websrv.wizard.WebServiceWizard;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.help.CSH;

public class WSDLPanel
extends UIPanel {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WSDLPanel.class);
    private static final String WSDL_PNL_ACC_DSC = localStrings.getLocalString("ui.wsdlpanel.acc_dsc", "Provide the WSDL file for the web service, and the package name to be used for the generated classes.");
    static final String WSDL_FILE = localStrings.getLocalString("ui.wsdlpanel.wsdl_file.tflabel", "WSDL File:");
    private static final String WSDL_FILE_ACC_DESC = localStrings.getLocalString("ui.wsdlpanel.wsdl_file.acc_desc", "Use the Browse button to provide the location of the WSDL file.");
    private static final String WSDL_FILE_MNEMONIC = localStrings.getLocalString("ui.wsdlpanel.wsdl_file.mnemonic", "W");
    private static final String WSDL_BROWSER_MN = localStrings.getLocalString("ui.wsdlpanel.wsdl_browser.mnemonic", "r");
    static final String PKG_NAME = localStrings.getLocalString("ui.wsdlpanel.pkg_name.tflabel", "Package Name:");
    private static final String PKG_NAME_ACC_DESC = localStrings.getLocalString("ui.wsdlpanel.pkg_name.acc_desc", "Provide the package name to be used for the generated classes.");
    private static final String PKG_NAME_MNEMONIC = localStrings.getLocalString("ui.wsdlpanel.pkg_name.mnemonic", "P");
    private static final String GEN_JAXRPC_STUBS = localStrings.getLocalString("ui.wsdlpanel.gen_non_portable.tflabel", "Generate JAX-RPC Stubs");
    private static final String GEN_JAXRPC_STUBS_DESC1 = localStrings.getLocalString("ui.wsdlpanel.gen_non_portable.desc1", "If you are creating a stand-alone Java client, you can choose to have non-portable JAX-RPC stubs generated.");
    private static final String GEN_JAXRPC_STUBS_DESC2 = localStrings.getLocalString("ui.wsdlpanel.gen_non_portable.desc2", "These objects are used by the client to communicate with the service.");
    private static final String GEN_JAXRPC_STUBS_DESC3 = localStrings.getLocalString("ui.wsdlpanel.gen_non_portable.desc3", "They are not required for clients that are J2EE components (e.g. EJB's or servlets).");
    private static final String GEN_JAXRPC_STUBS_DESC4 = "<I>&nbsp;&nbsp;&nbsp;" + GEN_JAXRPC_STUBS_DESC2 + "<br>&nbsp;&nbsp;&nbsp;" + GEN_JAXRPC_STUBS_DESC3 + "</I>";
    private static final String GEN_JAXRPC_STUBS_DESC5 = GEN_JAXRPC_STUBS_DESC1 + "<P>" + GEN_JAXRPC_STUBS_DESC4;
    private static final String GEN_JAXRPC_STUBS_ACC_DESC = GEN_JAXRPC_STUBS_DESC1 + GEN_JAXRPC_STUBS_DESC2 + GEN_JAXRPC_STUBS_DESC3;
    private static final String GEN_JAXRPC_STUBS_MN = localStrings.getLocalString("ui.wsdlpanel.gen_non_portable.mnemonic", "G");
    private static String endpointHelpID = "WsdlEndpoint";
    private static String clientHelpID = "WsdlClient";
    private UIPanel wsdlPanel = null;
    private UITitledTextField wsdlFile = null;
    private UITitledTextField pkgName = null;
    private UIPanel genStubsPanel = null;
    private UITitledHTMLText genStubsDesc = null;
    private UICheckBox genNonPortable = null;
    private String wsName = null;

    private static final String NOT_FILE_ERR(String v0) {
        return localStrings.getLocalString("ui.wsdlpanel.notfile.err", "WSDL File: {0} is a directory. Please specify a file.", new Object[]{v0});
    }

    private static final String DOESNT_EXIST_ERR(String v0) {
        return localStrings.getLocalString("ui.wsdlpanel.doesntexist.err", "WSDL File: {0} does not exist.  Please select an existing WSDL file.", new Object[]{v0});
    }

    private static final String INVALID_WSDL_ERR(String v0) {
        return localStrings.getLocalString("ui.wsdlpanel.invalidwsdl.err", "WSDL File: {0} is invalid.  See the logfile for more details.", new Object[]{v0});
    }

    private static final String INVALID_PKG_START(String v0) {
        return localStrings.getLocalString("ui.wsdlpanel.invalidpkgstart.err", "Package Name: {0} must start with a letter, an underscore, or a Unicode currency character.", new Object[]{v0});
    }

    private static final String INVALID_PKG_NAME(String v0, String v1) {
        return localStrings.getLocalString("ui.wsdlpanel.invalidpkgname.err", "Package Name: {0} contains illegal characters: {1}", new Object[]{v0, v1});
    }

    public String getHelpID() {
        return this.isGenStubsPanelVisible() ? clientHelpID : endpointHelpID;
    }

    public WSDLPanel() {
        super(WebServiceWizard.WIZARD_TITLE_NEW + " " + WebServiceWizard.WSDL_TITLE, WSDL_PNL_ACC_DSC);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        this.wsdlPanel = new UIPanel(gridbag);
        c.weightx = 1.0;
        c.weighty = 0.1;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 11;
        this.add((Component)this.wsdlPanel, c);
        this.wsdlFile = new UITitledTextField(WSDL_FILE, false);
        this.wsdlFile.setMnemonic(WSDL_FILE_MNEMONIC.charAt(0));
        this.wsdlFile.setToolTipText(WSDL_FILE_ACC_DESC);
        this.wsdlFile.setAccessibleDescription(WSDL_FILE_ACC_DESC);
        this.wsdlFile.setBrowserFilterKey("AllFiles");
        this.wsdlFile.setBrowserMnemonic(WSDL_BROWSER_MN.charAt(0));
        this.wsdlFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String wsdl = WSDLPanel.this.wsdlFile.getText();
                if (WSDLPanel.this.isWsdlFileValid(wsdl, false)) {
                    WSDLPanel.this.defaultPkgName(wsdl);
                    WSDLPanel.this.defaultWebServiceName(wsdl);
                }
            }
        });
        this.wsdlFile.setRequired(true);
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(20, 20, 15, 200);
        c.fill = 2;
        c.anchor = 10;
        this.wsdlPanel.add((Component)this.wsdlFile, c);
        this.pkgName = new UITitledTextField(PKG_NAME, false);
        this.pkgName.setMnemonic(PKG_NAME_MNEMONIC.charAt(0));
        this.pkgName.setToolTipText(PKG_NAME_ACC_DESC);
        this.pkgName.setAccessibleDescription(PKG_NAME_ACC_DESC);
        this.pkgName.setRequired(true);
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(5, 20, 5, 450);
        this.wsdlPanel.add((Component)this.pkgName, c);
        this.genStubsPanel = new UIPanel(gridbag);
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        c.anchor = 11;
        this.add((Component)this.genStubsPanel, c);
        this.genStubsDesc = new UITitledHTMLText(null, false, false);
        this.genStubsDesc.setText(GEN_JAXRPC_STUBS_DESC5);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        c.anchor = 10;
        this.genStubsPanel.add((Component)this.genStubsDesc, c);
        this.genNonPortable = new UICheckBox(GEN_JAXRPC_STUBS, GEN_JAXRPC_STUBS_MN.charAt(0));
        this.genNonPortable.setAccessibleDescription(GEN_JAXRPC_STUBS_ACC_DESC);
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(5, 20, 5, 5);
        c.fill = 1;
        c.anchor = 10;
        this.genStubsPanel.add((Component)this.genNonPortable, c);
    }

    private void defaultPkgName(String wsdl) {
        String s = FileTools.GetFileName(wsdl, false);
        s = s.toLowerCase();
        this.pkgName.setText(s);
    }

    public void defaultWebServiceName(String wsdl) {
        this.wsName = FileTools.GetFileName(wsdl, false);
    }

    public String getWsdlFile() {
        return this.wsdlFile.getText();
    }

    public String getWebServiceName() {
        return this.wsName;
    }

    public String getPkgName() {
        return this.pkgName.getText();
    }

    public boolean isGenNonPortable() {
        return this.genNonPortable.isSelected();
    }

    public void setGenStubsPanelVisible(boolean visible) {
        this.genStubsPanel.setVisible(visible);
        CSH.setHelpIDString((Component)this, (String)("SW" + this.getHelpID()));
    }

    public boolean isGenStubsPanelVisible() {
        return this.genStubsPanel.isVisible();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isWsdlFileValid(String wsdl, boolean showError) {
        boolean valid = true;
        File f = new File(wsdl);
        if (f.exists()) {
            if (f.isDirectory()) {
                valid = false;
                if (!showError) return valid;
                UIOptionPane.showErrorDialog(this, WSDLPanel.NOT_FILE_ERR(wsdl));
                return valid;
            } else {
                try {
                    WSDLParser parser = new WSDLParser(wsdl);
                    return valid;
                }
                catch (Exception e) {
                    valid = false;
                    if (!showError) return valid;
                    UIOptionPane.showErrorDialog(this, WSDLPanel.INVALID_WSDL_ERR(wsdl));
                    Print.printStackTrace((String)WSDLPanel.INVALID_WSDL_ERR(wsdl), (Throwable)e);
                }
            }
            return valid;
        } else {
            valid = false;
            if (!showError) return valid;
            UIOptionPane.showErrorDialog(this, WSDLPanel.DOESNT_EXIST_ERR(wsdl));
        }
        return valid;
    }

    public boolean isPkgNameValid(String pkg, boolean showError) {
        boolean valid = true;
        char c = pkg.charAt(0);
        if (Character.isJavaIdentifierStart(c)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 1; i < pkg.length(); ++i) {
                char ch = pkg.charAt(i);
                if (Character.isJavaIdentifierPart(ch)) continue;
                valid = false;
                sb.append(" " + ch + " ");
            }
            if (!valid && showError) {
                UIOptionPane.showErrorDialog(this, WSDLPanel.INVALID_PKG_NAME(pkg, sb.toString()));
            }
        } else {
            valid = false;
            if (showError) {
                UIOptionPane.showErrorDialog(this, WSDLPanel.INVALID_PKG_START(pkg));
            }
        }
        return valid;
    }
}

