/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.war;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.SecurityRoleReference;
import com.sun.enterprise.tools.common.dd.SecurityRoleMapping;
import com.sun.enterprise.tools.common.dd.application.SunApplication;
import com.sun.enterprise.tools.common.dd.webapp.Servlet;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.RolesDialog;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIRoleRefsTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JRadioButton;

public class WebComponentSecurityInspector
extends InspectorPane
implements DescriptionInspector.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebComponentSecurityInspector.class);
    private static String TABNAME = localStrings.getLocalString("ui.webcomponentsecurityinspector.tabname", "Security");
    private static String TABNAME_ACC_DSC = localStrings.getLocalString("ui.webcomponentsecurityinspector.tabname.acc_dsc", "Panel to set security properties for a servlet in a web module");
    private static final String SECURITY_IDENTITY = localStrings.getLocalString("ui.webcomponentsecurityinspector.security_identity", "Security Identity");
    private static final String SECURITY_IDENTITY_ACC_DSC = localStrings.getLocalString("at.webcomponentsecurityinspector.security_identity.acc_dsc", "Choose required Security Identity for servlet");
    private static final String USE_CALLER_ID = localStrings.getLocalString("ui.webcomponentsecurityinspector.use_caller_id", "Use Caller ID");
    private static final String RUN_AS_ROLE = localStrings.getLocalString("ui.webcomponentsecurityinspector.run_as_role", "Run As Role");
    private static final String ROLE_NAME = localStrings.getLocalString("ui.webcomponentsecurityinspector.role_name", "Role Name:");
    private static final String USER_IN_ROLE = localStrings.getLocalString("ui.webcomponentsecurityinspector.user_in_role", "User In Role:");
    private static String ROLE_NAME_REQD = localStrings.getLocalString("at.webcomponentsecurityinspector.role_name_reqd", "Role Name is required. Please enter the Role Name or delete the row.");
    private static final String DESCRIPTION_ACC_DSC = localStrings.getLocalString("at.webcomponentsecurityinspector.description.acc_dsc", "Description for Run As Role of Servlet");
    private static String wizardHelpID = "RoleRef";
    private static String deployHelpID = "Security";
    private WebComponentDescriptor descriptor = null;
    private WebBundleDescriptor wbd = null;
    private Servlet sunServlet = null;
    private SunWebApp swa = null;
    private UIControlButtonBox secIdDepBox = null;
    private UIRoleRefsTable roleNamesPanel = null;
    private JRadioButton rbUseCallerId = null;
    private JRadioButton rbRunAsRole = null;
    private UITitledComboBox cbRoleName = null;
    private UITitledComboBox cbUserInRole = null;
    private DescriptionInspector.DialogDisplayButton descInspector = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new WebComponentSecurityInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebComponentDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebComponentDescriptor ? (WebComponentDescriptor)desc : null;
            this.roleNamesPanel.clearTableData();
            if (this.descriptor != null) {
                this.wbd = this.descriptor.getWebBundleDescriptor();
                this.swa = (SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)this.wbd);
                if (this.swa == null) {
                    SunOneUtils.createSunWebApp(this.wbd);
                    this.swa = (SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)this.wbd);
                }
                this.sunServlet = null;
                for (int i = 0; i < this.swa.sizeServlet(); ++i) {
                    if (!this.swa.getServlet(i).getServletName().equals(this.descriptor.getCanonicalName())) continue;
                    this.sunServlet = this.swa.getServlet(i);
                }
            }
        }
    }

    private WebComponentSecurityInspector(String mode) {
        this.setInspectorMode(mode);
        this.initLayout();
    }

    private void initLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(TABNAME_ACC_DSC);
        this.secIdDepBox = new UIControlButtonBox(null, false);
        this.secIdDepBox.getAccessibleContext().setAccessibleDescription(SECURITY_IDENTITY_ACC_DSC);
        this.secIdDepBox.setControlButtonLocation(13);
        UIRadioButtonBox secIdBox = new UIRadioButtonBox(SECURITY_IDENTITY, true);
        this.secIdDepBox.setView(secIdBox);
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        this.add((Component)this.secIdDepBox, c);
        this.secIdDepBox.setVisible(!UIConfig.getConfigBoolean("/WSPack"));
        this.rbUseCallerId = UIRadioButtonBox.createRadioButton(USE_CALLER_ID);
        secIdBox.addItem(this.rbUseCallerId);
        this.rbRunAsRole = UIRadioButtonBox.createRadioButton(RUN_AS_ROLE);
        secIdBox.addItem(this.rbRunAsRole);
        secIdBox.getGBConstraints().insets.left += 25;
        this.cbRoleName = new UITitledComboBox(ROLE_NAME, false);
        this.cbRoleName.addActionItem(RolesDialog.getEditRolesAction(this));
        this.cbRoleName.setClearWhenDisabled(true);
        this.cbRoleName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebComponentSecurityInspector.this.updateRunAsRole();
            }
        });
        secIdBox.addWithGBConstraints(this.cbRoleName);
        secIdBox.addSelectionEnabledComponent(this.cbRoleName, null);
        this.cbUserInRole = new UITitledComboBox(USER_IN_ROLE, false);
        this.cbUserInRole.setSunONE(true);
        this.cbUserInRole.setEditable(true);
        this.cbUserInRole.setClearWhenDisabled(true);
        this.cbUserInRole.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebComponentSecurityInspector.this.updateUserInRole();
            }
        });
        secIdBox.addWithGBConstraints(this.cbUserInRole);
        secIdBox.addSelectionEnabledComponent(this.cbUserInRole, null);
        this.descInspector = new DescriptionInspector.DialogDisplayButton(this);
        this.descInspector.getAccessibleContext().setAccessibleDescription(DESCRIPTION_ACC_DSC);
        secIdBox.addWithGBConstraints(this.descInspector);
        secIdBox.addSelectionEnabledComponent(this.descInspector, null);
        this.rbUseCallerId.setSelected(true);
        secIdBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                boolean useCID = WebComponentSecurityInspector.this.descriptor.getUsesCallerIdentity();
                if (useCID && !WebComponentSecurityInspector.this.rbUseCallerId.isSelected()) {
                    WebComponentSecurityInspector.this.descriptor.setUsesCallerIdentity(false);
                } else if (!useCID && WebComponentSecurityInspector.this.rbUseCallerId.isSelected()) {
                    WebComponentSecurityInspector.this.descriptor.setUsesCallerIdentity(true);
                }
                if (WebComponentSecurityInspector.this.rbUseCallerId.isSelected()) {
                    if (WebComponentSecurityInspector.this.sunServlet != null) {
                        WebComponentSecurityInspector.this.sunServlet.setPrincipalName(null);
                        int w = WebComponentSecurityInspector.this.sunServlet.sizeWebserviceEndpoint();
                        if (w == 0) {
                            WebComponentSecurityInspector.this.sunServlet.setServletName(null);
                            WebComponentSecurityInspector.this.swa.removeServlet(WebComponentSecurityInspector.this.sunServlet);
                            WebComponentSecurityInspector.this.sunServlet = null;
                        }
                    }
                    WebComponentSecurityInspector.this.cbUserInRole.setSelectedIndex(-1);
                }
                if (WebComponentSecurityInspector.this.rbRunAsRole.isSelected()) {
                    if (WebComponentSecurityInspector.this.sunServlet == null) {
                        WebComponentSecurityInspector.this.sunServlet = SunOneUtils.createSunServlet(WebComponentSecurityInspector.this.descriptor);
                        WebComponentSecurityInspector.this.swa.addServlet(WebComponentSecurityInspector.this.sunServlet);
                    }
                    WebComponentSecurityInspector.this.cbUserInRole.setSelectedIndex(-1);
                    WebComponentSecurityInspector.this.updateUserInRole();
                }
                WebComponentSecurityInspector.this.invokeRefresh();
            }
        });
        JButton editRoles = RolesDialog.getEditRolesButton(this);
        this.secIdDepBox.addControlButton(editRoles);
        this.roleNamesPanel = new UIRoleRefsTable(true, "WAR"){

            public Collection getRoleReferences() {
                ArrayList list = new ArrayList();
                Enumeration e = WebComponentSecurityInspector.this.descriptor.getSecurityRoleReferences();
                while (e.hasMoreElements()) {
                    list.add(e.nextElement());
                }
                return list;
            }

            public void addRoleReference(RoleReference roleRef) {
                WebComponentSecurityInspector.this.descriptor.addSecurityRoleReference((SecurityRoleReference)roleRef);
                WebComponentSecurityInspector.this.invokeRefresh();
            }

            public void removeRoleReference(RoleReference roleRef) {
                WebComponentSecurityInspector.this.descriptor.removeSecurityRoleReference((SecurityRoleReference)roleRef);
                WebComponentSecurityInspector.this.invokeRefresh();
            }

            public Roles getRolesDescriptor() {
                return WebComponentSecurityInspector.this.descriptor.getWebBundleDescriptor();
            }

            public void roleReferenceChanged(RoleReference roleRef) {
                WebComponentSecurityInspector.this.descriptor.changed();
                WebComponentSecurityInspector.this.invokeRefresh();
            }
        };
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.roleNamesPanel, c);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        this.roleNamesPanel.refresh();
        if (this.descriptor.getUsesCallerIdentity()) {
            this.rbUseCallerId.setSelected(true);
        } else {
            Set rolesSet;
            WebBundleDescriptor ebd = this.descriptor.getWebBundleDescriptor();
            Vector<String> roleList = new Vector<String>();
            Set set = rolesSet = ebd != null ? ebd.getRoles() : null;
            if (rolesSet != null) {
                Iterator i = rolesSet.iterator();
                while (i.hasNext()) {
                    String rn = i.next().toString();
                    roleList.add(rn);
                }
            }
            Collections.sort(roleList, ListTools.getStringComparator());
            this.cbRoleName.setModel(roleList);
            this.rbRunAsRole.setSelected(true);
            RunAsIdentityDescriptor rad = this.getWebRunAsIdentity();
            if (rad == null) {
                rad = new RunAsIdentityDescriptor("");
                this.descriptor.setRunAsIdentity(rad);
            }
            if (rad.getRoleName().equals("") && this.cbRoleName.getItemCount() > 0) {
                rad.setRoleName(this.cbRoleName.getItemAt(0).toString());
            }
            if (!rad.getRoleName().equals("")) {
                this.cbRoleName.setText(rad.getRoleName());
            }
            if (this.descriptor.getRunAsIdentity() != null) {
                this.descInspector.setDescriptionInspector(this.descriptor.getRunAsIdentity().getDescription(), this.descriptor.getRunAsIdentity().getRoleName(), this, this.descriptor);
            }
            this.cbUserInRole.setModel(this.getUsersInRole(this.cbRoleName.getText(), this.getSecurityRoleMapping()));
            if (this.sunServlet != null && this.sunServlet.getPrincipalName() != null) {
                this.cbUserInRole.setSelectedItem(this.sunServlet.getPrincipalName());
            } else {
                this.cbUserInRole.setSelectedIndex(-1);
            }
        }
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.secIdDepBox.setReadOnly(state, true);
        this.roleNamesPanel.setReadOnly(state);
    }

    public void descriptionUpdated(String desc, Object arg) {
        this.descriptor.getRunAsIdentity().setDescription(desc);
        this.descriptor.changed();
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.roleNamesPanel.getInspectorTableView().getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, ROLE_NAME_REQD);
            }
            return false;
        }
        return true;
    }

    private RunAsIdentityDescriptor getWebRunAsIdentity() {
        return !this.descriptor.getUsesCallerIdentity() ? this.descriptor.getRunAsIdentity() : null;
    }

    private void updateRunAsRole() {
        if (!this.rbRunAsRole.isSelected()) {
            Print.dprintln((String)"Run-As-Role not selected!");
            return;
        }
        if (this.descriptor.getUsesCallerIdentity()) {
            this.descriptor.setUsesCallerIdentity(false);
        }
        if (!this.cbRoleName.getText().equals("")) {
            RunAsIdentityDescriptor rad = this.getWebRunAsIdentity();
            if (rad == null) {
                rad = new RunAsIdentityDescriptor("");
                this.descriptor.setRunAsIdentity(rad);
            }
            String roleName = this.cbRoleName.getText();
            rad.setRoleName(roleName);
        }
        this.invokeRefresh();
    }

    private void updateUserInRole() {
        if (!this.rbRunAsRole.isSelected()) {
            return;
        }
        String user = this.cbUserInRole.getText().trim();
        if (user.equals("") && this.sunServlet.getPrincipalName() != null) {
            this.sunServlet.setPrincipalName(null);
            return;
        }
        String servletName = this.sunServlet.getServletName();
        if (servletName == null) {
            this.sunServlet.setServletName(this.descriptor.getCanonicalName());
        }
        this.sunServlet.setPrincipalName(user);
    }

    private SecurityRoleMapping[] getSecurityRoleMapping() {
        SecurityRoleMapping[] srm = null;
        WebBundleDescriptor wbd = (WebBundleDescriptor)DescriptorTools.getBundleDescriptor((Descriptor)this.descriptor);
        if (DescriptorTools.isStandAlone((Descriptor)wbd)) {
            SunWebApp swa = (SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)wbd);
            srm = swa.getSecurityRoleMapping();
        } else {
            Application app = wbd.getApplication();
            SunApplication sa = (SunApplication)SunOneUtils.getSunDescriptor((Descriptor)app);
            srm = sa.getSecurityRoleMapping();
        }
        return srm;
    }

    private String[] getUsersInRole(String role, SecurityRoleMapping[] srm) {
        String[] users = null;
        if (srm != null) {
            for (int i = 0; i < srm.length; ++i) {
                String roleName = srm[i].getRoleName();
                if (!roleName.equals(role)) continue;
                users = srm[i].getPrincipalName();
                break;
            }
        }
        return users;
    }
}

