/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.war;

import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.LoginConfigurationImpl;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.UserDataConstraintImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIJarPackager;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledCheckBoxList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.war.WebAppRolePicker;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WebAppSecurityInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebAppSecurityInspector.class);
    private static String LIST_NAME = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.list_name", "List");
    private static String LIST_DESC = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.list_desc", "This is a list of items");
    private static final String AUTH_METHOD_SETTINGS_TITLE = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.title", "User Authentication Settings");
    private static final String AUTH_METHOD_SETTINGS_TOOLTIP = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.tooltip", "User Authentication Settings");
    private static final String AUTH_SETTINGS_DETAILS_TOOLTIP = localStrings.getLocalString("at.webappsecurityinspector.auth_settings_details.tooltip", "Enter further settings for either basic or form authentication");
    private static final String AUTH_SETTINGS_REALM_NAME = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_realm_name", "Realm Name:");
    private static final String AUTH_SETTINGS_REALM_NAME_TOOLTIP = localStrings.getLocalString("at.webappsecurityinspector.auth_method_realm_name.tooltip", "Enter realm name to which web server will authenticate user");
    private static final String AUTH_SETTINGS_LOGIN_PAGE = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_login_page", "Login Page:");
    private static final String AUTH_SETTINGS_LOGIN_PAGE_TOOLTIP = localStrings.getLocalString("at.webappsecurityinspector.auth_method_login_page.tooltip", "Select page where user enters login and password");
    private static final String AUTH_SETTINGS_ERROR_PAGE = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_error_page", "Error Page:");
    private static final String AUTH_SETTINGS_ERROR_PAGE_TOOLTIP = localStrings.getLocalString("at.webappsecurityinspector.auth_method_error_page.tooltip", "Select page returned if container cannot authenticate user from login page");
    private static final String AUTH_METHOD = localStrings.getLocalString("ui.webappsecurityinspector.auth_method", "User Authentication Method:");
    private static final String AUTH_METHOD_ACC_DSC = localStrings.getLocalString("at.webappsecurityinspector.auth_method.acc_dsc", "Choose User Authentication Method for Web Application");
    private static final String AUTH_METH_NONE = localStrings.getLocalString("ui.webappsecurityinspector.auth_meth_none", "None");
    private static final String AUTH_METH_BASIC = localStrings.getLocalString("ui.webappsecurityinspector.auth_meth_basic", "Basic");
    private static final String AUTH_METH_CLIENT_CERT = localStrings.getLocalString("ui.webappsecurityinspector.auth_meth_client_cert", "Client Certificate");
    private static final String AUTH_METH_DIGEST = localStrings.getLocalString("ui.webappsecurityinspector.auth_meth_digest", "Digest");
    private static final String AUTH_METH_FORM = localStrings.getLocalString("ui.webappsecurityinspector.auth_meth_form_based", "Form Based");
    private static final String AUTH_METHOD_SETTINGS_BUTTON = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings_button", "Settings...");
    private static final String SECURITY_CONSTRAINTS = localStrings.getLocalString("ui.webappsecurityinspector.security_constraints", "Security constraints");
    private static final String RU_SURE_DEL_SEC_CONSTRAINT = localStrings.getLocalString("ui.webappsecurityinspector.ok_to_delete_security", "Are you sure you want to delete selected security constraint?");
    private static final String DEL_SEC_CONSTRAINT = localStrings.getLocalString("ui.webappsecurityinspector.delete_security", "Delete Security Constraint");
    private static final String FIRST_SELECT_SEC_CONSTRAINT = localStrings.getLocalString("ui.webappsecurityinspector.please_select_security", "You must first select a security constraint from list");
    private static final String WEB_RESOURCE_COLLECTION = localStrings.getLocalString("ui.webappsecurityinspector.webresourcecollections", "Web Resource Collections");
    private static final String NETWORK_SECURITY_REQ = localStrings.getLocalString("ui.webappsecurityinspector.network_security_requirement", "Network Security Requirement:");
    private static final String NETWORK_SECURITY_REQ_ACC_DSC = localStrings.getLocalString("at.webappsecurityinspector.network_security_requirement_acc_dsc", "Choose Network Security Requirement for the Web Application");
    private static final String AUTHORIZED_ROLES = localStrings.getLocalString("ui.webappsecurityinspector.authorizedroles", "Authorized Roles");
    private static String OKTODEL_WEBRES = localStrings.getLocalString("ui.webappsecurityinspector.oktodelete_webrescoll_msg", "Are you sure you want to delete selected web resource collection?");
    private static String DELETE_WEBRES = localStrings.getLocalString("ui.webappsecurityinspector.oktodelete_webrescoll_title", "Delete web resource collection");
    private static String URL_PATTERNS = localStrings.getLocalString("ui.webappsecurityinspector.urlpatterns", "URL patterns");
    private static String OKTODEL_URLPATTERN = localStrings.getLocalString("ui.webappsecurityinspector.oktodelete_urlpattern_msg", "Are you sure you want to delete selected URL pattern?");
    private static String DELETE_URLPATTERN = localStrings.getLocalString("ui.webappsecurityinspector.oktodelete_urlpattern_title", "Delete URL Pattern");
    private static final String HTTP_METHOD = localStrings.getLocalString("ui.webappsecurityinspector.http_method", "HTTP Method");
    private static final char AUTH_METHOD_SETTINGS_BUTTON_MNEMONIC = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings_button_mnemonic", "S").charAt(0);
    private static final char ADD_CONSTRAINTS_MNEMONIC = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.add_cons_button_mnemonic", "A").charAt(0);
    private static final char DELETE_CONSTRAINTS_MNEMONIC = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.del_cons_button_mnemonic", "D").charAt(0);
    private static final char ADD_COLLECT_MNEMONIC = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.add_coll_button_mnemonic", "C").charAt(0);
    private static final char DELETE_COLLECT_MNEMONIC = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.del_coll_button_mnemonic", "L").charAt(0);
    private static final char EDIT_COLLECT_MNEMONIC = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.edit_coll_button_mnemonic", "I").charAt(0);
    private static final char EDIT_ROLE_MNEMONIC = localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.edit_role_button_mnemonic", "R").charAt(0);
    private static final String SECURITY_CONSTRAINT_KEY = "SecurityConstraint";
    private static final String WEB_COLLECTION_KEY = "WRCollection";
    private static final String HTTP_METHOD_DELETE = "DELETE";
    private static final String HTTP_METHOD_GET = "GET";
    private static final String HTTP_METHOD_HEAD = "HEAD";
    private static final String HTTP_METHOD_OPTIONS = "OPTIONS";
    private static final String HTTP_METHOD_POST = "POST";
    private static final String HTTP_METHOD_PUT = "PUT";
    private static final String HTTP_METHOD_TRACE = "TRACE";
    private static final String[] HTTP_METHODS = new String[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"};
    private static final String TABNAME = localStrings.getLocalString("ui.webappsecurityinspector.tabname", "Security");
    protected static String AuthMethNONE = "NONE";
    protected static String AuthMethBASIC = "BASIC";
    protected static String AuthMethFORM = "FORM";
    protected static String AuthMethCLIENT = "CLIENT-CERT";
    protected static String AuthMethDIGEST = "DIGEST";
    private static final String[] AuthMethodType = new String[]{AuthMethNONE, AuthMethBASIC, AuthMethCLIENT, AuthMethDIGEST, AuthMethFORM};
    private static final String[] AuthMethodText = new String[]{AUTH_METH_NONE, AUTH_METH_BASIC, AUTH_METH_CLIENT_CERT, AUTH_METH_DIGEST, AUTH_METH_FORM};
    private static String wizardHelpID = "Security";
    private static String deployHelpID = "Security";
    protected WebBundleDescriptor descriptor = null;
    private UITitledComboBox authMethodCombo = null;
    private UIButton authMethodSettings = null;
    protected LoginConfigurationImpl lastLoginConfig = null;
    private UITitledTable secConstraintTablePane = null;
    private UITitledTable webResCollectionsTable = null;
    private UIControlButtonBox urlPatternPanel = null;
    private JPanel urlTree = null;
    private UIJarPackager jarPackager = null;
    private Vector webWizardContents = null;
    private UITitledComboBox xportGuaranteeCombo = null;
    private UITitledList authConstraintsList = null;
    private UITitledCheckBoxList httpMeth = null;
    String[] transportChoices = UserDataConstraintImpl.getTransportGuaranteeChoices();
    private WebAppRolePicker rolePickerDialog = null;
    private static String authSettingsHelpSetMapID = "WWAuthSettings";
    protected AuthMethodSettingsDialog authMethodDialog = null;

    protected static final String AUTH_SETTINGS_DETAILS(String v0) {
        return localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.details", "Details [{0}]", new Object[]{v0});
    }

    protected static String AuthText2Type(String text) {
        if (text != null) {
            for (int i = 0; i < AuthMethodText.length; ++i) {
                if (!text.equals(AuthMethodText[i])) continue;
                return AuthMethodType[i];
            }
        }
        return AuthMethNONE;
    }

    protected static String AuthType2Text(String type) {
        if (type != null) {
            for (int i = 0; i < AuthMethodType.length; ++i) {
                if (!type.equals(AuthMethodType[i])) continue;
                return AuthMethodText[i];
            }
        }
        return AUTH_METH_NONE;
    }

    public static InspectorPane newInspectorPane(String mode) {
        return new WebAppSecurityInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : (desc instanceof WebComponentDescriptor ? ((WebComponentDescriptor)desc).getWebBundleDescriptor() : null);
            this.secConstraintTablePane.clearTableData();
            this.webResCollectionsTable.clearTableData();
        }
    }

    protected WebAppSecurityInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.authMethodCombo = new UITitledComboBox(AUTH_METHOD, false);
        this.authMethodCombo.setToolTipText(AUTH_METHOD_ACC_DSC);
        this.authMethodCombo.setModel(AuthMethodText);
        this.authMethodCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String lastAuthMeth;
                String authMeth;
                UITitledComboBox cb = WebAppSecurityInspector.this.authMethodCombo;
                if (cb.isSetSelectionUpdate()) {
                    return;
                }
                String selMeth = WebAppSecurityInspector.AuthText2Type((String)cb.getSelectedItem());
                LoginConfigurationImpl loginConfig = (LoginConfigurationImpl)WebAppSecurityInspector.this.descriptor.getLoginConfiguration();
                String string = authMeth = loginConfig != null ? loginConfig.getAuthenticationMethod() : AuthMethNONE;
                if (authMeth.equals(selMeth)) {
                    return;
                }
                String string2 = lastAuthMeth = WebAppSecurityInspector.this.lastLoginConfig != null ? WebAppSecurityInspector.this.lastLoginConfig.getAuthenticationMethod() : AuthMethNONE;
                if (selMeth.equals(lastAuthMeth)) {
                    loginConfig = WebAppSecurityInspector.this.lastLoginConfig;
                } else if (selMeth.equals(AuthMethNONE)) {
                    loginConfig = null;
                } else {
                    loginConfig = new LoginConfigurationImpl();
                    loginConfig.setAuthenticationMethod(selMeth);
                }
                WebAppSecurityInspector.this.descriptor.setLoginConfiguration(loginConfig);
            }
        });
        c.weightx = 0.4;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        this.add((Component)this.authMethodCombo, c);
        this.authMethodSettings = new UIButton(AUTH_METHOD_SETTINGS_BUTTON, AUTH_METHOD_SETTINGS_BUTTON_MNEMONIC);
        this.authMethodSettings.setToolTipText(AUTH_METHOD_SETTINGS_TITLE);
        this.authMethodSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebAppSecurityInspector.this.showAuthMethSettings();
            }
        });
        GridBagConstraints gbc = this.authMethodCombo.getGBConstraintsCopy();
        gbc.weightx = 0.0;
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.fill = 0;
        this.authMethodCombo.add((Component)this.authMethodSettings, gbc);
        c.weightx = 0.6;
        c.weighty = 0.0;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        this.add((Component)new UIPanel(), c);
        UITitledBox secConstraintsPanel = new UITitledBox(SECURITY_CONSTRAINTS, true);
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)secConstraintsPanel, c);
        GridBagConstraints secGBC = secConstraintsPanel.getGBConstraints();
        double w_top = 0.15;
        double w_left = 0.78;
        this.secConstraintTablePane = new UITitledTable(null, false);
        this.secConstraintTablePane.setScriptId(SECURITY_CONSTRAINTS);
        this.secConstraintTablePane.setTableView(new SecurityConstraintsTable(new SecurityConstraintsTableModel()));
        this.secConstraintTablePane.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                WebAppSecurityInspector.this.showSecurityConstraint(lsm.getMinSelectionIndex());
            }
        });
        secGBC.weightx = w_left;
        secGBC.weighty = w_top;
        secGBC.gridx = 0;
        secGBC.gridy = 0;
        secGBC.gridwidth = 1;
        secGBC.gridheight = 1;
        secGBC.insets = new Insets(0, 0, 5, 5);
        secGBC.fill = 1;
        secConstraintsPanel.add((Component)this.secConstraintTablePane, secGBC);
        UIButton addSecConstPB = UIButton.createAddButton(localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.add_cons_button", "Add Constraints"), ADD_CONSTRAINTS_MNEMONIC, new UIActionDispatcher((Object)this, "_addSecurityConst"), false);
        this.secConstraintTablePane.addControlButton(addSecConstPB);
        UIButton delSecConstPB = UIButton.createDeleteButton(localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.del_cons_button", "Delete Constraints..."), DELETE_CONSTRAINTS_MNEMONIC, new UIActionDispatcher((Object)this, "_delSecurityConst"), true);
        this.secConstraintTablePane.addSelectionEnabledButton(delSecConstPB);
        UIPanel filler = new UIPanel();
        secGBC.weightx = 1.0 - w_left;
        secGBC.weighty = w_top;
        secGBC.gridx = 1;
        secGBC.gridy = 0;
        secGBC.gridwidth = 1;
        secGBC.gridheight = 1;
        secGBC.insets = new Insets(0, 0, 0, 5);
        secGBC.fill = 1;
        secConstraintsPanel.add((Component)filler, secGBC);
        UITitledBox weResPanel = new UITitledBox(WEB_RESOURCE_COLLECTION, true);
        secGBC.weightx = w_left;
        secGBC.weighty = 1.0 - w_top;
        secGBC.gridx = 0;
        secGBC.gridy = 1;
        secGBC.gridwidth = 1;
        secGBC.gridheight = 1;
        secGBC.insets = new Insets(0, 0, 0, 5);
        secGBC.fill = 1;
        secConstraintsPanel.add((Component)weResPanel, secGBC);
        this.webResCollectionsTable = new UITitledTable(null, false);
        this.webResCollectionsTable.setScriptId(WEB_RESOURCE_COLLECTION);
        this.webResCollectionsTable.setTableView(new WebResourceCollectionsTable(new WebResourceCollectionsTableModel()));
        this.webResCollectionsTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                WebAppSecurityInspector.this.refreshWebResCollection();
            }
        });
        weResPanel.getGBConstraints().weighty = 0.35;
        weResPanel.addWithGBConstraints(this.webResCollectionsTable);
        this.webResCollectionsTable.setControlButtonLocation(202);
        this.secConstraintTablePane.addComponentToSelectionEnabledList(this.webResCollectionsTable);
        UIButton webResAddPB = UIButton.createAddButton(localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.add_coll_button", "Add Collections"), ADD_COLLECT_MNEMONIC, new UIActionDispatcher((Object)this, "_addWebResCollection"), false);
        webResAddPB.setEnabled(false);
        this.webResCollectionsTable.addControlButton(webResAddPB);
        UIButton webResDelPB = UIButton.createDeleteButton(localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.del_coll_button", "Delete Collections..."), DELETE_COLLECT_MNEMONIC, new UIActionDispatcher((Object)this, "_delWebResCollection"), true);
        webResDelPB.setEnabled(false);
        this.webResCollectionsTable.addSelectionEnabledButton(webResDelPB);
        this.jarPackager = UIJarPackager.newBrowser(this, "webres");
        this.urlTree = (JPanel)((Object)this.jarPackager.getDestinationTreeView());
        this.urlPatternPanel = new UIControlButtonBox(null, false);
        this.urlPatternPanel.setView(this.urlTree);
        this.httpMeth = new UITitledCheckBoxList(HTTP_METHOD, true, false);
        this.httpMeth.setSorted(true);
        this.httpMeth.addCheckBoxItems(HTTP_METHODS);
        this.httpMeth.addActionListener(new UIActionDispatcher((Object)this, "_setHttpMethod"));
        this.jarPackager.setDestinationAccessoryView(this.httpMeth);
        weResPanel.getGBConstraints().weighty = 0.65;
        weResPanel.getGBConstraints().insets.top = 7;
        weResPanel.addWithGBConstraints(this.urlPatternPanel);
        this.webResCollectionsTable.addComponentToSelectionEnabledList(this.urlPatternPanel);
        UIButton webResEditPB = UIButton.createEditButton(localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.edit_coll_button", "Edit Collections..."), EDIT_COLLECT_MNEMONIC, new UIActionDispatcher((Object)this, "_editWebResCollection"), true);
        webResEditPB.setText("   " + webResEditPB.getText() + "  ");
        webResEditPB.setEnabled(false);
        this.urlPatternPanel.addControlButton(webResEditPB);
        this.webResCollectionsTable.addComponentToSelectionEnabledList(webResEditPB);
        UITitledBox reqAuthBox = new UITitledBox(null, false);
        secGBC.weightx = 1.0 - w_left;
        secGBC.weighty = 1.0 - w_top;
        secGBC.gridx = 1;
        secGBC.gridy = 1;
        secGBC.gridwidth = 1;
        secGBC.gridheight = 1;
        secGBC.insets = new Insets(0, 0, 0, 0);
        secGBC.fill = 1;
        secConstraintsPanel.add((Component)reqAuthBox, secGBC);
        this.secConstraintTablePane.addComponentToSelectionEnabledList(reqAuthBox);
        reqAuthBox.setEnabled(false);
        GridBagConstraints raGbc = reqAuthBox.getGBConstraintsCopy();
        this.xportGuaranteeCombo = new UITitledComboBox(NETWORK_SECURITY_REQ, false);
        this.xportGuaranteeCombo.getAccessibleContext().setAccessibleDescription(NETWORK_SECURITY_REQ_ACC_DSC);
        this.xportGuaranteeCombo.setModel(this.transportChoices);
        this.xportGuaranteeCombo.setEnabled(false);
        this.xportGuaranteeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UITitledComboBox cb = WebAppSecurityInspector.this.xportGuaranteeCombo;
                WebAppSecurityInspector.this.handleTransportGuaranteeSelection(!cb.isSetSelectionUpdate());
            }
        });
        raGbc.weighty = 0.0;
        raGbc.fill = 2;
        reqAuthBox.add((Component)this.xportGuaranteeCombo, raGbc);
        this.authConstraintsList = new UITitledList(AUTHORIZED_ROLES, true);
        JList jl = new JList();
        jl.getAccessibleContext().setAccessibleName(LIST_NAME);
        jl.getAccessibleContext().setAccessibleDescription(LIST_DESC);
        this.authConstraintsList.setListView(jl);
        this.authConstraintsList.getListView().setSelectionBackground(Color.white);
        this.authConstraintsList.getListView().setCellRenderer(new SecurityListCellRenderer());
        this.authConstraintsList.setControlButtonLocation(101);
        UIButton authConstEditPB = UIButton.createEditButton(localStrings.getLocalString("ui.webappsecurityinspector.auth_method_settings.edit_role_button", "Edit Roles..."), EDIT_ROLE_MNEMONIC, new UIActionDispatcher((Object)this, "_editAuthConst"), true);
        this.authConstraintsList.addControlButton(authConstEditPB);
        raGbc.weighty = 0.5;
        raGbc.fill = 1;
        raGbc.insets.top = 7;
        reqAuthBox.add((Component)this.authConstraintsList, raGbc);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        LoginConfigurationImpl loginConfig = (LoginConfigurationImpl)this.descriptor.getLoginConfiguration();
        String authMeth = loginConfig != null ? loginConfig.getAuthenticationMethod() : AuthMethNONE;
        this.authMethodCombo.setSelectedItem(WebAppSecurityInspector.AuthType2Text(authMeth));
        if (authMeth.equals(AuthMethFORM) || authMeth.equals(AuthMethBASIC) || authMeth.equals(AuthMethDIGEST)) {
            this.authMethodSettings.setEnabled(true);
        } else {
            this.authMethodSettings.setEnabled(false);
        }
        Vector<Descriptor> secVec = new Vector<Descriptor>();
        HashSet<Descriptor> secSet = new HashSet<Descriptor>();
        Enumeration secEnum = this.descriptor.getSecurityConstraints();
        while (secEnum.hasMoreElements()) {
            Descriptor d = (Descriptor)secEnum.nextElement();
            if (d.getDisplayName().equals("")) {
                secVec.add(d);
                continue;
            }
            secSet.add(d);
        }
        if (secVec.size() > 0) {
            Enumeration e = secVec.elements();
            while (e.hasMoreElements()) {
                Descriptor d = (Descriptor)e.nextElement();
                String n = DescriptorTools.createUniqueName(SECURITY_CONSTRAINT_KEY, secSet);
                d.setDisplayName(n);
                secSet.add(d);
            }
        }
        this.secConstraintTablePane.updateTableData(secSet);
        this.showSecurityConstraint(this.getSelectedSecurityConstraint());
        this.refreshWebResCollection();
    }

    private void refreshWebResCollection() {
        WebResourceCollectionImpl w = this.getSelectedWebResCollection();
        if (w == null) {
            for (int r = 0; r < this.httpMeth.getListDataCount(); ++r) {
                this.httpMeth.setCheckBoxSelectionAt(r, false);
            }
            ((UIJarPackager.PackagerTreeViewInterface)((Object)this.urlTree)).updateTreeView(null);
            this.urlTree.setEnabled(false);
        } else {
            Vector methDataList = ListTools.toList(w.getHttpMethods());
            for (int r = 0; r < this.httpMeth.getListDataCount(); ++r) {
                String methData = (String)this.httpMeth.getCheckBoxDataAt(r);
                this.httpMeth.setCheckBoxSelectionAt(r, methDataList.contains(methData));
            }
            this.urlTree.setEnabled(true);
            ((UIJarPackager.PackagerTreeViewInterface)((Object)this.urlTree)).updateTreeView(w.getUrlPatterns());
        }
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.authMethodCombo.setReadOnly(state);
        this.authMethodSettings.setReadOnly(state);
        this.secConstraintTablePane.setReadOnly(state);
        this.webResCollectionsTable.setReadOnly(state);
        this.urlPatternPanel.setReadOnly(state);
        this.xportGuaranteeCombo.setReadOnly(state);
        this.authConstraintsList.setReadOnly(state);
    }

    private WebResourceCollectionImpl getSelectedWebResCollection() {
        Object sel = this.webResCollectionsTable.getSelectedRowObject();
        return (WebResourceCollectionImpl)sel;
    }

    public void _setHttpMethod() {
        WebResourceCollectionImpl wrc = this.getSelectedWebResCollection();
        if (wrc == null) {
            return;
        }
        for (int r = 0; r < this.httpMeth.getListDataCount(); ++r) {
            String methData = (String)this.httpMeth.getCheckBoxDataAt(r);
            if (this.httpMeth.isCheckBoxSelectedAt(r)) {
                wrc.addHttpMethod(methData);
                continue;
            }
            wrc.removeHttpMethod(methData);
        }
    }

    public void _addWebResCollection() {
        SecurityConstraintImpl sc = this.getSelectedSecurityConstraint();
        if (sc == null) {
            return;
        }
        WebResourceCollectionImpl wrc = new WebResourceCollectionImpl();
        wrc.setDisplayName(DescriptorTools.createUniqueName(WEB_COLLECTION_KEY, sc.getWebResourceCollections()));
        sc.addWebResourceCollection(wrc);
        this.webResCollectionsTable.selectRowWithValueOnUpdate(0, wrc.getDisplayName());
        this.webResCollectionsTable.updateTableData(sc.getWebResourceCollections());
        this.invokeRefresh();
    }

    public void _delWebResCollection() {
        Object[] list = this.webResCollectionsTable.confirmDeleteSelection(null, null);
        if (list != null) {
            SecurityConstraintImpl sc = this.getSelectedSecurityConstraint();
            for (int i = 0; i < list.length; ++i) {
                WebResourceCollectionImpl ref = (WebResourceCollectionImpl)list[i];
                sc.removeWebResourceCollection((WebResourceCollection)ref);
            }
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    public void setWizardContents(Vector contents) {
        this.webWizardContents = contents;
    }

    SecurityConstraintImpl getSelectedSecurityConstraint() {
        SecurityConstraintImpl secConst = null;
        ListSelectionModel lsm = this.secConstraintTablePane.getSelectionModel();
        int minIndex = lsm.getMinSelectionIndex();
        if (minIndex >= 0) {
            secConst = ((SecurityConstraintsTableModel)this.secConstraintTablePane.getModel()).getRow(minIndex);
        }
        return secConst;
    }

    private void showSecurityConstraint(int index) {
        SecurityConstraintImpl secConst = null;
        if (index != -1) {
            secConst = ((SecurityConstraintsTableModel)this.secConstraintTablePane.getModel()).getRow(index);
        }
        this.showSecurityConstraint(secConst);
    }

    private void showSecurityConstraint(SecurityConstraintImpl secConst) {
        if (secConst != null) {
            UserDataConstraintImpl userDataConstraint = (UserDataConstraintImpl)secConst.getUserDataConstraint();
            if (userDataConstraint != null) {
                String type = userDataConstraint.getTransportGuarantee();
                this.xportGuaranteeCombo.setSelectedItem(type);
            } else {
                userDataConstraint = new UserDataConstraintImpl();
                userDataConstraint.setTransportGuarantee("NONE");
                secConst.setUserDataConstraint(userDataConstraint);
                this.xportGuaranteeCombo.setSelectedItem("NONE");
            }
            AuthorizationConstraintImpl aci = (AuthorizationConstraintImpl)secConst.getAuthorizationConstraint();
            DefaultListModel<SecurityRoleDescriptor> dlm = new DefaultListModel<SecurityRoleDescriptor>();
            if (aci != null) {
                Enumeration e = aci.getSecurityRoles();
                while (e.hasMoreElements()) {
                    SecurityRoleDescriptor srd = (SecurityRoleDescriptor)e.nextElement();
                    dlm.addElement(srd);
                }
            }
            this.authConstraintsList.setModel(dlm);
            this.webResCollectionsTable.updateTableData(secConst.getWebResourceCollections());
        } else {
            this.authConstraintsList.setModel(new DefaultListModel());
            this.webResCollectionsTable.clearTableData();
            this.xportGuaranteeCombo.setSelectedItem("NONE");
        }
    }

    public void _editWebResCollection() {
        String name;
        WebResourceCollectionImpl w = this.getSelectedWebResCollection();
        if (w == null) {
            return;
        }
        String string = name = this.descriptor != null ? this.descriptor.getDisplayName() : null;
        if (this.isWizardMode()) {
            this.jarPackager.setSource(this.webWizardContents, name);
        } else {
            this.jarPackager.setSource(this.descriptor);
        }
        this.jarPackager.setDestination(w.getUrlPatterns(), name);
        if (!this.jarPackager.showBrowser()) {
            return;
        }
        w.setUrlPatterns(this.jarPackager.getUrlPatternContents());
        this.invokeRefresh();
    }

    public void _editAuthConst() {
        SecurityConstraintImpl sc = this.getSelectedSecurityConstraint();
        if (sc != null) {
            if (this.rolePickerDialog == null) {
                this.rolePickerDialog = new WebAppRolePicker(this.getMyParentFrame(), this.getOwner());
            }
            this.rolePickerDialog.setSecurityConstraintDescriptors(this.descriptor, sc);
            this.rolePickerDialog.setLocationRelativeTo(this);
            this.rolePickerDialog.show();
            this.invokeRefresh();
        }
    }

    public void _addSecurityConst() {
        SecurityConstraintImpl sc = new SecurityConstraintImpl();
        HashSet s = new HashSet();
        Enumeration e = this.descriptor.getSecurityConstraints();
        while (e.hasMoreElements()) {
            s.add(e.nextElement());
        }
        String n = DescriptorTools.createUniqueName(SECURITY_CONSTRAINT_KEY, s);
        sc.setDisplayName(n);
        this.descriptor.addSecurityConstraint(sc);
        s.add(sc);
        this.secConstraintTablePane.selectRowWithValueOnUpdate(0, n);
        this.secConstraintTablePane.updateTableData(s);
        this.invokeRefresh();
    }

    public void _delSecurityConst() {
        if (this.descriptor == null) {
            return;
        }
        Object[] list = this.secConstraintTablePane.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                SecurityConstraintImpl ref = (SecurityConstraintImpl)list[i];
                this.descriptor.removeSecurityConstraint((SecurityConstraint)ref);
            }
        }
        this.invokeRefresh();
    }

    private void handleTransportGuaranteeSelection(boolean doUpdate) {
        UserDataConstraintImpl userDataConst;
        SecurityConstraintImpl secConst;
        if (doUpdate && (secConst = this.getSelectedSecurityConstraint()) != null && (userDataConst = (UserDataConstraintImpl)secConst.getUserDataConstraint()) != null) {
            String type = (String)this.xportGuaranteeCombo.getSelectedItem();
            userDataConst.setTransportGuarantee(type);
            this.descriptor.changed();
        }
    }

    protected void showAuthMethSettings() {
        Print.dprintln((String)"In WebAppSecurityInspector::showAuthMethSettings()");
        this.authMethodDialog = null;
        if (this.authMethodDialog == null) {
            Window win = this.getMyParentWindow();
            if (win instanceof Dialog) {
                this.authMethodDialog = new AuthMethodSettingsDialog((Dialog)win, (LoginConfigurationImpl)this.descriptor.getLoginConfiguration());
            } else if (win instanceof Frame) {
                this.authMethodDialog = new AuthMethodSettingsDialog((Frame)win, (LoginConfigurationImpl)this.descriptor.getLoginConfiguration());
            } else {
                Print.dprintln((String)"Didn't find a parent window, using 'null'.");
                this.authMethodDialog = new AuthMethodSettingsDialog((Frame)null, (LoginConfigurationImpl)this.descriptor.getLoginConfiguration());
            }
        }
        this.authMethodDialog.setLoginConfiguration();
        this.authMethodDialog.show();
        if (this.authMethodDialog.userSelectedOK()) {
            this.lastLoginConfig = this.authMethodDialog.getLoginConfiguration();
            this.descriptor.setLoginConfiguration(this.lastLoginConfig);
        }
        this.authMethodDialog = null;
    }

    public class WebResourceCollectionsTableModel
    extends InspectorTableModel {
        public WebResourceCollectionsTableModel() {
            super(new String[]{""});
        }

        public Object getObjectValue(Object obj, int col) {
            WebResourceCollectionImpl ref = (WebResourceCollectionImpl)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getDisplayName();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            WebResourceCollectionImpl ref = (WebResourceCollectionImpl)obj;
            switch (col) {
                case 0: {
                    ref.setDisplayName(value.toString());
                }
            }
        }
    }

    private class WebResourceCollectionsTable
    extends InspectorTable {
        public WebResourceCollectionsTable(WebResourceCollectionsTableModel model) {
            super(model);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
        }
    }

    protected class AuthMethodSettingsDialog
    extends UIDialog {
        protected String authLoginMethod;
        protected LoginConfigurationImpl loginConfig;
        protected UITitledBox detailsPanel;
        protected UITitledTextField realmName;
        protected UITitledComboBox loginPage;
        protected UITitledComboBox errorPage;
        private boolean okSelected;

        public AuthMethodSettingsDialog(Frame frame, LoginConfigurationImpl loginConfig) {
            super(frame, true);
            this.authLoginMethod = null;
            this.loginConfig = null;
            this.detailsPanel = null;
            this.realmName = null;
            this.loginPage = null;
            this.errorPage = null;
            this.okSelected = false;
            this.loginConfig = loginConfig;
            this._initLayout();
        }

        public AuthMethodSettingsDialog(Dialog dialog, LoginConfigurationImpl loginConfig) {
            super(dialog, true);
            this.authLoginMethod = null;
            this.loginConfig = null;
            this.detailsPanel = null;
            this.realmName = null;
            this.loginPage = null;
            this.errorPage = null;
            this.okSelected = false;
            this.loginConfig = loginConfig;
            this._initLayout();
        }

        private void _initLayout() {
            this.setTitle(AUTH_METHOD_SETTINGS_TITLE);
            this.setWindowClosingAction(new ActionListener(this){
                private final /* synthetic */ AuthMethodSettingsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent we) {
                    this.this$1.cancelAction();
                }
            });
            UITitledBox contentPane = new UITitledBox(null, false);
            contentPane.setToolTipText(AUTH_METHOD_SETTINGS_TOOLTIP);
            contentPane.getGBConstraints().insets = new Insets(5, 5, 5, 5);
            this.detailsPanel = new UITitledBox(WebAppSecurityInspector.AUTH_SETTINGS_DETAILS(""), true);
            this.detailsPanel.setToolTipText(AUTH_SETTINGS_DETAILS_TOOLTIP);
            contentPane.addWithGBConstraints(this.detailsPanel);
            GridBagConstraints gbc = this.detailsPanel.getGBConstraints();
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 4, 2, 4);
            this.realmName = new UITitledTextField(AUTH_SETTINGS_REALM_NAME, false);
            this.realmName.setToolTipText(AUTH_SETTINGS_REALM_NAME_TOOLTIP);
            this.detailsPanel.addWithGBConstraints(this.realmName);
            Vector contentFiles = WebAppSecurityInspector.this.getArchiveContents();
            Vector<String> contents = new Vector<String>();
            contents.add("");
            Enumeration contentEnum = contentFiles.elements();
            while (contentEnum.hasMoreElements()) {
                String v = contentEnum.nextElement().toString();
                if (v.startsWith("META-INF") || v.startsWith("WEB-INF")) continue;
                contents.add(v.startsWith("/") ? v : "/" + v);
            }
            this.loginPage = new UITitledComboBox(AUTH_SETTINGS_LOGIN_PAGE, false);
            this.loginPage.setToolTipText(AUTH_SETTINGS_LOGIN_PAGE_TOOLTIP);
            this.loginPage.setModel(contents);
            this.loginPage.setEditable(true);
            this.detailsPanel.addWithGBConstraints(this.loginPage);
            this.errorPage = new UITitledComboBox(AUTH_SETTINGS_ERROR_PAGE, false);
            this.errorPage.setToolTipText(AUTH_SETTINGS_ERROR_PAGE_TOOLTIP);
            this.errorPage.setModel(contents);
            this.errorPage.setEditable(true);
            this.detailsPanel.addWithGBConstraints(this.errorPage);
            UIControlButtonBox dialogPane = new UIControlButtonBox(null, false);
            dialogPane.setControlButtonLocation(101);
            dialogPane.setView(contentPane);
            UIButton okPB = UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ AuthMethodSettingsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.okAction();
                }
            });
            dialogPane.addControlButton(okPB);
            UIButton canPB = UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ AuthMethodSettingsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.cancelAction();
                }
            });
            dialogPane.addControlButton(canPB);
            UIHelpButton helpPB = new UIHelpButton(authSettingsHelpSetMapID);
            dialogPane.addControlButton(helpPB);
            this.setContentPane(dialogPane);
            this.setBounds(0, 0, 380, 245);
            this.setLocationRelativeTo(WebAppSecurityInspector.this);
        }

        public void setLoginConfiguration() {
            if (this.loginConfig == null) {
                this.authLoginMethod = AuthMethNONE;
                this._setValue(this.realmName, null);
                this._setValue(this.loginPage, null);
                this._setValue(this.errorPage, null);
            } else {
                this.authLoginMethod = this.loginConfig.getAuthenticationMethod();
                if (this.authLoginMethod.equals(AuthMethFORM)) {
                    this._setValue(this.realmName, this.loginConfig.getRealmName());
                    this._setValue(this.loginPage, this.loginConfig.getFormLoginPage());
                    this._setValue(this.errorPage, this.loginConfig.getFormErrorPage());
                } else if (this.authLoginMethod.equals(AuthMethBASIC) || this.authLoginMethod.equals(AuthMethDIGEST)) {
                    this._setValue(this.realmName, this.loginConfig.getRealmName());
                    this._setValue(this.loginPage, null);
                    this._setValue(this.errorPage, null);
                } else {
                    this._setValue(this.realmName, null);
                    this._setValue(this.loginPage, null);
                    this._setValue(this.errorPage, null);
                }
            }
            this.detailsPanel.setTitle(WebAppSecurityInspector.AUTH_SETTINGS_DETAILS(WebAppSecurityInspector.AuthType2Text(this.authLoginMethod)));
        }

        public LoginConfigurationImpl getLoginConfiguration() {
            if (this.authLoginMethod.equals(AuthMethNONE)) {
                return null;
            }
            LoginConfigurationImpl loginConfig = new LoginConfigurationImpl();
            loginConfig.setAuthenticationMethod(this.authLoginMethod);
            if (this.realmName.isEnabled()) {
                loginConfig.setRealmName(this.realmName.getText());
            }
            if (this.loginPage.isEnabled()) {
                String loginUrl = this.loginPage.getText();
                if (!loginUrl.equals("") && !loginUrl.startsWith("/")) {
                    loginUrl = "/" + loginUrl;
                }
                loginConfig.setFormLoginPage(loginUrl);
            }
            if (this.errorPage.isEnabled()) {
                String errorUrl = this.errorPage.getText();
                if (!errorUrl.equals("") && !errorUrl.startsWith("/")) {
                    errorUrl = "/" + errorUrl;
                }
                loginConfig.setFormErrorPage(errorUrl);
            }
            return loginConfig;
        }

        protected void _setValue(UITitledBox t, String v) {
            t.setEnabled(v != null);
            this.setItemVisible(t, v);
            t.setText(v);
        }

        protected void setItemVisible(UITitledBox t, String v) {
            t.setVisible(true);
        }

        public void okAction() {
            this.okSelected = true;
            this.hide();
        }

        public void cancelAction() {
            this.okSelected = false;
            this.hide();
        }

        public boolean userSelectedOK() {
            return this.okSelected;
        }
    }

    private class SecurityConstraintsTableModel
    extends InspectorTableModel {
        public SecurityConstraintsTableModel() {
            super(new String[]{""});
            this.setDataOrdering(1);
        }

        public SecurityConstraintImpl getRow(int index) {
            return (SecurityConstraintImpl)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            SecurityConstraintImpl ref = (SecurityConstraintImpl)obj;
            return ref.getDisplayName();
        }

        public void setObjectValue(Object obj, int col, Object value) {
            SecurityConstraintImpl ref = (SecurityConstraintImpl)obj;
            ref.setDisplayName((String)value);
        }
    }

    class SecurityConstraintsTable
    extends InspectorTable {
        public SecurityConstraintsTable(SecurityConstraintsTableModel model) {
            super(model);
            this.setSelectionMode(0);
        }
    }

    private class SecurityListCellRenderer
    extends DefaultListCellRenderer {
        private SecurityListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
            } else {
                this.setText(value == null ? "" : ((SecurityRoleDescriptor)value).getDisplayName());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return this;
        }
    }
}

