/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.war;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.ErrorPageDescriptorImpl;
import com.sun.enterprise.deployment.JspConfigDescriptor;
import com.sun.enterprise.deployment.TagLibConfigurationDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.ErrorPageDescriptor;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;

public class WebAppFileRefsInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebAppFileRefsInspector.class);
    private static final String CBOX_NAME = localStrings.getLocalString("ui.webappfilerefinspector.cbox_name", "ComboBox");
    private static final String CBOX_DESC = localStrings.getLocalString("ui.webappfilerefinspector.cbox_desc", "This is a ComboBox for the web application inspector window");
    private static final String WELCOME_TOOLTIP = localStrings.getLocalString("ui.webappfilerefsinspector.welcome.tooltip", "Table of Welcome Files");
    private static final String WELCOME_TITLE = localStrings.getLocalString("ui.webappfilerefsinspector.welcome.title", "Welcome Files");
    private static String _WELCOME_OK_TO_DELETE = null;
    private static String _WELCOME_DELETE_FILE = null;
    private static String _WELCOME_PLEASE_SELECT = null;
    private static final String JSPTAG_TOOLTIP = localStrings.getLocalString("ui.webappfilerefsinspector.jsptag.tooltip", "Table of JSP Tag Libraries");
    private static final String JSPTAG_TITLE = localStrings.getLocalString("ui.webappfilerefsinspector.jsptag.title", "JSP Tag Libraries");
    private static final String JSPTAG_URI = localStrings.getLocalString("at.webappfilerefsinspector.jsptag.uri", "URI");
    private static final String JSPTAG_LOCATION = localStrings.getLocalString("at.webappfilerefsinspector.jsptag.location", "Location");
    private static String _JSPTAG_OK_TO_DELETE = null;
    private static String _JSPTAG_DELETE_TAG = null;
    private static final String ERRORMAP_TOOLTIP = localStrings.getLocalString("ui.webappfilerefsinspector.errormap.tooltip", "Table of context parameters");
    private static final String ERRORMAP_TITLE = localStrings.getLocalString("ui.webappfilerefsinspector.errormap.title", "Error Mapping");
    private static final String ERRORMAP_EXCEPTION = localStrings.getLocalString("ui.webappfilerefsinspector.errormap.exception", "Error/Exception");
    private static final String ERRORMAP_RESOURCE = localStrings.getLocalString("ui.webappfilerefsinspector.errormap.resource", "Resource to be Called");
    private static String _ERRORMAP_OK_TO_DELETE = null;
    private static String _ERRORMAP_DELETE_MAP = null;
    private static String _ERRORMAP_PLEASE_SELECT = null;
    private static final String MISSING_URI = localStrings.getLocalString("at.webappfilerefsinspector.missing_uri", "All JSP Tag Libraries must specify a URI");
    private static final String MISSING_LOCATION = localStrings.getLocalString("at.webappfilerefsinspector.missing_location", "All JSP Tag Libraries must specify a Location");
    private static final String MISSING_EXCEPTION = localStrings.getLocalString("at.webappfilerefsinspector.missing_exception", "All Error Mapping must specify an Error/Exception");
    private static final String MISSING_RESOURCE = localStrings.getLocalString("at.webappfilerefsinspector.missing_resource", "All Error Mapping must specify a Resource");
    private static final String TABNAME = localStrings.getLocalString("ui.webappfilerefsinspector.tabname", "File Refs");
    private static final char mnemonic_Add = localStrings.getLocalString("ui.webappfilerefinspector.file_add_but_mnemonic", "A").charAt(0);
    private static final char mnemonic_Delete = localStrings.getLocalString("ui.webappfilerefinspector.file_del_but_mnemonic", "D").charAt(0);
    private static final char mnemonic_AddTag = localStrings.getLocalString("ui.webappfilerefinspector.tag_add_but_mnemonic", "T").charAt(0);
    private static final char mnemonic_DeleteTag = localStrings.getLocalString("ui.webappfilerefinspector.tag_del_but_mnemonic", "G").charAt(0);
    private static final char mnemonic_AddError = localStrings.getLocalString("ui.webappfilerefinspector.map_add_but_mnemonic", "E").charAt(0);
    private static final char mnemonic_DeleteError = localStrings.getLocalString("ui.webappfilerefinspector.map_del_but_mnemonic", "R").charAt(0);
    private static String wizardHelpID = "FileRef";
    private static String deployHelpID = "FileRef";
    private WebBundleDescriptor descriptor = null;
    private UITitledTable pnlWelcomeFiles = null;
    private WelcomeTable welcomeTable = null;
    private Vector welcomeContents = new Vector();
    private UITitledTable pnlJSPTagLibs = null;
    private JSPTagLibTable jspTagLibTable = null;
    private UITitledTable pnlErrorMapping = null;
    private ErrorMappingTable errorMappingTable = null;
    private Vector errorContents = new Vector();

    private static final String WELCOME_OK_TO_DELETE() {
        return _WELCOME_OK_TO_DELETE != null ? _WELCOME_OK_TO_DELETE : (_WELCOME_OK_TO_DELETE = localStrings.getLocalString("ui.webappfilerefsinspector.welcome.ok_to_delete", "Are you sure you want to delete the selected welcome file?"));
    }

    private static final String WELCOME_DELETE_FILE() {
        return _WELCOME_DELETE_FILE != null ? _WELCOME_DELETE_FILE : (_WELCOME_DELETE_FILE = localStrings.getLocalString("ui.webappfilerefsinspector.welcome.delete_file", "Delete welcome file"));
    }

    private static String WELCOME_PLEASE_SELECT() {
        return _WELCOME_PLEASE_SELECT != null ? _WELCOME_PLEASE_SELECT : (_WELCOME_PLEASE_SELECT = localStrings.getLocalString("ui.webappfilerefsinspector.welcome.please_select", "You must first select a welcome file from the list"));
    }

    private static final String JSPTAG_OK_TO_DELETE() {
        return _JSPTAG_OK_TO_DELETE != null ? _JSPTAG_OK_TO_DELETE : (_JSPTAG_OK_TO_DELETE = localStrings.getLocalString("ui.webappfilerefsinspector.jsptag.ok_to_delete", "Are you sure you want to delete the selected JSP Tag Library?"));
    }

    private static final String JSPTAG_DELETE_TAG() {
        return _JSPTAG_DELETE_TAG != null ? _JSPTAG_DELETE_TAG : (_JSPTAG_DELETE_TAG = localStrings.getLocalString("ui.webappfilerefsinspector.jsptag.delete_tag", "Delete JSP Tag Library"));
    }

    private static final String ERRORMAP_OK_TO_DELETE() {
        return _ERRORMAP_OK_TO_DELETE != null ? _ERRORMAP_OK_TO_DELETE : (_ERRORMAP_OK_TO_DELETE = localStrings.getLocalString("ui.webappfilerefsinspector.errormap.ok_to_delete", "Are you sure you want to delete the selected error mapping?"));
    }

    private static final String ERRORMAP_DELETE_MAP() {
        return _ERRORMAP_DELETE_MAP != null ? _ERRORMAP_DELETE_MAP : (_ERRORMAP_DELETE_MAP = localStrings.getLocalString("ui.webappfilerefsinspector.errormap.delete_map", "Delete error mapping"));
    }

    private static String ERRORMAP_PLEASE_SELECT() {
        return _ERRORMAP_PLEASE_SELECT != null ? _ERRORMAP_PLEASE_SELECT : (_ERRORMAP_PLEASE_SELECT = localStrings.getLocalString("ui.webappfilerefsinspector.errormap.please_select", "You must first select an error mapping from the list"));
    }

    public static InspectorPane newInspectorPane(String mode) {
        return new WebAppFileRefsInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : null;
            this.welcomeTable.clearTableData();
            this.errorMappingTable.clearTableData();
            this.jspTagLibTable.clearTableData();
        }
    }

    protected JspConfigDescriptor getJspConfigDescriptor() {
        if (this.descriptor != null) {
            JspConfigDescriptor jspConfig = this.descriptor.getJspConfigDescriptor();
            if (jspConfig == null) {
                jspConfig = new JspConfigDescriptor();
                this.descriptor.setJspConfigDescriptor(jspConfig);
            }
            return jspConfig;
        }
        return null;
    }

    private WebAppFileRefsInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        this.pnlWelcomeFiles = new UITitledTable(WELCOME_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.pnlWelcomeFiles, c);
        this.welcomeTable = new WelcomeTable(new WelcomeTableModel());
        this.pnlWelcomeFiles.setTableView(this.welcomeTable);
        UIButton btnAddWelcomeFile = UIButton.createAddButton(localStrings.getLocalString("ui.webappfilerefinspector.file_add_but", "Add File"), mnemonic_Add, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebAppFileRefsInspector.this.addWelcomeFileAction();
            }
        }, false);
        this.pnlWelcomeFiles.addControlButton(btnAddWelcomeFile);
        UIButton btnDeleteWelcomeFile = UIButton.createDeleteButton(localStrings.getLocalString("ui.webappfilerefinspector.file_del_but", "Delete File"), mnemonic_Delete, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebAppFileRefsInspector.this.deleteWelcomeFileAction();
            }
        }, true);
        this.pnlWelcomeFiles.addSelectionEnabledButton(btnDeleteWelcomeFile);
        this.pnlJSPTagLibs = new UITitledTable(JSPTAG_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.pnlJSPTagLibs, c);
        this.jspTagLibTable = new JSPTagLibTable(new JSPTagLibTableModel());
        this.pnlJSPTagLibs.setTableView(this.jspTagLibTable);
        UIButton btnAddJSPTagLib = UIButton.createAddButton(localStrings.getLocalString("ui.webappfilerefinspector.tag_add_but", "Add Tag Library"), mnemonic_AddTag, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebAppFileRefsInspector.this.addJSPTagLibAction();
            }
        }, false);
        this.pnlJSPTagLibs.addControlButton(btnAddJSPTagLib);
        UIButton btnDeleteJSPTagLib = UIButton.createDeleteButton(localStrings.getLocalString("ui.webappfilerefinspector.tag_del_but", "Delete Tag Library"), mnemonic_DeleteTag, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebAppFileRefsInspector.this.deleteJSPTagLibAction();
            }
        }, true);
        this.pnlJSPTagLibs.addSelectionEnabledButton(btnDeleteJSPTagLib);
        this.pnlErrorMapping = new UITitledTable(ERRORMAP_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.pnlErrorMapping, c);
        this.errorMappingTable = new ErrorMappingTable(new ErrorMappingTableModel());
        this.pnlErrorMapping.setTableView(this.errorMappingTable);
        UIButton btnAddErrorMapping = UIButton.createAddButton(localStrings.getLocalString("ui.webappfilerefinspector.map_add_but", "Add Error"), mnemonic_AddError, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebAppFileRefsInspector.this.addErrorMappingAction();
            }
        }, false);
        this.pnlErrorMapping.addControlButton(btnAddErrorMapping);
        UIButton btnDeleteErrorMapping = UIButton.createDeleteButton(localStrings.getLocalString("ui.webappfilerefinspector.map_del_but", "Delete Error"), mnemonic_DeleteError, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebAppFileRefsInspector.this.deleteErrorMappingAction();
            }
        }, true);
        this.pnlErrorMapping.addSelectionEnabledButton(btnDeleteErrorMapping);
    }

    public void refresh() {
        Vector wf = this.welcomeTable.wrapData(this.descriptor.getWelcomeFiles());
        this.welcomeTable.updateTableData(wf);
        this.welcomeTable.resetEditors(this.getWelcomeFileList());
        this.jspTagLibTable.updateTableData(this.getJspConfigDescriptor().getTagLibs());
        this.errorMappingTable.updateTableData(this.descriptor.getErrorPageDescriptors());
        this.errorMappingTable.resetEditors(this.getErrorFileList());
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.pnlWelcomeFiles.setReadOnly(state);
        this.pnlJSPTagLibs.setReadOnly(state);
        this.pnlErrorMapping.setReadOnly(state);
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.jspTagLibTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_URI);
            }
            return false;
        }
        if (this.jspTagLibTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_LOCATION);
            }
            return false;
        }
        if (this.errorMappingTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_EXCEPTION);
            }
            return false;
        }
        if (this.errorMappingTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_RESOURCE);
            }
            return false;
        }
        if (this.errorMappingTable.getRowWithValue(1, "/") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_RESOURCE);
            }
            return false;
        }
        return true;
    }

    public void setWelcomeFileContents(List contents) {
        this.welcomeContents = new Vector();
        if (contents != null) {
            Iterator iterator = contents.iterator();
            while (iterator.hasNext()) {
                String item = iterator.next().toString();
                String _item = item.toLowerCase();
                if (_item.startsWith("web-inf") || _item.endsWith("/") || _item.endsWith(".class") || _item.endsWith(".jar")) continue;
                this.welcomeContents.addElement(item);
            }
        }
    }

    private Vector getWelcomeFileList() {
        if (this.isDeploymentMode()) {
            this.welcomeContents = null;
            List entries = ModuleArchive.getModuleArchive((Descriptor)this.descriptor).getEntryNames();
            this.setWelcomeFileContents(entries);
        }
        if (this.welcomeContents == null) {
            this.welcomeContents = new Vector();
        }
        return this.welcomeContents;
    }

    public void setErrorFileContents(List contents) {
        this.errorContents = new Vector();
        if (contents != null) {
            Iterator iterator = contents.iterator();
            while (iterator.hasNext()) {
                String item = iterator.next().toString();
                String _item = item.toLowerCase();
                if (_item.startsWith("web-inf") || _item.endsWith("/") || _item.endsWith(".class") || _item.endsWith(".jar")) continue;
                this.errorContents.addElement("/" + item);
            }
        }
    }

    private Vector getErrorFileList() {
        if (this.isDeploymentMode()) {
            this.errorContents = null;
            List entries = ModuleArchive.getModuleArchive((Descriptor)this.descriptor).getEntryNames();
            this.setErrorFileContents(entries);
        }
        if (this.errorContents == null) {
            this.errorContents = new Vector();
        }
        return this.errorContents;
    }

    private void addWelcomeFileAction() {
        String blankRef = null;
        if (this.welcomeTable.getRowWithValue(0, "") != null) {
            blankRef = "";
        } else if (this.welcomeTable.getRowWithValue(0, "/") != null) {
            blankRef = "/";
        } else {
            blankRef = "";
            this.descriptor.addWelcomeFile(blankRef);
        }
        this.welcomeTable.selectRowWithValueOnUpdate(0, blankRef);
        this.invokeRefresh();
    }

    private void deleteWelcomeFileAction() {
        Object[] list = this.welcomeTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                String ref = list[i].toString();
                this.descriptor.removeWelcomeFile(ref);
            }
            this.invokeRefresh();
        }
    }

    private void addJSPTagLibAction() {
        if (this.jspTagLibTable.getRowWithValue(0, "") == null) {
            this.getJspConfigDescriptor().addTagLib(new TagLibConfigurationDescriptor("", ""));
        }
        this.jspTagLibTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteJSPTagLibAction() {
        Object[] list = this.jspTagLibTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                TagLibConfigurationDescriptor ref = (TagLibConfigurationDescriptor)list[i];
                this.getJspConfigDescriptor().removeTagLib(ref);
            }
            this.invokeRefresh();
        }
    }

    private void addErrorMappingAction() {
        if (this.errorMappingTable.getRowWithValue(0, "") == null) {
            this.descriptor.addErrorPageDescriptor(new ErrorPageDescriptorImpl("", ""));
        }
        this.errorMappingTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteErrorMappingAction() {
        Object[] list = this.errorMappingTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                ErrorPageDescriptorImpl ref = (ErrorPageDescriptorImpl)list[i];
                this.descriptor.removeErrorPageDescriptor((ErrorPageDescriptor)ref);
            }
            this.invokeRefresh();
        }
    }

    public class ErrorMappingTableModel
    extends InspectorTableModel {
        public ErrorMappingTableModel() {
            super(new String[]{ERRORMAP_EXCEPTION, ERRORMAP_RESOURCE});
        }

        public Object getObjectValue(Object obj, int col) {
            ErrorPageDescriptorImpl ref = (ErrorPageDescriptorImpl)obj;
            if (ref == null) {
                return null;
            }
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getErrorSignifierAsString();
                    if (!value.equals("0")) break;
                    value = "";
                    break;
                }
                case 1: {
                    value = ref.getLocation();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            ErrorPageDescriptorImpl ref = (ErrorPageDescriptorImpl)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    ref.setErrorSignifierAsString(value.toString());
                    break;
                }
                case 1: {
                    ref.setLocation(value.toString());
                }
            }
            WebAppFileRefsInspector.this.descriptor.changed();
        }
    }

    private class ErrorMappingTable
    extends InspectorTable {
        DefaultCellEditor files;

        public ErrorMappingTable(ErrorMappingTableModel model) {
            super(model);
            this.files = null;
            this.setToolTipText(ERRORMAP_TOOLTIP);
            this.setSelectionMode(0);
        }

        public void resetEditors(Vector evl) {
            JComboBox cb = new JComboBox(evl);
            cb.getAccessibleContext().setAccessibleName(CBOX_NAME);
            cb.getAccessibleContext().setAccessibleDescription(CBOX_DESC);
            cb.setEditable(true);
            this.files = new DefaultCellEditor(cb);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 1: {
                    rtn = this.files;
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }

    public class JSPTagLibTableModel
    extends InspectorTableModel {
        public JSPTagLibTableModel() {
            super(new String[]{JSPTAG_URI, JSPTAG_LOCATION});
        }

        public Object getObjectValue(Object obj, int col) {
            TagLibConfigurationDescriptor ref = (TagLibConfigurationDescriptor)obj;
            if (ref == null) {
                return null;
            }
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getTagLibURI();
                    break;
                }
                case 1: {
                    value = ref.getTagLibLocation();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            TagLibConfigurationDescriptor ref = (TagLibConfigurationDescriptor)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    ref.setTagLibURI(value.toString());
                    break;
                }
                case 1: {
                    ref.setTagLibLocation(value.toString());
                }
            }
            WebAppFileRefsInspector.this.descriptor.changed();
        }
    }

    private class JSPTagLibTable
    extends InspectorTable {
        public JSPTagLibTable(JSPTagLibTableModel model) {
            super(model);
            this.setToolTipText(JSPTAG_TOOLTIP);
            this.setSelectionMode(0);
        }
    }

    public class WelcomeTableModel
    extends InspectorTableModel {
        public WelcomeTableModel() {
            super(new String[]{""});
        }

        public Object getObjectValue(Object obj, int col) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.toString();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
            switch (col) {
                case 0: {
                    String oldValue = ref.toString();
                    String newValue = value.toString();
                    if (oldValue.equals(newValue)) break;
                    WebAppFileRefsInspector.this.descriptor.removeWelcomeFile(oldValue);
                    ref.setObject(newValue);
                    WebAppFileRefsInspector.this.descriptor.addWelcomeFile(newValue);
                    break;
                }
            }
        }
    }

    private class WelcomeTable
    extends InspectorTable {
        DefaultCellEditor welcomeFiles;

        public WelcomeTable(WelcomeTableModel model) {
            super(model);
            this.welcomeFiles = null;
            this.setToolTipText(WELCOME_TOOLTIP);
            this.setSelectionMode(0);
        }

        public void resetEditors(Vector evl) {
            JComboBox cb = new JComboBox(evl);
            cb.getAccessibleContext().setAccessibleName(CBOX_NAME);
            cb.getAccessibleContext().setAccessibleDescription(CBOX_DESC);
            cb.setEditable(true);
            this.welcomeFiles = new DefaultCellEditor(cb);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 0: {
                    rtn = this.welcomeFiles;
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }
}

