/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class UITitledPasswordField
extends UITitledTextField {
    public UITitledPasswordField(String title, boolean showBorder, int fieldLen) {
        super(title, showBorder, fieldLen);
    }

    public UITitledPasswordField(String title, boolean showBorder) {
        this(title, showBorder, 0);
    }

    public UITitledPasswordField(String title) {
        this(title, false, 0);
    }

    public JPasswordField getPasswordField() {
        return (JPasswordField)super.getTextField();
    }

    public void setPassword(char[] passwd) {
        this.setPassword(new String(passwd));
    }

    public void setPassword(String passwd) {
        super.setText(passwd);
    }

    public void setText(String passwd) {
        this.setPassword(passwd);
    }

    public String getPassword() {
        return new String(((JPasswordField)this.getTextField()).getPassword());
    }

    public String getText() {
        return this.getPassword();
    }

    protected JTextField createPrivateTextField() {
        return new PrivatePasswordField();
    }

    protected class PrivatePasswordField
    extends JPasswordField {
        private Color savedBackground = Color.white;

        public PrivatePasswordField() {
            this._init();
        }

        private void _init() {
            this.savedBackground = this.getBackground();
            this.setDisabledTextColor(UITitledBox.DisabledTextColor);
            if (UITitledBox.DefaultTextBorder != null) {
                this.setBorder(UITitledBox.DefaultTextBorder);
            }
            Insets textMargin = this.getMargin();
            if (textMargin.left < 3) {
                textMargin.left = 3;
                this.setMargin(textMargin);
            }
        }

        public void setEnabled(boolean state) {
            super.setEnabled(state);
            this.setBackground(state ? this.savedBackground : UITitledBox.DisabledBackgroundColor);
        }
    }
}

