/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UIBrowser;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class UITitledHTMLText
extends UITitledBox
implements HyperlinkListener {
    protected static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UITitledHTMLText.class);
    private final String SCROLL_NAME = localStrings.getLocalString("ui.uititledhtmltext.scroll_name", "Scroll Panel");
    private final String SCROLL_DESC = localStrings.getLocalString("ui.uititledhtmltext.scroll_desc", "This is a scroll pane");
    public static final String HEAD = "<HEAD>";
    public static final String HTML = "<HTML>";
    public static final String BODY = "<BODY>";
    public static final String BOLD = "<B>";
    public static final String ITALIC = "<I>";
    public static final String UNDERLINE = "<U>";
    public static final String FONT_ = "<FONT";
    public static final String STYLE = "<STYLE TYPE='text/css'>";
    public static final String HEADER_1 = "<H1>";
    public static final String HEADER_2 = "<H2>";
    public static final String HEADER_3 = "<H3>";
    public static final String HEADER_4 = "<H4>";
    private static final String AMP = "&amp;";
    private static final String LT = "&lt;";
    private static final String GT = "&gt;";
    private static final String SPACE = "&nbsp;";
    private static final String NEWLN = "<BR>\n";
    private static boolean didInitStyleSheet = false;
    private boolean isScrollable = false;
    private JEditorPane editorPane = null;
    private JScrollPane scrollPane = null;
    private URL currentHyperLink = null;
    private String styleRules = null;
    private String[] wrapTags = null;

    public UITitledHTMLText(String title, boolean showBorder, boolean makeScrollable) {
        super(title, showBorder);
        this.setReadOnly(true);
        this.isScrollable = makeScrollable;
        this.editorPane = new PrivateEditorPane();
        if (!didInitStyleSheet) {
            didInitStyleSheet = true;
            HTMLEditorKit ek = (HTMLEditorKit)this.editorPane.getEditorKit();
            StyleSheet ss = ek.getStyleSheet();
            ss.addRule("body { font-size: 12pt; font-family: SansSerif }");
            ss.addRule("a { color:blue; text-decoration: underline }");
        }
        if (this.isScrollable) {
            this.scrollPane = new PrivateScrollPane(this.editorPane);
            this.scrollPane.setVerticalScrollBarPolicy(20);
            this.scrollPane.setHorizontalScrollBarPolicy(30);
            this.add((Component)this.scrollPane, this.getGBConstraints());
        } else {
            this.add((Component)this.editorPane, this.getGBConstraints());
        }
        this.setLabelComponent(this.editorPane);
        this.editorPane.addHyperlinkListener(this);
    }

    public UITitledHTMLText(String title, boolean showBorder) {
        this(title, showBorder, false);
    }

    public UITitledHTMLText(String title) {
        this(title, false);
    }

    public JEditorPane getEditorPane() {
        return this.editorPane;
    }

    public void setBackground(Color bgColor) {
        JEditorPane ep = this.getEditorPane();
        if (ep != null) {
            ep.setBackground(bgColor);
        } else {
            super.setBackground(bgColor);
        }
    }

    public Color getBackground() {
        JEditorPane ep = this.getEditorPane();
        return ep != null ? ep.getBackground() : super.getBackground();
    }

    public void setForeground(Color bgColor) {
        JEditorPane ep = this.getEditorPane();
        if (ep != null) {
            ep.setForeground(bgColor);
        } else {
            super.setForeground(bgColor);
        }
    }

    public Color getForeground() {
        JEditorPane ep = this.getEditorPane();
        return ep != null ? ep.getForeground() : super.getForeground();
    }

    public void setVerticalScrollBarPolicy(int policy) {
        if (this.scrollPane != null) {
            this.scrollPane.setVerticalScrollBarPolicy(policy);
        }
    }

    public void setHorizontalScrollBarPolicy(int policy) {
        if (this.scrollPane != null) {
            this.scrollPane.setHorizontalScrollBarPolicy(policy);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent he) {
        if (he.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
            String urlStr;
            this.currentHyperLink = he.getURL();
            if (this.currentHyperLink != null && (urlStr = this.currentHyperLink.toString()).startsWith("http://")) {
                UIBrowser.viewURL(urlStr);
            }
        }
    }

    public URL getCurrentHyperLink() {
        return this.currentHyperLink;
    }

    public void setStyleRules(String rules) {
        this.styleRules = UITitledHTMLText.STYLE(rules);
    }

    public void setStyleRules(String[] rules) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < rules.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(rules[i]);
        }
        this.setStyleRules(sb.toString());
    }

    public void setWrapTags(String[] wrapTags) {
        this.wrapTags = wrapTags;
    }

    public void setText(String text, String[] wrapTags) {
        String html = text != null && wrapTags != null ? UITitledHTMLText.wrapText(text, wrapTags) : text;
        this.setText(html);
    }

    public void setText(String html, boolean wrap) {
        String h;
        String string = h = html != null ? html.trim() : "";
        if (wrap && !h.substring(0, HTML.length()).equalsIgnoreCase(HTML)) {
            if (this.wrapTags != null) {
                h = UITitledHTMLText.wrapText(h, this.wrapTags);
            }
            if (!h.substring(0, BODY.length()).equalsIgnoreCase(BODY)) {
                h = UITitledHTMLText.wrapText(h, new String[]{BODY});
            }
            if (this.styleRules != null) {
                h = UITitledHTMLText.wrapText(this.styleRules, new String[]{HEAD}) + h;
            }
            h = UITitledHTMLText.wrapText(h, new String[]{HTML});
        }
        this.setText(h);
    }

    public void setText(String html) {
        this.getEditorPane().setText(html != null ? html : "");
        this.getEditorPane().setCaretPosition(0);
    }

    public String getText() {
        return this.getEditorPane().getText();
    }

    public void setEditable(boolean state) {
        if (state) {
            Print.dprintStackTrace((String)"Cannot set editable");
        }
    }

    public String toString() {
        return this.getEditorPane().toString();
    }

    public String getSelectedText() {
        return this.getEditorPane().getSelectedText();
    }

    public void setSelectedRange(int p1, int p2) {
        if (p1 < 0) {
            this.clearSelectedText();
            return;
        }
        if (p1 == 0 && p2 < 0) {
            this.getEditorPane().selectAll();
            return;
        }
        try {
            this.getEditorPane().setCaretPosition(p1);
            this.getEditorPane().moveCaretPosition(p2);
            this.getEditorPane().getCaret().setVisible(true);
            this.getEditorPane().getCaret().setSelectionVisible(true);
        }
        catch (Throwable t) {
            Print.dprintStackTrace((String)"'select' Error", (Throwable)t);
        }
    }

    public void clearSelectedText() {
        int sel = this.getSelectionStart();
        this.setSelectedRange(sel, sel);
    }

    public int getSelectionStart() {
        return this.getEditorPane().getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.getEditorPane().getSelectionEnd();
    }

    public static String convertToHTML(char c) {
        if (c == '&') {
            return AMP;
        }
        if (c == '<') {
            return LT;
        }
        if (c == '>') {
            return GT;
        }
        if (c == ' ') {
            return SPACE;
        }
        if (c == '\n') {
            return NEWLN;
        }
        return String.valueOf(c);
    }

    public static String convertToHTML(String text) {
        StringBuffer htmlText = new StringBuffer();
        char[] ch = text.toCharArray();
        int lastCh = 0;
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] == ' ' && lastCh != 32) {
                htmlText.append(' ');
            } else {
                htmlText.append(UITitledHTMLText.convertToHTML(ch[i]));
            }
            lastCh = ch[i];
        }
        return htmlText.toString();
    }

    public static String colorValue(Color c) {
        return "#" + Integer.toHexString(c.getRGB() & 0xFFFFFF | 0x1000000).substring(1).toUpperCase();
    }

    public static String startTag(String tag) {
        return tag.startsWith("<") ? tag : "<" + tag + ">";
    }

    public static String endTag(String tag) {
        int p1 = tag.startsWith("<") ? 1 : 0;
        int p2 = tag.indexOf(" ");
        if (p2 < p1) {
            p2 = tag.indexOf(">");
        }
        String endTag = p2 > p1 ? tag.substring(p1, p2) : tag.substring(p1);
        return "</" + endTag + ">";
    }

    public static String wrapText(String text, String[] tags) {
        StringBuffer html = new StringBuffer(text);
        for (int i = tags.length - 1; i >= 0; --i) {
            if (tags[i] == null) continue;
            UITitledHTMLText._wrapTextBuffer(html, tags[i].trim());
        }
        return html.toString();
    }

    private static StringBuffer _wrapTextBuffer(StringBuffer html, String tag) {
        return tag != null && !tag.equals("") ? html.insert(0, UITitledHTMLText.startTag(tag)).append(UITitledHTMLText.endTag(tag)) : html;
    }

    public static String FONT(int size) {
        return UITitledHTMLText.FONT(null, size, null);
    }

    public static String FONT(Color color) {
        return UITitledHTMLText.FONT(null, 0, color);
    }

    public static String FONT(int size, Color color) {
        return UITitledHTMLText.FONT(null, 0, color);
    }

    public static String FONT(String face, int size, Color color) {
        StringBuffer font = new StringBuffer(FONT_);
        if (face != null) {
            font.append(" face=").append("'").append(face).append("'");
        }
        if (size != 0) {
            font.append(" size=");
            if (size > 0) {
                font.append("+");
            }
            font.append(size);
        }
        if (color != null) {
            font.append(" color=").append(UITitledHTMLText.colorValue(color));
        }
        font.append(">");
        return font.toString();
    }

    public static String STYLE(String rule) {
        StringBuffer style = new StringBuffer(STYLE);
        style.append("<!-- ").append(rule).append(" -->");
        style.append(UITitledHTMLText.endTag(STYLE));
        return style.toString();
    }

    protected class PrivateViewport
    extends JViewport {
        public PrivateViewport() {
            this.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.uititledhtmltext.view_port_name", "View Port"));
            this.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.uititledhtmltext.view_port_desc", "This is the view area of the window"));
        }

        public void setView(Component v) {
            super.setView(v);
        }

        public void scrollRectToVisible(Rectangle r) {
            super.scrollRectToVisible(r);
        }
    }

    protected class PrivateScrollPane
    extends JScrollPane {
        public PrivateScrollPane(Component view) {
            super(view);
            this.getAccessibleContext().setAccessibleName(UITitledHTMLText.this.SCROLL_NAME);
            this.getAccessibleContext().setAccessibleDescription(UITitledHTMLText.this.SCROLL_DESC);
        }

        protected JViewport createViewport() {
            return new PrivateViewport();
        }
    }

    protected class PrivateEditorPane
    extends JEditorPane {
        public PrivateEditorPane() {
            super("text/html", "");
            this.setEditable(false);
            if (UITitledHTMLText.this.isScrollable) {
                Insets textMargin;
                this.setBackground(UITitledBox.DisabledBackgroundColor);
                this.setForeground(UITitledBox.DisabledTextColor);
                if (UITitledBox.DefaultTextBorder != null) {
                    super.setBorder(UITitledBox.DefaultTextBorder);
                }
                if ((textMargin = this.getMargin()) != null && textMargin.left < 5) {
                    textMargin.left = 5;
                    super.setMargin(textMargin);
                }
                this.setAutoscrolls(true);
            } else {
                Insets textMargin = this.getMargin();
                if (textMargin != null && textMargin.left > 0) {
                    textMargin.left = 0;
                    super.setMargin(textMargin);
                }
                this.setBackground(UIManager.getColor("Panel.background"));
                this.setForeground(Color.black);
            }
        }

        public boolean getScrollableTracksViewportHeight() {
            return UITitledHTMLText.this.isScrollable ? super.getScrollableTracksViewportHeight() : true;
        }

        public boolean getScrollableTracksViewportWidth() {
            return UITitledHTMLText.this.isScrollable ? super.getScrollableTracksViewportWidth() : true;
        }
    }
}

