/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.utils.StringTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.text.JTextComponent;

public class UITitledComboBox
extends UITitledBox {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UITitledComboBox.class);
    private static String BROWSE = localStrings.getLocalString("ui.uititledcombobox.browserbutton", "Browse...");
    private static String BROWSE_SELECT = localStrings.getLocalString("ui.uititledtextfield.browser_button.select", "Select");
    private static final String CBOX_NAME = localStrings.getLocalString("ui.uititledcombobox.cbox_name", "ComboBox");
    private static final String CBOX_DESC = localStrings.getLocalString("ui.uititledcombobox.cbox_desc", "This is a ComboBox");
    private static final String SEPARATOR_NAME = localStrings.getLocalString("ui.uititledcombobox.separator_name", "Separator");
    private static final String SEPARATOR_DESC = localStrings.getLocalString("ui.uititledcombobox.separator_desc", "This is a Separator");
    private static char BROWSE_MNEMONIC = localStrings.getLocalString("ui.uititledcombobox.browserbutton_mnemonic", "w").charAt(0);
    public static final String LAST_ADDED_ITEM = "*LastAddedItem*";
    private static final boolean SHOW_WIDE_POPUPS = true;
    private static final String NULL_VALUE = "";
    protected Object lastEnabledSelection = null;
    private JComboBox comboBox = null;
    private ComboBoxModel comboModel = null;
    private Color comboBoxBackground = null;
    protected boolean usingComboBox = false;
    protected Object lastAddedItem = null;
    private JButton browserButton = null;
    private String browserFilterKey = null;
    protected Hashtable selectionEnabler = null;
    protected boolean showSelectionAsToolTip = false;
    protected boolean reverseOrdering = false;
    protected int maxItems = -1;
    protected FocusListener focusListener = null;
    protected ActionListener actionListener = null;
    protected boolean ignoreFocusLostEvents = false;
    protected Vector actionItems = null;
    private static boolean didResetComboBoxColors = false;

    public UITitledComboBox(String title, boolean showBorder, boolean initCombo) {
        super(title, showBorder);
        if (initCombo) {
            this.initComboBox();
        }
    }

    public UITitledComboBox(String title, boolean showBorder) {
        this(title, showBorder, true);
    }

    public UITitledComboBox(String title) {
        this(title, false, true);
    }

    public UITitledComboBox() {
        this(null, false, true);
    }

    protected JComboBox createPrivateComboBox() {
        return new PrivateComboBox();
    }

    private void initComboBox() {
        this.usingComboBox = true;
        this.comboBox = this.createPrivateComboBox();
        this.comboBoxBackground = this.comboBox.getBackground();
        this.comboBox.setEditable(false);
        this.setGBConstraints(this.comboBox);
        this.add(this.comboBox);
        this.setLabelComponent(this.comboBox);
        this.actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (!UITitledComboBox.this.ignoreFocusLostEvents || !UITitledComboBox.this.isFocusLostAction()) {
                    UITitledComboBox.this._updateComponent();
                }
            }
        };
        this.comboBox.addActionListener(this.actionListener);
    }

    public boolean isComboBox() {
        return this.usingComboBox;
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void ignoreFocusLostActionEvents(boolean state) {
        this.ignoreFocusLostEvents = state;
    }

    public boolean isFocusLostAction() {
        return this.comboBox instanceof PrivateComboBox && ((PrivateComboBox)this.comboBox).isFocusLostAction();
    }

    protected void _updateComponent() {
        this._resetSelectionToolTip();
        super.updateComponent();
    }

    public boolean isEditable() {
        return this.comboBox != null ? this.comboBox.isEditable() : false;
    }

    public void setEditable(boolean state) {
        JTextField tf;
        if (this.comboBox == null) {
            return;
        }
        this.comboBox.setEditable(state);
        if (state && (tf = this.getEditorTextField()) != null) {
            Font boldFont = tf.getFont();
            tf.setFont(boldFont.deriveFont(0));
        }
        this._resetSelectionToolTip();
    }

    public void propertyChange(PropertyChangeEvent pce) {
        super.propertyChange(pce);
    }

    public void setReverseOrdering(boolean flag) {
        this.setReverseOrdering(flag, -1);
    }

    public void setReverseOrdering(boolean flag, int maxItems) {
        this.reverseOrdering = flag;
        this.maxItems = maxItems;
    }

    public boolean isReverseOrdering() {
        return this.reverseOrdering;
    }

    public int getIndexOf(Object obj) {
        ComboBoxModel model = this.getModel();
        if (model instanceof DefaultComboBoxModel) {
            return ((DefaultComboBoxModel)model).getIndexOf(obj);
        }
        if (model instanceof MutableComboBoxModel) {
            MutableComboBoxModel mcbm = (MutableComboBoxModel)model;
            int size = mcbm.getSize();
            for (int i = 0; i < size; ++i) {
                if (!mcbm.getElementAt(i).equals(obj)) continue;
                return i;
            }
            return -1;
        }
        Print.dprintStackTrace((String)"'getModel()' is not an instanceof 'MutableComboBoxModel'");
        return -1;
    }

    public boolean containsItem(Object obj) {
        return this.getIndexOf(obj) >= 0;
    }

    public void addItem(Object obj, boolean checkForDups) {
        if (!checkForDups || !this.containsItem(obj)) {
            this.addItem(obj);
        }
    }

    public void addItem(Object obj) {
        if (obj == null) {
            return;
        }
        if (UITitledComboBox.isActionItem(obj)) {
            Print.printStackTrace((String)"ActionItems must be added with 'addActionItem'");
            return;
        }
        Object addObj = obj instanceof JRadioButton ? ((JRadioButton)obj).getText() : obj;
        ComboBoxModel model = this.getModel();
        if (model != null) {
            if (model instanceof MutableComboBoxModel) {
                MutableComboBoxModel mcbm = (MutableComboBoxModel)model;
                boolean wasEnabled = this._disableUpdate();
                if (this.isReverseOrdering()) {
                    mcbm.insertElementAt(addObj, 0);
                } else {
                    mcbm.insertElementAt(addObj, UITitledComboBox.getActionItemIndex(mcbm));
                }
                this._enableUpdate(wasEnabled);
            } else {
                Print.printStackTrace((String)("Unable to add item to model: " + DT.className(model)));
            }
        } else {
            boolean wasEnabled = this._disableUpdate();
            if (this.isReverseOrdering()) {
                this.comboBox.insertItemAt(addObj, 0);
            } else {
                this.comboBox.insertItemAt(addObj, UITitledComboBox.getActionItemIndex(this.comboBox));
            }
            this._enableUpdate(wasEnabled);
        }
        this.lastAddedItem = addObj;
        if (this.maxItems > 0) {
            while (this.getItemCount() > this.maxItems) {
                if (this.isReverseOrdering()) {
                    this.removeItemAt(this.getItemCount() - 1);
                    continue;
                }
                this.removeItemAt(0);
            }
        }
    }

    public void removeItem(Object obj) {
        if (obj == null) {
            return;
        }
        Object delObj = obj instanceof JRadioButton ? ((JRadioButton)obj).getText() : obj;
        ComboBoxModel model = this.getModel();
        if (model != null) {
            if (model instanceof MutableComboBoxModel) {
                boolean wasEnabled = this._disableUpdate();
                ((MutableComboBoxModel)model).removeElement(delObj);
                this._enableUpdate(wasEnabled);
            } else {
                Print.printStackTrace((String)"Unable to remove item");
            }
        } else {
            boolean wasEnabled = this._disableUpdate();
            this.comboBox.removeItem(delObj);
            this._enableUpdate(wasEnabled);
        }
        if (this.lastAddedItem != null && this.lastAddedItem.equals(delObj)) {
            this.lastAddedItem = null;
        }
    }

    public void removeItemAt(int ndx) {
        Object delObj = this.getItemAt(ndx);
        ComboBoxModel model = this.getModel();
        if (model != null) {
            if (model instanceof MutableComboBoxModel) {
                boolean wasEnabled = this._disableUpdate();
                ((MutableComboBoxModel)model).removeElementAt(ndx);
                this._enableUpdate(wasEnabled);
            } else {
                Print.printStackTrace((String)"Unable to remove item");
            }
        } else {
            boolean wasEnabled = this._disableUpdate();
            this.comboBox.removeItemAt(ndx);
            this._enableUpdate(wasEnabled);
        }
        if (this.lastAddedItem != null && this.lastAddedItem.equals(delObj)) {
            this.lastAddedItem = null;
        }
    }

    public void setBrowserButton(JButton button) {
        if (this.browserButton == null) {
            this.browserButton = button;
            this.browserButton.setMargin(new Insets(0, 3, 0, 3));
            Dimension bsize = new Dimension(this.browserButton.getPreferredSize().width, this.comboBox.getPreferredSize().height);
            this.browserButton.setPreferredSize(bsize);
            this.browserButton.setMaximumSize(bsize);
            GridBagConstraints c = this.getGBConstraintsCopy();
            c.weightx = 0.0;
            c.gridx = -1;
            c.gridy = 0;
            c.insets.left = 3;
            c.fill = 0;
            this.add((Component)this.browserButton, c);
        } else {
            Print.dprintStackTrace((String)"BrowserButton already set");
        }
    }

    public void setBrowserActionListener(ActionListener listener) {
        if (this.browserButton == null) {
            UIButton button = new UIButton(BROWSE, BROWSE_MNEMONIC);
            button.addActionListener(listener);
            this.setBrowserButton(button);
        }
    }

    public void setBrowserFilterKey(String filterKey) {
        if (this.browserButton == null) {
            if (filterKey != null) {
                this.browserFilterKey = filterKey;
                this.setBrowserActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        UITitledComboBox.this.showBrowserFileChooser();
                    }
                });
            } else {
                this.browserFilterKey = null;
                this.setBrowserActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        UITitledComboBox.this.showBrowserDirChooser();
                    }
                });
            }
        } else {
            Print.dprintStackTrace((String)"BrowserButton already set");
        }
    }

    public void setBrowserMnemonic(char c) {
        this.browserButton.setMnemonic(c);
    }

    private void showBrowserFileChooser() {
        File currentDir = new File(this.getText());
        UIFileChooser jfc = UIFileChooser.getFileChooser(currentDir, this.browserFilterKey);
        int rtn = jfc.showDialog(this, BROWSE_SELECT);
        if (rtn == 0) {
            File chosenFile = jfc.getSelectedFile();
            this.setText(chosenFile.toString());
            this.fireUpdate();
        }
    }

    private void showBrowserDirChooser() {
        File currentDir = new File(this.getText());
        UIFileChooser jfc = UIFileChooser.getDirChooser(currentDir);
        int rtn = jfc.showDialog(this, BROWSE_SELECT);
        if (rtn == 0) {
            File chosenDir = jfc.getSelectedFile();
            this.setText(chosenDir.toString());
            this.fireUpdate();
        }
    }

    public Object getActionItemForTitle(String title) {
        if (this.actionItems != null) {
            Iterator i = this.actionItems.iterator();
            while (i.hasNext()) {
                Object item = i.next();
                if (!item.toString().equals(title)) continue;
                return item;
            }
        }
        return null;
    }

    public void removeActionItem(String title) {
        if (this.actionItems != null) {
            ComboBoxModel model = this.getModel();
            Iterator i = this.actionItems.iterator();
            while (i.hasNext()) {
                Object item = i.next();
                if (!item.toString().equals(title)) continue;
                i.remove();
                if (!(model instanceof MutableComboBoxModel)) continue;
                ((MutableComboBoxModel)model).removeElement(item);
            }
        }
    }

    public void addActionItem(UIActionDispatcher action) {
        this._addActionItem(action);
    }

    public void addActionItem(String title, ActionListener al) {
        this._addActionItem(new ActionItem(title, al));
    }

    protected void _addActionItem(Object action) {
        UITitledComboBox.addActionItemToModel(this.getModel(), action);
        if (this.actionItems == null) {
            this.actionItems = new Vector();
        }
        if (this.getActionItemForTitle(action.toString()) == null) {
            this.actionItems.add(action);
        }
    }

    protected static void addActionItemToModel(ComboBoxModel model, Object item) {
        if (item != null) {
            if (UITitledComboBox.isActionItem(item)) {
                if (model instanceof MutableComboBoxModel) {
                    MutableComboBoxModel mcbm = (MutableComboBoxModel)model;
                    int separatorIndex = UITitledComboBox.getActionItemIndex(model);
                    if (separatorIndex >= mcbm.getSize() || !(mcbm.getElementAt(separatorIndex) instanceof JSeparator)) {
                        JSeparator js = new JSeparator();
                        js.getAccessibleContext().setAccessibleName(SEPARATOR_NAME);
                        js.getAccessibleContext().setAccessibleDescription(SEPARATOR_DESC);
                        mcbm.insertElementAt(js, separatorIndex);
                    }
                    if (separatorIndex == 0) {
                        mcbm.insertElementAt(NULL_VALUE, 0);
                        ++separatorIndex;
                    }
                    mcbm.addElement(item);
                } else {
                    Print.dprintStackTrace((String)("Unsupported model: " + DT.className(model)));
                }
            } else {
                Print.dprintStackTrace((String)("Unsupported ActionItem: " + DT.className(item)));
            }
        }
    }

    protected void _resetActionItems(ComboBoxModel model) {
        if (this.actionItems == null) {
            return;
        }
        if (!(model instanceof MutableComboBoxModel)) {
            Print.dprintln((String)"Can't support 'ActionItem's!");
            return;
        }
        MutableComboBoxModel mcbm = (MutableComboBoxModel)model;
        int size = mcbm.getSize();
        int i = 0;
        while (i < size) {
            Object item = mcbm.getElementAt(i);
            if (UITitledComboBox.isActionItem(item)) {
                mcbm.removeElementAt(i);
                continue;
            }
            ++i;
        }
        Iterator i2 = this.actionItems.iterator();
        while (i2.hasNext()) {
            UITitledComboBox.addActionItemToModel(mcbm, i2.next());
        }
    }

    protected static int getActionItemIndex(ComboBoxModel model) {
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            if (!UITitledComboBox.isActionItem(model.getElementAt(i))) continue;
            return i;
        }
        return size;
    }

    protected static int getActionItemIndex(JComboBox comboBox) {
        int size = comboBox.getItemCount();
        for (int i = 0; i < size; ++i) {
            if (!UITitledComboBox.isActionItem(comboBox.getItemAt(i))) continue;
            return i;
        }
        return size;
    }

    public ComboBoxModel getModel() {
        return this.comboModel != null ? this.comboModel : this.comboBox.getModel();
    }

    public void clearModel() {
        this.setModel((ComboBoxModel)null);
    }

    public void setModel(ComboBoxModel model) {
        if (model == null) {
            model = new DefaultComboBoxModel();
        }
        Object sel = this.clearWhenDisabled && !this.isEnabled() ? this.lastEnabledSelection : this.getSelectedItem();
        int modelSize = model.getSize();
        int selIndex = -1;
        for (int i = 0; i < modelSize; ++i) {
            Object item = model.getElementAt(i);
            if (item == null) {
                if (model instanceof MutableComboBoxModel) {
                    Print.dprintStackTrace((String)("Replacing 'null' element found at index " + i));
                    ((MutableComboBoxModel)model).removeElementAt(i);
                    ((MutableComboBoxModel)model).insertElementAt(NULL_VALUE, i);
                    continue;
                }
                Print.dprintStackTrace((String)("'null' element found at index " + i));
                continue;
            }
            if (!item.equals(sel)) continue;
            selIndex = i;
        }
        this._resetActionItems(model);
        boolean wasEnabled = this._disableUpdate();
        this.comboModel = model;
        this.comboBox.setModel(this.comboModel);
        this._enableUpdate(wasEnabled);
        if (this.clearWhenDisabled && !this.isEnabled()) {
            this.lastEnabledSelection = selIndex >= 0 ? sel : (model.getSize() > 0 ? this.getItemAt(0) : null);
            this._setSelectedIndex(-1);
        } else if (selIndex >= 0) {
            this._setSelectedIndex(selIndex);
        } else if (model.getSize() > 0) {
            this._setSelectedIndex(0);
        } else {
            this._setSelectedIndex(-1);
        }
    }

    public void setModel(MutableComboBoxModel model) {
        this.setModel((ComboBoxModel)model);
    }

    public void setModel(Object[] items) {
        DefaultComboBoxModel<Object> model = items != null ? new DefaultComboBoxModel<Object>(items) : null;
        this.setModel((ComboBoxModel)model);
    }

    public void setModel(Vector items) {
        DefaultComboBoxModel model = items != null ? new DefaultComboBoxModel(items) : null;
        this.setModel((ComboBoxModel)model);
    }

    public void setModel(Collection items) {
        DefaultComboBoxModel model = null;
        if (items != null) {
            Vector v = new Vector();
            Iterator i = items.iterator();
            while (i.hasNext()) {
                v.add(i.next());
            }
            model = new DefaultComboBoxModel(v);
        }
        this.setModel((ComboBoxModel)model);
    }

    public int getItemCount() {
        return this.comboBox.getItemCount();
    }

    public Object getItemAt(int ndx) {
        return this.comboBox.getItemAt(ndx);
    }

    public void setShowSelectionAsToolTip(boolean state) {
        this.showSelectionAsToolTip = state;
    }

    public boolean getShowSelectionAsToolTip() {
        return this.showSelectionAsToolTip;
    }

    private void _resetSelectionToolTip() {
        if (this.showSelectionAsToolTip) {
            String tt = this.getText();
            this.comboBox.setToolTipText(!tt.equals(NULL_VALUE) ? tt : null);
        }
    }

    public void setShowWidePopups(boolean state) {
        if (this.comboBox instanceof PrivateComboBox) {
            ((PrivateComboBox)this.comboBox).setShowWidePopups(state);
        }
    }

    public boolean getShowWidePopups() {
        return this.comboBox instanceof PrivateComboBox ? ((PrivateComboBox)this.comboBox).getShowWidePopups() : false;
    }

    public void clearSelection() {
        this.lastEnabledSelection = null;
        this._setSelectedIndex(-1);
    }

    public void setSelectedItem(Object item, boolean addIfAbsent) {
        if (addIfAbsent) {
            if (item == null) {
                item = NULL_VALUE;
            }
            this.addItem(item, true);
        }
        this.setSelectedItem(item);
    }

    public void setSelectedItem(Object item) {
        if (UITitledComboBox.isActionItem(item)) {
            this.lastEnabledSelection = null;
            this._setSelectedIndex(-1);
        } else if (this.clearWhenDisabled && !this.isEnabled()) {
            this.lastEnabledSelection = item;
            this._setSelectedIndex(-1);
        } else if (item == null) {
            this._setSelectedIndex(-1);
        } else {
            this._setSelectedItem(item);
        }
    }

    private void _setSelectedItem(Object item) {
        boolean wasEnabled = this._disableUpdate();
        this.comboBox.setSelectedItem(item);
        this._resetSelectionToolTip();
        this._enableComponentsForSelection();
        this._enableUpdate(wasEnabled);
    }

    public Object getSelectedItem() {
        if (this.clearWhenDisabled && !this.isEnabled()) {
            return this.lastEnabledSelection;
        }
        return this.comboBox.getSelectedItem();
    }

    public Object[] getSelectedObjects() {
        return this.comboBox.getSelectedObjects();
    }

    public void setSelectedIndex(int index) {
        if (this.clearWhenDisabled && !this.isEnabled()) {
            Object item;
            Object v0 = item = index >= 0 ? this.comboBox.getItemAt(index) : null;
            if (UITitledComboBox.isActionItem(item)) {
                this.lastEnabledSelection = null;
                this._setSelectedIndex(-1);
            } else {
                this.lastEnabledSelection = item;
                this._setSelectedIndex(-1);
            }
        } else {
            this._setSelectedIndex(index);
        }
    }

    private void _setSelectedIndex(int index) {
        JTextField tf;
        boolean wasEnabled = this._disableUpdate();
        this.comboBox.setSelectedIndex(index);
        if (index < 0 && this.isEditable() && (tf = this.getEditorTextField()) != null) {
            tf.setText(NULL_VALUE);
        }
        this._resetSelectionToolTip();
        this._enableComponentsForSelection();
        this._enableUpdate(wasEnabled);
    }

    public int getSelectedIndex() {
        return this.comboBox.getSelectedIndex();
    }

    public boolean isSelectedItem(Object item) {
        Object selObj = this.getSelectedItem();
        return selObj != null && item.equals(selObj);
    }

    private boolean _disableUpdate() {
        this.setUpdateReason("SetSelect");
        boolean wasEnabled = this.isUpdateEnabled;
        this.isUpdateEnabled = false;
        return wasEnabled;
    }

    private void _enableUpdate(boolean wasEnabled) {
        this.isUpdateEnabled = wasEnabled;
        this.setUpdateReason(null);
    }

    protected String _selectionText(Object sel) {
        String t = NULL_VALUE;
        t = sel == null ? NULL_VALUE : (sel instanceof Class ? ((Class)sel).getName() : (sel instanceof Descriptor ? DescriptorTools.getDisplayName(sel) : sel.toString()));
        return t.trim();
    }

    public JTextField getEditorTextField() {
        if (this.isEditable()) {
            ComboBoxEditor editor = this.comboBox.getEditor();
            Component comp = editor.getEditorComponent();
            if (comp instanceof JTextField) {
                return (JTextField)comp;
            }
            Print.printStackTrace((String)"Editor component is not a JTextField");
        }
        return null;
    }

    public String getText() {
        if (this.clearWhenDisabled && !this.isEnabled()) {
            return this._selectionText(this.lastEnabledSelection);
        }
        if (this.isEditable()) {
            JTextField tf = this.getEditorTextField();
            String text = tf != null ? tf.getText() : NULL_VALUE;
            return text.trim();
        }
        return this._selectionText(this.comboBox.getSelectedItem());
    }

    public void setText(String text) {
        if (this.clearWhenDisabled && !this.isEnabled()) {
            this.lastEnabledSelection = text;
            this._setSelectedIndex(-1);
        } else if (this.isEditable()) {
            this._setSelectedItem(text);
        } else if (text == null) {
            this._setSelectedIndex(-1);
        } else {
            this._setSelectedItem(text);
        }
    }

    public void setIntValue(int val) {
        this.setText(String.valueOf(val));
    }

    public int getIntValue(int defaultValue) {
        String num = this.getText();
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException nfe) {
            int p;
            if (num.equals(NULL_VALUE)) {
                return defaultValue;
            }
            int len = num.length();
            int n = p = num.charAt(0) == '-' ? 1 : 0;
            while (p < len && Character.isDigit(num.charAt(p))) {
                ++p;
            }
            try {
                return Integer.parseInt(num.substring(0, p));
            }
            catch (NumberFormatException nfe2) {
                return defaultValue;
            }
        }
    }

    public void addItemListener(ItemListener listener) {
        this.comboBox.addItemListener(listener);
    }

    public void removeItemListener(ItemListener listener) {
        this.comboBox.removeItemListener(listener);
    }

    public void setReadOnly(boolean state) {
        this.comboBox.setEnabled(this.isEnabled() && !state);
        super.setReadOnly(state);
    }

    protected void _setReadOnly(boolean state) {
        super.setReadOnly(state);
    }

    public void setEnabled(boolean state) {
        boolean oldState = this.isEnabled();
        if (this.clearWhenDisabled) {
            if (!state && oldState) {
                if (this.lastEnabledSelection == null) {
                    this.lastEnabledSelection = this.isEditable() ? this.getText() : this.getSelectedItem();
                }
                this._setSelectedIndex(-1);
            } else if (state && !oldState && this.lastEnabledSelection != null) {
                this._setSelectedItem(this.lastEnabledSelection);
                this.lastEnabledSelection = null;
            }
        }
        this.comboBox.setEnabled(state && !this.isReadOnly());
        super.setEnabled(state);
    }

    protected void _setEnabled(boolean state) {
        super.setEnabled(state);
    }

    protected void setChildEnabled(Component child, boolean state) {
        child.setEnabled(state ? this._canEnableChild(child) : false);
    }

    protected boolean _canEnableChild(Component comp) {
        if (this.selectionEnabler == null) {
            return true;
        }
        Object val = this.selectionEnabler.get(comp);
        if (val == null) {
            return true;
        }
        Object selItem = this.getSelectedItem();
        if (selItem == null) {
            return false;
        }
        return val.equals(selItem);
    }

    public void addSelectionEnabledComponent(Component comp, Object selItem) {
        this._addSelectionEnabledObject(comp, selItem);
    }

    public void addSelectionEnabledAction(ActionListener action, Object selItem) {
        this._addSelectionEnabledObject(new SelectableAction(action), selItem);
    }

    protected void _addSelectionEnabledObject(Object selObj, Object selItem) {
        Object item;
        if (this.selectionEnabler == null) {
            this.selectionEnabler = new Hashtable();
        }
        Object object = item = selItem == null || selItem.equals(LAST_ADDED_ITEM) ? this.lastAddedItem : selItem;
        if (item != null) {
            this.selectionEnabler.put(selObj, item);
            if (selObj instanceof Component) {
                ((Component)selObj).setEnabled(this.isSelectedItem(item));
            } else if (selObj instanceof SelectableAction) {
                ((SelectableAction)selObj).setEnabled(this.isSelectedItem(item), false);
            } else if (selObj instanceof ActionListener) {
                // empty if block
            }
        } else {
            Print.printStackTrace((String)"Attempting to add 'null' item");
        }
    }

    protected void _enableComponentsForSelection() {
        if (this.selectionEnabler != null) {
            Object selItem = this.getSelectedItem();
            Enumeration keys = this.selectionEnabler.keys();
            while (keys.hasMoreElements()) {
                Object c = keys.nextElement();
                boolean enable = this.selectionEnabler.get(c).equals(selItem);
                if (c instanceof Component) {
                    ((Component)c).setEnabled(enable);
                    continue;
                }
                if (c instanceof SelectableAction) {
                    ((SelectableAction)c).setEnabled(enable, true);
                    continue;
                }
                if (!(c instanceof ActionListener) || !enable) continue;
                UIActionDispatcher.invoke((ActionListener)c);
            }
        }
    }

    public Vector getSelectionEnabledComponents(Object item) {
        Vector v = new Vector();
        if (this.selectionEnabler != null) {
            Enumeration keys = this.selectionEnabler.keys();
            while (keys.hasMoreElements()) {
                Object c = keys.nextElement();
                if (!(c instanceof Component) || !this.selectionEnabler.get(c).equals(item)) continue;
                v.add(c);
            }
        }
        return v;
    }

    public static boolean isActionItem(Object item) {
        return item instanceof ActionItem || item instanceof UIActionDispatcher || item instanceof JSeparator;
    }

    public String toString() {
        return this.comboBox.toString();
    }

    private static class PrivateComboBoxUI
    extends MetalComboBoxUI {
        private PrivateComboBoxUI() {
        }

        public static ComponentUI createUI(JComponent c) {
            return new PrivateComboBoxUI();
        }

        protected ComboPopup createPopup() {
            PrivateComboPopup pu = new PrivateComboPopup(this.comboBox);
            pu.getAccessibleContext().setAccessibleParent(this.comboBox);
            return pu;
        }

        public void setPopupVisible(JComboBox c, boolean v) {
            super.setPopupVisible(c, v);
        }

        private class CustomComboPopup
        extends MetalComboBoxUI.MetalComboPopup {
            private PrivateComboBox pcb;

            public CustomComboPopup(JComboBox combo) {
                super(PrivateComboBoxUI.this, combo);
                this.pcb = null;
                this.pcb = (PrivateComboBox)combo;
            }

            public KeyListener getKeyListener() {
                return super.getKeyListener();
            }

            public JList getList() {
                return super.getList();
            }

            protected JList createList() {
                JList jl = new JList();
                jl.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.uititledcombobox.list_name", "List"));
                jl.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.uititledcombobox.list_desc", "This is a list of items"));
                return jl;
            }

            public MouseListener getMouseListener() {
                return super.getMouseListener();
            }

            public MouseMotionListener getMouseMotionListener() {
                return super.getMouseMotionListener();
            }

            public boolean isVisible() {
                return super.isVisible();
            }

            public void show() {
                Point pcbOrigin = this.pcb.getLocationOnScreen();
            }

            public void hide() {
            }

            public void uninstallingUI() {
                super.uninstallingUI();
            }
        }

        private class PrivateComboPopup
        extends MetalComboBoxUI.MetalComboPopup {
            private PrivateComboBox pcb;

            public PrivateComboPopup(JComboBox combo) {
                super(PrivateComboBoxUI.this, combo);
                this.pcb = null;
                this.pcb = (PrivateComboBox)combo;
            }

            protected JList createList() {
                return super.createList();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void show() {
                if (this.pcb.getShowWidePopups()) {
                    try {
                        this.pcb._showingPopup(true);
                        super.show();
                    }
                    finally {
                        this.pcb._showingPopup(false);
                    }
                } else {
                    super.show();
                }
            }
        }
    }

    protected class PrivateComboBox
    extends JComboBox
    implements ItemListener {
        private Color savedBackground = null;
        private Color savedEditorBackground = null;
        private boolean showWidePopups = true;
        private int showingPopup = 0;
        private boolean isFocusLostAction = false;

        public PrivateComboBox() {
            this.getAccessibleContext().setAccessibleName(CBOX_NAME);
            this.getAccessibleContext().setAccessibleDescription(CBOX_DESC);
            if (!didResetComboBoxColors) {
                Color c = UIManager.getColor("ComboBox.disabledForeground");
                if (!c.equals(UITitledBox.DisabledTextColor)) {
                    UIManager.put("ComboBox.disabledForeground", UITitledBox.DisabledTextColor);
                }
                didResetComboBoxColors = true;
            }
            this.savedBackground = this.getBackground();
            this.addItemListener(this);
            this.setRenderer(new PopupListCellRenderer());
        }

        public boolean getShowWidePopups() {
            return this.showWidePopups;
        }

        public void setShowWidePopups(boolean state) {
            this.showWidePopups = state;
            this.updateUI();
        }

        private void _showingPopup(boolean state) {
            this.showingPopup = state ? ++this.showingPopup : --this.showingPopup;
        }

        public void updateUI() {
            if (this.getShowWidePopups()) {
                if (UITitledBox.isMetalLookAndFeel()) {
                    this.setUI(PrivateComboBoxUI.createUI(this));
                } else {
                    Print.dprintln((String)"Not MetalLookAndFeel: initializing with standard L&F");
                    super.updateUI();
                }
            } else {
                super.updateUI();
            }
        }

        public Dimension getSize() {
            if (this.showingPopup > 0) {
                Dimension d = new Dimension(super.getSize());
                d.width = Math.max(d.width, this.getPreferredPopupWidth());
                return d;
            }
            return super.getSize();
        }

        public void setEditable(boolean state) {
            super.setEditable(state);
        }

        public void setEnabled(boolean state) {
            Component c;
            super.setEnabled(state);
            super.setBackground(state ? this.savedBackground : UITitledBox.DisabledBackgroundColor);
            if (this.isEditable() && this.getEditor() != null && (c = this.getEditor().getEditorComponent()) instanceof JTextComponent) {
                JTextComponent tc = (JTextComponent)c;
                if (this.savedEditorBackground == null) {
                    this.savedEditorBackground = tc.getBackground();
                }
                tc.setBackground(state ? this.savedEditorBackground : UITitledBox.DisabledBackgroundColor);
            }
        }

        public void itemStateChanged(ItemEvent ie) {
            if (ie.getStateChange() == 1) {
                UITitledComboBox.this._enableComponentsForSelection();
            }
        }

        public int getPreferredPopupWidth() {
            JList list = this.getJList();
            if (list != null) {
                ListCellRenderer rend = list.getCellRenderer();
                ComboBoxModel model = this.getModel();
                int rows = this.getModel().getSize();
                int width = 0;
                for (int r = 0; r < rows; ++r) {
                    Object item = model.getElementAt(r);
                    Component c = rend.getListCellRendererComponent(list, item, r, false, false);
                    width = Math.max(width, c.getPreferredSize().width);
                }
                return width;
            }
            return -1;
        }

        private JList getJList() {
            Accessible a = this.getUI().getAccessibleChild(this, 0);
            return a instanceof ComboPopup ? ((ComboPopup)((Object)a)).getList() : null;
        }

        public void setUpdateReason(String reason) {
            UITitledComboBox.this.setUpdateReason(reason);
        }

        protected void fireActionEvent() {
            super.fireActionEvent();
        }

        public void actionPerformed(ActionEvent e) {
            this.isFocusLostAction = e.getID() == 0;
            super.actionPerformed(e);
            this.isFocusLostAction = false;
        }

        public boolean isFocusLostAction() {
            return this.isFocusLostAction;
        }

        public int getSelectedIndex() {
            ComboBoxModel model = this.getModel();
            Object sel = model.getSelectedItem();
            if (sel == null) {
                sel = UITitledComboBox.NULL_VALUE;
            }
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                Object obj = model.getElementAt(i);
                if (obj == null) {
                    obj = this._replaceNullIndex(i);
                }
                if (!obj.equals(sel)) continue;
                return i;
            }
            return -1;
        }

        public void setSelectedIndex(int ndx) {
            if (ndx < 0) {
                super.setSelectedIndex(-1);
            } else {
                Object obj = this.getItemAt(ndx);
                if (UITitledComboBox.isActionItem(obj)) {
                    if (obj instanceof ActionItem) {
                        ((ActionItem)obj).invokeLater();
                    } else if (obj instanceof UIActionDispatcher) {
                        ((UIActionDispatcher)obj).invokeLater();
                    }
                } else {
                    super.setSelectedIndex(ndx);
                }
            }
        }

        public void setSelectedItem(Object item) {
            if (!UITitledComboBox.isActionItem(item)) {
                super.setSelectedItem(item);
            }
        }

        private Object _replaceNullIndex(int i) {
            ComboBoxModel model = this.getModel();
            if (model instanceof MutableComboBoxModel) {
                Print.dprintStackTrace((String)("Replacing 'null' element found at index " + i));
                ((MutableComboBoxModel)model).removeElementAt(i);
                ((MutableComboBoxModel)model).insertElementAt(UITitledComboBox.NULL_VALUE, i);
            } else {
                Print.dprintStackTrace((String)("'null' element found at index " + i));
            }
            return UITitledComboBox.NULL_VALUE;
        }

        public class PopupListCellRenderer
        extends DefaultListCellRenderer {
            public Component getListCellRendererComponent(JList list, Object v, int ndx, boolean sel, boolean focus) {
                if (v instanceof JSeparator) {
                    return (Component)v;
                }
                if (v instanceof Class) {
                    Component c = super.getListCellRendererComponent((JList<?>)list, ((Class)v).getName(), ndx, sel, focus);
                    if (c instanceof JLabel && ndx == -1) {
                        ((JLabel)c).setText(StringTools.rightAlignLongText(((Class)v).getName(), this.getFontMetrics(this.getFont()), this.comboBoxWidthMinusArrow()));
                    }
                    return c;
                }
                if (v instanceof Descriptor) {
                    Component c;
                    String n;
                    Descriptor d = (Descriptor)v;
                    String dname = DescriptorTools.getDisplayName(d);
                    Descriptor m = DescriptorTools.getModuleDescriptor(d);
                    String mname = DescriptorTools.getDisplayName(m);
                    String string = n = m == null || m.equals(UITitledComboBox.NULL_VALUE) || m == d ? dname : dname + " (" + mname + ")";
                    if (n.equals(UITitledComboBox.NULL_VALUE)) {
                        String cn = d.getClass().getName();
                        int p = cn.lastIndexOf(".");
                        if (p >= 0) {
                            cn = cn.substring(p + 1);
                        }
                        n = "<" + cn + ">";
                    }
                    if ((c = super.getListCellRendererComponent((JList<?>)list, n, ndx, sel, focus)) instanceof JLabel) {
                        ((JLabel)c).setIcon(UIIcons.getIconFor(d, false));
                        if (ndx == -1) {
                            ((JLabel)c).setText(StringTools.rightAlignLongText(n, this.getFontMetrics(this.getFont()), this.comboBoxWidthMinusArrow()));
                        }
                    }
                    return c;
                }
                Component c = super.getListCellRendererComponent((JList<?>)list, v, ndx, sel, focus);
                if (c instanceof JLabel && ndx == -1) {
                    String str = v == null ? UITitledComboBox.NULL_VALUE : v.toString();
                    ((JLabel)c).setText(StringTools.rightAlignLongText(str, this.getFontMetrics(this.getFont()), this.comboBoxWidthMinusArrow()));
                }
                if (UITitledComboBox.isActionItem(v)) {
                    c.setForeground(UIConfig.getConfigColor("ui.ComboBox.actionItemCellColor"));
                }
                return c;
            }

            public int comboBoxWidthMinusArrow() {
                return PrivateComboBox.this.getWidth() - 24;
            }
        }
    }

    private static class ActionItem {
        private String title = null;
        private ActionListener action = null;

        public ActionItem(String title, ActionListener action) {
            this.title = title;
            this.action = action;
        }

        public void invokeLater() {
            if (this.action instanceof UIActionDispatcher) {
                ((UIActionDispatcher)this.action).invokeLater();
            } else if (this.action != null) {
                UIActionDispatcher.invokeLater(this.action);
            }
        }

        public String toString() {
            if (this.title != null) {
                return this.title;
            }
            if (this.action instanceof UIActionDispatcher) {
                return this.action.toString();
            }
            return "<action>";
        }
    }

    private class SelectableAction {
        private ActionListener action = null;
        private boolean isEnabled = true;

        public SelectableAction(ActionListener action) {
            this.action = action;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public void setEnabled(boolean enable, boolean invoke) {
            if (this.isEnabled != enable) {
                this.isEnabled = enable;
                if (this.isEnabled && invoke) {
                    UIActionDispatcher.invoke(this.action);
                }
            }
        }
    }
}

