/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class UITitledCheckBoxList
extends UITitledList {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UITitledCheckBoxList.class);
    private static String PANEL_NAME = localStrings.getLocalString("ui.uititledboxcheckboxlist.panel_name", "Panel");
    private static String PANEL_DESC = localStrings.getLocalString("ui.uititledboxcheckboxlist.panel_desc", "This is the panel for the titled check box list");
    private Object selectedCheckBoxData = null;
    private boolean selectedCheckBoxState = false;

    public UITitledCheckBoxList(String title, boolean showBorder) {
        this(title, showBorder, true);
    }

    public UITitledCheckBoxList(String title, boolean showBorder, boolean scrollable) {
        super(title, showBorder);
        super.setListView(this.createDefaultListView(false), scrollable);
    }

    public JList createDefaultListView(boolean inclIcon) {
        JList list = super.createDefaultListView(inclIcon);
        list.setBackground(Color.white);
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int r = ((JList)e.getSource()).locationToIndex(e.getPoint());
                if (r >= 0) {
                    UITitledCheckBoxList.this._setCheckBoxSelectionAt(r, -1);
                }
            }
        });
        list.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return (ListJCheckBox)value;
            }
        });
        return list;
    }

    public boolean contains(String text) {
        return this.getIndexOfCheckBox(text) >= 0;
    }

    public int getIndexOfCheckBox(String text) {
        if (text != null) {
            for (int r = 0; r < this.getListDataCount(); ++r) {
                if (!this.getCheckBoxAt(r).getText().equals(text)) continue;
                return r;
            }
        }
        return -1;
    }

    public JCheckBox getCheckBox(String text) {
        int row = this.getIndexOfCheckBox(text);
        return row >= 0 ? this.getCheckBoxAt(row) : null;
    }

    public JCheckBox getCheckBoxAt(int row) {
        return ((ListJCheckBox)this.getListDataAt(row)).getCheckBox();
    }

    public Object getCheckBoxData(String text) {
        int row = this.getIndexOfCheckBox(text);
        return row >= 0 ? this.getCheckBoxDataAt(row) : null;
    }

    public Object getCheckBoxDataAt(int row) {
        return ((ListJCheckBox)this.getListDataAt(row)).getData();
    }

    private void _setCheckBoxSelectionAt(int row, int v) {
        ListJCheckBox cb = (ListJCheckBox)this.getListDataAt(row);
        boolean toggle = v < 0 ? !cb.isSelected() : v != 0;
        cb.setSelected(toggle);
        this.selectedCheckBoxState = toggle;
        this.selectedCheckBoxData = cb.getData();
        this.updateComponent(this);
        this.getListView().repaint();
    }

    public void setCheckBoxSelection(String text, boolean state) {
        int row = this.getIndexOfCheckBox(text);
        this._setCheckBoxSelectionAt(row, state ? 1 : 0);
    }

    public void setCheckBoxSelectionAt(int row, boolean state) {
        this._setCheckBoxSelectionAt(row, state ? 1 : 0);
    }

    public boolean isCheckBoxSelected(String text) {
        JCheckBox cb = this.getCheckBox(text);
        return cb != null ? cb.isSelected() : false;
    }

    public boolean isCheckBoxSelectedAt(int row) {
        JCheckBox cb = this.getCheckBoxAt(row);
        return cb != null ? cb.isSelected() : false;
    }

    public Object getSelectedCheckBoxData() {
        return this.selectedCheckBoxData;
    }

    public boolean getSelectedCheckBoxState() {
        return this.selectedCheckBoxState;
    }

    public void setCheckBoxEnabled(String text, boolean enabled) {
        JCheckBox cb;
        int row = this.getIndexOfCheckBox(text);
        JCheckBox jCheckBox = cb = row >= 0 ? this.getCheckBoxAt(row) : null;
        if (cb != null) {
            cb.setEnabled(enabled);
            this.repaint();
        } else {
            Print.dprintln((String)("Checkbox not found: " + text));
        }
    }

    public void setCheckBoxEnabled(boolean enabled) {
        int size = this.getListDataCount();
        for (int r = 0; r < size; ++r) {
            this.getCheckBoxAt(r).setEnabled(enabled);
        }
        this.repaint();
    }

    public void setCheckBoxEnabled(Object[] items, boolean enable) {
        int size = this.getListDataCount();
        for (int r = 0; r < size; ++r) {
            JCheckBox cb;
            boolean contains = ListTools.arrayContains(items, (cb = this.getCheckBoxAt(r)).getText(), true);
            cb.setEnabled(contains ? enable : !enable);
        }
        this.repaint();
    }

    public void setCheckBoxEnabled(Collection items, boolean enable) {
        this.setCheckBoxEnabled(items != null ? items.toArray() : null, enable);
    }

    public void setListView(JList list) {
        Print.printStackTrace((String)"This method should not be invoked");
        if (this.getView() == null) {
            super.setListView(this.createDefaultListView(false));
        }
    }

    public void clearList() {
        this.getListModel().clear();
    }

    public void setToolTipText(String toolTip) {
        this.getListView().setToolTipText(toolTip);
    }

    public void addCheckBoxItem(String title) {
        this.addCheckBoxItem(title, false, true, title);
    }

    public void addCheckBoxItem(String title, boolean selected, Object data) {
        this.addCheckBoxItem(title, selected, true, data);
    }

    public void addCheckBoxItem(String title, boolean selected, boolean enabled, Object data) {
        super.addListItem(new ListJCheckBox(title, data, selected, enabled));
    }

    public void addCheckBoxItems(String[] title) {
        for (int i = 0; i < title.length; ++i) {
            this.addCheckBoxItem(title[i]);
        }
    }

    public void addListItem(Object item) {
        Print.printStackTrace((String)"This method should not be called");
        super.addListItem(item);
    }

    private class ListJCheckBox
    extends JPanel {
        private Color background;
        private Color foreground;
        private Object data;
        private UICheckBox checkBox;

        private ListJCheckBox() {
            super(new GridBagLayout());
            this.background = Color.white;
            this.foreground = Color.black;
            this.data = null;
            this.checkBox = null;
            this.getAccessibleContext().setAccessibleName(PANEL_NAME);
            this.getAccessibleContext().setAccessibleDescription(PANEL_DESC);
            GridBagConstraints c = new GridBagConstraints();
            this.setOpaque(true);
            this.setBackground(UITitledCheckBoxList.this.isScrollable() ? this.background : UITitledCheckBoxList.this.getBackground());
            this.checkBox = new UICheckBox();
            this.checkBox.setClearWhenDisabled(true);
            this.checkBox.setOpaque(true);
            this.checkBox.setBackground(UITitledCheckBoxList.this.isScrollable() ? this.background : UITitledCheckBoxList.this.getBackground());
            this.checkBox.setForeground(UITitledCheckBoxList.this.isScrollable() ? this.foreground : UITitledCheckBoxList.this.getForeground());
            c.weightx = 0.5;
            c.weighty = 0.5;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = UITitledCheckBoxList.this.isScrollable() ? new Insets(0, 5, 0, 0) : new Insets(0, 10, 0, 0);
            c.fill = 1;
            c.anchor = 17;
            this.add((Component)this.checkBox, c);
        }

        public ListJCheckBox(String title, Object data, boolean selected, boolean enabled) {
            this();
            this.data = data;
            UIButton.setButtonText(this.checkBox, title);
            this.setSelected(selected);
            this.setEnabled(enabled);
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }

        public void setSelected(boolean state) {
            this.checkBox.setSelected(state);
        }

        public boolean isEnabled() {
            return this.checkBox.isEnabled();
        }

        public void setEnabled(boolean state) {
            super.setEnabled(state);
            this.checkBox.setEnabled(state);
        }

        public Object getData() {
            return this.data;
        }

        public JCheckBox getCheckBox() {
            return this.checkBox;
        }

        public String toString() {
            return this.checkBox.getText();
        }
    }
}

