/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class UISortedTreeNode
extends DefaultMutableTreeNode {
    private static boolean SortFileTreeNodes = true;
    private static String FileSeperator = File.separator;
    private static String ArchSeperator = "/";
    private static Comparator nodeComparator = null;

    public UISortedTreeNode(Object obj, boolean allowsChildren) {
        super(obj, allowsChildren);
    }

    public void add(DefaultMutableTreeNode node) {
        if (SortFileTreeNodes) {
            int loc;
            int n = loc = this.children != null ? Collections.binarySearch(this.children, node, UISortedTreeNode.GetSortComparator()) : 0;
            if (loc < 0) {
                loc = -(loc + 1);
            }
            this.insert(node, loc);
        } else {
            super.add(node);
        }
    }

    public TreeNode getNamedChild(String name) {
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            TreeNode node = children.nextElement();
            if (!node.toString().equals(name)) continue;
            return node;
        }
        return null;
    }

    public void addPath(Object[] list, boolean allowsChildren) {
        this._addPath(new ArrayEnumerator(list), allowsChildren);
    }

    public void addPath(String path, String separator, boolean allowsChildren) {
        this._addPath(new StringTokenizer(path, separator), allowsChildren);
    }

    public void addFileList(Collection list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object entry = i.next();
            if (entry instanceof File) {
                this.addFilePath((File)entry);
                continue;
            }
            this.addPath(entry.toString(), FileSeperator, false);
        }
    }

    public void addFilePath(File file) {
        this.addPath(file.getAbsolutePath(), FileSeperator, file.isDirectory());
    }

    public void addArchiveList(Collection list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object entry = i.next();
            this.addArchivePath(entry.toString());
        }
    }

    public void addArchivePath(String archiveEntry) {
        this.addPath(archiveEntry, ArchSeperator, false);
    }

    private void _addPath(Enumeration e, boolean allowsChildren) {
        while (e.hasMoreElements()) {
            UISortedTreeNode node;
            String n = (String)e.nextElement();
            if (n.equals("")) continue;
            if (!this.getAllowsChildren()) {
                this.setAllowsChildren(true);
            }
            if ((node = (UISortedTreeNode)this.getNamedChild(n)) == null) {
                node = new UISortedTreeNode(n, e.hasMoreElements() || allowsChildren);
                this.add(node);
            }
            node._addPath(e, allowsChildren);
            break;
        }
    }

    protected static Comparator GetSortComparator() {
        if (nodeComparator == null) {
            nodeComparator = new SortedNodeComparator();
        }
        return nodeComparator;
    }

    protected static class SortedNodeComparator
    implements Comparator {
        protected SortedNodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            DefaultMutableTreeNode d1 = (DefaultMutableTreeNode)o1;
            DefaultMutableTreeNode d2 = (DefaultMutableTreeNode)o2;
            if (d1.getAllowsChildren() && !d2.getAllowsChildren()) {
                return -1;
            }
            if (!d1.getAllowsChildren() && d2.getAllowsChildren()) {
                return 1;
            }
            return d1.toString().toLowerCase().compareTo(d2.toString().toLowerCase());
        }

        public boolean equals(Object o) {
            return super.equals(o);
        }
    }

    private class ArrayEnumerator
    implements Enumeration {
        private Object[] array = null;
        private int index = 0;

        public ArrayEnumerator(Object[] array) {
            this.array = array;
            this.index = 0;
        }

        public boolean hasMoreElements() {
            return this.array != null && this.index < this.array.length;
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.array[this.index++];
        }
    }
}

