/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.WebArchivist;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleContent;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfigProperties;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTree;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JButton;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class UIProject {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIProject.class);
    private static String TREE_NAME = localStrings.getLocalString("ui.uiproject.update.tree_name", "Tree");
    private static String TREE_DESC = localStrings.getLocalString("ui.uiproject.update.tree_desc", "This is a tree view of the contents of the package");
    private static final String UPDATE_NONE = localStrings.getLocalString("ui.uiproject.update.none", "<none>");
    private static final String UPDATE_NOT_FOUND = localStrings.getLocalString("ui.uiproject.update.not_found", "The following entries were not found on disk:");
    private static final String UPDATE_COMPLETE = localStrings.getLocalString("ui.uiproject.update.complete", "Update complete.\n(Verify the deployment descriptors are valid, then save the object)");
    public static final char EDIT_SEARCH_PATHS_MNEMONIC = localStrings.getLocalString("ui.uiproject.update.edit_update_search_paths_mnemonic", "E").charAt(0);
    private static final char EDITPATHS_TABLE_MOVE_UP_MNEMONIC = localStrings.getLocalString("ui.uiproject.edit_paths.table.move_up_mnemonic", "U").charAt(0);
    private static final char EDITPATHS_TABLE_MOVE_DOWN_MNEMONIC = localStrings.getLocalString("ui.uiproject.edit_paths.table.move_down_mnemonic", "M").charAt(0);
    private static final char EDITPATHS_TABLE_BROWSE_MNEMONIC = localStrings.getLocalString("ui.uiproject.edit_paths.table.browse_mnemonic", "w").charAt(0);
    public static final String EDIT_SEARCH_PATHS = UIButton.setDefaultMnemonic(EDIT_SEARCH_PATHS_MNEMONIC, localStrings.getLocalString("ui.uiproject.update.edit_update_search_paths", "Edit Update Search Paths..."));
    public static final String CONFIG_PROJECT_ROOT = "project.root";
    public static final String CONFIG_SEARCHPATH = "project.path";
    private static final String ArchSeparator = "/";
    private static final char ArchSeparatorChar = '/';
    private static final String FileSeparator = File.separator;
    private static final char FileSeparatorChar = File.separatorChar;
    private static final boolean IsDosFileSeparator = FileSeparatorChar == '\\';
    private static String TEMP_PROJECT_SUBDIR = "project";
    private static String TEMP_APPLICATION_DIR = "J2EE_TempApplication";
    public static String PROJECT_FILENAME = "sun-j2ee-ri.project";
    private static String WEB_PROJECT = "WEB-INF/" + PROJECT_FILENAME;
    private static String META_PROJECT = "META-INF/" + PROJECT_FILENAME;
    private static String PROJECT_EXTN = ".project";
    private static String ENTRY_SEPARATOR = " : ";
    private static String DIR_LIB = "lib";
    private static String DIR_CLASSES = "classes";
    private static String DIR_TAGS = "tags";
    private static String DIR_WSDL = "wsdl";
    private static String META_INF = "META-INF";
    private static String META_INF_ = META_INF + "/";
    private static String META_INF_WSDL = META_INF_ + DIR_WSDL;
    private static String META_INF_WSDL_ = META_INF_WSDL + "/";
    private static String WEB_INF = "WEB-INF";
    private static String WEB_INF_ = WEB_INF + "/";
    private static String WEB_INF_LIB = WEB_INF_ + DIR_LIB;
    private static String WEB_INF_LIB_ = WEB_INF_LIB + "/";
    private static String WEB_INF_CLASSES = WEB_INF_ + DIR_CLASSES;
    private static String WEB_INF_CLASSES_ = WEB_INF_CLASSES + "/";
    private static String WEB_INF_TAGS = WEB_INF_ + DIR_TAGS;
    private static String WEB_INF_TAGS_ = WEB_INF_TAGS + "/";
    private static String WEB_INF_WSDL = WEB_INF_ + DIR_WSDL;
    private static String WEB_INF_WSDL_ = WEB_INF_WSDL + "/";
    private static final String XML_APP_CLIENT = "application-client.xml";
    private static final String XML_EJB_JAR = "ejb-jar.xml";
    private static final String XML_WEB = "web.xml";
    private static final String XML_JAXRPC = "jaxrpc-ri.xml";
    private static final String XML_RAR = "ra.xml";
    private static final String[] XML_FILES = new String[]{"application-client.xml", "ejb-jar.xml", "web.xml", "jaxrpc-ri.xml", "ra.xml"};
    private static final String S1XML_APPLICATION = "sun-application.xml";
    private static final String S1XML_CMP_MAPPING = "sun-cmp-mappings.xml";
    private static final String S1XML_APP_CLIENT = "sun-application-client.xml";
    private static final String S1XML_EJB_JAR = "sun-ejb-jar.xml";
    private static final String S1XML_WEB = "sun-web.xml";
    private static final String S1XML_RAR = "sun-ra.xml";
    private static final String[] S1XML_FILES = new String[]{"sun-application.xml", "sun-cmp-mappings.xml", "sun-application-client.xml", "sun-ejb-jar.xml", "sun-web.xml", "sun-ra.xml"};
    private boolean inclAppPath = false;
    private boolean findProjectOnDisk = false;
    private Descriptor descriptor = null;
    private boolean createdProjectFile = false;
    private Hashtable archivePropertiesHash = new Hashtable();
    private ProjectHashtable updateFilesHash = null;
    private ProjectHashtable archiveFilesHash = null;
    private static WeakHashMap projectHash = new WeakHashMap();
    private static int addArchiveEntries_recurse = 0;
    private static String[] jars = new String[]{".jar", ".war", ".rar", ".ear"};
    private static boolean SAVE_PROJECT_FILE = true;
    private static String WILDCARD = "*";
    private static final String PREUPDATE_CHANGED_TITLE = localStrings.getLocalString("ui.uiproject.pre_update.changed_title", "The following entries have changed:");
    private static final String PREUPDATE_NOTFOUND_TITLE = localStrings.getLocalString("ui.uiproject.pre_update.notfound_title", "The following entries were not found on disk:");
    private static final String PREUPDATE_CONTINUE = localStrings.getLocalString("ui.uiproject.pre_update.continue", "Click 'Ok' to update changed files, otherwise 'Cancel' to return without updating.");
    private static final String PREUPDATE_CANCEL = localStrings.getLocalString("ui.uiproject.pre_update.return", "Nothing to update, click 'Cancel' to return.");
    private PreUpdateDialog preUpdateDialog = null;
    private static final String EDITPATHS_ROOT = localStrings.getLocalString("ui.uiproject.edit_paths.search_root", "Search Root");
    private static final String EDITPATHS_TABLE_TITLE = localStrings.getLocalString("ui.uiproject.edit_paths.table.title", "Search Paths");
    private static final String EDITPATHS_PATH_DIRECTORY = localStrings.getLocalString("ui.uiproject.edit_paths.table.column_title", "Path Directory");
    private static final String EDITPATHS_TABLE_MOVE_UP = localStrings.getLocalString("ui.uiproject.edit_paths.table.move_up", "Move Up");
    private static final String EDITPATHS_TABLE_MOVE_DOWN = localStrings.getLocalString("ui.uiproject.edit_paths.table.move_down", "Move Down");
    private static final String EDITPATHS_TABLE_BROWSE = localStrings.getLocalString("ui.uiproject.edit_paths.table.browse", "Browse...");
    private static final String EDITPATHS_TABLE_UNUSED_PATHS = "Unused Paths";
    private static final String EDITPATHS_BROWSE_DIR = localStrings.getLocalString("ui.uiproject.edit_paths.table.browse_dir", "Select a directory");
    private static SearchPathEditor globalPathEditor = null;
    private static final String ENTRY = ".entry";
    private static final String ORIGIN = ".origin";

    private static String NO_PROJECT_FOUND(String v0) {
        return localStrings.getLocalString("ui.uiproject.update.no_project_found", "No project found for descriptor ''{0}''.", new Object[]{v0});
    }

    private static String UPDATE_MESSAGE(String v0) {
        return localStrings.getLocalString("ui.uiproject.update.changed_list", "The following entries in ''{0}'' have changed:", new Object[]{v0});
    }

    private static String ALL_UP_TO_DATE(String v0) {
        return localStrings.getLocalString("ui.uiproject.update.all_up_to_date", "All entries are up to date for ''{0}''", new Object[]{v0});
    }

    private static String NormalizeKey(String key) {
        if (key.startsWith(WEB_INF_)) {
            if (key.startsWith(WEB_INF_CLASSES_)) {
                return key.substring(WEB_INF_CLASSES_.length());
            }
            if (key.startsWith(WEB_INF_LIB_)) {
                return key.substring(WEB_INF_LIB_.length());
            }
            if (key.startsWith(WEB_INF_TAGS_)) {
                return key.substring(WEB_INF_TAGS_.length());
            }
            if (key.startsWith(WEB_INF_WSDL_)) {
                return key.substring(WEB_INF_WSDL_.length());
            }
            return key.substring(WEB_INF_.length());
        }
        if (key.startsWith(META_INF_)) {
            if (key.startsWith(META_INF_WSDL_)) {
                return key.substring(META_INF_WSDL_.length());
            }
            return key.substring(META_INF_.length());
        }
        return key;
    }

    private static String GetPathKey(Descriptor d) {
        String key = null;
        if (d instanceof WebBundleDescriptor) {
            key = "ui.update.searchPath.war";
        } else if (d instanceof EjbBundleDescriptor) {
            key = "ui.update.searchPath.ejb";
        } else if (d instanceof ConnectorDescriptor) {
            key = "ui.update.searchPath.rar";
        } else if (d instanceof ApplicationClientDescriptor) {
            key = "ui.update.searchPath.appClient";
        } else if (d instanceof Application) {
            key = "ui.update.searchPath.app";
        } else {
            key = "ui.update.searchPath.default";
            Print.dprintln((String)("Unsupported Descriptor = " + DT.className(d)));
        }
        return key;
    }

    private static Object ProjectPropertyKey(Descriptor k) {
        return UIProject.ProjectDescriptor(k);
    }

    private static Object ProjectArchiveKey(Descriptor k) {
        return ModuleArchive.getModuleArchive(k);
    }

    private static Object ProjectKey(Descriptor k) {
        String uri = ModuleArchive.getArchiveUri(k);
        return uri == null || uri.equals("") ? "*NEW*" : uri;
    }

    private static String ProjectKeyString(Descriptor k) {
        Object key = UIProject.ProjectKey(k);
        if (key instanceof String) {
            return (String)key;
        }
        if (key instanceof Descriptor) {
            return ((Descriptor)key).getDisplayName();
        }
        if (key instanceof ModuleArchive) {
            String uri = ((ModuleArchive)key).getArchiveUri();
            return uri == null || uri.equals("") ? "*blank*" : uri;
        }
        return key.toString();
    }

    private static Descriptor ProjectDescriptor(Descriptor k) {
        if (k instanceof Application) {
            return k;
        }
        if (k instanceof BundleDescriptor) {
            return k;
        }
        return null;
    }

    public static UIProject copyProject(UIProject p) {
        return (UIProject)p.clone();
    }

    public static UIProject newProject(Descriptor desc) {
        return new UIProject(desc);
    }

    public static boolean addProject(UIProject prj) {
        if (prj.isValid()) {
            projectHash.put(UIProject.ProjectArchiveKey(prj.getDescriptor()), prj);
            return true;
        }
        Print.dprintln((String)"Invalid project");
        return false;
    }

    public static UIProject getProject(Descriptor desc) {
        return UIProject.getProject(desc, true);
    }

    public static UIProject getProject(Descriptor desc, boolean createNew) {
        Descriptor d = UIProject.getArchiveDescriptor(desc);
        if (d == null) {
            return null;
        }
        UIProject prj = (UIProject)projectHash.get(UIProject.ProjectArchiveKey(d));
        if (prj == null && createNew) {
            UIProject p = UIProject.newProject(d);
            if (p.isValid()) {
                UIProject.addProject(p);
                prj = p;
            } else {
                Print.dprintln((String)("No project for " + desc.getDisplayName()));
            }
        }
        return prj;
    }

    public static void resetProject(Descriptor d) {
        UIProject prj = UIProject.getProject(d);
        if (prj != null) {
            prj.resetArchiveContent();
        }
    }

    public static void removeProject(UIProject proj) {
        UIProject.removeProject(proj.getDescriptor());
    }

    public static void removeProject(Descriptor desc) {
        Descriptor d = UIProject.getArchiveDescriptor(desc);
        if (d != null) {
            projectHash.remove(UIProject.ProjectArchiveKey(d));
            UIProject.DeleteTempArchiveDir(d);
        }
    }

    public static boolean saveArchiveProject(Descriptor desc) {
        UIProject prj = UIProject.getProject(desc);
        return prj != null ? prj.saveProjectConfig(desc, true) : false;
    }

    public static ArchiveHashtable getProjectFileEntry(Descriptor d) {
        UIProject prj = UIProject.getProject(d);
        return prj != null ? prj.getArchiveProjectEntry(d) : null;
    }

    public static File getArchiveRoot(Descriptor desc) {
        UIProject prj = UIProject.getProject(desc);
        return prj != null ? prj.getConfigRoot(desc) : null;
    }

    public static File[] getArchivePaths(Descriptor desc) {
        UIProject prj = UIProject.getProject(desc);
        return prj != null ? prj.getAbsolutePaths(desc) : null;
    }

    public static File[] getAllArchivePaths(Descriptor desc) {
        UIProject prj = UIProject.getProject(desc, false);
        if (prj == null) {
            return null;
        }
        if (prj.getDescriptor() instanceof Application) {
            Vector fullPath = new Vector();
            prj._getAbsolutePaths(prj.getDescriptor(), true, fullPath);
            Set allDesc = prj.getArchiveDescriptors();
            Iterator i = allDesc.iterator();
            while (i.hasNext()) {
                Descriptor d = (Descriptor)i.next();
                prj._getAbsolutePaths(d, true, fullPath);
            }
            return fullPath.toArray(new File[fullPath.size()]);
        }
        return prj.getAbsolutePaths(desc, true);
    }

    public static void addArchivePath(Descriptor desc, File path) {
        UIProject prj = UIProject.getProject(desc);
        if (prj != null) {
            prj.addConfigPath(desc, path.getAbsoluteFile());
            prj.saveProjectConfig(desc, true);
        }
    }

    public static void addArchivePaths(Descriptor desc, File[] paths) {
        UIProject prj;
        if (paths != null && paths.length > 0 && (prj = UIProject.getProject(desc)) != null) {
            for (int i = 0; i < paths.length; ++i) {
                prj.addConfigPath(desc, paths[i].getAbsoluteFile());
            }
            prj.saveProjectConfig(desc, true);
        }
    }

    public static void addArchivePaths(Descriptor desc, ModuleContent fcd) {
        UIProject prj = UIProject.getProject(desc);
        if (prj != null) {
            Iterator dirs = fcd.getDirectories();
            while (dirs.hasNext()) {
                File dir = (File)dirs.next();
                prj.addConfigPath(desc, dir.getAbsoluteFile());
            }
            prj.saveProjectConfig(desc, true);
        }
    }

    public static void addArchiveEntry(Descriptor desc, String entryName, File entryFile) {
        if (entryName != null) {
            ArchiveHashtable hash = new ArchiveHashtable();
            hash.putEntry(entryName, entryFile);
            UIProject.addArchiveEntries(desc, hash);
        }
    }

    public static void addArchiveEntries(Descriptor desc, Map ht) {
        if (addArchiveEntries_recurse == 0 && ht != null && ht.size() > 0) {
            ++addArchiveEntries_recurse;
            UIProject prj = UIProject.getProject(desc);
            if (prj != null) {
                ArchiveHashtable aht = ht instanceof ArchiveHashtable ? (ArchiveHashtable)ht : new ArchiveHashtable(ht);
                Iterator i = aht.keySet().iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    if (key.endsWith(PROJECT_FILENAME)) continue;
                    String fKey = UIProject.ToFileSep(UIProject.NormalizeKey(key));
                    File file = (File)aht.get(key);
                    String fileStr = file.toString();
                    if (UIProject.StrFileEndsWith(fileStr, fKey)) {
                        String dirStr = fileStr.substring(0, fileStr.length() - fKey.length());
                        if (dirStr.endsWith(FileSeparator)) {
                            dirStr = dirStr.substring(0, dirStr.length() - 1);
                        }
                        File dir = new File(dirStr);
                        prj.addConfigPath(desc, dir.getAbsoluteFile());
                        continue;
                    }
                    prj.addConfigPath(desc, file.getParentFile());
                }
                prj.saveProjectConfig(desc, true);
                ProjectHashtable pht = prj.getArchiveContent(desc, false);
                if (pht != null) {
                    pht.setNeedsUpdate(true);
                }
            }
            --addArchiveEntries_recurse;
        }
    }

    public static void removeArchiveEntry(Descriptor desc, String entryName) {
        if (entryName != null) {
            Vector<String> v = new Vector<String>();
            v.add(entryName);
            UIProject.removeArchiveEntries(desc, v);
        }
    }

    public static void removeArchiveEntries(Descriptor desc, List entries) {
        ProjectHashtable pht;
        UIProject prj;
        if (entries != null && entries.size() > 0 && (prj = UIProject.getProject(desc)) != null && (pht = prj.getArchiveContent(desc, false)) != null) {
            pht.setNeedsUpdate(true);
        }
    }

    private UIProject() {
        this.inclAppPath = false;
    }

    private UIProject(Descriptor desc) {
        this.setDescriptor(desc);
    }

    private UIProject(UIProject p) {
        this.inclAppPath = p.inclAppPath;
        this.findProjectOnDisk = p.findProjectOnDisk;
        this.descriptor = p.descriptor;
        this.createdProjectFile = p.createdProjectFile;
        this.archivePropertiesHash.putAll(p.archivePropertiesHash);
        this.updateFilesHash = p.updateFilesHash;
        this.archiveFilesHash = p.archiveFilesHash;
    }

    protected Object clone() {
        return new UIProject(this);
    }

    public boolean isValid() {
        return this.descriptor != null;
    }

    private static Descriptor getArchiveDescriptor(Descriptor d) {
        return DescriptorTools.getModuleDescriptor(d);
    }

    private void setDescriptor(Descriptor desc) {
        Descriptor d = UIProject.getArchiveDescriptor(desc);
        if (d instanceof Application) {
            Application app = (Application)d;
            this.descriptor = app;
            UIProject.DeleteTempArchiveDir(this.descriptor);
        } else if (d instanceof BundleDescriptor) {
            BundleDescriptor bd = (BundleDescriptor)d;
            this.descriptor = bd;
            UIProject.DeleteTempArchiveDir(this.descriptor);
        } else {
            this.descriptor = null;
            Print.dprintStackTrace((String)("Descriptor not supported: " + DT.className(desc)));
        }
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public File getArchiveFile() {
        return ModuleArchive.getArchiveFile(this.descriptor);
    }

    public Set getArchiveDescriptors() {
        Descriptor d = this.getDescriptor();
        if (d instanceof Application) {
            return ((Application)d).getArchivableDescriptors();
        }
        if (d instanceof BundleDescriptor) {
            HashSet<Descriptor> hs = new HashSet<Descriptor>();
            hs.add(d);
            return hs;
        }
        return null;
    }

    protected ProjectHashtable getArchiveFilesHash(boolean refresh) {
        try {
            if (refresh) {
                if (this.archiveFilesHash == null) {
                    this.archiveFilesHash = new ProjectHashtable();
                }
                this.traverseArchive(false, this.archiveFilesHash);
            }
            return this.archiveFilesHash;
        }
        catch (Throwable t) {
            Print.printStackTrace((String)"Error", (Throwable)t);
            this.archiveFilesHash = null;
            return null;
        }
    }

    public void resetArchiveContent() {
        this.archiveFilesHash = null;
    }

    public ProjectHashtable getArchiveContent(Descriptor desc) {
        return this.getArchiveContent(desc, true);
    }

    public ProjectHashtable getArchiveContent(Descriptor obj, boolean refresh) {
        if (!this.isValid()) {
            Print.dprintStackTrace((String)"Project not valid");
            return null;
        }
        Descriptor desc = UIProject.ProjectDescriptor(obj);
        try {
            ProjectHashtable afh = this.getArchiveFilesHash(refresh);
            if (afh == null) {
                return null;
            }
            if (afh.isEmpty()) {
                return null;
            }
            if (desc == null || desc == this.getDescriptor()) {
                return afh;
            }
            Object key = UIProject.ProjectKey(desc);
            ArchiveEntry ae = (ArchiveEntry)afh.get(key);
            if (ae == null) {
                if (refresh) {
                    String keyName = UIProject.ProjectKeyString(desc);
                    if (keyName.equals("*NEW*")) {
                        Print.dprintln((String)("ArchiveEntry not found: '" + keyName + "'"));
                    } else {
                        Print.dprintStackTrace((String)("ArchiveEntry not found: '" + keyName + "'\n" + "  Project descriptor=" + DT.className(this.getDescriptor()) + ", displayName=" + this.getDescriptor().getDisplayName() + ", key=" + UIProject.ProjectKey(this.getDescriptor()) + "\n" + "  Target  descriptor=" + DT.className(desc) + ", displayName=" + desc.getDisplayName() + ", key=" + UIProject.ProjectKey(desc) + "\n" + "  (ProjDesc == TarDesc)?" + (desc == this.getDescriptor())));
                        UIProject.printMap(afh, null);
                    }
                }
                return null;
            }
            return ae.getArchiveHash();
        }
        catch (Throwable t) {
            Print.printStackTrace((String)"Error", (Throwable)t);
            return null;
        }
    }

    public ArchiveHashtable getArchiveEntry(Descriptor d, String entry) {
        Object value;
        ProjectHashtable h = this.getArchiveContent(d);
        Object v0 = value = h != null ? h.get(entry) : null;
        if (value instanceof FileEntry) {
            ArchiveHashtable item = new ArchiveHashtable();
            File file = ((FileEntry)value).getDiskFile();
            item.putEntry(entry, file);
            return item;
        }
        return null;
    }

    public File getArchiveEntryFile(Descriptor d, String entry) {
        ProjectHashtable h = this.getArchiveContent(d);
        Object value = h != null ? h.get(entry) : null;
        return value instanceof FileEntry ? ((FileEntry)value).getDiskFile() : null;
    }

    public ArchiveHashtable getArchiveProjectEntry(Descriptor d) {
        File f;
        String entry = UIProject.getProjectEntryName(d);
        ArchiveHashtable ht = this.getArchiveEntry(d, entry);
        if (ht != null && !(f = (File)ht.get(entry)).exists()) {
            Print.dprintln((String)("Project file !exists: " + entry + " ==> " + f));
            return null;
        }
        return ht;
    }

    public void addArchiveHash(UIProject subProj) {
        Descriptor d = subProj.getDescriptor();
        if (d instanceof BundleDescriptor && this.getDescriptor() instanceof Application) {
            this.addArchiveHash(d, subProj.getArchiveContent(null));
            UIProject.removeProject(subProj);
        } else {
            Print.printStackTrace((String)"Can only add a 'BundleDescriptor' to an 'Application'");
        }
    }

    public void addArchiveHash(Descriptor d, ProjectHashtable contents) {
        if (d instanceof BundleDescriptor && this.getDescriptor() instanceof Application) {
            ModuleArchive arch = ModuleArchive.getModuleArchive(d);
            String descName = UIProject.getArchiveName(d);
            ArchiveEntry ae = new ArchiveEntry(arch, d.getDisplayName(), contents);
            this.getArchiveContent(null).putEntry(UIProject.ProjectKey(d), ae);
        } else {
            Print.printStackTrace((String)"Can only add a 'BundleDescriptor' to an 'Application'");
        }
    }

    private ProjectHashtable getUpdateArchiveEntries(boolean reset) throws Exception {
        if (reset || this.updateFilesHash == null) {
            ProjectHashtable h = new ProjectHashtable();
            this.updateFilesHash = this.traverseArchive(true, h) ? h : null;
            return h;
        }
        return this.updateFilesHash;
    }

    protected boolean traverseArchive(boolean useArchiveFile, ProjectHashtable archiveHash) throws Exception {
        if (this.isValid()) {
            boolean foundAllEntries = true;
            SearchPath sp = new SearchPath(null, this.descriptor);
            if (useArchiveFile) {
                ZipInputStream zs = new ZipInputStream(new FileInputStream(this.getArchiveFile()));
                foundAllEntries &= this.scanJar(null, sp, zs, archiveHash);
                zs.close();
            } else {
                ModuleArchive arch = ModuleArchive.getModuleArchive(this.descriptor);
                foundAllEntries &= this.scanJar(null, sp, arch, archiveHash);
            }
            return foundAllEntries;
        }
        return false;
    }

    private boolean scanJar(ArchiveEntry archEntry, SearchPath searchPath, Object source, ProjectHashtable updateMap) throws Exception {
        boolean foundAllEntries = true;
        ZipInputStream zis = null;
        Enumeration entryEnum = null;
        if (source instanceof ZipInputStream) {
            zis = (ZipInputStream)source;
            entryEnum = null;
        } else if (source instanceof ModuleArchive) {
            zis = null;
            ModuleArchive modArch = (ModuleArchive)source;
            Descriptor d = modArch.getDescriptor();
            if (d instanceof Application) {
                Application app = (Application)d;
                List names = ModuleArchive.getModuleArchive((Descriptor)app).getEntryNames();
                Set bdList = app.getArchivableDescriptors();
                Iterator i = bdList.iterator();
                while (i.hasNext()) {
                    ModuleArchive bdArch = ModuleArchive.getModuleArchive((Descriptor)i.next());
                    if (bdArch == null) continue;
                    String n = bdArch.getArchiveUri();
                    names.remove(n);
                    names.add(0, bdArch);
                }
                entryEnum = ListTools.toEnumeration(names);
            } else {
                entryEnum = ListTools.toEnumeration(((ModuleArchive)source).getEntryNames());
            }
        }
        if (updateMap.needsUpdate()) {
            updateMap.clear();
        }
        while (true) {
            String entryName;
            long entryTime = 0L;
            String entryObject = null;
            if (zis != null) {
                ZipEntry entry = zis.getNextEntry();
                if (entry == null) break;
                entryObject = entry.getName();
                entryTime = entry.getTime();
            } else {
                if (!entryEnum.hasMoreElements()) break;
                entryObject = (String)entryEnum.nextElement();
            }
            if (entryObject instanceof String && UIProject.SkipJarEntry(entryObject)) continue;
            ModuleArchive arch = archEntry == null ? this.findNamedModuleArchive(entryObject) : null;
            String string = entryName = entryObject instanceof String ? entryObject : arch.getArchiveUri();
            if (arch != null) {
                Object archKey = UIProject.ProjectKey(arch.getDescriptor());
                ArchiveEntry oldArchEntry = (ArchiveEntry)updateMap.get(archKey);
                if (oldArchEntry != null && !oldArchEntry.getArchiveHash().needsUpdate()) continue;
                ProjectHashtable entryHash = null;
                ArchiveEntry newArchEntry = null;
                if (oldArchEntry != null) {
                    entryHash = oldArchEntry.getArchiveHash();
                    newArchEntry = oldArchEntry;
                } else {
                    entryHash = new ProjectHashtable();
                    newArchEntry = new ArchiveEntry(arch, entryName, entryHash);
                    updateMap.putEntry(archKey, newArchEntry);
                }
                SearchPath sp = new SearchPath(this.inclAppPath ? searchPath : null, arch.getDescriptor());
                if (zis != null) {
                    ZipInputStream zs = new ZipInputStream(zis);
                    foundAllEntries &= this.scanJar(newArchEntry, sp, zs, entryHash);
                    continue;
                }
                foundAllEntries &= this.scanJar(newArchEntry, sp, arch, entryHash);
                continue;
            }
            if (!updateMap.needsUpdate()) continue;
            if (UIProject.isJar(entryName)) {
                // empty if block
            }
            FileEntry fileEntry = null;
            File file = searchPath.findFile(entryName);
            if (file != null && file.isFile()) {
                boolean upd = entryTime > 0L && file.lastModified() > entryTime;
                fileEntry = new FileEntry(archEntry, entryName, file, upd);
            } else {
                foundAllEntries = false;
                fileEntry = new FileEntry(archEntry, entryName, null, false);
            }
            updateMap.putEntry(entryName, fileEntry);
        }
        updateMap.setNeedsUpdate(false);
        return foundAllEntries;
    }

    public boolean updateArchiveFiles(boolean interactive) throws Exception {
        if (!this.showPreUpdate(interactive)) {
            return false;
        }
        ProjectHashtable archList = this.getUpdateArchiveEntries(false);
        if (!interactive) {
            Enumeration e;
            String descName = UIProject.getArchiveName(this.descriptor);
            Vector needsUpd = new Vector();
            Vector foundOk = new Vector();
            Vector notFound = new Vector();
            this._parseFileTypes(archList, needsUpd, foundOk, notFound, true);
            StringBuffer sb = new StringBuffer(UIProject.UPDATE_MESSAGE(descName));
            if (needsUpd.size() > 0) {
                e = needsUpd.elements();
                while (e.hasMoreElements()) {
                    sb.append("\n   ").append((String)e.nextElement());
                }
            } else {
                sb.append("\n    ").append(UPDATE_NONE);
            }
            if (notFound.size() > 0) {
                sb.append("\n");
                sb.append(UPDATE_NOT_FOUND);
                e = notFound.elements();
                while (e.hasMoreElements()) {
                    sb.append("\n   ").append((String)e.nextElement());
                }
            }
            Print.println((String)sb.toString());
        }
        this.performUpdate(this.getDescriptor(), archList);
        Print.println((String)UPDATE_COMPLETE);
        return true;
    }

    private void _parseFileTypes(ProjectHashtable h, Object nu, Object ok, Object nf, boolean sort) throws Exception {
        Enumeration keys = h.keys();
        while (keys.hasMoreElements()) {
            Object e = keys.nextElement();
            Object v = h.get(e);
            if (v instanceof FileEntry) {
                FileEntry ev = (FileEntry)v;
                this._addParsedEntry(ev.exists() ? (ev.needsUpdate() ? nu : ok) : nf, ev);
                continue;
            }
            if (v instanceof ArchiveEntry) {
                ArchiveEntry ae = (ArchiveEntry)v;
                this._parseFileTypes(ae.getArchiveHash(), nu, ok, nf, false);
                continue;
            }
            Print.printStackTrace((String)("Unknown type: " + DT.className(e)));
        }
        if (sort) {
            this._sortParsedFiles(nu);
            this._sortParsedFiles(ok);
            this._sortParsedFiles(nf);
        }
    }

    private void _addParsedEntry(Object list, FileEntry fe) {
        if (list instanceof List) {
            ((List)list).add(fe.getAbsEntryName());
        } else if (list instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode topRoot = (DefaultMutableTreeNode)list;
            ArchiveEntry archEntry = fe.getArchiveEntry();
            if (archEntry != null) {
                DefaultMutableTreeNode archRoot = UITitledTree.getNodeForUserObject(topRoot, archEntry);
                if (archRoot == null) {
                    archRoot = new ArchiveEntryTreeNode(archEntry);
                    topRoot.add(archRoot);
                }
                archRoot.add(new FileEntryTreeNode(fe));
            } else {
                topRoot.add(new FileEntryTreeNode(fe));
            }
        }
    }

    private void _sortParsedFiles(Object c) {
        if (c instanceof List) {
            ListTools.sortList((List)c, true);
        } else if (c instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)c;
            Vector<TreeNode> v = new Vector<TreeNode>();
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                v.add(e.nextElement());
            }
            node.removeAllChildren();
            ListTools.sortList(v, true);
            e = v.elements();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode mtn = (DefaultMutableTreeNode)e.nextElement();
                if (mtn.getChildCount() > 0) {
                    this._sortParsedFiles(mtn);
                }
                node.add(mtn);
            }
        }
    }

    private void performUpdate(Descriptor desc, ProjectHashtable filesHash) throws Exception {
        ModuleArchive arch;
        ArchiveHashtable updEntries = new ArchiveHashtable();
        Iterator keys = filesHash.keySet().iterator();
        while (keys.hasNext()) {
            Object e = keys.next();
            Object v = filesHash.get(e);
            if (v instanceof FileEntry) {
                FileEntry ev = (FileEntry)v;
                if (!ev.needsUpdate()) continue;
                updEntries.putEntry(ev.getEntryName(), ev.getDiskFile());
                continue;
            }
            if (!(v instanceof ArchiveEntry)) continue;
            ArchiveEntry ae = (ArchiveEntry)v;
            this.performUpdate(ae.getDescriptor(), ae.getArchiveHash());
        }
        if (updEntries.size() > 0 && (arch = ModuleArchive.getModuleArchive(desc)) != null) {
            Print.dprintln((String)("Updating archive: " + arch.getArchiveUri()));
            arch.addArchiveEntries(updEntries);
        }
    }

    private static File MakeFile(File root, String file) {
        if (file == null) {
            return root;
        }
        if ((file = file.trim()).equals("") || file.equals(".")) {
            return root;
        }
        String rfile = UIProject.ToFileSep(file);
        File af = new File(rfile);
        if (af.isAbsolute()) {
            return af;
        }
        return root != null ? new File(root, rfile) : null;
    }

    private ModuleArchive findNamedModuleArchive(Object entry) {
        if (entry == null) {
            return ModuleArchive.getModuleArchive(this.descriptor);
        }
        if (entry instanceof ModuleArchive) {
            return (ModuleArchive)entry;
        }
        Iterator it = this.getArchiveDescriptors().iterator();
        while (it.hasNext()) {
            ModuleArchive modArch = ModuleArchive.getModuleArchive((Descriptor)it.next());
            if (modArch == null || !entry.equals(modArch.getArchiveUri())) continue;
            return modArch;
        }
        return null;
    }

    private static String getArchiveName(Descriptor d) {
        int p;
        String uri = ModuleArchive.getArchiveUri(d);
        if (uri != null && !uri.equals("") && (p = uri.lastIndexOf(FileSeparator)) >= 0) {
            uri = uri.substring(p + 1);
        }
        return uri;
    }

    private static File getArchiveFile(Descriptor d) {
        return ModuleArchive.getArchiveFile(d);
    }

    public static boolean isJar(String name) {
        boolean isJar = false;
        String n = name.toLowerCase();
        for (int i = 0; i < jars.length; ++i) {
            if (!n.endsWith(jars[i])) continue;
            isJar = true;
            break;
        }
        return isJar;
    }

    public static String getProjectEntryName(Object d) {
        if (d instanceof WebBundleDescriptor || d instanceof WebArchivist) {
            return WEB_PROJECT;
        }
        return META_PROJECT;
    }

    private static String DelExtn(String name) {
        if (name != null) {
            int p = name.lastIndexOf(".");
            return p > 0 ? name.substring(0, p) : name;
        }
        return "";
    }

    private static File TempDirectory() {
        File tmpDir = new File(UIConfig.getTempDirectory(), TEMP_PROJECT_SUBDIR);
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
            FileUtil.deleteOnExit((File)tmpDir, (boolean)true);
        }
        return tmpDir;
    }

    private static boolean DeleteTempArchiveDir(Descriptor d) {
        File dir = UIProject.TempArchiveDir(d);
        try {
            boolean deleted = true;
            if (dir.exists()) {
                if (!FileUtil.deleteDirContents((File)dir)) {
                    Print.dprintln((String)("Some contents could not be deleted from directory: " + dir));
                }
                if (!dir.delete()) {
                    deleted = false;
                    Print.dprintln((String)("Temp Archive Dir could not deleted: " + dir));
                }
            }
            return deleted;
        }
        catch (Throwable t) {
            Print.dprintln((String)("Temp Archive Dir name may not have been deleted: " + dir));
            return false;
        }
    }

    private static File TempArchiveDir(Descriptor d) {
        File dir;
        String dirName = TEMP_APPLICATION_DIR;
        if (d != null) {
            String archUri = UIProject.DelExtn(ModuleArchive.getArchiveUri(d));
            if (!archUri.equals("")) {
                dirName = archUri.replace(File.separatorChar, '.').replaceFirst(":", "");
            } else {
                String name = d.getDisplayName();
                if (!name.equals("")) {
                    dirName = name;
                }
            }
        }
        if (DescriptorTools.isModuleDescriptor(d)) {
            dir = new File(UIProject.TempDirectory(), dirName);
            if (!dir.exists()) {
                dir.mkdirs();
                FileUtil.deleteOnExit((File)dir, (boolean)true);
            }
            return dir;
        }
        if (d instanceof BundleDescriptor) {
            File appDir = UIProject.TempArchiveDir((Descriptor)((BundleDescriptor)d).getApplication());
            File dir2 = new File(appDir, dirName);
            if (!dir2.exists()) {
                dir2.mkdirs();
                FileUtil.deleteOnExit((File)dir2, (boolean)true);
            }
            return dir2;
        }
        Print.dprintln((String)("Unsupported descriptor: " + DT.className(d)));
        dir = new File(UIProject.TempDirectory(), dirName);
        if (!dir.exists()) {
            dir.mkdirs();
            FileUtil.deleteOnExit((File)dir, (boolean)true);
        }
        return dir;
    }

    private static File TempProjectFile(Descriptor d, boolean deleteIfExists) {
        return UIProject.createTempFilename(d, UIProject.getProjectEntryName(d), deleteIfExists);
    }

    public static File createTempFilename(Descriptor d, String fileName, boolean deleteIfExists) {
        File parent;
        File file;
        File tmpDir = UIProject.TempArchiveDir(d);
        if (!deleteIfExists && tmpDir.getName().equals(TEMP_APPLICATION_DIR)) {
            deleteIfExists = true;
        }
        if ((file = new File(tmpDir, UIProject.ToFileSep(fileName))).isDirectory()) {
            Print.printStackTrace((String)("Temp file is a directory!: " + file));
            String name = file.getName();
            while (file.isDirectory()) {
                file = new File(file, name);
            }
            Print.println((String)("Converted to " + file));
        }
        if (!(parent = file.getParentFile()).exists()) {
            parent.mkdirs();
            FileUtil.deleteOnExit((File)parent, (boolean)true);
        }
        if (deleteIfExists && file.exists()) {
            file.delete();
            if (file.exists()) {
                Print.dprintln((String)("Temp file may not have been deleted: " + file));
            }
        }
        FileUtil.deleteOnExit((File)file, (boolean)true);
        return file;
    }

    public static File getJarFile(Descriptor desc) {
        return UIProject.getJarFile(desc, false);
    }

    public static File getJarFile(Descriptor desc, boolean expand) {
        File jfile = null;
        if (desc == null) {
            Print.printStackTrace((String)"Descriptor is null");
        } else if (DescriptorTools.isModuleDescriptor(desc)) {
            jfile = ModuleArchive.getArchiveFile(desc);
        } else if (desc instanceof BundleDescriptor) {
            BundleDescriptor bd = (BundleDescriptor)desc;
            Application app = bd.getApplication();
            ModuleArchive appModArch = ModuleArchive.getModuleArchive((Descriptor)app);
            if (appModArch != null) {
                File appArchFile = appModArch.getArchiveFile();
                long jarModTime = appArchFile != null ? appArchFile.lastModified() : -1L;
                String archiveName = UIProject.getArchiveName((Descriptor)bd);
                if (!archiveName.equals("")) {
                    File tmpJar = new File(UIProject.TempArchiveDir((Descriptor)app), archiveName);
                    if (!tmpJar.exists() || jarModTime > tmpJar.lastModified()) {
                        try {
                            appModArch.extractEntryToFile(bd, tmpJar);
                            tmpJar.setLastModified(jarModTime);
                            FileUtil.deleteOnExit((File)tmpJar, (boolean)true);
                            jfile = tmpJar;
                        }
                        catch (Throwable t) {
                            Print.dprintStackTrace((String)("Error extracting archive: " + archiveName + " => " + t));
                        }
                    } else {
                        jfile = tmpJar;
                    }
                } else {
                    Print.dprintStackTrace((String)("No archiveName for Bundle: " + bd.getDisplayName()));
                }
            } else {
                Print.dprintStackTrace((String)("Application doesn't have an Archivist: " + app.getDisplayName()));
            }
        } else {
            Print.printStackTrace((String)("Invalid descriptor: " + DT.className(desc)));
        }
        if (jfile == null || !jfile.exists()) {
            return null;
        }
        if (!expand) {
            return jfile;
        }
        String archiveName = UIProject.getArchiveName(desc);
        File expandedJarDir = new File(UIProject.TempArchiveDir(desc), "expand");
        Print.dprintln((String)("Expanding Jar: " + jfile + " to dir " + expandedJarDir));
        FileUtil.deleteOnExit((File)expandedJarDir, (boolean)true);
        try {
            JarFile jar = new JarFile(jfile);
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryFilename = UIProject.ToFileSep(entry.getName());
                File file = new File(expandedJarDir, entryFilename);
                FileUtil.deleteOnExit((File)file, (boolean)true);
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                if (file.exists() && jfile.lastModified() <= file.lastModified()) continue;
                File parent = file.getParentFile();
                if (parent.exists() || parent.mkdirs()) {
                    InputStream in = jar.getInputStream(new ZipEntry(entry));
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                    UIProject._copyStreams(in, out);
                    in.close();
                    out.close();
                    continue;
                }
                Print.dprintln((String)("Unable to make parent dir: " + parent));
            }
            expandedJarDir.setLastModified(jfile.lastModified());
            return expandedJarDir;
        }
        catch (IOException ioe) {
            Print.dprintln((String)("Error expanding jarfile: " + jfile + " => " + ioe));
            return jfile;
        }
    }

    private static void _copyStreams(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[1024];
        int len = 0;
        while (len != -1) {
            try {
                len = is.read(buf, 0, buf.length);
            }
            catch (EOFException eof) {
                break;
            }
            if (len == -1) continue;
            os.write(buf, 0, len);
        }
    }

    private static boolean SkipJarEntry(String n) {
        int x;
        if (n.endsWith(ArchSeparator)) {
            return true;
        }
        if (n.equals(WEB_PROJECT) || n.equals(META_PROJECT)) {
            return true;
        }
        if (n.startsWith(META_INF_) && !n.startsWith(META_INF_WSDL_)) {
            return true;
        }
        for (x = 0; x < XML_FILES.length; ++x) {
            if (!n.endsWith(ArchSeparator + XML_FILES[x])) continue;
            return true;
        }
        for (x = 0; x < S1XML_FILES.length; ++x) {
            if (!n.endsWith(ArchSeparator + S1XML_FILES[x])) continue;
            return true;
        }
        return false;
    }

    public boolean getConfigBoolean(Descriptor d, String key, boolean dftVal) {
        UIConfigProperties p = this.getProjectConfig(d);
        return p.getPropertyBoolean(key, dftVal);
    }

    public File getConfigRoot(Descriptor d) {
        UIConfigProperties p;
        String r;
        File root = null;
        if (d == null) {
            d = this.descriptor;
        }
        if ((r = (p = this.getProjectConfig(d)).getProperty(CONFIG_PROJECT_ROOT, null)) != null && !r.equals("")) {
            root = new File(r);
        }
        if (root == null) {
            root = this.findArchiveRoot(d);
        }
        return root;
    }

    public void setConfigRoot(Descriptor d, File root) {
        UIConfigProperties p = this.getProjectConfig(d);
        p.setProperty(CONFIG_PROJECT_ROOT, root.getPath());
    }

    public File[] getConfigPaths(Descriptor d) {
        UIConfigProperties p = this.getProjectConfig(d);
        String[] list = p.getStringArray(CONFIG_SEARCHPATH, null);
        if (list == null) {
            list = p.getStringArray(UIProject.GetPathKey(d), null);
        }
        if (list == null) {
            list = UIConfig.getStringArray(UIProject.GetPathKey(d));
        }
        File[] fileList = new File[list.length];
        for (int i = 0; i < list.length; ++i) {
            fileList[i] = new File(list[i]);
        }
        return fileList;
    }

    public File[] getAbsolutePaths(Descriptor d) {
        return this.getAbsolutePaths(d, true);
    }

    public File[] getAbsolutePaths(Descriptor d, boolean mustExist) {
        Vector fullPath = this._getAbsolutePaths(d, mustExist, null);
        return fullPath.toArray(new File[fullPath.size()]);
    }

    public Vector _getAbsolutePaths(Descriptor d, boolean mustExist, Vector fullPath) {
        if (fullPath == null) {
            fullPath = new Vector<File>();
        }
        File root = this.getConfigRoot(d);
        File[] pathList = this.getConfigPaths(d);
        for (int i = 0; i < pathList.length; ++i) {
            File absDir;
            File dir = UIProject.MakeFile(root, pathList[i].getPath());
            if (dir == null || mustExist && !dir.getName().equals(WILDCARD) && !dir.isDirectory() || fullPath.contains(absDir = dir.getAbsoluteFile())) continue;
            fullPath.add(absDir);
        }
        return fullPath;
    }

    public ClassLoader getClassLoader(Descriptor d) {
        return ModuleArchive.getClassLoader(d);
    }

    protected File[] getRelativePaths(Descriptor d, File[] paths) {
        String rootPath;
        File rootFile = this.getConfigRoot(d);
        String string = rootPath = rootFile != null ? rootFile.getAbsolutePath() : null;
        if (rootPath != null && !rootPath.equals("")) {
            String rp = rootPath.endsWith(FileSeparator) ? rootPath : rootPath + FileSeparator;
            Vector<File> newPaths = new Vector<File>();
            for (int i = 0; i < paths.length; ++i) {
                String pathName = paths[i].toString();
                if (pathName.equals(rootPath)) {
                    pathName = ".";
                } else if (UIProject.StrFileStartsWith(pathName, rp)) {
                    pathName = pathName.substring(rp.length());
                    while (pathName.startsWith(FileSeparator)) {
                        pathName = pathName.substring(1);
                    }
                }
                File pathDir = new File(pathName);
                if (newPaths.contains(pathDir)) continue;
                newPaths.add(pathDir);
            }
            return newPaths.toArray(new File[newPaths.size()]);
        }
        return paths;
    }

    public void setConfigPath(Descriptor d, File[] paths) {
        Object[] newPaths = this.getRelativePaths(d, paths);
        UIConfigProperties p = this.getProjectConfig(d);
        p.setPropertyArray(CONFIG_SEARCHPATH, newPaths);
    }

    public void addConfigPath(Descriptor d, File pathFile) {
        if (pathFile != null) {
            File[] pathList = this.getAbsolutePaths(d, false);
            for (int i = 0; i < pathList.length; ++i) {
                if (!pathList[i].equals(pathFile)) continue;
                return;
            }
            File[] newPath = new File[pathList.length + 1];
            for (int i = 0; i < pathList.length; ++i) {
                newPath[i + 1] = pathList[i];
            }
            newPath[0] = pathFile;
            this.setConfigPath(d, newPath);
        }
    }

    private File[] getUnusedConfigPaths(Descriptor d) {
        File root = this.getConfigRoot(d);
        String rootStr = root != null ? root.getPath() : null;
        File[] paths = this.getConfigPaths(d);
        Vector<File> pathList = new Vector<File>();
        for (int i = 0; i < paths.length; ++i) {
            pathList.add(paths[i]);
        }
        SearchPath sp = new SearchPath(null, d);
        List names = ModuleArchive.getModuleArchive(d).getEntryNames();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            File dir;
            String entry = (String)i.next();
            if (UIProject.SkipJarEntry(entry) || (dir = sp.findPath(entry)) == null) continue;
            String dirStr = dir.getPath();
            if (rootStr != null && UIProject.StrFileStartsWith(dirStr, rootStr)) {
                dirStr = dirStr.substring(rootStr.length());
                while (dirStr.startsWith(FileSeparator)) {
                    dirStr = dirStr.substring(1);
                }
                dir = new File(!dirStr.equals("") ? dirStr : ".");
            }
            pathList.remove(dir);
        }
        return pathList.toArray(new File[pathList.size()]);
    }

    private boolean saveProjectConfig(Descriptor d, boolean saveProjectEntry) {
        return this.saveProjectConfig(this.getProjectConfig(d), d, saveProjectEntry);
    }

    private boolean saveProjectConfig(UIConfigProperties cfgProps, Descriptor d, boolean saveProjectEntry) {
        if (cfgProps != null) {
            try {
                File cfgFile = cfgProps.getConfigFile();
                if (cfgFile != null) {
                    cfgProps.save(cfgFile, " " + d.getDisplayName() + " Project File");
                    cfgProps.setLastModified(cfgFile.lastModified());
                    if (saveProjectEntry) {
                        this.saveProjectEntry(cfgProps, d, true);
                    }
                    return true;
                }
                Print.printStackTrace((String)"Project config file not specified");
            }
            catch (IOException ioe) {
                Print.dprintln((String)("Unable to save project config: " + ioe));
            }
        } else {
            Print.dprintln((String)"'cfgProps' is null");
        }
        return false;
    }

    private void saveProjectEntry(UIConfigProperties cfgProps, Descriptor d, boolean okToUpdate) {
        if (SAVE_PROJECT_FILE) {
            File propFile = cfgProps.getConfigFile();
            if (propFile != null) {
                String propName = UIProject.getProjectEntryName(d);
                ModuleArchive modArch = ModuleArchive.getModuleArchive(d);
                if (okToUpdate || !modArch.containsArchiveEntry(propName)) {
                    modArch.addArchiveEntry(propName, propFile);
                }
            } else {
                Print.printStackTrace((String)"Project config file not specified");
            }
        }
    }

    private UIConfigProperties getProjectConfig(Descriptor d) {
        File diskProjParent;
        File projFile;
        UIConfigProperties cfgProps;
        if (d == null) {
            if (this.descriptor == null) {
                Print.dprintStackTrace((String)"Descriptor is null");
                return null;
            }
            d = this.descriptor;
        }
        if ((cfgProps = (UIConfigProperties)this.archivePropertiesHash.get(UIProject.ProjectPropertyKey(d))) != null) {
            File cfgFile = cfgProps.getConfigFile();
            if (cfgFile != null && cfgFile.lastModified() > cfgProps.lastModified()) {
                Print.dprintln((String)"Updating project file from disk (has it changed?)");
                try {
                    cfgProps.loadFile();
                }
                catch (Throwable t) {
                    Print.dprintStackTrace((String)("Error reloading project file: " + cfgFile), (Throwable)t);
                }
                this.saveProjectEntry(cfgProps, d, true);
            } else {
                this.saveProjectEntry(cfgProps, d, false);
            }
            return cfgProps;
        }
        cfgProps = new UIConfigProperties();
        this.archivePropertiesHash.put(UIProject.ProjectPropertyKey(d), cfgProps);
        String projectFileEntry = UIProject.getProjectEntryName(d);
        File diskProject = UIProject.TempProjectFile(d, true);
        if (!diskProject.exists() && this.findProjectOnDisk && (projFile = this.findArchiveProject(d)).exists()) {
            diskProject = projFile;
        }
        if (!(diskProjParent = diskProject.getParentFile()).exists()) {
            diskProjParent.mkdirs();
            FileUtil.deleteOnExit((File)diskProjParent, (boolean)true);
        }
        cfgProps.setConfigFile(diskProject);
        long diskProjectTime = diskProject.exists() ? diskProject.lastModified() : 0L;
        File jarFile = UIProject.getJarFile(d);
        JarFile jar = null;
        try {
            jar = jarFile != null ? new JarFile(jarFile) : null;
        }
        catch (Throwable t) {
            Print.dprintln((String)("Error openning JarFile: " + jarFile + " => " + t));
        }
        ZipEntry jarProject = jar != null ? jar.getEntry(projectFileEntry) : null;
        long jarProjectTime = jarProject != null ? jarProject.getTime() : 0L;
        try {
            if (jarProject != null && jarProjectTime > diskProjectTime) {
                if (jarProjectTime > cfgProps.lastModified()) {
                    InputStream projInput = jar.getInputStream(jarProject);
                    cfgProps.loadStream(projInput);
                    cfgProps.setLastModified(jarProjectTime);
                    projInput.close();
                    this.saveProjectConfig(cfgProps, d, false);
                }
            } else if (diskProject.exists()) {
                if (diskProjectTime > cfgProps.lastModified()) {
                    cfgProps.loadFile();
                    this.saveProjectEntry(cfgProps, d, true);
                } else {
                    this.saveProjectEntry(cfgProps, d, false);
                }
            } else {
                Object[] paths;
                File root = this.findArchiveRoot(d);
                if (root != null) {
                    cfgProps.setProperty(CONFIG_PROJECT_ROOT, root.getPath());
                }
                if ((paths = UIProject.extractObsoleteProjectPaths(d)) == null) {
                    paths = UIConfig.getStringArray(UIProject.GetPathKey(d));
                }
                cfgProps.setPropertyArray(CONFIG_SEARCHPATH, paths);
                this.saveProjectConfig(cfgProps, d, true);
                this.createdProjectFile = true;
            }
        }
        catch (Exception ex) {
            Print.dprintStackTrace((String)("Unable to read Project file: " + diskProject), (Throwable)ex);
        }
        if (jar != null) {
            try {
                jar.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return cfgProps;
    }

    private File findArchiveRoot(Descriptor archDesc) {
        File dir;
        if (archDesc == null) {
            archDesc = this.descriptor;
        }
        File root = null;
        if (DescriptorTools.isModuleDescriptor(archDesc)) {
            File af = ModuleArchive.getArchiveFile(archDesc);
            if (af != null) {
                root = af.getParentFile();
            }
        } else if (archDesc instanceof BundleDescriptor) {
            root = this.findArchiveRoot((Descriptor)((BundleDescriptor)archDesc).getApplication());
        } else {
            Print.dprintln((String)("Unsupported descriptor: " + DT.className(archDesc)));
        }
        if (root == null) {
            return null;
        }
        String name = archDesc.getDisplayName();
        if (name != null && !name.equals("") && (dir = UIProject.MakeFile(root, name)) != null && dir.isDirectory()) {
            return dir;
        }
        String archUriName = UIProject.getArchiveName(archDesc);
        if (archUriName != null) {
            int p = archUriName.lastIndexOf(".");
            String n = p > 0 ? archUriName.substring(0, p) : name;
            String e = p > 0 ? archUriName.substring(p + 1) : "";
            File dir2 = UIProject.MakeFile(root, n + "_" + e);
            if (dir2 != null && dir2.isDirectory()) {
                return dir2;
            }
            dir2 = UIProject.MakeFile(root, n);
            if (dir2 != null && dir2.isDirectory()) {
                return dir2;
            }
        }
        return root;
    }

    private File findArchiveProject(Descriptor d) {
        File proj;
        File root;
        if (d == null) {
            d = this.descriptor;
        }
        if ((root = this.findArchiveRoot(d)) == null) {
            return null;
        }
        String name = d.getDisplayName();
        if (name != null && !name.equals("") && (proj = UIProject.MakeFile(root, name + PROJECT_EXTN)) != null && proj.isFile()) {
            return proj;
        }
        String archUriName = UIProject.getArchiveName(d);
        if (archUriName != null) {
            int p = archUriName.lastIndexOf(".");
            String n = p > 0 ? archUriName.substring(0, p) : name;
            String e = p > 0 ? archUriName.substring(p + 1) : "";
            File proj2 = UIProject.MakeFile(root, n + "_" + e + PROJECT_EXTN);
            if (proj2 != null && proj2.isFile()) {
                return proj2;
            }
            proj2 = UIProject.MakeFile(root, n + PROJECT_EXTN);
            if (proj2 != null && proj2.isFile()) {
                return proj2;
            }
        }
        return null;
    }

    public static File findFileEntry(File root, String entry) {
        if (!root.isDirectory()) {
            return null;
        }
        String re = UIProject.ToArchSep(entry);
        while (true) {
            File file;
            if ((file = UIProject.MakeFile(root, re)) != null && file.exists()) {
                return file;
            }
            int p = re.indexOf(ArchSeparator);
            if (p < 0) break;
            re = re.substring(p + 1);
        }
        return null;
    }

    private static String PREUPDATE_TITLE(Object v0) {
        return localStrings.getLocalString("ui.uiproject.pre_update.title", "Update Files: {0}", new Object[]{v0});
    }

    private boolean showPreUpdate(boolean interactive) {
        ArchiveEntryTreeNode[] archNodes = this.getArchiveEntryNodes();
        ArchiveEntryTreeNode needsUpdate = archNodes[0];
        ArchiveEntryTreeNode foundOk = archNodes[1];
        ArchiveEntryTreeNode notFound = archNodes[2];
        if (needsUpdate.getChildCount() == 0 && notFound.getChildCount() == 0) {
            if (interactive) {
                String archName = UIProject.getArchiveName(this.descriptor);
                UIOptionPane.showInfoDialog(DT.getApplicationFrame(), UIProject.ALL_UP_TO_DATE(archName));
            }
            return false;
        }
        if (interactive) {
            if (this.preUpdateDialog == null) {
                this.preUpdateDialog = new PreUpdateDialog();
            }
            return this.preUpdateDialog.show(archNodes);
        }
        return true;
    }

    private ArchiveEntryTreeNode[] getArchiveEntryNodes() {
        String descName = UIProject.getArchiveName(this.descriptor);
        ArchiveEntry appArchEntry = new ArchiveEntry(ModuleArchive.getModuleArchive(this.descriptor), descName, null);
        ArchiveEntryTreeNode needsUpd = new ArchiveEntryTreeNode(appArchEntry);
        ArchiveEntryTreeNode foundOk = new ArchiveEntryTreeNode(appArchEntry);
        ArchiveEntryTreeNode notFound = new ArchiveEntryTreeNode(appArchEntry);
        try {
            ProjectHashtable archList = this.getUpdateArchiveEntries(true);
            this._parseFileTypes(archList, needsUpd, foundOk, notFound, true);
        }
        catch (Exception ex) {
            Print.printStackTrace((String)"Getting archive nodes", (Throwable)ex);
        }
        return new ArchiveEntryTreeNode[]{needsUpd, foundOk, notFound};
    }

    private static String EDITPATHS_TITLE(Object v0) {
        return localStrings.getLocalString("ui.uiproject.edit_paths.title", "Edit Search Paths: {0}", new Object[]{v0});
    }

    private static String EDITPATHS_NOT_A_DIRECTORY(Object v0) {
        return localStrings.getLocalString("ui.uiproject.edit_paths.table.not_a_directory", "Specified path is not a directory\n {0}", new Object[]{v0});
    }

    public static boolean editSearchPaths(Component c, Descriptor d) {
        Window win;
        Window window = win = c != null ? WinTools.getAncestorWindow(c) : DT.getApplicationFrame();
        if (globalPathEditor == null || globalPathEditor.getOwner() != win) {
            if (globalPathEditor != null) {
                globalPathEditor.dispose();
            }
            if (win == null) {
                globalPathEditor = new SearchPathEditor(DT.getApplicationFrame());
            } else if (win instanceof Dialog) {
                globalPathEditor = new SearchPathEditor((Dialog)win);
            } else if (win instanceof Frame) {
                globalPathEditor = new SearchPathEditor((Frame)win);
            } else {
                Print.dprintln((String)("Not a Frame/Dialog: " + DT.className(win)));
                globalPathEditor = new SearchPathEditor(DT.getApplicationFrame());
            }
        }
        return globalPathEditor.showEditor(d, true);
    }

    public static void printMap(Map hash, String title) {
        if (UIConfig.debugMode()) {
            if (hash == null) {
                Print.dprintln((String)"Printing Hashtable contents ... (Hashtable is 'null')");
            } else {
                Print.dprintln((String)"Printing Hashtable contents ...");
                String t = title != null ? title : "";
                Print.println((String)("\n=== " + UIUtils.debugClassName(hash) + " contents: " + t));
                UIProject._printMap(hash, 0);
                Print.println((String)"");
            }
        }
    }

    private static void _printMap(Map hash, int level) {
        String indent = "    ";
        for (int i = 0; i < level; ++i) {
            indent = indent + "    ";
        }
        if (hash == null) {
            Print.println((String)(indent + "<null>"));
            return;
        }
        if (hash.isEmpty()) {
            Print.println((String)(indent + "<empty>"));
            return;
        }
        Iterator e = hash.keySet().iterator();
        while (e.hasNext()) {
            Object key = e.next();
            String keyClass = UIUtils.debugClassName(key);
            Object val = hash.get(key);
            String valClass = UIUtils.debugClassName(val);
            Print.println((String)(indent + "(" + keyClass + ")'" + key + "'" + " ==> " + "(" + valClass + ")'" + val + "'"));
            if (!(val instanceof ArchiveEntry)) continue;
            UIProject._printMap(((ArchiveEntry)val).getArchiveHash(), level + 1);
        }
    }

    private static String ToFileSep(String n) {
        return n.replace('/', FileSeparatorChar);
    }

    private static String ToArchSep(String n) {
        return n.replace(FileSeparatorChar, '/');
    }

    private static boolean StrFileStartsWith(String target, String test) {
        if (target == null || test == null) {
            return false;
        }
        return !IsDosFileSeparator ? target.startsWith(test) : target.toLowerCase().startsWith(test.toLowerCase());
    }

    private static boolean StrFileEndsWith(String target, String test) {
        if (target == null || test == null) {
            return false;
        }
        return !IsDosFileSeparator ? target.endsWith(test) : target.toLowerCase().endsWith(test.toLowerCase());
    }

    private static boolean StrFileEquals(String target, String test) {
        if (target == null || test == null) {
            return false;
        }
        return !IsDosFileSeparator ? target.equals(test) : target.equalsIgnoreCase(test);
    }

    public static String[] extractObsoleteProjectPaths(Descriptor d) {
        String archName = UIProject.getArchiveName(d);
        String name = "";
        if (DescriptorTools.isModuleDescriptor(d)) {
            name = ((RootDeploymentDescriptor)d).getDisplayName();
        } else if (d instanceof BundleDescriptor) {
            Application app = ((BundleDescriptor)d).getApplication();
            name = app != null ? app.getDisplayName() : ((BundleDescriptor)d).getDisplayName();
        }
        return UIProject.extractObsoleteProjectPaths(name, UIProject.getArchiveName(d));
    }

    public static String[] extractObsoleteProjectPaths(String appName, String archName) {
        File projFile = new File(UIConfig.getConfigDirectory(), appName + ".proj");
        if (!projFile.exists()) {
            return null;
        }
        Properties props = new Properties();
        try {
            FileInputStream fis = new FileInputStream(projFile);
            props.load(fis);
            fis.close();
        }
        catch (Exception ex) {
            Print.dprintln((String)("Old project exists, but cannot be read: " + projFile));
            return null;
        }
        Vector<String> paths = new Vector<String>();
        String archPrefix = null;
        Enumeration<Object> ke = props.keys();
        while (ke.hasMoreElements()) {
            String entryKey = (String)ke.nextElement();
            if (archPrefix != null && !entryKey.startsWith(archPrefix) || !entryKey.endsWith(ENTRY)) continue;
            if (archPrefix == null) {
                String name;
                int a = entryKey.indexOf(".");
                String ap = a > 0 ? entryKey.substring(0, a) + "." : null;
                if (ap == null || !archName.equals(name = props.getProperty(ap + "name"))) continue;
                archPrefix = ap;
            }
            String entry = props.getProperty(entryKey);
            int ep = entryKey.length() - ENTRY.length();
            String originKey = entryKey.substring(0, ep) + ORIGIN;
            String origin = props.getProperty(originKey);
            if (origin == null || !UIProject.StrFileEndsWith(origin, UIProject.ToFileSep(entry))) continue;
            String relDir = origin.substring(0, origin.length() - entry.length());
            while (relDir.endsWith(FileSeparator)) {
                relDir = relDir.substring(0, relDir.length() - 1);
            }
            if (paths.contains(relDir)) continue;
            paths.add(relDir);
        }
        if (paths.size() == 0) {
            return null;
        }
        Print.dprintln((String)("Loaded v1.3 project paths: " + archName + " => " + projFile));
        return paths.toArray(new String[paths.size()]);
    }

    private static class SearchPathEditor
    extends UIDialog {
        private Descriptor currentDescriptor = null;
        private UIProject currentProject = null;
        private UITitledTextField editPathRoot = null;
        private UITitledTable editPathTable = null;
        private SearchPathTable searchPathTable = null;
        private File searchRoot = null;
        private Vector searchPaths = null;
        private boolean ok = false;

        public SearchPathEditor(Frame win) {
            super(win, true);
            this._winInit();
        }

        public SearchPathEditor(Dialog win) {
            super(win, true);
            this._winInit();
        }

        private void _winInit() {
            this._init();
            this.setSize(new Dimension(750, 500));
            this.setLocationRelativeToOwner();
        }

        private void _init() {
            UIControlButtonBox dialogBox = new UIControlButtonBox(null, false);
            dialogBox.setControlButtonLocation(101);
            this.setContentPane(dialogBox);
            UITitledBox content = new UITitledBox(null, false);
            dialogBox.setView(content);
            GridBagConstraints c = content.getGBConstraintsCopy();
            this.editPathRoot = new UITitledTextField(EDITPATHS_ROOT, true);
            this.editPathRoot.addActionListener(new ActionListener(this){
                private final /* synthetic */ SearchPathEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent c) {
                    String pathName = SearchPathEditor.access$1900(this.this$0).getText();
                    if (!pathName.equals("")) {
                        File dir = new File(pathName);
                        if (!dir.isDirectory()) {
                            UIOptionPane.showWarningDialog(this.this$0, UIProject.access$2000(dir));
                        }
                        SearchPathEditor.access$2102(this.this$0, dir.getAbsoluteFile());
                    }
                    SearchPathEditor.access$2200(this.this$0);
                }
            });
            this.editPathRoot.setBrowserActionListener(new ActionListener(this){
                private final /* synthetic */ SearchPathEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent c) {
                    String dirName = SearchPathEditor.access$1900(this.this$0).getText();
                    UIFileChooser dc = UIFileChooser.getDirChooser(new File(dirName));
                    int rtn = dc.showDialog(this.this$0, UIProject.access$2300());
                    if (rtn == 0) {
                        File dir = dc.getSelectedFile().getAbsoluteFile();
                        if (dir.isDirectory()) {
                            SearchPathEditor.access$2102(this.this$0, dir);
                            SearchPathEditor.access$2200(this.this$0);
                        } else {
                            Print.dprintln((String)("Not a Dir: " + dir));
                        }
                    }
                }
            });
            c.weightx = 0.5;
            c.weighty = 0.0;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(5, 5, 0, 5);
            c.fill = 2;
            content.add((Component)this.editPathRoot, c);
            this.editPathTable = new UITitledTable(EDITPATHS_TABLE_TITLE, true);
            this.searchPathTable = new SearchPathTable(new SearchPathTableModel());
            this.editPathTable.setTableView(this.searchPathTable);
            c.weightx = 0.5;
            c.weighty = 0.5;
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(5, 5, 5, 5);
            c.fill = 1;
            content.add((Component)this.editPathTable, c);
            UIButton addBtn = UIButton.createAddButton(new ActionListener(this){
                private final /* synthetic */ SearchPathEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    SearchPathEditor.access$2500(this.this$0);
                }
            });
            this.editPathTable.addControlButton(addBtn);
            UIButton delBtn = UIButton.createDeleteButton(new ActionListener(this){
                private final /* synthetic */ SearchPathEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    SearchPathEditor.access$2600(this.this$0);
                }
            }, true);
            this.editPathTable.addSelectionEnabledButton(delBtn);
            UIButton mvUpBtn = new UIButton(EDITPATHS_TABLE_MOVE_UP, EDITPATHS_TABLE_MOVE_UP_MNEMONIC, null, new ActionListener(this){
                private final /* synthetic */ SearchPathEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    SearchPathEditor.access$2900(this.this$0);
                }
            });
            this.editPathTable.addSelectionEnabledButton(mvUpBtn);
            UIButton mvDnBtn = new UIButton(EDITPATHS_TABLE_MOVE_DOWN, EDITPATHS_TABLE_MOVE_DOWN_MNEMONIC, null, new ActionListener(this){
                private final /* synthetic */ SearchPathEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    SearchPathEditor.access$3200(this.this$0);
                }
            });
            this.editPathTable.addSelectionEnabledButton(mvDnBtn);
            UIButton browseBtn = new UIButton(EDITPATHS_TABLE_BROWSE, EDITPATHS_TABLE_BROWSE_MNEMONIC, new ActionListener(this){
                private final /* synthetic */ SearchPathEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    SearchPathEditor.access$3500(this.this$0);
                }
            });
            this.editPathTable.addSelectionEnabledButton(browseBtn);
            if (UIConfig.debugMode()) {
                UIButton unusedBtn = new UIButton(UIProject.EDITPATHS_TABLE_UNUSED_PATHS, null, new ActionListener(this){
                    private final /* synthetic */ SearchPathEditor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent ae) {
                        SearchPathEditor.access$3600(this.this$0);
                    }
                });
                this.editPathTable.addControlButton(unusedBtn);
            }
            UIButton okBtn = UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ SearchPathEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    SearchPathEditor.access$3702(this.this$0, true);
                    this.this$0.hide();
                }
            });
            dialogBox.addControlButton(okBtn);
            UIButton cancelBtn = UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ SearchPathEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    SearchPathEditor.access$3702(this.this$0, false);
                    this.this$0.hide();
                }
            });
            dialogBox.addControlButton(cancelBtn);
            dialogBox.addControlButton(new UIHelpButton("EditSearchPaths"));
        }

        public boolean showEditor(Descriptor d, boolean update) {
            this.currentDescriptor = d;
            UIProject prj = UIProject.getProject(this.currentDescriptor);
            if (prj == null) {
                UIOptionPane.showErrorDialog(this.getOwner(), UIProject.NO_PROJECT_FOUND(d.getDisplayName()));
                return false;
            }
            this.currentProject = prj;
            this.setTitle(UIProject.EDITPATHS_TITLE(d.getDisplayName()));
            File[] paths = prj.getConfigPaths(this.currentDescriptor);
            this.searchPaths = new Vector();
            for (int i = 0; i < paths.length; ++i) {
                this.searchPaths.add(this.searchPathTable.wrapDataItem(paths[i].getPath()));
            }
            this.searchRoot = prj.getConfigRoot(this.currentDescriptor);
            this.refreshRoot();
            this.refreshTable();
            this.searchPathTable.clearSelection();
            this.ok = false;
            super.show();
            if (this.ok && update) {
                File root = this.getSearchRoot();
                prj.setConfigRoot(d, root);
                Vector dirList = this.getSearchPaths();
                File[] dirs = dirList.toArray(new File[dirList.size()]);
                prj.setConfigPath(d, dirs);
                prj.saveProjectConfig(d, true);
            }
            return this.ok;
        }

        private File getSearchRoot() {
            return this.searchRoot;
        }

        private Vector getSearchPaths() {
            Vector<File> paths = new Vector<File>();
            Iterator i = this.searchPaths.iterator();
            while (i.hasNext()) {
                String fileName = i.next().toString();
                if (fileName.equals("")) continue;
                paths.add(new File(fileName));
            }
            return paths;
        }

        private void addAction() {
            if (this.searchPathTable.getRowWithValue(0, "") == null) {
                this.searchPaths.add(this.searchPathTable.wrapDataItem(""));
            }
            this.refreshTable();
            this.searchPathTable.selectRowWithValue(0, "");
        }

        private void deleteAction() {
            Object[] list = this.searchPathTable.confirmDeleteSelection(null, null);
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    this.searchPaths.remove(list[i]);
                }
            }
            this.refreshTable();
        }

        private void moveUpAction() {
            int p;
            Object sel = this.searchPathTable.getSelectedRowObject();
            int n = p = sel != null ? this.searchPaths.indexOf(sel) : -1;
            if (p > 0) {
                this.searchPaths.remove(sel);
                this.searchPaths.insertElementAt(sel, p - 1);
                this.refreshTable();
                this.searchPathTable.setSelectedRowObject(sel);
            }
        }

        private void moveDownAction() {
            int p;
            Object sel = this.searchPathTable.getSelectedRowObject();
            int n = p = sel != null ? this.searchPaths.indexOf(sel) : -1;
            if (p >= 0 && p < this.searchPaths.size() - 1) {
                this.searchPaths.remove(sel);
                this.searchPaths.insertElementAt(sel, p + 1);
                this.refreshTable();
                this.searchPathTable.setSelectedRowObject(sel);
            }
        }

        private void browseDirAction() {
            Object sel = this.searchPathTable.getSelectedRowObject();
            if (sel != null) {
                UIFileChooser dc;
                int rtn;
                String dirName = this.searchPathTable.getObjectValue(sel, 0).toString();
                File dirFile = new File(dirName);
                if (!dirFile.isAbsolute()) {
                    dirFile = new File(this.getSearchRoot(), dirName);
                }
                if ((rtn = (dc = UIFileChooser.getDirChooser(dirFile)).showDialog(this, EDITPATHS_BROWSE_DIR)) == 0) {
                    File dir = dc.getSelectedFile().getAbsoluteFile();
                    if (dir.isDirectory()) {
                        this.searchPathTable.setObjectValue(sel, 0, dir.getPath());
                        this.searchPathTable.repaint();
                    } else {
                        Print.dprintln((String)("Not a Dir: " + dir));
                    }
                }
            }
        }

        private void selectUnusedPathsAction() {
            this.searchPathTable.clearSelection();
            File[] paths = this.currentProject.getUnusedConfigPaths(this.currentDescriptor);
            if (paths != null) {
                for (int i = 0; i < paths.length; ++i) {
                    int ndx = this.searchPathTable.findRowWithValue(0, paths[i].getPath());
                    this.searchPathTable.addSelectedIndex(ndx);
                }
            }
        }

        private void refreshRoot() {
            this.editPathRoot.setText(this.searchRoot != null ? this.searchRoot.getPath() : "");
        }

        private void refreshTable() {
            this.searchPathTable.updateTableData(this.searchPaths);
        }

        static /* synthetic */ UITitledTextField access$1900(SearchPathEditor x0) {
            return x0.editPathRoot;
        }

        static /* synthetic */ File access$2102(SearchPathEditor x0, File x1) {
            x0.searchRoot = x1;
            return x0.searchRoot;
        }

        static /* synthetic */ void access$2200(SearchPathEditor x0) {
            x0.refreshRoot();
        }

        static /* synthetic */ void access$2500(SearchPathEditor x0) {
            x0.addAction();
        }

        static /* synthetic */ void access$2600(SearchPathEditor x0) {
            x0.deleteAction();
        }

        static /* synthetic */ void access$2900(SearchPathEditor x0) {
            x0.moveUpAction();
        }

        static /* synthetic */ void access$3200(SearchPathEditor x0) {
            x0.moveDownAction();
        }

        static /* synthetic */ void access$3500(SearchPathEditor x0) {
            x0.browseDirAction();
        }

        static /* synthetic */ void access$3600(SearchPathEditor x0) {
            x0.selectUnusedPathsAction();
        }

        static /* synthetic */ boolean access$3702(SearchPathEditor x0, boolean x1) {
            x0.ok = x1;
            return x0.ok;
        }

        private class SearchPathTableModel
        extends InspectorTableModel {
            public SearchPathTableModel() {
                super(new String[]{EDITPATHS_PATH_DIRECTORY});
                this.setDataOrdering(2);
            }

            public Object getObjectValue(Object obj, int col) {
                return obj.toString();
            }

            public void setObjectValue(Object obj, int col, Object value) {
                File checkDir;
                String pathName = value.toString();
                File dir = new File(pathName);
                File file = checkDir = dir.isAbsolute() ? dir : new File(SearchPathEditor.this.getSearchRoot(), pathName);
                if (!checkDir.getName().equals(WILDCARD) && !checkDir.isDirectory()) {
                    UIOptionPane.showWarningDialog(SearchPathEditor.this, UIProject.EDITPATHS_NOT_A_DIRECTORY(checkDir));
                }
                ((InspectorTableModel.InspectorDataWrapper)obj).setObject(dir);
            }
        }

        private class SearchPathTable
        extends InspectorTable {
            public SearchPathTable(SearchPathTableModel model) {
                super(model);
            }
        }
    }

    private class PreUpdateDialog
    extends UIDialog {
        private UITitledTree needsUpdateTree;
        private UITitledTextField diskFileText;
        private UITitledTree notFoundTree;
        private UIControlButtonBox buttons;
        private JButton okBtn;
        private JButton cancelBtn;
        private JButton editBtn;
        private boolean ok;

        public PreUpdateDialog() {
            this(DT.getApplicationFrame());
        }

        public PreUpdateDialog(Frame win) {
            super(win, true);
            this.needsUpdateTree = null;
            this.diskFileText = null;
            this.notFoundTree = null;
            this.buttons = null;
            this.okBtn = null;
            this.cancelBtn = null;
            this.editBtn = null;
            this.ok = false;
            this.init();
            this.setSize(new Dimension(750, 500));
            this.setLocationRelativeToOwner();
        }

        private void init() {
            UIPanel content = new UIPanel();
            GridBagConstraints c = new GridBagConstraints();
            content.setLayout(new GridBagLayout());
            this.setContentPane(content);
            this.needsUpdateTree = new UITitledTree(PREUPDATE_CHANGED_TITLE, true);
            JTree jt = new JTree();
            jt.getAccessibleContext().setAccessibleName(TREE_NAME);
            jt.getAccessibleContext().setAccessibleDescription(TREE_DESC);
            this.needsUpdateTree.setTreeView(jt);
            this.needsUpdateTree.setRootVisible(false);
            this.needsUpdateTree.setShowsRootHandles(true);
            this.diskFileText = new UITitledTextField(null, false);
            this.diskFileText.setReadOnly(true);
            this.needsUpdateTree.getGBConstraints().weighty = 0.0;
            this.needsUpdateTree.getGBConstraints().fill = 2;
            this.needsUpdateTree.addWithGBConstraints(this.diskFileText);
            this.needsUpdateTree.addTreeSelectionListener(new TreeSelectionListener(this){
                private final /* synthetic */ PreUpdateDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void valueChanged(TreeSelectionEvent tse) {
                    PreUpdateDialog.access$900(this.this$1);
                }
            });
            c.weightx = 0.5;
            c.weighty = 0.5;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(5, 5, 5, 5);
            c.fill = 1;
            content.add((Component)this.needsUpdateTree, c);
            this.notFoundTree = new UITitledTree(PREUPDATE_NOTFOUND_TITLE, true);
            jt = new JTree();
            jt.getAccessibleContext().setAccessibleName(TREE_NAME);
            jt.getAccessibleContext().setAccessibleDescription(TREE_DESC);
            this.notFoundTree.setTreeView(jt);
            this.notFoundTree.setRootVisible(true);
            this.notFoundTree.setShowsRootHandles(true);
            this.notFoundTree.setControlButtonLocation(101);
            this.notFoundTree.addTreeSelectionListener(new TreeSelectionListener(this){
                private final /* synthetic */ PreUpdateDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void valueChanged(TreeSelectionEvent tse) {
                    PreUpdateDialog.access$1100(this.this$1);
                }
            });
            this.editBtn = new UIButton(EDIT_SEARCH_PATHS, EDIT_SEARCH_PATHS_MNEMONIC, "edit", new ActionListener(this){
                private final /* synthetic */ PreUpdateDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    PreUpdateDialog.access$1200(this.this$1);
                }
            });
            this.editBtn.setEnabled(false);
            this.notFoundTree.addControlButton(this.editBtn);
            c.weightx = 0.5;
            c.weighty = 0.5;
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(5, 5, 5, 5);
            c.fill = 1;
            content.add((Component)this.notFoundTree, c);
            this.buttons = new UIControlButtonBox("<updated later>", false);
            this.buttons.setEnabledTitleColor(Color.black);
            this.buttons.setControlButtonLocation(101);
            c.weightx = 0.5;
            c.weighty = 0.0;
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(5, 5, 5, 5);
            c.fill = 2;
            content.add((Component)this.buttons, c);
            this.okBtn = UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ PreUpdateDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    PreUpdateDialog.access$1302(this.this$1, true);
                    this.this$1.hide();
                }
            });
            this.buttons.addControlButton(this.okBtn);
            this.cancelBtn = UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ PreUpdateDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    PreUpdateDialog.access$1302(this.this$1, false);
                    this.this$1.hide();
                }
            });
            this.buttons.addControlButton(this.cancelBtn);
            this.buttons.addControlButton(new UIHelpButton("UpdateFiles"));
        }

        public boolean show(ArchiveEntryTreeNode[] archNodes) {
            this.setTitle(UIProject.PREUPDATE_TITLE(UIProject.this.getDescriptor().getDisplayName()));
            this.ok = false;
            this.refreshUpdateTrees(archNodes);
            super.show();
            return this.ok;
        }

        public void refreshUpdateTrees(ArchiveEntryTreeNode[] archNodes) {
            if (archNodes == null) {
                archNodes = UIProject.this.getArchiveEntryNodes();
            }
            ArchiveEntryTreeNode needsUpdate = archNodes[0];
            ArchiveEntryTreeNode foundOk = archNodes[1];
            ArchiveEntryTreeNode notFound = archNodes[2];
            boolean hasUpdates = needsUpdate.getChildCount() > 0;
            this.needsUpdateTree.setRootNode(needsUpdate);
            this.notFoundTree.setRootNode(notFound);
            this.notFoundTree.setVisible(notFound.getChildCount() > 0);
            this.okBtn.setVisible(hasUpdates);
            this.buttons.setTitle(hasUpdates ? PREUPDATE_CONTINUE : PREUPDATE_CANCEL);
        }

        private void selectedNeedsUpdateFile() {
            String pathName = "";
            Object entry = this.needsUpdateTree.getSelectedUserObject();
            if (entry instanceof FileEntry) {
                File file = ((FileEntry)entry).getDiskFile();
                pathName = file != null ? file.getPath() : "?";
            }
            this.diskFileText.setText(pathName);
        }

        private void selectedNotFoundFile() {
            Object entry = this.notFoundTree.getSelectedUserObject();
            this.editBtn.setEnabled(entry instanceof ArchiveEntry);
        }

        private void editSearchPathsAction() {
            Object entry = this.notFoundTree.getSelectedUserObject();
            if (!(entry instanceof ArchiveEntry)) {
                return;
            }
            if (UIProject.editSearchPaths(this, ((ArchiveEntry)entry).getDescriptor())) {
                this.refreshUpdateTrees(null);
            }
        }

        static /* synthetic */ void access$900(PreUpdateDialog x0) {
            x0.selectedNeedsUpdateFile();
        }

        static /* synthetic */ void access$1100(PreUpdateDialog x0) {
            x0.selectedNotFoundFile();
        }

        static /* synthetic */ void access$1200(PreUpdateDialog x0) {
            x0.editSearchPathsAction();
        }

        static /* synthetic */ boolean access$1302(PreUpdateDialog x0, boolean x1) {
            x0.ok = x1;
            return x0.ok;
        }
    }

    private class SearchPath {
        private Descriptor archDesc = null;
        private File rootDir = null;
        private Vector pathList = new Vector();

        public SearchPath(SearchPath sp, Descriptor d) {
            this.archDesc = d;
            if (sp != null) {
                this.pathList.addAll(sp.pathList);
            }
            this._setSubPaths();
        }

        public Descriptor getDescriptor() {
            return this.archDesc;
        }

        private void _setSubPaths() {
            File[] path = UIProject.this.getAbsolutePaths(this.archDesc);
            for (int i = 0; i < path.length; ++i) {
                if (this.pathList.size() == i) {
                    this.pathList.add(path[i]);
                    continue;
                }
                this.pathList.insertElementAt(path[i], i);
            }
        }

        public Enumeration getPaths() {
            return this.pathList.elements();
        }

        private File _recursiveFind(File root, String entry) {
            if (root.isDirectory()) {
                File file = UIProject.findFileEntry(root, entry);
                if (file != null && file.exists()) {
                    return file;
                }
                File[] dirFiles = root.listFiles();
                if (dirFiles != null) {
                    for (int i = 0; i < dirFiles.length; ++i) {
                        if (!dirFiles[i].isDirectory() || (file = this._recursiveFind(dirFiles[i], entry)) == null) continue;
                        return file;
                    }
                }
            }
            return null;
        }

        private File _findFile(String entry, boolean fullFile) {
            Enumeration paths = this.getPaths();
            while (paths.hasMoreElements()) {
                File dir = (File)paths.nextElement();
                File file = dir.getName().equals(WILDCARD) ? this._recursiveFind(dir.getParentFile(), entry) : UIProject.findFileEntry(dir, entry);
                if (file == null || !file.exists()) continue;
                return fullFile ? file : dir;
            }
            return null;
        }

        public File findFile(String entry) {
            File file = this._findFile(entry, true);
            if (file == null && (entry.startsWith(WEB_INF_) || entry.startsWith(META_INF_))) {
                String rp = UIProject.NormalizeKey(entry);
                file = this._findFile(rp, true);
            }
            return file;
        }

        public File findPath(String entry) {
            File file = this._findFile(entry, false);
            if (file == null && (entry.startsWith(WEB_INF_) || entry.startsWith(META_INF_))) {
                String rp = UIProject.NormalizeKey(entry);
                file = this._findFile(rp, false);
            }
            return file;
        }

        public String toString() {
            String ps = ";";
            StringBuffer sb = new StringBuffer();
            Enumeration paths = this.getPaths();
            int i = 0;
            while (paths.hasMoreElements()) {
                if (i > 0) {
                    sb.append(ps);
                }
                sb.append(paths.nextElement());
                ++i;
            }
            return sb.toString();
        }
    }

    private class FileEntryTreeNode
    extends DefaultMutableTreeNode {
        public FileEntryTreeNode(FileEntry fe) {
            super(fe);
        }

        public FileEntry getFileEntry() {
            return (FileEntry)this.getUserObject();
        }

        public String toString() {
            return this.getFileEntry().getEntryName();
        }
    }

    public class FileEntry
    extends ProjectHashtableEntry {
        private ArchiveEntry parentEntry;
        private File diskFile;
        private boolean needsUpdate;

        public FileEntry(ArchiveEntry parent, String name, File file, boolean upd) {
            this.parentEntry = null;
            this.diskFile = null;
            this.needsUpdate = false;
            this.parentEntry = parent;
            this.entryName = name;
            this.diskFile = file;
            this.needsUpdate = upd;
        }

        public boolean exists() {
            return this.diskFile != null;
        }

        public boolean needsUpdate() {
            return this.needsUpdate;
        }

        public ArchiveEntry getArchiveEntry() {
            return this.parentEntry;
        }

        public String getParentName() {
            return this.getArchiveEntry() != null ? this.getArchiveEntry().getEntryName() : null;
        }

        public String getArchiveName() {
            return this.getParentName() != null ? this.getParentName() : UIProject.this.getArchiveFile().getName();
        }

        public File getDiskFile() {
            return this.diskFile;
        }

        public String getAbsEntryName() {
            return (this.getParentName() != null ? this.getParentName() + ENTRY_SEPARATOR : "") + this.entryName;
        }

        public String toString() {
            return this.diskFile != null ? this.diskFile.toString() : this.entryName;
        }
    }

    private class ArchiveEntryTreeNode
    extends DefaultMutableTreeNode {
        public ArchiveEntryTreeNode(ArchiveEntry ae) {
            super(ae, true);
        }

        public ArchiveEntry getArchiveEntry() {
            return (ArchiveEntry)this.getUserObject();
        }

        public String toString() {
            return this.getArchiveEntry().getEntryName();
        }
    }

    public class ArchiveEntry
    extends ProjectHashtableEntry {
        private ModuleArchive archivist;
        private ProjectHashtable archiveHash;

        public ArchiveEntry(ModuleArchive arch, String name, ProjectHashtable archHash) {
            this.archivist = null;
            this.archiveHash = null;
            this.archivist = arch;
            this.entryName = name;
            this.archiveHash = archHash;
        }

        public ModuleArchive getModuleArchive() {
            return this.archivist;
        }

        public Descriptor getDescriptor() {
            return this.archivist.getDescriptor();
        }

        public ProjectHashtable getArchiveHash() {
            return this.archiveHash;
        }
    }

    private static class ProjectHashtableEntry {
        protected String entryName = null;

        private ProjectHashtableEntry() {
        }

        public String getEntryName() {
            return this.entryName;
        }
    }

    public static class ProjectHashtable
    extends Hashtable {
        private boolean needsUpdate = true;

        public ProjectHashtable() {
            this.setNeedsUpdate(true);
        }

        public ProjectHashtable(ProjectHashtable pht) {
            super(pht);
            this.needsUpdate = pht.needsUpdate;
        }

        public Object putEntry(Object key, ProjectHashtableEntry val) {
            ProjectHashtableEntry rtn = super.put(key, val);
            return rtn;
        }

        public Object put(Object key, Object val) {
            Print.dprintStackTrace((String)"Use 'putEntry' instead!!");
            return this.putEntry(key, (ProjectHashtableEntry)val);
        }

        public void clear() {
            super.clear();
            this.setNeedsUpdate(true);
        }

        public void setNeedsUpdate(boolean upd) {
            this.needsUpdate = upd;
        }

        public boolean needsUpdate() {
            return this.needsUpdate;
        }
    }

    public static class ArchiveHashtable
    extends Hashtable {
        public ArchiveHashtable() {
        }

        public ArchiveHashtable(Map ht) {
            Iterator i = ht.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                File file = (File)ht.get(key);
                this.putEntry(key, file);
            }
        }

        public Object putEntry(String key, File file) {
            return super.put(key, file);
        }

        public Object put(Object key, Object val) {
            Print.dprintStackTrace((String)"Use 'putEntry' instead!!");
            return this.putEntry((String)key, (File)val);
        }
    }
}

