/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIButtonEnabler;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelp;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class UIMenu
extends JMenu {
    protected static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIMenu.class);
    protected static String MENU_NAME = localStrings.getLocalString("ui.uimenu.menu_name", "Menu");
    protected static String MENU_DESC = localStrings.getLocalString("ui.uimenu.menu_desc", "This is a menu");
    protected static String MENU_ITEM_NAME = localStrings.getLocalString("ui.uimenu.menu_item_name", "Menu Item");
    protected static String MENU_ITEM_DESC = localStrings.getLocalString("ui.uimenu.menu_item_desc", "This is an item in the menu");
    public static final String Separator = "*Separator*";
    private PopupMenuListener popupMenuListener = null;
    private boolean hideIfEmpty = false;
    private JSeparator preSeparator = null;
    private JSeparator postSeparator = null;

    public static UIMenu createMenu(String title, boolean preSep, boolean postSep, Object[] items, boolean hideIfEmpty) {
        UIMenu menu = new UIMenu(title, '\u0000');
        menu.setPreSeparator(preSep);
        menu.setPostSeparator(postSep);
        menu.setHideIfEmpty(hideIfEmpty);
        for (int i = 0; i < items.length; ++i) {
            JMenuItem item;
            if (items[i] == null) continue;
            if (items[i].equals("") || items[i].equals(Separator)) {
                menu.addSeparator();
                continue;
            }
            if (items[i] instanceof JSeparator) {
                menu.add((JSeparator)items[i]);
                continue;
            }
            if (items[i] instanceof UIMenu) {
                item = (UIMenu)items[i];
                menu.addSeparator(((UIMenu)item).getPreSeparator());
                menu.add(item);
                menu.addSeparator(((UIMenu)item).getPostSeparator());
                continue;
            }
            if (items[i] instanceof UIMenuItem) {
                item = (UIMenuItem)items[i];
                menu.addSeparator(((UIMenuItem)item).getPreSeparator());
                menu.add(item);
                menu.addSeparator(((UIMenuItem)item).getPostSeparator());
                continue;
            }
            if (items[i] instanceof JMenuItem) {
                menu.add((JMenuItem)items[i]);
                continue;
            }
            if (items[i] instanceof String) {
                item = DT.getActionMenuItem((String)items[i]);
                if (item == null) continue;
                menu.add(item);
                continue;
            }
            Print.dprintStackTrace((String)("Not a JMenuItem: " + UIUtils.debugClassName(items[i])));
        }
        WinTools.resetDuplicateMnemonics(menu);
        return menu;
    }

    public static JMenuItem createMenuItem(String title, char mnemonic, KeyStroke accelerator, String enablementKey) {
        UIMenuItem item = new UIMenuItem(title, mnemonic, null);
        if (accelerator != null) {
            item.setAccelerator(accelerator);
        }
        UIButtonEnabler.GetGlobalEnabler().add(enablementKey, (AbstractButton)item);
        return item;
    }

    public static JMenuItem createMenuItem(String title, char mnemonic, KeyStroke accelerator, String[] enablementKey) {
        UIMenuItem item = new UIMenuItem(title, mnemonic, null);
        if (accelerator != null) {
            item.setAccelerator(accelerator);
        }
        UIButtonEnabler.GetGlobalEnabler().add(enablementKey, (AbstractButton)item);
        return item;
    }

    public static JMenuItem createHelpItem(String title, char mnemonic, KeyStroke accelerator, String enablementKey, String helpID) {
        JMenuItem item = UIMenu.createMenuItem(title, mnemonic, accelerator, enablementKey);
        ((UIMenuItem)item).setIsHelp(true);
        UIHelp.getInstance().enableHelpOnButton(item, helpID);
        return item;
    }

    public static JMenuItem createHelpItem(String title, char mnemonic, KeyStroke accelerator, String[] enablementKey, String helpID) {
        JMenuItem item = UIMenu.createMenuItem(title, mnemonic, accelerator, enablementKey);
        ((UIMenuItem)item).setIsHelp(true);
        UIHelp.getInstance().enableHelpOnButton(item, helpID);
        return item;
    }

    public UIMenu(String title) {
        this.getAccessibleContext().setAccessibleName(MENU_NAME);
        this.getAccessibleContext().setAccessibleDescription(MENU_DESC);
        UIButton.setButtonText(this, title);
    }

    public UIMenu(String title, char dftMnemonic) {
        this.getAccessibleContext().setAccessibleName(MENU_NAME);
        this.getAccessibleContext().setAccessibleDescription(MENU_DESC);
        UIButton.setButtonText((AbstractButton)this, title, dftMnemonic);
    }

    public UIMenu[] getSubMenus() {
        Vector<Component> v = new Vector<Component>();
        Component[] c = this.getMenuComponents();
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof UIMenu)) continue;
            v.add(c[i]);
        }
        return v.toArray(new UIMenu[v.size()]);
    }

    public JMenuItem add(JMenuItem item) {
        super.add(item);
        if (item instanceof UIMenu && ((UIMenu)item).hideIfEmpty()) {
            this.installPopupListener();
        }
        return item;
    }

    private void installPopupListener() {
        if (this.popupMenuListener == null) {
            this.popupMenuListener = new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent pe) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent pe) {
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent pe) {
                    UIMenu[] m = UIMenu.this.getSubMenus();
                    for (int i = 0; i < m.length; ++i) {
                        if (!m[i].hideIfEmpty()) continue;
                        m[i].setVisible(!m[i].isEmpty());
                    }
                }
            };
            this.getPopupMenu().addPopupMenuListener(this.popupMenuListener);
        }
    }

    public void setHideIfEmpty(boolean flag) {
        this.hideIfEmpty = flag;
    }

    public boolean hideIfEmpty() {
        return this.hideIfEmpty;
    }

    public boolean isEmpty() {
        Component[] c = this.getMenuComponents();
        for (int i = 0; i < c.length; ++i) {
            UIMenu m;
            if (!(c[i] instanceof UIMenu ? !(m = (UIMenu)c[i]).hideIfEmpty() || !m.isEmpty() : c[i] instanceof UIMenuItem)) continue;
            return false;
        }
        return true;
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (this.preSeparator != null) {
            this.preSeparator.setVisible(flag);
        }
        if (this.postSeparator != null) {
            this.postSeparator.setVisible(flag);
        }
    }

    public void setPreSeparator(boolean s) {
        if (s) {
            if (this.preSeparator == null) {
                this.preSeparator = new JPopupMenu.Separator();
            }
        } else {
            this.preSeparator = null;
        }
    }

    public JSeparator getPreSeparator() {
        return this.preSeparator;
    }

    public void setPostSeparator(boolean s) {
        if (s) {
            if (this.postSeparator == null) {
                this.postSeparator = new JPopupMenu.Separator();
            }
        } else {
            this.postSeparator = null;
        }
    }

    public JSeparator getPostSeparator() {
        return this.postSeparator;
    }

    public void addSeparator(JSeparator sep) {
        if (sep != null) {
            this.add(sep);
        }
    }

    public static class UIMenuButton
    extends UIButton {
        public UIMenuButton(String iconName, String toolTip) {
            super(UIIcons.getImageIconFor(iconName));
            this.putClientProperty("hideActionText", Boolean.TRUE);
            this.setToolTipText(toolTip);
            this.setEnabled(true);
        }

        public void setToolTipText(String t) {
            if (t != null) {
                int p = UIButton.getIndexOfMnemonic(t);
                String tt = p >= 0 ? t.substring(p + 1) : t;
                super.setToolTipText(tt);
            }
        }
    }

    public static class UIMenuItem
    extends JMenuItem {
        private JMenuItem master = null;
        private boolean isHelp = false;
        private JSeparator preSeparator = null;
        private JSeparator postSeparator = null;

        public UIMenuItem(JMenuItem mi) {
            this.master = mi;
            this.getAccessibleContext().setAccessibleName(MENU_ITEM_NAME);
            this.getAccessibleContext().setAccessibleDescription(MENU_ITEM_DESC);
            this.setText(this.master.getText());
            if (this.master.getIcon() != null) {
                this.setIcon(this.master.getIcon());
            }
            this.setEnabled(this.master.isEnabled());
        }

        public UIMenuItem(String title, char dftMnemonic, Icon icon) {
            this(title, dftMnemonic, icon, false);
        }

        public UIMenuItem(String title, char dftMnemonic, Icon icon, boolean isHelp) {
            this.getAccessibleContext().setAccessibleName(MENU_ITEM_NAME);
            this.getAccessibleContext().setAccessibleDescription(MENU_ITEM_DESC);
            UIButton.setButtonText((AbstractButton)this, title, dftMnemonic);
            if (icon != null) {
                this.setIcon(icon);
            }
            this.setIsHelp(isHelp);
            this.setEnabled(true);
        }

        public void setIsHelp(boolean state) {
            this.isHelp = state;
        }

        public void setPreSeparator(boolean s) {
            if (s) {
                if (this.preSeparator == null) {
                    this.preSeparator = new JPopupMenu.Separator();
                }
            } else {
                this.preSeparator = null;
            }
        }

        public JSeparator getPreSeparator() {
            return this.preSeparator;
        }

        public void setPostSeparator(boolean s) {
            if (s) {
                if (this.postSeparator == null) {
                    this.postSeparator = new JPopupMenu.Separator();
                }
            } else {
                this.postSeparator = null;
            }
        }

        public JSeparator getPostSeparator() {
            return this.postSeparator;
        }

        public void setVisible(boolean flag) {
            super.setVisible(flag);
            if (this.preSeparator != null) {
                this.preSeparator.setVisible(flag);
            }
            if (this.postSeparator != null) {
                this.postSeparator.setVisible(flag);
            }
        }

        public void resetMasterEnabled() {
            if (this.master != null) {
                boolean masterEnabled = this.master.isEnabled();
                if (super.isEnabled() != masterEnabled) {
                    this.setEnabled(masterEnabled);
                }
            }
        }

        protected void fireActionPerformed(ActionEvent ae) {
            if (this.master != null) {
                if (this.master instanceof UIMenuItem) {
                    ((UIMenuItem)this.master).invoke();
                } else {
                    this.master.doClick();
                }
            } else if (this.isHelp) {
                String helpId = CSH.getHelpIDString((Component)this);
                if (UIHelp.getInstance().isHelpValid(this, helpId)) {
                    String cmd = this.getActionCommand();
                    UIHelpButton helpButton = helpId.equals("UsingHelp") ? UIHelp.usingHelpHiddenButton : UIHelp.contentHiddenButton;
                    ActionEvent aEvent = new ActionEvent(helpButton, 1001, cmd);
                    CSH.DisplayHelpFromSource cshdh = new CSH.DisplayHelpFromSource(UIHelp.getInstance().getHelpBroker());
                    cshdh.actionPerformed(aEvent);
                }
            } else {
                super.fireActionPerformed(ae);
            }
        }

        public void invoke() {
            String cmd = this.getActionCommand();
            ActionEvent ae = new ActionEvent(this, 1001, cmd);
            this.fireActionPerformed(ae);
        }
    }
}

