/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.appc.AppClientJarFileInspector;
import com.sun.enterprise.tools.deployment.ui.ejb.EjbJarGeneralInspector;
import com.sun.enterprise.tools.deployment.ui.rar.ConnectorRARGeneralInspector;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleContent;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.StringTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIJarPackager;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.tools.deployment.ui.war.WebAppGeneralInspector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;

public class UIJarPackagerBox
extends UIControlButtonBox
implements ActionListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIJarPackagerBox.class);
    private static final String CONTENTS = localStrings.getLocalString("ui.uijarpackagerbox.title", "Contents:");
    private static final String OKTODEL_CONTENTS = localStrings.getLocalString("ui.uijarpackagerbox.oktodelete_contents_msg", "Are you sure you want to delete selected contents?");
    private static final String DELETE_CONTENTS = localStrings.getLocalString("ui.uijarpackagerbox.oktodelete_contents_title", "Delete contents");
    private UpdateListener inspector = null;
    private BundleDescriptor bundleDescriptor = null;
    private Object startingDirLoc = null;
    private UIJarPackager jarPackager = null;
    private UIJarPackager.PackagerTreeViewInterface contentsView = null;

    private static String ERR_ADDING_CONTENT(Object v0) {
        return localStrings.getLocalString("ui.uijarpackagerbox.error_adding_content", "There was an error while adding content to this module.\nA helper class may be missing.\n {0}", new Object[]{v0});
    }

    public UIJarPackagerBox(UpdateListener inspector, String type, boolean hasBorder) {
        this(CONTENTS, inspector, type, hasBorder);
    }

    public UIJarPackagerBox(String title, UpdateListener inspector, String type, boolean hasBorder) {
        super(title, hasBorder);
        this.inspector = inspector;
        this.jarPackager = UIJarPackager.newBrowser(this, type);
        this.contentsView = this.jarPackager.getDestinationTreeView();
        this.setView((JPanel)((Object)this.contentsView));
        UIButton editPB = UIButton.createEditContentsButton(this, true);
        editPB.setText("      " + editPB.getText() + "      ");
        this.addControlButton(editPB);
        this.contentsView.getTree().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UIJarPackagerBox.this.actionPerformed(new ActionEvent(this, 1, "edit"));
                }
            }
        });
    }

    public void setContents(BundleDescriptor bd, Object archLoc, ModuleContent classes, ModuleContent files) {
        if (bd == null) {
            Print.printStackTrace((String)"BundleDescription should not be null");
        }
        if (archLoc != null && !(archLoc instanceof Descriptor) && !(archLoc instanceof File)) {
            Print.printStackTrace((String)("Invalid archive location class " + UIUtils.debugClassName(archLoc)));
            archLoc = null;
        }
        UIProject.getProject((Descriptor)bd);
        this.bundleDescriptor = bd;
        Object object = this.startingDirLoc = archLoc != null ? archLoc : bd;
        if (this.inspector.isWizardMode()) {
            try {
                Map h = files != null ? files.getEntryNameMap() : new HashMap();
                this.contentsView.updateTreeView(h, this.bundleDescriptor);
            }
            catch (Throwable t) {
                Print.printStackTrace((String)"Updating Contents View", (Throwable)t);
            }
        } else {
            this.contentsView.updateTreeView(this.bundleDescriptor);
        }
    }

    public void setContents(BundleDescriptor bd, ModuleContent classes, ModuleContent files) {
        this.setContents(bd, null, classes, files);
    }

    public void setContents(BundleDescriptor bd) {
        this.setContents(bd, null, null, null);
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        super.setButtonsEnabled(!state);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("edit")) {
            File homeDir;
            File archDir;
            File archFile;
            Object src = this.contentsView.getTreeViewSource();
            Object alt = this.contentsView.getTreeViewAltSource();
            String name = this.bundleDescriptor != null ? this.bundleDescriptor.getDisplayName() : null;
            this.jarPackager.setDestination(src, name);
            this.jarPackager.setAlternateDestination(alt);
            Vector startDirs = null;
            if (this.startingDirLoc instanceof File) {
                startDirs = new Vector();
            } else {
                Object[] dirs = UIProject.getAllArchivePaths((Descriptor)this.startingDirLoc);
                startDirs = ListTools.toList(dirs);
            }
            File file = archFile = this.bundleDescriptor != null ? ModuleArchive.getArchiveFile((Descriptor)this.bundleDescriptor) : null;
            if (archFile != null && (archDir = archFile.getParentFile()) != null && !startDirs.contains(archDir)) {
                startDirs.add(0, archDir);
            }
            if (this.inspector.isWizardMode()) {
                File appFile;
                ModuleArchive modArch;
                String loc = null;
                String ext = "";
                if (this.inspector instanceof AppClientJarFileInspector) {
                    loc = ((AppClientJarFileInspector)this.inspector).getFileLocation();
                    ext = ".jar";
                } else if (this.inspector instanceof EjbJarGeneralInspector) {
                    loc = ((EjbJarGeneralInspector)this.inspector).getFileLocation();
                    ext = ".jar";
                } else if (this.inspector instanceof ConnectorRARGeneralInspector) {
                    loc = ((ConnectorRARGeneralInspector)this.inspector).getFileLocation();
                    ext = ".rar";
                } else if (this.inspector instanceof WebAppGeneralInspector) {
                    loc = ((WebAppGeneralInspector)this.inspector).getFileLocation();
                    ext = ".war";
                }
                if (!StringTools.isEmpty(loc)) {
                    File tp = new File(loc);
                    if (loc.toLowerCase().endsWith(ext)) {
                        tp = tp.getParentFile();
                    }
                    if (tp != null && !startDirs.contains(tp)) {
                        startDirs.add(tp);
                    }
                }
                if (this.startingDirLoc instanceof Descriptor && (modArch = ModuleArchive.getModuleArchive((Descriptor)this.startingDirLoc)) != null && modArch.getArchiveFile() != null && (appFile = modArch.getArchiveFile().getParentFile()) != null && !startDirs.contains(appFile)) {
                    startDirs.add(appFile);
                }
            }
            if (!startDirs.contains(homeDir = UIConfig.getHomeDirectory())) {
                startDirs.add(homeDir);
            }
            if (this.jarPackager.showBrowser(startDirs.toArray(new File[startDirs.size()]))) {
                ModuleContent conFcd = this.jarPackager.getContentsDescriptor();
                Vector delCon = this.jarPackager.getRemovedContents();
                try {
                    this.inspector.addContentsAction(null, conFcd, delCon);
                }
                catch (Throwable t) {
                    Print.printStackTrace((String)"Adding Contents", (Throwable)t);
                    UIOptionPane.showErrorDialog(this, UIJarPackagerBox.ERR_ADDING_CONTENT(t.toString()));
                }
            }
        }
    }

    public static interface UpdateListener {
        public boolean isWizardMode();

        public void addContentsAction(ModuleContent var1, ModuleContent var2, Vector var3) throws IOException;
    }
}

