/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UIInvocationEvent;
import com.sun.enterprise.util.Print;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.Stack;

public class UIEventQueue
extends EventQueue {
    private static final long BUSY_CURSOR_DELAY = 1750L;
    private static final long CLEAR_CURSOR_DELAY = 200L;
    private int dispatchLevel = 0;
    private static UIEventQueue eventQueue = null;
    private static long eventCounter = 0L;
    private static AWTEvent lastEvent = null;
    private static Stack busyStack = new Stack();

    public static EventQueue getSystemEventQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueue();
    }

    public static void invokeLater(Runnable r) {
        UIEventQueue.getSystemEventQueue().postEvent(new UIInvocationEvent(r));
    }

    public static void invokeAndWait(Runnable r) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(r);
    }

    public static boolean isInvokeLaterPending() {
        return UIEventQueue.eventExists(16000);
    }

    public static boolean isFocusLostPending() {
        return UIEventQueue.eventExists(1005);
    }

    public static boolean eventExists(int id) {
        AWTEvent ev = UIEventQueue._peekEvent(id);
        return ev != null;
    }

    public static UIInvocationEvent peekInvocationEvent() {
        AWTEvent ev = UIEventQueue._peekEvent(16000);
        return ev instanceof UIInvocationEvent ? (UIInvocationEvent)ev : null;
    }

    private static AWTEvent _peekEvent(int id) {
        EventQueue eq = eventQueue != null ? eventQueue : UIEventQueue.getSystemEventQueue();
        return eq.peekEvent(id);
    }

    public static void installEventQueue() {
        if (eventQueue == null) {
            eventQueue = new UIEventQueue();
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(eventQueue);
        } else {
            Print.dprintStackTrace((String)"UIEventQueue already installed");
        }
    }

    private UIEventQueue() {
    }

    public AWTEvent getNextEvent() throws InterruptedException {
        return super.getNextEvent();
    }

    public static long count() {
        return eventCounter;
    }

    public static AWTEvent lastEvent() {
        return lastEvent;
    }

    protected void dispatchEvent(AWTEvent e) {
        ++eventCounter;
        ++this.dispatchLevel;
        UIEventQueue.pingCurrentBusyCursor();
        try {
            lastEvent = e;
            super.dispatchEvent(e);
        }
        catch (Throwable t) {
            Print.dprintln((String)("DispatchLevel == " + this.dispatchLevel));
            Print.printStackTrace(null, (Throwable)t);
        }
        --this.dispatchLevel;
        UIEventQueue.pingCurrentBusyCursor();
    }

    public static boolean pushBusyCursor(Window win) {
        if (eventQueue != null) {
            eventQueue._pushBusyCursor(win);
            return true;
        }
        Print.dprintln((String)"No global UIEventQueue is installed");
        return false;
    }

    private void _pushBusyCursor(Window win) {
        UIBusyCursor bc = new UIBusyCursor(win, this);
        busyStack.push(bc);
        bc.startBusyCursor();
    }

    public static boolean popBusyCursor(Window win) {
        if (eventQueue == null) {
            Print.dprintln((String)"No global UIEventQueue is running");
            return false;
        }
        UIBusyCursor bc = UIEventQueue.getCurrentBusyCursor();
        if (bc != null && bc.getTargetWindow() == win) {
            Print.dprintln((String)"Stopping BusyCursor ...");
            bc.stopBusyCursor();
            busyStack.pop();
            return true;
        }
        Print.dprintln((String)"Invalid target-window specified");
        return false;
    }

    private static UIBusyCursor getCurrentBusyCursor() {
        return !busyStack.empty() ? (UIBusyCursor)busyStack.peek() : null;
    }

    private static void pingCurrentBusyCursor() {
        UIBusyCursor bc = UIEventQueue.getCurrentBusyCursor();
        if (bc != null) {
            bc.pingTimer();
        }
    }

    private static class UIBusyCursor
    extends Thread {
        private Cursor waitCursor = Cursor.getPredefinedCursor(3);
        private Cursor savedCursor = null;
        private boolean notified = false;
        private int sleepMethod = 1;
        private Window targetWindow = null;
        private UIEventQueue evQue = null;
        private boolean isRunning = false;
        private int processLevel = -1;

        public UIBusyCursor(Window targetWindow, UIEventQueue evQ) {
            this.targetWindow = targetWindow;
            this.evQue = evQ;
            this.processLevel = this.evQue.dispatchLevel;
            this.isRunning = false;
        }

        public void startBusyCursor() {
            this.isRunning = true;
            this.start();
        }

        public void stopBusyCursor() {
            this.isRunning = false;
            this.pingTimer();
        }

        public Window getTargetWindow() {
            return this.targetWindow;
        }

        public boolean isRunning() {
            if (!this.targetWindow.isVisible()) {
                this.isRunning = false;
            }
            return this.isRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long vs = 250L;
            long mvw2 = 3000L / vs;
            while (!this.targetWindow.isVisible()) {
                if (!this.isRunning || mvw2 <= 0L) {
                    Print.dprintln((String)"TargetWindow never became visible");
                    return;
                }
                try {
                    Thread.sleep(vs);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                --mvw2;
            }
            Print.dprintln((String)"BusyCursor Started");
            long watchdogDelay = 500L;
            while (this.isRunning()) {
                while (this.isRunning()) {
                    try {
                        if (this.sleepMethod == 0) {
                            Thread.sleep(watchdogDelay);
                            break;
                        }
                        UIBusyCursor mvw2 = this;
                        synchronized (mvw2) {
                            this.notified = false;
                            this.wait(watchdogDelay);
                            if (!this.notified) {
                                break;
                            }
                        }
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (this.evQue.dispatchLevel != this.processLevel) continue;
                }
                if (this.isRunning() && this.evQue.dispatchLevel > this.processLevel) {
                    Cursor c;
                    if (this.savedCursor != null || (c = this.targetWindow.getCursor()).getName().equals(this.waitCursor.getName())) continue;
                    this.savedCursor = c;
                    this.targetWindow.setCursor(this.waitCursor);
                    watchdogDelay = 200L;
                    continue;
                }
                if (this.savedCursor == null) continue;
                this.targetWindow.setCursor(this.savedCursor);
                this.savedCursor = null;
                watchdogDelay = 500L;
            }
            Print.dprintln((String)"BusyCursor Stopped");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pingTimer() {
            if (this.sleepMethod == 0) {
                super.interrupt();
            } else {
                UIBusyCursor uIBusyCursor = this;
                synchronized (uIBusyCursor) {
                    this.notified = true;
                    this.notify();
                }
            }
        }
    }
}

