/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.utils.UIEventQueue;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public class UIDialog
extends JDialog
implements DescriptionInspector.DescriptionInspectorManager {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIDialog.class);
    private static String DIALOG_NAME = localStrings.getLocalString("ui.uidialog.dialog_name", "Dialog box");
    private static String DIALOG_DESC = localStrings.getLocalString("ui.uidialog.dialog_desc", "This is a dialog box waiting for your action");
    private static String PLEASE_USE_CLOSE = localStrings.getLocalString("ui.uidialog.please_use_close", "To close this window, please use the dialog buttons provided.");
    private static int DISMISS_UNDEF = 0;
    private static int DISMISS_HIDE = 1;
    private static int DISMISS_DISPOSE = 2;
    private static int DISMISS_INVISIBLE = 3;
    private boolean disposeOnHide = false;
    private boolean isDisposed = false;
    private int dismissMethod = DISMISS_UNDEF;
    private int isHiding = 0;
    private int isDisposing = 0;
    private int isShowing = 0;
    private Dimension preferredSize = null;
    private boolean installBusyCursor = false;
    private static Hashtable dialogCache = null;
    private static final Object NullKey = new Object();
    private UITitledBox contentBox = null;
    private WindowAdapter defaultWindowClosingAction = null;
    private DescriptionInspector _UIDialog_descInspector = null;

    protected static UIDialog newDialog(DialogFactory factory, Component owner, boolean modal) {
        return factory.newInstance(WinTools.getAncestorWindow(owner), modal);
    }

    public static UIDialog newDialog(Component ownerComp, boolean modal) {
        return UIDialog.newDialog(new DialogFactoryImpl(), ownerComp, modal);
    }

    public static UIDialog getDialog(Object key, Class dialogClass) {
        Hashtable keyCache;
        if (dialogCache != null && (keyCache = (Hashtable)dialogCache.get(dialogClass)) != null) {
            return (UIDialog)keyCache.get(key != null ? key : NullKey);
        }
        return null;
    }

    public static void putDialog(Object key, UIDialog dialog) {
        Hashtable<Object, UIDialog> keyCache;
        Class<?> dialogClass = dialog.getClass();
        if (dialogCache == null) {
            dialogCache = new Hashtable();
        }
        if ((keyCache = (Hashtable<Object, UIDialog>)dialogCache.get(dialogClass)) == null) {
            keyCache = new Hashtable<Object, UIDialog>();
            dialogCache.put(dialogClass, keyCache);
        }
        keyCache.put(key != null ? key : NullKey, dialog);
    }

    public static void removeDialog(Object key, UIDialog dialog) {
        Class<?> dialogClass;
        Hashtable keyCache;
        if (dialogCache != null && (keyCache = (Hashtable)dialogCache.get(dialogClass = dialog.getClass())) != null) {
            keyCache.remove(key != null ? key : NullKey);
            if (keyCache.isEmpty()) {
                dialogCache.remove(dialogClass);
            }
        }
    }

    public static void removeDialog(UIDialog dialog) {
        Class<?> dialogClass;
        Hashtable keyCache;
        if (dialogCache != null && (keyCache = (Hashtable)dialogCache.get(dialogClass = dialog.getClass())) != null) {
            Enumeration kEnum = keyCache.keys();
            while (kEnum.hasMoreElements()) {
                Object key = kEnum.nextElement();
                UIDialog d = (UIDialog)keyCache.get(key);
                if (d != dialog) continue;
                keyCache.remove(key);
            }
            if (keyCache.isEmpty()) {
                dialogCache.remove(dialogClass);
            }
        }
    }

    private UIDialog() {
    }

    protected UIDialog(Dialog win, boolean modal) {
        super(win, modal);
        this._uiDialogInit();
    }

    public UIDialog(Dialog win, String title, boolean modal) {
        super(win, title, modal);
        this._uiDialogInit();
    }

    protected UIDialog(Frame win, boolean modal) {
        super(win, modal);
        this._uiDialogInit();
    }

    public UIDialog(Frame win, String title, boolean modal) {
        super(win, title, modal);
        this._uiDialogInit();
    }

    private void _uiDialogInit() {
        this.setContentBox(new UITitledBox(null, false));
        this.doNothingOnClose();
        this.setDefaultCancelAction();
    }

    public void setContentPane(Container content) {
        super.setContentPane(content);
        this.contentBox = null;
    }

    public Container getContentPane() {
        return this.contentBox != null ? this.contentBox : super.getContentPane();
    }

    public void setContentBox(UITitledBox box) {
        if (this.contentBox != null) {
            super.getContentPane().remove(this.contentBox);
        }
        this.contentBox = box;
        if (this.contentBox != null) {
            super.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 0.5;
            c.weighty = 0.5;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(5, 5, 5, 5);
            c.fill = 1;
            c.anchor = 10;
            super.getContentPane().add((Component)this.contentBox, c);
        }
    }

    public UITitledBox getContentBox() {
        if (this.contentBox != null) {
            return this.contentBox;
        }
        Container c = super.getContentPane();
        return c instanceof UITitledBox ? (UITitledBox)c : null;
    }

    public void doNothingOnClose() {
        this.setDefaultCloseOperation(0);
        if (this.defaultWindowClosingAction == null) {
            this.defaultWindowClosingAction = new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    Print.dprintln((String)"Window Closing ...");
                    UIOptionPane.showWarningDialog(UIDialog.this, PLEASE_USE_CLOSE);
                }
            };
            super.addWindowListener(this.defaultWindowClosingAction);
        }
    }

    public void addWindowListener(WindowListener winList) {
        if (winList == null) {
            return;
        }
        if (winList == this.defaultWindowClosingAction) {
            return;
        }
        super.addWindowListener(winList);
    }

    public void setWindowClosingAction(final ActionListener listener) {
        this.setDefaultCloseOperation(0);
        if (listener != null) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    listener.actionPerformed(new ActionEvent(UIDialog.this, 1001, "windowClosing"));
                }
            });
        }
    }

    public void setDisposeOnHide(boolean disposeOnHide) {
        this.disposeOnHide = disposeOnHide;
    }

    public boolean getDisposeOnHide() {
        return this.disposeOnHide;
    }

    public void setEnableBusyCursor(boolean enableBusyCursor) {
        this.installBusyCursor = enableBusyCursor;
    }

    protected void _showDialog() {
        ++this.isShowing;
        boolean modal = this.isModal();
        super.show();
        if (modal && this.dismissMethod == DISMISS_UNDEF) {
            Print.dprintStackTrace((String)"This dialog was dimissed without calling hide()/dismiss()/setVisible(false)!");
        }
        --this.isShowing;
    }

    protected void _hideDialog() {
        ++this.isHiding;
        if (this.disposeOnHide) {
            this._disposeDialog();
        } else {
            this.dismissMethod = DISMISS_HIDE;
            super.hide();
        }
        --this.isHiding;
    }

    protected void _disposeDialog() {
        ++this.isDisposing;
        this.dismissMethod = DISMISS_DISPOSE;
        super.dispose();
        UIDialog.removeDialog(this);
        --this.isDisposing;
        this.isDisposed = true;
    }

    public void setVisible(boolean visible) {
        if (this.isShowing > 0 || this.isHiding > 0) {
            Print.dprintln((int)1, (String)"Recursive 'setVisible' detected");
            if (!visible) {
                this.dismissMethod = DISMISS_INVISIBLE;
            }
            super.setVisible(visible);
        } else if (visible) {
            this.show();
        } else {
            this.hide();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        if (this.isDisposed) {
            Print.printStackTrace((String)"Dialog has already been disposed");
        } else if (this.installBusyCursor) {
            UIEventQueue.pushBusyCursor(this);
            try {
                this._showDialog();
            }
            finally {
                UIEventQueue.popBusyCursor(this);
            }
        } else {
            this._showDialog();
        }
    }

    public void hide() {
        if (this.isHiding > 0) {
            if (this.isDisposing == 0) {
                Print.dprintln((int)1, (String)"Recursive 'hide' detected");
            }
            this.dismissMethod = DISMISS_HIDE;
            super.hide();
        } else {
            this._hideDialog();
        }
    }

    public void dispose() {
        if (this.isHiding > 0) {
            Print.dprintln((int)1, (String)"Recursive 'dispose' detected");
            this._disposeDialog();
        } else {
            this.disposeOnHide = true;
            this._hideDialog();
        }
    }

    public void centerOnScreen() {
        Dimension d = this.getToolkit().getScreenSize();
        Rectangle r = this.getBounds();
        int x = (d.width - r.width) / 2;
        int y = (d.height - r.height) / 2;
        this.setLocation(x, y);
    }

    public void setLocationRelativeToOwner() {
        this.setLocationRelativeTo(this.getOwner());
    }

    public void setLocationRelativeToOwner(int ofsX, int ofsY) {
        Window w = WinTools.getAncestorWindow(this.getOwner());
        if (w != null) {
            Point p = w.getLocation();
            this.setLocation(p.x + ofsX, p.y + ofsY);
        }
    }

    public void setPreferredSize(Dimension dim) {
        if (dim != null) {
            this.preferredSize = dim;
        } else {
            Rectangle b = this.getBounds();
            this.preferredSize = new Dimension(b.width, b.height);
        }
    }

    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    public void setPreferredWidth(int width) {
        Dimension dim = this.getPreferredSize();
        this.setPreferredSize(new Dimension(width, dim.height));
    }

    public void setPreferredHeight(int height) {
        Dimension dim = this.getPreferredSize();
        this.setPreferredSize(new Dimension(dim.width, height));
    }

    public Dimension getPreferredSize() {
        Dimension dim = this.preferredSize;
        return dim != null ? dim : super.getPreferredSize();
    }

    public DescriptionInspector getDescriptionInspector() {
        if (this._UIDialog_descInspector == null) {
            this._UIDialog_descInspector = new DescriptionInspector(this);
        }
        return this._UIDialog_descInspector;
    }

    private void setDefaultCancelAction() {
        ActionMap am = this.getRootPane().getActionMap();
        InputMap im = this.getRootPane().getInputMap(2);
        Object cancel = new Object();
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                UIDialog.this.cancelAction();
            }
        };
        im.put(esc, cancel);
        am.put(cancel, cancelAction);
    }

    protected void cancelAction() {
    }

    private static class DialogFactoryImpl
    implements DialogFactory {
        public UIDialog newInstance(Window win, boolean modal) {
            if (win instanceof Dialog) {
                UIDialog ud = new UIDialog((Dialog)win, modal);
                ud.getAccessibleContext().setAccessibleName(DIALOG_NAME);
                ud.getAccessibleContext().setAccessibleDescription(DIALOG_DESC);
                return ud;
            }
            if (win instanceof Frame) {
                UIDialog ud = new UIDialog((Frame)win, modal);
                ud.getAccessibleContext().setAccessibleName(DIALOG_NAME);
                ud.getAccessibleContext().setAccessibleDescription(DIALOG_DESC);
                return ud;
            }
            UIDialog ud = new UIDialog((Frame)null, modal);
            ud.getAccessibleContext().setAccessibleName(DIALOG_NAME);
            ud.getAccessibleContext().setAccessibleDescription(DIALOG_DESC);
            return ud;
        }
    }

    public static interface DialogFactory {
        public UIDialog newInstance(Window var1, boolean var2);
    }
}

