/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;

public class UICheckBox
extends JCheckBox {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UICheckBox.class);
    private boolean isReadOnly = false;
    private boolean clearWhenDisabled = false;
    private Boolean lastEnabledSelection = null;
    private boolean lastEnabledState = true;

    public UICheckBox() {
        this.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.uicheckbox.cbox_name", "Check Box"));
        this.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.uicheckbox.cbox_desc", "This is a check box"));
    }

    public UICheckBox(String title) {
        this();
        this.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.uicheckbox.cbox_name", "{0}", new Object[]{title}));
        this.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.uicheckbox.cbox_desc", "This is a check box for {0}", new Object[]{title}));
        UIButton.setButtonText(this, title);
    }

    public UICheckBox(String title, char dftMnemonic) {
        this();
        this.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.uicheckbox.cbox_name", "{0}", new Object[]{title}));
        this.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.uicheckbox.cbox_desc", "This is a check box for {0}", new Object[]{title}));
        UIButton.setButtonText((AbstractButton)this, title, dftMnemonic);
    }

    public UICheckBox(Icon icon) {
        super(icon);
        this.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.uicheckbox.cbox_name", "Check Box"));
        this.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.uicheckbox.cbox_desc", "This is a check box"));
    }

    public UICheckBox(String title, String ac, ActionListener al) {
        this(title);
        this.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.uicheckbox.cbox_name", "{0}", new Object[]{title}));
        this.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.uicheckbox.cbox_desc", "This is a check box for {0}", new Object[]{title}));
        if (ac != null) {
            this.setActionCommand(ac);
        }
        if (al != null) {
            this.addActionListener(al);
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean state) {
        this.isReadOnly = state;
        if (this.isReadOnly) {
            if (this.isEnabled()) {
                super.setEnabled(false);
            }
        } else {
            super.setEnabled(this.lastEnabledState);
        }
    }

    public void setClearWhenDisabled(boolean clear) {
        this.clearWhenDisabled = clear;
    }

    public void setEnabled(boolean enable) {
        this.lastEnabledState = enable;
        super.setEnabled(enable && !this.isReadOnly());
        if (this.clearWhenDisabled) {
            if (!enable && this.lastEnabledSelection == null) {
                this.lastEnabledSelection = new Boolean(super.isSelected());
                super.setSelected(false);
            } else if (enable && this.lastEnabledSelection != null) {
                super.setSelected(this.lastEnabledSelection);
                this.lastEnabledSelection = null;
            }
        }
    }

    public void setSelected(boolean sel) {
        if (this.clearWhenDisabled) {
            if (!this.lastEnabledState) {
                this.lastEnabledSelection = new Boolean(sel);
            } else {
                super.setSelected(sel);
            }
        } else {
            super.setSelected(sel);
        }
    }

    public boolean isSelected() {
        return this.clearWhenDisabled && !this.lastEnabledState && this.lastEnabledSelection != null ? this.lastEnabledSelection.booleanValue() : super.isSelected();
    }

    public void setAccessibleDescription(String text) {
        this.getAccessibleContext().setAccessibleDescription(text);
    }
}

