/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.utils.DTClassLoader;
import com.sun.enterprise.tools.deployment.ui.utils.TestHarness;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfigProperties;
import com.sun.enterprise.tools.deployment.ui.utils.UIEventQueue;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.util.Print;
import java.io.File;

public class TestHarnessInit {
    private static boolean testHarnessInit = false;
    private static TestHarness testHarness = null;

    private static TestHarness getTestHarness() {
        if (!testHarnessInit) {
            testHarnessInit = true;
            UIConfigProperties cfgProps = new UIConfigProperties();
            File cfgFile = new File(UIConfig.getConfigDirectory(), "testharness.conf");
            try {
                cfgProps.loadFile(cfgFile);
                cfgProps.setConfigFile(cfgFile);
            }
            catch (Exception ex) {
                Print.println((String)("Error: " + ex));
                Print.println((String)("Unable to load config: " + cfgFile));
                return null;
            }
            String className = cfgProps.getProperty("ui.testHarness.class");
            if (className == null) {
                className = "com.sun.enterprise.tools.deployment.ui.script.TestHarnessImpl";
            }
            DTClassLoader scriptClassLoader = new DTClassLoader(DT.class.getClassLoader());
            String[] classpath = cfgProps.getStringArray("ui.testHarness.classpath");
            if (classpath != null) {
                StringBuffer sb = new StringBuffer("TestHarness ClassPath: ");
                for (int i = 0; i < classpath.length; ++i) {
                    sb.append(classpath[i]).append("  ");
                }
                Print.println((String)sb.toString());
                scriptClassLoader.addFiles(classpath);
            }
            Class testHarnessClass = null;
            try {
                testHarnessClass = scriptClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            if (testHarnessClass != null) {
                Print.println((String)("Instantiating TestHarness instance: " + className));
                try {
                    testHarness = (TestHarness)testHarnessClass.newInstance();
                    testHarness.setClassLoader(scriptClassLoader);
                }
                catch (Throwable t) {
                    Print.println((String)"ERROR: Unable to instantiate TestHarness.");
                    Print.println((String)t.toString());
                }
            } else {
                Print.println((String)("TestHarness Class not found: " + className));
            }
        }
        return testHarness;
    }

    public static String[] getScriptMenuNames() {
        TestHarness th = TestHarnessInit.getTestHarness();
        return th != null ? th.getScriptMenuNames() : null;
    }

    public static void scriptInitialization() {
        String startup;
        TestHarness th = TestHarnessInit.getTestHarness();
        if (th != null && (startup = th.getStartupScript()) != null && !startup.equals("")) {
            UIEventQueue.invokeLater(new UIActionDispatcher((Object)TestHarnessInit.class, "runStartupScript", (Object)new Object[]{startup}));
        }
    }

    public static void runStartupScript(String name) {
        TestHarnessInit.runScriptAction(name, false);
    }

    public static void runScriptAction(String name) {
        TestHarnessInit.runScriptAction(name, true);
    }

    public static void runScriptAction(String name, boolean interactive) {
        TestHarness th = TestHarnessInit.getTestHarness();
        if (th != null && (!interactive || UIOptionPane.showConfirmDialog(null, "Continue with Script '" + name + "'?\n" + "(Make sure everything is ready; " + "Server connected, Apps closed, etc.)"))) {
            th.runScript(name, interactive);
        }
    }
}

