/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.utils.ColorTools;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.StringTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class InspectorTable
extends JTable
implements DescriptionInspector.UpdateListener {
    public static final int RIGHT_ALIGN = 1;
    public static final int LEFT_ALIGN = -1;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(InspectorTable.class);
    private static final String TABLE_NAME = localStrings.getLocalString("ui.inspectortable.table_name", "Table");
    private static final String TABLE_DESC = localStrings.getLocalString("ui.inspectortable.table_desc", "This is a table");
    private static final String TABLE_HEADER_NAME = localStrings.getLocalString("ui.inspectortable.table_header_name", "Table Header");
    private static final String TABLE_HEADER_DESC = localStrings.getLocalString("ui.inspectortable.table_header_desc", "This is the table header");
    private static final String LABEL_NAME = localStrings.getLocalString("ui.inspectortable.label_name", "Label");
    private static final String LABEL_DESC = localStrings.getLocalString("ui.inspectortable.label_desc", "This is a label");
    private static final String CBOX_NAME = localStrings.getLocalString("ui.inspectortable.cbox_name", "Inspector Table ComboBox");
    private static final String CBOX_DESC = localStrings.getLocalString("ui.inspectortable.cbox_desc", "This is a ComboBox for inspector table in this window");
    private int descriptionColumn = -1;
    private DescriptionInspector.UpdateListener descUpdateListener = null;
    private boolean handleDescriptionUpdates = false;
    private boolean superDidInitialize = true;
    private boolean isCustomModelSet = false;
    private JTextField tableTextEditor = null;
    private int selectRowOnUpdate_Column = -1;
    private Object selectRowOnUpdate_Value = null;
    private boolean enableHorizontalScrolling = false;
    private UITitledTable tableOwner = null;
    private boolean rightAlign = true;
    private boolean _did_setupInspectorTable = false;
    private boolean _did_setupDescriptionColumn = false;
    private int resizingColumns = 0;
    private Vector updaterList = null;
    private int editMethod = -1;
    private int editingStopped_recursion = 0;
    private InspectorCellRenderer[] delegateRenderers = null;
    public boolean settingSelection = false;
    private static final String JAVA_LANG = "java.lang.";
    private static final String[] primitiveType = new String[]{"java.lang.String", "java.lang.Character", "java.lang.Boolean", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double"};
    private TableCellEditor[] primitiveEditor = new TableCellEditor[primitiveType.length];
    private TableCellEditor primitiveTypeEditor = null;

    public InspectorTable() {
        this.isCustomModelSet = false;
        this._setupInspectorTable();
    }

    public InspectorTable(int alignmentFlag) {
        this();
        this.setAlignment(alignmentFlag);
    }

    public InspectorTable(TableModel model) {
        this(model, false);
    }

    public InspectorTable(TableModel model, int alignmentFlag) {
        this(model);
        this.setAlignment(alignmentFlag);
    }

    public InspectorTable(TableModel model, boolean horizonalScroll) {
        this.setHorizontalScrollingEnabled(horizonalScroll);
        this.setModel(model);
        this._setupInspectorTable();
    }

    private void setAlignment(int flag) {
        if (flag != 1) {
            this.rightAlign = false;
        }
    }

    private void _setupInspectorTable() {
        if (this._did_setupInspectorTable) {
            return;
        }
        this._did_setupInspectorTable = true;
        this.getAccessibleContext().setAccessibleName(TABLE_NAME);
        this.getAccessibleContext().setAccessibleDescription(TABLE_DESC);
        this.tableTextEditor = new UITitledTextField().getTextField();
        this.tableTextEditor.setCursor(Cursor.getPredefinedCursor(2));
        DefaultCellEditor tableEditor = new DefaultCellEditor(this.tableTextEditor);
        this.setDefaultEditor(Object.class, tableEditor);
        this.setDefaultEditor(Integer.class, this.getIntegerEditor(5));
        this.setCellSelectionEnabled(true);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                InspectorTable.this._processMouseClicked(me);
            }
        });
        this._setupDescriptionColumn();
    }

    private void _setupDescriptionColumn() {
        if (this.isCustomModelSet && !this._did_setupDescriptionColumn) {
            TableModel model = this.getModel();
            int colLen = model.getColumnCount();
            for (int c = 0; c < colLen; ++c) {
                String colName = model.getColumnName(c);
                if (!colName.equals(DescriptionInspector.DESCRIPTION_COLUMN_INIT)) continue;
                this.setDescriptionColumn(c);
                break;
            }
            this._did_setupDescriptionColumn = true;
        }
    }

    public InspectorTableModel getInspectorTableModel() {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return (InspectorTableModel)model;
        }
        InspectorTable._printDataModelError();
        return null;
    }

    public boolean isReadOnly() {
        return this.tableOwner != null ? this.tableOwner.isReadOnly() : false;
    }

    public UITitledTable getTableOwner() {
        return this.tableOwner;
    }

    public void setTableOwner(UITitledTable tableOwner) {
        this.tableOwner = tableOwner;
    }

    public boolean isHorizonalScrollingEnabled() {
        return this.enableHorizontalScrolling;
    }

    public void setHorizontalScrollingEnabled(boolean enable) {
        this.enableHorizontalScrolling = enable;
    }

    public int getColumnIndexWithTitle(String title) {
        try {
            return this.getColumnModel().getColumnIndex(title);
        }
        catch (IllegalArgumentException iae) {
            return -1;
        }
    }

    public TableColumn getColumn(int n, boolean realColumn) {
        return n >= 0 && n < this.getColumnCount() ? this.getInspectorColumnModel().getColumn(n, realColumn) : null;
    }

    public TableColumn getColumn(int n) {
        return n >= 0 && n < this.getColumnCount() ? this.getColumnModel().getColumn(n) : null;
    }

    public void adjustColumnWidth(int c, boolean includeEditor) {
        this.adjustColumnWidth(c, null, includeEditor);
    }

    public void adjustColumnWidth(int c, Object templateValue, boolean includeEditor) {
        if (this.isColumnHidden(c)) {
            Print.dprintln((String)("Column is hidden: " + c));
            return;
        }
        TableColumn tc = this.getColumn(c);
        if (tc == null) {
            Print.dprintln((String)("Invalid column index: " + c));
            return;
        }
        int actualWidth = tc.getWidth();
        TableCellRenderer hr = tc.getHeaderRenderer();
        if (hr == null) {
            hr = this.getTableHeader().getDefaultRenderer();
        }
        Component hc = hr.getTableCellRendererComponent(this, tc.getHeaderValue(), false, false, 0, c);
        int prefWidth = hc.getPreferredSize().width;
        if (templateValue != null) {
            TableCellRenderer rend = this.getCellRenderer(0, c);
            Component comp = rend.getTableCellRendererComponent(this, templateValue, false, false, 0, c);
            Dimension ps = comp.getPreferredSize();
            if (ps.width > prefWidth) {
                prefWidth = ps.width;
            }
        }
        for (int r = 0; r < this.getRowCount(); ++r) {
            Object v;
            Component comp;
            TableCellEditor tce;
            if (includeEditor && this.getModel().isCellEditable(r, c) && (tce = this.getCellEditor(r, c)) instanceof DefaultCellEditor && (comp = ((DefaultCellEditor)tce).getComponent()) instanceof JComboBox) {
                Dimension ps = comp.getPreferredSize();
                if (ps.width > prefWidth) {
                    prefWidth = ps.width;
                }
            }
            if ((v = this.getValueAt(r, c)) == null) continue;
            TableCellRenderer rend = this.getCellRenderer(r, c);
            Component comp2 = rend.getTableCellRendererComponent(this, v, false, false, r, c);
            Dimension ps = comp2.getPreferredSize();
            if (ps.width <= prefWidth) continue;
            prefWidth = ps.width;
        }
        prefWidth += 4;
        if (tc instanceof InspectorTableColumn) {
            ((InspectorTableColumn)tc).setAdjustedWidth(prefWidth);
        } else {
            tc.setMinWidth(prefWidth);
            tc.setMaxWidth(prefWidth);
            tc.setPreferredWidth(prefWidth);
        }
    }

    public void setColumnHidden(String title, boolean hide) {
        int n = this.getColumnIndexWithTitle(title);
        if (n < 0) {
            Print.dprintStackTrace((String)("Title not found in table: " + title));
            return;
        }
        this.setColumnHidden(n, hide);
    }

    public void setColumnHidden(int n, boolean hide) {
        this.getInspectorColumnModel().setColumnHidden(n, hide);
    }

    public boolean isColumnHidden(String title) {
        int n = this.getColumnIndexWithTitle(title);
        if (n < 0) {
            Print.dprintStackTrace((String)("Title not found in table: " + title));
            return true;
        }
        return this.isColumnHidden(n);
    }

    public boolean isColumnHidden(int n) {
        return this.getInspectorColumnModel().isColumnHidden(n);
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new InspectorTableColumnModel();
    }

    public InspectorTableColumnModel getInspectorColumnModel() {
        TableColumnModel tcm = super.getColumnModel();
        if (tcm instanceof InspectorTableColumnModel) {
            return (InspectorTableColumnModel)tcm;
        }
        Print.printStackTrace((String)"ColumnModel is not 'InspectorTableColumnModel'");
        return null;
    }

    protected JTableHeader createDefaultTableHeader() {
        return new InspectorTableHeader(this.columnModel);
    }

    public void sizeColumnsToFit(int resizingColumn) {
        ++this.resizingColumns;
        super.sizeColumnsToFit(resizingColumn);
        --this.resizingColumns;
    }

    public void doLayout() {
        ++this.resizingColumns;
        super.doLayout();
        --this.resizingColumns;
    }

    public void setAutoResizeMode(int mode) {
        super.setAutoResizeMode(mode);
    }

    private DescriptionInspector getDescriptionInspector() {
        return DescriptionInspector.findDescriptionInspector(this);
    }

    public int getDescriptionColumn() {
        return this.descriptionColumn;
    }

    public void setDescriptionColumn(int column) {
        if (this.descriptionColumn == column) {
            return;
        }
        if (column < 0) {
            Print.dprintStackTrace((String)"Invalid description column");
        }
        this.descriptionColumn = column;
        DescriptionInspector.setDescriptionColumnForTable(this, column);
        this.descUpdateListener = new DescriptionInspector.UpdateListener(){

            public void descriptionUpdated(String description, Object ref) {
                if (InspectorTable.this.handleDescriptionUpdates) {
                    InspectorTableModel model = (InspectorTableModel)InspectorTable.this.getModel();
                    model.setObjectValue(ref, InspectorTable.this.descriptionColumn, description);
                } else if (ref != null && ref instanceof Descriptor) {
                    ((Descriptor)ref).setDescription(description);
                } else {
                    Print.dprintStackTrace((String)"Description not updated");
                }
            }
        };
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && InspectorTable.this.handleDescriptionUpdates) {
                    InspectorTable.this.showSelectedDescription();
                }
            }
        });
    }

    public void setDescriptionInspector(String description, String refName, DescriptionInspector.UpdateListener listener, Object refObject) {
        this.setDescriptionInspector(description, refName, listener, refObject, this.isReadOnly());
    }

    public void setDescriptionInspector(String description, String refName, DescriptionInspector.UpdateListener listener, Object refObject, boolean readOnly) {
        DescriptionInspector din;
        if (this.updaterList == null || !this.updaterList.contains(listener)) {
            this.updaterList = new Vector();
            this.updaterList.add(this);
            this.updaterList.add(listener);
        }
        if ((din = this.getDescriptionInspector()) != null) {
            din.setDescription(description, refName, this.updaterList, refObject, readOnly);
        }
    }

    public void clearDescriptionInspector() {
        DescriptionInspector din = this.getDescriptionInspector();
        if (din != null) {
            din.clearDescription();
        }
    }

    public void descriptionUpdated(String description, Object refObject) {
        TableModel model = this.getModel();
        if (model instanceof AbstractTableModel) {
            ((AbstractTableModel)model).fireTableCellUpdated(this.getSelectedRow(), this.descriptionColumn);
        }
    }

    public void showSelectedDescription() {
        if (!this.handleDescriptionUpdates) {
            return;
        }
        Object ref = this.getSelectedRowObject();
        if (ref != null) {
            if (this.descUpdateListener != null) {
                Object obj = this.getObjectValue(ref, 0);
                String name = obj != null ? obj.toString() : "";
                String desc = (String)this.getObjectValue(ref, this.descriptionColumn);
                boolean readOnly = !this.getModel().isCellEditable(this.getSelectedRow(), this.descriptionColumn);
                this.setDescriptionInspector(desc, name, this.descUpdateListener, ref, readOnly);
            } else {
                Print.dprintln((String)"'descUpdateListener' was never initialized!");
            }
        } else {
            this.clearDescriptionInspector();
        }
    }

    public void setHandleDescriptionUpdates(boolean state) {
        this.handleDescriptionUpdates = state;
    }

    public Object getValueAt(int row, int col) {
        Object obj = null;
        if (this.isValidIndex(row, col)) {
            obj = this.descriptionColumn == col ? super.getValueAt(row, col) : super.getValueAt(row, col);
        } else {
            Print.dprintln((String)("Table Rows = " + this.getRowCount()));
            Print.dprintln((String)("Model Rows = " + this.getModel().getRowCount()));
            Print.dprintStackTrace((String)("Row/Column out of range [" + row + "/" + col + "]"));
        }
        return obj;
    }

    public boolean isCellEditable(int row, int col) {
        if (col >= 0 && this.descriptionColumn == col) {
            return true;
        }
        return super.isCellEditable(row, col);
    }

    public void processKeyEvent(KeyEvent ke) {
        JTextComponent c;
        TableCellEditor editor;
        int row;
        if (UIConfig.debugMode() && ke.getID() != 401 && ke.getKeyCode() == 9 && (row = this.getSelectedRow()) == this.getRowCount() - 1) {
            int nc = -1;
            int col = this.getSelectedColumn();
            int maxCol = this.getColumnCount();
            for (int c2 = col + 1; c2 < maxCol; ++c2) {
                if (!this.isCellEditable(row, nc)) continue;
                nc = c2;
                break;
            }
            if (nc < 0) {
                Print.dprintln((String)"Next tab should Tab OUT!");
            }
        }
        super.processKeyEvent(ke);
        if (this.editMethod == 0) {
            Component t;
            TableCellEditor tce;
            int col;
            if (this.isEditing()) {
                return;
            }
            if (ke.isActionKey() || ke.getID() != 400 || ke.getKeyChar() < ' ') {
                return;
            }
            row = this.getSelectedRow();
            if (this.isValidIndex(row, col = this.getSelectedColumn()) && (tce = this.getCellEditor(row, col)) instanceof DefaultCellEditor && (t = ((DefaultCellEditor)tce).getComponent()) instanceof JTextComponent) {
                Print.dprintln((String)("Editing cell at " + row + "/" + col + " [(int)char=" + ke.getKeyChar() + "]"));
                this.editCellAt(row, col);
            }
        } else if (this.editMethod == 1 && (editor = this.getCellEditor()) instanceof DefaultCellEditor && ((DefaultCellEditor)editor).getComponent() instanceof JTextComponent && !(c = (JTextComponent)((DefaultCellEditor)editor).getComponent()).getCaret().isVisible()) {
            c.getCaret().setVisible(true);
        }
    }

    private void _processMouseClicked(MouseEvent me) {
        int col;
        int row;
        if (me.getClickCount() == 2 && !this.isEditing() && this.isValidIndex(row = this.getSelectedRow(), col = this.getSelectedColumn())) {
            this.editCellAt(row, col);
        }
    }

    public boolean editCellAt(int row, int col) {
        return super.editCellAt(row, col);
    }

    public void valueChanged(ListSelectionEvent lse) {
        super.valueChanged(lse);
    }

    public void editingStopped(ChangeEvent e) {
        JComboBox cb;
        ComboBoxEditor cbe;
        Component comp;
        Component c;
        if (this.editingStopped_recursion > 0) {
            return;
        }
        ++this.editingStopped_recursion;
        TableCellEditor tce = this.getCellEditor();
        if (tce instanceof DefaultCellEditor && (c = ((DefaultCellEditor)tce).getComponent()) instanceof JComboBox && ((JComboBox)c).isEditable() && (comp = (cbe = (cb = (JComboBox)c).getEditor()).getEditorComponent()) instanceof JTextField) {
            String selTxt;
            String text = ((JTextField)comp).getText();
            Object selObj = cb.getSelectedItem();
            String string = selTxt = selObj != null ? selObj.toString() : "";
            if (!text.equals(selTxt)) {
                ActionEvent ae = new ActionEvent(comp, 1001, "");
                cb.actionPerformed(ae);
            }
        }
        super.editingStopped(e);
        --this.editingStopped_recursion;
    }

    public TableCellEditor getCellEditor(int r, int c) {
        return super.getCellEditor(r, c);
    }

    public boolean isValidIndex(int row, int col) {
        return row >= 0 && col >= 0 && row < this.getRowCount() && col < this.getColumnCount();
    }

    public void setValueAt(Object value, int row, int column) {
        if (this.isValidIndex(row, column)) {
            if (value != null) {
                super.setValueAt(value, row, column);
            } else {
                Print.dprintln((String)"Attempting to set a 'null' value!");
            }
        } else {
            Print.dprintStackTrace((String)("Row/Column out of range (" + row + "/" + column + ") " + "[size = " + this.getRowCount() + "/" + this.getColumnCount() + "] " + DT.className(this)));
        }
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        if (!this.superDidInitialize) {
            return;
        }
        this.isCustomModelSet = true;
        if (model instanceof InspectorTableModel) {
            ((InspectorTableModel)model).setInspectorTable(this);
        }
        this._setupDescriptionColumn();
        int dataModelCnt = model.getColumnCount();
        int thisModelCnt = this.getColumnCount();
        if (dataModelCnt != thisModelCnt) {
            Print.dprintln((String)("Column count mismatch: " + dataModelCnt + " != " + thisModelCnt));
        }
        if (this.enableHorizontalScrolling) {
            this.setAutoResizeMode(0);
        } else {
            this.setAutoResizeMode(1);
            this.sizeColumnsToFit(0);
        }
    }

    public void createDefaultColumnsFromModel() {
        if (this.isEditing()) {
            return;
        }
        TableModel dm = this.getModel();
        TableColumnModel cm = this.getColumnModel();
        if (dm != null && cm != null && cm.getColumnCount() != dm.getColumnCount()) {
            while (cm.getColumnCount() > 0) {
                cm.removeColumn(cm.getColumn(0));
            }
            for (int i = 0; i < dm.getColumnCount(); ++i) {
                InspectorTableColumn col = new InspectorTableColumn(i);
                this.addColumn(col);
            }
        }
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
        return super.prepareRenderer(renderer, row, col);
    }

    public TableCellRenderer getCellRenderer(int r, int c) {
        if (this.delegateRenderers == null) {
            this.delegateRenderers = new InspectorCellRenderer[this.getColumnCount()];
        } else if (this.delegateRenderers.length < this.getColumnCount()) {
            InspectorCellRenderer[] newList = new InspectorCellRenderer[this.getColumnCount()];
            System.arraycopy(this.delegateRenderers, 0, newList, 0, this.delegateRenderers.length);
            this.delegateRenderers = newList;
        }
        TableCellRenderer renderer = super.getCellRenderer(r, c);
        if (renderer instanceof InspectorCellRenderer) {
            return renderer;
        }
        if (this.delegateRenderers[c] == null) {
            this.delegateRenderers[c] = new InspectorCellRenderer(this.rightAlign);
        }
        this.delegateRenderers[c].setDelegate(renderer != null ? renderer : this.getDefaultRenderer(this.getColumnClass(c)));
        return this.delegateRenderers[c];
    }

    public void setEnabled(boolean state) {
        super.setEnabled(state);
    }

    public List getTableData() {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).getData();
        }
        InspectorTable._printDataModelError();
        return null;
    }

    public void clear() {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            this.clearSelection();
            ((InspectorTableModel)model)._updateTableData((Collection)null);
        } else {
            InspectorTable._printDataModelError();
        }
    }

    public void clearTableData() {
        this.clear();
    }

    public void updateTableData(Collection c) {
        this._updateTableData(c);
    }

    public void updateTableData(Set s) {
        this._updateTableData(s);
    }

    public void updateTableData(Enumeration e) {
        this._updateTableData(e);
    }

    public void updateTableData(Object[] l) {
        this._updateTableData(l);
    }

    private void _updateTableData(Object s) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            int minSel = -1;
            int maxSel = -1;
            Object refSel = null;
            if (this.selectRowOnUpdate_Column < 0) {
                if (this.isSingleSelection()) {
                    refSel = this.getSelectedRowObject();
                } else {
                    minSel = this.getMinSelectionIndex();
                    maxSel = this.getMaxSelectionIndex();
                }
            }
            if (s == null) {
                ((InspectorTableModel)model)._updateTableData((Collection)null);
            } else if (s instanceof Collection) {
                ((InspectorTableModel)model)._updateTableData((Collection)s);
            } else if (s instanceof Enumeration) {
                ((InspectorTableModel)model)._updateTableData((Enumeration)s);
            } else if (s instanceof Object[]) {
                ((InspectorTableModel)model)._updateTableData((Object[])s);
            } else {
                Print.printStackTrace((String)("Unsupported data type - " + DT.className(s)));
            }
            if (this.selectRowOnUpdate_Column >= 0) {
                this.selectRowWithValue(this.selectRowOnUpdate_Column, this.selectRowOnUpdate_Value);
                this.selectRowOnUpdate_Column = -1;
                this.selectRowOnUpdate_Value = null;
            } else if (refSel != null && this.getObjectIndex(refSel) >= 0) {
                this.setSelectedRowObject(refSel);
            } else {
                this.setSelectionInterval(minSel, maxSel);
            }
            if (this.handleDescriptionUpdates) {
                this.showSelectedDescription();
            }
        } else {
            InspectorTable._printDataModelError();
        }
    }

    public void addRowObject(Object obj) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            ((InspectorTableModel)model).addRowObject(obj, true);
        } else {
            InspectorTable._printDataModelError();
        }
    }

    public void removeRowObject(Object obj) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            ((InspectorTableModel)model).removeRowObject(obj, true);
        } else {
            InspectorTable._printDataModelError();
        }
    }

    public void removeRowObjects(Object[] list) {
        if (list == null) {
            return;
        }
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            for (int i = 0; i < list.length; ++i) {
                ((InspectorTableModel)model).removeRowObject(list[i], true);
            }
        } else {
            InspectorTable._printDataModelError();
        }
    }

    public void changeSelection(int row, int col, boolean toggle, boolean extend) {
        if (this.isValidIndex(row, col)) {
            super.changeSelection(row, col, toggle, extend);
        } else {
            Print.dprintln((String)("Invalid index: " + row + "/" + col));
        }
    }

    public boolean isSettingSelection() {
        return this.settingSelection;
    }

    public boolean isSingleSelection() {
        return this.getSelectionModel().getSelectionMode() == 0;
    }

    public int getSelectedRow() {
        return super.getSelectedRow();
    }

    public int getSelectedColumn() {
        return super.getSelectedColumn();
    }

    public Object[] getSelectedRowObjects() {
        Vector<Object> sel = new Vector<Object>();
        ListSelectionModel lsm = this.getSelectionModel();
        int minSel = this.getMinSelectionIndex();
        if (minSel >= 0) {
            int maxSel = this.getMaxSelectionIndex();
            for (int i = minSel; i <= maxSel; ++i) {
                if (!lsm.isSelectedIndex(i)) continue;
                sel.add(this.getRowObject(i));
            }
        }
        return sel.toArray();
    }

    public Object getSelectedRowObject() {
        return this.getRowObject(this.getSelectedRow());
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public void clearSelection() {
        this.settingSelection = true;
        this.getSelectionModel().clearSelection();
        this.settingSelection = false;
    }

    public boolean isSelectionEmpty() {
        return !this.isValidIndex(this.getSelectedRow(), this.getSelectedColumn());
    }

    public ListSelectionModel getColumnSelectionModel() {
        return this.getColumnModel().getSelectionModel();
    }

    public void setSelectionInterval(int minSel, int maxSel) {
        if (maxSel < minSel) {
            maxSel = minSel;
        }
        if (minSel < 0) {
            this.clearSelection();
            return;
        }
        TableModel model = this.getModel();
        int lastRow = this.getRowCount() - 1;
        if (lastRow < 0) {
            this.clearSelection();
        } else {
            if (minSel > lastRow) {
                minSel = lastRow;
            }
            if (maxSel > lastRow) {
                maxSel = lastRow;
            }
            this.settingSelection = true;
            this.getSelectionModel().setSelectionInterval(minSel, maxSel);
            this.settingSelection = false;
        }
    }

    public void setSelectedIndex(int ndx) {
        this.setSelectionInterval(ndx, ndx);
    }

    public void addSelectedIndex(int ndx) {
        if (ndx >= 0) {
            this.addRowSelectionInterval(ndx, ndx);
        }
    }

    public void setSelectedRowObject(Object ref) {
        int ndx = this.getObjectIndex(ref);
        if (ref != null && ndx < 0) {
            Print.dprintln((String)("Specified object not found in table: " + ref));
        }
        this.setSelectionInterval(ndx, ndx);
    }

    public void selectRowWithValue(int column, Object value) {
        int ndx = this.findRowWithValue(column, value);
        this.setSelectedIndex(ndx);
    }

    public void selectRowsWithValue(int column, Object[] value) {
        this.clearSelection();
        for (int i = 0; i < value.length; ++i) {
            int ndx = this.findRowWithValue(column, value[i]);
            this.addSelectedIndex(ndx);
        }
    }

    public void selectBlankRow(int column) {
        this.selectRowWithValue(column, "");
    }

    public void selectRowWithValueOnUpdate(int column, Object value) {
        this.selectRowOnUpdate_Column = column;
        this.selectRowOnUpdate_Value = value;
    }

    public Object[] confirmDeleteSelection(String msg, String title) {
        Object[] ref = this.getSelectedRowObjects();
        if (ref != null && ref.length > 0) {
            String optTitle;
            StringBuffer list = new StringBuffer("");
            for (int i = 0; i < ref.length; ++i) {
                list.append("  ");
                list.append(this.getObjectValue(ref[i], 0));
                list.append("\n");
            }
            String optMsg = msg == null ? localStrings.getLocalString("ui.inspectortable.confirm_delete_selection", "Are you sure you want to delete the selected row(s)?\n{0}", new Object[]{list.toString()}) : msg;
            String string = optTitle = title == null ? localStrings.getLocalString("ui.inspectortable.delete_selection", "Delete Selection") : title;
            if (UIOptionPane.showConfirmDialog((Component)this, (Object)optMsg, optTitle)) {
                return ref;
            }
        } else {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.inspectortable.first_select_item", "You must first select an item from the list"));
        }
        return null;
    }

    public Object getRowObject(int row) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).getRowObject(row);
        }
        InspectorTable._printDataModelError();
        return null;
    }

    public int getObjectIndex(Object obj) {
        if (obj != null) {
            TableModel model = this.getModel();
            if (model instanceof InspectorTableModel) {
                return ((InspectorTableModel)model).getObjectIndex(obj);
            }
            InspectorTable._printDataModelError();
        }
        return -1;
    }

    public int findRowWithValue(int col, Object value) {
        return this.findRowWithValue(-1, col, value);
    }

    public int findRowWithValue(int startRow, int col, Object value) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).findRowWithValue(startRow, col, value);
        }
        InspectorTable._printDataModelError();
        return -1;
    }

    public Object getRowWithValue(int col, Object value) {
        return this.getRowWithValue(-1, col, value);
    }

    public Object getRowWithValue(int startRow, int col, Object value) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).getRowWithValue(startRow, col, value);
        }
        InspectorTable._printDataModelError();
        return null;
    }

    public Object getObjectValue(Object obj, int col) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).getObjectValue(obj, col);
        }
        InspectorTable._printDataModelError();
        return null;
    }

    public void setObjectValue(Object obj, int col, Object value) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            ((InspectorTableModel)model).setObjectValue(obj, col, value);
            return;
        }
        InspectorTable._printDataModelError();
    }

    public InspectorTableModel.InspectorDataWrapper wrapDataItem(Object obj) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).wrapDataItem(obj);
        }
        InspectorTable._printDataModelError();
        return new InspectorTableModel.InspectorDataWrapper("");
    }

    public InspectorTableModel.InspectorDataWrapper wrapDataItem(Object[] obj) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).wrapDataItem(obj);
        }
        InspectorTable._printDataModelError();
        return new InspectorTableModel.InspectorDataWrapper(new Object[]{""});
    }

    public Vector wrapData(Collection objSet) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).wrapData(objSet);
        }
        InspectorTable._printDataModelError();
        return new Vector();
    }

    public Vector wrapData(Enumeration objEnum) {
        TableModel model = this.getModel();
        if (model instanceof InspectorTableModel) {
            return ((InspectorTableModel)model).wrapData(objEnum);
        }
        InspectorTable._printDataModelError();
        return new Vector();
    }

    private static void _printDataModelError() {
        Print.printStackTrace((String)"getModel() is not an instance of InspectorTableModel");
    }

    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
    }

    public void initIconColumn(int col, Icon colIcon, Object[][] iconValueMap, ActionListener action) {
        TableColumn tc = this.getColumnModel().getColumn(col);
        tc.setHeaderRenderer(new TableIconColumnRenderer(colIcon));
        tc.setCellRenderer(new TableIconCellRenderer(iconValueMap));
        tc.setCellEditor(new TableIconCellEditor(action));
        int w = colIcon.getIconWidth() + 10;
        tc.setMinWidth(w);
        tc.setMaxWidth(w);
        tc.setPreferredWidth(w);
        this.sizeColumnsToFit(col);
    }

    public void initIconColumn(int col, String headerValue, Object[][] iconValueMap, ActionListener action) {
        TableColumn tc = this.getColumnModel().getColumn(col);
        tc.setHeaderValue(headerValue);
        tc.setCellRenderer(new TableIconCellRenderer(iconValueMap));
        tc.setCellEditor(new TableIconCellEditor(action));
        this.sizeColumnsToFit(col);
    }

    public TableComboBoxEditor getComboBoxEditor(Object[] items) {
        UITitledComboBox cb = new UITitledComboBox();
        cb.setModel(items);
        return new TableComboBoxEditor(cb);
    }

    public TableComboBoxEditor getComboBoxEditor(Collection items) {
        UITitledComboBox cb = new UITitledComboBox();
        cb.setModel(items);
        return new TableComboBoxEditor(cb);
    }

    public TableComboBoxEditor getComboBoxEditor(ComboBoxModel cbm) {
        UITitledComboBox cb = new UITitledComboBox();
        cb.setModel(cbm);
        return new TableComboBoxEditor(cb);
    }

    public TableCellEditor getIntegerEditor(int width) {
        return new NumericCellEditor(new NumericEditorField(true, width));
    }

    public TableCellEditor getDecimalEditor(int width) {
        return new NumericCellEditor(new NumericEditorField(false, width));
    }

    public TableCellEditor getCharacterEditor(int width) {
        return new CharacterCellEditor(new CharacterEditorField(width));
    }

    private static int getPrimitiveTypeIndex(String type) {
        for (int i = 0; i < primitiveType.length; ++i) {
            if (!primitiveType[i].equals(type)) continue;
            return i;
        }
        return -1;
    }

    public String[] getPrimitiveTypes() {
        return primitiveType;
    }

    public String getPrimitiveTypeName(String type) {
        return type.startsWith(JAVA_LANG) ? type.substring(JAVA_LANG.length()) : type;
    }

    public TableCellEditor getPrimitiveTypesEditor() {
        if (this.primitiveTypeEditor == null) {
            Object[] list = new String[primitiveType.length];
            for (int i = 0; i < primitiveType.length; ++i) {
                list[i] = this.getPrimitiveTypeName(primitiveType[i]);
            }
            this.primitiveTypeEditor = this.getComboBoxEditor(list);
        }
        return this.primitiveTypeEditor;
    }

    public TableCellEditor getPrimitiveValueEditor(Class type) {
        return this.getPrimitiveValueEditor(type.getName());
    }

    public TableCellEditor getPrimitiveValueEditor(String type) {
        int ndx = InspectorTable.getPrimitiveTypeIndex(type);
        if (ndx < 0) {
            Print.dprintln((String)("Unsupported type: " + type));
            return super.getDefaultEditor(Object.class);
        }
        if (this.primitiveEditor[ndx] == null) {
            TableCellEditor dce = null;
            switch (ndx) {
                case 0: {
                    dce = super.getDefaultEditor(String.class);
                    break;
                }
                case 1: {
                    dce = this.getCharacterEditor(1);
                    break;
                }
                case 2: {
                    dce = this.getComboBoxEditor(new String[]{"false", "true"});
                    break;
                }
                case 3: {
                    dce = this.getIntegerEditor(3);
                    break;
                }
                case 4: {
                    dce = this.getIntegerEditor(5);
                    break;
                }
                case 5: {
                    dce = this.getIntegerEditor(5);
                    break;
                }
                case 6: {
                    dce = this.getIntegerEditor(10);
                    break;
                }
                case 7: {
                    dce = this.getDecimalEditor(16);
                    break;
                }
                case 8: {
                    dce = this.getDecimalEditor(16);
                }
            }
            this.primitiveEditor[ndx] = dce;
        }
        return this.primitiveEditor[ndx];
    }

    protected class CharacterEditorField
    extends JTextField {
        public CharacterEditorField(int width) {
            super(width);
            this.setText("");
        }

        public char getCharacterValue() {
            String value = this.getText().trim();
            return value.length() > 0 ? value.charAt(0) : (char)' ';
        }

        protected Document createDefaultModel() {
            return new CharacterDocument();
        }

        protected class CharacterDocument
        extends PlainDocument {
            protected CharacterDocument() {
            }

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                super.remove(0, this.getLength());
                String c = str.length() > 0 ? str.substring(0, 1) : " ";
                super.insertString(0, c, a);
            }
        }
    }

    protected class CharacterCellEditor
    extends DefaultCellEditor {
        CharacterEditorField field;

        public CharacterCellEditor(CharacterEditorField field) {
            super(field);
            this.field = null;
            this.field = field;
        }

        public Object getCellEditorValue() {
            Character c = new Character(this.field.getCharacterValue());
            return c;
        }
    }

    protected class NumericEditorField
    extends JTextField {
        private Toolkit toolkit;
        private NumberFormat formatter;
        private boolean allowsDecimal;

        public NumericEditorField(boolean intOnly, int width) {
            super(width);
            this.toolkit = null;
            this.formatter = null;
            this.allowsDecimal = false;
            this.allowsDecimal = !intOnly;
            this.toolkit = Toolkit.getDefaultToolkit();
            this.formatter = NumberFormat.getNumberInstance();
            this.formatter.setParseIntegerOnly(intOnly);
            if (intOnly) {
                this.setValue(0);
            } else {
                this.setValue(0.0);
            }
        }

        public boolean getAllowsDecimal() {
            return this.allowsDecimal;
        }

        public long getLongValue() {
            long retVal = 0L;
            try {
                retVal = this.formatter.parse(this.getText()).longValue();
            }
            catch (ParseException e) {
                this.toolkit.beep();
            }
            return retVal;
        }

        public double getDoubleValue() {
            double retVal = 0.0;
            try {
                retVal = this.formatter.parse(this.getText()).doubleValue();
            }
            catch (ParseException e) {
                this.toolkit.beep();
            }
            return retVal;
        }

        public void setValue(int value) {
            this.setText(this.formatter.format(value));
        }

        public void setValue(double value) {
            this.setText(this.formatter.format(value));
        }

        protected Document createDefaultModel() {
            return new NumericDocument();
        }

        protected class NumericDocument
        extends PlainDocument {
            protected NumericDocument() {
            }

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                char[] s = str.toCharArray();
                char[] r = new char[s.length];
                int j = 0;
                for (int i = 0; i < r.length; ++i) {
                    if (Character.isDigit(s[i]) || s[i] == '-') {
                        r[j++] = s[i];
                        continue;
                    }
                    if (NumericEditorField.this.getAllowsDecimal() && (s[i] == '.' || s[i] == 'E')) {
                        r[j++] = s[i];
                        continue;
                    }
                    NumericEditorField.this.toolkit.beep();
                }
                super.insertString(offs, new String(r, 0, j), a);
            }
        }
    }

    protected class NumericCellEditor
    extends DefaultCellEditor {
        NumericEditorField field;

        public NumericCellEditor(NumericEditorField field) {
            super(field);
            this.field = null;
            this.field = field;
        }

        public Object getCellEditorValue() {
            return this.field.getAllowsDecimal() ? (Number)new Double(this.field.getDoubleValue()) : (Number)new Long(this.field.getLongValue());
        }
    }

    public class TableComboBoxEditor
    extends DefaultCellEditor {
        private UITitledComboBox uiComboBox;

        public TableComboBoxEditor(UITitledComboBox cb) {
            super(cb.getComboBox());
            this.uiComboBox = null;
            this.uiComboBox = cb;
        }

        public TableComboBoxEditor(JComboBox comboBox) {
            super(comboBox);
            this.uiComboBox = null;
            comboBox.getAccessibleContext().setAccessibleName(CBOX_NAME);
            comboBox.getAccessibleContext().setAccessibleDescription(CBOX_DESC);
        }

        public TableComboBoxEditor() {
            this(new JComboBox());
        }

        public UITitledComboBox getUITitledComboBox() {
            return this.uiComboBox;
        }

        public void addActionItem(String title, ActionListener action) {
            if (this.uiComboBox != null) {
                this.uiComboBox.addActionItem(title, action);
            }
        }

        public void addActionItem(UIActionDispatcher action) {
            if (this.uiComboBox != null) {
                this.uiComboBox.addActionItem(action);
            }
        }

        public JComboBox getComboBox() {
            return (JComboBox)this.getComponent();
        }

        public void setSelectedItem(Object obj) {
            this.getComboBox().setSelectedItem(obj);
        }

        public void setModel(Vector list) {
            this.getComboBox().setModel(new DefaultComboBoxModel(list));
        }

        public void setModel(Object[] items) {
            this.getComboBox().setModel(new DefaultComboBoxModel<Object>(items));
        }

        public void setModel(ComboBoxModel cbm) {
            this.getComboBox().setModel(cbm);
        }

        public void setEditable(boolean editable) {
            this.getComboBox().setEditable(editable);
        }
    }

    public static class TableIconCellEditor
    extends DefaultCellEditor {
        private ActionListener action = null;

        public TableIconCellEditor(ActionListener action) {
            super(new UICheckBox());
            this.action = action;
        }

        public boolean isCellEditable(EventObject anEvent) {
            UIActionDispatcher.invokeLater(this.action);
            return false;
        }
    }

    public static class TableIconCellRenderer
    implements TableCellRenderer {
        private JLabel iconLabel = null;
        private Hashtable iconMap = new Hashtable();

        public TableIconCellRenderer() {
            this.iconLabel = new JLabel();
            this.iconLabel.getAccessibleContext().setAccessibleName(LABEL_NAME);
            this.iconLabel.getAccessibleContext().setAccessibleDescription(LABEL_DESC);
        }

        public TableIconCellRenderer(Hashtable iconKeys) {
            this();
            this.setIconMap(iconKeys);
        }

        public TableIconCellRenderer(Object[][] iconKeys) {
            this();
            this.setIconMap(iconKeys);
        }

        public TableIconCellRenderer(Icon trueIcon, Icon falseIcon) {
            this();
            this.addIconMap("true", trueIcon);
            this.addIconMap("false", falseIcon);
        }

        public void setIconMap(Hashtable iconKeys) {
            Enumeration e = iconKeys.keys();
            while (e.hasMoreElements()) {
                Object k = e.nextElement();
                Object v = iconKeys.get(k);
                this.addIconMap(k.toString(), (Icon)v);
            }
        }

        public void setIconMap(Object[][] iconKey) {
            for (int i = 0; i < iconKey.length; ++i) {
                Object k = iconKey[i][0];
                Object v = iconKey[i][1];
                this.addIconMap(k.toString(), (Icon)v);
            }
        }

        public void addIconMap(String k, Icon v) {
            this.iconMap.put(k, v != null ? v : "");
        }

        public Component getTableCellRendererComponent(JTable table, Object keyVal, boolean isSelected, boolean hasFocus, int row, int column) {
            Object obj;
            this.iconLabel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            if (keyVal == null) {
                keyVal = Boolean.FALSE.toString();
            }
            if ((obj = this.iconMap.get(keyVal.toString())) == null) {
                this.iconLabel.setIcon(null);
                this.iconLabel.setText(keyVal.toString());
            } else if (obj instanceof Icon) {
                this.iconLabel.setIcon((Icon)obj);
                this.iconLabel.setText(null);
            } else {
                this.iconLabel.setIcon(null);
                this.iconLabel.setText(null);
            }
            return this.iconLabel;
        }
    }

    public static class TableIconColumnRenderer
    extends JLabel
    implements TableCellRenderer {
        public TableIconColumnRenderer(Icon columnIcon) {
            this(columnIcon, "?");
        }

        public TableIconColumnRenderer(Icon columnIcon, String dftText) {
            this.setOpaque(true);
            this.getAccessibleContext().setAccessibleName(LABEL_NAME);
            this.getAccessibleContext().setAccessibleDescription(LABEL_DESC);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            if (columnIcon != null) {
                this.setIcon(columnIcon);
            } else {
                this.setText(dftText);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }
    }

    public class InspectorCellRenderer
    implements TableCellRenderer {
        private boolean rightAlign = true;
        private TableCellRenderer delegate = null;

        public InspectorCellRenderer(TableCellRenderer renderer, boolean rightAlign) {
            this.setDelegate(renderer);
            this.rightAlign = rightAlign;
        }

        public InspectorCellRenderer(boolean rightAlign) {
            this(new DefaultTableCellRenderer(), rightAlign);
        }

        public void setDelegate(TableCellRenderer renderer) {
            this.delegate = renderer;
        }

        public TableCellRenderer getDelegate() {
            return this.delegate;
        }

        public Component getTableCellRendererComponent(JTable tbl, Object val, boolean isSel, boolean focus, int r, int c) {
            Component renderer = this.delegate.getTableCellRendererComponent(tbl, val, isSel, focus, r, c);
            if (renderer instanceof JComponent) {
                JComponent comp = (JComponent)renderer;
                if (comp instanceof JLabel) {
                    String str = val == null ? "" : val.toString();
                    FontMetrics fm = InspectorTable.this.getFontMetrics(((JLabel)comp).getFont());
                    String displayedVal = null;
                    displayedVal = this.rightAlign ? StringTools.rightAlignLongText(str, fm, this.cellWidth(tbl, (JLabel)comp, r, c)) : StringTools.leftAlignLongText(str, fm, this.cellWidth(tbl, (JLabel)comp, r, c));
                    ((JLabel)comp).setText(displayedVal);
                    if (!displayedVal.equals(str)) {
                        ((JLabel)comp).setToolTipText(str);
                    } else {
                        ((JLabel)comp).setToolTipText(null);
                    }
                }
                if (isSel) {
                    comp.setBackground(tbl.getSelectionBackground());
                    comp.setOpaque(true);
                } else {
                    Color bg;
                    TableModel model = tbl.getModel();
                    Color color = bg = model.isCellEditable(r, c) ? UITitledBox.EnabledBackgroundColor : UITitledBox.DisabledBackgroundColor;
                    if ((r & 1) == 1 && model.getColumnCount() > 1) {
                        bg = ColorTools.brighter(bg, -0.03);
                    }
                    comp.setBackground(bg);
                    comp.setOpaque(true);
                }
            } else {
                Print.dprintln((String)("Not a JComponent: " + DT.className(renderer)));
            }
            return renderer;
        }

        public int cellWidth(JTable tbl, JLabel label, int r, int c) {
            int cellWidth = tbl.getCellRect((int)r, (int)c, (boolean)false).width;
            Insets insets = label.getInsets();
            return cellWidth -= insets.left + insets.right;
        }
    }

    private class InspectorTableColumn
    extends TableColumn {
        private int adjustedWidth;

        public InspectorTableColumn(int modelIndex) {
            super(modelIndex);
            this.adjustedWidth = -1;
        }

        public void setWidth(int width) {
            super.setWidth(width);
        }

        public void setAdjustedWidth(int width) {
            this.adjustedWidth = width;
            super.setMaxWidth(width);
            super.setMinWidth(width);
            super.setPreferredWidth(this.adjustedWidth);
        }

        public int getPreferredWidth() {
            if (this.adjustedWidth > -1) {
                return this.adjustedWidth;
            }
            return super.getPreferredWidth();
        }

        public int getMaxWidth() {
            if (InspectorTable.this.resizingColumns > 0 && this.adjustedWidth > -1) {
                return this.adjustedWidth;
            }
            return super.getMaxWidth();
        }
    }

    private class InspectorTableHeader
    extends JTableHeader {
        public InspectorTableHeader() {
            this(null);
            this.setReorderingAllowed(false);
        }

        public InspectorTableHeader(TableColumnModel cm) {
            super(cm);
            this.getAccessibleContext().setAccessibleName(TABLE_HEADER_NAME);
            this.getAccessibleContext().setAccessibleDescription(TABLE_HEADER_DESC);
            this.setReorderingAllowed(false);
        }

        public String getToolTipText(MouseEvent me) {
            Object v;
            String tip = null;
            int c = this.columnModel.getColumnIndexAtX(me.getPoint().x);
            if (c >= 0 && c != InspectorTable.this.getDescriptionColumn() && (v = this.columnModel.getColumn(c).getHeaderValue()) instanceof String) {
                tip = (String)v;
            }
            return tip != null ? tip : super.getToolTipText(me);
        }
    }

    private class HiddenTableColumn
    extends TableColumn {
        private TableColumn realColumn;

        public HiddenTableColumn(TableColumn tc) {
            super(tc.getModelIndex(), 0);
            this.realColumn = null;
            this.setMinWidth(0);
            this.setMaxWidth(0);
            this.setResizable(false);
            this.realColumn = tc;
        }

        public TableColumn getRealColumn() {
            return this.realColumn;
        }
    }

    private class InspectorTableColumnModel
    extends DefaultTableColumnModel {
        private Hashtable hiddenColumns = new Hashtable();

        public void setColumnHidden(int tcNdx, boolean hide) {
            TableColumn tc = InspectorTable.this.getColumn(tcNdx, true);
            if (tc != null) {
                if (!hide) {
                    this.hiddenColumns.remove(tc);
                } else if (!this.hiddenColumns.containsKey(tc)) {
                    this.hiddenColumns.put(tc, new HiddenTableColumn(tc));
                }
                this.totalColumnWidth = -1;
                this.fireColumnMarginChanged();
            }
        }

        public boolean isColumnHidden(int n) {
            TableColumn tc = this.getColumn(n, false);
            return tc != null ? tc instanceof HiddenTableColumn : true;
        }

        public TableColumn getColumn(int ndx) {
            return this.getColumn(ndx, false);
        }

        public TableColumn getColumn(int ndx, boolean realColumn) {
            TableColumn tc = super.getColumn(ndx);
            if (realColumn) {
                return tc;
            }
            Object htc = this.hiddenColumns.get(tc);
            return htc != null ? (TableColumn)htc : tc;
        }

        public Enumeration getColumns() {
            Enumeration<TableColumn> enumeration = super.getColumns();
            if (!this.hiddenColumns.isEmpty()) {
                Vector v = new Vector();
                while (enumeration.hasMoreElements()) {
                    TableColumn tc = enumeration.nextElement();
                    Object htc = this.hiddenColumns.get(tc);
                    v.add(htc != null ? htc : tc);
                }
                enumeration = v.elements();
            }
            return enumeration;
        }

        public void fireChangeNotification() {
            this.fireColumnMarginChanged();
        }
    }
}

