/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.util.Print;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;

public class HTTPCommand {
    private static boolean UseProxy = false;
    private static String ProxyHost = null;
    private static int ProxyPort = 0;
    private String cmd = null;
    private String url = null;
    private String auth = null;
    private byte[] inlineData = null;
    private int responseCode = -1;
    private String status = null;
    private static final char CharPad = '=';
    private static final char[] CharMap = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public static boolean setHttpProxy(String host, int port) {
        ProxyHost = host;
        ProxyPort = port;
        UseProxy = ProxyHost != null && ProxyPort > 1024;
        return UseProxy;
    }

    public static boolean setHttpProxy(String proxy) {
        if (proxy != null) {
            int ndx = proxy.indexOf(":");
            int len = proxy.length();
            if (ndx > 0 && ndx + 1 < len) {
                try {
                    String host = proxy.substring(0, ndx);
                    int port = Integer.parseInt(proxy.substring(ndx + 1));
                    return HTTPCommand.setHttpProxy(host, port);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return HTTPCommand.setHttpProxy(null, 0);
    }

    public HTTPCommand(String cmd, String url, String auth) {
        this.cmd = cmd;
        this.url = url;
        this.auth = auth;
    }

    public HTTPCommand(String cmd, String url, String user, String password) {
        this(cmd, url, user + ":" + password);
    }

    public HTTPCommand(String postUrl, String auth, byte[] inlineData) {
        this.cmd = "PUT";
        this.url = postUrl;
        this.auth = auth;
        this.inlineData = inlineData;
    }

    public HTTPCommand(String postUrl, String user, String password, byte[] inlineData) {
        this(postUrl, user + ":" + password, inlineData);
    }

    public String readHTTP() throws IOException, UnknownHostException, ConnectException {
        return this.readHTTP_new();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readHTTP_new() throws IOException, UnknownHostException, ConnectException {
        String string;
        this.status = null;
        this.responseCode = -1;
        HttpURLConnection httpConn = null;
        try {
            try {
                httpConn = (HttpURLConnection)new URL(this.url).openConnection();
                httpConn.setAllowUserInteraction(false);
                httpConn.setDoInput(true);
                httpConn.setUseCaches(false);
                if (this.inlineData != null && this.inlineData.length > 0) {
                    httpConn.setDoOutput(true);
                    httpConn.setRequestMethod("PUT");
                    httpConn.setRequestProperty("Content-Length", String.valueOf(this.inlineData.length));
                } else {
                    httpConn.setDoOutput(false);
                    httpConn.setRequestMethod("GET");
                }
                httpConn.setRequestProperty("User-Agent", "Deploytool/1.4");
                if (this.auth != null && this.auth.length() > 0) {
                    String _enc = this.auth.charAt(0) == '$' ? this.auth.substring(1) : HTTPCommand.encodeBase64(this.auth);
                    httpConn.setRequestProperty("Authorization", "Basic " + _enc);
                }
                httpConn.connect();
                if (this.inlineData != null && this.inlineData.length > 0) {
                    BufferedOutputStream out = new BufferedOutputStream(httpConn.getOutputStream());
                    out.write(this.inlineData, 0, this.inlineData.length);
                    out.flush();
                    out.close();
                }
                BufferedInputStream in = new BufferedInputStream(httpConn.getInputStream());
                String pageData = HTTPCommand.readPageFromStream(in, 8192);
                ((InputStream)in).close();
                string = pageData.trim();
                Object var6_7 = null;
                if (httpConn == null) return string;
                this.status = httpConn.getHeaderField(0);
            }
            catch (FileNotFoundException fnfe) {
                if (httpConn == null) {
                    throw fnfe;
                }
                String string2 = "";
                Object var6_8 = null;
                if (httpConn == null) return string2;
                this.status = httpConn.getHeaderField(0);
                try {
                    httpConn.disconnect();
                    return string2;
                }
                catch (Throwable t) {
                    // empty catch block
                }
                return string2;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (httpConn == null) throw throwable;
            this.status = httpConn.getHeaderField(0);
            try {}
            catch (Throwable t) {
                throw throwable;
            }
            httpConn.disconnect();
            throw throwable;
        }
        try {}
        catch (Throwable t) {
            // empty catch block
            return string;
        }
        httpConn.disconnect();
        return string;
    }

    private static String readPageFromStream(InputStream webStream, int maxLen) {
        StringBuffer pageStr = new StringBuffer();
        BufferedReader pageStream = new BufferedReader(new InputStreamReader(webStream));
        do {
            String rcd;
            try {
                rcd = pageStream.readLine();
            }
            catch (IOException e) {
                rcd = null;
            }
            if (rcd == null) break;
            pageStr.append(rcd).append("\n");
        } while (pageStr.length() < maxLen);
        return pageStr.toString();
    }

    public String getStatusString() {
        Print.dprintln((String)"Replace with 'getStatusMessage()'");
        return this.getStatusMessage();
    }

    public int getStatus() {
        Print.dprintln((String)"Replace with 'getStatusCode()'");
        return this.getStatusCode();
    }

    public String getStatusMessage() {
        return this.status != null ? this.status : "";
    }

    public int getStatusCode() {
        int p1;
        if (this.responseCode < 0 && this.status != null && this.status.startsWith("HTTP/") && (p1 = this.status.indexOf(" ")) > 0) {
            try {
                String s = this.status.substring(p1).trim();
                int p2 = s.indexOf(" ");
                String num = p2 > 0 ? s.substring(0, p2).trim() : s;
                this.responseCode = Integer.parseInt(num);
                return this.responseCode;
            }
            catch (NumberFormatException nfe) {
                this.responseCode = -1;
            }
        }
        return this.responseCode;
    }

    private String readHTTP_old() throws IOException, UnknownHostException, ConnectException {
        Print.dprintln((String)"Old HTTP reader");
        String data = HTTPCommand.readPageFromProxy(this.cmd, this.url, this.auth, ProxyHost, ProxyPort, this.inlineData);
        int ndx = data.indexOf("\n");
        this.status = ndx > 0 ? data.substring(0, ndx).trim() : null;
        ndx = data.indexOf("\n\n");
        return ndx > 0 ? data.substring(ndx).trim() : data;
    }

    private static String readPageFromProxy(String get_post, String theUrl, String auth, String proxyHost, int proxyPort, byte[] inlineData) throws IOException, UnknownHostException, ConnectException {
        if (theUrl == null || theUrl.length() <= 7) {
            return "";
        }
        String host = proxyHost;
        int port = proxyPort;
        String url = theUrl;
        URL tmpURL = new URL(theUrl);
        String protocol = tmpURL.getProtocol();
        if (!protocol.equalsIgnoreCase("http")) {
            return "";
        }
        if (host == null) {
            host = tmpURL.getHost();
            port = tmpURL.getPort();
            url = tmpURL.getFile();
        }
        tmpURL = null;
        if (port <= 0) {
            port = 80;
        }
        Socket _socketId = new Socket(host, port);
        BufferedInputStream _in = new BufferedInputStream(_socketId.getInputStream());
        OutputStream _out = _socketId.getOutputStream();
        StringBuffer cmd = new StringBuffer(get_post + " " + url + " HTTP/1.0\r\n");
        if (auth != null && auth.length() > 0) {
            String _enc = auth.charAt(0) == '$' ? auth.substring(1) : HTTPCommand.encodeBase64(auth);
            cmd.append("Authorization: Basic " + _enc + "\r\n");
        }
        if (inlineData != null && inlineData.length > 0) {
            cmd.append("Content-Length: " + inlineData.length + "\r\n");
        }
        cmd.append("\r\n");
        _out.write(cmd.toString().getBytes());
        if (inlineData != null && inlineData.length > 0) {
            _out.write(inlineData);
        }
        _out.flush();
        String pageData = HTTPCommand.readPageFromStream(_in, 8192);
        _socketId.close();
        return pageData;
    }

    public static String encodeBase64(String str) {
        String encStr = "";
        char[] strArry = str.toCharArray();
        int len = strArry.length;
        for (int i = 0; i < len; i += 3) {
            long bit24 = strArry[i] << 16;
            if (i + 1 < len) {
                bit24 += (long)(strArry[i + 1] << 8);
            }
            if (i + 2 < len) {
                bit24 += (long)strArry[i + 2];
            }
            char[] enc = new char[]{CharMap[(int)(bit24 >>> 18 & 0x3FL)], CharMap[(int)(bit24 >>> 12 & 0x3FL)], i + 1 < len ? CharMap[(int)(bit24 >>> 6 & 0x3FL)] : (char)'=', i + 2 < len ? CharMap[(int)(bit24 & 0x3FL)] : (char)'='};
            encStr = encStr + String.valueOf(enc);
        }
        return encStr;
    }
}

