/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfigProperties;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledHTMLText;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextArea;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExecProcess {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ExecProcess.class);
    protected static String CONSOLE_TITLE = localStrings.getLocalString("ui.execprocess.console.title", "Exec Console");
    protected static String STOP_BUTTON = localStrings.getLocalString("ui.execprocess.console.stop_button", "Stop");
    protected static char STOP_BUTTON_MNEMONIC = localStrings.getLocalString("ui.execprocess.console.stop_button_mnemonic", "S").charAt(0);
    private static Color CONSOLE_BACKGROUND_COLOR = new Color(242, 242, 242);
    private static int TIMEOUT_MAX = 60000;
    private static int TIMEOUT_INCREMENT = 500;
    private static int SEPARATOR_LENGTH = 70;
    private String helpText = null;
    private String[] execArgs = null;
    private Process process = null;
    private boolean stopVisible = true;
    private ExecOutputManager execManager = null;
    private long startTime = -1L;

    protected static String EXEC_FINISHED(double sec, int status) {
        return localStrings.getLocalString("ui.execprocess.exec_finished", "[Completed (time={0}sec, status={1})]", new Object[]{String.valueOf(sec), String.valueOf(status)});
    }

    public ExecProcess(String cmd, String[] args) {
        if (args != null) {
            this.execArgs = new String[args.length + 1];
            this.execArgs[0] = cmd;
            System.arraycopy(args, 0, this.execArgs, 1, args.length);
        } else {
            this.execArgs = new String[]{cmd};
        }
    }

    public ExecProcess(String[] cmd) {
        this.execArgs = cmd;
    }

    public ExecProcess(String cmdStr) {
        this(ExecProcess.parseCommandArguments(cmdStr));
    }

    public ExecProcess(Process process) {
        this((String[])null);
        this.process = process;
    }

    public ExecProcess(ThreadMain main) {
        this(new ThreadProcess(main));
    }

    private static String[] parseCommandArguments(String cmdStr) {
        if (cmdStr == null) {
            return null;
        }
        String c = cmdStr.trim();
        String cmd = null;
        String arg = null;
        int s = c.indexOf(" ");
        if (s >= 0) {
            cmd = c.substring(0, s);
            arg = c.substring(s + 1).trim();
        } else {
            cmd = c;
            arg = "";
        }
        Vector<String> cmdArgs = new Vector<String>();
        cmdArgs.add(cmd);
        cmdArgs.addAll(UIConfigProperties.stringToList("(" + arg + ")", false));
        return cmdArgs.toArray(new String[cmdArgs.size()]);
    }

    public boolean getStopButtonVisible() {
        return this.stopVisible;
    }

    public void setStopButtonVisible(boolean visible) {
        this.stopVisible = visible;
    }

    public void setHelpText(String text) {
        this.helpText = text;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public boolean isValid() throws NoCommand, NonExistantCommand, NotAbsoluteCommand {
        if (this.process != null) {
            return true;
        }
        if (this.execArgs == null || this.execArgs.length == 0) {
            throw new NoCommand();
        }
        File cmdFile = new File(this.execArgs[0]);
        if (!cmdFile.isAbsolute()) {
            throw new NotAbsoluteCommand(cmdFile.toString());
        }
        if (!cmdFile.exists() || !cmdFile.isFile()) {
            throw new NonExistantCommand(cmdFile.toString());
        }
        return true;
    }

    public Process getProcess() {
        return this.process;
    }

    public void destroy() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public void close() {
        if (this.process instanceof ThreadProcess) {
            ((ThreadProcess)this.process).close();
        } else if (!this.isFinished()) {
            this.destroy();
        }
    }

    public int waitFor(int timeout) {
        return this.getExitValue(timeout);
    }

    public int getExitValue() {
        return this.getExitValue(2000);
    }

    public int getExitValue(int timeout) {
        if (this.process == null) {
            return -1;
        }
        while (true) {
            try {
                return this.process.exitValue();
            }
            catch (IllegalThreadStateException itse) {
                if (timeout <= 0) {
                    return -2;
                }
                try {
                    Thread.sleep(200L);
                    timeout -= 200;
                }
                catch (Throwable t) {
                    return -3;
                }
            }
        }
    }

    public boolean isFinished() {
        return this.process == null || this.getExitValue(0) >= 0;
    }

    public void execCommand(int timeout) throws NoCommand, NonExistantCommand, NotAbsoluteCommand, ErrorExecutingCommand {
        if (timeout > 0) {
            ExecOutputManager etm = this.startExecOutputManager(null);
            if (!etm.isFinished(timeout >= 0 ? timeout : TIMEOUT_MAX)) {
                etm.destroy();
            }
        } else {
            this.exec();
        }
    }

    public String getStandardOutput(int timeout) {
        return this.getExecOutput(timeout).getStdout();
    }

    public String getOutput(int timeout) {
        return this.getExecOutput(timeout).getOutput();
    }

    private ExecOutputManager startExecOutputManager(ExecOutputListener output) throws NoCommand, NonExistantCommand, NotAbsoluteCommand, ErrorExecutingCommand {
        if (this.execManager == null) {
            this.execManager = new ExecOutputManager(this, output);
        } else if (output != null) {
            output.appendMessage(this.execManager.getOutput());
            output.setFinished(this);
        }
        return this.execManager;
    }

    private ExecOutputManager getExecOutput(int timeout) {
        ExecOutputManager etm = null;
        try {
            etm = this.startExecOutputManager(null);
            if (etm.isFinished(timeout >= 0 ? timeout : TIMEOUT_MAX)) {
                return etm;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        etm.destroy();
        return etm;
    }

    public String getCommandString() {
        if (this.execArgs == null) {
            return "";
        }
        String[] cmd = this.execArgs;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cmd.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            if (cmd[i].indexOf(" ") >= 0) {
                sb.append("'").append(cmd[i]).append("'");
                continue;
            }
            sb.append(cmd[i]);
        }
        return sb.toString();
    }

    public String toString() {
        if (this.execArgs == null) {
            return "<null>";
        }
        String[] cmd = this.execArgs;
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < cmd.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('\"').append(cmd[i]).append('\"');
        }
        sb.append(")");
        return sb.toString();
    }

    private Process exec() throws NoCommand, NonExistantCommand, NotAbsoluteCommand, ErrorExecutingCommand {
        if (this.process != null) {
            if (this.process instanceof ThreadProcess) {
                ((ThreadProcess)this.process).start();
                this.startTime = System.currentTimeMillis();
            }
            return this.process;
        }
        this.isValid();
        try {
            Print.dprintln((String)("Exec: " + this.toString()));
            this.process = Runtime.getRuntime().exec(this.execArgs);
            this.startTime = System.currentTimeMillis();
            return this.process;
        }
        catch (Throwable t) {
            Print.dprintStackTrace((String)"Error executing", (Throwable)t);
            throw new ErrorExecutingCommand(this.execArgs[0], t);
        }
    }

    public long getTimeLapse() {
        return this.startTime > 0L ? System.currentTimeMillis() - this.startTime : -1L;
    }

    public static void showConsole(ExecProcess ep, String title) {
        ExecProcess.showConsole(ep, title, false);
    }

    public static void showConsole(ExecProcess[] ep, String title) {
        ExecProcess.showConsole(ep, title, false);
    }

    public static void showConsole(ExecProcess ep, String title, boolean printCommandLine) {
        new ExecConsole(title).showConsole(ep, printCommandLine);
    }

    public static void showConsole(ExecProcess[] ep, String title, boolean printCommandLine) {
        new ExecConsole(title).showConsole(ep, printCommandLine);
    }

    public static void showConsole(Throwable t, String title) {
        new ExecConsole(title).showConsole(t);
    }

    public static void showConsole(String s, String title) {
        new ExecConsole(title).showConsole(s);
    }

    public static void debugTest() {
        if (!UIConfig.debugMode()) {
            return;
        }
        ExecProcess[] exe = new ExecProcess[]{new ExecProcess("/usr/bin/sleep 10"), new ExecProcess("/usr/bin/ls -l /tmp"), new ExecProcess("/usr/bin/sleep 10"), new ExecProcess("/usr/bin/ls -l /export/ws"), new ExecProcess("/usr/bin/sleep 5")};
        ExecProcess.showConsole(exe, "ExecProcess Test", true);
    }

    private static class ExecConsole
    extends UIDialog
    implements ExecOutputListener {
        private int execCurrent = -1;
        private ExecProcess[] execProcess = null;
        private boolean printCommandLine = false;
        private UITitledHTMLText helpText = null;
        private UITitledTextArea consoleText = null;
        private UIButton stopBtn = null;
        private UIButton closeBtn = null;
        private StringBuffer printBuffer = new StringBuffer();
        private UIActionDispatcher flushBuffer = new UIActionDispatcher((Object)this, "flushPrintBuffer");
        private boolean isFlushing = false;

        public ExecConsole(String title) {
            super(DT.getApplicationFrame(), true);
            this.initLayout(title);
        }

        private void initLayout(String title) {
            this.setTitle(title != null ? title : CONSOLE_TITLE);
            this.setSize(new Dimension(700, 600));
            this.centerOnScreen();
            UITitledBox contentPane = super.getContentBox();
            GridBagConstraints c = contentPane.getGBConstraints();
            c.insets = new Insets(0, 0, 5, 0);
            this.helpText = new UITitledHTMLText(null, false);
            c.weightx = 0.5;
            c.weighty = 0.0;
            c.fill = 2;
            contentPane.add((Component)this.helpText, c);
            this.helpText.setVisible(false);
            this.consoleText = new UITitledTextArea(null, false);
            this.consoleText.setLineWrap(UIConfig.getConfigBoolean("ui.ExecProcess.consoleWordWrap"));
            this.consoleText.setTextDisabledBackground(CONSOLE_BACKGROUND_COLOR);
            this.consoleText.setReadOnly(true, true);
            this.consoleText.setFont(new Font("Monospaced", 0, 12));
            c.weightx = 0.5;
            c.weighty = 0.5;
            c.fill = 1;
            contentPane.add((Component)this.consoleText, c);
            UIControlButtonBox buttonPanel = new UIControlButtonBox(null, false);
            buttonPanel.setControlButtonLocation(101);
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.anchor = 13;
            c.fill = 0;
            contentPane.add((Component)buttonPanel, c);
            this.stopBtn = new UIButton(STOP_BUTTON, STOP_BUTTON_MNEMONIC, new ActionListener(this){
                private final /* synthetic */ ExecConsole this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    ExecConsole.access$400(this.this$0);
                }
            });
            buttonPanel.addControlButton(this.stopBtn);
            this.closeBtn = UIButton.createCloseButton(new ActionListener(this){
                private final /* synthetic */ ExecConsole this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    ExecConsole.access$500(this.this$0);
                }
            });
            buttonPanel.addControlButton(this.closeBtn);
        }

        public void setStopButtonVisible(boolean visible) {
            this.stopBtn.setVisible(visible);
        }

        private void destroyProcess() {
            if (this.execProcess != null) {
                for (int i = 0; i < this.execProcess.length; ++i) {
                    this.execProcess[i].destroy();
                }
            }
        }

        private void closeConsole() {
            if (this.execProcess != null) {
                for (int i = 0; i < this.execProcess.length; ++i) {
                    this.execProcess[i].close();
                }
                this.execProcess = null;
            }
            this.dispose();
        }

        private void _startProcess(int ndx) {
            if (ndx >= 0 && ndx < this.execProcess.length) {
                String cs;
                this.execCurrent = ndx;
                ExecProcess ep = this.execProcess[this.execCurrent];
                String help = ep.getHelpText();
                if (help != null && !help.equals("")) {
                    this.setHelpText(help);
                }
                if (this.printCommandLine && (cs = ep.getCommandString()) != null && !cs.equals("")) {
                    this.appendMessage("% " + cs + "\n\n");
                }
                this._setFinished(false);
                try {
                    ep.startExecOutputManager(this);
                }
                catch (Throwable t) {
                    Print.dprintStackTrace((String)t.toString(), (Throwable)t);
                    this.appendMessage("\n[" + t.toString() + "]\n");
                    this.appendSeparator("*");
                    this._setFinished(true);
                }
            } else {
                this.execCurrent = -1;
            }
        }

        public void showConsole(ExecProcess[] ep, boolean printCommandLine) {
            this.consoleText.setText("");
            this.printCommandLine = printCommandLine;
            this.execProcess = ep;
            if (ep != null && ep.length > 0) {
                this.setStopButtonVisible(ep[0].getStopButtonVisible());
            }
            this._startProcess(0);
            this.show();
        }

        public void showConsole(ExecProcess ep, boolean printCommandLine) {
            this.showConsole(new ExecProcess[]{ep}, printCommandLine);
        }

        public void showConsole(Throwable t) {
            this.showConsole(t, true);
        }

        public void showConsole(Throwable t, boolean clear) {
            this.execProcess = null;
            this.execCurrent = -1;
            Print.dprintStackTrace((String)t.toString(), (Throwable)t);
            if (clear) {
                this.consoleText.setText("");
            } else {
                this.consoleText.appendText("\n");
            }
            this.consoleText.appendText("[" + t.toString() + "]");
            this._setFinished(true);
            this.show();
        }

        public void showConsole(String s) {
            this.execProcess = null;
            this.execCurrent = -1;
            this.consoleText.setText(s);
            this._setFinished(true);
            this.show();
        }

        public void setHelpText(String text) {
            this.helpText.setVisible(text != null);
            this.helpText.setText(text != null ? text : "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushPrintBuffer() {
            StringBuffer stringBuffer = this.printBuffer;
            synchronized (stringBuffer) {
                this.isFlushing = true;
                this.consoleText.appendText(this.printBuffer.toString());
                this.printBuffer.setLength(0);
                this.isFlushing = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void appendOutput(String s, boolean isStdout) {
            StringBuffer stringBuffer = this.printBuffer;
            synchronized (stringBuffer) {
                this.printBuffer.append(s);
                if (!this.isFlushing) {
                    this.flushBuffer.invokeLater();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void appendMessage(String s) {
            StringBuffer stringBuffer = this.printBuffer;
            synchronized (stringBuffer) {
                this.printBuffer.append(s);
                if (!this.isFlushing) {
                    this.flushBuffer.invokeLater();
                }
            }
        }

        public void appendSeparator(String ch) {
            this.appendSeparator(ch, SEPARATOR_LENGTH);
        }

        public void appendSeparator(String ch, int len) {
            StringBuffer sb = new StringBuffer();
            if (ch == null || ch.equals("")) {
                ch = "#";
            }
            while (sb.length() < len) {
                sb.append(ch);
            }
            this.appendMessage(sb.toString() + "\n");
        }

        public void setFinished(Object obj) {
            if (this.execProcess != null) {
                ExecProcess ep = this.execProcess[this.execCurrent];
                int es = ep.getExitValue();
                long tenths = ep.getTimeLapse() / 100L;
                double sec = (double)tenths / 10.0;
                this.appendMessage("\n");
                this.appendSeparator("*");
                this.appendMessage(ExecProcess.EXEC_FINISHED(sec, es) + "\n");
                if (es == 0) {
                    this.appendSeparator("-");
                    if (this.execCurrent + 1 < this.execProcess.length) {
                        this.appendMessage("\n");
                        this._startProcess(this.execCurrent + 1);
                    } else {
                        this._setFinished(true);
                    }
                } else {
                    this.appendSeparator("*");
                    this._setFinished(true);
                }
            } else {
                this._setFinished(true);
            }
        }

        private void _setFinished(boolean finished) {
            this.stopBtn.setEnabled(!finished);
            this.closeBtn.setEnabled(finished);
            this.closeBtn.makeDefaultButton(finished);
        }

        static /* synthetic */ void access$400(ExecConsole x0) {
            x0.destroyProcess();
        }

        static /* synthetic */ void access$500(ExecConsole x0) {
            x0.closeConsole();
        }
    }

    private static class ExecOutputListenerThread
    extends Thread {
        private ExecProcess execProc = null;
        private InputStream input = null;
        private ExecOutputListener output = null;
        private boolean isStdout = false;
        private boolean isFinished = false;

        public ExecOutputListenerThread(ExecProcess exe, ExecOutputListener out, boolean std) {
            this.execProc = exe;
            this.output = out;
            this.isStdout = std;
        }

        public void start() {
            Print.printStackTrace((String)"Don't call this!");
        }

        public void startExec() throws NoCommand, NonExistantCommand, NotAbsoluteCommand, ErrorExecutingCommand {
            Process proc = this.execProc.exec();
            this.input = this.isStdout ? proc.getInputStream() : proc.getErrorStream();
            super.start();
        }

        public void run() {
            this.isFinished = false;
            byte[] data = new byte[1024];
            try {
                int m;
                while ((m = this.input.read(data)) >= 0) {
                    String s = new String(data, 0, m);
                    this.output.appendOutput(s, this.isStdout);
                }
            }
            catch (Exception x) {
                if (!this.execProc.isFinished()) {
                    this.output.appendMessage("\n[" + x.toString() + "] (" + this + ")\n");
                }
                Print.dprintln((String)("Exception on stream: " + this + " - " + x));
            }
            this.isFinished = true;
            this.output.setFinished(this);
            Print.dprintln((String)("Exiting: " + this));
        }

        public boolean isFinished() {
            return this.isFinished;
        }

        public String toString() {
            return this.isStdout ? "stdout" : "stderr";
        }
    }

    private static class ExecOutputManager
    implements ExecOutputListener {
        private ExecProcess execProc = null;
        private ExecOutputListener outputListener = null;
        private StringBuffer outputStdout = null;
        private StringBuffer outputAll = null;
        private ExecOutputListenerThread stdout = null;
        private ExecOutputListenerThread stderr = null;

        public ExecOutputManager(ExecProcess execProc, ExecOutputListener output) throws NoCommand, NonExistantCommand, NotAbsoluteCommand, ErrorExecutingCommand {
            this.execProc = execProc;
            this.execProc.exec();
            this.outputListener = output;
            this.outputStdout = new StringBuffer();
            this.outputAll = new StringBuffer();
            this.stdout = new ExecOutputListenerThread(this.execProc, this, true);
            this.stderr = new ExecOutputListenerThread(this.execProc, this, false);
            this.stdout.startExec();
            this.stderr.startExec();
        }

        public void setFinished(Object obj) {
            if (this.isFinished() && this.outputListener != null) {
                this.outputListener.setFinished(this);
            }
        }

        public boolean isFinished() {
            if (this.stdout.isFinished() && this.stderr.isFinished()) {
                if (!this.execProc.isFinished()) {
                    this.execProc.destroy();
                }
                return true;
            }
            return false;
        }

        public boolean isFinished(int timeout) {
            try {
                while (true) {
                    if (this.isFinished()) {
                        return true;
                    }
                    if (timeout > 0) {
                        Thread.sleep(TIMEOUT_INCREMENT);
                        timeout -= TIMEOUT_INCREMENT;
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }

        public void destroy() {
            this.execProc.destroy();
        }

        public void appendOutput(String s, boolean isStdout) {
            if (isStdout) {
                this.outputStdout.append(s);
            }
            this.outputAll.append(s);
            if (this.outputListener != null) {
                this.outputListener.appendOutput(s, isStdout);
            }
        }

        public void appendMessage(String s) {
            this.outputAll.append(s);
            if (this.outputListener != null) {
                this.outputListener.appendMessage(s);
            }
        }

        public String getStdout() {
            return this.outputStdout.toString();
        }

        public String getOutput() {
            return this.outputAll.toString();
        }
    }

    private static interface ExecOutputListener {
        public void appendOutput(String var1, boolean var2);

        public void appendMessage(String var1);

        public void setFinished(Object var1);
    }

    public static class ThreadProcess
    extends Process
    implements Runnable {
        private ThreadMain threadProcess = null;
        protected static final int STDOUT = 1;
        protected static final int STDERR = 2;
        private PipedOutputStream stdOutput = new PipedOutputStream();
        private PipedInputStream stdOutput_in = null;
        private PipedOutputStream stdError = null;
        private PipedInputStream stdError_in = null;
        private PipedInputStream stdInput = null;
        private PipedOutputStream stdInput_out = null;
        private boolean destroyRequested = false;
        private int exitStatus = -1;
        private Object exitLock = null;
        private Thread realThread = null;

        public ThreadProcess() {
            try {
                this.stdOutput_in = new PipedInputStream(this.stdOutput);
            }
            catch (IOException ioe) {
                Print.printStackTrace((String)"Creating StdOutput PipedInputStream", (Throwable)ioe);
            }
            this.stdError = new PipedOutputStream();
            try {
                this.stdError_in = new PipedInputStream(this.stdError);
            }
            catch (IOException ioe) {
                Print.printStackTrace((String)"Creating StdError PipedInputStream", (Throwable)ioe);
            }
            this.stdInput = new PipedInputStream();
            try {
                this.stdInput_out = new PipedOutputStream(this.stdInput);
            }
            catch (IOException ioe) {
                Print.printStackTrace((String)"Creating StdInput PipedOutputStream", (Throwable)ioe);
            }
            this.exitLock = new Object();
        }

        public ThreadProcess(ThreadMain tp) {
            this();
            this.setProcessThread(tp);
        }

        public void setProcessThread(ThreadMain tp) {
            this.threadProcess = tp;
            tp.setProcess(this);
        }

        public void destroy() {
            this.destroyRequested = true;
        }

        public void close() {
            this.destroy();
            try {
                this.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._closeStream(this.stdError_in);
            this._closeStream(this.stdOutput_in);
            this._closeStream(this.stdInput_out);
        }

        public int exitValue() {
            if (this.exitStatus < 0) {
                throw new IllegalThreadStateException("Thread hasn't completed");
            }
            return this.exitStatus;
        }

        public InputStream getErrorStream() {
            return this.stdError_in;
        }

        public InputStream getInputStream() {
            return this.stdOutput_in;
        }

        public OutputStream getOutputStream() {
            return this.stdInput_out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int waitFor() throws InterruptedException {
            Object object = this.exitLock;
            synchronized (object) {
                while (this.exitStatus < 0) {
                    this.exitLock.wait();
                }
            }
            return this.exitStatus;
        }

        public void start() {
            if (this.realThread == null) {
                this.realThread = new Thread(this);
                this.realThread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.threadProcess == null) {
                Print.dprintStackTrace((String)"'ThreadProcess' not specified.");
                return;
            }
            this.exitStatus = this.threadProcess.run();
            if (this.exitStatus < 0) {
                Print.dprintStackTrace((String)("Negative exit status! " + this.exitStatus));
                this.exitStatus = 0;
            }
            Object object = this.exitLock;
            synchronized (object) {
                this.exitLock.notifyAll();
            }
            this._closeStream(this.stdError);
            this._closeStream(this.stdOutput);
            this._closeStream(this.stdInput);
        }

        private void _closeStream(InputStream in) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void _closeStream(OutputStream out) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected OutputStream getStdError() {
            return this.stdError;
        }

        protected OutputStream getStdOutput() {
            return this.stdOutput;
        }

        protected InputStream getStdInput() {
            return this.stdInput;
        }

        protected void print(int f, String s) {
            OutputStream out = f == 1 ? this.getStdOutput() : this.getStdError();
            try {
                byte[] b = s.getBytes();
                out.write(b, 0, b.length);
                out.flush();
            }
            catch (IOException ioe) {
                Print.println((String)s);
                Print.printStackTrace((String)("Writing " + (f == 1 ? "StdOutput" : "StdError")), (Throwable)ioe);
            }
        }

        protected void println(int f, String s) {
            this.print(f, s + "\n");
        }

        protected void print(String s) {
            this.print(1, s);
        }

        protected void println(String s) {
            this.print(1, s + "\n");
        }

        protected void println(Throwable t) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            t.printStackTrace(ps);
            ps.close();
            StringTokenizer st = new StringTokenizer(bos.toString(), "\n");
            while (st.hasMoreTokens()) {
                this.print(2, st.nextToken() + "\n");
            }
            this.print(2, "\n");
        }

        protected boolean destroyRequested() {
            return this.destroyRequested;
        }
    }

    public static abstract class ThreadMain {
        private ThreadProcess process = null;

        public void setProcess(ThreadProcess process) {
            this.process = process;
        }

        public OutputStream getStdError() {
            return this.process.getStdError();
        }

        public OutputStream getStdOutput() {
            return this.process.getStdOutput();
        }

        public InputStream getStdInput() {
            return this.process.getStdInput();
        }

        public void print(int f, String s) {
            this.process.print(f, s);
        }

        public void println(int f, String s) {
            this.process.println(f, s);
        }

        public void print(String s) {
            this.process.print(s);
        }

        public void println(String s) {
            this.process.println(s);
        }

        public void println(Throwable t) {
            this.process.println(t);
        }

        public void printSeparator(String ch) {
            this.printSeparator(ch, SEPARATOR_LENGTH);
        }

        public void printSeparator(String ch, int len) {
            StringBuffer sb = new StringBuffer();
            if (ch == null || ch.equals("")) {
                ch = "#";
            }
            while (sb.length() < len) {
                sb.append(ch);
            }
            this.println(sb.toString());
        }

        public boolean destroyRequested() {
            return this.process.destroyRequested();
        }

        public abstract int run();
    }

    public static class ErrorExecutingCommand
    extends Exception {
        private Throwable error = null;

        public ErrorExecutingCommand(String m, Throwable t) {
            super(t.toString() + ": " + m);
            this.error = t;
        }
    }

    public static class NotAbsoluteCommand
    extends Exception {
        public NotAbsoluteCommand(String m) {
            super("Command path is not absolute: " + m);
        }
    }

    public static class NonExistantCommand
    extends Exception {
        public NonExistantCommand(String m) {
            super("Command does not exist: " + m);
        }
    }

    public static class NoCommand
    extends Exception {
        public NoCommand() {
            super("No command specified");
        }
    }
}

