/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.tools.common.cmp.ui.MappingEvaluator;
import com.sun.enterprise.tools.common.cmp.ui.SunOneUtilsCMP;
import com.sun.enterprise.tools.common.dd.CallProperty;
import com.sun.enterprise.tools.common.dd.PortInfo;
import com.sun.enterprise.tools.common.dd.ServiceRef;
import com.sun.enterprise.tools.common.dd.SunBaseBean;
import com.sun.enterprise.tools.common.dd.WebserviceEndpoint;
import com.sun.enterprise.tools.common.dd.appclient.SunApplicationClient;
import com.sun.enterprise.tools.common.dd.application.SunApplication;
import com.sun.enterprise.tools.common.dd.connector.ResourceAdapter;
import com.sun.enterprise.tools.common.dd.connector.SunConnector;
import com.sun.enterprise.tools.common.dd.ejb.CmpResource;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ejb.EnterpriseBeans;
import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.common.dd.webapp.Servlet;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.StringTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMappings;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import org.netbeans.modules.schema2beans.Schema2BeansException;

public class SunOneUtils {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SunOneUtils.class);
    private static final String SUN_ONE_DESCRIPTOR = "Sun_One_Descriptor";
    private static final String SUN_CMP_MAPPINGS = "sun_cmp_mappings";
    private static AbstractArchive abstractArch = null;

    private static String INVALID_FILENAME(String v0) {
        return localStrings.getLocalString("ui.uisunoneutils.invalid_filename", "{0} is not a valid Java name. Please provide a valid name.", new Object[]{v0});
    }

    private static String NO_FILENAME(String v0) {
        return localStrings.getLocalString("ui.uisunoneutils.no_filename", "No name provided. Please specify a name.", new Object[]{v0});
    }

    private static String DIR_NOT_ALLOWED(String v0) {
        return localStrings.getLocalString("ui.uisunoneutils.directory_not_allowed", "Filename may not be a directory: {0}", new Object[]{v0});
    }

    private static String INVALID_DIR(String v0) {
        return localStrings.getLocalString("ui.uisunoneutils.invalid_directory", "Invalid Directory :{0}. It does not exist or is read only.", new Object[]{v0});
    }

    private static String ALREADY_EXISTS(String v0) {
        return localStrings.getLocalString("ui.uisunoneutils.already_exists", "{0} already exists. Please specify a different name.", new Object[]{v0});
    }

    private static String NO_CMP_RESOURCE_JNDI_NAME(String v0) {
        return localStrings.getLocalString("ui.uisunoneutils.no_cmp_resource_jndi_name", "Please provide a CMP Resource JNDI Name for {0} and save your changes.", new Object[]{v0});
    }

    private SunOneUtils() {
    }

    public static String createUID() {
        Random generateId = new Random();
        int gen_id = generateId.nextInt();
        if (gen_id < 0) {
            gen_id = -gen_id;
        }
        return "" + gen_id;
    }

    public static void createSunOneXml(Set descSet) {
        Iterator i = descSet.iterator();
        while (i.hasNext()) {
            Object d = i.next();
            SunOneUtils.createSunOneXml((Descriptor)d);
        }
    }

    public static void createSunOneXml(Descriptor desc) {
        if (desc instanceof Application) {
            Application app = (Application)desc;
            SunApplication sunApp = (SunApplication)SunOneUtils.getSunDescriptor(desc);
            if (sunApp == null) {
                sunApp = SunApplication.createGraph();
                SunOneUtils.setSunDescriptor(desc, (SunBaseBean)sunApp);
                sunApp.setPassByReference("false");
                sunApp.graphManager().setDoctype("-//Sun Microsystems, Inc.//DTD Application Server 8.0 J2EE Application 1.4//EN", "http://www.sun.com/software/appserver/dtds/sun-application_1_4-0.dtd");
            }
            SunOneUtils.createSunOneXml(app.getEjbBundleDescriptors());
            SunOneUtils.createSunOneXml(app.getWebBundleDescriptors());
            SunOneUtils.createSunOneXml(app.getApplicationClientDescriptors());
            SunOneUtils.createSunOneXml(app.getRarDescriptors());
        } else if (desc instanceof ConnectorDescriptor) {
            ConnectorDescriptor rar = (ConnectorDescriptor)desc;
            if (SunOneUtils.getSunDescriptor(desc) == null) {
                SunConnector sunConnector = SunConnector.createGraph();
                sunConnector.graphManager().setDoctype("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 Connector 1.0//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-connector_1_0-0.dtd");
                sunConnector.setResourceAdapter(new ResourceAdapter());
                SunOneUtils.setSunDescriptor((Descriptor)rar, (SunBaseBean)sunConnector);
            }
        } else if (desc instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ebd = (EjbBundleDescriptor)desc;
            if (SunOneUtils.getSunDescriptor(desc) == null) {
                SunOneUtils.createSunEjbJar((EjbBundleDescriptor)desc);
            }
            Iterator itr1 = ebd.getEjbs().iterator();
            while (itr1.hasNext()) {
                EjbDescriptor next = (EjbDescriptor)itr1.next();
                Ejb ejb = (Ejb)SunOneUtils.getSunDescriptor((Descriptor)next);
                if (ejb != null) continue;
                ejb = SunOneUtils.createSunEjb(next);
                ((SunEjbJar)SunOneUtils.getSunDescriptor(desc)).getEnterpriseBeans().addEjb(ejb);
            }
        } else if (desc instanceof WebBundleDescriptor) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)desc;
            if (SunOneUtils.getSunDescriptor((Descriptor)wbd) == null) {
                SunWebApp sunWebApp = null;
                try {
                    sunWebApp = new SunWebApp();
                }
                catch (Schema2BeansException se) {
                    se.printStackTrace();
                    throw new RuntimeException(se.getMessage());
                }
                sunWebApp.graphManager().setDoctype("-//Sun Microsystems, Inc.//DTD Application Server 8.1 Servlet 2.4//EN", "http://www.sun.com/software/appserver/dtds/sun-web-app_2_4-1.dtd");
                SunOneUtils.setSunDescriptor((Descriptor)wbd, (SunBaseBean)sunWebApp);
            }
        } else if (desc instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor acd = (ApplicationClientDescriptor)desc;
            if (SunOneUtils.getSunDescriptor((Descriptor)acd) == null) {
                SunApplicationClient sunAppC = null;
                try {
                    sunAppC = new SunApplicationClient();
                }
                catch (Schema2BeansException se) {
                    se.printStackTrace();
                    throw new RuntimeException(se.getMessage());
                }
                sunAppC.graphManager().setDoctype("-//Sun Microsystems, Inc.//DTD Application Server 8.1 Application Client 1.4//EN", "http://www.sun.com/software/appserver/dtds/sun-application-client_1_4-1.dtd");
                SunOneUtils.setSunDescriptor((Descriptor)acd, (SunBaseBean)sunAppC);
            }
        } else {
            return;
        }
    }

    public static void createSunEjbJar(EjbBundleDescriptor ejbBundleDescriptor) {
        SunEjbJar sunEjbJar = SunEjbJar.createGraph();
        sunEjbJar.graphManager().setDoctype("-//Sun Microsystems, Inc.//DTD Application Server 8.1 EJB 2.1//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_2_1-1.dtd");
        SunOneUtils.setSunDescriptor((Descriptor)ejbBundleDescriptor, (SunBaseBean)sunEjbJar);
        EnterpriseBeans enterpriseBeans = new EnterpriseBeans();
        sunEjbJar.setEnterpriseBeans(enterpriseBeans);
        enterpriseBeans.setName(ejbBundleDescriptor.getDisplayName());
        if (ejbBundleDescriptor.containsCMPEntity() && SunOneUtils.getSunCmpMappings((Descriptor)ejbBundleDescriptor) == null) {
            SunCmpMappings sunCmpMappings = SunCmpMappings.createGraph();
            sunCmpMappings.graphManager().setDoctype("-//Sun Microsystems, Inc.//DTD Application Server 8.1 OR Mapping//EN", "http://www.sun.com/software/appserver/dtds/sun-cmp-mapping_1_2.dtd");
            SunOneUtils.setSunCmpMappings((Descriptor)ejbBundleDescriptor, sunCmpMappings);
        }
    }

    public static Ejb createSunEjb(EjbDescriptor ejbDesc) {
        return SunOneUtils.createSunEjb(ejbDesc, null);
    }

    public static Ejb createSunEjb(EjbDescriptor ejbDesc, Ejb ejb) {
        Ejb ejb2 = ejb = ejb == null ? new Ejb() : (Ejb)ejb.clone();
        if (ejb.getEjbName() == null || "".equals(ejb.getEjbName())) {
            ejb.setEjbName(ejbDesc.getDisplayName());
        }
        String jndiName = ejb.getJndiName();
        if ((ejbDesc instanceof EjbEntityDescriptor || ejbDesc instanceof EjbSessionDescriptor) && ejbDesc.isRemoteInterfacesSupported() && (ejb.getJndiName() == null || "".equals(ejb.getJndiName()))) {
            ejb.setJndiName(ejbDesc.getDisplayName());
        }
        SunOneUtils.setSunDescriptor((Descriptor)ejbDesc, (SunBaseBean)ejb);
        return ejb;
    }

    public static void mergeEjbBundles(EjbBundleDescriptor target, EjbBundleDescriptor newebd) {
        EnterpriseBeans eb = ((SunEjbJar)SunOneUtils.getSunDescriptor((Descriptor)target)).getEnterpriseBeans();
        Iterator ejbs = newebd.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
            Ejb ejb = SunOneUtils.createSunEjb(ejbDescriptor, (Ejb)SunOneUtils.getSunDescriptor((Descriptor)ejbDescriptor));
            ((SunEjbJar)SunOneUtils.getSunDescriptor((Descriptor)target)).getEnterpriseBeans().addEjb(ejb);
        }
    }

    public static void removeSunEjb(EjbBundleDescriptor ebd, EjbDescriptor ejb) {
        ((SunEjbJar)SunOneUtils.getSunDescriptor((Descriptor)ebd)).getEnterpriseBeans().removeEjb((Ejb)SunOneUtils.getSunDescriptor((Descriptor)ejb));
        SunCmpMappings scms = SunOneUtils.getSunCmpMappings((Descriptor)ebd);
        SunOneUtilsCMP.removeBean(scms, ejb.getName());
    }

    public static boolean isJndiUnique(Application app, String test) {
        if (app == null) {
            return true;
        }
        HashSet<String> jndiSet = new HashSet<String>();
        Iterator itr = app.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            Iterator itr1 = ejbBundleDescriptor.getEjbs().iterator();
            while (itr1.hasNext()) {
                EjbDescriptor ejbDesc = (EjbDescriptor)itr1.next();
                jndiSet.add(ejbDesc.getJndiName());
            }
        }
        if (jndiSet.contains(test)) {
            UIOptionPane.showErrorDialog(null, SunOneUtils.ALREADY_EXISTS(test));
            return false;
        }
        return true;
    }

    public static void createSunWebApp(WebBundleDescriptor webBundleDescriptor) {
        SunWebApp sunWebApp = SunWebApp.createGraph();
        sunWebApp.graphManager().setDoctype("-//Sun Microsystems, Inc.//DTD Application Server 8.1 Servlet 2.4//EN", "http://www.sun.com/software/appserver/dtds/sun-web-app_2_4-1.dtd");
        SunOneUtils.setSunDescriptor((Descriptor)webBundleDescriptor, (SunBaseBean)sunWebApp);
    }

    public static Servlet createSunServlet(WebComponentDescriptor servletDesc) {
        return SunOneUtils.createSunServlet(servletDesc, null);
    }

    public static Servlet createSunServlet(WebComponentDescriptor servletDesc, Servlet servlet) {
        Servlet servlet2 = servlet = servlet == null ? new Servlet() : (Servlet)servlet.clone();
        if (servlet.getServletName() == null || "".equals(servlet.getServletName())) {
            servlet.setServletName(servletDesc.getCanonicalName());
        }
        SunOneUtils.setSunDescriptor((Descriptor)servletDesc, (SunBaseBean)servlet);
        return servlet;
    }

    public static WebserviceEndpoint createSunWebserviceEndpoint(WebServiceEndpoint wse) {
        return SunOneUtils.createSunWebserviceEndpoint(wse, null);
    }

    public static WebserviceEndpoint createSunWebserviceEndpoint(WebServiceEndpoint wse, WebserviceEndpoint endpoint) {
        WebserviceEndpoint webserviceEndpoint = endpoint = endpoint == null ? new WebserviceEndpoint() : (WebserviceEndpoint)endpoint.clone();
        if (endpoint.getPortComponentName() == null || "".equals(endpoint.getPortComponentName())) {
            endpoint.setPortComponentName(wse.getEndpointName());
        }
        SunOneUtils.setSunDescriptor((Descriptor)wse, (SunBaseBean)endpoint);
        return endpoint;
    }

    public static void removeSunServlet(WebBundleDescriptor wbd, WebComponentDescriptor web) {
        SunWebApp swa = (SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)wbd);
        Servlet servlet = (Servlet)SunOneUtils.getSunDescriptor((Descriptor)web);
        if (servlet == null) {
            for (int i = 0; i < swa.sizeServlet(); ++i) {
                if (!swa.getServlet(i).getServletName().equals(web.getCanonicalName())) continue;
                servlet = swa.getServlet(i);
                break;
            }
        }
        swa.removeServlet(servlet);
    }

    public static void setSunDescriptor(Descriptor desc, SunBaseBean sbb) {
        if (desc == null) {
            return;
        }
        desc.addExtraAttribute(SUN_ONE_DESCRIPTOR, (Object)sbb);
    }

    public static SunBaseBean getSunDescriptor(Descriptor desc) {
        if (desc == null) {
            return null;
        }
        return (SunBaseBean)desc.getExtraAttribute(SUN_ONE_DESCRIPTOR);
    }

    public static void copySunDescriptor(Descriptor from, Descriptor to) {
        if (from == null || to == null) {
            return;
        }
        SunBaseBean sbb = SunOneUtils.getSunDescriptor(from);
        SunOneUtils.setSunDescriptor(to, sbb);
    }

    public static void setSunCmpMappings(Descriptor desc, SunCmpMappings scm) {
        desc.addExtraAttribute(SUN_CMP_MAPPINGS, (Object)scm);
    }

    public static SunCmpMappings getSunCmpMappings(Descriptor desc) {
        return (SunCmpMappings)desc.getExtraAttribute(SUN_CMP_MAPPINGS);
    }

    public static SunCmpMappings readSunCmpMappings(InputStream is) {
        try {
            return SunCmpMappings.createGraph((InputStream)is);
        }
        catch (Schema2BeansException se) {
            se.printStackTrace();
            throw new RuntimeException(se.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SunCmpMappings createSunCmpMappings(AbstractArchive absArch, String jarName) {
        InputStream is = null;
        SunCmpMappings scm = null;
        if (absArch.getArchiveUri().endsWith(".ear")) {
            try {
                AbstractArchive embeddedArch = absArch.getEmbeddedArchive(jarName);
                if (embeddedArch == null) return scm;
                is = embeddedArch.getEntry("META-INF/sun-cmp-mappings.xml");
                if (is == null) return scm;
                return SunOneUtils.readSunCmpMappings(is);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new RuntimeException(ioe.getMessage());
            }
        }
        if (!absArch.getArchiveUri().endsWith(jarName)) return scm;
        try {
            is = absArch.getEntry("META-INF/sun-cmp-mappings.xml");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException(ioe.getMessage());
        }
        if (is == null) return scm;
        return SunOneUtils.readSunCmpMappings(is);
    }

    public static void removeSunCmpMappings(Descriptor desc) {
        desc.removeExtraAttribute(SUN_CMP_MAPPINGS);
    }

    public static void setAbstractArchive(AbstractArchive abstractArch) {
        SunOneUtils.abstractArch = abstractArch;
    }

    public static AbstractArchive getAbstractArchive() {
        return abstractArch;
    }

    public static void removeServiceRef(Descriptor d, String nm) {
        SunApplicationClient sac;
        if (d == null) {
            return;
        }
        SunBaseBean sbb = SunOneUtils.getSunDescriptor(d);
        if (sbb == null) {
            return;
        }
        ServiceRef sr = null;
        if (sbb instanceof Ejb) {
            Ejb sunEjb = (Ejb)sbb;
            sr = SunOneUtils.searchServiceRef(sunEjb.getServiceRef(), nm);
            if (sr != null) {
                sunEjb.removeServiceRef(sr);
            }
        } else if (sbb instanceof SunWebApp) {
            SunWebApp swa = (SunWebApp)sbb;
            sr = SunOneUtils.searchServiceRef(swa.getServiceRef(), nm);
            if (sr != null) {
                swa.removeServiceRef(sr);
            }
        } else if (sbb instanceof SunApplicationClient && (sr = SunOneUtils.searchServiceRef((sac = (SunApplicationClient)sbb).getServiceRef(), nm)) != null) {
            sac.removeServiceRef(sr);
        }
    }

    public static ServiceRef getServiceRefByName(SunBaseBean sbb, String nm) {
        SunApplicationClient sac;
        if (sbb == null) {
            return null;
        }
        ServiceRef sr = null;
        if (sbb instanceof Ejb) {
            Ejb sunEjb = (Ejb)sbb;
            sr = SunOneUtils.searchServiceRef(sunEjb.getServiceRef(), nm);
            if (sr == null) {
                sr = new ServiceRef();
                sr.setServiceRefName(nm);
                sunEjb.addServiceRef(sr);
            }
        } else if (sbb instanceof SunWebApp) {
            SunWebApp swa = (SunWebApp)sbb;
            sr = SunOneUtils.searchServiceRef(swa.getServiceRef(), nm);
            if (sr == null) {
                sr = new ServiceRef();
                sr.setServiceRefName(nm);
                swa.addServiceRef(sr);
            }
        } else if (sbb instanceof SunApplicationClient && (sr = SunOneUtils.searchServiceRef((sac = (SunApplicationClient)sbb).getServiceRef(), nm)) == null) {
            sr = new ServiceRef();
            sr.setServiceRefName(nm);
            sac.addServiceRef(sr);
        }
        return sr;
    }

    private static ServiceRef searchServiceRef(ServiceRef[] rrArray, String name) {
        if (rrArray == null) {
            return null;
        }
        for (int i = 0; i < rrArray.length; ++i) {
            if (!name.equals(rrArray[i].getServiceRefName())) continue;
            return rrArray[i];
        }
        return null;
    }

    public static void replaceServiceRef(SunBaseBean sbb, ServiceRef oldObj, ServiceRef newObj) {
        if (sbb instanceof Ejb) {
            Ejb sunEjb = (Ejb)sbb;
            if (oldObj != null) {
                sunEjb.removeServiceRef(oldObj);
            }
            if (!SunOneUtils.isEmptyElement(newObj)) {
                sunEjb.addServiceRef(newObj);
            }
        } else if (sbb instanceof SunWebApp) {
            SunWebApp swa = (SunWebApp)sbb;
            if (oldObj != null) {
                swa.removeServiceRef(oldObj);
            }
            if (!SunOneUtils.isEmptyElement(newObj)) {
                swa.addServiceRef(newObj);
            }
        } else if (sbb instanceof SunApplicationClient) {
            SunApplicationClient sac = (SunApplicationClient)sbb;
            if (oldObj != null) {
                sac.removeServiceRef(oldObj);
            }
            if (!SunOneUtils.isEmptyElement(newObj)) {
                sac.addServiceRef(newObj);
            }
        }
    }

    private static boolean isEmptyElement(ServiceRef sr) {
        if (sr == null) {
            return true;
        }
        return sr.sizePortInfo() == 0 && sr.sizeCallProperty() == 0 && sr.getWsdlOverride() == null;
    }

    public static void copyServiceRef(ServiceRef to, ServiceRef from) {
        to.setServiceRefName(from.getServiceRefName());
        PortInfo[] piA = from.getPortInfo();
        from.setPortInfo(null);
        to.setPortInfo(piA);
        CallProperty[] cpA = from.getCallProperty();
        from.setCallProperty(null);
        to.setCallProperty(cpA);
        to.setWsdlOverride(from.getWsdlOverride());
    }

    public static PortInfo findPortInfoByEndpointName(ServiceRef sunServiceRef, String endpointName) {
        PortInfo[] piA = sunServiceRef.getPortInfo();
        for (int i = 0; i < piA.length; ++i) {
            String nm = piA[i].getServiceEndpointInterface();
            if (nm == null || !nm.equals(endpointName)) continue;
            return piA[i];
        }
        return null;
    }

    public static void renamePortInfoByEndpointName(ServiceRef sunServiceRef, String oldName, String newName) {
        PortInfo pi = SunOneUtils.findPortInfoByEndpointName(sunServiceRef, oldName);
        if (pi != null) {
            pi.setServiceEndpointInterface(newName);
        }
    }

    public static void removePortInfoByEndpointName(ServiceRef sunServiceRef, String endpointName) {
        PortInfo pi = SunOneUtils.findPortInfoByEndpointName(sunServiceRef, endpointName);
        if (pi != null) {
            sunServiceRef.removePortInfo(pi);
        }
    }

    public static List preDeploymentCheck(EjbBundleDescriptor descriptor) {
        List schemaFileList;
        List errors;
        CmpResource cmpResource;
        ArrayList<String> retVal = new ArrayList<String>();
        if (descriptor == null) {
            Print.dprintln((String)"preDeploymentCheck() called with null descriptor");
            return retVal;
        }
        if (!DescriptorTools.isCmpBeanPresent(descriptor)) {
            return retVal;
        }
        SunCmpMappings scm = SunOneUtils.SunCmpMappingsToBeWritenOut(descriptor);
        if (scm == null) {
            return retVal;
        }
        SunEjbJar sunEjbJar = (SunEjbJar)SunOneUtils.getSunDescriptor((Descriptor)descriptor);
        EnterpriseBeans eb = sunEjbJar.getEnterpriseBeans();
        CmpResource cmpResource2 = cmpResource = eb == null ? null : eb.getCmpResource();
        if (cmpResource == null || StringTools.isEmpty(cmpResource.getJndiName())) {
            retVal.add(SunOneUtils.NO_CMP_RESOURCE_JNDI_NAME(descriptor.getDisplayName()));
        }
        if ((errors = MappingEvaluator.evaluate(schemaFileList = SunOneUtils.getSchemaFileList(descriptor), scm)) != null && errors.size() > 0) {
            retVal.addAll(errors);
        }
        return retVal;
    }

    public static List getSchemaFileList(EjbBundleDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Vector<String> schemaFileList = new Vector<String>();
        List entries = ModuleArchive.getModuleArchive((Descriptor)descriptor).getEntryNames();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Object item = i.next();
            String archItem = FileTools.ToArchSep(item.toString());
            if (!FileTools.StrFileHasExtension(archItem, SunOneUtilsCMP.DBSCHEMA_EXTENSION_ARRAY)) continue;
            schemaFileList.add(archItem);
        }
        return entries;
    }

    public static SunCmpMappings SunCmpMappingsToBeWritenOut(EjbBundleDescriptor descriptor) {
        SunCmpMappings scm = null;
        scm = SunOneUtilsCMP.getExistingMappingContext((Descriptor)descriptor) != null ? SunOneUtilsCMP.getSunCmpMappings(SunOneUtilsCMP.getExistingMappingContext((Descriptor)descriptor), descriptor) : (SunCmpMappings)descriptor.getExtraAttribute(SUN_CMP_MAPPINGS);
        if (scm != null) {
            SunCmpMapping[] maps = null;
            maps = scm.getSunCmpMapping();
            if (null == maps || maps.length < 1) {
                return null;
            }
            boolean writeIt = false;
            for (int i = 0; i < maps.length; ++i) {
                String schema = maps[i].getSchema();
                if (null == schema || schema.trim().length() <= 0) continue;
                writeIt |= true;
            }
            if (!writeIt) {
                return null;
            }
        }
        return scm;
    }
}

