/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.common.dd.connector.MapElement;
import com.sun.enterprise.tools.common.dd.connector.RoleMap;
import com.sun.enterprise.tools.common.dd.connector.SunConnector;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.PrincipalDialog;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JPanel;

public class RoleMapConnectorInspector
extends InspectorPane
implements DescriptionInspector.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RoleMapConnectorInspector.class);
    private final String TABNAME = localStrings.getLocalString("ui.sunone.rolemapconnectorinspector.sunconnector_tab", "Role Map");
    private final String TOOLTIP = localStrings.getLocalString("ui.sunone.rolemapconnectorinspector.sunconnector_tool_tip", "Sun Connector Role Map Configuration");
    private final String ROLEMAP_TABLE_USERNAME = localStrings.getLocalString("ui.sunone.rolemapconnectorinspector.rolemap_table_username", "UserName");
    private final String ROLEMAP_TABLE_PASSWORD = localStrings.getLocalString("ui.sunone.rolemapconnectorinspector.rolemap_table_password", "Password");
    private final String ROLEMAP_TABLE_CREDENTIAL = localStrings.getLocalString("ui.sunone.rolemapconnectorinspector.rolemap_table_credential", "Credential");
    private final String ROLEMAP_TABLE_PRINCIPAL = localStrings.getLocalString("ui.sunone.rolemapconnectorinspector.rolemap_principal", "# of Principal");
    private final String NO_WINDOW = localStrings.getLocalString("ui.sunone.MappingInspector.No_Window", "Didn't find a parent window, using 'null'.");
    private final String ROLEMAP_TABLE_ACC_DSC = localStrings.getLocalString("ui.sunone.rolemapconnectorinspector.rolemap_acc_dsc", "Table for editing Role Maps for the Resource Adapter");
    private final String PRINCIPAL_EDIT_BUTTON = localStrings.getLocalString("ui.sunone.rolemapconnectorinspector.rolemap_principal_edit_button", "E}Edit Principal");
    private final String DESCRIPTION_ACC_DSC = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.resourcedadapter_description.acc_dsc", "Enter Description for the Resource Adapter");
    private final String MISSING_USERNAME = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.missing_username", "All Backend principal must have a user name");
    private final String MISSING_PASSWORD = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.missing_password", "All Backend principal must have a Password");
    private final String MISSING_CREDENTIAL = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.missing_credential", "All Backend principal must have a Credential");
    private final String MISSING_PRINCIPAL = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.missing_principal", "All Backend principal must have at least 1 principal.");
    private final String TABLE_TITLE = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.table_title", "Backend Principals");
    private final String ROLE_MAP_ID = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.role_map_id", "Map Id");
    private final String ROLE_MAP_ID_ACC_DSC = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.role_map_id_acc_dsc", "Enter Map Id for Sun Connector Role Mapping");
    private final String ATR_MAPID = "map-id";
    private final String MAPPING = "mappingId";
    private final String ATR_USERNAME = "user-name";
    private final String ATR_PASSWORD = "password";
    private final String ATR_CREDENTIAL = "credential";
    private SunConnector sunConnector = null;
    private RoleMap roleMap;
    private MapElement mapElement;
    private UITitledTextField mapIdField = null;
    private RoleMapTable roleMapTable = null;
    private static String wizardHelpID = "SunConnectorRoleMap";
    private static String deployHelpID = "SunConnectorRoleMap";
    private ConnectorDescriptor descriptor = null;
    private DescriptionInspector.DialogDisplayButton descriptionField = null;
    private UITitledTable pnlRoleMap = null;
    private PrincipalDialog principalDialog = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new RoleMapConnectorInspector(mode);
    }

    public String getTabName() {
        return this.TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return ConnectorDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            if (desc instanceof ConnectorDescriptor) {
                this.descriptor = (ConnectorDescriptor)desc;
                this.roleMapTable.clearTableData();
                this.sunConnector = (SunConnector)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor);
                this.roleMap = this.sunConnector.getRoleMap();
                if (this.roleMap == null) {
                    this.roleMap = new RoleMap();
                    this.sunConnector.setRoleMap(this.roleMap);
                }
            } else {
                this.descriptor = null;
                this.sunConnector = null;
                this.roleMap = null;
            }
        }
    }

    private RoleMapConnectorInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.setToolTipText(this.TOOLTIP);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 5, 0, 5);
        c.fill = 2;
        this.mapIdField = new UITitledTextField(this.ROLE_MAP_ID, false);
        this.mapIdField.getAccessibleContext().setAccessibleDescription(this.ROLE_MAP_ID_ACC_DSC);
        this.mapIdField.setReadOnly(true);
        this.mapIdField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String sel = RoleMapConnectorInspector.this.mapIdField.getText();
                ((SunConnector)SunOneUtils.getSunDescriptor((Descriptor)RoleMapConnectorInspector.this.descriptor)).getRoleMap().setAttributeValue("map-id", sel == null ? "" : sel);
            }
        });
        this.add((Component)this.mapIdField, c);
        c.weightx = 0.5;
        c.weighty = 0.3;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.pnlRoleMap = new UITitledTable(this.TABLE_TITLE, true);
        this.pnlRoleMap.getAccessibleContext().setAccessibleDescription(this.ROLEMAP_TABLE_ACC_DSC);
        this.roleMapTable = new RoleMapTable(new RoleMapTableModel());
        this.pnlRoleMap.setTableView(this.roleMapTable);
        UIButton btnAddRoleMap = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoleMapConnectorInspector.this.addRoleMapAction();
            }
        });
        this.pnlRoleMap.addControlButton(btnAddRoleMap);
        this.pnlRoleMap.addSelectionEnabledButton(UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                RoleMapConnectorInspector.this.deleteRoleMapAction();
            }
        }));
        UIButton btnEditRoleMap = UIButton.createEditButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                RoleMapConnectorInspector.this.editRoleMapAction();
            }
        });
        UIButton.setButtonText(btnEditRoleMap, this.PRINCIPAL_EDIT_BUTTON);
        this.pnlRoleMap.addSelectionEnabledButton(btnEditRoleMap);
        this.add((Component)this.pnlRoleMap, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 5, 0, 5);
        c.fill = 1;
        this.descriptionField = new DescriptionInspector.DialogDisplayButton(this);
        this.descriptionField.getAccessibleContext().setAccessibleDescription(this.DESCRIPTION_ACC_DSC);
        this.add((Component)this.descriptionField, c);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        if (this.roleMap.getAttributeValue("map-id") == null) {
            String mapId = "mappingId";
            if (this.descriptor.getApplication() != null) {
                Iterator it = this.descriptor.getApplication().getRarDescriptors().iterator();
                int i = 0;
                while (it.hasNext()) {
                    ConnectorDescriptor cd = (ConnectorDescriptor)it.next();
                    if (!mapId.equals(((SunConnector)SunOneUtils.getSunDescriptor((Descriptor)cd)).getRoleMap().getAttributeValue("map-id"))) continue;
                    mapId = "mappingId" + ++i;
                }
            }
            this.mapIdField.setText(mapId);
            this.roleMap.setAttributeValue("map-id", mapId);
        } else {
            this.mapIdField.setText(this.roleMap.getAttributeValue("map-id"));
        }
        this.roleMapTable.updateTableData(this.roleMap.getMapElement());
        this.descriptionField.setDescriptionInspector(((SunConnector)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).getRoleMap().getDescription(), this.descriptor.getName(), this, this.descriptor);
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.roleMapTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_USERNAME);
            }
            return false;
        }
        if (this.roleMapTable.getRowWithValue(2, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_PASSWORD);
            }
            return false;
        }
        if (this.roleMapTable.getRowWithValue(3, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_CREDENTIAL);
            }
            return false;
        }
        if (this.roleMapTable.getRowWithValue(0, "0") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_PRINCIPAL);
            }
            return false;
        }
        return true;
    }

    private void addRoleMapAction() {
        if (!this.validateEntries(true)) {
            return;
        }
        MapElement me = new MapElement();
        me.setBackendPrincipal(true);
        me.setAttributeValue("BackendPrincipal", 0, "user-name", "");
        me.setAttributeValue("BackendPrincipal", 0, "password", "");
        me.setAttributeValue("BackendPrincipal", 0, "credential", "");
        this.roleMap.addMapElement(me);
        this.roleMapTable.selectRowWithValueOnUpdate(0, "0");
        this.invokeRefresh();
    }

    private void deleteRoleMapAction() {
        Object[] list = this.roleMapTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                MapElement ref = (MapElement)list[i];
                this.roleMap.removeMapElement(ref);
            }
            this.invokeRefresh();
        }
    }

    private void editRoleMapAction() {
        MapElement me = (MapElement)this.roleMapTable.getSelectedRowObject();
        if (me != null) {
            this.showPrincipalDialog(me);
            this.roleMapTable.updateTableData(this.roleMap.getMapElement());
            this.invokeRefresh();
        }
    }

    private void showPrincipalDialog(MapElement me) {
        MapElement oldMapElement = (MapElement)me.clone();
        if (this.principalDialog == null) {
            Window win = this.getMyParentWindow();
            if (win instanceof Dialog) {
                this.principalDialog = new PrincipalDialog((Dialog)win, (JPanel)this, me);
            } else if (win instanceof Frame) {
                this.principalDialog = new PrincipalDialog((Frame)win, (JPanel)this, me);
            } else {
                UIUtils.debugPrintln(this.NO_WINDOW);
                this.principalDialog = new PrincipalDialog((Frame)null, (JPanel)this, me);
            }
        } else {
            this.principalDialog.setMapElement(me);
        }
        this.principalDialog.show();
        if (this.principalDialog.userSelectedOK()) {
            this.descriptor.changed();
        } else {
            MapElement[] mapElement = this.roleMap.getMapElement();
            for (int i = 0; i < mapElement.length; ++i) {
                if (mapElement[i] != me) continue;
                oldMapElement.setAttributeValue("BackendPrincipal", 0, "user-name", me.getAttributeValue("BackendPrincipal", 0, "user-name"));
                oldMapElement.setAttributeValue("BackendPrincipal", 0, "password", me.getAttributeValue("BackendPrincipal", 0, "password"));
                oldMapElement.setAttributeValue("BackendPrincipal", 0, "credential", me.getAttributeValue("BackendPrincipal", 0, "credential"));
                mapElement[i] = oldMapElement;
                break;
            }
            this.roleMap.setMapElement(mapElement);
        }
        this.principalDialog = null;
    }

    public void descriptionUpdated(String description, Object ref) {
        ((SunConnector)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).getRoleMap().setDescription(description);
    }

    public class RoleMapTableModel
    extends InspectorTableModel {
        public RoleMapTableModel() {
            super(new String[]{RoleMapConnectorInspector.this.ROLEMAP_TABLE_PRINCIPAL, RoleMapConnectorInspector.this.ROLEMAP_TABLE_USERNAME, RoleMapConnectorInspector.this.ROLEMAP_TABLE_PASSWORD, RoleMapConnectorInspector.this.ROLEMAP_TABLE_CREDENTIAL});
        }

        public Object getObjectValue(Object ch, int col) {
            MapElement obj = (MapElement)ch;
            String value = null;
            switch (col) {
                case 0: {
                    int num = obj.sizePrincipal();
                    value = "" + num;
                    break;
                }
                case 1: {
                    value = obj.getAttributeValue("BackendPrincipal", 0, "user-name");
                    break;
                }
                case 2: {
                    value = obj.getAttributeValue("BackendPrincipal", 0, "password");
                    break;
                }
                case 3: {
                    value = obj.getAttributeValue("BackendPrincipal", 0, "credential");
                }
            }
            return value;
        }

        public void setObjectValue(Object ch, int col, Object value) {
            String str = (String)value;
            MapElement obj = (MapElement)ch;
            switch (col) {
                case 1: {
                    obj.setAttributeValue("BackendPrincipal", 0, "user-name", str);
                    break;
                }
                case 2: {
                    obj.setAttributeValue("BackendPrincipal", 0, "password", str);
                    break;
                }
                case 3: {
                    obj.setAttributeValue("BackendPrincipal", 0, "credential", str);
                }
            }
            RoleMapConnectorInspector.this.descriptor.changed();
        }

        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }
    }

    private class RoleMapTable
    extends InspectorTable {
        public RoleMapTable(RoleMapTableModel model) {
            super(model);
            this.setToolTipText(RoleMapConnectorInspector.this.TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
        }
    }
}

