/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.common.dd.connector.ResourceAdapter;
import com.sun.enterprise.tools.common.dd.connector.SunConnector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ResAdaptConnectorInspector
extends InspectorPane
implements DescriptionInspector.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ResAdaptConnectorInspector.class);
    private final String RES_ADAPT_TOOLTIP = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.sunconnector_tool_tip", "Sun Connector Resource Adapter Configuration");
    private final String TABNAME = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.resourcedadapter_tab", "Resource Adapter");
    private final String JNDI_NAME_TITLE = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.resourcedadapter_jndiname_title", "JNDI Name");
    private final String MAX_POOL_SIZE_TITLE = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.resourcedadapter_maxpoolsize_title", "Max Pool Size");
    private final String STEADY_POOL_SIZE_TITLE = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.resourcedadapter_steadypoolsize_title", "Steady Pool Size");
    private final String MAX_WAIT_IN_MILLIS_TITLE = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.resourcedadapter_maxwaitinmillis_title", "Max Wait In Millis");
    private final String IDLE_TIMEOUT_IN_SECS_TITLE = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.resourcedadapter_idletimeoutinsecs_title", "Idle Timeout In Secs");
    private final String NO_WINDOW = localStrings.getLocalString("ui.sunone.MappingInspector.No_Window", "Didn't find a parent window, using 'null'.");
    private final String PROPERTY_ELEMENT_TITLE = localStrings.getLocalString("ui.sunone.MappingInspector.property_element_title", "Property Element");
    private final String PROPERTY_ELEMENT_TOOLTIP = localStrings.getLocalString("ui.sunone.MappingInspector.property_element_tooltip", "supplying properties as name value pairs");
    private final String COLUMN_NAME = localStrings.getLocalString("ui.sunone.MappingInspector.column_name", "Name");
    private final String COLUMN_VALUE = localStrings.getLocalString("ui.sunone.MappingInspector.column_value", "Value");
    private final String JNDI_NAME_TOOLTIP = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.resourcedadapter_jndiname_tooltip", "Enter value for JNDI Name");
    private final String MAX_POOL_SIZE_TOOLTIP = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.resourcedadapter_maxpoolsize_tooltip", "Enter value for Max Pool Size");
    private final String STEADY_POOL_SIZE_TOOLTIP = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.resourcedadapter_steadypoolsize_tooltip", "Enter value for Steady Pool Size");
    private final String MAX_WAIT_IN_MILLIS_TOOLTIP = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.resourcedadapter_maxwaitinmillis_tooltip", "Enter value for Max Wait In Millis");
    private final String IDLE_TIMEOUT_IN_SECS_TOOLTIP = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.resourcedadapter_idletimeoutinsecs_tooltip", "Enter value for Idle Timeout In Secs");
    private final String DESCRIPTION_ACC_DSC = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.resourcedadapter_description_acc_dsc", "Enter Description for the Resource Adapter");
    private final String MISSING_JNDI_NAME = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.resourcedadapter_missing_jndi_name", "Jndi name is required.");
    private final String MISSING_NAME = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.resourcedadapter_missing_name", "All Property Element must have a name.");
    private final String MISSING_VALUE = localStrings.getLocalString("ui.sunone.resadaptconnectorinspector.resourcedadapter_missing_value", "All Property Element must have a value.");
    private final String ATR_JNDINAME = "jndi-name";
    private final String ATR_MAXPOOLSIZE = "max-pool-size";
    private final String ATR_STEADYPOOLSIZE = "steady-pool-size";
    private final String ATR_MAXWAITTIME = "max-wait-time-in-millis";
    private final String ATR_IDLETIMEOUT = "idle-timeout-in-seconds";
    private final String ATR_NAME = "name";
    private final String ATR_VALUE = "value";
    private final String ATR_PROPERTY_ELEMENT = "PropertyElement";
    private static String wizardHelpID = "SunConnectorResourceAdapter";
    private static String deployHelpID = "SunConnectorResourceAdapter";
    private ConnectorDescriptor descriptor = null;
    private SunConnector sunConnector = null;
    private ResourceAdapter resourceAdapter = null;
    private PropElementTable propElementTable = null;
    private UITitledTextField jndiNameField = null;
    private UITitledTextField maxPoolSizeField = null;
    private UITitledTextField steadyPoolSizeField = null;
    private UITitledTextField maxWaitInMillisField = null;
    private UITitledTextField idleTimeoutInSecsField = null;
    private DescriptionInspector.DialogDisplayButton descriptionField = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new ResAdaptConnectorInspector(mode);
    }

    public String getTabName() {
        return this.TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return ConnectorDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            if (desc instanceof ConnectorDescriptor) {
                this.descriptor = (ConnectorDescriptor)desc;
                this.propElementTable.clearTableData();
                this.sunConnector = (SunConnector)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor);
                this.resourceAdapter = this.sunConnector.getResourceAdapter();
            } else {
                this.descriptor = null;
                this.sunConnector = null;
                this.resourceAdapter = null;
            }
        }
    }

    private ResAdaptConnectorInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 10, 5, 15);
        c.fill = 2;
        c.anchor = 10;
        this.jndiNameField = new UITitledTextField(this.JNDI_NAME_TITLE, false);
        this.jndiNameField.setToolTipText(this.JNDI_NAME_TOOLTIP);
        this.jndiNameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ResAdaptConnectorInspector.this.updateJndiNameField();
            }
        });
        this.add((Component)this.jndiNameField, c);
        UIPanel resAdaptPanel = new UIPanel(new GridBagLayout());
        c.fill = 2;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.maxPoolSizeField = new UITitledTextField(this.MAX_POOL_SIZE_TITLE, false);
        this.maxPoolSizeField.setToolTipText(this.MAX_POOL_SIZE_TOOLTIP);
        this.maxPoolSizeField.setIntegerDocument(false);
        this.maxPoolSizeField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ResAdaptConnectorInspector.this.updateMaxPoolSizeField();
            }
        });
        resAdaptPanel.add((Component)this.maxPoolSizeField, c);
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 7);
        this.steadyPoolSizeField = new UITitledTextField(this.STEADY_POOL_SIZE_TITLE, false);
        this.steadyPoolSizeField.setToolTipText(this.STEADY_POOL_SIZE_TOOLTIP);
        this.steadyPoolSizeField.setIntegerDocument(false);
        this.steadyPoolSizeField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ResAdaptConnectorInspector.this.updateSteadyPoolSizeField();
            }
        });
        resAdaptPanel.add((Component)this.steadyPoolSizeField, c);
        c.fill = 2;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.maxWaitInMillisField = new UITitledTextField(this.MAX_WAIT_IN_MILLIS_TITLE, false);
        this.maxWaitInMillisField.setToolTipText(this.MAX_WAIT_IN_MILLIS_TOOLTIP);
        this.maxWaitInMillisField.setIntegerDocument(false);
        this.maxWaitInMillisField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ResAdaptConnectorInspector.this.updateMaxWaitInMillisField();
            }
        });
        resAdaptPanel.add((Component)this.maxWaitInMillisField, c);
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 7);
        this.idleTimeoutInSecsField = new UITitledTextField(this.IDLE_TIMEOUT_IN_SECS_TITLE, false);
        this.idleTimeoutInSecsField.setToolTipText(this.IDLE_TIMEOUT_IN_SECS_TOOLTIP);
        this.idleTimeoutInSecsField.setIntegerDocument(false);
        this.idleTimeoutInSecsField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ResAdaptConnectorInspector.this.updateIdleTimeoutInSecsField();
            }
        });
        resAdaptPanel.add((Component)this.idleTimeoutInSecsField, c);
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)resAdaptPanel, c);
        UITitledTable pnlProp = new UITitledTable(this.PROPERTY_ELEMENT_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)pnlProp, c);
        this.propElementTable = new PropElementTable(new PropElementTableModel());
        pnlProp.setTableView(this.propElementTable);
        pnlProp.addControlButton(UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResAdaptConnectorInspector.this.addPropElementAction();
            }
        }));
        pnlProp.addSelectionEnabledButton(UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ResAdaptConnectorInspector.this.deletePropElementAction();
            }
        }));
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 5, 0, 5);
        c.fill = 1;
        this.descriptionField = new DescriptionInspector.DialogDisplayButton(this);
        this.descriptionField.getAccessibleContext().setAccessibleDescription(this.DESCRIPTION_ACC_DSC);
        this.add((Component)this.descriptionField, c);
    }

    public void refresh() {
        ResourceAdapter ra;
        if (this.descriptor == null) {
            return;
        }
        if (this.isWizardMode()) {
            ra = null;
            ra = new ResourceAdapter();
            ((SunConnector)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).setResourceAdapter(ra);
            this.jndiNameField.setText(ra.getAttributeValue("jndi-name"));
        } else {
            this.jndiNameField.setText(this.resourceAdapter.getAttributeValue("jndi-name"));
        }
        if (this.isWizardMode()) {
            ra = null;
            ra = new ResourceAdapter();
            ((SunConnector)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).setResourceAdapter(ra);
            this.maxPoolSizeField.setText(ra.getAttributeValue("max-pool-size"));
        } else {
            this.maxPoolSizeField.setText(this.resourceAdapter.getAttributeValue("max-pool-size"));
        }
        if (this.isWizardMode()) {
            ra = null;
            ra = new ResourceAdapter();
            ((SunConnector)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).setResourceAdapter(ra);
            this.steadyPoolSizeField.setText(ra.getAttributeValue("steady-pool-size"));
        } else {
            this.steadyPoolSizeField.setText(this.resourceAdapter.getAttributeValue("steady-pool-size"));
        }
        if (this.isWizardMode()) {
            ra = null;
            ra = new ResourceAdapter();
            ((SunConnector)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).setResourceAdapter(ra);
            this.maxWaitInMillisField.setText(ra.getAttributeValue("max-wait-time-in-millis"));
        } else {
            this.maxWaitInMillisField.setText(this.resourceAdapter.getAttributeValue("max-wait-time-in-millis"));
        }
        if (this.isWizardMode()) {
            ra = null;
            ra = new ResourceAdapter();
            ((SunConnector)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).setResourceAdapter(ra);
            this.idleTimeoutInSecsField.setText(ra.getAttributeValue("idle-timeout-in-seconds"));
        } else {
            this.idleTimeoutInSecsField.setText(this.resourceAdapter.getAttributeValue("idle-timeout-in-seconds"));
        }
        this.propElementTable.updateTableData(ResAdaptConnectorInspector.toBooleanArray(this.resourceAdapter.getPropertyElement()));
        this.descriptionField.setDescriptionInspector(this.descriptor.getDescription(), this.descriptor.getDisplayName(), this, this.descriptor);
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.jndiNameField.getText().equals("")) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_JNDI_NAME);
            }
            return false;
        }
        return this.validatePropElement(showErrors);
    }

    private boolean validatePropElement(boolean showErrors) {
        if (this.propElementTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_NAME);
            }
            return false;
        }
        if (this.propElementTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_VALUE);
            }
            return false;
        }
        return true;
    }

    protected void updateJndiNameField() {
        String sel = this.jndiNameField.getText();
        ((SunConnector)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).getResourceAdapter().setAttributeValue("jndi-name", sel);
        this.descriptor.changed();
    }

    protected void updateMaxPoolSizeField() {
        String sel = this.maxPoolSizeField.getText();
        ((SunConnector)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).getResourceAdapter().setAttributeValue("max-pool-size", sel);
        this.descriptor.changed();
    }

    protected void updateSteadyPoolSizeField() {
        String sel = this.steadyPoolSizeField.getText();
        ((SunConnector)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).getResourceAdapter().setAttributeValue("steady-pool-size", sel);
        this.descriptor.changed();
    }

    protected void updateMaxWaitInMillisField() {
        String sel = this.maxWaitInMillisField.getText();
        ((SunConnector)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).getResourceAdapter().setAttributeValue("max-wait-time-in-millis", sel);
        this.descriptor.changed();
    }

    protected void updateIdleTimeoutInSecsField() {
        String sel = this.idleTimeoutInSecsField.getText();
        ((SunConnector)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).getResourceAdapter().setAttributeValue("idle-timeout-in-seconds", sel);
        this.descriptor.changed();
    }

    private void addPropElementAction() {
        if (!this.validatePropElement(true)) {
            if (this.propElementTable.getRowWithValue(0, "") != null) {
                this.propElementTable.selectRowWithValueOnUpdate(0, "");
            } else if (this.propElementTable.getRowWithValue(1, "") != null) {
                this.propElementTable.selectRowWithValueOnUpdate(1, "");
            }
        } else {
            int cnt = this.resourceAdapter.addPropertyElement(true);
            this.resourceAdapter.setPropertyElement(cnt, true);
            this.resourceAdapter.setAttributeValue("PropertyElement", cnt, "name", "");
            this.resourceAdapter.setAttributeValue("PropertyElement", cnt, "value", "");
            this.propElementTable.selectRowWithValueOnUpdate(0, "");
            this.descriptor.changed();
        }
        this.invokeRefresh();
    }

    private void deletePropElementAction() {
        Object[] list = this.propElementTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                Object obj = list[i];
                this.resourceAdapter.removePropertyElement(this.propElementTable.getObjectIndex(obj));
            }
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    public void descriptionUpdated(String description, Object ref) {
        ((SunConnector)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).getResourceAdapter().setDescription(description);
        this.descriptor.changed();
    }

    private static Boolean[] toBooleanArray(boolean[] b) {
        if (b == null) {
            return new Boolean[0];
        }
        Boolean[] ba = new Boolean[b.length];
        for (int i = 0; i < b.length; ++i) {
            ba[i] = new Boolean(b[i]);
        }
        return ba;
    }

    public class PropElementTableModel
    extends InspectorTableModel {
        public PropElementTableModel() {
            super(new String[]{ResAdaptConnectorInspector.this.COLUMN_NAME, ResAdaptConnectorInspector.this.COLUMN_VALUE});
        }

        public Object getObjectValue(Object obj, int col) {
            int ix = this.getObjectIndex(obj);
            String value = null;
            switch (col) {
                case 0: {
                    value = ResAdaptConnectorInspector.this.resourceAdapter.getAttributeValue("PropertyElement", ix, "name");
                    break;
                }
                case 1: {
                    value = ResAdaptConnectorInspector.this.resourceAdapter.getAttributeValue("PropertyElement", ix, "value");
                }
            }
            if (value == null) {
                value = "";
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            String str = (String)value;
            int ix = this.getObjectIndex(obj);
            switch (col) {
                case 0: {
                    ResAdaptConnectorInspector.this.resourceAdapter.setAttributeValue("PropertyElement", ix, "name", str);
                    break;
                }
                case 1: {
                    ResAdaptConnectorInspector.this.resourceAdapter.setAttributeValue("PropertyElement", ix, "value", str);
                }
            }
            ResAdaptConnectorInspector.this.descriptor.changed();
        }
    }

    private class PropElementTable
    extends InspectorTable {
        public PropElementTable(PropElementTableModel model) {
            super(model);
            this.setToolTipText(ResAdaptConnectorInspector.this.PROPERTY_ELEMENT_TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
        }
    }
}

