/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.tools.common.dd.ejb.Cmp;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ejb.Finder;
import com.sun.enterprise.tools.common.dd.ejb.OneOneFinders;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextArea;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.ejb.EJBException;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OneOneFinderDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(OneOneFinderDialog.class);
    private static final String FIND_SELECT_METHODS = localStrings.getLocalString("ui.finderselectdialog.dialog_title", "Finder/Select Methods");
    private static final String IMPL_QUERIES = localStrings.getLocalString("ui.oneonefinderdialog.ejb_ql_queries_title", "Sun-specific Finder Queries");
    private static final String SHOW_FINDERS = localStrings.getLocalString("ui.oneonefinderdialog.show_finders", "Show:");
    private static final String SHOW_LOCAL_FINDERS = localStrings.getLocalString("ui.oneonefinderdialog.show_local_finders", "Local Finders");
    private static final String SHOW_REMOTE_FINDERS = localStrings.getLocalString("ui.oneonefinderdialog.show_remote_finders", "Remote Finders");
    private static final String SHOW_SELECT_METHODS = localStrings.getLocalString("ui.oneonefinderdialog.show_select_methods", "Select Methods");
    private static final String FINDER_QUERY = localStrings.getLocalString("ui.oneonefinderdialog.jdoql_query", "JDO-QL Query");
    private static final String FINDER_PARAMS = localStrings.getLocalString("ui.oneonefinderdialog.params", "JDO-QL Params:");
    private static final String FINDER_VARS = localStrings.getLocalString("ui.oneonefinderdialog.jdoql_vars", "JDO-QL Variables:");
    private static final String FINDER_ORDER = localStrings.getLocalString("ui.oneonefinderdialog.order", "JDO-QL Order By:");
    private static final String RETURN_TYPE = localStrings.getLocalString("ui.oneonefinderdialog.return.type", "Return EJBs Of Type:");
    private static final String RETURN_LOCAL = localStrings.getLocalString("ui.oneonefinderdialog.return.local", "Local");
    private static final String RETURN_REMOTE = localStrings.getLocalString("ui.oneonefinderdialog.return.remote", "Remote");
    private static final String RETURN_NONE = localStrings.getLocalString("ui.oneonefinderdialog.return.none", "None");
    private static final String FINDER_TABLE_METHOD = localStrings.getLocalString("ui.oneonefinderdialog.findertablemethod", "Method");
    private static final String FINDER_PARAMS_TOOLTIP = localStrings.getLocalString("ui.oneonefinderdialog.params.tooltip", "JDO-QL Params for selected method");
    private static final String FINDER_VARS_TOOLTIP = localStrings.getLocalString("ui.oneonefinderdialog.jdoql_vars.tooltip", "JDO-QL Variables for selected method");
    private static final String FINDER_TABLE_METHOD_TOOLTIP = localStrings.getLocalString("ui.oneonefinderdialog.findertablemethod.tooltip", "List of Finder methods");
    private static final String FINDER_ORDER_TOOLTIP = localStrings.getLocalString("ui.oneonefinderdialog.order.tooltip", "JDO-QL Ordering for selected method");
    private static final String METHOD_FIND = "find";
    private static final String METHOD_FindBPK = "findByPrimaryKey";
    private static final String helpID = "OneOneFinderMethods";
    private static Object[] FINDER_OPTIONS = new Object[]{SHOW_LOCAL_FINDERS, SHOW_REMOTE_FINDERS, SHOW_SELECT_METHODS};
    private UIRadioButtonBox showFinders = null;
    private DescriptionInspector.DescriptionManagerDialog oneonefinderdialog = null;
    private FinderSelectTable finderTable = null;
    private UITitledTextArea finderQueryText = null;
    private UITitledTextArea finderQueryParams = null;
    private UITitledTextArea finderQueryVars = null;
    private UITitledTextArea finderQueryOrder = null;
    private Hashtable tableDataCache = new Hashtable();
    private EjbCMPEntityDescriptor descriptor = null;

    private static String FIND_SELECT_METHODS_FOR(String v0) {
        return localStrings.getLocalString("ui.oneonefinderdialog.dialog_title_for", "Sun-specific Finder Queries - {0}", new Object[]{v0});
    }

    private static final String FINDER_QUERY_FOR(String v0) {
        return localStrings.getLocalString("ui.oneonefinderdialog.jdoql_query_for", "JDO-QL Query for {0}", new Object[]{v0});
    }

    private static String ERROR_GETTING_QUERY_METHODS(String v0) {
        return localStrings.getLocalString("ui.oneonefinderdialog.error_getting_query_methods", "Error encountered while trying to obtain query methods\n {0}", new Object[]{v0});
    }

    public OneOneFinderDialog(Component owner) {
        this.oneonefinderdialog = DescriptionInspector.DescriptionManagerDialog.newDialog(owner);
        this.oneonefinderdialog.setModal(true);
        this.oneonefinderdialog.doNothingOnClose();
        this.oneonefinderdialog.setContentPane(this.getFinderSelectPane());
        this.oneonefinderdialog.setSize(550, 330);
        this.oneonefinderdialog.setLocationRelativeToOwner(20, 20);
    }

    private JPanel getFinderSelectPane() {
        UIControlButtonBox panel = new UIControlButtonBox(null, false);
        panel.setControlButtonLocation(101);
        UITitledBox viewBox = new UITitledBox(IMPL_QUERIES, true);
        panel.setView(viewBox);
        GridBagConstraints c = viewBox.getGBConstraintsCopy();
        this.showFinders = new UIRadioButtonBox(SHOW_FINDERS, false);
        this.showFinders.setModel(FINDER_OPTIONS);
        this.showFinders.setClearWhenDisabled(true);
        this.showFinders.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                OneOneFinderDialog.this.refreshDialog();
            }
        });
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 0);
        c.fill = 0;
        c.anchor = 11;
        UITitledTable tablePanel = new UITitledTable(null, false);
        this.finderTable = new FinderSelectTable(new FinderSelectTableModel());
        this.finderTable.setMinimumSize(new Dimension(150, 150));
        this.finderTable.getSelectionModel().addListSelectionListener(new FinderSelectionListener());
        tablePanel.setTableView(this.finderTable);
        c.weightx = 0.45;
        c.weighty = 0.5;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 0);
        c.fill = 1;
        c.anchor = 10;
        viewBox.add((Component)tablePanel, c);
        UITitledBox queryBox = new UITitledBox(null, false);
        c.weightx = 0.55;
        c.weighty = 0.5;
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        c.anchor = 10;
        viewBox.add((Component)queryBox, c);
        this.finderQueryText = new UITitledTextArea(FINDER_QUERY, false);
        this.finderQueryText.setClearWhenDisabled(true);
        this.finderQueryText.setEnabled(false);
        this.finderQueryText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                QueryItem q = (QueryItem)OneOneFinderDialog.this.finderTable.getSelectedRowObject();
                if (q != null) {
                    q.setEjbQL(OneOneFinderDialog.this.finderQueryText.getText());
                }
            }
        });
        queryBox.addWithGBConstraints(this.finderQueryText);
        this.finderQueryVars = new UITitledTextArea(FINDER_VARS, false);
        this.finderQueryVars.setClearWhenDisabled(true);
        this.finderQueryVars.setEnabled(false);
        this.finderQueryVars.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                QueryItem q = (QueryItem)OneOneFinderDialog.this.finderTable.getSelectedRowObject();
                if (q != null) {
                    q.setVariables(OneOneFinderDialog.this.finderQueryVars.getText());
                }
            }
        });
        queryBox.addWithGBConstraints(this.finderQueryVars);
        this.finderQueryParams = new UITitledTextArea(FINDER_PARAMS, false);
        this.finderQueryParams.setClearWhenDisabled(true);
        this.finderQueryParams.setEnabled(false);
        this.finderQueryParams.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                QueryItem q = (QueryItem)OneOneFinderDialog.this.finderTable.getSelectedRowObject();
                if (q != null) {
                    q.setReturn(OneOneFinderDialog.this.finderQueryParams.getText());
                }
            }
        });
        queryBox.addWithGBConstraints(this.finderQueryParams);
        this.finderQueryOrder = new UITitledTextArea(FINDER_ORDER, false);
        this.finderQueryOrder.setClearWhenDisabled(true);
        this.finderQueryOrder.setEnabled(false);
        this.finderQueryOrder.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                QueryItem q = (QueryItem)OneOneFinderDialog.this.finderTable.getSelectedRowObject();
                if (q != null) {
                    q.setOrder(OneOneFinderDialog.this.finderQueryOrder.getText());
                }
            }
        });
        queryBox.addWithGBConstraints(this.finderQueryOrder);
        UIButton okBtn = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                OneOneFinderDialog.this.okAction();
            }
        });
        panel.addControlButton(okBtn);
        UIButton cancelBtn = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                OneOneFinderDialog.this.oneonefinderdialog.hide();
            }
        });
        panel.addControlButton(cancelBtn);
        panel.addControlButton(new UIHelpButton(helpID));
        viewBox.getAccessibleContext().setAccessibleDescription(IMPL_QUERIES);
        this.finderTable.getAccessibleContext().setAccessibleDescription(FINDER_TABLE_METHOD_TOOLTIP);
        this.finderQueryText.setToolTipText(FINDER_QUERY);
        this.finderQueryParams.setToolTipText(FINDER_PARAMS_TOOLTIP);
        this.finderQueryVars.setToolTipText(FINDER_VARS_TOOLTIP);
        this.finderQueryOrder.setToolTipText(FINDER_ORDER_TOOLTIP);
        return panel;
    }

    private void refreshDialog() {
        QueryItem q;
        this.showFinders.setItemEnabled(SHOW_LOCAL_FINDERS, this.descriptor.getLocalHomeClassName() != null);
        this.showFinders.setItemEnabled(SHOW_REMOTE_FINDERS, this.descriptor.getHomeClassName() != null);
        String showMeth = (String)this.showFinders.getSelectedItem();
        if (showMeth == null) {
            if (this.showFinders.isItemEnabled(SHOW_LOCAL_FINDERS)) {
                this.showFinders.setSelectedItem(SHOW_LOCAL_FINDERS);
            } else if (this.showFinders.isItemEnabled(SHOW_REMOTE_FINDERS)) {
                this.showFinders.setSelectedItem(SHOW_REMOTE_FINDERS);
            } else {
                this.showFinders.setSelectedItem(SHOW_SELECT_METHODS);
            }
            showMeth = (String)this.showFinders.getSelectedItem();
        }
        Vector<QueryItem> queryList = new Vector<QueryItem>();
        Enumeration values = this.tableDataCache.elements();
        while (values.hasMoreElements()) {
            q = (QueryItem)values.nextElement();
            if (!q.getType().equals(showMeth)) continue;
            queryList.add(q);
        }
        this.finderTable.clearTableData();
        this.finderTable.updateTableData(queryList);
        this.finderTable.clearSelection();
        this.finderQueryText.setEnabled(false);
        if (this.finderTable.getRowCount() > 0 && (q = (QueryItem)this.finderTable.getSelectedRowObject()) == null) {
            this.finderTable.setSelectedIndex(0);
        }
    }

    public void setDescriptor(Object d) {
        if (d == null) {
            Print.dprintStackTrace((String)"Specified descriptor is null");
            this.descriptor = null;
            return;
        }
        if (!(d instanceof EjbCMPEntityDescriptor)) {
            Print.dprintStackTrace((String)("Not EjbCMPEntityDescriptor: " + DT.className(d)));
            this.descriptor = null;
        }
        this.descriptor = (EjbCMPEntityDescriptor)d;
        String title = OneOneFinderDialog.FIND_SELECT_METHODS_FOR(this.descriptor.getDisplayName());
        this.oneonefinderdialog.setTitle(title);
        this.oneonefinderdialog.getAccessibleContext().setAccessibleDescription(title);
        this.loadDataCache(true);
    }

    public void show() {
        this.refreshDialog();
        this.oneonefinderdialog.show();
    }

    private void okAction() {
        Enumeration enumeration = this.tableDataCache.keys();
        while (enumeration.hasMoreElements()) {
            String methName = (String)enumeration.nextElement();
            QueryItem qi = (QueryItem)this.tableDataCache.get(methName);
            Method meth = qi.getMethod();
            Finder finder = this.locateFinderDescriptor(meth);
            if (finder == null) continue;
            finder.setQueryFilter(qi.getEjbQL());
            finder.setQueryVariables(qi.getVariables());
            finder.setQueryParams(qi.getReturn());
            finder.setQueryOrdering(qi.getOrder());
        }
        this.oneonefinderdialog.hide();
    }

    private Hashtable loadDataCache(boolean clear) {
        if (clear) {
            this.tableDataCache.clear();
        }
        try {
            String className = this.descriptor.getHomeClassName();
            if (className != null) {
                this.addMethods(this.getEjbClass(className).getMethods(), MethodDescriptor.EJB_HOME, SHOW_REMOTE_FINDERS, METHOD_FIND, this.tableDataCache);
            }
        }
        catch (Exception ex) {
            UIOptionPane.showErrorDialog(this.oneonefinderdialog, OneOneFinderDialog.ERROR_GETTING_QUERY_METHODS(ex.toString()));
        }
        return this.tableDataCache;
    }

    private void addMethods(Method[] methods, String methodIntf, String type, String mKey, Hashtable ht) {
        for (int i = 0; i < methods.length; ++i) {
            Finder finder;
            Method meth = methods[i];
            String methName = new MethodDescriptor(meth, methodIntf).getFormattedString();
            if (!methName.startsWith(mKey) || methName.startsWith(METHOD_FindBPK)) continue;
            QueryItem qi = (QueryItem)ht.get(methName);
            if (qi == null) {
                qi = new QueryItem(methName, meth, "", RETURN_LOCAL, "", type, "");
                ht.put(methName, qi);
            }
            if ((finder = this.locateFinderDescriptor(meth)) == null) continue;
            qi.setEjbQL(finder.getQueryFilter());
            qi.setVariables(finder.getQueryVariables());
            qi.setReturn(finder.getQueryParams());
            qi.setOrder(finder.getQueryOrdering());
        }
    }

    private Finder locateFinderDescriptor(Method meth) {
        OneOneFinders oneOneFinders;
        Ejb ejb = (Ejb)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor);
        Cmp cmp = ejb.getCmp();
        if (cmp == null) {
            cmp = new Cmp();
            ejb.setCmp(cmp);
            cmp.setIsOneOneCmp("true");
        }
        if (null == (oneOneFinders = cmp.getOneOneFinders())) {
            oneOneFinders = new OneOneFinders();
            cmp.setOneOneFinders(oneOneFinders);
        }
        Finder[] finders = oneOneFinders.getFinder();
        Finder retVal = null;
        int len = finders != null ? finders.length : 0;
        for (int i = 0; i < len && retVal == null; ++i) {
            Finder tmp = finders[i];
            if (!tmp.getMethodName().trim().equals(meth.getName().trim())) continue;
            retVal = tmp;
        }
        if (null == retVal) {
            retVal = new Finder();
            retVal.setMethodName(meth.getName().trim());
            retVal.setQueryFilter("true");
            retVal.setQueryVariables("");
            retVal.setQueryParams("");
            retVal.setQueryOrdering("");
            oneOneFinders.addFinder(retVal);
        }
        return retVal;
    }

    private Class getEjbClass(String className) {
        try {
            return ModuleArchive.getClassLoader((Descriptor)this.descriptor.getPersistenceDescriptor().getEjbBundleDescriptor()).loadClass(className);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    private class FinderSelectTableModel
    extends InspectorTableModel {
        public FinderSelectTableModel() {
            super(new String[]{FINDER_TABLE_METHOD});
            this.setDataOrdering(1);
        }

        public Descriptor getRowDescriptor(int index) {
            return (QueryDescriptor)this.getRowObject(index);
        }

        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        public Object getObjectValue(Object obj, int col) {
            QueryItem q = (QueryItem)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = q.getName();
                    break;
                }
                case 1: {
                    value = q.getVariables();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            QueryItem q = (QueryItem)obj;
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    q.setVariables(value.toString());
                }
            }
            OneOneFinderDialog.this.descriptor.changed();
        }
    }

    private class FinderSelectTable
    extends InspectorTable {
        public FinderSelectTable(FinderSelectTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
        }
    }

    private class FinderSelectionListener
    implements ListSelectionListener {
        private FinderSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            QueryItem q = (QueryItem)OneOneFinderDialog.this.finderTable.getSelectedRowObject();
            if (q == null) {
                OneOneFinderDialog.this.finderQueryText.setTitle(FINDER_QUERY);
                OneOneFinderDialog.this.finderQueryText.setEnabled(false);
            } else {
                String qfn = q.getName();
                int p = qfn.indexOf("(");
                String qmn = p > 0 ? qfn.substring(0, p) : qfn;
                OneOneFinderDialog.this.finderQueryText.setTitle(OneOneFinderDialog.FINDER_QUERY_FOR(qmn));
                OneOneFinderDialog.this.finderQueryText.setToolTipText(OneOneFinderDialog.FINDER_QUERY_FOR(qmn));
                OneOneFinderDialog.this.finderQueryText.setText(q.getEjbQL());
                OneOneFinderDialog.this.finderQueryText.setEnabled(true);
                OneOneFinderDialog.this.finderQueryVars.setText(q.getVariables());
                OneOneFinderDialog.this.finderQueryVars.setEnabled(true);
                OneOneFinderDialog.this.finderQueryParams.setText(q.getReturn());
                OneOneFinderDialog.this.finderQueryParams.setEnabled(true);
                OneOneFinderDialog.this.finderQueryOrder.setText(q.getOrder());
                OneOneFinderDialog.this.finderQueryOrder.setEnabled(true);
                if (OneOneFinderDialog.this.showFinders.getSelectedItem().equals(SHOW_SELECT_METHODS)) {
                    // empty if block
                }
            }
        }
    }

    private class QueryItem
    extends InspectorTableModel.InspectorDataWrapper {
        public QueryItem(String n, Method m, String e, String r, String d, String t, String o) {
            super(new Object[]{n, m, e, r, d, t, o});
            this.setDefaultNullValue("");
        }

        public String getName() {
            return (String)this.getObject(0);
        }

        public Method getMethod() {
            return (Method)this.getObject(1);
        }

        public String getEjbQL() {
            return (String)this.getObject(2);
        }

        public String getReturn() {
            return (String)this.getObject(3);
        }

        public String getVariables() {
            return (String)this.getObject(4);
        }

        public String getType() {
            return (String)this.getObject(5);
        }

        public String getOrder() {
            return (String)this.getObject(6);
        }

        public void setEjbQL(String v) {
            this.setObject(2, v);
        }

        public void setReturn(String v) {
            this.setObject(3, v);
        }

        public void setVariables(String v) {
            this.setObject(4, v);
        }

        public void setOrder(String v) {
            this.setObject(6, v);
        }

        public void print() {
            Print.dprintln((String)(this.getName() + this.getEjbQL() + this.getReturn() + this.getVariables() + this.getType() + this.getOrder()));
        }
    }
}

