/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.util.Print;
import com.sun.org.apache.xpath.internal.XPathAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLParser {
    private String wsdlFilename;
    private Element docElement;
    private String namespace;

    public WSDLParser(String wsdlFilename) {
        this.wsdlFilename = wsdlFilename;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new File(wsdlFilename));
            this.docElement = doc.getDocumentElement();
            String namespaceXpath = "/definitions/@targetNamespace";
            Node n = XPathAPI.selectSingleNode(this.docElement, namespaceXpath);
            this.namespace = n.getNodeValue();
        }
        catch (Exception ex) {
            throw (RuntimeException)new RuntimeException("Error parsing WSDL file " + wsdlFilename).initCause(ex);
        }
    }

    public QName[] getAllServiceQNames() {
        List serviceNames = this.getValuesForXPath("/definitions/service/@name");
        return this.createQNames(serviceNames);
    }

    public QName[] getAllPortQNames() {
        List portNames = this.getValuesForXPath("/definitions/service/port/@name");
        return this.createQNames(portNames);
    }

    public QName[] getPortQNames(String serviceNameLocalPart) {
        List portNames = this.getValuesForXPath("/definitions/service[@name=\"" + serviceNameLocalPart + "\"]/port/@name");
        return this.createQNames(portNames);
    }

    private List getValuesForXPath(String xpath) {
        try {
            NodeList nl = XPathAPI.selectNodeList(this.docElement, xpath);
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                String value = n.getNodeValue();
                values.add(value);
            }
            return values;
        }
        catch (Exception ex) {
            throw (RuntimeException)new RuntimeException("Error searching xpath " + xpath + " in WSDL file " + this.wsdlFilename).initCause(ex);
        }
    }

    private QName[] createQNames(List localparts) {
        QName[] qnames = new QName[localparts.size()];
        for (int i = 0; i < qnames.length; ++i) {
            qnames[i] = new QName();
            qnames[i].namespace = this.namespace;
            qnames[i].localpart = (String)localparts.get(i);
        }
        return qnames;
    }

    public static void main(String[] args) {
        WSDLParser parser = new WSDLParser(args[0]);
        Print.dprintln((String)"getAllServiceQNames");
        WSDLParser.printQNames(parser.getAllServiceQNames());
        Print.dprintln((String)"getAllPortQNames");
        WSDLParser.printQNames(parser.getAllPortQNames());
        Print.dprintln((String)"getPortQNames");
        WSDLParser.printQNames(parser.getPortQNames(parser.getAllServiceQNames()[0].localpart));
    }

    private static void printQNames(QName[] qnames) {
        for (int i = 0; i < qnames.length; ++i) {
            Print.dprintln((String)(qnames[i].namespace + ":" + qnames[i].localpart));
        }
    }

    public static class QName {
        public String namespace;
        public String localpart;
    }
}

