/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.dtv.TreeCombo;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.RolesInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;

public class RolesDialog
extends UIDialog
implements DescriptorInspector,
NotificationListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RolesDialog.class);
    private static String EDIT_ROLES_BUTTON = localStrings.getLocalString("ui.rolesdialog.edit.button", "Edit Roles...");
    private static String IMPORT_ROLES_BUTTON = localStrings.getLocalString("ui.rolesdialog.import.button", "Import Roles...");
    private static String IMPORTED_ROLES = localStrings.getLocalString("ui.rolesdialog.import.done", "Roles have been imported from the current server.");
    private static final String EDIT_ROLES = localStrings.getLocalString("ui.rolesdialog.edit_roles", "Edit Roles");
    private static final String ARCHIVE = localStrings.getLocalString("ui.rolesdialog.module", "Module:");
    private static final String ROLES_DIALOG_ACC_DSC = localStrings.getLocalString("at.rolesdialog.acc_dsc", "Dialog to Add or Delete Roles");
    private static final char ROLES_MNEMONIC = localStrings.getLocalString("ui.rolesdialog_import_edit_roles_mnemonic", "R").charAt(0);
    private static String helpSetMapID = "EditRoles";
    private static UIActionDispatcher importRolesAction = null;
    private Descriptor descriptor = null;
    private TempRoles tempRoles = null;
    private TreeCombo bundleCombo = null;
    private RolesInspector rolesInspector = null;
    private UIButton okButton = null;
    private boolean isOk = false;

    private static String EDIT_ROLES_FOR(String v0) {
        return localStrings.getLocalString("ui.rolesdialog.edit_roles_for", "Edit Roles for {0}", new Object[]{v0});
    }

    private static String DEFINED_ROLES_FOR(String v0) {
        return localStrings.getLocalString("at.rolesdialog.defined_roles_for", "Defined Roles for {0}", new Object[]{v0});
    }

    public static void setImportRolesAction(UIActionDispatcher importRoles) {
        importRolesAction = importRoles;
        importRolesAction.setDescription(IMPORT_ROLES_BUTTON);
    }

    public Class getDescriptorClass() {
        return Roles.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor d) {
        this._setDescriptor(d, true);
    }

    public void _setDescriptor(Descriptor d, boolean setSelected) {
        if (this.tempRoles != null) {
            this.tempRoles.removeNotificationListener(this);
            this.tempRoles = null;
        }
        if (d instanceof Roles) {
            this.descriptor = d;
            this.tempRoles = new TempRoles((Roles)this.descriptor);
            this.tempRoles.addNotificationListener(this);
            this.rolesInspector.setDescriptor(this.tempRoles);
            if (DT.getSelectedDescriptor() instanceof Application) {
                this.setTitle(RolesDialog.DEFINED_ROLES_FOR(d.getDisplayName()));
                this.okButton.setVisible(false);
            } else {
                this.setTitle(RolesDialog.EDIT_ROLES_FOR(d.getDisplayName()));
                this.okButton.setVisible(true);
            }
            if (setSelected && this.bundleCombo != null) {
                this.bundleCombo.setSelectedDescriptor(d);
            }
        } else {
            this.descriptor = null;
            this.tempRoles = null;
            this.rolesInspector.setDescriptor(null);
        }
        this.rolesInspector.refresh();
    }

    public void notification(NotificationEvent ne) {
        this.rolesInspector.refresh();
    }

    public static UIActionDispatcher getEditRolesAction(DescriptorInspector insp) {
        return RolesDialog.getEditRolesAction(insp, null);
    }

    public static UIActionDispatcher getEditRolesAction(final DescriptorInspector insp, final ActionListener refresh) {
        UIActionDispatcher editRoles = new UIActionDispatcher(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                RolesDialog._editRoles(insp, refresh);
            }
        });
        String title = importRolesAction != null ? IMPORT_ROLES_BUTTON : EDIT_ROLES_BUTTON;
        editRoles.setDescription(title);
        return editRoles;
    }

    public static JButton getEditRolesButton(DescriptorInspector insp) {
        return RolesDialog.getEditRolesButton(insp, null);
    }

    public static JButton getEditRolesButton(final DescriptorInspector insp, final ActionListener refresh) {
        String title = importRolesAction != null ? IMPORT_ROLES_BUTTON : EDIT_ROLES_BUTTON;
        return new UIButton(title, ROLES_MNEMONIC, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RolesDialog._editRoles(insp, refresh);
            }
        });
    }

    private static void _editRoles(DescriptorInspector insp, ActionListener refresh) {
        Descriptor d = insp.getDescriptor();
        Descriptor md = DescriptorTools.getModuleDescriptor(d);
        if (importRolesAction != null) {
            if (md instanceof Roles) {
                Object rtn = importRolesAction.invoke(new Object[]{md});
                if (rtn instanceof Boolean && ((Boolean)rtn).booleanValue()) {
                    UIOptionPane.showInfoDialog(null, IMPORTED_ROLES);
                }
            } else {
                Print.dprintStackTrace((String)("Not a Roles descriptor: " + UIUtils.debugClassName(md)));
            }
        } else {
            RolesDialog rd = RolesDialog.newRolesDialog((Component)((Object)insp), d instanceof Application);
            if (!rd.showDialog(md)) {
                return;
            }
        }
        if (refresh != null) {
            UIActionDispatcher.invoke(refresh);
        } else if (insp instanceof InspectorPane) {
            ((InspectorPane)insp).invokeRefresh();
        } else {
            Print.dprintln((String)"No method to refresh inspector");
        }
    }

    public static RolesDialog newRolesDialog(Component owner) {
        return RolesDialog.newRolesDialog(owner, false);
    }

    public static RolesDialog newRolesDialog(Component owner, boolean showArchives) {
        RolesDialog dialog = null;
        Window win = WinTools.getAncestorWindow(owner);
        dialog = win instanceof Frame ? new RolesDialog((Frame)win, showArchives) : (win instanceof Dialog ? new RolesDialog((Dialog)win, showArchives) : new RolesDialog((Frame)null, showArchives));
        dialog.setLocationRelativeTo(owner);
        return dialog;
    }

    private RolesDialog(Frame owner, boolean showArchives) {
        super(owner, true);
        this._initLayout(showArchives);
    }

    private RolesDialog(Dialog owner, boolean showArchives) {
        super(owner, true);
        this._initLayout(showArchives);
    }

    private void _initLayout(boolean showArchives) {
        this.setTitle(EDIT_ROLES);
        this.doNothingOnClose();
        this.setSize(new Dimension(500, 400));
        this.getAccessibleContext().setAccessibleDescription(ROLES_DIALOG_ACC_DSC);
        this.rolesInspector = (RolesInspector)RolesInspector.newInspectorPane("DeploymentMode");
        UIControlButtonBox content = new UIControlButtonBox(null, false);
        content.setControlButtonLocation(101);
        this.setContentPane(content);
        if (showArchives) {
            UITitledBox box = new UITitledBox(null, false);
            GridBagConstraints gbc = box.getGBConstraintsCopy();
            gbc.insets = new Insets(5, 5, 5, 5);
            this.bundleCombo = TreeCombo.newAppEjbWarCombo(ARCHIVE, false);
            this.bundleCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    TreeCombo tc = RolesDialog.this.bundleCombo;
                    Descriptor d = (Descriptor)tc.getSelectedDescriptor();
                    if (d == null) {
                        RolesDialog.this._setDescriptor(null, false);
                    } else if (d instanceof Roles) {
                        RolesDialog.this._setDescriptor(d, false);
                    } else {
                        Print.dprintln((String)("Unknown descriptor: " + d.getDisplayName()));
                    }
                }
            });
            gbc.weighty = 0.0;
            gbc.fill = 2;
            box.add((Component)this.bundleCombo, gbc);
            gbc.weighty = 0.5;
            gbc.fill = 1;
            box.add((Component)this.rolesInspector, gbc);
            content.setView(box);
        } else {
            content.setView(this.rolesInspector);
        }
        this.okButton = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RolesDialog.this.okAction();
            }
        });
        content.addControlButton(this.okButton);
        UIButton cancelPB = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RolesDialog.this.cancelAction();
            }
        });
        content.addControlButton(cancelPB);
        content.addControlButton(new UIHelpButton(helpSetMapID));
    }

    public boolean showDialog(Descriptor d) {
        this.isOk = false;
        this._setDescriptor(d, false);
        this.show();
        return this.isOk;
    }

    private void okAction() {
        Iterator ri = null;
        Roles rolesDescriptor = (Roles)this.descriptor;
        this.isOk = true;
        ri = new HashSet(rolesDescriptor.getRoles()).iterator();
        while (ri.hasNext()) {
            rolesDescriptor.removeRole((Role)ri.next());
        }
        ri = this.tempRoles.getRoles().iterator();
        while (ri.hasNext()) {
            Role r = (Role)ri.next();
            if (r.getName().equals("")) continue;
            rolesDescriptor.addRole(r);
        }
        this.setDescriptor(null);
        this.hide();
    }

    protected void cancelAction() {
        this.isOk = false;
        this.setDescriptor(null);
        this.hide();
    }

    private class TempRoles
    extends Descriptor
    implements Roles {
        private HashSet tempRoles = new HashSet();

        public TempRoles(Roles roles) {
            this.tempRoles.addAll(roles.getRoles());
        }

        public Set getRoles() {
            return this.tempRoles;
        }

        public void addRole(Role role) {
            this.tempRoles.remove(role);
            this.tempRoles.add(role);
            this.changed();
        }

        public void removeRole(Role role) {
            this.tempRoles.remove(role);
            this.changed();
        }
    }
}

