/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.tools.common.dd.DefaultResourcePrincipal;
import com.sun.enterprise.tools.common.dd.ResourceRef;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.sunone.CommonDescriptorUtil;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICardPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIJndiName;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledPasswordField;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class ResourceRefsInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ResourceRefsInspector.class);
    private static String RESFACT_REF = localStrings.getLocalString("ui.resourcerefsinspector.resource_factories_ref", "Resource Factories Referenced in Code");
    private static String DEPLOYMENT_SETTINGS = localStrings.getLocalString("ui.resourcerefsinspector.deployment_settings", "Sun-specific Settings");
    private static String JNDI_NAME = localStrings.getLocalString("ui.resourcerefsinspector.jndi_name", "JNDI Name:");
    private static String URL_TITLE = localStrings.getLocalString("ui.resourcerefsinspector.url", "URL");
    private static String USER_NAME = localStrings.getLocalString("ui.resourcerefsinspector.username", "User Name:");
    private static String USER_PASS = localStrings.getLocalString("ui.resourcerefsinspector.password", "Password:");
    private static String MAIL_FROM = localStrings.getLocalString("ui.resourcerefsinspector.from", "From");
    private static String MAIL_HOST = localStrings.getLocalString("ui.resourcerefsinspector.host", "Host:");
    private static final String RESREF_TABLE_TOOLTIP = localStrings.getLocalString("ui.resourcerefsinspector.resfact_table.tooltip", "Table of resource references");
    private static final String RESREF_TYPE_TOOLTIP = localStrings.getLocalString("ui.resourcerefsinspector.resfact_table.type.tooltip", "Click to Edit Resource Type");
    private static final String RESREF_AUTH_TOOLTIP = localStrings.getLocalString("ui.resourcerefsinspector.resfact_table.auth.tooltip", "Click to Edit Resource Authentication");
    private static final String RESREF_SHARE_TOOLTIP = localStrings.getLocalString("ui.resourcerefsinspector.resfact_table.sharable.tooltip", "Click to Toggle Sharable Scope");
    private static final String REFREF_COL_CODEDNAME = localStrings.getLocalString("ui.resourcerefsinspector.resfact_table.coded_name", "Coded Name");
    private static final String RESREF_COL_TYPE = localStrings.getLocalString("ui.resourcerefsinspector.resfact_table.type", "Type");
    private static final String RESREF_COL_AUTH = localStrings.getLocalString("ui.resourcerefsinspector.resfact_table.auth", "Authentication");
    private static final String RESREF_COL_SHARABLE = localStrings.getLocalString("ui.resourcerefsinspector.resfact_table.sharable", "Sharable");
    private static String JNDI_NAME_TOOLTIP = localStrings.getLocalString("ui.resourcerefsinspector.linkvalue_tooltip", "Enter value for JNDI Name");
    private static String USER_NAME_TOOLTIP = localStrings.getLocalString("ui.resourcerefsinspector.username_tooltip", "Enter value for User name");
    private static String USER_PASS_TOOLTIP = localStrings.getLocalString("ui.resourcerefsinspector.password_tooltip", "Enter value for Password");
    private static final String NEED_BOTH = localStrings.getLocalString("ui.resourcerefsinspector.need_both", "User Name and Password must both be specified or omitted.");
    private static String TABNAME = localStrings.getLocalString("ui.resourcerefsinspector.tabname", "Resource Refs");
    private static String USER_PASSWD_PANEL = "UserPassPanel";
    private static String JAVA_MAIL = "JavaMail";
    private static String URL = "URL";
    private static String wizardHelpID = "ResourceRef";
    private static String deployHelpID = "ResourceRef";
    private WritableJndiNameEnvironment descriptor = null;
    private CommonDescriptorUtil commonDescriptor = null;
    private UITitledTable resourceRefsPanel = null;
    private ResourceRefsTableModel resourceRefsTableModel = null;
    private ResourceRefsTable resourceRefsTable = null;
    private DeploymentSettingsBox deploymentSettingsPanel = null;
    private static String[] RESOURCE_TYPES = new String[]{"javax.sql.DataSource", "javax.mail.Session", "java.net.URL", "javax.jms.QueueConnectionFactory", "javax.jms.TopicConnectionFactory", "javax.jms.ConnectionFactory", "javax.resource.cci.ConnectionFactory", "javax.xml.registry.ConnectionFactory"};
    private static String[] AUTH_TYPES = new String[]{ResourceReferenceDescriptor.CONTAINER_AUTHORIZATION, ResourceReferenceDescriptor.APPLICATION_AUTHORIZATION};
    private final String JNDI_COMBO_PANEL = "jndiCombo";
    private final String JNDI_TEXT_PANEL = "jndiText";
    private final String URL_TEXT_PANEL = "urlText";

    private static String DEPLOYMENT_SETTINGS_FOR(String v0) {
        return localStrings.getLocalString("ui.resourcerefsinspector.deployment_settings_for", "Sun-specific Settings for {0}", new Object[]{v0});
    }

    public static InspectorPane newInspectorPane(String mode) {
        return new ResourceRefsInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WritableJndiNameEnvironment.class;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WritableJndiNameEnvironment ? (WritableJndiNameEnvironment)desc : null;
            this.resourceRefsTable.clearTableData();
            if (this.descriptor != null) {
                if (this.descriptor instanceof ApplicationClientDescriptor) {
                    this.commonDescriptor = new CommonDescriptorUtil((Descriptor)((ApplicationClientDescriptor)this.descriptor));
                } else if (this.descriptor instanceof WebBundleDescriptor) {
                    this.commonDescriptor = new CommonDescriptorUtil((Descriptor)((WebBundleDescriptor)this.descriptor));
                } else if (this.descriptor instanceof EjbDescriptor) {
                    this.commonDescriptor = new CommonDescriptorUtil((Descriptor)((EjbDescriptor)this.descriptor));
                }
            }
        }
    }

    private ResourceRefsInspector(String mode) {
        this.initializeLayout();
        this.setInspectorMode(mode);
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        UITitledBox titledBox = new UITitledBox(RESFACT_REF, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)titledBox, c);
        this.resourceRefsPanel = new UITitledTable(null, false);
        titledBox.addWithGBConstraints(this.resourceRefsPanel);
        this.resourceRefsTable = new ResourceRefsTable(new ResourceRefsTableModel());
        this.resourceRefsTable.getSelectionModel().addListSelectionListener(new ResourceRefsSelectionListener());
        this.resourceRefsTable.setAutoResizeMode(4);
        this.resourceRefsPanel.getGBConstraints().weighty = 0.85;
        this.resourceRefsPanel.setTableView(this.resourceRefsTable);
        UIButton addPB = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResourceRefsInspector.this.addResourceRefAction();
            }
        });
        this.resourceRefsPanel.addControlButton(addPB);
        UIButton delPB = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResourceRefsInspector.this.deleteResourceRefAction();
            }
        }, true);
        this.resourceRefsPanel.addSelectionEnabledButton(delPB);
        this.deploymentSettingsPanel = new DeploymentSettingsBox();
        GridBagConstraints gbc = titledBox.getGBConstraints();
        gbc.weighty = 0.0;
        gbc.insets.top = 5;
        gbc.insets.right = 85;
        titledBox.addWithGBConstraints(this.deploymentSettingsPanel);
        this.deploymentSettingsPanel.setVisible(UIConfig.getConfigBoolean("/showDeploymentSettings") || UIConfig.getConfigBoolean("/WSPack"));
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.resourceRefsPanel.setReadOnly(state);
        this.deploymentSettingsPanel.setReadOnly(state, true);
    }

    public boolean hasEmptyRow() {
        return this.resourceRefsTable.getRowWithValue(0, "") != null;
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.hasEmptyRow()) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.resourcerefsinspector.missing_coded_name", "All references must specify a 'Coded Name'."));
            }
            return false;
        }
        return this.deploymentSettingsPanel.validateEntries(showErrors);
    }

    private ResourceReferenceDescriptor getSelectedResourceReference() {
        int minIndex;
        ResourceReferenceDescriptor resourceRef = null;
        ListSelectionModel lsm = this.resourceRefsTable.getSelectionModel();
        if (lsm.isSelectedIndex(minIndex = lsm.getMinSelectionIndex())) {
            resourceRef = this.getTableModel().getRow(minIndex);
        }
        return resourceRef;
    }

    private ResourceRefsTableModel getTableModel() {
        return (ResourceRefsTableModel)this.resourceRefsTable.getModel();
    }

    private void addResourceRefAction() {
        if (this.resourceRefsTable.getRowWithValue(0, "") == null) {
            ResourceReferenceDescriptor ref = new ResourceReferenceDescriptor();
            ref.setDisplayName("");
            ref.setType(RESOURCE_TYPES[0]);
            ref.setAuthorization(AUTH_TYPES[0]);
            ref.setDescription("");
            this.descriptor.addResourceReferenceDescriptor(ref);
        }
        this.resourceRefsTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteResourceRefAction() {
        Object[] list = this.resourceRefsTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                ResourceReferenceDescriptor ref = (ResourceReferenceDescriptor)list[i];
                this.commonDescriptor.removeResourceRef(ref.getName());
                this.descriptor.removeResourceReferenceDescriptor(ref);
            }
            this.invokeRefresh();
        }
    }

    public void refresh() {
        this.resourceRefsTable.updateTableData(this.descriptor.getResourceReferenceDescriptors());
        this.deploymentSettingsPanel.setVisible(UIConfig.getConfigBoolean("/showDeploymentSettings"));
        this.deploymentSettingsPanel.selectRef(this.getSelectedResourceReference());
    }

    private class ResourceRefsTableModel
    extends InspectorTableModel {
        ResourceRefsInspector inspector;

        public ResourceRefsTableModel() {
            super(new String[]{REFREF_COL_CODEDNAME, RESREF_COL_TYPE, RESREF_COL_AUTH, RESREF_COL_SHARABLE, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public boolean isCellEditable(int row, int col) {
            if (this.isReadOnly()) {
                return false;
            }
            return col != 1 || !UIConfig.getConfigBoolean("/WSPack");
        }

        public ResourceReferenceDescriptor getRow(int index) {
            return (ResourceReferenceDescriptor)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            ResourceReferenceDescriptor ref = (ResourceReferenceDescriptor)obj;
            Object value = null;
            switch (col) {
                case 0: {
                    value = ref.getDisplayName();
                    break;
                }
                case 1: {
                    value = ref.getType();
                    break;
                }
                case 2: {
                    value = ref.getAuthorization();
                    break;
                }
                case 3: {
                    value = ref.getSharingScope().equals(ResourceReferenceDescriptor.RESOURCE_SHAREABLE) ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 4: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            ResourceReferenceDescriptor ref = (ResourceReferenceDescriptor)obj;
            if (ref == null) {
                return;
            }
            String vs = value.toString();
            switch (col) {
                case 0: {
                    String oldName = ref.getDisplayName();
                    String newName = vs;
                    if (newName.equals(oldName)) break;
                    if (ResourceRefsInspector.this.commonDescriptor.getResourceRef(newName) != null) {
                        UIOptionPane.showErrorDialog(null, localStrings.getLocalString("ui.resourcerefsinspector.dup_name", "Error: Duplicate Coded Name"));
                        break;
                    }
                    ref.setDisplayName(newName);
                    ResourceRefsInspector.this.commonDescriptor.addResourceRef(oldName, newName, ref.getJndiName(), null, null);
                    break;
                }
                case 1: {
                    ref.setType(vs);
                    break;
                }
                case 2: {
                    ref.setAuthorization(vs);
                    break;
                }
                case 3: {
                    ref.setSharingScope(vs.equals("true") ? ResourceReferenceDescriptor.RESOURCE_SHAREABLE : ResourceReferenceDescriptor.RESOURCE_UNSHAREABLE);
                    break;
                }
                case 4: {
                    ref.setDescription(vs);
                }
            }
            ((Descriptor)ResourceRefsInspector.this.descriptor).changed();
        }
    }

    private class ResourceRefsTable
    extends InspectorTable {
        public ResourceRefsTable(ResourceRefsTableModel model) {
            super(model);
            this.setToolTipText(RESREF_TABLE_TOOLTIP);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
            TableColumn typeColumn = this.getColumnModel().getColumn(1);
            UITitledComboBox typeCombo = new UITitledComboBox(null, false);
            typeCombo.setModel(RESOURCE_TYPES);
            typeCombo.setEditable(true);
            typeCombo.setShowWidePopups(true);
            typeColumn.setCellEditor(new DefaultCellEditor(typeCombo.getComboBox()));
            DefaultTableCellRenderer typeRenderer = new DefaultTableCellRenderer();
            typeRenderer.setToolTipText(RESREF_TYPE_TOOLTIP);
            typeColumn.setCellRenderer(typeRenderer);
            TableColumn authColumn = this.getColumnModel().getColumn(2);
            UITitledComboBox authCombo = new UITitledComboBox(null, false);
            authCombo.setShowWidePopups(true);
            authCombo.setModel(AUTH_TYPES);
            authColumn.setCellEditor(new DefaultCellEditor(authCombo.getComboBox()));
            DefaultTableCellRenderer authRenderer = new DefaultTableCellRenderer();
            authRenderer.setToolTipText(RESREF_AUTH_TOOLTIP);
            authColumn.setCellRenderer(authRenderer);
            this.adjustColumnWidth(2, false);
            this.adjustColumnWidth(3, false);
        }
    }

    private class ResourceRefsSelectionListener
    implements ListSelectionListener {
        private ResourceRefsSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ResourceRefsInspector.this.invokeRefresh();
        }
    }

    private class DeploymentSettingsBox
    extends UITitledBox {
        private UICardPanel upperCardPanel;
        private UICardPanel lowerCardPanel;
        private UIJndiName linkValueText;
        private UIJndiName jndiNameText;
        private UITitledTextField urlValueText;
        private UITitledTextField userNameText;
        private UITitledPasswordField passwdText;
        private ResourceReferenceDescriptor selectedRef;

        public DeploymentSettingsBox() {
            super(DEPLOYMENT_SETTINGS, true);
            this.upperCardPanel = null;
            this.lowerCardPanel = null;
            this.linkValueText = null;
            this.jndiNameText = null;
            this.urlValueText = null;
            this.userNameText = null;
            this.passwdText = null;
            this.selectedRef = null;
            this.initLayout();
            this.getAccessibleContext().setAccessibleDescription(DEPLOYMENT_SETTINGS);
        }

        private void initLayout() {
            GridBagConstraints gbc = this.getGBConstraintsCopy();
            GridBagConstraints c = new GridBagConstraints();
            this.upperCardPanel = new UICardPanel();
            gbc.weightx = 0.5;
            gbc.weighty = 0.0;
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.fill = 1;
            gbc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.upperCardPanel, gbc);
            UIPanel jndiTextPanel = new UIPanel(new BorderLayout());
            this.linkValueText = new UIJndiName();
            this.linkValueText.addActionListener(new ActionListener(this){
                private final /* synthetic */ DeploymentSettingsBox this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    DeploymentSettingsBox.access$600(this.this$1, DeploymentSettingsBox.access$400(this.this$1), DeploymentSettingsBox.access$500(this.this$1).getJndiName());
                }
            });
            jndiTextPanel.add(this.linkValueText);
            this.upperCardPanel.addCard(jndiTextPanel, "jndiText");
            UIPanel urlTextPanel = new UIPanel(new BorderLayout());
            this.urlValueText = new UITitledTextField(URL_TITLE + ":", false);
            this.urlValueText.addActionListener(new ActionListener(this){
                private final /* synthetic */ DeploymentSettingsBox this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    DeploymentSettingsBox.access$600(this.this$1, DeploymentSettingsBox.access$400(this.this$1), DeploymentSettingsBox.access$800(this.this$1).getText());
                }
            });
            urlTextPanel.add(this.urlValueText);
            this.upperCardPanel.addCard(urlTextPanel, "urlText");
            UIPanel jndiComboPanel = new UIPanel(new BorderLayout());
            this.jndiNameText = new UIJndiName();
            this.jndiNameText.setToolTipText(JNDI_NAME_TOOLTIP);
            this.jndiNameText.addActionListener(new ActionListener(this){
                private final /* synthetic */ DeploymentSettingsBox this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    DeploymentSettingsBox.access$1000(this.this$1, DeploymentSettingsBox.access$400(this.this$1));
                }
            });
            jndiComboPanel.add(this.jndiNameText);
            this.upperCardPanel.addCard(jndiComboPanel, "jndiCombo");
            this.lowerCardPanel = new UICardPanel();
            gbc.weightx = 0.5;
            gbc.weighty = 0.0;
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.fill = 1;
            this.add((Component)this.lowerCardPanel, gbc);
            UIPanel userPasswdPanel = new UIPanel(new GridBagLayout());
            this.lowerCardPanel.addCard(userPasswdPanel, USER_PASSWD_PANEL);
            this.userNameText = new UITitledTextField(USER_NAME, false);
            this.userNameText.setToolTipText(USER_NAME_TOOLTIP);
            this.userNameText.addActionListener(new ActionListener(this){
                private final /* synthetic */ DeploymentSettingsBox this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    DeploymentSettingsBox.access$1400(this.this$1, DeploymentSettingsBox.access$400(this.this$1));
                }
            });
            c.weightx = 0.5;
            c.weighty = 0.0;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(0, 0, 0, 7);
            c.fill = 2;
            userPasswdPanel.add((Component)this.userNameText, c);
            this.passwdText = new UITitledPasswordField(USER_PASS, false);
            this.passwdText.setToolTipText(USER_PASS_TOOLTIP);
            this.passwdText.addActionListener(new ActionListener(this){
                private final /* synthetic */ DeploymentSettingsBox this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    DeploymentSettingsBox.access$1700(this.this$1, DeploymentSettingsBox.access$400(this.this$1));
                }
            });
            c.weightx = 0.5;
            c.weighty = 0.0;
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(0, 0, 0, 0);
            c.fill = 2;
            userPasswdPanel.add((Component)this.passwdText, c);
            UIPanel urlPanel = new UIPanel();
            this.lowerCardPanel.addCard(urlPanel, URL);
        }

        public void selectRef(ResourceReferenceDescriptor rrd) {
            this.selectedRef = rrd;
            if (rrd == null) {
                this.showResourceType(null);
                this.jndiNameText.setEnabled(false);
                this.linkValueText.setEnabled(false);
                this.userNameText.setText("");
                this.userNameText.setEnabled(false);
                this.passwdText.setPassword("");
                this.passwdText.setEnabled(false);
                this.setTitle(DEPLOYMENT_SETTINGS);
            } else {
                DefaultResourcePrincipal principal;
                String jndiName;
                String resType = rrd.getType();
                this.showResourceType(resType);
                ResourceRef ref = ResourceRefsInspector.this.commonDescriptor.getResourceRef(rrd.getDisplayName());
                String string = jndiName = ref == null ? "" : ref.getJndiName();
                if (resType.equals("javax.resource.cci.ConnectionFactory") || resType.equals("javax.xml.registry.ConnectionFactory")) {
                    this.jndiNameText.setJndiName(jndiName);
                } else {
                    this.linkValueText.setAvailableJndiNames((Descriptor)ResourceRefsInspector.this.descriptor, resType);
                    this.linkValueText.setJndiName(jndiName);
                }
                DefaultResourcePrincipal defaultResourcePrincipal = principal = ref == null ? null : ref.getDefaultResourcePrincipal();
                if (principal != null) {
                    this.userNameText.setText(principal.getName());
                    this.passwdText.setPassword(principal.getPassword());
                } else {
                    this.userNameText.setText("");
                    this.passwdText.setPassword("");
                }
                this.jndiNameText.setEnabled(true);
                this.linkValueText.setEnabled(true);
                this.userNameText.setEnabled(true);
                this.passwdText.setEnabled(true);
                this.setTitle(ResourceRefsInspector.DEPLOYMENT_SETTINGS_FOR(rrd.getDisplayName()));
            }
        }

        public void showResourceType(String resType) {
            if (resType == null || resType.equals("")) {
                this.showCards("jndiText", null);
            } else if (resType.equals("javax.mail.Session")) {
                this.showCards("jndiText", JAVA_MAIL);
            } else if (resType.equals("java.net.URL")) {
                this.showCards("urlText", null);
            } else if (resType.equals("javax.resource.cci.ConnectionFactory") || resType.equals("javax.xml.registry.ConnectionFactory")) {
                this.showCards("jndiCombo", USER_PASSWD_PANEL);
            } else if (resType.equals("javax.jms.QueueConnectionFactory") || resType.equals("javax.jms.TopicConnectionFactory") || resType.equals("javax.jms.ConnectionFactory")) {
                this.showCards("jndiText", USER_PASSWD_PANEL);
            } else if (resType.equals("javax.sql.DataSource")) {
                this.showCards("jndiText", USER_PASSWD_PANEL);
            } else {
                this.showCards("jndiText", USER_PASSWD_PANEL);
            }
        }

        private void showCards(String upper, String lower) {
            this.upperCardPanel.showCard(upper);
            this.lowerCardPanel.showCard(lower);
        }

        public boolean validateEntries(boolean showErrors) {
            String nm = this.userNameText.getText();
            String psd = this.passwdText.getText();
            if ((nm == null || nm.equals("")) && !"".equals(psd)) {
                if (showErrors) {
                    UIOptionPane.showErrorDialog(this, NEED_BOTH);
                }
                return false;
            }
            if ((psd == null || psd.equals("")) && !"".equals(nm)) {
                if (showErrors) {
                    UIOptionPane.showErrorDialog(this, NEED_BOTH);
                }
                return false;
            }
            return true;
        }

        private void storeLinkValue(ResourceReferenceDescriptor rr, String value) {
            if (rr == null) {
                rr = ResourceRefsInspector.this.getSelectedResourceReference();
            }
            if (rr != null) {
                rr.setJndiName(value);
                if (ResourceRefsInspector.this.commonDescriptor != null) {
                    ResourceRefsInspector.this.commonDescriptor.setResourceRefJndiName(rr.getDisplayName(), value);
                }
                if (ResourceRefsInspector.this.descriptor != null) {
                    ((Descriptor)ResourceRefsInspector.this.descriptor).changed();
                }
            }
        }

        private void storeJndiComboValue(ResourceReferenceDescriptor rr) {
            if (rr == null) {
                rr = ResourceRefsInspector.this.getSelectedResourceReference();
            }
            if (rr != null) {
                rr.setJndiName(this.jndiNameText.getJndiName());
                if (ResourceRefsInspector.this.commonDescriptor != null) {
                    ResourceRefsInspector.this.commonDescriptor.setResourceRefJndiName(rr.getDisplayName(), this.jndiNameText.getJndiName());
                }
                if (ResourceRefsInspector.this.descriptor != null) {
                    ((Descriptor)ResourceRefsInspector.this.descriptor).changed();
                }
            }
        }

        private void storeUserName(ResourceReferenceDescriptor rr) {
            if (rr == null) {
                rr = ResourceRefsInspector.this.getSelectedResourceReference();
            }
            if (rr != null) {
                String user = this.userNameText.getText();
                String passwd = this.passwdText.getPassword();
                rr.setResourcePrincipal(new ResourcePrincipal(user, passwd));
                if (ResourceRefsInspector.this.commonDescriptor != null) {
                    ResourceRefsInspector.this.commonDescriptor.setResourceRefPrincipal(rr.getDisplayName(), user, passwd);
                }
                if (ResourceRefsInspector.this.descriptor != null) {
                    ((Descriptor)ResourceRefsInspector.this.descriptor).changed();
                }
            }
        }

        private void storePassword(ResourceReferenceDescriptor rr) {
            if (rr == null) {
                rr = ResourceRefsInspector.this.getSelectedResourceReference();
            }
            if (rr != null) {
                String user = this.userNameText.getText();
                String passwd = this.passwdText.getPassword();
                rr.setResourcePrincipal(new ResourcePrincipal(user, passwd));
                if (ResourceRefsInspector.this.commonDescriptor != null) {
                    ResourceRefsInspector.this.commonDescriptor.setResourceRefPrincipal(rr.getDisplayName(), user, passwd);
                }
                if (ResourceRefsInspector.this.descriptor != null) {
                    ((Descriptor)ResourceRefsInspector.this.descriptor).changed();
                }
            }
        }

        static /* synthetic */ ResourceReferenceDescriptor access$400(DeploymentSettingsBox x0) {
            return x0.selectedRef;
        }

        static /* synthetic */ UIJndiName access$500(DeploymentSettingsBox x0) {
            return x0.linkValueText;
        }

        static /* synthetic */ void access$600(DeploymentSettingsBox x0, ResourceReferenceDescriptor x1, String x2) {
            x0.storeLinkValue(x1, x2);
        }

        static /* synthetic */ UITitledTextField access$800(DeploymentSettingsBox x0) {
            return x0.urlValueText;
        }

        static /* synthetic */ void access$1000(DeploymentSettingsBox x0, ResourceReferenceDescriptor x1) {
            x0.storeJndiComboValue(x1);
        }

        static /* synthetic */ void access$1400(DeploymentSettingsBox x0, ResourceReferenceDescriptor x1) {
            x0.storeUserName(x1);
        }

        static /* synthetic */ void access$1700(DeploymentSettingsBox x0, ResourceReferenceDescriptor x1) {
            x0.storePassword(x1);
        }
    }
}

