/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class NameValuePairTable
extends UITitledTable {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(NameValuePairTable.class);
    public static final String TABLE_TITLE = localStrings.getLocalString("ui.namevaluepairtable.title", "Initialization Parameters");
    public static final String TABLE_NAME = localStrings.getLocalString("ui.namevaluepairtable.column.parameter", "Name");
    public static final String TABLE_VALUE = localStrings.getLocalString("ui.namevaluepairtable.column.value", "Value");
    private NameValueTable nameValueTable = null;
    private UIButton addButton = null;
    private UIButton delButton = null;
    protected Descriptor descriptor = null;

    public NameValuePairTable() {
        super(TABLE_TITLE, true);
        this.initLayout();
    }

    private void initLayout() {
        this.nameValueTable = new NameValueTable(new NameValueTableModel());
        this.setTableView(this.nameValueTable);
        this.addButton = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NameValuePairTable.this.addAction();
            }
        });
        this.addControlButton(this.addButton);
        this.delButton = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NameValuePairTable.this.deleteAction();
            }
        }, true);
        this.addSelectionEnabledButton(this.delButton);
    }

    public void setDescriptor(Descriptor d) {
        this.descriptor = d;
        this.refresh();
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void refresh() {
    }

    public void addRecord() {
        Print.printStackTrace((String)"This should be overridden");
    }

    public void deleteRecord(Object ref) {
        Print.printStackTrace((String)"This should be overridden");
    }

    public void changed() {
    }

    private void addAction() {
        if (this.nameValueTable.getRowWithValue(0, "") == null) {
            this.addRecord();
        }
        this.nameValueTable.selectRowWithValueOnUpdate(0, "");
        this.refresh();
    }

    private void deleteAction() {
        Object[] list = this.nameValueTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                this.deleteRecord(list[i]);
            }
            this.refresh();
        }
    }

    private class NameValueTableModel
    extends InspectorTableModel {
        public NameValueTableModel() {
            super(new String[]{TABLE_NAME, TABLE_VALUE, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public Object getObjectValue(Object obj, int col) {
            NameValuePairDescriptor ref = (NameValuePairDescriptor)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getDisplayName();
                    break;
                }
                case 1: {
                    value = ref.getValue();
                    break;
                }
                case 2: {
                    value = ref.getDescription();
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            NameValuePairDescriptor ref = (NameValuePairDescriptor)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    ref.setDisplayName(value.toString());
                    break;
                }
                case 1: {
                    ref.setValue(value.toString());
                    break;
                }
                case 2: {
                    ref.setDescription(value.toString());
                }
            }
            NameValuePairTable.this.changed();
        }
    }

    private class NameValueTable
    extends InspectorTable {
        public NameValueTable(NameValueTableModel model) {
            super(model);
            this.setHandleDescriptionUpdates(true);
        }
    }
}

