/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.common.dd.MessageDestination;
import com.sun.enterprise.tools.common.dd.SunBaseBean;
import com.sun.enterprise.tools.common.dd.appclient.SunApplicationClient;
import com.sun.enterprise.tools.common.dd.ejb.EnterpriseBeans;
import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIJndiName;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MsgDestInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MsgDestInspector.class);
    private static String LIST_NAME = localStrings.getLocalString("ui.msgdestinspector.table.list_name", "List");
    private static String LIST_DESC = localStrings.getLocalString("ui.msgdestinspector.table.list_desc", "This is a list of items");
    private static String MSG_DEST_TBL_TITLE = localStrings.getLocalString("ui.msgdestinspector.table.title", "Message Destinations");
    private static String TABLE_TOOLTIP = localStrings.getLocalString("ui.msgdestinspector.table.tooltip", "Table of Message Destinations");
    private static final String TABLE_DEST_NAME = localStrings.getLocalString("ui.msgdestinspector.table.dest_name", "Destination Name");
    private static final String TABLE_DISPLAY_NAME = localStrings.getLocalString("ui.msgdestinspector.table.display_name", "Display Name");
    private static String JNDI_NAME_TOOLTIP = localStrings.getLocalString("ui.msgdestinspector.jndi_name.tooltip", "Enter value for JNDI Name");
    private static String DEPLOYMENT_SETTINGS = localStrings.getLocalString("ui.msgdestinspector.deployment_settings", "Sun-specific Settings");
    private static final String TABNAME = localStrings.getLocalString("ui.msgdestinspector.tabname", "Message Destinations");
    private static final String PRODUCER_TABLE_TITLE = localStrings.getLocalString("ui.msgdestinspector.producer.table.title", "Producers:");
    private static final String CONSUMER_TABLE_TITLE = localStrings.getLocalString("ui.msgdestinspector.consumer.table.title", "Consumers:");
    private static final String DUPLICATE_NAME_ERROR_DIALOG_TITLE = localStrings.getLocalString("ui.msgdestinspector.errordialog.title", "Duplicate Message Destination Name");
    private static final String MISSING_DEST_NAME = localStrings.getLocalString("ui.msgdestinspector.missing_dest_name", "All Message Destinations must specify a 'Destination Name'.");
    private static String wizardHelpID = "MsgDest";
    private static String deployHelpID = "MsgDest";
    private BundleDescriptor descriptor = null;
    private SunBaseBean sunDescriptor = null;
    private Hashtable msgHashtable = null;
    private UITitledTable msgDestPanel = null;
    private MessageDestTable messageDestTable = null;
    private UITitledList consumersTable = null;
    private UITitledList producersTable = null;
    private DeploymentSettingsBox deploymentSettingsPanel = null;

    private static String DEPLOYMENT_SETTINGS_FOR(String v0) {
        return localStrings.getLocalString("ui.msgdestinspector.deployment_settings_for", "Sun-specific Settings for {0}", new Object[]{v0});
    }

    private static final String ADDING_DUPLICATE_NAME(String v0) {
        return localStrings.getLocalString("ui.msgdestinspector.duplicate.error", "Message Destination Name {0} already exists", new Object[]{v0});
    }

    public static InspectorPane newInspectorPane(String mode) {
        return new MsgDestInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return BundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            if (desc instanceof BundleDescriptor) {
                this.descriptor = (BundleDescriptor)desc;
                this.initSun();
            } else {
                this.descriptor = null;
            }
            this.msgDestPanel.clear();
            this.consumersTable.clear();
            this.producersTable.clear();
            this.deploymentSettingsPanel.selectRef(null);
            this.resetFirstRefresh();
        }
    }

    private void initSun() {
        this.sunDescriptor = SunOneUtils.getSunDescriptor((Descriptor)this.descriptor);
        if (this.sunDescriptor instanceof SunEjbJar) {
            this.initMsgHashtable(((SunEjbJar)this.sunDescriptor).getEnterpriseBeans().getMessageDestination());
        } else if (this.sunDescriptor instanceof SunWebApp) {
            this.initMsgHashtable(((SunWebApp)this.sunDescriptor).getMessageDestination());
        } else if (this.sunDescriptor instanceof SunApplicationClient) {
            this.initMsgHashtable(((SunApplicationClient)this.sunDescriptor).getMessageDestination());
        }
    }

    private void initMsgHashtable(MessageDestination[] msgDArray) {
        this.msgHashtable = new Hashtable();
        if (msgDArray != null) {
            for (int i = 0; i < msgDArray.length; ++i) {
                this.msgHashtable.put(msgDArray[i].getMessageDestinationName(), msgDArray[i]);
            }
        }
    }

    private void addMessageDestinationToSunDescriptor(MessageDestination msgDest) {
        MessageDestination[] md;
        if (this.sunDescriptor instanceof SunEjbJar) {
            EnterpriseBeans eb = ((SunEjbJar)this.sunDescriptor).getEnterpriseBeans();
            MessageDestination[] md2 = eb.getMessageDestination();
            if (!this.editMsgDestJndi(msgDest, md2)) {
                eb.addMessageDestination(msgDest);
            }
        } else if (this.sunDescriptor instanceof SunWebApp) {
            MessageDestination[] md3 = ((SunWebApp)this.sunDescriptor).getMessageDestination();
            if (!this.editMsgDestJndi(msgDest, md3)) {
                ((SunWebApp)this.sunDescriptor).addMessageDestination(msgDest);
            }
        } else if (this.sunDescriptor instanceof SunApplicationClient && !this.editMsgDestJndi(msgDest, md = ((SunApplicationClient)this.sunDescriptor).getMessageDestination())) {
            ((SunApplicationClient)this.sunDescriptor).addMessageDestination(msgDest);
        }
    }

    private boolean editMsgDestJndi(MessageDestination tableMD, MessageDestination[] descMD) {
        boolean editJndi = false;
        for (int i = 0; i < descMD.length; ++i) {
            if (!descMD[i].equals((Object)tableMD)) continue;
            descMD[i].setJndiName(tableMD.getJndiName());
            editJndi = true;
            break;
        }
        return editJndi;
    }

    private void removeMessageDestinationFromSunDescriptor(MessageDestination msgDest) {
        if (this.sunDescriptor instanceof SunEjbJar) {
            ((SunEjbJar)this.sunDescriptor).getEnterpriseBeans().removeMessageDestination(msgDest);
        } else if (this.sunDescriptor instanceof SunWebApp) {
            ((SunWebApp)this.sunDescriptor).removeMessageDestination(msgDest);
        } else if (this.sunDescriptor instanceof SunApplicationClient) {
            ((SunApplicationClient)this.sunDescriptor).removeMessageDestination(msgDest);
        }
    }

    private MsgDestInspector(String mode) {
        this.initializeLayout();
        this.setInspectorMode(mode);
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        UITitledBox titledBox = new UITitledBox(MSG_DEST_TBL_TITLE, true);
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        this.add((Component)titledBox, c);
        this.msgDestPanel = new UITitledTable(null, false);
        titledBox.addWithGBConstraints(this.msgDestPanel);
        this.msgDestPanel.getGBConstraints().weighty = 0.85;
        this.messageDestTable = new MessageDestTable(new MessageDestTableModel());
        this.msgDestPanel.setTableView(this.messageDestTable);
        this.msgDestPanel.getSelectionModel().addListSelectionListener(new MessageDestinationSelectionListener());
        this.msgDestPanel.addControlButton(UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MsgDestInspector.this.addMsgDestAction();
            }
        }));
        this.msgDestPanel.addSelectionEnabledButton(UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MsgDestInspector.this.deleteMsgDestAction();
            }
        }));
        UITitledBox producersTablePanel = new UITitledBox(null, false);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)producersTablePanel, c);
        this.producersTable = new UITitledList(PRODUCER_TABLE_TITLE, false);
        JList jl = new JList();
        jl.getAccessibleContext().setAccessibleName(LIST_NAME);
        jl.getAccessibleContext().setAccessibleDescription(LIST_DESC);
        this.producersTable.setListView(jl);
        this.producersTable.getListView().setSelectionBackground(Color.white);
        this.producersTable.getListView().setCellRenderer(new ConsumersProducersCellRenderer());
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        producersTablePanel.add((Component)this.producersTable, c);
        UITitledBox consumersTablePanel = new UITitledBox(null, false);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)consumersTablePanel, c);
        this.consumersTable = new UITitledList(CONSUMER_TABLE_TITLE, false);
        jl = new JList();
        jl.getAccessibleContext().setAccessibleName(LIST_NAME);
        jl.getAccessibleContext().setAccessibleDescription(LIST_DESC);
        this.consumersTable.setListView(jl);
        this.consumersTable.getListView().setSelectionBackground(Color.white);
        this.consumersTable.getListView().setCellRenderer(new ConsumersProducersCellRenderer());
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        consumersTablePanel.add((Component)this.consumersTable, c);
        this.deploymentSettingsPanel = new DeploymentSettingsBox();
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        this.add((Component)this.deploymentSettingsPanel, c);
    }

    private MessageDestination getMessageDestinationByName(String nm) {
        return (MessageDestination)this.msgHashtable.get(nm);
    }

    private void storeJndiNameValue() {
        MessageDestinationDescriptor ref = this.getSelectedMessageDestination();
        if (ref != null) {
            ref.setJndiName(this.deploymentSettingsPanel.getJndiName());
            MessageDestination msgDest = this.getMessageDestinationByName(ref.getName());
            if (this.deploymentSettingsPanel.getJndiName().length() > 0) {
                if (msgDest == null) {
                    msgDest = new MessageDestination();
                    msgDest.setMessageDestinationName(ref.getName());
                    this.addMessageDestinationToSunDescriptor(msgDest);
                    this.msgHashtable.put(ref.getName(), msgDest);
                } else {
                    this.addMessageDestinationToSunDescriptor(msgDest);
                }
                msgDest.setJndiName(this.deploymentSettingsPanel.getJndiName());
            } else {
                this.removeMessageDestinationFromSunDescriptor(msgDest);
                msgDest.setJndiName(null);
            }
            if (this.descriptor != null) {
                this.descriptor.changed();
            }
        } else {
            Print.dprintln((String)"Expected a non-null selection!!!");
        }
    }

    public void refresh() {
        this.msgDestPanel.updateTableData(this.descriptor.getMessageDestinations());
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.msgDestPanel.setReadOnly(state);
        this.producersTable.setReadOnly(true);
        this.consumersTable.setReadOnly(true);
        this.deploymentSettingsPanel.setReadOnly(state, true);
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.messageDestTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_DEST_NAME);
            }
            return false;
        }
        return true;
    }

    private void addMsgDestAction() {
        if (this.msgDestPanel.getRowWithValue(0, "") == null) {
            this.descriptor.addMessageDestination(new MessageDestinationDescriptor("", ""));
            MessageDestination msgDest = new MessageDestination();
            msgDest.setMessageDestinationName("");
            this.msgHashtable.put("", msgDest);
        }
        this.msgDestPanel.selectRowWithValueOnUpdate(0, "");
        if (this.descriptor != null) {
            this.descriptor.changed();
        }
        this.invokeRefresh();
    }

    private void deleteMsgDestAction() {
        Object[] list = this.msgDestPanel.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                MessageDestinationDescriptor msgDesc = (MessageDestinationDescriptor)list[i];
                this.descriptor.removeMessageDestination(msgDesc);
                MessageDestination msg = this.getMessageDestinationByName(msgDesc.getName());
                if (msg == null) continue;
                this.removeMessageDestinationFromSunDescriptor(msg);
            }
        }
        if (this.descriptor != null) {
            this.descriptor.changed();
        }
        this.invokeRefresh();
    }

    private Set getMessageDestinationNames(Descriptor desc) {
        Set messDestSet = null;
        if (desc instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor d = (EjbBundleDescriptor)desc;
            messDestSet = d.getMessageDestinations();
        } else if (desc instanceof WebBundleDescriptor) {
            WebBundleDescriptor d = (WebBundleDescriptor)desc;
            messDestSet = d.getMessageDestinations();
        } else if (desc instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor d = (ApplicationClientDescriptor)desc;
            messDestSet = d.getMessageDestinations();
        } else {
            messDestSet = new HashSet();
        }
        return messDestSet;
    }

    private void showProducersAndConsumers(MessageDestinationDescriptor messageDestinationDescriptor) {
        if (messageDestinationDescriptor == null) {
            return;
        }
        MessageDestinationDescriptor workingMsgDestDesc = messageDestinationDescriptor;
        if (workingMsgDestDesc.hasName()) {
            String msgDescriptionName = workingMsgDestDesc.getName();
            DefaultListModel producterList = new DefaultListModel();
            DefaultListModel consumerList = new DefaultListModel();
            Iterator itr = this.getComponentList().iterator();
            while (itr.hasNext()) {
                Object next = itr.next();
                Set msgDestRefDescriptorsSet = null;
                if (next instanceof EjbDescriptor) {
                    msgDestRefDescriptorsSet = ((EjbDescriptor)next).getMessageDestinationReferenceDescriptors();
                    if (next instanceof EjbMessageBeanDescriptor && msgDescriptionName.equals(((EjbMessageBeanDescriptor)next).getMessageDestinationLinkName())) {
                        consumerList.addElement(next);
                    }
                } else if (next instanceof WebBundleDescriptor) {
                    msgDestRefDescriptorsSet = ((WebBundleDescriptor)next).getMessageDestinationReferenceDescriptors();
                } else if (next instanceof ApplicationClientDescriptor) {
                    msgDestRefDescriptorsSet = ((ApplicationClientDescriptor)next).getMessageDestinationReferenceDescriptors();
                }
                Iterator i = msgDestRefDescriptorsSet.iterator();
                while (i.hasNext()) {
                    MessageDestinationReferenceDescriptor messageDestRef = (MessageDestinationReferenceDescriptor)i.next();
                    MessageDestinationDescriptor msgDestLink = messageDestRef.resolveLinkName();
                    if (msgDestLink == null || !msgDescriptionName.equals(msgDestLink.getName())) continue;
                    String usage = messageDestRef.getUsage();
                    if (usage.indexOf("Produces") > -1) {
                        producterList.addElement(next);
                    }
                    if (usage.indexOf("Consumes") <= -1) continue;
                    consumerList.addElement(next);
                }
            }
            this.producersTable.setModel(producterList);
            this.consumersTable.setModel(consumerList);
        }
    }

    private Vector getComponentList() {
        BundleDescriptor bundleDesc = (BundleDescriptor)this.getDescriptor();
        Application application = bundleDesc.getApplication();
        Vector<BundleDescriptor> componentList = new Vector<BundleDescriptor>();
        if (application == null) {
            if (bundleDesc instanceof EjbBundleDescriptor) {
                componentList.addAll(((EjbBundleDescriptor)bundleDesc).getEjbs());
                return componentList;
            }
            if (bundleDesc instanceof WebBundleDescriptor) {
                componentList.add(bundleDesc);
                return componentList;
            }
            if (bundleDesc instanceof ApplicationClientDescriptor) {
                componentList.add(bundleDesc);
            }
        } else {
            componentList.addAll(application.getEjbDescriptors());
            componentList.addAll(application.getApplicationClientDescriptors());
            componentList.addAll(application.getWebBundleDescriptors());
        }
        return componentList;
    }

    private MessageDestTableModel getTableModel() {
        return (MessageDestTableModel)this.messageDestTable.getModel();
    }

    private MessageDestinationDescriptor getSelectedMessageDestination() {
        int minIndex;
        MessageDestinationDescriptor messageDestinationDescriptor = null;
        ListSelectionModel lsm = this.messageDestTable.getSelectionModel();
        if (lsm.isSelectedIndex(minIndex = lsm.getMinSelectionIndex())) {
            messageDestinationDescriptor = this.getTableModel().getRow(minIndex);
        }
        return messageDestinationDescriptor;
    }

    static /* synthetic */ void access$700(MsgDestInspector x0) {
        x0.storeJndiNameValue();
    }

    private class ConsumersProducersCellRenderer
    extends DefaultListCellRenderer {
        private ConsumersProducersCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(list.getBackground());
            this.setText(value == null ? "" : ((Descriptor)value).getName());
            return this;
        }
    }

    private class MessageDestinationSelectionListener
    implements ListSelectionListener {
        private MessageDestinationSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel sm = (ListSelectionModel)e.getSource();
            MessageDestinationDescriptor ref = MsgDestInspector.this.getSelectedMessageDestination();
            MsgDestInspector.this.showProducersAndConsumers(ref);
            MsgDestInspector.this.deploymentSettingsPanel.selectRef(ref);
        }
    }

    public class MessageDestTableModel
    extends InspectorTableModel {
        public MessageDestTableModel() {
            super(new String[]{TABLE_DEST_NAME, TABLE_DISPLAY_NAME, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public boolean isCellEditable(int row, int col) {
            return !this.isReadOnly();
        }

        public MessageDestinationDescriptor getRow(int index) {
            return (MessageDestinationDescriptor)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            MessageDestinationDescriptor ref = (MessageDestinationDescriptor)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getName();
                    break;
                }
                case 1: {
                    value = ref.getDisplayName();
                    if (value != null && !value.equals("")) break;
                    value = ref.getName();
                    break;
                }
                case 2: {
                    value = ref.getDescription();
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            String valStr = value.toString();
            MessageDestinationDescriptor ref = (MessageDestinationDescriptor)obj;
            switch (col) {
                case 0: {
                    int rows = this.getRowCount();
                    for (int i = 0; i < rows; ++i) {
                        MessageDestinationDescriptor ref1 = (MessageDestinationDescriptor)this.getRowObject(i);
                        if (obj == ref1 || !valStr.equals(ref1.getName())) continue;
                        JOptionPane.showMessageDialog(null, MsgDestInspector.ADDING_DUPLICATE_NAME(valStr), DUPLICATE_NAME_ERROR_DIALOG_TITLE, 0);
                        return;
                    }
                    MessageDestination msg = MsgDestInspector.this.getMessageDestinationByName(ref.getName());
                    if (msg != null) {
                        MsgDestInspector.this.msgHashtable.remove(ref.getName());
                        MsgDestInspector.this.msgHashtable.put(valStr, msg);
                        msg.setMessageDestinationName(valStr);
                    }
                    ref.setName(valStr);
                    break;
                }
                case 1: {
                    if (value.equals("")) {
                        value = ref.getName();
                    }
                    ref.setDisplayName(valStr);
                    break;
                }
                case 2: {
                    ref.setDescription(valStr);
                }
            }
            MsgDestInspector.this.descriptor.changed();
        }
    }

    private class MessageDestTable
    extends InspectorTable {
        public MessageDestTable(MessageDestTableModel model) {
            super(model);
            this.setToolTipText(TABLE_TOOLTIP);
            this.setHandleDescriptionUpdates(true);
        }
    }

    private class DeploymentSettingsBox
    extends UITitledBox {
        public UIJndiName jndiNameText;

        public DeploymentSettingsBox() {
            super(DEPLOYMENT_SETTINGS, true);
            this.jndiNameText = null;
            this.initLayout();
        }

        private void initLayout() {
            this.jndiNameText = new UIJndiName();
            this.jndiNameText.setToolTipText(JNDI_NAME_TOOLTIP);
            this.jndiNameText.addActionListener(new ActionListener(this){
                private final /* synthetic */ DeploymentSettingsBox this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    MsgDestInspector.access$700(DeploymentSettingsBox.access$600(this.this$1));
                }
            });
            GridBagConstraints gbc = this.getGBConstraints();
            gbc.insets = new Insets(5, 5, 10, 25);
            this.addWithGBConstraints(this.jndiNameText);
            this.selectRef(null);
        }

        public void selectRef(MessageDestinationDescriptor ref) {
            if (ref == null) {
                this.setTitle(DEPLOYMENT_SETTINGS);
                this.jndiNameText.setEnabled(false);
            } else {
                this.setTitle(MsgDestInspector.DEPLOYMENT_SETTINGS_FOR(ref.getDisplayName()));
                MessageDestination msgDest = MsgDestInspector.this.getMessageDestinationByName(ref.getName());
                this.jndiNameText.setJndiName(msgDest == null ? "" : msgDest.getJndiName());
                this.jndiNameText.setEnabled(true);
            }
        }

        public String getJndiName() {
            return this.jndiNameText.getJndiName();
        }

        static /* synthetic */ MsgDestInspector access$600(DeploymentSettingsBox x0) {
            return x0.MsgDestInspector.this;
        }
    }
}

