/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.app.NewAppDialog;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleManager;
import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.J2EEClassLoader;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;

public class ModuleManagerImpl
implements ModuleManager,
NotificationListener {
    protected static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ModuleManagerImpl.class);
    protected static final String SELECT_MODULE_TO_SAVE = localStrings.getLocalString("ui.modulemanagerimpl.select_module_to_save", "Please select module to save.");
    protected static final String INVALID_SELECTION = localStrings.getLocalString("ui.modulemanagerimpl.invalid_selection", "Invalid selection");
    protected static final String OPEN_MODULE = localStrings.getLocalString("ui.modulemanagerimpl.open_module", "Open Module");
    protected static final String UNRECOGNIZED_TYPE = localStrings.getLocalString("ui.modulemanagerimpl.unrecognized_type", "Unrecognized module type");
    private Window ownerWindow = null;
    private NotificationListener descriptorChangedListener = null;
    private Descriptor activeModule = null;
    private Hashtable wizardNewActions = new Hashtable();
    private Hashtable wizardEditActions = new Hashtable();
    private int notifyDisableCount = 0;
    private Vector notifyListeners = new Vector();
    private ApplicationManager applicationManager = null;
    private StandAloneManager standAloneManager = null;

    protected static String FILE_IS_OWNED(Object v0, Object v1) {
        return localStrings.getLocalString("ui.modulemanagerimpl.file_is_owned", "Cannot overwrite file, owned by open module: {1}", new Object[]{v0, v1});
    }

    protected static String FILE_NON_EXISTANT(Object v0) {
        return localStrings.getLocalString("ui.modulemanagerimpl.file_not_found", "Selected file does not exist.\n {0}", new Object[]{v0});
    }

    protected static String IS_EARLIER_VERSION(Object v0) {
        return localStrings.getLocalString("ui.modulemanagerimpl.is_earlier_version", "{0}\n\nWarning - Module to be Converted to Current Version\n\nThe module you selected is formatted for a previous version of the J2EE\nplatform. If you open and save the module in this tool, it will be converted\nto match the J2EE 1.4 format. The module will no longer be usable with\nprevious versions of the platform.\n\nDo you wish to continue opening this module?", new Object[]{v0});
    }

    protected static String ALREADY_OPEN(Object v0) {
        return localStrings.getLocalString("ui.modulemanagerimpl.already_open", "{0} is already open.\nContinue by reloading from disk?", new Object[]{v0});
    }

    protected static String COULD_NOT_OPEN(Object v0, Object v1) {
        return localStrings.getLocalString("ui.modulemanagerimpl.could_not_open", "Error: Could not open file {0}\n{1}", new Object[]{v0, v1});
    }

    protected static String SAVE_FAILED(Object v0) {
        return localStrings.getLocalString("ui.modulemanagerimpl.save_failed", "Save failed.\n {0}", new Object[]{v0});
    }

    protected static String IS_CORRUPT(Object v0, Object v1) {
        return localStrings.getLocalString("at.modulemanagerimpl.is_corrupt", "{0} is corrupt or cannot be read.\nUse the verifier to determine the cause.\n {1}", new Object[]{v0, v1});
    }

    protected static String INVALID_EAR(Object v0) {
        return localStrings.getLocalString("ui.modulemanagerimpl.invalid_ear", "Not a valid Application module: ", new Object[]{v0});
    }

    protected static String INVALID_RAR(Object v0) {
        return localStrings.getLocalString("ui.modulemanagerimpl.invalid_rar", "Not a valid Resource Adapter module: ", new Object[]{v0});
    }

    protected static String INVALID_WAR(Object v0) {
        return localStrings.getLocalString("ui.modulemanagerimpl.invalid_war", "Not a valid WAR module: ", new Object[]{v0});
    }

    protected static String UNABLE_TO_SAVE(Object v0, Object v1) {
        return localStrings.getLocalString("ui.modulemanagerimpl.unable_to_save", "Unable to save module: {0}\n {1}", new Object[]{v0, v1});
    }

    protected static String WAS_SAVED(Object v0, Object v1) {
        return localStrings.getLocalString("ui.modulemanagerimpl.was_saved", "{0} was saved to\n {1}", new Object[]{v0, v1});
    }

    private Window getOwnerWindow() {
        return this.ownerWindow != null ? this.ownerWindow : WinTools.getActiveWindow(DT.getApplicationFrame());
    }

    public Descriptor getActiveModule() {
        return this.activeModule;
    }

    public Descriptor setActiveModule(Descriptor d) {
        if (d != this.activeModule) {
            this.activeModule = d;
            if (d != null) {
                this.notify("ActiveChanged", "ModuleProperty", d);
            } else {
                this.notify("ActiveChanged", null, null);
            }
        }
        return d;
    }

    public Application createNewApplication() {
        return NewAppDialog.createNewApplication();
    }

    public Application createNewApplication(String appName, String jarFile) {
        Application newApp = new Application(appName, new File(jarFile));
        ModuleArchive modArch = ModuleArchive.newModuleArchive((Descriptor)newApp, jarFile, null);
        try {
            this.saveModule((Descriptor)newApp, false);
        }
        catch (IOException ioe) {
            Print.printStackTrace((String)"Unable to create/save new application", (Throwable)ioe);
        }
        return (Application)this.addModule((Descriptor)newApp, true);
    }

    public Descriptor createNewModule(String wizardClassName) throws Exception {
        UIActionDispatcher ad = (UIActionDispatcher)this.wizardNewActions.get(wizardClassName);
        if (ad == null) {
            ad = new UIActionDispatcher(wizardClassName, "newModule", new Class[]{Frame.class});
            this.wizardNewActions.put(wizardClassName, ad);
        }
        return (Descriptor)ad.invoke(new Object[]{DT.getApplicationFrame()});
    }

    public Descriptor editExistingModule(String wizardClassName) throws Exception {
        UIActionDispatcher ad = (UIActionDispatcher)this.wizardEditActions.get(wizardClassName);
        if (ad == null) {
            ad = new UIActionDispatcher(wizardClassName, "editModule", new Class[]{Frame.class});
            this.wizardEditActions.put(wizardClassName, ad);
        }
        return (Descriptor)ad.invoke(new Object[]{DT.getApplicationFrame()});
    }

    public Descriptor openExistingModule() {
        return this.openExistingModule("@ModuleFiles");
    }

    public Descriptor openExistingModule(String filter) {
        UIFileChooser chooser = UIFileChooser.getFileChooser(null, filter);
        int rtn = chooser.showDialog(this.getOwnerWindow(), OPEN_MODULE);
        if (rtn == 0) {
            File file = chooser.getSelectedFile();
            try {
                return this.setActiveModule(this.openModule(file, true));
            }
            catch (Exception ex) {
                UIOptionPane.showErrorDialog(this.getOwnerWindow(), ModuleManagerImpl.COULD_NOT_OPEN(file.toString(), ex.getMessage()));
            }
        }
        return null;
    }

    public Descriptor openModule(File file) throws Exception {
        return this.openModule(file, true);
    }

    public Descriptor openModule(File file, boolean confirmReload) throws Exception {
        if (!file.isFile()) {
            throw new FileNotFoundException(file.toString());
        }
        String fileName = file.getName();
        int p = fileName.lastIndexOf(".");
        String ext = p >= 0 ? fileName.substring(p) : "";
        ModuleType type = null;
        if (ext.equalsIgnoreCase(".ear")) {
            type = ModuleType.EAR;
        } else if (ext.equalsIgnoreCase(".rar")) {
            type = ModuleType.RAR;
        } else if (ext.equalsIgnoreCase(".war")) {
            type = ModuleType.WAR;
        } else if (ext.equalsIgnoreCase(".jar") && FileUtil.isEJBJar((File)file)) {
            type = ModuleType.EJB;
        } else if (ext.equalsIgnoreCase(".jar") && FileUtil.isAppClientJar((File)file)) {
            type = ModuleType.CAR;
        } else {
            throw new Exception(UNRECOGNIZED_TYPE);
        }
        Descriptor d = this._openModule(file, type, confirmReload);
        if (d != null) {
            this.tagOpenModules(false);
            UIConfig.addStartingDirectory(file.getParentFile());
            UIConfig.saveConfig();
        }
        return d;
    }

    protected Descriptor _openModule(File jarFile, ModuleType type, boolean confirmReload) {
        Descriptor mod = this.getModuleWithJar(jarFile);
        if (mod != null) {
            if (confirmReload && !UIOptionPane.showConfirmDialog(this.getOwnerWindow(), ModuleManagerImpl.ALREADY_OPEN(mod.getDisplayName()))) {
                return null;
            }
            this.removeModule(mod);
        }
        try {
            Descriptor d = ModuleArchive.openModuleArchive(jarFile, type);
            if (d == null) {
                throw new Exception("Invalid file format");
            }
            if (!DescriptorTools.checkSpecVersion((RootDeploymentDescriptor)d)) {
                if (!UIOptionPane.showConfirmDialog(this.getOwnerWindow(), ModuleManagerImpl.IS_EARLIER_VERSION(jarFile))) {
                    return null;
                }
                this.setDirty(d);
            }
            return this.addModule(d);
        }
        catch (Throwable t) {
            Print.printStackTrace((String)("Opening module: " + jarFile), (Throwable)t);
            UIOptionPane.showErrorDialog(this.getOwnerWindow(), ModuleManagerImpl.IS_CORRUPT(jarFile.getName(), t.getMessage()));
            return null;
        }
    }

    public void closeActiveModule() {
        this.closeModule(this.getActiveModule());
    }

    public void closeModule(Descriptor d) {
        if (d instanceof Application) {
            Application app = (Application)d;
            if (this.isDirty((Descriptor)app)) {
                int doSave = this.checkSave((Descriptor)app);
                if (doSave == UIOptionPane.CANCEL_OPTION) {
                    return;
                }
                if (doSave == UIOptionPane.YES_OPTION) {
                    try {
                        this.saveModule((Descriptor)app, false);
                    }
                    catch (IOException ioe) {
                        Print.printStackTrace((String)"Closing module", (Throwable)ioe);
                    }
                }
            }
            this.removeModule((Descriptor)app);
            this.tagOpenModules(true);
        } else if (DescriptorTools.isStandAlone(d)) {
            BundleDescriptor bd = (BundleDescriptor)d;
            if (this.isDirty((Descriptor)bd)) {
                int doSave = this.checkSave((Descriptor)bd);
                if (doSave == UIOptionPane.CANCEL_OPTION) {
                    return;
                }
                if (doSave == UIOptionPane.YES_OPTION) {
                    try {
                        this.saveModule((Descriptor)bd, false);
                    }
                    catch (IOException ioe) {
                        Print.printStackTrace((String)"Closing module", (Throwable)ioe);
                    }
                }
            }
            this.removeModule((Descriptor)bd);
            this.tagOpenModules(true);
        }
    }

    protected int checkSave(Descriptor d) {
        int rtn = DescriptorTools.hasTabErrors(d) ? UIOptionPane.showConfirmDialog(this.getOwnerWindow(), localStrings.getLocalString("at.modulemanagerimpl.has_tab_errors", "{0} has tab errors.  Do you still wish to save?", new Object[]{d.getDisplayName()}), null, UIOptionPane.YES_NO_CANCEL_OPTIONS) : UIOptionPane.showConfirmDialog(this.getOwnerWindow(), localStrings.getLocalString("at.modulemanagerimpl.has_unsaved_changes", "{0} has unsaved changes.  Do you wish to save?", new Object[]{d.getDisplayName()}), null, UIOptionPane.YES_NO_CANCEL_OPTIONS);
        return rtn;
    }

    public Descriptor saveActiveModule() {
        try {
            Descriptor actd = this.getActiveModule();
            Descriptor d = DescriptorTools.getModuleDescriptor(actd);
            if (d != null) {
                int doSave = DescriptorTools.hasTabErrors(d) ? this.checkSave(d) : UIOptionPane.YES_OPTION;
                return doSave == UIOptionPane.YES_OPTION ? this.saveModule(d, true) : null;
            }
            UIOptionPane.showWarningDialog(this.getOwnerWindow(), SELECT_MODULE_TO_SAVE);
        }
        catch (Throwable t) {
            Print.printStackTrace((String)"Saving", (Throwable)t);
            UIOptionPane.showErrorDialog(this.getOwnerWindow(), ModuleManagerImpl.SAVE_FAILED(t));
        }
        return null;
    }

    public Descriptor saveSelectedModuleAs() {
        Descriptor toSave = DT.getSelectedDescriptor();
        if (toSave instanceof EjbDescriptor) {
            toSave = ((EjbDescriptor)toSave).getEjbBundleDescriptor();
        } else if (toSave instanceof WebComponentDescriptor) {
            toSave = ((WebComponentDescriptor)toSave).getWebBundleDescriptor();
        }
        if (DescriptorTools.hasTabErrors(toSave) && this.checkSave(toSave) != UIOptionPane.YES_OPTION) {
            return null;
        }
        if (toSave instanceof Application) {
            Application app = (Application)toSave;
            try {
                File currentFile = ModuleArchive.getArchiveFile((Descriptor)app);
                UIFileChooser chooser = UIFileChooser.getFileChooser(currentFile, "EarFiles");
                int rtn = chooser.showDialog(this.getOwnerWindow(), localStrings.getLocalString("ui.modulemanagerimpl.save_app_as", "Save Application As"));
                if (rtn != 0) {
                    return null;
                }
                File newFile = chooser.getSelectedFile();
                if (newFile.equals(currentFile)) {
                    return this.saveModule((Descriptor)app, true);
                }
                Descriptor mod = this.getModuleWithJar(newFile);
                if (mod != null) {
                    throw new Exception(ModuleManagerImpl.FILE_IS_OWNED(newFile, mod.getDisplayName()));
                }
                if (!FileTools.checkFileOverwrite((Component)this.getOwnerWindow(), newFile)) {
                    return null;
                }
                if (newFile.exists()) {
                    newFile.delete();
                }
                Descriptor newApp = this.saveModuleAs((Descriptor)app, newFile, true);
                UIOptionPane.showInfoDialog(this.getOwnerWindow(), ModuleManagerImpl.WAS_SAVED(app.getDisplayName(), newFile));
                return newApp;
            }
            catch (Throwable t) {
                Print.printStackTrace((String)"Saving", (Throwable)t);
                UIOptionPane.showErrorDialog(this.getOwnerWindow(), ModuleManagerImpl.UNABLE_TO_SAVE(app.getDisplayName(), t.getMessage()));
                return null;
            }
        }
        if (toSave instanceof BundleDescriptor) {
            BundleDescriptor bd = (BundleDescriptor)toSave;
            boolean isSA = DescriptorTools.isStandAlone((Descriptor)bd);
            try {
                String label = "";
                String filter = null;
                if (bd instanceof ConnectorDescriptor) {
                    label = localStrings.getLocalString("ui.modulemanagerimpl.save_rar_as", "Save RAR As");
                    filter = "RarFiles";
                } else if (bd instanceof EjbBundleDescriptor) {
                    label = localStrings.getLocalString("ui.modulemanagerimpl.save_ejb_jar_as", "Save EJB JAR As");
                    filter = "JarFiles";
                } else if (bd instanceof WebBundleDescriptor) {
                    label = localStrings.getLocalString("ui.modulemanagerimpl.save_war_as", "Save WAR As");
                    filter = "WarFiles";
                } else if (bd instanceof ApplicationClientDescriptor) {
                    label = localStrings.getLocalString("ui.modulemanagerimpl.save_app_client_as", "Save Application Client As");
                    filter = "JarFiles";
                } else {
                    Print.dprintStackTrace((String)("Unsupported BundleDescriptor: " + DT.className(bd)));
                    label = localStrings.getLocalString("ui.modulemanagerimpl.unknown", "Unknown");
                    filter = "AllFiles";
                }
                File currentFile = isSA ? ModuleArchive.getArchiveFile((Descriptor)bd) : null;
                UIFileChooser chooser = UIFileChooser.getFileChooser(currentFile, filter);
                int rtn = chooser.showDialog(this.getOwnerWindow(), label);
                if (rtn != 0) {
                    return null;
                }
                File newFile = chooser.getSelectedFile();
                if (isSA && newFile.equals(currentFile)) {
                    return this.saveModule((Descriptor)bd, true);
                }
                Descriptor mod = this.getModuleWithJar(newFile);
                if (mod != null) {
                    throw new Exception(ModuleManagerImpl.FILE_IS_OWNED(newFile, mod.getDisplayName()));
                }
                if (!FileTools.checkFileOverwrite((Component)this.getOwnerWindow(), newFile)) {
                    return null;
                }
                if (newFile.exists()) {
                    newFile.delete();
                }
                Descriptor newBD = isSA ? this.saveModuleAs((Descriptor)bd, newFile, true) : this.saveModuleAs((Descriptor)bd, newFile, false);
                UIOptionPane.showInfoDialog(this.getOwnerWindow(), ModuleManagerImpl.WAS_SAVED(bd.getDisplayName(), newFile));
                return newBD;
            }
            catch (Throwable t) {
                Print.printStackTrace((String)"Saving", (Throwable)t);
                UIOptionPane.showErrorDialog(this.getOwnerWindow(), ModuleManagerImpl.UNABLE_TO_SAVE(bd.getDisplayName(), t.getMessage()));
                return null;
            }
        }
        UIOptionPane.showWarningDialog(this.getOwnerWindow(), localStrings.getLocalString("ui.modulemanagerimpl.no_savable_object_selected", "No savable object is selected."));
        return null;
    }

    public void saveAllModules() {
        this._saveAllModules(false, true);
    }

    public boolean saveDirtyModules(boolean interactive) {
        return this._saveAllModules(true, interactive);
    }

    protected boolean _saveAllModules(boolean dirtyOnly, boolean interactive) {
        boolean didSave = true;
        Vector appList = this.getApplications();
        Iterator i = appList.iterator();
        while (i.hasNext()) {
            int doSave;
            Application app = (Application)i.next();
            if (dirtyOnly && !this.isDirty((Descriptor)app)) continue;
            boolean isValid = !DescriptorTools.hasTabErrors((Descriptor)app);
            int n = doSave = interactive && (dirtyOnly || !isValid) ? this.checkSave((Descriptor)app) : UIOptionPane.YES_OPTION;
            if (doSave == UIOptionPane.CANCEL_OPTION) {
                return false;
            }
            if (doSave != UIOptionPane.YES_OPTION) continue;
            try {
                this.saveModule((Descriptor)app, true);
            }
            catch (Throwable t) {
                if (interactive) {
                    Print.printStackTrace((String)"Saving Application", (Throwable)t);
                    UIOptionPane.showErrorDialog(this.getOwnerWindow(), ModuleManagerImpl.UNABLE_TO_SAVE(app.getDisplayName(), t.getMessage()));
                    return false;
                }
                didSave = false;
            }
        }
        Vector modList = this.getStandAlones();
        Iterator i2 = modList.iterator();
        while (i2.hasNext()) {
            int doSave;
            BundleDescriptor bd = (BundleDescriptor)i2.next();
            if (dirtyOnly && !this.isDirty((Descriptor)bd)) continue;
            boolean isValid = !DescriptorTools.hasTabErrors((Descriptor)bd);
            int n = doSave = interactive && (dirtyOnly || !isValid) ? this.checkSave((Descriptor)bd) : UIOptionPane.YES_OPTION;
            if (doSave == UIOptionPane.CANCEL_OPTION) {
                return false;
            }
            if (doSave != UIOptionPane.YES_OPTION) continue;
            try {
                this.saveModule((Descriptor)bd, true);
            }
            catch (Throwable t) {
                if (interactive) {
                    Print.printStackTrace((String)"Saving Stand-Alone", (Throwable)t);
                    UIOptionPane.showErrorDialog(this.getOwnerWindow(), ModuleManagerImpl.UNABLE_TO_SAVE(bd.getDisplayName(), t.getMessage()));
                    return false;
                }
                didSave = false;
            }
        }
        return didSave;
    }

    public Descriptor saveModule(Descriptor d) throws IOException {
        return this.saveModule(d, true);
    }

    public Descriptor saveModule(Descriptor d, boolean reload) throws IOException {
        Descriptor newDesc = this._archivistSave(d, null, false, false, reload);
        this.clearDirty(newDesc);
        return newDesc;
    }

    public boolean saveDirtyModule(Descriptor d, boolean interactive) {
        try {
            if (this.isDirty(d)) {
                int doSave;
                int n = doSave = interactive ? this.checkSave(d) : UIOptionPane.YES_OPTION;
                if (doSave == UIOptionPane.YES_OPTION) {
                    this.clearDirty(this._archivistSave(d, null, false, false, false));
                    return true;
                }
                return false;
            }
        }
        catch (IOException ioe) {
            UIOptionPane.showErrorDialog(this.getOwnerWindow(), ModuleManagerImpl.SAVE_FAILED(ioe));
            return false;
        }
        return true;
    }

    public Descriptor saveModuleAs(Descriptor d, File newFile) throws IOException {
        return this.saveModuleAs(d, newFile, true);
    }

    public Descriptor saveModuleAs(Descriptor d, File newFile, boolean reload) throws IOException {
        Descriptor newDesc = this._archivistSave(d, newFile, false, true, reload);
        this.clearDirty(newDesc);
        return newDesc;
    }

    public Descriptor saveModuleAsPure(Descriptor d, File newFile) throws IOException {
        Descriptor newDesc = this._archivistSave(d, newFile, true, false, false);
        return newDesc;
    }

    public void copyModuleAs(Descriptor desc, File newFile) throws IOException {
        this._archivistSave(desc, newFile, false, false, false);
    }

    protected Descriptor _archivistSave(Descriptor d, File file, boolean pure, boolean resetUri, boolean reopen) throws IOException {
        if (d instanceof Application) {
            // empty if block
        }
        ModuleArchive modArch = ModuleArchive.getModuleArchive(d);
        if (file != null) {
            if (pure) {
                modArch.saveAsPure(file);
            } else if (resetUri) {
                modArch.setArchiveFile(file);
                modArch.save();
            } else {
                modArch.saveAs(file);
            }
        } else {
            modArch.save();
        }
        if (!pure && reopen) {
            File archFile = modArch.getArchiveFile();
            if (archFile != null) {
                try {
                    return this.setActiveModule(this.openModule(archFile, false));
                }
                catch (Throwable t) {
                    Print.printStackTrace((String)("Unable to reopen saved module: " + archFile), (Throwable)t);
                }
            } else {
                Print.dprintln((String)"Unable to reopen: archiveFile is null");
            }
        }
        return d;
    }

    public boolean preVerifyModule(Descriptor d) {
        if (d instanceof Application) {
            Application app = (Application)d;
            Set bds = app.getBundleDescriptors();
            boolean ok = true;
            Iterator i = bds.iterator();
            while (i.hasNext()) {
                if (this.preVerifyBundle(app, (BundleDescriptor)i.next())) continue;
                ok = false;
            }
            return ok;
        }
        if (d instanceof BundleDescriptor) {
            BundleDescriptor bd = (BundleDescriptor)d;
            return this.preVerifyBundle(null, bd);
        }
        return true;
    }

    public boolean preVerifyBundle(Application app, BundleDescriptor bd) {
        boolean ok = true;
        if (app != null) {
            if (bd != null) {
                if (app != bd.getApplication()) {
                    ok = ModuleManagerImpl.printPreVerifyMessage(app, bd, "Application mismatch", ok);
                }
                if (DescriptorTools.isStandAlone((Descriptor)bd)) {
                    ok = ModuleManagerImpl.printPreVerifyMessage(app, bd, "Application Bundle says it's a stand-alone", ok);
                }
            } else {
                ok = ModuleManagerImpl.printPreVerifyMessage(app, bd, "Application Bundle is 'null'", ok);
            }
        } else if (bd == null) {
            ok = ModuleManagerImpl.printPreVerifyMessage(app, bd, "Stand-Alone Bundle is 'null'", ok);
        } else if (!DescriptorTools.isStandAlone((Descriptor)bd)) {
            ok = ModuleManagerImpl.printPreVerifyMessage(app, bd, "Stand-Alone Bundle says it isn't a stand-alone", ok);
        }
        if (bd != null) {
            if (bd instanceof WebBundleDescriptor) {
                WebBundleDescriptor wbd = (WebBundleDescriptor)bd;
                Set cs = wbd.getWebComponentDescriptorsSet();
                Iterator i = cs.iterator();
                while (i.hasNext()) {
                    Descriptor d = (Descriptor)i.next();
                    if (bd == DescriptorTools.getBundleDescriptor(d)) continue;
                    ok = ModuleManagerImpl.printPreVerifyMessage(app, bd, "Component BundleDescriptor mismatch", ok);
                }
            } else if (bd instanceof EjbBundleDescriptor) {
                EjbBundleDescriptor ebd = (EjbBundleDescriptor)bd;
                Set cs = ebd.getEjbs();
                Iterator i = cs.iterator();
                while (i.hasNext()) {
                    Descriptor d = (Descriptor)i.next();
                    if (bd == DescriptorTools.getBundleDescriptor(d)) continue;
                    ok = ModuleManagerImpl.printPreVerifyMessage(app, bd, "Component BundleDescriptor mismatch", ok);
                }
            } else if (bd instanceof ConnectorDescriptor) {
                ConnectorDescriptor cd = (ConnectorDescriptor)bd;
            } else if (bd instanceof ApplicationClientDescriptor) {
                ApplicationClientDescriptor acd = (ApplicationClientDescriptor)bd;
            } else {
                ok = ModuleManagerImpl.printPreVerifyMessage(app, bd, "Unrecognized Bundle", ok);
            }
        }
        return ok;
    }

    public static boolean printPreVerifyMessage(Application app, BundleDescriptor bd, String msg, boolean ok) {
        if (!ok) {
            Print.println((String)"] --------------------------------------------------------------------------------");
            Print.println((String)"] Pre-validation errors:");
            Print.println((String)("]   Application: " + DescriptorTools.getDisplayName(app)));
            Print.println((String)("]   Bundle     : " + DescriptorTools.getDisplayName(bd) + " - " + DT.className(bd)));
        }
        Print.println((String)("]   => " + msg));
        return false;
    }

    public Descriptor getModuleWithJar(File jarFile) {
        File jarFileAbs = jarFile.getAbsoluteFile();
        Vector appList = this.getApplications();
        Iterator i = appList.iterator();
        while (i.hasNext()) {
            Application app = (Application)i.next();
            File appFile = ModuleArchive.getArchiveFile((Descriptor)app);
            if (appFile == null || !appFile.equals(jarFileAbs)) continue;
            return app;
        }
        Vector saList = this.getStandAlones();
        Iterator i2 = saList.iterator();
        while (i2.hasNext()) {
            BundleDescriptor bd = (BundleDescriptor)i2.next();
            File uriFile = ModuleArchive.getArchiveFile((Descriptor)bd);
            if (!uriFile.equals(jarFileAbs)) continue;
            return bd;
        }
        return null;
    }

    public Descriptor addModule(Descriptor d) {
        return this.addModule(d, true);
    }

    public Descriptor addModule(Descriptor d, boolean activate) {
        this.preVerifyModule(d);
        if (d != null) {
            if (d instanceof Application) {
                this.getApplicationManager()._addApplication((Application)d);
                d.addNotificationListener(this.getDescriptorChangedListener());
                this.notify("ModuleAdded", "ModuleProperty", d);
            } else if (d instanceof BundleDescriptor) {
                this.getStandAloneManager()._addStandAlone((BundleDescriptor)d);
                d.addNotificationListener(this.getDescriptorChangedListener());
                this.notify("ModuleAdded", "ModuleProperty", d);
            } else {
                Print.printStackTrace((String)("Invalid descriptor: " + UIUtils.debugClassName(d)));
            }
        }
        return d;
    }

    public void removeModule(Descriptor d) {
        if (d != null) {
            if (d instanceof Application) {
                if (this.getActiveModule() == d) {
                    this.setActiveModule(null);
                }
                UIProject.removeProject(d);
                ClassLoader cl = ModuleArchive.getClassLoader(d);
                if (cl instanceof J2EEClassLoader) {
                    J2EEClassLoader j2eecl = (J2EEClassLoader)cl;
                    j2eecl.cleanup();
                }
                d.removeNotificationListener(this.getDescriptorChangedListener());
                this.getApplicationManager()._removeApplication((Application)d);
                this.notify("ModuleRemoved", "ModuleProperty", d);
            } else if (d instanceof BundleDescriptor) {
                if (this.getActiveModule() == d) {
                    this.setActiveModule(null);
                }
                UIProject.removeProject(d);
                ClassLoader cl = ModuleArchive.getClassLoader(d);
                if (cl instanceof J2EEClassLoader) {
                    J2EEClassLoader j2eecl = (J2EEClassLoader)cl;
                    j2eecl.cleanup();
                }
                d.removeNotificationListener(this.getDescriptorChangedListener());
                this.getStandAloneManager()._removeStandAlone((BundleDescriptor)d);
                this.notify("ModuleRemoved", "ModuleProperty", d);
            } else {
                Print.printStackTrace((String)("Invalid descriptor: " + UIUtils.debugClassName(d)));
            }
        }
    }

    private NotificationListener getDescriptorChangedListener() {
        if (this.descriptorChangedListener == null) {
            this.descriptorChangedListener = this;
        }
        return this.descriptorChangedListener;
    }

    public boolean isDirty(Descriptor d) {
        return DescriptorTools.isDirty(d);
    }

    public void setDirty(Descriptor d) {
        if (!this.isDirty(d)) {
            DescriptorTools.setDirty(d);
        }
    }

    public void clearDirty(Descriptor d) {
        if (this.isDirty(d)) {
            DescriptorTools.clearDirty(d);
        }
    }

    public Descriptor addEjbToApp(Application app, File jarFile) throws Exception {
        if (app == null) {
            return null;
        }
        if (jarFile == null) {
            UIFileChooser chooser = UIFileChooser.getFileChooser(null, "JarFiles");
            int rtn = chooser.showDialog(this.getOwnerWindow(), localStrings.getLocalString("ui.modulemanagerimpl.add_ejbjar", "Add EJB JAR"));
            if (rtn != 0) {
                return null;
            }
            jarFile = chooser.getSelectedFile();
        }
        if (jarFile == null || !jarFile.exists()) {
            throw new FileNotFoundException(ModuleManagerImpl.FILE_NON_EXISTANT(jarFile));
        }
        if (!FileUtil.isEJBJar((File)jarFile)) {
            throw new Exception(localStrings.getLocalString("ui.modulemanagerimpl.invalid_ejbjar", "Not a valid EJB jar file"));
        }
        BundleDescriptor d = ModuleArchive.getModuleArchive((Descriptor)app).addArchive(jarFile);
        return d;
    }

    public Descriptor addWarToApp(Application app, File jarFile) throws Exception {
        if (app == null) {
            return null;
        }
        if (jarFile == null) {
            UIFileChooser chooser = UIFileChooser.getFileChooser(null, "WarFiles");
            int rtn = chooser.showDialog(this.getOwnerWindow(), localStrings.getLocalString("ui.modulemanagerimpl.add_war", "Add Web WAR"));
            if (rtn != 0) {
                return null;
            }
            jarFile = chooser.getSelectedFile();
        }
        if (jarFile == null || !jarFile.exists()) {
            throw new FileNotFoundException(ModuleManagerImpl.FILE_NON_EXISTANT(jarFile));
        }
        if (!FileUtil.isWARFile((File)jarFile)) {
            throw new Exception(localStrings.getLocalString("ui.modulemanagerimpl.invalid_war", "Not a valid WAR file"));
        }
        ModuleArchive appArch = ModuleArchive.getModuleArchive((Descriptor)app);
        BundleDescriptor d = appArch.addArchive(jarFile);
        return d;
    }

    public Descriptor addAppClientToApp(Application app, File jarFile) throws Exception {
        if (app == null) {
            return null;
        }
        if (jarFile == null) {
            UIFileChooser chooser = UIFileChooser.getFileChooser(null, "JarFiles");
            int rtn = chooser.showDialog(this.getOwnerWindow(), localStrings.getLocalString("ui.modulemanagerimpl.add_appclientjar", "Add Application Client JAR"));
            if (rtn != 0) {
                return null;
            }
            jarFile = chooser.getSelectedFile();
        }
        if (jarFile == null || !jarFile.exists()) {
            throw new FileNotFoundException(ModuleManagerImpl.FILE_NON_EXISTANT(jarFile));
        }
        if (!FileUtil.isAppClientJar((File)jarFile)) {
            throw new Exception(localStrings.getLocalString("ui.modulemanagerimpl.invalid_appclientjar", "Not a valid Application Client Jar file"));
        }
        return ModuleArchive.getModuleArchive((Descriptor)app).addArchive(jarFile);
    }

    public Descriptor addRarToApp(Application app, File jarFile) throws Exception {
        if (app == null) {
            return null;
        }
        if (jarFile == null) {
            UIFileChooser chooser = UIFileChooser.getFileChooser(null, "RarFiles");
            int rtn = chooser.showDialog(this.getOwnerWindow(), localStrings.getLocalString("ui.modulemanagerimpl.add_rar", "Add Resource Adapter RAR"));
            if (rtn != 0) {
                return null;
            }
            jarFile = chooser.getSelectedFile();
        }
        if (jarFile == null || !jarFile.exists()) {
            throw new FileNotFoundException(ModuleManagerImpl.FILE_NON_EXISTANT(jarFile));
        }
        if (!FileUtil.isRARFile((File)jarFile)) {
            throw new Exception(localStrings.getLocalString("ui.modulemanagerimpl.invalid_rar", "Not a valid Resource Adapter Jar file"));
        }
        return ModuleArchive.getModuleArchive((Descriptor)app).addArchive(jarFile);
    }

    public void tagOpenModules(boolean save) {
        Vector<String> modules = new Vector<String>();
        Enumeration e = this.getApplications().elements();
        while (e.hasMoreElements()) {
            Application app = (Application)e.nextElement();
            modules.add(ModuleArchive.getArchiveUri((Descriptor)app));
        }
        e = this.getStandAlones().elements();
        while (e.hasMoreElements()) {
            Descriptor d = (Descriptor)e.nextElement();
            modules.add(ModuleArchive.getArchiveUri(d));
        }
        UIConfig.setConfigList("ui.current.modules", modules);
        if (save) {
            UIConfig.saveConfig();
        }
    }

    public void setNotificationEnabled(boolean flag) {
        if (!flag) {
            ++this.notifyDisableCount;
        } else if (this.notifyDisableCount > 0) {
            --this.notifyDisableCount;
        }
    }

    public boolean isNotificationEnabled() {
        return this.notifyDisableCount == 0;
    }

    public void addNotificationListener(NotificationListener nl) {
        if (!this.notifyListeners.contains(nl)) {
            this.notifyListeners.addElement(nl);
        }
    }

    public void removeNotificationListener(NotificationListener nl) {
        this.notifyListeners.removeElement(nl);
    }

    public void notification(NotificationEvent ne) {
        String type = ne.getType();
        if (Descriptor.DESCRIPTOR_CHANGED.equals(type)) {
            Descriptor d = (Descriptor)ne.getObjectThatChanged();
            Object attr = ne.getAttributeThatChanged();
            if ("RefreshOnly".equals(attr)) {
                this.notify(type, NotificationEvent.OBJECT_THAT_CHANGED, d);
            } else if (this.isNotificationEnabled()) {
                this.setDirty(d);
                this.notify(type, NotificationEvent.OBJECT_THAT_CHANGED, d);
            }
        } else {
            Print.dprintStackTrace((String)("!DESCRIPTOR_CHANGED!: " + type));
            this.notify(type, NotificationEvent.OBJECT_THAT_CHANGED, ne.getObjectThatChanged());
        }
    }

    private void notify(String type, String name, Object value) {
        if (!this.isNotificationEnabled()) {
            return;
        }
        NotificationEvent ne = name == null ? new NotificationEvent((Object)this, type) : new NotificationEvent((Object)this, type, name, value);
        this._sendNotificationEvent(ne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sendNotificationEvent(NotificationEvent ne) {
        Vector listenersClone = null;
        Vector vector = this.notifyListeners;
        synchronized (vector) {
            listenersClone = (Vector)this.notifyListeners.clone();
        }
        Iterator i = listenersClone.iterator();
        while (i.hasNext()) {
            NotificationListener nl = (NotificationListener)i.next();
            nl.notification(ne);
        }
    }

    public Vector getApplications() {
        return this.getApplicationManager().getApplications();
    }

    public Vector getApplicationNames() {
        return this.getApplicationManager().getApplicationNames();
    }

    private ApplicationManager getApplicationManager() {
        if (this.applicationManager == null) {
            this.applicationManager = new ApplicationManager();
        }
        return this.applicationManager;
    }

    public List getModules(ModuleType type) {
        return ModuleType.EAR.equals(type) ? this.getApplications() : this.getStandAloneManager().getStandAlones(type);
    }

    public List getModuleNames(ModuleType type) {
        List mods = this.getModules(type);
        Vector<String> names = new Vector<String>();
        Iterator i = mods.iterator();
        while (i.hasNext()) {
            names.add(DescriptorTools.getDisplayName(i.next()));
        }
        return names;
    }

    public Vector getStandAlones() {
        return this.getStandAloneManager().getStandAlones();
    }

    public Vector getStandAloneNames() {
        return this.getStandAloneManager().getStandAloneNames();
    }

    private StandAloneManager getStandAloneManager() {
        if (this.standAloneManager == null) {
            this.standAloneManager = new StandAloneManager();
        }
        return this.standAloneManager;
    }

    private class StandAloneManager {
        private Vector standalones = new Vector();

        private StandAloneManager() {
        }

        public List getStandAlones(ModuleType bundleType) {
            Vector<BundleDescriptor> m = new Vector<BundleDescriptor>();
            Iterator i = this.standalones.iterator();
            while (i.hasNext()) {
                BundleDescriptor bd = (BundleDescriptor)i.next();
                if (!bd.getModuleType().equals(bundleType)) continue;
                m.add(bd);
            }
            return m;
        }

        public Vector getStandAlones() {
            return (Vector)this.standalones.clone();
        }

        public Vector getStandAloneNames() {
            Vector<String> names = new Vector<String>();
            Iterator i = this.standalones.iterator();
            while (i.hasNext()) {
                names.addElement(((BundleDescriptor)i.next()).getDisplayName());
            }
            return names;
        }

        public void _addStandAlone(BundleDescriptor desc) {
            String newName;
            String oldName = desc.getDisplayName();
            if (!oldName.equals(newName = DescriptorTools.createUniqueName(oldName, desc, this.standalones.iterator()))) {
                desc.setDisplayName(newName);
            }
            this.standalones.addElement(desc);
        }

        public void _removeStandAlone(BundleDescriptor desc) {
            this.standalones.removeElement(desc);
        }
    }

    private class ApplicationManager {
        private Vector applications = new Vector();

        private ApplicationManager() {
        }

        public Vector getApplications() {
            return (Vector)this.applications.clone();
        }

        public Vector getApplicationNames() {
            Vector<String> names = new Vector<String>();
            Enumeration e = this.applications.elements();
            while (e.hasMoreElements()) {
                names.addElement(((Application)e.nextElement()).getDisplayName());
            }
            return names;
        }

        public void _removeApplication(Application app) {
            this.applications.removeElement(app);
        }

        public void _addApplication(Application app) {
            String newName;
            String oldName = app.getDisplayName();
            if (!oldName.equals(newName = DescriptorTools.createUniqueName(oldName, app, this.applications.iterator()))) {
                app.setDisplayName(newName);
            }
            this.applications.addElement(app);
        }
    }
}

