/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.AbstractArchiveFactory;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.ConnectorArchivist;
import com.sun.enterprise.deployment.archivist.InputJarArchive;
import com.sun.enterprise.deployment.archivist.JarArchiveFactory;
import com.sun.enterprise.deployment.archivist.MemoryMappedArchive;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.archivist.SunOneAppArchivist;
import com.sun.enterprise.tools.deployment.ui.archivist.SunOneAppClientArchivist;
import com.sun.enterprise.tools.deployment.ui.archivist.SunOneConnectorArchivist;
import com.sun.enterprise.tools.deployment.ui.archivist.SunOneEjbArchivist;
import com.sun.enterprise.tools.deployment.ui.archivist.SunOneWebArchivist;
import com.sun.enterprise.tools.deployment.ui.shared.ArchiveEntryManager;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.DTClassLoader;
import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.J2EEClassLoader;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.util.Print;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.enterprise.deploy.shared.ModuleType;
import org.xml.sax.SAXParseException;

public class ModuleArchive
extends MemoryMappedArchive
implements ArchiveEntryManager {
    protected static String ATTR_MODULE_ARCHIVE = "ui.ModuleArchive";
    protected static String ATTR_ARCHIVIST = "ui.Archivist";
    protected static String WEB_SERVICES_XML = "/webservices.xml";
    protected static AbstractArchiveFactory defaultAbsArchFact = null;
    private static int MarkerCounter = 1;
    private int uid = -1;
    private Descriptor descriptor = null;
    private String archivePath = "";
    private AbstractArchive inputArchive = null;
    private ModuleArchiveManifest manifest = null;
    private boolean saveAsPureModuleOnly = false;
    private ClassLoader classLoader = null;
    private Vector inputArchiveEntries = null;
    private Map entriesAdded = new HashMap();
    private Set entriesRemoved = new HashSet();
    private static boolean sunOneArchivistRegistered = false;
    private static EmptyArchive _EmptyArchive = new EmptyArchive();

    public static String getXMLEntryName(Descriptor d) {
        if (d instanceof Application) {
            return "META-INF/application.xml";
        }
        if (d instanceof ConnectorDescriptor) {
            return "META-INF/ra.xml";
        }
        if (d instanceof EjbBundleDescriptor) {
            return "META-INF/ejb-jar.xml";
        }
        if (d instanceof WebBundleDescriptor) {
            return "WEB-INF/web.xml";
        }
        if (d instanceof ApplicationClientDescriptor) {
            return "META-INF/application-client.xml";
        }
        return null;
    }

    public static boolean isValidModule(Descriptor d) {
        return ModuleArchive.getXMLEntryName(d) != null;
    }

    public boolean isValidModule() {
        return ModuleArchive.isValidModule(this.getDescriptor());
    }

    protected static ModuleArchive _getModuleArchive(Descriptor bd) {
        Object ma = bd != null ? bd.getExtraAttribute(ATTR_MODULE_ARCHIVE) : null;
        return ma instanceof ModuleArchive ? (ModuleArchive)ma : null;
    }

    public static ModuleArchive getModuleArchive(Descriptor d) {
        ModuleArchive ma;
        if (d == null) {
            return new ModuleArchive();
        }
        if (!ModuleArchive.isValidModule(d)) {
            Print.printStackTrace((String)"Invalid Module");
        }
        if ((ma = ModuleArchive._getModuleArchive(d)) != null) {
            return ma;
        }
        String descName = d.getDisplayName();
        if (d instanceof Application) {
            return ModuleArchive.newModuleArchive(d, null, null);
        }
        if (DescriptorTools.isStandAlone(d)) {
            return ModuleArchive.newModuleArchive(d, null, null);
        }
        if (d instanceof BundleDescriptor && ((BundleDescriptor)d).getApplication() != null) {
            Application app = ((BundleDescriptor)d).getApplication();
            ModuleArchive appMod = ModuleArchive.getModuleArchive((Descriptor)app);
            Iterator i = app.getModules();
            while (i.hasNext()) {
                ModuleDescriptor md = (ModuleDescriptor)i.next();
                if (md.getDescriptor() != d) continue;
                String uri = md.getArchiveUri();
                if (uri != null && !uri.equals("")) {
                    try {
                        AbstractArchive embArch = appMod.getEmbeddedArchive(uri);
                        ModuleArchive bdMod = new ModuleArchive(d, md.getManifest(), null, embArch);
                        d.addExtraAttribute(ATTR_MODULE_ARCHIVE, (Object)bdMod);
                        return bdMod;
                    }
                    catch (Throwable t) {
                        Print.dprintln((String)("getEmbeddedArchive('" + descName + "'): " + t));
                        break;
                    }
                }
                Print.dprintln((String)("BundleDescriptor URI is null: " + descName));
            }
            Print.dprintStackTrace((String)("Bundle missing from Application's children: " + descName));
            return ModuleArchive.newModuleArchive(d, null, null);
        }
        Print.printStackTrace((String)("Invalid stand-alone BundleDescriptor: " + descName));
        return ModuleArchive.newModuleArchive(d, null, null);
    }

    public static ModuleArchive newModuleArchive(Descriptor bd, String archUri, Map contentMap) {
        ModuleArchive modArch;
        if (!ModuleArchive.isValidModule(bd)) {
            Print.printStackTrace((String)"Invalid Module");
        }
        if ((modArch = ModuleArchive._getModuleArchive(bd)) == null) {
            modArch = new ModuleArchive(bd, null, null, null);
        }
        modArch.setArchiveUri(archUri);
        modArch.addArchiveEntries(contentMap);
        bd.addExtraAttribute(ATTR_MODULE_ARCHIVE, (Object)modArch);
        return modArch;
    }

    public static Descriptor openModuleArchive(File archFile, ModuleType type) throws IOException {
        if (!archFile.isFile()) {
            throw new FileNotFoundException(archFile.toString());
        }
        Archivist arch = ModuleArchive.createArchivistForType(type);
        if (arch == null) {
            return null;
        }
        String archUri = archFile.getAbsolutePath();
        arch.setArchiveUri(archUri);
        AbstractArchiveFactory fact = arch.getAbstractArchiveFactory();
        AbstractArchive absArch = fact.openArchive(archUri);
        if (absArch == null) {
            Print.dprintStackTrace((String)"AbstractArchive is 'null'!");
            return null;
        }
        try {
            SunOneUtils.setAbstractArchive(absArch);
            RootDeploymentDescriptor rd = arch.open(absArch);
            ModuleArchive modArch = new ModuleArchive((Descriptor)rd, arch.getManifest(), arch, absArch);
            modArch.setArchiveUri(archUri);
            rd.addExtraAttribute(ATTR_MODULE_ARCHIVE, (Object)modArch);
            if (rd instanceof BundleDescriptor) {
                ModuleArchive.wrapStandAloneInApplication((BundleDescriptor)rd, archFile.getName());
            }
            RootDeploymentDescriptor rootDeploymentDescriptor = rd;
            return rootDeploymentDescriptor;
        }
        catch (SAXParseException spe) {
            IOException ioe = new IOException(spe.toString());
            ioe.initCause(spe);
            throw ioe;
        }
        catch (Throwable t) {
            Print.printStackTrace((String)"Error openning module", (Throwable)t);
            IOException ioe = new IOException(t.toString());
            ioe.initCause(t);
            throw ioe;
        }
        finally {
            try {
                absArch.close();
            }
            catch (IOException ioe) {}
        }
    }

    public static void wrapStandAloneInApplication(BundleDescriptor bd, String appName) {
        if (bd.getApplication() == null) {
            if (appName == null) {
                appName = bd.getDisplayName();
            }
            Application app = Application.createApplication((String)appName, (ModuleDescriptor)bd.getModuleDescriptor());
            app.setDisplayName("*STANDALONE*");
        }
    }

    public static Archivist getArchivist(Descriptor d) {
        ModuleArchive modArch = ModuleArchive.getModuleArchive(d);
        return modArch != null ? modArch.getArchivist() : null;
    }

    public static String getArchiveUri(Descriptor d) {
        ModuleArchive modArch = ModuleArchive.getModuleArchive(d);
        String uri = "";
        if (modArch != null) {
            uri = modArch.getArchiveUri();
            try {
                modArch.close();
            }
            catch (IOException ioe) {
                Print.dprintStackTrace((String)("Error closing module archive: " + uri), (Throwable)ioe);
            }
        }
        return uri;
    }

    public static File getArchiveFile(Descriptor d) {
        ModuleArchive modArch = ModuleArchive.getModuleArchive(d);
        return modArch != null ? modArch.getArchiveFile() : null;
    }

    public static ClassLoader getClassLoader(Descriptor d) {
        ModuleArchive modArch = ModuleArchive.getModuleArchive(d);
        return modArch != null ? modArch.getClassLoader() : null;
    }

    public static boolean isStandAlone(Descriptor d) {
        return DescriptorTools.isStandAlone(d);
    }

    protected static AbstractArchiveFactory getDefaultAbstractArchiveFactory() {
        if (defaultAbsArchFact == null) {
            defaultAbsArchFact = new JarArchiveFactory();
        }
        return defaultAbsArchFact;
    }

    private ModuleArchive() {
        this(new Descriptor(), null, null, null);
        Print.dprintStackTrace((String)"Created empty (null) module [FIX THIS]");
    }

    protected ModuleArchive(Descriptor d, Manifest man, Archivist arch, AbstractArchive inpArch) {
        ModuleArchive.registerSunOneArchivist();
        this.uid = MarkerCounter++;
        this.descriptor = d;
        if (arch == null) {
            arch = ModuleArchive.createArchivistForDescriptor(d);
        }
        SunOneUtils.createSunOneXml(d);
        this.setArchivist(arch);
        this.setInputArchive(inpArch);
        this.getInputArchiveEntries();
        this.setClassLoader(new ModuleArchiveClassLoader());
        if (arch != null) {
            this.manifest = new ModuleArchiveManifest(man != null ? man : arch.getManifest());
            arch.setManifest((Manifest)this.manifest);
            if (d instanceof BundleDescriptor) {
                ((BundleDescriptor)d).getModuleDescriptor().setManifest((Manifest)this.manifest);
            }
        } else {
            Print.dprintStackTrace((String)("Null Archivist: Invalid Descriptor - " + DT.className(d)));
        }
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean isApplication() {
        return this.getDescriptor() instanceof Application;
    }

    public boolean isStandAlone() {
        return DescriptorTools.isStandAlone(this.getDescriptor());
    }

    public String getDisplayName() {
        return DescriptorTools.getDisplayName(this.getDescriptor());
    }

    public boolean isBundleDescriptor() {
        return this.getDescriptor() instanceof BundleDescriptor;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public void setSaveAsPureJ2EEModule(boolean s) {
        this.saveAsPureModuleOnly = s;
    }

    public boolean getSaveAsPureJ2EEModule() {
        return this.saveAsPureModuleOnly;
    }

    public AbstractArchive getInputArchive() {
        if (this.isValidModule()) {
            File archFile;
            if (this.inputArchive == null && (archFile = this.getArchiveFile()) != null && archFile.exists()) {
                AbstractArchiveFactory fact = this.getArchivist().getAbstractArchiveFactory();
                try {
                    this.inputArchive = fact.openArchive(archFile.getAbsolutePath());
                }
                catch (IOException ioe) {
                    Print.dprintln((String)("Still couldn't open inputArchive: " + ioe));
                }
            }
            return this.inputArchive;
        }
        return null;
    }

    public void setInputArchive(AbstractArchive inpArch) {
        if (inpArch != null) {
            this.setArchiveUri(inpArch.getArchiveUri());
            this.inputArchive = inpArch;
        } else {
            this.setArchiveUri(null);
            this.inputArchive = null;
        }
    }

    protected AbstractArchive _openInputArchive() {
        if (this.inputArchive instanceof InputJarArchive) {
            try {
                File ijaFile;
                InputJarArchive ija = (InputJarArchive)this.inputArchive;
                if (!ija.exists() && (ijaFile = new File(ija.getArchiveUri())).isAbsolute() && ijaFile.exists()) {
                    ija.open(ija.getArchiveUri());
                }
                Descriptor d = this.getDescriptor();
                if (!this.isStandAlone() && d instanceof BundleDescriptor) {
                    ModuleArchive ma;
                    Application app = ((BundleDescriptor)d).getApplication();
                    ModuleArchive moduleArchive = ma = app != null ? ModuleArchive.getModuleArchive((Descriptor)app) : null;
                    if (ma != null) {
                        ma._openInputArchive();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.inputArchive;
    }

    public void setArchiveUri(String path) {
        String string = this.archivePath = path != null ? path : "";
        if (this.isValidModule()) {
            this.getArchivist().setArchiveUri(path);
        }
    }

    public void setArchiveFile(File path) {
        this.setArchiveUri(path != null ? path.getAbsolutePath() : null);
    }

    public String getArchiveUri() {
        if (this.isValidModule()) {
            String archPath;
            Archivist arch = this.getArchivist();
            String string = archPath = arch != null ? arch.getArchiveUri() : null;
            if (archPath != null && !archPath.equals("") && !archPath.equals(this.archivePath)) {
                this.archivePath = archPath;
            }
            return this.archivePath != null ? this.archivePath : "";
        }
        return "";
    }

    public File getArchiveFile() {
        if (this.isValidModule()) {
            String archUri = this.getArchiveUri();
            File archFile = !archUri.equals("") ? new File(archUri) : null;
            return archFile != null && archFile.isAbsolute() ? archFile : null;
        }
        return null;
    }

    private boolean _containsWebServiceDescriptor(Descriptor d) {
        if (d instanceof BundleDescriptor) {
            return ((BundleDescriptor)d).getWebServices().hasWebServices();
        }
        return false;
    }

    private InputStream _getWebServicesDDInputStream() {
        Descriptor d = this.getDescriptor();
        if (this._containsWebServiceDescriptor(d)) {
            DeploymentDescriptorFile wsDD = this.getArchivist().getWebServicesDDFile(d);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            wsDD.write(d, (OutputStream)out);
            return new ByteArrayInputStream(out.toByteArray());
        }
        return null;
    }

    public List getEntryNames(String type) {
        Vector<String> list = new Vector<String>();
        Enumeration e = this.entries();
        while (e.hasMoreElements()) {
            String item = (String)e.nextElement();
            if (type != null && !item.endsWith(type)) continue;
            list.add(item);
        }
        return list;
    }

    public List getEntryNames() {
        return this.getEntryNames(null);
    }

    public List getClassNames() {
        Vector<String> list = new Vector<String>();
        Enumeration e = this.entries();
        while (e.hasMoreElements()) {
            String cn;
            int p;
            String name;
            String item = (String)e.nextElement();
            if (item.endsWith(".class")) {
                int p1 = item.startsWith("WEB-INF/classes/") ? "WEB-INF/classes/".length() : 0;
                int p2 = item.lastIndexOf(".class");
                String cn2 = item.substring(p1, p2).replace('/', '.');
                list.add(cn2);
                continue;
            }
            if (item.endsWith(".jar") && this.getDescriptor() instanceof WebBundleDescriptor) {
                try {
                    ZipEntry je;
                    JarInputStream jarEntry = new JarInputStream(this.getEntry(item));
                    while ((je = jarEntry.getNextEntry()) != null) {
                        name = je.getName();
                        if (!name.endsWith(".class")) continue;
                        p = name.lastIndexOf(".class");
                        cn = name.substring(0, p).replace('/', '.');
                        list.add(cn);
                    }
                    jarEntry.close();
                }
                catch (IOException ioe) {
                    Print.dprintStackTrace((String)("Unable to read JarEntry: " + item), (Throwable)ioe);
                }
                continue;
            }
            if (!item.endsWith(".jar") || !(this.getDescriptor() instanceof ConnectorDescriptor)) continue;
            try {
                ZipEntry je;
                JarInputStream jarEntry = new JarInputStream(this.getEntry(item));
                while ((je = jarEntry.getNextEntry()) != null) {
                    name = je.getName();
                    if (!name.endsWith(".class")) continue;
                    p = name.lastIndexOf(".class");
                    cn = name.substring(0, p).replace('/', '.');
                    list.add(cn);
                }
                jarEntry.close();
            }
            catch (IOException ioe) {
                Print.dprintStackTrace((String)("Unable to read JarEntry: " + item), (Throwable)ioe);
            }
        }
        return list;
    }

    public List getClasses() {
        Vector list = new Vector();
        ClassLoader classLoader = this.getClassLoader();
        Iterator i = this.getClassNames().iterator();
        while (i.hasNext()) {
            String cn = (String)i.next();
            try {
                list.add(classLoader.loadClass(cn));
            }
            catch (Throwable t) {
                Print.dprintStackTrace((String)("Error loading class: " + cn), (Throwable)t);
            }
        }
        return list;
    }

    public void setClassLoader(ClassLoader cl) {
        if (cl == null) {
            Print.dprintln((String)"Setting 'null' ClassLoader!!!");
        }
        if (this.isValidModule()) {
            this.classLoader = cl;
            this.getArchivist().setClassLoader(cl);
            Descriptor d = this.getDescriptor();
            if (d instanceof RootDeploymentDescriptor) {
                ((RootDeploymentDescriptor)d).setClassLoader(cl);
            } else {
                Print.dprintln((String)("Unsupported descriptor: " + DT.className(d)));
            }
        }
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return new ModuleArchiveClassLoader();
    }

    protected void clearInputArchiveEntries() {
        this.inputArchiveEntries = null;
    }

    protected Vector getInputArchiveEntries() {
        if (this.inputArchiveEntries == null) {
            this.inputArchiveEntries = new Vector();
            if (this.getInputArchive() != null) {
                Enumeration e = this._openInputArchive().entries();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    this.inputArchiveEntries.add(name);
                }
            }
        }
        return this.inputArchiveEntries;
    }

    public void printArchiveEntries(String msg) {
        if (!UIConfig.debugMode()) {
            return;
        }
        Map ht = this.getArchiveEntries();
        Print.dprintln((String)("Archive Entries: " + msg + " [" + this.uid + "]"));
        Iterator i = ht.keySet().iterator();
        while (i.hasNext()) {
            Object k = i.next();
            Print.println((String)("  " + k + " => " + ht.get(k)));
        }
        Print.println((String)"");
    }

    public boolean containsArchiveEntry(String name) {
        if (name == null) {
            return false;
        }
        if (this.entriesAdded.containsKey(name)) {
            return true;
        }
        if (this.entriesRemoved.contains(name)) {
            return false;
        }
        return this.getInputArchiveEntries().contains(name);
    }

    protected boolean _isSkipEntry(String name) {
        if (this.entriesRemoved.contains(name)) {
            return true;
        }
        if (name.equals("META-INF/MANIFEST.MF")) {
            return true;
        }
        if (!UIConfig.getConfigBoolean("ui.project.saveProjectFile")) {
            return name.endsWith(UIProject.PROJECT_FILENAME);
        }
        return false;
    }

    public Map getArchiveEntries() {
        HashMap entries = new HashMap(this.entriesAdded);
        Iterator i = this.getInputArchiveEntries().iterator();
        while (i.hasNext()) {
            String name = ModuleArchive.ArchSep((String)i.next());
            if (this._isSkipEntry(name) || entries.containsKey(name)) continue;
            entries.put(name, null);
        }
        return entries;
    }

    protected void _addArchiveEntry(String name, File file) {
        if (name != null) {
            String n = ModuleArchive.ArchSep(name);
            if (!this.entriesAdded.containsKey(n)) {
                this.entriesAdded.put(n, file);
            }
            if (this.entriesRemoved.contains(n)) {
                this.entriesRemoved.remove(n);
            }
        }
    }

    public void addArchiveEntry(String name, File file) {
        if (name != null) {
            Descriptor d = this.getDescriptor();
            this._addArchiveEntry(name, file);
            UIProject.addArchiveEntry(d, name, file);
            if (d != null) {
                d.changed();
            }
        }
    }

    public void addArchiveEntries(Map entries) {
        if (entries != null && entries.size() > 0) {
            Iterator k = entries.keySet().iterator();
            while (k.hasNext()) {
                Object key = k.next();
                if (key instanceof String) {
                    Object file = entries.get(key);
                    if (file == null || file instanceof File) {
                        this._addArchiveEntry((String)key, (File)file);
                        continue;
                    }
                    Print.dprintln((String)"Expected 'File' value");
                    continue;
                }
                Print.dprintln((String)("Expected 'String' key [" + UIUtils.debugClassName(key) + "]"));
            }
            Descriptor d = this.getDescriptor();
            UIProject.addArchiveEntries(d, entries);
            if (d != null) {
                d.changed();
            }
        }
    }

    protected void _removeArchiveEntry(String name) {
        if (name != null) {
            String n = ModuleArchive.ArchSep(name);
            this.entriesAdded.remove(n);
            this.entriesRemoved.add(n);
        }
    }

    public void removeArchiveEntry(String name) {
        if (name != null) {
            Descriptor d = this.getDescriptor();
            this._removeArchiveEntry(name);
            UIProject.removeArchiveEntry(d, name);
            if (d != null) {
                d.changed();
            }
        }
    }

    public void removeArchiveEntries(List keys) {
        if (keys != null && keys.size() > 0) {
            Iterator k = keys.iterator();
            while (k.hasNext()) {
                Object key = k.next();
                if (key instanceof String) {
                    this._removeArchiveEntry((String)key);
                    continue;
                }
                Print.dprintln((String)("Expected 'String' key [" + UIUtils.debugClassName(key) + "]"));
            }
            Descriptor d = this.getDescriptor();
            UIProject.removeArchiveEntries(d, keys);
            if (d != null) {
                d.changed();
            }
        }
    }

    protected static String ArchSep(String n) {
        return n != null ? n.replace(File.separatorChar, '/') : null;
    }

    protected static Descriptor getAppModuleByUri(Application app, String uri) {
        if (app != null && uri != null) {
            Iterator i = app.getModules();
            while (i.hasNext()) {
                ModuleDescriptor mod = (ModuleDescriptor)i.next();
                if (!mod.getArchiveUri().equals(uri)) continue;
                return mod.getDescriptor();
            }
        }
        return null;
    }

    public AbstractArchive getEmbeddedArchive(String name) throws IOException {
        Descriptor d;
        ModuleArchive modArch;
        if (this.getDescriptor() instanceof Application && (modArch = ModuleArchive._getModuleArchive(d = ModuleArchive.getAppModuleByUri((Application)this.getDescriptor(), name))) != null) {
            return modArch;
        }
        if (this.entriesAdded.containsKey(name)) {
            File file = (File)this.entriesAdded.get(name);
            if (file != null) {
                InputJarArchive ija = new InputJarArchive();
                ija.open(file.getAbsolutePath());
                return ija;
            }
            Print.dprintln((String)("Embedded archive not available: " + name));
            return null;
        }
        if (this.getInputArchive() != null) {
            AbstractArchive embArch = this._openInputArchive().getEmbeddedArchive(name);
            if (embArch != null) {
                return embArch;
            }
            Print.dprintln((String)("Embedded archive not found in inputArchive: " + name));
            return null;
        }
        Print.dprintStackTrace((String)("No inputArchive to look for key: " + name));
        return null;
    }

    public void close() throws IOException {
        if (this.getInputArchive() != null) {
            this.getInputArchive().close();
        }
    }

    public Enumeration entries() {
        Descriptor d = this.getDescriptor();
        String infDir = d instanceof WebBundleDescriptor ? "WEB-INF" : "META-INF";
        HashSet set = new HashSet(this.getArchiveEntries().keySet());
        if (this._containsWebServiceDescriptor(d)) {
            set.add(infDir + WEB_SERVICES_XML);
        }
        return ListTools.toEnumeration(set.iterator());
    }

    public InputStream getEntry(String name) throws IOException {
        String infDir;
        Descriptor d;
        if (name == null) {
            return null;
        }
        if (this.getDescriptor() instanceof Application && (d = ModuleArchive.getAppModuleByUri((Application)this.getDescriptor(), name)) != null) {
            StringTokenizer tokens;
            ModuleArchive modArch = ModuleArchive.getModuleArchive(d);
            String archUri = modArch.getArchiveUri();
            if (archUri == null || archUri.equals("")) {
                Print.dprintStackTrace((String)"ModuleArchive ArchiveUri not defined!");
                archUri = name;
            }
            if ((tokens = new StringTokenizer(archUri, ":")).countTokens() > 1) {
                tokens.nextToken();
                archUri = tokens.nextToken();
            }
            File tempModFile = UIProject.createTempFilename(d, archUri, true);
            Print.dprintln((String)("Saving temp AppModule: " + d.getDisplayName() + " => " + tempModFile));
            modArch.saveAs(tempModFile);
            return new FileInputStream(tempModFile);
        }
        String string = infDir = this.getDescriptor() instanceof WebBundleDescriptor ? "WEB-INF" : "META-INF";
        if (name.equals(infDir + WEB_SERVICES_XML)) {
            return this._getWebServicesDDInputStream();
        }
        if (this.entriesAdded.containsKey(name)) {
            FileInputStream entryStream;
            File file = (File)this.entriesAdded.get(name);
            FileInputStream fileInputStream = entryStream = file != null ? new FileInputStream(file) : null;
            if (entryStream == null) {
                Print.dprintln((String)(this.getDisplayName() + ") Entry File is null: " + name));
            }
            return entryStream;
        }
        if (this.getInputArchive() != null) {
            InputStream entryStream = this._openInputArchive().getEntry(name);
            if (entryStream == null) {
                Print.dprintln((String)(this.getDisplayName() + ") Entry not found in InputArchive: " + name));
            }
            return entryStream;
        }
        if (name.equals(ModuleArchive.getXMLEntryName(this.getDescriptor()))) {
            return new ByteArrayInputStream(new byte[0]);
        }
        Print.dprintln((String)(this.getDisplayName() + ") Entry not found: " + name));
        return null;
    }

    public Manifest getManifest() throws IOException {
        Print.dprintStackTrace((String)"Someone is asking for my Manifest");
        return this._getManifest();
    }

    public boolean exists() {
        return !this.entriesAdded.isEmpty() || !this.getInputArchiveEntries().isEmpty();
    }

    public boolean delete() {
        this.entriesAdded.clear();
        this.entriesRemoved.clear();
        return this.getInputArchive() != null ? this._openInputArchive().delete() : true;
    }

    public OutputStream addEntry(String name) throws IOException {
        throw new UnsupportedOperationException("'addEntry(String)' Not Supported");
    }

    public void closeEntry(AbstractArchive os) throws IOException {
        throw new UnsupportedOperationException("'closeEntry(AbstractArchive)' Not Supported");
    }

    public void closeEntry(OutputStream os) throws IOException {
        throw new UnsupportedOperationException("'closeEntry(OutputStream)' Not Supported");
    }

    public boolean renameTo(String name) {
        throw new UnsupportedOperationException("'renameTo(String)' Not Supported");
    }

    public static Archivist createArchivistForDescriptor(Descriptor d) {
        if (d instanceof Application) {
            return ModuleArchive.createArchivistForType(ModuleType.EAR);
        }
        if (d instanceof WebBundleDescriptor) {
            return ModuleArchive.createArchivistForType(ModuleType.WAR);
        }
        if (d instanceof EjbBundleDescriptor) {
            return ModuleArchive.createArchivistForType(ModuleType.EJB);
        }
        if (d instanceof ConnectorDescriptor) {
            return ModuleArchive.createArchivistForType(ModuleType.RAR);
        }
        if (d instanceof ApplicationClientDescriptor) {
            return ModuleArchive.createArchivistForType(ModuleType.CAR);
        }
        Print.printStackTrace((String)("Unsupported descriptor: " + DT.className(d)));
        return null;
    }

    public static Archivist createArchivistForType(ModuleType type) {
        if (!sunOneArchivistRegistered) {
            ModuleArchive.registerSunOneArchivist();
        }
        if (ModuleType.EAR.equals(type)) {
            return new SunOneAppArchivist();
        }
        if (ModuleType.RAR.equals(type)) {
            return new SunOneConnectorArchivist();
        }
        if (ModuleType.WAR.equals(type)) {
            return new SunOneWebArchivist();
        }
        if (ModuleType.EJB.equals(type)) {
            return new SunOneEjbArchivist();
        }
        if (ModuleType.CAR.equals(type)) {
            return new SunOneAppClientArchivist();
        }
        Print.printStackTrace((String)("Invalid type: " + type));
        return null;
    }

    private static void registerSunOneArchivist() {
        if (sunOneArchivistRegistered) {
            return;
        }
        sunOneArchivistRegistered = true;
        ArchivistFactory.registerArchivist((Archivist)new ApplicationArchivist());
        ArchivistFactory.registerArchivist((Archivist)new SunOneWebArchivist());
        ArchivistFactory.registerArchivist((Archivist)new SunOneAppClientArchivist());
        ArchivistFactory.registerArchivist((Archivist)new SunOneEjbArchivist());
        ArchivistFactory.registerArchivist((Archivist)new SunOneConnectorArchivist());
    }

    public Archivist getArchivist() {
        Archivist arch;
        Object a = this.descriptor.getExtraAttribute(ATTR_ARCHIVIST);
        Archivist archivist = arch = a instanceof Archivist ? (Archivist)a : null;
        if (arch == null) {
            Print.printStackTrace((String)"Archivist is null!");
        } else if (arch instanceof ConnectorArchivist) {
            arch.setHandleRuntimeInfo(false);
        } else if (this.getSaveAsPureJ2EEModule()) {
            arch.setHandleRuntimeInfo(false);
        } else {
            arch.setHandleRuntimeInfo(true);
        }
        return arch;
    }

    public void setArchivist(Archivist arch) {
        if (arch != null) {
            arch.setDescriptor(this.descriptor);
            this.descriptor.addExtraAttribute(ATTR_ARCHIVIST, (Object)arch);
        } else {
            this.descriptor.removeExtraAttribute(ATTR_ARCHIVIST);
        }
    }

    public BundleDescriptor addArchive(File archFile) throws IOException {
        Descriptor ad = this.getDescriptor();
        if (ad instanceof Application) {
            Application app = (Application)ad;
            if (DescriptorTools.isDirty((Descriptor)app)) {
                this.save();
            }
            ApplicationArchivist appArch = (ApplicationArchivist)this.getArchivist();
            try {
                this.close();
                String archPath = archFile.getAbsolutePath();
                ModuleDescriptor md = appArch.addArchive(archPath, null, null);
                UIProject.resetProject((Descriptor)app);
                this.clearInputArchiveEntries();
                BundleDescriptor bd = md.getDescriptor();
                if (bd instanceof WebBundleDescriptor) {
                    WebBundleDescriptor wbd = (WebBundleDescriptor)bd;
                    SunWebApp swa = (SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)wbd);
                    wbd.setContextRoot(swa.getContextRoot());
                    swa.setContextRoot(null);
                }
                return bd;
            }
            catch (SAXParseException spe) {
                IOException ioe = new IOException(spe.toString());
                ioe.initCause(spe);
                throw ioe;
            }
        }
        Print.dprintStackTrace((String)("Not an Application: " + UIUtils.debugClassName(ad)));
        return null;
    }

    public Descriptor addToApplication(Application app) throws IOException {
        if (this.isValidModule()) {
            File tempModuleFile = this.saveTemp();
            ModuleArchive appModArch = ModuleArchive.getModuleArchive((Descriptor)app);
            BundleDescriptor bd = appModArch.addArchive(tempModuleFile);
            this.descriptor.removeExtraAttribute(ATTR_MODULE_ARCHIVE);
            bd.addExtraAttribute(ATTR_MODULE_ARCHIVE, (Object)this);
            bd.addExtraAttribute(ATTR_ARCHIVIST, (Object)this.getArchivist());
            bd.getModuleDescriptor().setManifest(this._getManifest());
            bd.setClassLoader(this.getClassLoader());
            this.descriptor = bd;
            this.setArchiveUri(bd.getModuleDescriptor().getArchiveUri());
            this.addManifestClasspaths(appModArch._getManifest());
            this.close();
            this.clearInputArchiveEntries();
            return this.descriptor;
        }
        return null;
    }

    public void removeFromApplication() throws IOException {
        if (this.isStandAlone()) {
            Print.dprintStackTrace((String)("StandAlone Bundle: " + this.getDisplayName()));
        } else if (!(this.getDescriptor() instanceof BundleDescriptor)) {
            Print.dprintStackTrace((String)("Not a BundleDescriptor: " + DT.className(this.getDescriptor())));
        } else if (((BundleDescriptor)this.getDescriptor()).getApplication() == null) {
            Print.dprintStackTrace((String)("Not part of an Application: " + this.getDisplayName()));
        } else {
            BundleDescriptor bd = (BundleDescriptor)this.getDescriptor();
            Application app = bd.getApplication();
            app.removeModule(bd.getModuleDescriptor());
            ModuleArchive.getModuleArchive((Descriptor)app).removeArchiveEntry(this.getArchiveUri());
        }
    }

    public void save() throws IOException {
        this.saveAs(this.getArchiveUri());
    }

    public void saveAs(File archFile) throws IOException {
        this.saveAs(archFile != null ? archFile.getAbsolutePath() : null);
    }

    public void saveAs(String archUri) throws IOException {
        this.saveAs(archUri, false);
    }

    public void saveAsPure(File archFile) throws IOException {
        this.saveAsPure(archFile != null ? archFile.getAbsolutePath() : null);
    }

    public void saveAsPure(String archUri) throws IOException {
        this.saveAs(archUri, true);
    }

    public File saveTemp() throws IOException {
        File tempModFile;
        Descriptor d = this.getDescriptor();
        String archUri = this.getArchiveUri();
        String uriName = null;
        if (!archUri.equals("")) {
            uriName = new File(archUri).getName();
        } else if (this.isStandAlone()) {
            uriName = DescriptorTools.createUniqueModuleName(null, d);
        } else if (this.getDescriptor() instanceof BundleDescriptor) {
            Application app = ((BundleDescriptor)d).getApplication();
            uriName = DescriptorTools.createUniqueModuleName(app, d);
        } else {
            uriName = DescriptorTools.createUniqueModuleName(null, d);
        }
        String ext = DescriptorTools.getModuleExtension(d);
        if (!ext.equals("") && !uriName.endsWith(ext)) {
            uriName = uriName + ext;
        }
        if ((tempModFile = UIProject.createTempFilename(d, uriName, true)).isDirectory()) {
            Print.printStackTrace((String)"Temp file is a directory!");
        }
        Print.dprintln((String)("Saving Temp Module: " + d.getDisplayName() + " => " + tempModFile));
        this.saveAs(tempModFile);
        return tempModFile;
    }

    public void saveAs(String archUri, boolean pure) throws IOException {
        if (this.isValidModule()) {
            if (archUri != null && !archUri.equals("")) {
                Descriptor d;
                if (!this.isStandAlone() && (d = this.getDescriptor()) instanceof WebBundleDescriptor) {
                    WebBundleDescriptor wbd = (WebBundleDescriptor)d;
                    String cr = wbd.getContextRoot();
                    SunWebApp swa = (SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)wbd);
                    if (cr != null && swa != null) {
                        swa.setContextRoot(cr);
                    }
                }
                ModuleArchive.preSaveValidation(this.getDescriptor());
                Archivist arch = this.getArchivist();
                try {
                    arch.setHandleRuntimeInfo(!pure);
                    arch.write((AbstractArchive)this, archUri);
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (NullPointerException npe) {
                    Print.dprintStackTrace((String)"Error while saving", (Throwable)npe);
                    FileNotFoundException ioe = new FileNotFoundException("Previous module is no longer accessible");
                    ioe.initCause(npe);
                    throw ioe;
                }
                finally {
                    arch.setHandleRuntimeInfo(true);
                }
                if (archUri.equals(this.getArchiveUri())) {
                    this.close();
                }
            } else {
                Print.dprintln((String)"URI not specified.  Not saved.");
            }
        }
    }

    public void extractEntryToFile(String name, File out) throws IOException {
        if (this.isValidModule()) {
            this.getArchivist().extractEntry(name, out);
        }
    }

    public void extractEntryToFile(BundleDescriptor bd, File out) throws IOException {
        if (!(this.descriptor instanceof Application)) {
            throw new IOException("This descriptor is not an Application");
        }
        if (bd.getApplication() != this.descriptor) {
            throw new IOException("Specified BundleDescriptor is not part of this Application");
        }
        ModuleArchive modArch = ModuleArchive.getModuleArchive(this.descriptor);
        String bdUri = ModuleArchive.getArchiveUri((Descriptor)bd);
        modArch.extractEntryToFile(bdUri, out);
    }

    protected static String GetManifestClasspathsString(Manifest m) {
        return m != null ? (String)m.getMainAttributes().get(Attributes.Name.CLASS_PATH) : null;
    }

    protected static String GetManifestClasspathsString(List cpList) {
        StringBuffer sb = new StringBuffer();
        Iterator i = cpList.iterator();
        while (i.hasNext()) {
            sb.append(i.next().toString()).append(" ");
        }
        String cpath = sb.toString().trim();
        return cpath;
    }

    protected static List GetManifestClasspaths(Manifest m) {
        return ListTools.parseList(ModuleArchive.GetManifestClasspathsString(m), " ");
    }

    protected static void SetManifestClasspaths(Manifest man, String cpaths) {
        if (man != null) {
            man.getMainAttributes().put(Attributes.Name.CLASS_PATH, cpaths);
        }
    }

    protected static void SetManifestClasspaths(Manifest man, List cpList) {
        ModuleArchive.SetManifestClasspaths(man, ModuleArchive.GetManifestClasspathsString(cpList));
    }

    public static void PrintManifestClasspaths(String msg, Descriptor d) {
        ModuleArchive modArch = ModuleArchive.getModuleArchive(d);
        ModuleArchive.PrintManifestClasspaths(msg, modArch._getManifest());
    }

    protected static void PrintManifestClasspaths(String msg, Manifest man) {
        if (!UIConfig.debugMode()) {
            return;
        }
        if (man == null) {
            Print.dprintln((String)("Printing Manifest Classpaths: " + msg + " [null]"));
            return;
        }
        List cpaths = ModuleArchive.GetManifestClasspaths(man);
        Print.dprintln((String)("Printing Manifest Classpaths: " + msg + " [" + cpaths.size() + "]"));
        Iterator i = cpaths.iterator();
        while (i.hasNext()) {
            Print.dprintln((String)("    Classpath ==> " + i.next()));
        }
    }

    public List getLibraryJarEntries() {
        List cpList = this.getManifestClasspaths();
        return cpList;
    }

    public void addLibraryJar(File libJar) {
        if (libJar.exists()) {
            ClassLoader cl;
            String libJarEntry = "library/" + libJar.getName();
            this.addArchiveEntry(libJarEntry, libJar);
            this.addManifestClasspath(libJarEntry);
            if (this.descriptor instanceof Application) {
                HashSet bdset = new HashSet();
                bdset.addAll(((Application)this.descriptor).getEjbBundleDescriptors());
                bdset.addAll(((Application)this.descriptor).getApplicationClientDescriptors());
                Iterator i = bdset.iterator();
                while (i.hasNext()) {
                    Descriptor bd = (Descriptor)i.next();
                    ModuleArchive.getModuleArchive(bd).addManifestClasspath(libJarEntry);
                }
            }
            if ((cl = this.getClassLoader()) instanceof J2EEClassLoader) {
                try {
                    ((J2EEClassLoader)cl).setLocation(libJar);
                }
                catch (IOException ioe) {
                    Print.printStackTrace((String)"Adding library to J2EEClassLoader", (Throwable)ioe);
                }
            } else {
                Print.dprintln((String)("ClassLoader is not J2EEClassLoader: " + DT.className(cl)));
            }
        }
    }

    public void removeLibraryJarEntry(String libJarEntry) {
        this.removeArchiveEntry(libJarEntry);
        this.removeManifestClasspath(libJarEntry);
        if (this.descriptor instanceof Application) {
            HashSet bdset = new HashSet();
            bdset.addAll(((Application)this.descriptor).getEjbBundleDescriptors());
            bdset.addAll(((Application)this.descriptor).getApplicationClientDescriptors());
            Iterator i = bdset.iterator();
            while (i.hasNext()) {
                Descriptor bd = (Descriptor)i.next();
                ModuleArchive.getModuleArchive(bd).removeManifestClasspath(libJarEntry);
            }
        }
    }

    public void addManifestClasspath(String libJar) {
        List cpList = this.getManifestClasspaths();
        if (!cpList.contains(libJar)) {
            cpList.add(0, libJar);
            this.setManifestClasspaths(cpList);
        }
    }

    public void addManifestClasspaths(List manPaths) {
        List cpList = this.getManifestClasspaths();
        boolean changed = false;
        Iterator i = manPaths.iterator();
        while (i.hasNext()) {
            String cp = (String)i.next();
            if (cpList.contains(cp)) continue;
            cpList.add(cp);
            changed = true;
        }
        if (changed) {
            this.setManifestClasspaths(cpList);
        }
    }

    public void addManifestClasspaths(Manifest man) {
        this.addManifestClasspaths(ModuleArchive.GetManifestClasspaths(man));
    }

    public void removeManifestClasspath(String libJar) {
        List cpList = this.getManifestClasspaths();
        if (cpList.contains(libJar)) {
            cpList.remove(libJar);
            this.setManifestClasspaths(cpList);
        }
    }

    public boolean hasManifestClasspaths() {
        String cpaths = ModuleArchive.GetManifestClasspathsString(this._getManifest());
        return cpaths != null && !cpaths.equals("");
    }

    public List getManifestClasspaths() {
        return ModuleArchive.GetManifestClasspaths(this._getManifest());
    }

    public void setManifestClasspaths(List cpList) {
        Manifest m = this._getManifest();
        ModuleArchive.SetManifestClasspaths(m, cpList);
        Archivist arch = this.getArchivist();
        Manifest archManifest = arch.getManifest();
        if (archManifest != m) {
            arch.setManifest(m);
        }
        if (this.isBundleDescriptor()) {
            ((BundleDescriptor)this.getDescriptor()).getModuleDescriptor().setManifest(m);
        }
    }

    protected Manifest _getManifest() {
        return this.manifest;
    }

    private static boolean preSaveValidation(Descriptor d) {
        Application app = null;
        Vector<Descriptor> ejbBundles = null;
        Vector<Descriptor> warBundles = null;
        if (d instanceof Application) {
            app = (Application)d;
            ejbBundles = new Vector(app.getEjbBundleDescriptors());
            warBundles = new Vector(app.getWebBundleDescriptors());
        } else if (d instanceof EjbBundleDescriptor) {
            ejbBundles = new Vector<Descriptor>();
            ejbBundles.add(d);
        } else if (d instanceof WebBundleDescriptor) {
            warBundles = new Vector<Descriptor>();
            warBundles.add(d);
        }
        Vector<Descriptor> allBundles = new Vector<Descriptor>();
        if (ejbBundles != null) {
            allBundles.addAll(ejbBundles);
        }
        if (warBundles != null) {
            allBundles.addAll(warBundles);
        }
        Iterator i = allBundles.iterator();
        while (i.hasNext()) {
            BundleDescriptor bd = (BundleDescriptor)i.next();
            Vector msgDest = new Vector(bd.getMessageDestinations());
            Iterator m = msgDest.iterator();
            while (m.hasNext()) {
                MessageDestinationDescriptor mdd = (MessageDestinationDescriptor)m.next();
                String n = mdd.getName();
                if (n != null && !n.equals("")) continue;
                bd.removeMessageDestination(mdd);
            }
        }
        return true;
    }

    private static class EmptyArchive
    extends AbstractArchive {
        private EmptyArchive() {
        }

        public String getArchiveUri() {
            return null;
        }

        public long getArchiveSize() throws NullPointerException, SecurityException {
            return -1L;
        }

        public AbstractArchive getEmbeddedArchive(String name) throws IOException {
            return null;
        }

        public void closeEntry(AbstractArchive os) throws IOException {
        }

        public void close() throws IOException {
        }

        public InputStream getEntry(String name) throws IOException {
            return null;
        }

        public void closeEntry(OutputStream os) throws IOException {
        }

        public Enumeration entries() {
            return new Vector().elements();
        }

        public Enumeration entries(Enumeration e) {
            return new Vector().elements();
        }

        public Manifest getManifest() throws IOException {
            return new Manifest();
        }

        public boolean exists() {
            return false;
        }

        public boolean delete() {
            return false;
        }

        public boolean renameTo(String name) {
            return false;
        }

        public boolean supportsElementsOverwriting() {
            return false;
        }

        public void closeEntry() throws IOException {
        }

        public URI getURI() {
            return null;
        }

        public OutputStream putNextEntry(String name) throws IOException {
            return null;
        }
    }

    protected class ModuleArchiveManifest
    extends Manifest {
        private HashMap entryAttrMap = null;

        public ModuleArchiveManifest(Manifest manifest) {
            this._setDefaultMainAttributes(manifest);
        }

        private void _setDefaultMainAttributes(Manifest man) {
            if (man != null) {
                this.getMainAttributes().putAll((Map<?, ?>)man.getMainAttributes());
                String cpath = (String)this.getMainAttributes().get(Attributes.Name.CLASS_PATH);
            } else {
                Attributes mainAttr = super.getMainAttributes();
                mainAttr.put(Attributes.Name.MANIFEST_VERSION, "1.1");
                mainAttr.put(Attributes.Name.CLASS_PATH, "");
            }
        }

        public Attributes getMainAttributes() {
            return super.getMainAttributes();
        }

        public Map getEntries() {
            HashMap<String, Attributes> manMap = new HashMap<String, Attributes>();
            Map archEntries = ModuleArchive.this.getArchiveEntries();
            Iterator i = archEntries.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Attributes attr = this.entryAttrMap != null ? (Attributes)this.entryAttrMap.get(key) : null;
                manMap.put(key, attr != null ? attr : new Attributes());
            }
            this.entryAttrMap = manMap;
            return this.entryAttrMap;
        }

        public void read(InputStream inp) throws IOException {
            throw new UnsupportedOperationException("'read(InputStream)' Not Supported");
        }

        public void write(OutputStream out) throws IOException {
            Manifest manWriter = new Manifest(this);
            manWriter.write(out);
        }
    }

    protected class ModuleArchiveClassLoader
    extends DTClassLoader {
        public ModuleArchiveClassLoader() {
            Descriptor d = ModuleArchive.this.getDescriptor();
            File archFile = ModuleArchive.this.getArchiveFile();
            if (archFile != null) {
                super.addArchiveJar(archFile);
            } else if (d instanceof BundleDescriptor) {
                Application app = ((BundleDescriptor)d).getApplication();
                if (app != null) {
                    ModuleArchive appModArch = ModuleArchive.getModuleArchive((Descriptor)app);
                    this.setParent(appModArch.getClassLoader(), false);
                } else {
                    Print.dprintln((String)("No valid Archive File: " + ModuleArchive.this.getArchiveUri()));
                }
            }
        }

        protected Class findClass(String className) throws ClassNotFoundException {
            String classEntry = className.replace('.', '/') + ".class";
            Map entryMap = ModuleArchive.this.getArchiveEntries();
            Iterator i = entryMap.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                File val = (File)entryMap.get(key);
                if (val == null || !val.exists()) continue;
                if (key.endsWith(classEntry)) {
                    try {
                        byte[] classData = FileTools.readFile(val);
                        return super.defineClass(className, classData, 0, classData.length);
                    }
                    catch (IOException ioe) {
                        throw new ClassNotFoundException(ioe.toString(), ioe);
                    }
                }
                if (!UIProject.isJar(val.getAbsolutePath())) continue;
                try {
                    JarFile zip = new JarFile(val);
                    ZipEntry entry = zip.getEntry(classEntry);
                    if (entry == null) {
                        entry = zip.getEntry("WEB-INF/classes/" + classEntry);
                    }
                    if (entry == null) continue;
                    InputStream in = zip.getInputStream(entry);
                    byte[] classData = FileTools.readInputStream(in);
                    return super.defineClass(className, classData, 0, classData.length);
                }
                catch (IOException ioe) {
                    Print.dprintln((String)("Unable to read Jar entry: " + val + " -> " + className));
                }
            }
            return super.findClass(className);
        }
    }
}

