/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.table.TableCellEditor;

public class EnvironmentInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnvironmentInspector.class);
    private static final String TABLE_TOOLTIP = localStrings.getLocalString("ui.environmentinspector.table.tooltip", "Table of environment entries");
    private static final String TABLE_TITLE = localStrings.getLocalString("ui.environmentinspector.table.title", "Environment entries referenced in code");
    private static final String TABLE_CODED_ENTRY = localStrings.getLocalString("ui.environmentinspector.table.coded_entry", "Coded Entry");
    private static final String TABLE_TYPE = localStrings.getLocalString("ui.environmentinspector.table.type", "Type");
    private static final String TABLE_VALUE = localStrings.getLocalString("ui.environmentinspector.table.value", "Value");
    private static final String MISSING_CODE_ENTRY = localStrings.getLocalString("at.environmentinspector.missing_code_entry", "All references must specify a 'Coded Entry'.");
    private static final String TABNAME = localStrings.getLocalString("ui.environmentinspector.tabname", "Env. Entries");
    private static String wizardHelpID = "Env";
    private static String deployHelpID = "Env";
    private WritableJndiNameEnvironment descriptor;
    private static final String JAVA_LANG = "java.lang.";
    private UITitledTable environmentEntriesPanel = null;
    private EnvironmentEntriesTable environmentEntriesTable = null;

    private static String ILLEGAL_VALUE(String v0) {
        return localStrings.getLocalString("ui.environmentinspector.table.illegal_type", "{0} is not a legal value for this environment entry type", new Object[]{v0});
    }

    public static InspectorPane newInspectorPane(String mode) {
        return new EnvironmentInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WritableJndiNameEnvironment.class;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WritableJndiNameEnvironment ? (WritableJndiNameEnvironment)desc : null;
            this.environmentEntriesTable.clearTableData();
        }
    }

    private EnvironmentInspector(String mode) {
        this.initializeLayout();
        this.setInspectorMode(mode);
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.environmentEntriesPanel = new UITitledTable(TABLE_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.environmentEntriesPanel, c);
        this.environmentEntriesTable = new EnvironmentEntriesTable(new EnvironmentEntriesTableModel());
        this.environmentEntriesPanel.getGBConstraints().weighty = 0.85;
        this.environmentEntriesPanel.setTableView(this.environmentEntriesTable);
        UIButton addPB = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EnvironmentInspector.this.addEnvironmentPropertyAction();
            }
        });
        this.environmentEntriesPanel.addControlButton(addPB);
        UIButton delPB = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EnvironmentInspector.this.removeEnvironmentPropertyAction();
            }
        }, true);
        this.environmentEntriesPanel.addSelectionEnabledButton(delPB);
    }

    public void refresh() {
        if (this.descriptor != null) {
            this.environmentEntriesTable.updateTableData(this.descriptor.getEnvironmentProperties());
        }
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.environmentEntriesPanel.setReadOnly(state);
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.environmentEntriesTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_CODE_ENTRY);
            }
            return false;
        }
        return true;
    }

    private void addEnvironmentPropertyAction() {
        if (this.environmentEntriesTable.getRowWithValue(0, "") == null) {
            this.descriptor.addEnvironmentProperty(new EnvironmentProperty("", "", "", String.class.getName()));
        }
        this.environmentEntriesTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void removeEnvironmentPropertyAction() {
        Object[] list = this.environmentEntriesTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                EnvironmentProperty ref = (EnvironmentProperty)list[i];
                this.descriptor.removeEnvironmentProperty(ref);
            }
        }
        this.invokeRefresh();
    }

    private class EnvironmentEntriesTableModel
    extends InspectorTableModel {
        public EnvironmentEntriesTableModel() {
            super(new String[]{TABLE_CODED_ENTRY, TABLE_TYPE, TABLE_VALUE, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public EnvironmentProperty getRow(int index) {
            return (EnvironmentProperty)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getDisplayName();
                    break;
                }
                case 1: {
                    value = ref.getType().startsWith(EnvironmentInspector.JAVA_LANG) ? ref.getType().substring(EnvironmentInspector.JAVA_LANG.length()) : ref.getType();
                    break;
                }
                case 2: {
                    value = ref.getValue();
                    break;
                }
                case 3: {
                    value = ref.getDescription();
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            if (ref == null) {
                return;
            }
            String valStr = value.toString();
            switch (col) {
                case 0: {
                    ref.setDisplayName(valStr);
                    break;
                }
                case 1: {
                    if (!valStr.startsWith(EnvironmentInspector.JAVA_LANG)) {
                        valStr = EnvironmentInspector.JAVA_LANG + valStr;
                    }
                    if (valStr.equals(ref.getType())) break;
                    ref.setType(valStr);
                    this.setObjectValue(obj, 2, "");
                    break;
                }
                case 2: {
                    try {
                        ref.setValue(super.validatePrimitiveValue(ref.getType(), valStr));
                    }
                    catch (IllegalArgumentException iae) {
                        UIOptionPane.showErrorDialog(null, EnvironmentInspector.ILLEGAL_VALUE(valStr));
                    }
                    break;
                }
                case 3: {
                    ref.setDescription(valStr);
                }
            }
            ((Descriptor)EnvironmentInspector.this.descriptor).changed();
        }
    }

    private class EnvironmentEntriesTable
    extends InspectorTable {
        public EnvironmentEntriesTable(EnvironmentEntriesTableModel model) {
            super(model);
            this.setToolTipText(TABLE_TOOLTIP);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 1: {
                    TableCellEditor e = super.getPrimitiveTypesEditor();
                    if (e instanceof InspectorTable.TableComboBoxEditor) {
                        InspectorTable.TableComboBoxEditor tcbe = (InspectorTable.TableComboBoxEditor)e;
                        tcbe.getComboBox().setMaximumRowCount(tcbe.getComboBox().getItemCount());
                    }
                    rtn = e;
                    break;
                }
                case 2: {
                    EnvironmentProperty ref = (EnvironmentProperty)this.getRowObject(row);
                    rtn = super.getPrimitiveValueEditor(ref.getType());
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }
}

