/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.node.ApplicationNode;
import com.sun.enterprise.deployment.node.J2EEDocumentBuilder;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.node.appclient.AppClientNode;
import com.sun.enterprise.deployment.node.connector.ConnectorNode;
import com.sun.enterprise.deployment.node.ejb.EjbBundleNode;
import com.sun.enterprise.deployment.node.web.WebBundleNode;
import com.sun.enterprise.tools.common.dd.SunBaseBean;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledHTMLText;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import com.sun.enterprise.util.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.text.html.HTMLDocument;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DescriptorViewer
extends UIDialog
implements DescriptorInspector,
NotificationListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DescriptorViewer.class);
    private static final String SPLIT_NAME = localStrings.getLocalString("ui.descriptorviewer.split_name", "Split Pane");
    private static final String SPLIT_DESC = localStrings.getLocalString("ui.descriptorviewer.split_desc", "This pane splits this window");
    private static final String TITLE = localStrings.getLocalString("ui.descriptorviewer.title", "J2EE Descriptor Viewer");
    private static final String S1_TITLE = localStrings.getLocalString("ui.descriptorviewer.s1_title", "Application Server Descriptor Viewer");
    private static final String FIND_BTN = localStrings.getLocalString("ui.descriptorviewer.find", "Find");
    private static final char mnemonicFIND_BTN = localStrings.getLocalString("ui.descriptorviewer.find_mnemonic", "F").charAt(0);
    private static final String IGNORE_CASE = localStrings.getLocalString("ui.descriptorviewer.ignore_case", "Ignore Case");
    private static final String SAVE_DD = localStrings.getLocalString("ui.descriptorviewer.save_descriptor", "Save Deployment Descriptor");
    private static final String SAVE_XML = localStrings.getLocalString("ui.descriptorviewer.save_xml", "Save XML");
    public static final String REVIEW_SETTINGS_TITLE = localStrings.getLocalString("ui.descriptorviewer.review_settings.title", "Review Settings");
    public static final String REVIEW_SETTINGS_HELP = localStrings.getLocalString("ui.descriptorviewer.review_settings.help", "The following deployment descriptor will be generated for your module.\nTo change any of the settings, click 'Back'.  If you are satisfied with the settings, click 'Finish'.");
    private Descriptor descriptor = null;
    private boolean displayRuntime = false;
    private static String helpSetMapID_standard = "DescriptorViewer";
    private static String helpSetMapID_runtime = "AppServerViewer";
    private XMLTextArea descriptorText = null;
    private JButton saveAsPB = null;
    private UIHelpButton helpPB = null;
    private UITitledComboBox findSelection = null;
    private UICheckBox ignoreCase = null;
    private String xmlText = null;
    private int ignore_notification = 0;
    private int notification_recurse = 0;
    private UIFileChooser jfc = null;
    private static final String COLOR_ON = UITitledHTMLText.FONT(Color.blue.darker());
    private static final String COLOR_OFF = UITitledHTMLText.endTag(COLOR_ON);
    private static final String BOLD_ON = "<B>";
    private static final String BOLD_OFF = UITitledHTMLText.endTag("<B>");
    private static final String HILITE_ON = "<B>" + COLOR_ON;
    private static final String HILITE_OFF = COLOR_OFF + BOLD_OFF;

    private static String TITLE_(Descriptor d) {
        String t = "";
        if (d instanceof Application) {
            t = d.getDisplayName() + " (application.xml)";
        }
        if (d instanceof ApplicationClientDescriptor) {
            t = d.getDisplayName() + " (application-client.xml)";
        }
        if (d instanceof EjbBundleDescriptor) {
            t = d.getDisplayName() + " (ejb-jar.xml)";
        }
        if (d instanceof WebBundleDescriptor) {
            t = d.getDisplayName() + " (web.xml)";
        }
        if (d instanceof ConnectorDescriptor) {
            t = d.getDisplayName() + " (ra.xml)";
        }
        return TITLE + "  " + t;
    }

    private static String S1_TITLE_(Descriptor d) {
        String t = "";
        if (d instanceof Application) {
            t = d.getDisplayName() + " (sun-application.xml)";
        }
        if (d instanceof ApplicationClientDescriptor) {
            t = d.getDisplayName() + " (sun-application-client.xml)";
        }
        if (d instanceof EjbBundleDescriptor) {
            t = d.getDisplayName() + " (sun-ejb-jar.xml)";
        }
        if (d instanceof WebBundleDescriptor) {
            t = d.getDisplayName() + " (sun-web.xml)";
        }
        if (d instanceof ConnectorDescriptor) {
            t = d.getDisplayName() + " (sun-connector.xml)";
        }
        return S1_TITLE + "  " + t;
    }

    public Class getDescriptorClass() {
        return Descriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor d) {
        if (this.descriptor != null) {
            this.descriptor.removeNotificationListener((NotificationListener)this);
        }
        this.descriptor = d;
        if (this.descriptor != null) {
            this.descriptor.addNotificationListener((NotificationListener)this);
        }
        this.refresh();
    }

    public void setDisplayRuntime(boolean runtime) {
        this.displayRuntime = runtime;
        this.setTitle(this.displayRuntime ? S1_TITLE : TITLE);
        this.helpPB.setHelpID(runtime ? helpSetMapID_runtime : helpSetMapID_standard);
    }

    private String getRuntimeText(Descriptor d) {
        SunBaseBean sbb = null;
        if (d instanceof Application) {
            Application app = (Application)d;
            sbb = SunOneUtils.getSunDescriptor((Descriptor)app);
        } else if (d instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor acd = (ApplicationClientDescriptor)d;
            sbb = SunOneUtils.getSunDescriptor((Descriptor)acd);
        } else if (d instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ebd = (EjbBundleDescriptor)d;
            sbb = SunOneUtils.getSunDescriptor((Descriptor)ebd);
        } else if (d instanceof WebBundleDescriptor) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)d;
            sbb = SunOneUtils.getSunDescriptor((Descriptor)wbd);
        } else if (d instanceof ConnectorDescriptor) {
            ConnectorDescriptor rar = (ConnectorDescriptor)d;
            sbb = SunOneUtils.getSunDescriptor((Descriptor)rar);
        }
        if (sbb == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter();
            sbb.write((Writer)writer, "UTF-8");
            return writer.toString();
        }
        catch (Exception ex) {
            Print.println((String)localStrings.getLocalString("ui.descriptorviewer.error_forming_xml", "Warning: error forming XML"));
            return null;
        }
    }

    public DescriptorViewer(Frame frame) {
        super(frame, false);
        this.setTitle(TITLE);
        this.setSize(new Dimension(780, 600));
        this.centerOnScreen();
        UIPanel contentPane = new UIPanel(localStrings.getLocalString("ui.descriptorviewer.panel_name", "Split Pane"), localStrings.getLocalString("ui.descriptorviewer.panel_desc", "This is the panel for viewer"));
        contentPane.setLayout(new GridBagLayout());
        super.setContentPane(contentPane);
        GridBagConstraints c = new GridBagConstraints();
        UITitledBox findBox = new UITitledBox(null, false);
        GridBagConstraints fc = new GridBagConstraints();
        this.findSelection = new UITitledComboBox(null, false);
        this.findSelection.ignoreFocusLostActionEvents(true);
        this.findSelection.setReverseOrdering(true, 5);
        this.findSelection.setEditable(true);
        this.findSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String text = DescriptorViewer.this.findSelection.getText();
                if (!text.equals("")) {
                    DescriptorViewer.this.findSelection.removeItem(text);
                    DescriptorViewer.this.findSelection.addItem(text);
                    DescriptorViewer.this.findAction(text);
                }
            }
        });
        fc.gridx = 0;
        fc.gridy = 0;
        fc.weightx = 0.5;
        fc.weighty = 0.0;
        fc.gridheight = 1;
        fc.gridwidth = 1;
        fc.insets = new Insets(0, 0, 0, 0);
        fc.fill = 2;
        findBox.add((Component)this.findSelection, fc);
        UIButton findBtn = new UIButton(FIND_BTN, mnemonicFIND_BTN);
        findBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String text = DescriptorViewer.this.findSelection.getText();
                if (!text.equals("")) {
                    DescriptorViewer.this.findSelection.removeItem(text);
                    DescriptorViewer.this.findSelection.addItem(text);
                    DescriptorViewer.this.findAction(text);
                }
            }
        });
        fc.gridx = 1;
        fc.gridy = 0;
        fc.weightx = 0.0;
        fc.weighty = 0.0;
        fc.gridheight = 1;
        fc.gridwidth = 1;
        fc.insets = new Insets(0, 5, 0, 0);
        fc.fill = 0;
        findBox.add((Component)findBtn, fc);
        this.ignoreCase = new UICheckBox(IGNORE_CASE);
        this.ignoreCase.setSelected(true);
        fc.gridx = 2;
        fc.gridy = 0;
        fc.weightx = 0.0;
        fc.weighty = 0.0;
        fc.gridheight = 1;
        fc.gridwidth = 1;
        fc.insets = new Insets(0, 5, 0, 0);
        fc.fill = 0;
        findBox.add((Component)this.ignoreCase, fc);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(5, 5, 0, 5);
        c.fill = 2;
        contentPane.add((Component)findBox, c);
        UIControlButtonBox xmlPanel = new UIControlButtonBox(null, false);
        xmlPanel.setControlButtonLocation(101);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        contentPane.add((Component)xmlPanel, c);
        this.descriptorText = new XMLTextArea();
        xmlPanel.setView(this.descriptorText);
        this.saveAsPB = UIButton.createSaveAsButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DescriptorViewer.this.saveAsAction();
            }
        }, true);
        xmlPanel.addControlButton(this.saveAsPB);
        UIButton closePB = UIButton.createCloseButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DescriptorViewer.this.setDescriptor(null);
                DescriptorViewer.this.hide();
            }
        });
        xmlPanel.addControlButton(closePB);
        this.helpPB = new UIHelpButton(helpSetMapID_standard);
        xmlPanel.addControlButton(this.helpPB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void refresh() {
        boolean dirty = DescriptorTools.isDirty(this.descriptor);
        DT.getModuleManager().setNotificationEnabled(false);
        ++this.ignore_notification;
        try {
            if (this.displayRuntime) {
                this.xmlText = this.descriptorText.updateXMLText(this.getRuntimeText(this.descriptor));
                this.setTitle(DescriptorViewer.S1_TITLE_(this.descriptor));
            } else {
                this.xmlText = this.descriptorText.updateXMLText(this.descriptor);
                this.setTitle(DescriptorViewer.TITLE_(this.descriptor));
            }
            this.saveAsPB.setEnabled(this.xmlText != null);
            Object var3_2 = null;
            --this.ignore_notification;
            DT.getModuleManager().setNotificationEnabled(true);
            if (dirty) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            --this.ignore_notification;
            DT.getModuleManager().setNotificationEnabled(true);
            if (dirty) throw throwable;
            DescriptorTools.clearDirty(this.descriptor);
            throw throwable;
        }
        DescriptorTools.clearDirty(this.descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notification(NotificationEvent ne) {
        if (this.ignore_notification > 0) {
            return;
        }
        if (this.notification_recurse > 0) {
            Print.dprintStackTrace((String)"Recursive notification...");
            return;
        }
        try {
            ++this.notification_recurse;
            this.refresh();
        }
        finally {
            --this.notification_recurse;
        }
    }

    private void findAction(String text) {
        int p1;
        int start;
        if (text.equals("*all*")) {
            Print.dprintln((String)"Selecting ALL");
            this.descriptorText.setSelectedRange(0, -1);
            return;
        }
        String findText = text;
        String fullText = this.descriptorText.getXMLText();
        if (this.ignoreCase.isSelected()) {
            findText = findText.toLowerCase();
            fullText = fullText.toLowerCase();
        }
        if ((start = this.descriptorText.getSelectionStart()) >= fullText.length()) {
            start = 0;
        }
        if ((p1 = fullText.indexOf(findText, start)) < 0 && start > 0) {
            p1 = fullText.indexOf(findText);
        }
        if (p1 >= 0) {
            int p2 = p1 + findText.length();
            this.descriptorText.setSelectedRange(p1 + 1, p2 + 1);
        } else {
            this.descriptorText.clearSelectedText();
        }
    }

    private void saveAsAction() {
        int returnValue;
        if (this.xmlText == null) {
            return;
        }
        if (this.jfc == null) {
            this.jfc = UIFileChooser.getFileChooser(null, "XMLFiles");
        }
        if ((returnValue = this.jfc.showDialog(this, SAVE_DD, SAVE_XML)) != 0) {
            return;
        }
        File newFile = this.jfc.getSelectedFile();
        if (!FileTools.checkFileOverwrite((Component)this, newFile)) {
            return;
        }
        try {
            if (newFile.exists()) {
                newFile.delete();
            }
            FileOutputStream fos = new FileOutputStream(newFile);
            byte[] textBytes = this.xmlText.getBytes();
            fos.write(textBytes, 0, textBytes.length);
            fos.close();
        }
        catch (IOException ioe) {
            Print.printStackTrace((String)"Unable to save XML to file", (Throwable)ioe);
        }
    }

    public static class XMLTextArea
    extends UITitledHTMLText
    implements UpdateXMLTextArea {
        private String xmlTextString = "";

        public XMLTextArea() {
            this((String)null, false);
        }

        public XMLTextArea(String title, boolean showBorder) {
            super(title, showBorder, true);
            this.setBackground(Color.white);
        }

        private void setXMLText(HTMLFormatter html) {
            super.setText(html.getHTMLText(), true);
            try {
                HTMLDocument htmlDoc = (HTMLDocument)this.getEditorPane().getDocument();
                String s = htmlDoc.getText(0, htmlDoc.getLength());
                this.xmlTextString = s.startsWith("\n") ? s.substring(1) : s;
            }
            catch (Exception ex) {
                Print.dprintStackTrace((String)"Get HTML Text", (Throwable)ex);
                this.xmlTextString = "";
            }
        }

        public void setXMLText(String text) {
            this.xmlTextString = this.stripCR(text);
            super.setText(this.highlightText(this.xmlTextString), true);
        }

        private String stripCR(String s) {
            int p = s.indexOf("\r");
            if (p >= 0) {
                StringBuffer sb = new StringBuffer(s);
                int i = p;
                while (i < sb.length()) {
                    if (sb.charAt(i) == '\r') {
                        sb.deleteCharAt(i);
                        continue;
                    }
                    ++i;
                }
                s = sb.toString();
            }
            return s;
        }

        private String highlightText(String text) {
            StringBuffer htmlText = new StringBuffer(HILITE_ON);
            char[] ch = text.trim().toCharArray();
            for (int i = 0; i < ch.length; ++i) {
                if (ch[i] == '<') {
                    htmlText.append(HILITE_OFF);
                }
                htmlText.append(UITitledHTMLText.convertToHTML(ch[i]));
                if (ch[i] != '>') continue;
                htmlText.append(HILITE_ON);
            }
            return htmlText.toString();
        }

        public String getXMLText() {
            return this.xmlTextString;
        }

        public String updateXMLText(Descriptor desc) {
            if (desc == null) {
                return this.updateXMLText("");
            }
            ApplicationNode xmlNode = null;
            if (desc instanceof Application) {
                xmlNode = new ApplicationNode();
            } else if (desc instanceof ApplicationClientDescriptor) {
                xmlNode = new AppClientNode();
            } else if (desc instanceof EjbBundleDescriptor) {
                xmlNode = new EjbBundleNode();
            } else if (desc instanceof WebBundleDescriptor) {
                xmlNode = new WebBundleNode();
            } else if (desc instanceof ConnectorDescriptor) {
                xmlNode = new ConnectorNode();
            } else {
                Print.dprintln((String)("Descriptor not supported: " + UIUtils.debugClassName(desc)));
                return this.updateXMLText("");
            }
            try {
                Document document = J2EEDocumentBuilder.getDocument((Descriptor)desc, (XMLNode)xmlNode);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                if (xmlNode.getDocType() != null) {
                    transformer.setOutputProperty("doctype-public", xmlNode.getDocType());
                    if (xmlNode.getSystemID() != null) {
                        transformer.setOutputProperty("doctype-system", xmlNode.getSystemID());
                    }
                }
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("method", "xml");
                HTMLFormatter html = new HTMLFormatter();
                transformer.transform(new DOMSource(document), new SAXResult(html));
                this.setXMLText(html);
                return html.getXMLText();
            }
            catch (Exception ex) {
                Print.dprintStackTrace((String)"Descriptor XML", (Throwable)ex);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                J2EEDocumentBuilder.write((Descriptor)desc, (RootXMLNode)xmlNode, (OutputStream)bos);
                return this.updateXMLText(bos.toString());
            }
        }

        public String updateXMLText(String key, Descriptor desc) {
            return this.updateXMLText(desc);
        }

        public String updateXMLText(String xmltxt) {
            this.setXMLText(xmltxt != null ? xmltxt : "");
            return xmltxt;
        }

        public String updateXMLText(String key, String xmltxt) {
            return this.updateXMLText(xmltxt);
        }

        private class HTMLFormatter
        extends DefaultHandler {
            private String INDENT_TAB = "    ";
            private boolean isHighlighted = false;
            private boolean hasData = false;
            private int indentLevel = 0;
            private StringBuffer xml = new StringBuffer();
            private StringBuffer html = new StringBuffer();

            public void startDocument() throws SAXException {
                this.append("<?xml version='1.0' encoding='UTF-8'?>", true);
            }

            public void endDocument() throws SAXException {
                this.append("\n", true);
            }

            public void startElement(String ns, String sName, String qName, Attributes attrs) throws SAXException {
                this.indent(this.indentLevel++);
                this.setHighlight(false);
                String eName = !"".equals(qName) ? qName : sName;
                this.append("<" + eName, true);
                if (attrs != null && attrs.getLength() > 0) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        String asName = attrs.getLocalName(i);
                        String aqName = attrs.getQName(i);
                        String aeName = !"".equals(aqName) ? aqName : asName;
                        this.indent(this.indentLevel + 1);
                        this.append(aeName + "=\"", true);
                        this.append(HILITE_ON, false);
                        this.append(attrs.getValue(i), true);
                        this.append(HILITE_OFF, false);
                        this.append("\"", true);
                    }
                    this.indent(this.indentLevel + 1);
                    this.append(">", true);
                } else {
                    this.append(">", true);
                }
            }

            public void endElement(String ns, String sName, String qName) throws SAXException {
                --this.indentLevel;
                this.setHighlight(false);
                if (this.hasData) {
                    this.hasData = false;
                } else {
                    this.indent(this.indentLevel);
                }
                String eName = "".equals(sName) ? qName : sName;
                this.append("</" + eName + ">", true);
            }

            public void characters(char[] buf, int offset, int len) throws SAXException {
                String s = UITitledHTMLText.convertToHTML(new String(buf, offset, len));
                if (!s.equals("")) {
                    if (!this.hasData) {
                        this.hasData = true;
                    }
                    this.setHighlight(true);
                    this.append(s, true);
                }
            }

            public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
            }

            private void indent(int level) {
                this.append("\n", true);
                for (int i = 0; i < level; ++i) {
                    this.append(this.INDENT_TAB, true);
                }
            }

            private void setHighlight(boolean state) {
                if (state != this.isHighlighted) {
                    this.append(state ? HILITE_ON : HILITE_OFF, false);
                    this.isHighlighted = state;
                }
            }

            private void append(String s, boolean isXml) {
                if (isXml) {
                    this.xml.append(s);
                    this.html.append(UITitledHTMLText.convertToHTML(s));
                } else {
                    this.html.append(s);
                }
            }

            public String getHTMLText() {
                return this.html.toString();
            }

            public String getXMLText() {
                return this.xml.toString();
            }
        }
    }

    public static class SplitXMLTextArea
    extends JSplitPane
    implements UpdateXMLTextArea {
        private XMLTextArea first = null;
        private Hashtable xmlMap = null;

        public SplitXMLTextArea() {
            super(0);
            this.setOneTouchExpandable(true);
            this.getAccessibleContext().setAccessibleName(SPLIT_NAME);
            this.getAccessibleContext().setAccessibleDescription(SPLIT_DESC);
        }

        public SplitXMLTextArea(String[] list, boolean showBorder) {
            this();
            for (int i = 0; i < list.length; ++i) {
                this.addXMLTextArea(list[i], new XMLTextArea(list[i], showBorder));
            }
        }

        public SplitXMLTextArea(int count, boolean showBorder) {
            this();
            for (int i = 0; i < count; ++i) {
                this.addXMLTextArea(String.valueOf(i), new XMLTextArea(null, showBorder));
            }
        }

        public void addXMLTextArea(String key, XMLTextArea xta) {
            if (this.xmlMap == null) {
                this.xmlMap = new Hashtable();
            }
            if (this.first == null) {
                this.first = xta;
            }
            this.xmlMap.put(key, xta);
            this.add(xta);
        }

        public XMLTextArea getXMLTextArea(int ndx) {
            return this.getXMLTextArea(String.valueOf(ndx));
        }

        public XMLTextArea getXMLTextArea(String key) {
            if (key == null) {
                return this.first;
            }
            return this.xmlMap != null ? (XMLTextArea)this.xmlMap.get(key) : null;
        }

        public void setXMLTextAreaVisible(String key, boolean visible) {
            XMLTextArea xta = this.getXMLTextArea(key);
            if (xta != null && visible != xta.isVisible()) {
                xta.setVisible(visible);
                if (visible) {
                    this.resetToPreferredSizes();
                }
            }
        }

        public String updateXMLText(Descriptor desc) {
            return this.updateXMLText(null, desc);
        }

        public String updateXMLText(String key, Descriptor desc) {
            XMLTextArea xta = this.getXMLTextArea(key);
            return xta != null ? xta.updateXMLText(desc) : null;
        }

        public String updateXMLText(String xmltxt) {
            return this.updateXMLText(null, xmltxt);
        }

        public String updateXMLText(String key, String xmltxt) {
            XMLTextArea xta = this.getXMLTextArea(key);
            return xta != null ? xta.updateXMLText(xmltxt) : null;
        }
    }

    public static interface UpdateXMLTextArea {
        public String updateXMLText(Descriptor var1);

        public String updateXMLText(String var1);

        public String updateXMLText(String var1, Descriptor var2);

        public String updateXMLText(String var1, String var2);
    }
}

