/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.script;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeView;
import com.sun.enterprise.tools.deployment.ui.script.ScriptException;
import com.sun.enterprise.tools.deployment.ui.script.ScriptRunnerCore;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledCheckBoxList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextArea;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTree;
import com.sun.enterprise.tools.deployment.ui.utils.Wizard;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ScriptRunner
extends ScriptRunnerCore {
    protected static final String NEXT = "Next";
    protected static final String CANCEL = "Cancel";
    protected static final String FINISH = "Finish";
    public static boolean CheckActiveWindow = false;
    static /* synthetic */ Class class$javax$swing$JMenuItem;

    public void closeAllWindows() throws ScriptException {
        Frame appFrame = DT.getApplicationFrame();
        Vector winList = this.getDepthFirstWindowList();
        Enumeration e = winList.elements();
        while (e.hasMoreElements()) {
            Window win = (Window)e.nextElement();
            if (win == appFrame) continue;
            if (win instanceof Wizard) {
                this.clickButton(win, CANCEL);
                continue;
            }
            if (win instanceof UIDialog) {
                win.hide();
                continue;
            }
            win.hide();
        }
    }

    public void clickButton(Component p, String t) throws ScriptException {
        JButton c = (JButton)this.findComponent(p, JButton.class, t);
        if (CheckActiveWindow && !this.isWindowActive(c)) {
            this.error("Window is not active: " + t);
        }
        if (!c.isEnabled()) {
            this.error("Button is disabled: " + t);
        }
        this.invoke(new UIActionDispatcher((Object)c, "doClick", null));
        this.pause(t.equals(NEXT) || t.equals(FINISH) ? 3000 : 1500);
    }

    public void selectRadioButton(Component p, String t) throws ScriptException {
        JRadioButton c = (JRadioButton)this.findComponent(p, JRadioButton.class, t);
        if (CheckActiveWindow && !this.isWindowActive(c)) {
            this.error("Window is not active: " + t);
        }
        if (!c.isEnabled()) {
            this.error("RadioButton is disabled: " + t);
        }
        c.doClick();
        this.pause(750);
    }

    public void selectComboBox(Component p, String t, String v) throws ScriptException {
        UITitledComboBox c = (UITitledComboBox)this.findComponent(p, UITitledComboBox.class, t);
        if (CheckActiveWindow && !this.isWindowActive(c)) {
            this.error("Window is not active: " + t);
        }
        if (!c.isEnabled()) {
            this.error("ComboBox is disabled: " + t);
        }
        c.setSelectedItem(v);
        if (v != null && c.getSelectedItem() == null) {
            this.error("UITitledComboBox Selection Not Found: " + v);
        }
        c.fireUpdate();
        this.pause(750);
    }

    public void setCheckBox(Component p, String t, boolean value) throws ScriptException {
        JCheckBox cb = (JCheckBox)this.findComponent(p, JCheckBox.class, t);
        if (CheckActiveWindow && !this.isWindowActive(cb)) {
            this.error("Window is not active: " + t);
        }
        if (!cb.isEnabled()) {
            this.error("CheckBox is disabled: " + t);
        }
        cb.setSelected(value);
        this.pause(750);
    }

    public void setTextField(Component p, String t, String v) throws ScriptException {
        Component c = this.findComponent(p, new Class[]{UITitledTextField.class, JTextField.class}, t);
        if (CheckActiveWindow && !this.isWindowActive(p)) {
            this.error("Window is not active: " + t);
        }
        if (c instanceof UITitledTextField) {
            UITitledTextField tf = (UITitledTextField)c;
            if (!tf.isEnabled()) {
                this.error("UITitledTextField is disabled: " + t);
            }
            tf.setText(v != null ? v : "");
            tf.fireUpdate();
        } else {
            JTextField jf = (JTextField)c;
            if (!jf.isEnabled()) {
                this.error("JTextField is disabled: " + t);
            }
            jf.setText(v != null ? v : "");
            jf.postActionEvent();
        }
        this.pause(750);
    }

    public void setTextArea(Component p, String t, String v) throws ScriptException {
        UITitledTextArea c = (UITitledTextArea)this.findComponent(p, UITitledTextArea.class, t);
        if (CheckActiveWindow && !this.isWindowActive(c)) {
            this.error("Window is not active: " + t);
        }
        if (!c.isEnabled()) {
            this.error("UITitledTextArea is disabled: " + t);
        }
        c.setText(v != null ? v : "");
        c.fireUpdate();
        this.pause(750);
    }

    public void selectCheckBoxList(Component p, String t, String[] v) throws ScriptException {
        UITitledCheckBoxList c = (UITitledCheckBoxList)this.findComponent(p, UITitledCheckBoxList.class, t);
        if (CheckActiveWindow && !this.isWindowActive(c)) {
            this.error("Window is not active: " + t);
        }
        if (!c.isEnabled()) {
            this.error("UITitledCheckBoxList is disabled: " + t);
        }
        UITitledCheckBoxList cbList = c;
        if (v != null) {
            for (int r = 0; r < v.length; ++r) {
                int cb = cbList.getIndexOfCheckBox(v[r]);
                if (cb >= 0) {
                    cbList.setCheckBoxSelectionAt(cb, true);
                    this.pause(500);
                    continue;
                }
                this.error("CheckBox item not found: " + v[r]);
            }
        } else {
            for (int r = 0; r < cbList.getListDataCount(); ++r) {
                cbList.setCheckBoxSelectionAt(r, true);
                this.pause(500);
            }
        }
    }

    public void selectTreeItems(Component p, String t, String[] v) throws ScriptException {
        UITitledTree tt = (UITitledTree)this.findComponent(p, UITitledTree.class, t);
        if (CheckActiveWindow && !this.isWindowActive(tt)) {
            this.error("Window is not active: " + t);
        }
        JTree tree = tt.getTreeView();
        Vector<TreePath> selections = new Vector<TreePath>();
        for (int i = 0; i < v.length; ++i) {
            boolean found = false;
            for (int r = 0; r < tree.getRowCount(); ++r) {
                TreePath path = tree.getPathForRow(r);
                if (!this.compareTitle(path.getLastPathComponent().toString(), v[i])) continue;
                selections.add(path);
                found = true;
                break;
            }
            if (found) continue;
            this.error("Tree row not found: " + v[i]);
        }
        TreePath[] paths = selections.toArray(new TreePath[selections.size()]);
        tree.setSelectionPaths(paths);
        this.pause(500);
        tt.fireUpdate();
    }

    public void expandTreeItem(Component p, String t, String v) throws ScriptException {
        UITitledTree tt = (UITitledTree)this.findComponent(p, UITitledTree.class, t);
        if (CheckActiveWindow && !this.isWindowActive(tt)) {
            this.error("Window is not active: " + t);
        }
        JTree tree = tt.getTreeView();
        for (int r = 0; r < tree.getRowCount(); ++r) {
            TreePath path = tree.getPathForRow(r);
            if (!path.getLastPathComponent().toString().equals(v)) continue;
            tree.expandPath(path);
            this.pause(500);
            tt.fireUpdate();
            return;
        }
        this.error("Tree row not found: " + v);
    }

    public void selectTreeDescriptor(String d) throws ScriptException {
        DescriptorTreeView dtv;
        DescriptorTreeNode node;
        Window mainWin = this.findWindow("Application Deployment Tool");
        if (CheckActiveWindow && !this.isWindowActive(mainWin)) {
            this.error("Main Window is not active");
        }
        if ((node = (dtv = (DescriptorTreeView)this.findComponent((Component)mainWin, DescriptorTreeView.class, null)).getRootNode().getNodeFor(d)) == null) {
            this.error("Node Not Found: " + d);
        }
        dtv.setSelectedDescriptor((Descriptor)node.getUserObject(), true);
        this.pause(2000);
    }

    public void selectTreeDescriptor(String[] d) throws ScriptException {
        Window mainWin = this.findWindow("Application Deployment Tool");
        if (CheckActiveWindow && !this.isWindowActive(mainWin)) {
            this.error("Main Window is not active");
        }
        DescriptorTreeView dtv = (DescriptorTreeView)this.findComponent((Component)mainWin, DescriptorTreeView.class, null);
        DefaultMutableTreeNode node = null;
        for (int i = 0; node != null && i < d.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = node = i == 0 ? dtv.getRootNode().getNodeFor(d[0]) : ((DescriptorTreeNode)node).getNodeFor(d[i]);
            if (node != null) continue;
            this.error("Node Not Found: " + d[i]);
        }
        dtv.setSelectedDescriptor((Descriptor)node.getUserObject(), true);
        this.pause(2000);
    }

    public void selectTableRow(Component p, String title, String rowVal) throws ScriptException {
        this.selectTableRow(p, title, new String[]{rowVal});
    }

    public void selectTableRow(Component p, String title, String[] rowVal) throws ScriptException {
        Class[] tableClasses = new Class[]{UITitledTable.class, UITitledList.class};
        Component comp = this.findComponent(p, tableClasses, title);
        if (CheckActiveWindow && !this.isWindowActive(comp)) {
            this.error("Window is not active: " + title);
        }
        if (comp instanceof UITitledTable) {
            UITitledTable tb = (UITitledTable)comp;
            InspectorTable table = tb.getInspectorTableView();
            Object rowObj = null;
            for (int r = 0; r < table.getRowCount(); ++r) {
                boolean match = false;
                Object obj = table.getRowObject(r);
                for (int c = 0; c < rowVal.length; ++c) {
                    Object cv = table.getObjectValue(obj, c);
                    String colVal = cv != null ? cv.toString() : "";
                    boolean bl = match = rowVal[c].equals("") ? colVal.equals("") : colVal.startsWith(rowVal[c]);
                    if (!match) break;
                }
                if (!match) continue;
                table.setSelectedIndex(r);
                rowObj = obj;
                break;
            }
            if (rowObj == null) {
                this.error("Table Row Not Found: " + rowVal[0]);
            }
        } else if (comp instanceof UITitledList) {
            UITitledList tl = (UITitledList)comp;
            int ndx = tl.getIndexOfTitle(rowVal[0]);
            if (ndx < 0) {
                this.error("List Row Not Found: " + rowVal[0]);
            }
            tl.setSelectedIndex(ndx);
        }
    }

    public void setTableValues(Component p, String title, String rowVal, String[] val) throws ScriptException {
        this.setTableValues(p, title, new String[]{rowVal}, val);
    }

    public void setTableValues(Component p, String title, String[] rowVal, String[] val) throws ScriptException {
        Class[] tableClasses = new Class[]{UITitledTable.class, UITitledList.class};
        Component comp = this.findComponent(p, tableClasses, title);
        if (CheckActiveWindow && !this.isWindowActive(comp)) {
            this.error("Window is not active: " + title);
        }
        if (comp instanceof UITitledTable) {
            UITitledTable tb = (UITitledTable)comp;
            InspectorTable table = tb.getInspectorTableView();
            Object rowObj = null;
            for (int r = 0; r < table.getRowCount(); ++r) {
                boolean match = false;
                Object obj = table.getRowObject(r);
                for (int c = 0; c < rowVal.length; ++c) {
                    Object cv = table.getObjectValue(obj, c);
                    String colVal = cv != null ? cv.toString() : "";
                    boolean bl = match = rowVal[c].equals("") ? colVal.equals("") : colVal.startsWith(rowVal[c]);
                    if (!match) break;
                }
                if (!match) continue;
                table.setSelectedIndex(r);
                rowObj = obj;
                break;
            }
            if (rowObj == null) {
                this.error("UITitledTable Row Not Found: " + rowVal[0]);
            }
            if (val != null) {
                for (int c = 0; c < val.length; ++c) {
                    if (val[c] == null) continue;
                    Object v = table.getObjectValue(rowObj, c);
                    if (v instanceof String) {
                        table.setObjectValue(rowObj, c, val[c]);
                    } else if (v instanceof Boolean) {
                        table.setObjectValue(rowObj, c, Boolean.valueOf(val[c]));
                    } else {
                        table.setObjectValue(rowObj, c, val[c]);
                    }
                    this.pause(500);
                }
            }
            tb.repaint();
            tb.fireUpdate();
        } else if (comp instanceof UITitledCheckBoxList) {
            UITitledCheckBoxList cbl = (UITitledCheckBoxList)comp;
            int row = cbl.getIndexOfCheckBox(rowVal[0]);
            if (row >= 0) {
                JCheckBox cb = cbl.getCheckBoxAt(row);
                cb.setSelected(Boolean.getBoolean(val[0]));
            } else {
                this.error("UITitledCheckBoxList Row Not Found: " + rowVal[0]);
            }
        } else if (comp instanceof UITitledList) {
            UITitledList tl = (UITitledList)comp;
            int row = tl.getIndexOfTitle(rowVal[0]);
            Object obj = row >= 0 ? tl.getListDataAt(row) : null;
        }
    }

    public void selectTab(String t) throws ScriptException {
        Window mainWin = this.findWindow("Application Deployment Tool");
        JTabbedPane tabs = (JTabbedPane)this.findComponent((Component)mainWin, JTabbedPane.class, null);
        if (CheckActiveWindow && !this.isWindowActive(tabs)) {
            this.error("Main Window is not active");
        }
        boolean found = false;
        for (int i = 0; i < tabs.getTabCount(); ++i) {
            String tabTitle = tabs.getTitleAt(i);
            if (tabTitle == null || !tabTitle.startsWith(t)) continue;
            tabs.setSelectedIndex(i);
            found = true;
            break;
        }
        if (!found) {
            this.error("JTabbedPane Tab Not Found: " + t);
        }
        this.pause(2000);
    }

    public void selectMenuItem(String[] tree) throws ScriptException {
        Window mainWin = this.findWindow("Application Deployment Tool");
        JMenuBar menuBar = (JMenuBar)this.findComponent((Component)mainWin, JMenuBar.class, null);
        JMenu mbMenu = (JMenu)this.findComponent((Component)menuBar, JMenu.class, tree[0]);
        if (CheckActiveWindow && !this.isWindowActive(mbMenu)) {
            this.error("Main Window is not active");
        }
        Stack<JMenu> menuList = new Stack<JMenu>();
        JMenu menu = mbMenu;
        menu.setSelected(true);
        menu.setPopupMenuVisible(true);
        menuList.push(menu);
        for (int i = 1; i < tree.length; ++i) {
            JMenuItem menuItem = (JMenuItem)this.findComponent((Component)menu, class$javax$swing$JMenuItem == null ? ScriptRunner.class$("javax.swing.JMenuItem") : class$javax$swing$JMenuItem, tree[i]);
            if (menuItem instanceof JMenu) {
                menu = (JMenu)menuItem;
                menu.setSelected(true);
                menu.setPopupMenuVisible(true);
                menuList.push(menu);
                this.pause(500);
                continue;
            }
            menuItem.setSelected(true);
            this.invoke(new UIActionDispatcher((Object)menuItem, "doClick", null));
            this.pause(500);
            menuItem.setSelected(false);
        }
        while (!menuList.empty()) {
            JMenu m = (JMenu)menuList.pop();
            m.setPopupMenuVisible(false);
            m.setSelected(false);
        }
    }
}

