/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.rar;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.SecurityPermission;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JCheckBox;

public class ResAdaptSecurityInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ResAdaptSecurityInspector.class);
    private static final String TABNAME = localStrings.getLocalString("ui.resadaptsecurityinspector.tabname", "Security");
    private static final String SPECIFICATION = localStrings.getLocalString("ui.resadaptsecurityinspector.specification", "Specification");
    private static final String AUTH_MECH = localStrings.getLocalString("ui.resadaptsecurityinspector.auth_mechanisms", "Authentication Mechanisms");
    private static final String AUTH_MECH_ACC_DSC = localStrings.getLocalString("at.resadaptsecurityinspector.auth_mechanisms.acc_dsc", "Select required Authentication Mechanism for Resource Adapter");
    private static final String PASSWORD = localStrings.getLocalString("ui.resadaptsecurityinspector.password", "Password");
    private static final String PASSWORD_ACC_DSC = localStrings.getLocalString("at.resadaptsecurityinspector.password.acc_dsc", "Select checkbox to choose Password as the Authentication Mechanism");
    private static final String KERBEROS = localStrings.getLocalString("ui.resadaptsecurityinspector.kerberos_v50", "Kerberos Version 5.0");
    private static final String KERBEROS_ACC_DSC = localStrings.getLocalString("at.resadaptsecurityinspector.kerberos_v50.acc_dsc", "Select checkbox to choose Kerberos Version 5.0 as the Authentication Mechanism");
    private static final String REAUTH = localStrings.getLocalString("ui.resadaptsecurityinspector.kerberos_reauth_supported", "Reauthentication Supported");
    private static final String REAUTH_ACC_DSC = localStrings.getLocalString("at.resadaptsecurityinspector.kerberos_reauth_supported.acc_dsc", "Select checkbox to choose Reauthentication Supported as the Authentication Mechanism");
    private static final String SECURITY_PERM = localStrings.getLocalString("ui.resadaptsecurityinspector.sec_perm", "Security Permissions");
    private static final String SECURITY_PERM_ACC_DSC = localStrings.getLocalString("at.resadaptsecurityinspector.sec_perm.acc_dsc", "Table to add/delete Security Permissions for the Resource Adapter");
    private static final String SECURITY_PERM_ADD = localStrings.getLocalString("ui.resadaptsecurityinspector.sec_perm.add", "Add");
    private static final String SECURITY_PERM_DEL = localStrings.getLocalString("ui.resadaptsecurityinspector.sec_perm.delete", "Delete...");
    private static final String OKTODEL_SECURITY = localStrings.getLocalString("ui.resadaptsecurityinspector.sec_perm.delete.confirm", "Are you sure you want to delete selected security permissions?");
    private static final String DELETE_SECURITY = localStrings.getLocalString("ui.resadaptsecurityinspector.sec_perm.delete.confirm_btn", "Delete Security Permissions");
    private static String wizardHelpID = "Security";
    private static String deployHelpID = "Security";
    private ConnectorDescriptor descriptor;
    private JCheckBox authPassword = null;
    private JCheckBox authKerberos = null;
    private JCheckBox authReAuthSupport = null;
    private UITitledTable securityTable = null;
    private RASecurityPermTable securityPermTable = null;
    private static boolean replaceExistingAuthMeth = true;

    public static InspectorPane newInspectorPane(String mode) {
        return new ResAdaptSecurityInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return ConnectorDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof ConnectorDescriptor) {
            this.descriptor = (ConnectorDescriptor)obj;
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private ResAdaptSecurityInspector(String mode) {
        this.setInspectorMode(mode);
        this.initLayout();
    }

    private void initLayout() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 5, 0);
        c.fill = 1;
        c.anchor = 10;
        UITitledBox authMechBox = new UITitledBox(AUTH_MECH, true);
        authMechBox.getAccessibleContext().setAccessibleDescription(AUTH_MECH_ACC_DSC);
        this.authPassword = new UICheckBox(PASSWORD);
        this.authPassword.getAccessibleContext().setAccessibleDescription(PASSWORD_ACC_DSC);
        this.authPassword.setSelected(false);
        this.authPassword.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ResAdaptSecurityInspector.this.setDescriptorAuthMech(0, ResAdaptSecurityInspector.this.authPassword.isSelected());
            }
        });
        authMechBox.add((Component)this.authPassword, authMechBox.getGBConstraints());
        this.authKerberos = new UICheckBox(KERBEROS);
        this.authKerberos.getAccessibleContext().setAccessibleDescription(KERBEROS_ACC_DSC);
        this.authKerberos.setSelected(false);
        this.authKerberos.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ResAdaptSecurityInspector.this.setDescriptorAuthMech(1, ResAdaptSecurityInspector.this.authKerberos.isSelected());
            }
        });
        authMechBox.add((Component)this.authKerberos, authMechBox.getGBConstraints());
        this.authReAuthSupport = new UICheckBox(REAUTH);
        this.authReAuthSupport.getAccessibleContext().setAccessibleDescription(REAUTH_ACC_DSC);
        this.authReAuthSupport.setSelected(false);
        this.authReAuthSupport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                OutboundResourceAdapter obra = ResAdaptSecurityInspector.this.descriptor.getOutboundResourceAdapter();
                if (obra == null) {
                    obra = new OutboundResourceAdapter();
                    ResAdaptSecurityInspector.this.descriptor.setOutboundResourceAdapter(obra);
                }
                obra.setReauthenticationSupport(ResAdaptSecurityInspector.this.authReAuthSupport.isSelected());
            }
        });
        authMechBox.addWithGBConstraints(this.authReAuthSupport);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        this.add((Component)authMechBox, c);
        this.securityTable = new UITitledTable(SECURITY_PERM, true);
        this.securityTable.getAccessibleContext().setAccessibleDescription(SECURITY_PERM_ACC_DSC);
        this.securityPermTable = new RASecurityPermTable();
        this.securityTable.setTableView(this.securityPermTable);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.fill = 1;
        c.anchor = 10;
        this.add((Component)this.securityTable, c);
        UIButton addPB = new UIButton(SECURITY_PERM_ADD);
        addPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResAdaptSecurityInspector.this.addSecurityPermissionAction();
            }
        });
        this.securityTable.addControlButton(addPB);
        UIButton delPB = new UIButton(SECURITY_PERM_DEL);
        delPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResAdaptSecurityInspector.this.deleteSecurityPermissionAction();
            }
        });
        this.securityTable.addSelectionEnabledButton(delPB);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        boolean authpass = false;
        boolean authkerb = false;
        OutboundResourceAdapter obra = this.descriptor.getOutboundResourceAdapter();
        if (obra != null) {
            Iterator authMech = obra.getAuthMechanisms().iterator();
            while (authMech.hasNext()) {
                AuthMechanism auth = (AuthMechanism)authMech.next();
                if (auth.getAuthMechVal() == 0) {
                    authpass = true;
                    continue;
                }
                if (auth.getAuthMechVal() != 1) continue;
                authkerb = true;
            }
        }
        this.authPassword.setSelected(authpass);
        this.authKerberos.setSelected(authkerb);
        ArrayList<SecurityPermissionWrapper> secWrapper = new ArrayList<SecurityPermissionWrapper>();
        if (obra == null) {
            this.authReAuthSupport.setSelected(false);
        } else {
            this.authReAuthSupport.setSelected(obra.supportsReauthentication());
        }
        Iterator secIter = this.descriptor.getSecurityPermissions().iterator();
        while (secIter.hasNext()) {
            SecurityPermission secPerm = (SecurityPermission)secIter.next();
            secWrapper.add(new SecurityPermissionWrapper(secPerm));
        }
        this.securityTable.updateTableData(secWrapper);
    }

    private void addSecurityPermissionAction() {
        if (this.securityPermTable.getRowWithValue(0, "") == null) {
            OutboundResourceAdapter obra = this.descriptor.getOutboundResourceAdapter();
            if (obra == null) {
                obra = new OutboundResourceAdapter();
                this.descriptor.setOutboundResourceAdapter(obra);
            }
            this.descriptor.addSecurityPermission(new SecurityPermission("", ""));
        }
        this.securityPermTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteSecurityPermissionAction() {
        Object[] list = this.securityTable.confirmDeleteSelection(null, null);
        if (list != null && list.length > 0) {
            for (int i = 0; i < list.length; ++i) {
                this.descriptor.removeSecurityPermission(((SecurityPermissionWrapper)((Object)list[i])).getSecurityPermission());
            }
            this.securityPermTable.clearSelection();
            this.invokeRefresh();
        }
    }

    private void setDescriptorAuthMech(int mech, boolean state) {
        OutboundResourceAdapter obra = this.descriptor.getOutboundResourceAdapter();
        if (obra == null) {
            obra = new OutboundResourceAdapter();
            this.descriptor.setOutboundResourceAdapter(obra);
            obra.addAuthMechanism(mech);
        } else {
            if (state) {
                if (replaceExistingAuthMeth) {
                    obra.removeAuthMechanism(mech);
                }
                obra.addAuthMechanism(mech);
            } else {
                obra.removeAuthMechanism(mech);
            }
            this.invokeRefresh();
        }
    }

    private static class RASecurityPermModel
    extends InspectorTableModel {
        public RASecurityPermModel() {
            super(new String[]{SPECIFICATION, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public Object getObjectValue(Object obj, int col) {
            SecurityPermissionWrapper sp = (SecurityPermissionWrapper)((Object)obj);
            String value = null;
            switch (col) {
                case 0: {
                    value = sp.getPermission();
                    break;
                }
                case 1: {
                    value = sp.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            SecurityPermissionWrapper sp = (SecurityPermissionWrapper)((Object)obj);
            String vs = value.toString();
            switch (col) {
                case 0: {
                    sp.setPermission(vs);
                    break;
                }
                case 1: {
                    sp.setDescription(vs);
                }
            }
        }
    }

    private static class RASecurityPermTable
    extends InspectorTable {
        public RASecurityPermTable() {
            super(new RASecurityPermModel());
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }
    }

    private class SecurityPermissionWrapper
    extends Descriptor {
        private SecurityPermission secPerm = null;

        public SecurityPermissionWrapper(String d, String p) {
            this(new SecurityPermission(d, p));
        }

        public SecurityPermissionWrapper(SecurityPermission sp) {
            this.secPerm = sp;
        }

        public SecurityPermission getSecurityPermission() {
            return this.secPerm;
        }

        public String getDescription() {
            return this.secPerm.getDescription();
        }

        public void setDescription(String description) {
            this.secPerm.setDescription(description);
        }

        public String getPermission() {
            return this.secPerm.getPermission();
        }

        public void setPermission(String permission) {
            this.secPerm.setPermission(permission);
        }

        public String getName() {
            return this.getPermission();
        }

        public boolean equals(Object ref) {
            return this.secPerm.equals(ref);
        }
    }
}

