/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.rar;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.InboundResourceAdapter;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.tools.deployment.ui.rar.ConfigPropsDialog;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

public class MsgInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MsgInspector.class);
    private static final String CBOX_NAME = localStrings.getLocalString("ui.msginspector.cbox_name", "Resource Adapter Inspector ComboBox");
    private static final String CBOX_DESC = localStrings.getLocalString("ui.msginspector.cbox_desc", "This is a ComboBox for Resource Adapter Inspector window");
    private static final String MSG_LISTENERS_TABLE_TITLE = localStrings.getLocalString("ui.msginspector.msg_listeners_table_title", "Message Listeners");
    private static final String LISTENER_TYPE_CLASS = localStrings.getLocalString("ui.msginspector.listener_type_class", "Listener Type");
    private static final String ACT_SPEC_CLASS = localStrings.getLocalString("ui.msginspector.act_spec_class", "Activation Specification Class");
    private static final String TABNAME = localStrings.getLocalString("ui.msginspector.tabname", "Message Support");
    private static String wizardHelpID = "RARMessaging";
    private static String deployHelpID = "RARMessaging";
    private ConnectorDescriptor descriptor = null;
    private UITitledTable msgTablePanel = null;
    private MessageTable msgTable = null;
    private MessageTableModel msgTableModel = null;
    private Vector classList = null;
    private ConfigPropsDialog cfgPropsDiag = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new MsgInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return ConnectorDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        Print.dprintln((String)"Set Descriptor");
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof ConnectorDescriptor ? (ConnectorDescriptor)desc : null;
            this.msgTable.clearTableData();
        }
        this.msgTable.resetListenerTypeEditor();
        this.msgTable.resetActSpecEditor();
    }

    public boolean validateEntries(boolean showErrors) {
        Print.dprintln((String)("validateEntries " + showErrors));
        this.msgTable.resetListenerTypeEditor();
        this.msgTable.resetActSpecEditor();
        return true;
    }

    private MsgInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.msgTablePanel = new UITitledTable(MSG_LISTENERS_TABLE_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.msgTablePanel, c);
        this.msgTableModel = new MessageTableModel();
        this.msgTable = new MessageTable(this.msgTableModel);
        this.msgTablePanel.setTableView(this.msgTable);
        UIButton addMsgListenerBtn = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MsgInspector.this.addMsgListenerAction();
            }
        });
        this.msgTablePanel.addControlButton(addMsgListenerBtn);
        UIButton delMsgListenerBtn = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MsgInspector.this.deleteMsgListenerAction();
            }
        }, true);
        this.msgTablePanel.addSelectionEnabledButton(delMsgListenerBtn);
    }

    private InboundResourceAdapter _getInboundResourceAdapter(boolean createIfNull) {
        InboundResourceAdapter ibra = this.descriptor.getInboundResourceAdapter();
        if (ibra == null && createIfNull) {
            ibra = new InboundResourceAdapter();
            this.descriptor.setInboundResourceAdapter(ibra);
        }
        return ibra;
    }

    public void refresh() {
        InboundResourceAdapter ibra = this._getInboundResourceAdapter(false);
        Set msgListeners = ibra != null ? ibra.getMessageListeners() : null;
        this.msgTable.updateTableData(msgListeners);
    }

    public void setClassList(Vector newClassList) {
        this.classList = newClassList;
        this.msgTable.resetListenerTypeEditor();
        this.msgTable.resetActSpecEditor();
    }

    private List getMsgListenerIfaces() {
        Vector msgListenerIfaces = this.getArchiveInterfaceNames();
        msgListenerIfaces.add("javax.jms.MessageListener");
        msgListenerIfaces.add("javax.xml.messaging.OnewayListener");
        msgListenerIfaces.add("javax.xml.messaging.ReqRespListener");
        return msgListenerIfaces;
    }

    private void addMsgListenerAction() {
        if (this.msgTable.getRowWithValue(0, "") == null) {
            MessageListener newML = new MessageListener();
            newML.setMessageListenerType("");
            this._getInboundResourceAdapter(true).addMessageListener(newML);
        }
        this.msgTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteMsgListenerAction() {
        Object[] list = this.msgTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                MessageListener ref = (MessageListener)list[i];
                this._getInboundResourceAdapter(true).removeMessageListener(ref);
            }
            this.invokeRefresh();
        }
    }

    public void cfgPropsAction() {
        MessageListener ref = (MessageListener)this.msgTable.getSelectedRowObject();
        if (ref == null) {
            return;
        }
        if (this.cfgPropsDiag == null) {
            this.cfgPropsDiag = ConfigPropsDialog.newDialog(this);
        }
        this.cfgPropsDiag.showDialog((Descriptor)ref);
        this.invokeRefresh();
    }

    private class MessageTableModel
    extends InspectorTableModel {
        public MessageTableModel() {
            super(new String[]{LISTENER_TYPE_CLASS, ACT_SPEC_CLASS, ""});
        }

        public Object getObjectValue(Object obj, int col) {
            MessageListener ref = (MessageListener)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getMessageListenerType();
                    break;
                }
                case 1: {
                    value = ref.getActivationSpecClass();
                    break;
                }
                case 2: {
                    value = ref.getConfigProperties().size() == 0 ? "blank" : "filled";
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            MessageListener ref = (MessageListener)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    ref.setMessageListenerType(value.toString());
                    break;
                }
                case 1: {
                    ref.setActivationSpecClass(value.toString());
                    break;
                }
            }
        }
    }

    private class MessageTable
    extends InspectorTable {
        public MessageTable(MessageTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.initIconColumn(2, UIIcons.getImageIconFor(UIIcons.CONF_PROPS_EMPTY_TBL_ICON), (Object[][])new Object[][]{{"filled", UIIcons.getImageIconFor(UIIcons.CONF_PROPS_FILLED_TBL_ICON)}, {"blank", UIIcons.getImageIconFor(UIIcons.CONF_PROPS_EMPTY_TBL_ICON)}}, new ActionListener(this){
                private final /* synthetic */ MessageTable this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    MessageTable.access$200(this.this$1).cfgPropsAction();
                }
            });
        }

        public void resetListenerTypeEditor() {
            List items = MsgInspector.this.getMsgListenerIfaces();
            JComboBox cBox = new JComboBox(new Vector(items));
            cBox.setEditable(true);
            cBox.getAccessibleContext().setAccessibleName(CBOX_NAME);
            cBox.getAccessibleContext().setAccessibleDescription(CBOX_DESC);
            this.getColumn(LISTENER_TYPE_CLASS).setCellEditor(new DefaultCellEditor(cBox));
        }

        public void resetActSpecEditor() {
            Vector items = MsgInspector.this.getArchiveImplementationNames();
            JComboBox cBox = new JComboBox(items);
            cBox.setEditable(true);
            cBox.getAccessibleContext().setAccessibleName(CBOX_NAME);
            cBox.getAccessibleContext().setAccessibleDescription(CBOX_DESC);
            this.getColumn(ACT_SPEC_CLASS).setCellEditor(new DefaultCellEditor(cBox));
        }

        static /* synthetic */ MsgInspector access$200(MessageTable x0) {
            return x0.MsgInspector.this;
        }
    }
}

