/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.rar;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.rar.NewResAdaptWizard;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleContent;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.StringTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIDisplayNameBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIJarPackagerBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFileChooser;

public class ConnectorRARGeneralInspector
extends InspectorPane
implements UIJarPackagerBox.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnectorRARGeneralInspector.class);
    private static final String TOOLTIP = localStrings.getLocalString("at.connectorrargeneralinspector.tooltip", "Resource Adapter Archive information");
    private static String CONTENTS_ACC_DSC = localStrings.getLocalString("ui.connectorrargeneralinspector.contents.acc_dsc", "Display the contents of the Resource Adapter");
    private static String TABNAME = localStrings.getLocalString("ui.connectorrargeneralinspector.tabname", "RAR File");
    private static String wizardHelpID = "RAR";
    private static String deployHelpID = "RAR";
    private ConnectorDescriptor descriptor;
    private UIDisplayNameBox fileDisplayBox = null;
    private UIJarPackagerBox contentsListBox = null;
    private ModuleContent wizardContentsMap = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new ConnectorRARGeneralInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return ConnectorDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof ConnectorDescriptor) {
            this.descriptor = (ConnectorDescriptor)obj;
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private ConnectorRARGeneralInspector(String mode) {
        this.setInspectorMode(mode);
        this.initLayout();
    }

    private void initLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.fileDisplayBox = new UIDisplayNameBox(3, this.isWizardMode());
        this.fileDisplayBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConnectorRARGeneralInspector.this.descriptor.setDisplayName(ConnectorRARGeneralInspector.this.fileDisplayBox.getDisplayName());
                ConnectorRARGeneralInspector.this.invokeRefresh();
            }
        });
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        c.anchor = 10;
        this.add((Component)this.fileDisplayBox, c);
        this.contentsListBox = new UIJarPackagerBox(this, "conrar", true);
        this.contentsListBox.getAccessibleContext().setAccessibleDescription(CONTENTS_ACC_DSC);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 5, 5, 5);
        c.fill = 1;
        c.anchor = 10;
        this.add((Component)this.contentsListBox, c);
        if (this.isWizardMode()) {
            this.wizardContentsMap = new ModuleContent();
        }
    }

    public void refresh() {
        Application app;
        Descriptor obj;
        if (this.descriptor == null) {
            return;
        }
        if (this.isWizardMode() && (obj = this.getSelectedParentDescriptor()) instanceof Application) {
            app = (Application)obj;
            String descName = this.descriptor.getDisplayName();
            if (StringTools.isEmpty(descName)) {
                descName = ".rar".substring(1);
            }
            Vector<String> list = new Vector<String>();
            Iterator i = app.getRarDescriptors().iterator();
            while (i.hasNext()) {
                list.add(((Descriptor)i.next()).getDisplayName());
            }
            String nn = DescriptorTools.createUniqueName(descName, list);
            if (!nn.equals(descName)) {
                this.descriptor.setDisplayName(nn);
            }
        }
        if (this.isDeploymentMode()) {
            this.fileDisplayBox.setFileLocation(ModuleArchive.getModuleArchive((Descriptor)this.descriptor).getArchiveUri());
            this.fileDisplayBox.setDisplayName(this.descriptor.getDisplayName());
        }
        if (this.isDeploymentMode()) {
            this.contentsListBox.setContents((BundleDescriptor)this.descriptor);
        } else if (this.isStandAlone()) {
            File dir = new File(this.getArchiveFileName());
            this.contentsListBox.setContents((BundleDescriptor)this.descriptor, dir, null, this.wizardContentsMap);
        } else {
            obj = this.getSelectedParentDescriptor();
            app = obj instanceof Application ? (Application)obj : null;
            this.contentsListBox.setContents((BundleDescriptor)this.descriptor, app, null, this.wizardContentsMap);
        }
    }

    private void browseStandAloneFileName() {
        UIFileChooser jfc = UIFileChooser.getFileChooser(null, "RarFiles");
        int rtn = ((JFileChooser)jfc).showDialog(this, localStrings.getLocalString("ui.connectorrargeneralinspector.choose_module_filename", "Choose Module File"));
        if (rtn == 0) {
            File chosenFile = ((JFileChooser)jfc).getSelectedFile();
            this.fileDisplayBox.setFileLocation(chosenFile.toString());
        }
    }

    public void setWizardComponentMode(String addMode) {
        this.fileDisplayBox.setWizardComponentMode(addMode);
        this.fileDisplayBox.setSavedStartingDirectory(NewResAdaptWizard.getSavedStartingDirectory());
    }

    public boolean isStandAlone() {
        return this.fileDisplayBox.isCreateNewStandAlone();
    }

    public String getArchiveFileName() {
        return this.isStandAlone() ? this.fileDisplayBox.getFileLocation() : null;
    }

    public String getFileLocation() {
        return this.fileDisplayBox.getFileLocation();
    }

    public Descriptor getSelectedParentDescriptor() {
        return this.fileDisplayBox.getSelectedParentDescriptor();
    }

    public boolean validateTargetLocation() {
        if (!StringTools.isEmpty(this.fileDisplayBox.getDisplayName())) {
            this.descriptor.setDisplayName(this.fileDisplayBox.getDisplayName());
        }
        return this.fileDisplayBox.validateTargetLocation();
    }

    public void ensureNonNullDisplayName() {
        if (!StringTools.isEmpty(this.descriptor.getDisplayName())) {
            return;
        }
        String dName = this.fileDisplayBox.getDisplayName();
        if (StringTools.isEmpty(dName)) {
            if (this.isStandAlone()) {
                String t1 = new File(this.fileDisplayBox.getFileLocation()).getName();
                dName = t1.substring(0, t1.lastIndexOf(".rar"));
            } else {
                dName = ".rar".substring(1);
            }
        }
        this.descriptor.setDisplayName(dName);
    }

    public void addContentsAction(ModuleContent clsFcd, ModuleContent conFcd, Vector delCon) throws IOException {
        if (this.isWizardMode()) {
            this.wizardContentsMap.removeEntries(delCon);
        } else {
            ModuleArchive.getModuleArchive((Descriptor)this.descriptor).removeArchiveEntries(delCon);
        }
        if (this.isWizardMode()) {
            this.wizardContentsMap.addAll(conFcd);
            UIProject.addArchivePaths((Descriptor)this.descriptor, conFcd);
        } else {
            ModuleArchive.getModuleArchive((Descriptor)this.descriptor).addArchiveEntries(conFcd.getEntryNameMap());
        }
        this.invokeRefresh();
    }

    public ModuleContent getModuleContent() {
        if (!this.isWizardMode()) {
            return null;
        }
        this.wizardContentsMap.addEntries(UIProject.getProjectFileEntry((Descriptor)this.descriptor));
        return this.wizardContentsMap;
    }
}

