/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.pref;

import com.sun.enterprise.tools.deployment.ui.pref.PreferencePanel;
import com.sun.enterprise.tools.deployment.ui.pref.PreferenceTable;
import com.sun.enterprise.tools.deployment.ui.utils.UIBrowser;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfigProperties;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledHTMLText;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;

public class BrowserPreferences
extends UITitledBox
implements PreferencePanel {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(BrowserPreferences.class);
    protected static String BROWSER_COMMAND_TITLE = localStrings.getLocalString("ui.browserpreferences.command.title", "Platform Browser Startup Command");
    protected static String BROWSER_COMMAND_HELP = localStrings.getLocalString("ui.browserpreferences.command.help", "Enter the command which will be used to invoke your web browser on your platform.  Use the dollar sign ($) to indicate where in the string you would like the URL to be placed when the command is invoked.");
    protected static String BROWSER_COMMAND = localStrings.getLocalString("ui.browserpreferences.command", "Command:");
    protected static String BROWSER_ARGUMENTS = localStrings.getLocalString("ui.browserpreferences.arguments", "Arguments: [must include a '$' as described above]");
    protected static String CHOOSE_BROWSER_COMMNAD = localStrings.getLocalString("ui.browserpreferences.choose_command", "Choose Browser Command");
    protected static String BROWSER_URLS = localStrings.getLocalString("ui.browserpreferences.urls", "Browser Help URLs");
    protected static String BROWSER_URLS_HELP = localStrings.getLocalString("ui.browserpreferences.urls.help", "Add URLs that you would like to show up in the Help menu");
    protected static String BROWSER_URLS_COLUMN_TITLE = localStrings.getLocalString("ui.browserpreferences.urls.column_title", "Url");
    private static final String BROWSER_BLANK = " ";
    private UITitledComboBox browserCommand = null;
    private UITitledTextField browserArguments = null;
    private PreferenceTable browserHelpUrls = null;

    public BrowserPreferences(String nodeTitle) {
        super(nodeTitle, true);
        GridBagConstraints gbc = this.getGBConstraints();
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        UITitledBox command = new UITitledBox(BROWSER_COMMAND_TITLE, true);
        this.addWithGBConstraints(command);
        UITitledHTMLText commandHelp = new UITitledHTMLText(null, false);
        command.addWithGBConstraints(commandHelp);
        commandHelp.setText(BROWSER_COMMAND_HELP);
        this.browserCommand = new UITitledComboBox(BROWSER_COMMAND, false);
        this.browserCommand.setEditable(true);
        this.browserCommand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                BrowserPreferences.this.browserArguments.fireUpdate();
                BrowserPreferences.this.browserArguments.setEnabled(!BrowserPreferences.this.browserCommand.isBlank());
            }
        });
        this.browserCommand.setBrowserActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String cmd = BrowserPreferences.this.browseForBrowsers();
                BrowserPreferences.this.browserCommand.setSelectedItem(cmd, true);
            }
        });
        this.browserCommand.setModel(this.getPossibleBrowsers());
        command.addWithGBConstraints(this.browserCommand);
        this.browserArguments = new UITitledTextField(BROWSER_ARGUMENTS, false);
        this.browserArguments.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (BrowserPreferences.this.browserCommand.isBlank()) {
                    BrowserPreferences.this.browserArguments.setText("");
                } else if (BrowserPreferences.this.browserArguments.isBlank()) {
                    String c = BrowserPreferences.this.browserCommand.getText();
                    BrowserPreferences.this.browserArguments.setText(UIBrowser.getDefaultArgumentForBrowserCommand(c));
                }
            }
        });
        command.addWithGBConstraints(this.browserArguments);
        gbc.insets.top = 5;
        UITitledBox helpUrls = new UITitledBox(BROWSER_URLS, true);
        gbc.weighty = 0.5;
        gbc.fill = 1;
        this.addWithGBConstraints(helpUrls);
        UITitledHTMLText urlHelp = new UITitledHTMLText(null, false);
        helpUrls.getGBConstraints().weighty = 0.0;
        helpUrls.addWithGBConstraints(urlHelp);
        urlHelp.setText(BROWSER_URLS_HELP);
        this.browserHelpUrls = new PreferenceTable(null, false, "ui.browser.helpUrls", new String[]{BROWSER_URLS_COLUMN_TITLE});
        this.browserHelpUrls.setRestartRequired(true);
        this.browserHelpUrls.setNewRecordTemplate("");
        this.browserHelpUrls.addEditButtons(13);
        helpUrls.getGBConstraints().weighty = 0.5;
        helpUrls.addWithGBConstraints(this.browserHelpUrls);
    }

    private List getPossibleBrowsers() {
        List br = UIBrowser.getDefaultBrowserCommands();
        br.add(0, BROWSER_BLANK);
        return br;
    }

    private String browseForBrowsers() {
        File startDir = new File(this.browserCommand.getText());
        UIFileChooser jfc = UIFileChooser.getFileChooser(startDir, "AllFiles");
        int rtn = ((JFileChooser)jfc).showDialog(this, CHOOSE_BROWSER_COMMNAD);
        return rtn == 0 ? ((JFileChooser)jfc).getSelectedFile().getAbsolutePath() : null;
    }

    public void refreshConfig() {
        Object[] browse = UIConfig.getConfigArray("ui.browser.openUrlCommand");
        if (browse.length > 0) {
            String cmd = (String)browse[0];
            this.browserCommand.setSelectedItem(cmd, true);
        } else {
            this.browserCommand.setSelectedItem(BROWSER_BLANK, true);
        }
        if (browse.length > 1) {
            String args = UIConfigProperties.arrayToString(browse, 1, false);
            this.browserArguments.setText(args);
        } else {
            this.browserArguments.setText("");
            this.browserArguments.setEnabled(!this.browserCommand.isBlank());
        }
        if (this.browserHelpUrls != null) {
            this.browserHelpUrls.refreshConfig();
        }
    }

    public boolean commitConfig() {
        String br = "(\"" + this.browserCommand.getText() + "\" " + this.browserArguments.getText() + ")";
        UIConfig.setConfigValue("ui.browser.openUrlCommand", br);
        return this.browserHelpUrls != null ? this.browserHelpUrls.commitConfig() : false;
    }
}

