/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.ejb;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.tools.common.cmp.ui.SunOneUtilsCMP;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.cmp.CmpInspectorPane;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.SunONESettingsDialog;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMappings;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;

public class EjbRelationshipsInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbRelationshipsInspector.class);
    private static final String TABNAME = localStrings.getLocalString("ui.ejbrelationshipsinspector.tabname", "Relationships");
    private static final String CONTAINER_MANAGED_RELA = localStrings.getLocalString("ui.ejbrelationshipsinspector.table.title", "Container Managed Relationships");
    private static final String RELA_BIDIRECTION = localStrings.getLocalString("ui.ejbrelationshipsinspector.direction.bi", "Bidirect.");
    private static final String RELA_UNIDIRECTION = localStrings.getLocalString("ui.ejbrelationshipsinspector.direction.uni", "Unidirect.");
    private static final String RELA_TBL_EJB_A = localStrings.getLocalString("ui.ejbrelationshipsinspector.table.ejb_a", "EJB A");
    private static final String RELA_TBL_EJB_B_REF = localStrings.getLocalString("ui.ejbrelationshipsinspector.table.ejb_b_ref", "Bean B Ref");
    private static final String RELA_TBL_EJB_B = localStrings.getLocalString("ui.ejbrelationshipsinspector.table.ejb_b", "EJB B");
    private static final String RELA_TBL_EJB_A_REF = localStrings.getLocalString("ui.ejbrelationshipsinspector.table.ejb_a_ref", "Bean A Ref");
    private static final String RELA_TBL_MULTI = localStrings.getLocalString("ui.ejbrelationshipsinspector.table.multi", "Multi");
    private static final String RELA_TBL_RELATIVE = localStrings.getLocalString("ui.ejbrelationshipsinspector.table.relative", "Relative");
    private static final String RELA_TBL_MULTIPLICITY = localStrings.getLocalString("ui.ejbrelationshipsinspector.table.multiplicity", "Multiplicity");
    private static final String RELA_TBL_DIRECTION = localStrings.getLocalString("ui.ejbrelationshipsinspector.table.direction", "Direction");
    private static final String RELA_TBL_LIFECYCLE = localStrings.getLocalString("ui.ejbrelationshipsinspector.table.lifecycle", "Lifecycle");
    private static final String RELA_TBL_FIELD = localStrings.getLocalString("ui.ejbrelationshipsinspector.table.field", "Field");
    private static final String REL_ONE_ONE = localStrings.getLocalString("ui.ejbrelationshipsinspector.multiplicity.one_2_one", "1:1");
    private static final String REL_ONE_MANY = localStrings.getLocalString("ui.ejbrelationshipsinspector.multiplicity.one_2_many", "1:*");
    private static final String REL_MANY_ONE = localStrings.getLocalString("ui.ejbrelationshipsinspector.multiplicity.many_2_one", "*:1");
    private static final String REL_MANY_MANY = localStrings.getLocalString("ui.ejbrelationshipsinspector.multiplicity.many_2_many", "*:*");
    private static final String MULT_ONE_ONE = localStrings.getLocalString("ui.ejbrelationshipsinspector.multiplicity.cb.one_2_one", "One to One (1:1)");
    private static final String MULT_ONE_MANY = localStrings.getLocalString("ui.ejbrelationshipsinspector.multiplicity.cb.one_2_many", "One to Many (1:*)");
    private static final String MULT_MANY_ONE = localStrings.getLocalString("ui.ejbrelationshipsinspector.multiplicity.cb.many_2_one", "Many to One (*:1)");
    private static final String MULT_MANY_MANY = localStrings.getLocalString("ui.ejbrelationshipsinspector.multiplicity.cb.many_2_many", "Many to Many (*:*)");
    private static final String ADD_RELATIONSHIP = localStrings.getLocalString("ui.ejbrelationshipsinspector.relationship.add_title", "Add Relationship");
    private static final String EDIT_RELATIONSHIP = localStrings.getLocalString("ui.ejbrelationshipsinspector.relationship.edit_title", "Edit Relationship");
    private static final String EJB_A = localStrings.getLocalString("ui.ejbrelationshipsinspector.relationship.ejba.title", "Enterprise Bean A");
    private static final String EJB_A_ACC_DSC = localStrings.getLocalString("at.ejbrelationshipsinspector.relationship.ejba.title.acc_dsc", "Set parameters for Enterprise Bean A in the relationship");
    private static final String EJB_A_NAME = localStrings.getLocalString("ui.ejbrelationshipsinspector.relationship.ejba.name", "Enterprise Bean Name:");
    private static final String EJB_A_NAME_ACC_DSC = localStrings.getLocalString("at.ejbrelationshipsinspector.relationship.ejba.name_tooltip", "Select Enterprise Bean A for the realtionship");
    private static final String EJB_A_REF_B = localStrings.getLocalString("ui.ejbrelationshipsinspector.relationship.ejba.field_ref", "Field Referencing Bean B:");
    private static final String EJB_A_REF_B_ACC_DSC = localStrings.getLocalString("at.ejbrelationshipsinspector.relationship.ejba.field_ref.acc_dsc", "Select field in Bean A referencing Bean B");
    private static final String EJB_A_REF_B_TYPE = localStrings.getLocalString("ui.ejbrelationshipsinspector.relationship.ejba.field_type", "Field Type");
    private static final String EJB_A_REF_B_TYPE_ACC_DSC = localStrings.getLocalString("at.ejbrelationshipsinspector.relationship.ejba.field_type.acc_dsc", "Select type for above referencing field");
    private static final String EJB_A_DEL_ON_B = localStrings.getLocalString("ui.ejbrelationshipsinspector.relationship.ejba.delete", "Delete When Bean B Is Deleted");
    private static final String EJB_A_DEL_ON_B_ACC_DSC = localStrings.getLocalString("at.ejbrelationshipsinspector.relationship.ejba.delete.acc_dsc", "Check if Bean A should be delete when Bean B is Deleted");
    private static final String EJB_B = localStrings.getLocalString("ui.ejbrelationshipsinspector.relationship.ejbb.title", "Enterprise Bean B");
    private static final String EJB_B_ACC_DSC = localStrings.getLocalString("at.ejbrelationshipsinspector.relationship.ejbb.title.acc_dsc", "Set parameters for Enterprise Bean B in the relationship");
    private static final String EJB_B_NAME = localStrings.getLocalString("ui.ejbrelationshipsinspector.relationship.ejbb.name", "Enterprise Bean Name:");
    private static final String EJB_B_NAME_ACC_DSC = localStrings.getLocalString("at.ejbrelationshipsinspector.relationship.ejbb.name.tooltip", "Select Enterprise Bean B for the realtionship");
    private static final String EJB_B_REF_A = localStrings.getLocalString("ui.ejbrelationshipsinspector.relationship.ejbb.field_ref", "Field Referencing Bean A:");
    private static final String EJB_B_REF_A_ACC_DSC = localStrings.getLocalString("at.ejbrelationshipsinspector.relationship.ejbb.field_ref.acc_dsc", "Select field in Bean B referencing Bean A");
    private static final String EJB_B_REF_A_TYPE = localStrings.getLocalString("ui.ejbrelationshipsinspector.relationship.ejbb.field_type", "Field Type");
    private static final String EJB_B_REF_A_TYPE_ACC_DSC = localStrings.getLocalString("at.ejbrelationshipsinspector.relationship.ejbb.field_type.acc_dsc", "Select type for above referencing field");
    private static final String EJB_B_DEL_ON_A = localStrings.getLocalString("ui.ejbrelationshipsinspector.relationship.ejbb.delete", "Delete When Bean A Is Deleted");
    private static final String EJB_B_DEL_ON_A_ACC_DSC = localStrings.getLocalString("at.ejbrelationshipsinspector.relationship.ejbb.delete.acc_dsc", "Check if Bean B should be delete when Bean A is Deleted");
    private static final String EJB_MULTIPLICITY = localStrings.getLocalString("ui.ejbrelationshipsinspector.relationship.multiplicity", "Multiplicity (Bean A : Bean B):");
    private static final String EJB_MULTIPLICITY_ACC_DSC = localStrings.getLocalString("at.ejbrelationshipsinspector.relationship.multiplicity.acc_dsc", "Choose type of multiplicity required between the beans");
    private static final String CASCADE_DELETE = localStrings.getLocalString("ui.ejbrelationshipsinspector.error.casca_dedelete", "ERROR: Cascade-delete can only be specified if the other role has a multiplicity of ONE");
    private static final String CMRFIELD_NAME = localStrings.getLocalString("ui.ejbrelationshipsinspector.error.cmrfield_name", "ERROR: Please select a CMR field name");
    private static final String CMRFIELD_TYPE = localStrings.getLocalString("ui.ejbrelationshipsinspector.error.cmrfield_type", "ERROR: Please select a CMR field type");
    private static final String BEAN_NAME_FIELDS = localStrings.getLocalString("ui.ejbrelationshipsinspector.error.bean_name_fields", "ERROR: Please select an Enterprise Bean Name");
    private static final String CONTAINER_MANAGED_RELA_ACC_DSC = localStrings.getLocalString("at.ejbrelationshipsinspector.table.title.acc_dsc", "Table to manipulate an EJB Jar file's Container Managed Relationships");
    private static final String DESCRIPTION_ACC_DSC = localStrings.getLocalString("at.ejbrelationshipsinspector.relationship.relationship_description.acc_dsc", "Enter description for the relationship");
    private static final String NONE = "<none>";
    private static String DEPLOYMENT_SETTINGS = localStrings.getLocalString("ui.ejbrelationshipsinspector.s1_settings", "Sun-specific Settings...");
    private static char DEPLOYMENT_SETTINGS_MNEMONIC = localStrings.getLocalString("ui.ejbjargeneralinspector.sunone_settings_button_mnemonic", "S").charAt(0);
    private static String wizardHelpID = "Relationships";
    private static String deployHelpID = "Relationships";
    private EjbBundleDescriptor descriptor = null;
    private UITitledTable relTablePanel = null;
    private RelationshipsTable relTable = null;
    private JButton deploymentSettingsPB = null;
    private SunONESettingsDialog sunOneSettingsDialog = null;
    private InspectorPane cmpInspector = null;
    private static final int A_FIELD = 0;
    private static final int B_FIELD = 1;
    private static final String NO_TYPE = "<none>";
    private static final String[] CMRFieldTypes = new String[]{"java.util.Collection", "java.util.Set", "<none>"};
    private RelationshipsDialog relDialog = null;
    private static final String relationshipHelpSetMapID = "Relationship";

    public static InspectorPane newInspectorPane(String mode) {
        return new EjbRelationshipsInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return EjbBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        this.descriptor = desc instanceof EjbBundleDescriptor ? (EjbBundleDescriptor)desc : null;
        this.relTable.clearTableData();
    }

    private EjbRelationshipsInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(CONTAINER_MANAGED_RELA_ACC_DSC);
        this.relTablePanel = new UITitledTable(CONTAINER_MANAGED_RELA, true);
        this.relTable = new RelationshipsTable(new RelationshipsTableModel());
        this.relTable.getAccessibleContext().setAccessibleDescription(CONTAINER_MANAGED_RELA_ACC_DSC);
        this.relTablePanel.setTableView(this.relTable);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.relTablePanel, c);
        UIButton addButton = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EjbRelationshipsInspector.this.addAction();
            }
        }, true);
        this.relTablePanel.addControlButton(addButton);
        UIButton editButton = UIButton.createEditButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EjbRelationshipsInspector.this.editAction();
            }
        }, true);
        this.relTablePanel.addSelectionEnabledButton(editButton);
        UIButton delButton = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EjbRelationshipsInspector.this.deleteAction();
            }
        }, true);
        this.relTablePanel.addSelectionEnabledButton(delButton);
        this.deploymentSettingsPB = new UIButton(DEPLOYMENT_SETTINGS, DEPLOYMENT_SETTINGS_MNEMONIC);
        this.deploymentSettingsPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EjbRelationshipsInspector.this.sunOneSettingsDialog();
            }
        });
        this.deploymentSettingsPB.setEnabled(this.isDeploymentMode());
        this.relTablePanel.addControlButton(this.deploymentSettingsPB);
    }

    private void sunOneSettingsDialog() {
        if (this.sunOneSettingsDialog == null) {
            Frame frame = DT.getApplicationFrame();
            this.sunOneSettingsDialog = new SunONESettingsDialog(frame);
            String mode = "DeploymentMode";
            this.cmpInspector = CmpInspectorPane.newInspectorPane(mode);
            this.sunOneSettingsDialog.addPanel(this, this.cmpInspector);
        }
        this.sunOneSettingsDialog.setAllPanelsEnabled();
        this.sunOneSettingsDialog.show((Descriptor)this.descriptor, null);
    }

    public void refresh() {
        this.relTable.updateTableData(this.descriptor.getRelationships());
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.relTablePanel.setReadOnly(state);
    }

    private void addAction() {
        this.relTable.clearSelection();
        this.showRelationshipsDialog(null);
        this.invokeRefresh();
    }

    private void editAction() {
        Object ref = this.relTable.getSelectedRowObject();
        if (ref != null) {
            this.showRelationshipsDialog((RelationshipDescriptor)ref);
            this.invokeRefresh();
        }
    }

    private void deleteAction() {
        Object[] list = this.relTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                RelationshipDescriptor ref = (RelationshipDescriptor)list[i];
                this.descriptor.removeRelationship(ref);
                SunCmpMappings scms = SunOneUtils.getSunCmpMappings((Descriptor)this.descriptor);
                this.doRelationshipDelete(scms, ref);
            }
        }
        this.invokeRefresh();
    }

    private void validateRelationshipDescriptor(RelationshipDescriptor relDesc) {
        EjbCMPEntityDescriptor sinkDesc;
        EjbCMPEntityDescriptor sorcDesc = relDesc.getSource().getOwner();
        if (sorcDesc instanceof EjbCMPEntityDescriptor) {
            this.checkRelationships(sorcDesc);
        }
        if ((sinkDesc = relDesc.getSink().getOwner()) instanceof EjbCMPEntityDescriptor) {
            this.checkRelationships(sinkDesc);
        }
    }

    private void checkRelationships(EjbCMPEntityDescriptor ejb) {
        EjbBundleDescriptor ebd;
        String n = ejb.getDisplayName();
        PersistenceDescriptor pers = ejb.getPersistenceDescriptor();
        Descriptor owner = pers.getParentDescriptor();
        if (owner != ejb) {
            Print.dprintln((String)("EJB/Parent mismatch: EJB=" + n + ", Parent=" + (owner == null ? "null" : owner.getDisplayName())));
        }
        if ((ebd = pers.getEjbBundleDescriptor()) != this.descriptor) {
            Print.dprintln((String)("Bundle mismatch: EjbBundle=" + this.descriptor.getDisplayName() + ", PersBundle=" + (ebd == null ? "null" : ebd.getDisplayName())));
        }
        Set rels = pers.getRelationships();
        Iterator itr = rels.iterator();
        while (itr.hasNext()) {
            RelationshipDescriptor rd = (RelationshipDescriptor)itr.next();
        }
    }

    private void showRelationshipsDialog(RelationshipDescriptor relDesc) {
        if (this.relDialog == null) {
            Window win = this.getMyParentWindow();
            this.relDialog = win instanceof Frame ? new RelationshipsDialog((Frame)win) : (win instanceof Dialog ? new RelationshipsDialog((Dialog)win) : new RelationshipsDialog((Frame)null));
        }
        this.relDialog.setRelationshipDescriptor(relDesc);
        this.relDialog.centerOnScreen();
        this.relDialog.show();
        if (this.relDialog.isOk()) {
            if (relDesc == null) {
                relDesc = this.relDialog.createRelationshipDescriptor();
                this.validateRelationshipDescriptor(relDesc);
                this.descriptor.addRelationship(relDesc);
            } else {
                this.relDialog.updateRelationshipDescriptor(relDesc);
                this.validateRelationshipDescriptor(relDesc);
            }
        }
    }

    private void doFieldChanges(SunCmpMappings scms, String oldBean, String oldField, String newBean, String newField) {
        String newValue;
        String oldValue = this.makeValue(oldBean, oldField);
        if (oldValue.equals(newValue = this.makeValue(newBean, newField))) {
            return;
        }
        if (null != oldField) {
            SunOneUtilsCMP.removeField(scms, oldBean, oldField, true);
        }
        if ("<none>".equals(newField)) {
            return;
        }
        SunOneUtilsCMP.addField(scms, newBean, newField, true);
    }

    private String makeValue(String f, String b) {
        return f + "::" + (null == b ? "<none>" : b);
    }

    private void doRelationshipDelete(SunCmpMappings scms, RelationshipDescriptor ref) {
        if (null != scms) {
            RelationRoleDescriptor role = ref.getSource();
            String beanName = role.getName();
            String fieldName = role.getCMRField();
            if (null != fieldName) {
                SunOneUtilsCMP.removeField(scms, beanName, fieldName, true);
            }
            role = ref.getSink();
            beanName = role.getName();
            fieldName = role.getCMRField();
            if (null != fieldName) {
                SunOneUtilsCMP.removeField(scms, beanName, fieldName, true);
            }
        }
    }

    private class RelationshipsDialog
    extends UIDialog
    implements ActionListener,
    DescriptionInspector.UpdateListener {
        private RelationshipDescriptor relDesc;
        private UITitledComboBox ejbA_name;
        private UITitledComboBox ejbA_field;
        private UITitledComboBox ejbA_fieldType;
        private JCheckBox ejbA_del;
        private UITitledComboBox ejbB_name;
        private UITitledComboBox ejbB_field;
        private UITitledComboBox ejbB_fieldType;
        private JCheckBox ejbB_del;
        private UITitledComboBox multiplicity;
        private DescriptionInspector.DialogDisplayButton descInspector;
        private String description;
        private boolean isOk;

        public RelationshipsDialog(Frame owner) {
            super(owner, true);
            this.relDesc = null;
            this.ejbA_name = null;
            this.ejbA_field = null;
            this.ejbA_fieldType = null;
            this.ejbA_del = null;
            this.ejbB_name = null;
            this.ejbB_field = null;
            this.ejbB_fieldType = null;
            this.ejbB_del = null;
            this.multiplicity = null;
            this.descInspector = null;
            this.description = "";
            this.isOk = false;
            this.initLayout();
        }

        public RelationshipsDialog(Dialog owner) {
            super(owner, true);
            this.relDesc = null;
            this.ejbA_name = null;
            this.ejbA_field = null;
            this.ejbA_fieldType = null;
            this.ejbA_del = null;
            this.ejbB_name = null;
            this.ejbB_field = null;
            this.ejbB_fieldType = null;
            this.ejbB_del = null;
            this.multiplicity = null;
            this.descInspector = null;
            this.description = "";
            this.isOk = false;
            this.initLayout();
        }

        private void initLayout() {
            UIControlButtonBox dialogView = new UIControlButtonBox(null, false);
            dialogView.setControlButtonLocation(101);
            this.setContentPane(dialogView);
            UITitledBox content = new UITitledBox(null, false);
            dialogView.setView(content);
            GridBagConstraints c = content.getGBConstraints();
            this.multiplicity = new UITitledComboBox(EJB_MULTIPLICITY, false);
            this.multiplicity.getAccessibleContext().setAccessibleDescription(EJB_MULTIPLICITY_ACC_DSC);
            this.multiplicity.setModel(new Object[]{MULT_ONE_ONE, MULT_ONE_MANY, MULT_MANY_ONE, MULT_MANY_MANY});
            this.multiplicity.addActionListener(new ActionListener(this){
                private final /* synthetic */ RelationshipsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    RelationshipsDialog.access$2000(this.this$1, 0, false, false);
                    RelationshipsDialog.access$2100(this.this$1, 0, false, "<none>");
                    RelationshipsDialog.access$2000(this.this$1, 1, false, false);
                    RelationshipsDialog.access$2100(this.this$1, 1, false, "<none>");
                }
            });
            c.weightx = 0.5;
            c.weighty = 0.0;
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 2;
            c.insets = new Insets(5, 5, 5, 5);
            content.add((Component)this.multiplicity, c);
            UITitledBox descBox = new UITitledBox(" ", false);
            c.weightx = 0.5;
            c.weighty = 0.0;
            c.gridx = 1;
            c.gridy = 0;
            c.fill = 2;
            c.insets = new Insets(5, 5, 5, 5);
            content.add((Component)descBox, c);
            this.descInspector = new DescriptionInspector.DialogDisplayButton(false);
            this.descInspector.getAccessibleContext().setAccessibleDescription(DESCRIPTION_ACC_DSC);
            descBox.addWithGBConstraints(this.descInspector);
            UITitledBox ejbA = new UITitledBox(EJB_A, true);
            ejbA.getAccessibleContext().setAccessibleDescription(EJB_A_ACC_DSC);
            c.weightx = 0.5;
            c.weighty = 0.5;
            c.gridx = 0;
            c.gridy = 1;
            c.fill = 1;
            c.insets = new Insets(5, 5, 5, 5);
            content.add((Component)ejbA, c);
            this.ejbA_name = new UITitledComboBox(EJB_A_NAME, false);
            this.ejbA_name.getAccessibleContext().setAccessibleDescription(EJB_A_NAME_ACC_DSC);
            ejbA.addWithGBConstraints(this.ejbA_name);
            this.ejbA_name.addActionListener(new ActionListener(this){
                private final /* synthetic */ RelationshipsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    RelationshipsDialog.access$2800(this.this$1).setModel(this.this$1.refreshItemsForField((String)RelationshipsDialog.access$2700(this.this$1).getSelectedItem()));
                }
            });
            this.ejbA_field = new UITitledComboBox(EJB_A_REF_B, false);
            this.ejbA_field.getAccessibleContext().setAccessibleDescription(EJB_A_REF_B_ACC_DSC);
            ejbA.addWithGBConstraints(this.ejbA_field);
            this.ejbA_field.addActionListener(new ActionListener(this){
                private final /* synthetic */ RelationshipsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    RelationshipsDialog.access$2100(this.this$1, 0, false, "<none>");
                }
            });
            this.ejbA_fieldType = new UITitledComboBox(EJB_A_REF_B_TYPE, false);
            this.ejbA_fieldType.getAccessibleContext().setAccessibleDescription(EJB_A_REF_B_TYPE_ACC_DSC);
            ejbA.addWithGBConstraints(this.ejbA_fieldType);
            this.ejbA_fieldType.setClearWhenDisabled(true);
            this.ejbA_fieldType.setModel(CMRFieldTypes);
            this.ejbA_del = new UICheckBox(EJB_A_DEL_ON_B);
            this.ejbA_del.getAccessibleContext().setAccessibleDescription(EJB_A_DEL_ON_B_ACC_DSC);
            ejbA.addWithGBConstraints(this.ejbA_del);
            UITitledBox ejbB = new UITitledBox(EJB_B, true);
            ejbB.getAccessibleContext().setAccessibleDescription(EJB_B_ACC_DSC);
            c.weightx = 0.5;
            c.weighty = 0.5;
            c.gridx = 1;
            c.gridy = 1;
            c.fill = 1;
            c.insets = new Insets(5, 5, 5, 5);
            content.add((Component)ejbB, c);
            this.ejbB_name = new UITitledComboBox(EJB_B_NAME, false);
            this.ejbB_name.getAccessibleContext().setAccessibleDescription(EJB_B_NAME_ACC_DSC);
            ejbB.addWithGBConstraints(this.ejbB_name);
            this.ejbB_name.addActionListener(new ActionListener(this){
                private final /* synthetic */ RelationshipsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    RelationshipsDialog.access$4100(this.this$1).setModel(this.this$1.refreshItemsForField((String)RelationshipsDialog.access$4000(this.this$1).getSelectedItem()));
                }
            });
            this.ejbB_field = new UITitledComboBox(EJB_B_REF_A, false);
            this.ejbB_field.getAccessibleContext().setAccessibleDescription(EJB_B_REF_A_ACC_DSC);
            ejbB.addWithGBConstraints(this.ejbB_field);
            this.ejbB_field.addActionListener(new ActionListener(this){
                private final /* synthetic */ RelationshipsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    RelationshipsDialog.access$2100(this.this$1, 1, false, "<none>");
                }
            });
            this.ejbB_fieldType = new UITitledComboBox(EJB_B_REF_A_TYPE, false);
            this.ejbB_fieldType.getAccessibleContext().setAccessibleDescription(EJB_B_REF_A_TYPE_ACC_DSC);
            ejbB.addWithGBConstraints(this.ejbB_fieldType);
            this.ejbB_fieldType.setClearWhenDisabled(true);
            this.ejbB_fieldType.setModel(CMRFieldTypes);
            this.ejbB_del = new UICheckBox(EJB_B_DEL_ON_A);
            this.ejbB_del.getAccessibleContext().setAccessibleDescription(EJB_B_DEL_ON_A_ACC_DSC);
            ejbB.addWithGBConstraints(this.ejbB_del);
            dialogView.addControlButton(UIButton.createOkButton(this));
            dialogView.addControlButton(UIButton.createCancelButton(this));
            UIHelpButton helpPB = new UIHelpButton(EjbRelationshipsInspector.relationshipHelpSetMapID);
            dialogView.addControlButton(helpPB);
            this.pack();
            this.setSize(700, this.getSize().height);
        }

        public void actionPerformed(ActionEvent ae) {
            boolean ok = ae.getActionCommand().equals("ok");
            if (!ok || this.validateFields()) {
                this.isOk = ok;
                this.descInspector.clearDescriptionInspector();
                this.hide();
            }
        }

        private boolean sourceIsMany() {
            String m = (String)this.multiplicity.getSelectedItem();
            return m.equals(MULT_MANY_ONE) || m.equals(MULT_MANY_MANY);
        }

        private boolean sinkIsMany() {
            String m = (String)this.multiplicity.getSelectedItem();
            return m.equals(MULT_ONE_MANY) || m.equals(MULT_MANY_MANY);
        }

        private void enableFieldType(int field, boolean setSel, String dftType) {
            if (field == 0) {
                String A_field;
                String string = A_field = this.sinkIsMany() ? (String)this.ejbA_field.getSelectedItem() : null;
                if (A_field == null || A_field.equals("<none>")) {
                    this.ejbA_fieldType.setSelectedItem("<none>");
                    this.ejbA_fieldType.setEnabled(false);
                } else if (!this.ejbA_fieldType.isEnabled()) {
                    this.ejbA_fieldType.setEnabled(true);
                    this.ejbA_fieldType.setSelectedItem(dftType != null ? dftType : "<none>");
                } else if (setSel || this.ejbA_fieldType.getSelectedItem() == null) {
                    this.ejbA_fieldType.setSelectedItem(dftType != null ? dftType : "<none>");
                }
            } else if (field == 1) {
                String B_field;
                String string = B_field = this.sourceIsMany() ? (String)this.ejbB_field.getSelectedItem() : null;
                if (B_field == null || B_field.equals("<none>")) {
                    this.ejbB_fieldType.setSelectedItem("<none>");
                    this.ejbB_fieldType.setEnabled(false);
                } else if (!this.ejbB_fieldType.isEnabled()) {
                    this.ejbB_fieldType.setEnabled(true);
                    this.ejbB_fieldType.setSelectedItem(dftType != null ? dftType : "<none>");
                } else if (setSel || this.ejbB_fieldType.getSelectedItem() == null) {
                    this.ejbB_fieldType.setSelectedItem(dftType != null ? dftType : "<none>");
                }
            }
        }

        private void enableCascadeDelete(int field, boolean setSel, boolean dftVal) {
            if (field == 0) {
                if (this.sinkIsMany()) {
                    this.ejbA_del.setSelected(false);
                    this.ejbA_del.setEnabled(false);
                } else if (!this.ejbA_del.isEnabled()) {
                    this.ejbA_del.setEnabled(true);
                    this.ejbA_del.setSelected(dftVal);
                } else if (setSel) {
                    this.ejbA_del.setSelected(dftVal);
                }
            } else if (field == 1) {
                if (this.sourceIsMany()) {
                    this.ejbB_del.setSelected(false);
                    this.ejbB_del.setEnabled(false);
                } else if (!this.ejbB_del.isEnabled()) {
                    this.ejbB_del.setEnabled(true);
                    this.ejbB_del.setSelected(dftVal);
                } else if (setSel) {
                    this.ejbB_del.setSelected(dftVal);
                }
            }
        }

        private boolean validateFields() {
            String B_type;
            boolean A_isMany = this.sourceIsMany();
            boolean B_isMany = this.sinkIsMany();
            if (this.ejbA_name.getText().equals("") || this.ejbB_name.getText().equals("")) {
                Object v;
                UIOptionPane.showErrorDialog(this, BEAN_NAME_FIELDS);
                if (this.ejbA_name.getText().equals("")) {
                    v = this.ejbA_field.getItemAt(0);
                    this.ejbA_field.setSelectedItem(v != null ? v : "<none>");
                    this.enableFieldType(0, false, "<none>");
                }
                if (this.ejbB_name.getText().equals("")) {
                    v = this.ejbB_field.getItemAt(0);
                    this.ejbB_field.setSelectedItem(v != null ? v : "<none>");
                    this.enableFieldType(1, false, "<none>");
                }
                return false;
            }
            String A_field = (String)this.ejbA_field.getSelectedItem();
            String B_field = (String)this.ejbB_field.getSelectedItem();
            if ((A_field == null || A_field.equals("<none>")) && (B_field == null || B_field.equals("<none>"))) {
                UIOptionPane.showErrorDialog(this, CMRFIELD_NAME);
                return false;
            }
            String A_type = B_isMany && !A_field.equals("<none>") ? this.ejbA_fieldType.getText() : null;
            String string = B_type = A_isMany && !B_field.equals("<none>") ? this.ejbB_fieldType.getText() : null;
            if (A_type != null && A_type.equals("<none>") || B_type != null && B_type.equals("<none>")) {
                UIOptionPane.showErrorDialog(this, CMRFIELD_TYPE);
                return false;
            }
            if (!A_isMany && B_isMany) {
                if (this.ejbA_del.isSelected()) {
                    UIOptionPane.showErrorDialog(this, CASCADE_DELETE);
                    return false;
                }
            } else if (A_isMany && !B_isMany) {
                if (this.ejbB_del.isSelected()) {
                    UIOptionPane.showErrorDialog(this, CASCADE_DELETE);
                    return false;
                }
            } else if (A_isMany && B_isMany && (this.ejbA_del.isSelected() || this.ejbB_del.isSelected())) {
                UIOptionPane.showErrorDialog(this, CASCADE_DELETE);
                return false;
            }
            return true;
        }

        public Vector refreshItemsForField(String ejb) {
            Vector<String> fieldItems = new Vector<String>();
            Vector fd = null;
            Iterator itr = EjbRelationshipsInspector.this.descriptor.getEjbs().iterator();
            while (itr.hasNext()) {
                EjbDescriptor desc = (EjbDescriptor)itr.next();
                if (!desc.getDisplayName().equals(ejb)) continue;
                fd = desc.getFieldDescriptors();
                if (fd != null) {
                    Iterator itr1 = fd.iterator();
                    while (itr1.hasNext()) {
                        FieldDescriptor next = (FieldDescriptor)itr1.next();
                        fieldItems.addElement(next.getDisplayName());
                    }
                    break;
                }
                Print.dprintln((String)"fdSet is null for EJB");
                break;
            }
            fieldItems.addElement("<none>");
            return fieldItems;
        }

        public void setRelationshipDescriptor(RelationshipDescriptor rel) {
            this.relDesc = rel;
            Object fd = null;
            Vector fields = new Vector();
            Set ejbs = EjbRelationshipsInspector.this.descriptor.getEjbs();
            Vector<String> obj = new Vector<String>();
            Iterator itr = ejbs.iterator();
            while (itr.hasNext()) {
                EjbDescriptor next = (EjbDescriptor)itr.next();
                if (!(next instanceof EjbCMPEntityDescriptor) || !((EjbCMPEntityDescriptor)next).isEJB20()) continue;
                obj.addElement(next.getDisplayName());
            }
            this.ejbA_name.setModel(obj);
            this.ejbB_name.setModel(obj);
            if (this.relDesc != null) {
                this.setTitle(EDIT_RELATIONSHIP);
                this.descInspector.setDescriptionInspector(this.relDesc.getDescription(), this.relDesc.getDisplayName(), this, this.relDesc);
                this.ejbA_name.setSelectedItem(this.relDesc.getSource().getOwner().getDisplayName());
                this.ejbB_name.setSelectedItem(this.relDesc.getSink().getOwner().getDisplayName());
                boolean A_isMany = this.relDesc.getSource().getIsMany();
                boolean B_isMany = this.relDesc.getSink().getIsMany();
                boolean A_del = false;
                boolean B_del = false;
                if (A_isMany && B_isMany) {
                    this.multiplicity.setSelectedItem(MULT_MANY_MANY);
                } else if (!A_isMany && B_isMany) {
                    this.multiplicity.setSelectedItem(MULT_ONE_MANY);
                    B_del = this.relDesc.getSink().getCascadeDelete();
                } else if (A_isMany && !B_isMany) {
                    this.multiplicity.setSelectedItem(MULT_MANY_ONE);
                    A_del = this.relDesc.getSource().getCascadeDelete();
                } else if (!A_isMany && !B_isMany) {
                    this.multiplicity.setSelectedItem(MULT_ONE_ONE);
                    A_del = this.relDesc.getSource().getCascadeDelete();
                    B_del = this.relDesc.getSink().getCascadeDelete();
                }
                this.enableCascadeDelete(0, true, A_del);
                this.enableCascadeDelete(1, true, B_del);
                this.ejbA_field.setModel(this.refreshItemsForField((String)this.ejbA_name.getSelectedItem()));
                if (this.relDesc.getSource().getCMRField() != null) {
                    this.ejbA_field.setSelectedItem(this.relDesc.getSource().getCMRField());
                    this.enableFieldType(0, true, this.relDesc.getSource().getCMRFieldType());
                } else {
                    this.ejbA_field.setSelectedItem("<none>");
                    this.enableFieldType(0, true, "<none>");
                }
                this.ejbB_field.setModel(this.refreshItemsForField((String)this.ejbB_name.getSelectedItem()));
                if (this.relDesc.getSink().getCMRField() != null) {
                    this.ejbB_field.setSelectedItem(this.relDesc.getSink().getCMRField());
                    this.enableFieldType(1, true, this.relDesc.getSink().getCMRFieldType());
                } else {
                    this.ejbB_field.setSelectedItem("<none>");
                    this.enableFieldType(1, true, "<none>");
                }
            } else {
                this.setTitle(ADD_RELATIONSHIP);
                this.descInspector.setDescriptionInspector("", "", this, null);
                this.multiplicity.setSelectedItem(MULT_ONE_ONE);
                String A_name = (String)this.ejbA_name.getItemAt(0);
                this.ejbA_name.setSelectedItem(A_name);
                this.ejbA_field.setModel(this.refreshItemsForField(A_name));
                String A_field = "<none>";
                this.ejbA_field.setSelectedItem(A_field);
                this.enableFieldType(0, true, "<none>");
                this.enableCascadeDelete(0, true, false);
                String B_name = (String)this.ejbB_name.getItemAt(0);
                this.ejbB_name.setSelectedItem(B_name);
                this.ejbB_field.setModel(this.refreshItemsForField(B_name));
                String B_field = "<none>";
                this.ejbB_field.setSelectedItem(B_field);
                this.enableFieldType(1, true, "<none>");
                this.enableCascadeDelete(1, true, false);
            }
        }

        public void show() {
            this.isOk = false;
            super.show();
        }

        public boolean isOk() {
            return this.isOk;
        }

        public void descriptionUpdated(String description, Object ref) {
            this.description = description;
        }

        public RelationshipDescriptor createRelationshipDescriptor() {
            RelationshipDescriptor ref = new RelationshipDescriptor();
            RelationRoleDescriptor source = new RelationRoleDescriptor();
            RelationRoleDescriptor sink = new RelationRoleDescriptor();
            source.setRelationshipDescriptor(ref);
            sink.setRelationshipDescriptor(ref);
            source.setPartner(sink);
            sink.setPartner(source);
            ref.setSource(source);
            ref.setSink(sink);
            ref = this.setCommonDescriptorFields(ref);
            return ref;
        }

        public void updateRelationshipDescriptor(RelationshipDescriptor rel) {
            this.relDesc = this.setCommonDescriptorFields(rel);
        }

        private RelationshipDescriptor setCommonDescriptorFields(RelationshipDescriptor ref) {
            RelationRoleDescriptor source = ref.getSource();
            RelationRoleDescriptor sink = ref.getSink();
            boolean A_isMany = this.sourceIsMany();
            boolean B_isMany = this.sinkIsMany();
            String A_name = this.ejbA_name.getText();
            EjbDescriptor A_desc = EjbRelationshipsInspector.this.descriptor.getEjbByName(A_name);
            if (A_desc == null) {
                Print.printStackTrace((String)("[A] Can't find source descriptor: " + A_name));
                return null;
            }
            PersistenceDescriptor A_pers = this.getPersistenceDescFromOwner((Descriptor)A_desc);
            if (A_pers == null) {
                Print.dprintStackTrace((String)"[A] No PersistenceDescriptor!");
            }
            String A_field = this.ejbA_field.getText();
            String A_type = B_isMany && !A_field.equals("<none>") ? this.ejbA_fieldType.getText() : "<none>";
            boolean A_delete = this.ejbA_del.isSelected();
            String B_name = this.ejbB_name.getText();
            EjbDescriptor B_desc = EjbRelationshipsInspector.this.descriptor.getEjbByName(B_name);
            if (B_desc == null) {
                Print.printStackTrace((String)("[B] Can't find sink descriptor: " + B_name));
                return null;
            }
            PersistenceDescriptor B_pers = this.getPersistenceDescFromOwner((Descriptor)B_desc);
            if (B_pers == null) {
                Print.dprintStackTrace((String)"[B] No PersistenceDescriptor!");
            }
            String B_field = this.ejbB_field.getText();
            String B_type = A_isMany && !B_field.equals("<none>") ? this.ejbB_fieldType.getText() : "<none>";
            boolean B_delete = this.ejbB_del.isSelected();
            SunCmpMappings scms = SunOneUtils.getSunCmpMappings((Descriptor)EjbRelationshipsInspector.this.descriptor);
            EjbRelationshipsInspector.this.doFieldChanges(scms, source.getName(), source.getCMRField(), A_name, A_field);
            EjbRelationshipsInspector.this.doFieldChanges(scms, sink.getName(), sink.getCMRField(), B_name, B_field);
            if (null != scms) {
                SunOneUtils.setSunCmpMappings((Descriptor)EjbRelationshipsInspector.this.descriptor, scms);
            }
            String desc = this.description;
            if (A_desc instanceof EjbCMPEntityDescriptor) {
                source.setOwner((EjbCMPEntityDescriptor)A_desc);
            } else {
                Print.dprintln((String)"[A] Not an EjbCMPEntityDescriptor!");
            }
            source.setPersistenceDescriptor(A_pers);
            source.setName(A_name);
            if (B_desc instanceof EjbCMPEntityDescriptor) {
                sink.setOwner((EjbCMPEntityDescriptor)B_desc);
            } else {
                Print.dprintln((String)"[B] Not an EjbCMPEntityDescriptor!");
            }
            sink.setPersistenceDescriptor(B_pers);
            sink.setName(B_name);
            ref.setIsBidirectional(!A_field.equals("<none>") && !B_field.equals("<none>"));
            source.setCMRField(A_field.equals("<none>") ? null : A_field);
            sink.setCMRField(B_field.equals("<none>") ? null : B_field);
            source.setCMRFieldType(A_type.equals("<none>") ? null : A_type);
            sink.setCMRFieldType(B_type.equals("<none>") ? null : B_type);
            ref.setDescription(desc);
            if (!A_isMany && !B_isMany) {
                source.setIsMany(false);
                sink.setIsMany(false);
            } else if (!A_isMany && B_isMany) {
                source.setIsMany(false);
                sink.setIsMany(true);
            } else if (A_isMany && !B_isMany) {
                source.setIsMany(true);
                sink.setIsMany(false);
            } else if (A_isMany && B_isMany) {
                source.setIsMany(true);
                sink.setIsMany(true);
            }
            if (A_delete && !B_isMany) {
                source.setCascadeDelete(true);
            } else {
                source.setCascadeDelete(false);
            }
            if (B_delete && !A_isMany) {
                sink.setCascadeDelete(true);
            } else {
                sink.setCascadeDelete(false);
            }
            return ref;
        }

        private PersistenceDescriptor getPersistenceDescFromOwner(Descriptor relOwner) {
            PersistenceDescriptor pers = null;
            if (relOwner instanceof EjbCMPEntityDescriptor) {
                pers = ((EjbCMPEntityDescriptor)relOwner).getPersistenceDescriptor();
            }
            return pers;
        }

        static /* synthetic */ void access$2000(RelationshipsDialog x0, int x1, boolean x2, boolean x3) {
            x0.enableCascadeDelete(x1, x2, x3);
        }

        static /* synthetic */ void access$2100(RelationshipsDialog x0, int x1, boolean x2, String x3) {
            x0.enableFieldType(x1, x2, x3);
        }

        static /* synthetic */ UITitledComboBox access$2700(RelationshipsDialog x0) {
            return x0.ejbA_name;
        }

        static /* synthetic */ UITitledComboBox access$2800(RelationshipsDialog x0) {
            return x0.ejbA_field;
        }

        static /* synthetic */ UITitledComboBox access$4000(RelationshipsDialog x0) {
            return x0.ejbB_name;
        }

        static /* synthetic */ UITitledComboBox access$4100(RelationshipsDialog x0) {
            return x0.ejbB_field;
        }
    }

    private class RelationshipsTableModel
    extends InspectorTableModel {
        public RelationshipsTableModel() {
            super(new String[]{RELA_TBL_EJB_A, RELA_TBL_EJB_B_REF, RELA_TBL_MULTI, RELA_TBL_EJB_B, RELA_TBL_EJB_A_REF, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public Object getObjectValue(Object obj, int col) {
            RelationshipDescriptor rel = (RelationshipDescriptor)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = rel.getSource().getOwner().getDisplayName();
                    break;
                }
                case 1: {
                    value = rel.getSource().getCMRField() != null ? rel.getSource().getCMRField() : "<none>";
                    break;
                }
                case 2: {
                    if (rel.isOneOne()) {
                        value = REL_ONE_ONE;
                        break;
                    }
                    if (rel.isOneMany()) {
                        value = REL_ONE_MANY;
                        break;
                    }
                    if (rel.isManyOne()) {
                        value = REL_MANY_ONE;
                        break;
                    }
                    if (!rel.isManyMany()) break;
                    value = REL_MANY_MANY;
                    break;
                }
                case 3: {
                    value = rel.getSink().getOwner().getDisplayName();
                    break;
                }
                case 4: {
                    value = rel.getSink().getCMRField() != null ? rel.getSink().getCMRField() : "<none>";
                    break;
                }
                case 5: {
                    value = rel.getDescription();
                }
            }
            return value;
        }

        public boolean isCellEditable(int row, int col) {
            if (this.isReadOnly()) {
                return false;
            }
            return col == 5;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            RelationshipDescriptor rel = (RelationshipDescriptor)obj;
            switch (col) {
                case 5: {
                    rel.setDescription(value.toString());
                }
            }
            EjbRelationshipsInspector.this.descriptor.changed();
        }
    }

    private class RelationshipsTable
    extends InspectorTable {
        public RelationshipsTable(RelationshipsTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
            InspectorTable.TableIconCellRenderer ticr = new InspectorTable.TableIconCellRenderer();
            ticr.addIconMap(REL_ONE_ONE, UIIcons.getImageIconFor(UIIcons.MULTIPLICITY_1_1));
            ticr.addIconMap(REL_ONE_MANY, UIIcons.getImageIconFor(UIIcons.MULTIPLICITY_1_M));
            ticr.addIconMap(REL_MANY_ONE, UIIcons.getImageIconFor(UIIcons.MULTIPLICITY_M_1));
            ticr.addIconMap(REL_MANY_MANY, UIIcons.getImageIconFor(UIIcons.MULTIPLICITY_M_M));
            this.getColumn(2).setCellRenderer(ticr);
        }
    }
}

