/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.ejb;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.common.dd.ejb.CheckpointAtEndOfMethod;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ejb.Method;
import com.sun.enterprise.tools.common.dd.ejb.MethodParams;
import com.sun.enterprise.tools.deployment.ui.ejb.MethodInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Set;
import java.util.Vector;

public class CheckpointedMethodInspector
extends MethodInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CheckpointedMethodInspector.class);
    private static String TABNAME = localStrings.getLocalString("ui.checkpointedmethodinspector.tabname", "Checkpointed Methods");
    private static final String AVAILABILITY = localStrings.getLocalString("ui.checkpointedmethodinspector.availability", "Availability:");
    private static final String AVAILABILITY_ACC_DSC = localStrings.getLocalString("ui.checkpointedmethodinspector.availability.acc_dsc", "Choose an option to derive, enable, or disable availability in this stateful session bean.");
    private static final String AVAILABILITY_MN = localStrings.getLocalString("ui.checkpointedmethodinspector.availability.mnemonic", "A");
    private static final String DERIVED = localStrings.getLocalString("ui.checkpointedmethodinspector.derived_option", "Derived");
    private static final String TRUE = localStrings.getLocalString("ui.checkpointedmethodinspector.true_option", "True");
    private static final String FALSE = localStrings.getLocalString("ui.checkpointedmethodinspector.false_option", "False");
    private static final String CHKPT_METH_ACC_DSC = localStrings.getLocalString("ui.checkpointedmethodinspector.checkpointed_method.acc_dsc", "Set EJB methods to be checkpointed.");
    private static final String CHECKPOINT_COLUMN = localStrings.getLocalString("ui.checkpointedmethodinspector.checkpoint_column", "<HTML>&nbsp;Checkpoint&nbsp;</HTML>");
    private static final String METHOD_COLUMN = localStrings.getLocalString("ui.checkpointedmethodinspector.method_column", "Method");
    private static final String SHOW_INTERFACES = localStrings.getLocalString("ui.checkpointedmethodinspector.show_interface", "Show:");
    private static final String SHOW_INTERFACES_ACC_DSC = localStrings.getLocalString("ui.checkpointedmethodinspector.show_interface.acc_dsc", "Choose interfaces to expose");
    private static final String SHOW_INTERFACES_MN = localStrings.getLocalString("ui.checkpointedmethodinspector.show_interface.mnemonic", "S");
    private static final String SHOW_LOCAL = localStrings.getLocalString("ui.checkpointedmethodinspector.local", "Local Methods");
    private static final String SHOW_LOCAL_HOME = localStrings.getLocalString("ui.checkpointedmethodinspector.local_home", "Local Home Methods");
    private static final String SHOW_REMOTE = localStrings.getLocalString("ui.checkpointedmethodinspector.remote", "Remote Methods");
    private static final String SHOW_REMOTE_HOME = localStrings.getLocalString("ui.checkpointedmethodinspector.remote_home", "Remote Home Methods");
    private static String HELP_ID = "Checkpoint";
    private InspectorPane inspectorPane = null;
    private EjbSessionDescriptor descriptor = null;
    private Set mdSet = null;
    private Ejb ejb = null;
    private CheckpointAtEndOfMethod checkpoint = null;
    private Method[] methodArray = null;
    private MethodParams params = null;
    static Object[] INTERFACE_OPTIONS = new Object[]{SHOW_LOCAL, SHOW_LOCAL_HOME, SHOW_REMOTE, SHOW_REMOTE_HOME};
    private static Object[] AVAILABILITY_OPTIONS = new Object[]{DERIVED, TRUE, FALSE};
    private UITitledComboBox availability = null;
    private UITitledComboBox showInterfaces = null;
    private UITitledTable checkpointPanel = null;
    private CheckpointTable checkpointTable = null;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbSessionDescriptor;

    public static InspectorPane newInspectorPane(String mode) {
        return new CheckpointedMethodInspector().inspectorPane;
    }

    String[] initIntfOptions() {
        ArrayList<String> list = new ArrayList<String>();
        Set intfNames = this.getAvailableInterfaces();
        if (intfNames.contains(MethodDescriptor.EJB_LOCAL)) {
            list.add(SHOW_LOCAL);
        }
        if (intfNames.contains(MethodDescriptor.EJB_LOCALHOME)) {
            list.add(SHOW_LOCAL_HOME);
        }
        if (intfNames.contains(MethodDescriptor.EJB_REMOTE)) {
            list.add(SHOW_REMOTE);
        }
        if (intfNames.contains(MethodDescriptor.EJB_HOME)) {
            list.add(SHOW_REMOTE_HOME);
        }
        return list.toArray(new String[list.size()]);
    }

    private void setMDSet() {
        try {
            this.mdSet = this.descriptor.getMethodDescriptors();
        }
        catch (Throwable e) {
            Print.printStackTrace((String)"Getting method descriptors", (Throwable)e);
            UIOptionPane.showErrorDialog(this.inspectorPane, CheckpointedMethodInspector.GET_METH_ERROR(this.descriptor.getDisplayName(), e.toString()));
        }
    }

    public CheckpointedMethodInspector() {
        if (this.inspectorPane == null) {
            this.inspectorPane = new InspectorPane(){

                public String getHelpID() {
                    return HELP_ID;
                }

                public String getTabName() {
                    return TABNAME;
                }

                public Descriptor getDescriptor() {
                    return CheckpointedMethodInspector.this.descriptor;
                }

                public Class getDescriptorClass() {
                    return class$com$sun$enterprise$deployment$EjbSessionDescriptor == null ? (class$com$sun$enterprise$deployment$EjbSessionDescriptor = CheckpointedMethodInspector.class$("com.sun.enterprise.deployment.EjbSessionDescriptor")) : class$com$sun$enterprise$deployment$EjbSessionDescriptor;
                }

                public void setDescriptor(Descriptor d) {
                    if (d instanceof EjbSessionDescriptor) {
                        CheckpointedMethodInspector.this.descriptor = (EjbSessionDescriptor)d;
                        CheckpointedMethodInspector.this.setMDSet();
                        CheckpointedMethodInspector.this.checkpointTable.clearTableData();
                        CheckpointedMethodInspector.this.ejb = (Ejb)SunOneUtils.getSunDescriptor((Descriptor)CheckpointedMethodInspector.this.descriptor);
                        CheckpointedMethodInspector.this.checkpoint = CheckpointedMethodInspector.this.ejb.getCheckpointAtEndOfMethod();
                        if (CheckpointedMethodInspector.this.checkpoint != null) {
                            CheckpointedMethodInspector.access$702(CheckpointedMethodInspector.this, CheckpointedMethodInspector.this.checkpoint.getMethod());
                        } else {
                            CheckpointedMethodInspector.access$702(CheckpointedMethodInspector.this, null);
                        }
                        CheckpointedMethodInspector.this.initMethods(CheckpointedMethodInspector.this.mdSet, CheckpointedMethodInspector.this.methodArray);
                        if (CheckpointedMethodInspector.this.showInterfaces != null) {
                            CheckpointedMethodInspector.this.showInterfaces.setModel(CheckpointedMethodInspector.this.initIntfOptions());
                        }
                    }
                }

                protected void refresh() {
                    if (CheckpointedMethodInspector.this.descriptor == null) {
                        return;
                    }
                    String avail = CheckpointedMethodInspector.this.ejb.getAvailabilityEnabled();
                    if (avail == null) {
                        CheckpointedMethodInspector.this.availability.setSelectedItem(DERIVED);
                        CheckpointedMethodInspector.this.showInterfaces.setEnabled(true);
                        CheckpointedMethodInspector.this.checkpointTable.setEnabled(true);
                        CheckpointedMethodInspector.this.checkpointPanel.setReadOnly(false);
                    } else if (avail.equals(Boolean.TRUE.toString())) {
                        CheckpointedMethodInspector.this.availability.setSelectedItem(TRUE);
                        CheckpointedMethodInspector.this.showInterfaces.setEnabled(true);
                        CheckpointedMethodInspector.this.checkpointTable.setEnabled(true);
                        CheckpointedMethodInspector.this.checkpointPanel.setReadOnly(false);
                    } else {
                        if (avail.equals(Boolean.FALSE.toString())) {
                            CheckpointedMethodInspector.this.availability.setSelectedItem(FALSE);
                            CheckpointedMethodInspector.this.showInterfaces.setEnabled(false);
                            CheckpointedMethodInspector.this.checkpointTable.setEnabled(false);
                            CheckpointedMethodInspector.this.checkpointPanel.setReadOnly(true);
                            return;
                        }
                        CheckpointedMethodInspector.this.availability.setSelectedIndex(-1);
                        CheckpointedMethodInspector.this.showInterfaces.setEnabled(false);
                        CheckpointedMethodInspector.this.checkpointTable.setEnabled(false);
                        CheckpointedMethodInspector.this.checkpointPanel.setReadOnly(true);
                    }
                    CheckpointedMethodInspector.this.checkpointTable.setModel(new CheckpointTableModel());
                    CheckpointedMethodInspector.this.checkpointTable.updateTableData(CheckpointedMethodInspector.this.getMethodsForSelIntf());
                }
            };
        }
        this.initLayout();
    }

    private void initLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.inspectorPane.setLayout(new GridBagLayout());
        this.availability = new UITitledComboBox(AVAILABILITY);
        this.availability.setMnemonic(AVAILABILITY_MN.charAt(0));
        this.availability.setModel(AVAILABILITY_OPTIONS);
        this.availability.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String s = (String)CheckpointedMethodInspector.this.availability.getSelectedItem();
                if (s.equals(DERIVED)) {
                    CheckpointedMethodInspector.this.ejb.setAvailabilityEnabled(null);
                } else if (s.equals(TRUE)) {
                    CheckpointedMethodInspector.this.ejb.setAvailabilityEnabled(Boolean.TRUE.toString());
                } else if (s.equals(FALSE)) {
                    CheckpointedMethodInspector.this.ejb.setAvailabilityEnabled(Boolean.FALSE.toString());
                }
                CheckpointedMethodInspector.this.inspectorPane.invokeRefresh();
            }
        });
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 0;
        c.anchor = 17;
        this.inspectorPane.add((Component)this.availability, c);
        this.showInterfaces = new UITitledComboBox(SHOW_INTERFACES, false);
        this.showInterfaces.getAccessibleContext().setAccessibleDescription(SHOW_INTERFACES_ACC_DSC);
        this.showInterfaces.setMnemonic(SHOW_INTERFACES_MN.charAt(0));
        this.showInterfaces.setModel(INTERFACE_OPTIONS);
        this.showInterfaces.setClearWhenDisabled(true);
        this.showInterfaces.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                CheckpointedMethodInspector.this.inspectorPane.invokeRefresh();
            }
        });
        c.gridx = 0;
        c.gridy = 1;
        this.inspectorPane.add((Component)this.showInterfaces, c);
        this.checkpointPanel = new UITitledTable(null, false);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 1;
        c.anchor = 10;
        this.inspectorPane.add((Component)this.checkpointPanel, c);
        this.checkpointTable = new CheckpointTable(new CheckpointTableModel());
        this.checkpointTable.getAccessibleContext().setAccessibleDescription(CHKPT_METH_ACC_DSC);
        this.checkpointPanel.setTableView(this.checkpointTable);
    }

    private Set getMethodsForSelIntf() {
        String selIntf = (String)this.showInterfaces.getSelectedItem();
        Set set = null;
        if (selIntf == null) {
            if (this.descriptor.getLocalClassName() != null) {
                this.showInterfaces.setSelectedItem(SHOW_LOCAL);
            } else if (this.descriptor.getRemoteClassName() != null) {
                this.showInterfaces.setSelectedItem(SHOW_REMOTE);
            }
            selIntf = (String)this.showInterfaces.getSelectedItem();
        }
        if (selIntf.equals(SHOW_LOCAL)) {
            set = this.getMethodDescriptorsByIntf(MethodDescriptor.EJB_LOCAL);
        } else if (selIntf.equals(SHOW_LOCAL_HOME)) {
            set = this.getMethodDescriptorsByIntf(MethodDescriptor.EJB_LOCALHOME);
        } else if (selIntf.equals(SHOW_REMOTE)) {
            set = this.getMethodDescriptorsByIntf(MethodDescriptor.EJB_REMOTE);
        } else if (selIntf.equals(SHOW_REMOTE_HOME)) {
            set = this.getMethodDescriptorsByIntf(MethodDescriptor.EJB_HOME);
        }
        return set;
    }

    void clearMethod() {
        this.checkpoint = null;
        this.ejb.setCheckpointAtEndOfMethod(this.checkpoint);
    }

    void addMethod(Method m) {
        if (this.checkpoint == null) {
            this.checkpoint = new CheckpointAtEndOfMethod();
            this.ejb.setCheckpointAtEndOfMethod(this.checkpoint);
        }
        this.checkpoint.addMethod(m);
    }

    public String[] getColumnNames() {
        Vector<String> cn = new Vector<String>();
        cn.add(METHOD_COLUMN);
        cn.add(CHECKPOINT_COLUMN);
        cn.add(DescriptionInspector.DESCRIPTION_COLUMN_INIT);
        return cn.toArray(new String[0]);
    }

    static /* synthetic */ Method[] access$702(CheckpointedMethodInspector x0, Method[] x1) {
        x0.methodArray = x1;
        return x1;
    }

    public class CheckpointTableModel
    extends InspectorTableModel {
        public CheckpointTableModel() {
            super(CheckpointedMethodInspector.this.getColumnNames());
            this.setDataOrdering(1);
        }

        public Object getObjectValue(Object obj, int col) {
            MethodDescriptor md = (MethodDescriptor)obj;
            Object value = null;
            switch (col) {
                case 0: {
                    value = md.getFormattedString();
                    break;
                }
                case 1: {
                    value = CheckpointedMethodInspector.this.getBooleanValue(md);
                    break;
                }
                case 2: {
                    if (!CheckpointedMethodInspector.this.getBooleanValue(md).booleanValue()) break;
                    value = md == null ? null : CheckpointedMethodInspector.this.getDescValue(md);
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            MethodDescriptor md = (MethodDescriptor)obj;
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    CheckpointedMethodInspector.this.updateMethods(md, (Boolean)value);
                    break;
                }
                case 2: {
                    String desc = (String)value;
                    if (!CheckpointedMethodInspector.this.getBooleanValue(md).booleanValue()) break;
                    CheckpointedMethodInspector.this.updateMethodDesc(md, desc);
                }
            }
            CheckpointedMethodInspector.this.descriptor.changed();
        }

        public boolean isCellEditable(int row, int col) {
            if (this.isReadOnly()) {
                return false;
            }
            if (col == 0) {
                return false;
            }
            if (col == 1) {
                return true;
            }
            if (col == 2) {
                return true;
            }
            return true;
        }
    }

    private class CheckpointTable
    extends InspectorTable {
        public CheckpointTable(CheckpointTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
            this.adjustColumnWidth(1, false);
        }

        public void setModel(CheckpointTableModel model) {
            super.setModel(model);
        }

        public void updateColumnNames() {
            this.getInspectorTableModel().setColumnNames(CheckpointedMethodInspector.this.getColumnNames());
        }
    }
}

