/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.dtv;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentPlatform;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeModel;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.FixedTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.NodeDescriptors;
import com.sun.enterprise.tools.deployment.ui.dtv.RootTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.ServerTreeNode;
import com.sun.enterprise.tools.deployment.ui.server.DeployedObjectDescriptor;
import com.sun.enterprise.tools.deployment.ui.server.EEServerDescriptor;
import com.sun.enterprise.tools.deployment.ui.server.ServerDescriptor;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIContextMenu;
import com.sun.enterprise.tools.deployment.ui.utils.UIEventQueue;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class UIDescriptorTree
extends JTree
implements UIContextMenu.ContextMenuKey {
    protected static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIDescriptorTree.class);
    protected static String TREE_NAME = localStrings.getLocalString("ui.uidescriptortree.tree_name", "Tree");
    protected static String TREE_DESC = localStrings.getLocalString("ui.uidescriptortree.tree_desc", "This is a tree view of the descriptors");
    private static final String CONTEXT_APP = "CtxApp";
    private static final String CONTEXT_STANDALONE = "CtxStandAlone";
    private static final String CONTEXT_BUNDLE = "CtxBundle";
    private static final String CONTEXT_COMPONENT = "CtxComponent";
    private static final String CONTEXT_SERVER = "CtxServer";
    private static final String CONTEXT_DEPLOYED = "CtxDeployedObject";
    private static final String CONTEXT_EJBCOMP = "CtxEjbComponent";
    private static final String CONTEXT_WEBCOMP = "CtxWebComponent";
    private static final String CONTEXT_JAXRPC = "CtxJAXRPC";
    private static final String CONTEXT_FILES = "CtxFiles";
    private DescriptorTreeNode rootNode = null;
    private List selectionListeners = null;
    private Runnable fireValueChanged_Run = null;
    private TreeSelectionEvent fireValueChanged_Event = null;
    static final String FAKE_EDITOR_OBJECT = "*Resizer*";

    public UIDescriptorTree() {
        this(new RootTreeNode());
    }

    public UIDescriptorTree(DescriptorTreeNode rootNode) {
        this.setRootNode(rootNode);
        this.getAccessibleContext().setAccessibleName(TREE_NAME);
        this.getAccessibleContext().setAccessibleDescription(TREE_DESC);
        this.setCellRenderer(new DescriptorTreeCellRenderer());
        this.setCellEditor(new DefaultTreeCellEditor(this, null, new DescriptorTreeCellEditor()));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        TreeSelectionModel selModel = this.getSelectionModel();
        selModel.setSelectionMode(1);
        this.setSelectionModel(selModel);
        super.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent tse) {
                TreePath selPath = tse.getNewLeadSelectionPath();
                Descriptor mainDesc = UIDescriptorTree.this.getTopDescriptorFor(selPath);
                UIDescriptorTree.this.setActiveDescriptor(mainDesc);
                if (UIDescriptorTree.this.selectionListeners != null) {
                    Iterator i = UIDescriptorTree.this.selectionListeners.iterator();
                    while (i.hasNext()) {
                        ((TreeSelectionListener)i.next()).valueChanged(tse);
                    }
                }
            }
        });
        new UIContextMenu(this);
    }

    public void setRootNode(DescriptorTreeNode rootNode) {
        this.rootNode = rootNode;
        this.setModel(new DescriptorTreeModel(this, rootNode));
    }

    public DescriptorTreeNode getRootNode() {
        return this.rootNode;
    }

    public void refresh() {
        this.getRootNode().update((DescriptorTreeModel)this.getModel());
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new Vector();
        }
        if (!this.selectionListeners.contains(tsl)) {
            this.selectionListeners.add(tsl);
        }
    }

    public void removeTreeSelectionListener(TreeSelectionListener tsl) {
        if (this.selectionListeners != null && this.selectionListeners.contains(tsl)) {
            this.selectionListeners.remove(tsl);
        }
    }

    public String getContextKey(UIContextMenu ctxMenu, MouseEvent me) {
        if (!UIConfig.getConfigBoolean("ui.tree.enableContextMenus")) {
            return null;
        }
        String key = null;
        Descriptor d = this.getDescriptorAtLocation(me.getX(), me.getY());
        if (d != null) {
            this.setSelectedDescriptor(d, false);
        }
        if (d instanceof Application) {
            key = CONTEXT_APP;
            if (!ctxMenu.hasPopupMenu(key)) {
                ctxMenu.addItem(key, "!Save");
                ctxMenu.addItem(key, "!EditSearchPaths");
                ctxMenu.addItem(key, "!Update");
                ctxMenu.addItem(key, "!DescViewer");
                ctxMenu.addItem(key, "!S1DescViewer");
                ctxMenu.addItem(key, "!EditUsers");
                ctxMenu.addItem(key, "!Deploy");
                ctxMenu.addItem(key, "!Close");
            }
        } else if (d instanceof BundleDescriptor) {
            if (DescriptorTools.isStandAlone(d)) {
                key = CONTEXT_STANDALONE;
                if (!ctxMenu.hasPopupMenu(key)) {
                    ctxMenu.addItem(key, "!Save");
                    ctxMenu.addItem(key, "!EditSearchPaths");
                    ctxMenu.addItem(key, "!Update");
                    ctxMenu.addItem(key, "!DescViewer");
                    ctxMenu.addItem(key, "!S1DescViewer");
                    ctxMenu.addItem(key, "!EditUsers");
                    ctxMenu.addItem(key, "!Deploy");
                    ctxMenu.addItem(key, "!Close");
                }
            } else {
                key = CONTEXT_BUNDLE;
                if (!ctxMenu.hasPopupMenu(key)) {
                    ctxMenu.addItem(key, "!EditSearchPaths");
                    ctxMenu.addItem(key, "!DescViewer");
                    ctxMenu.addItem(key, "!S1DescViewer");
                    ctxMenu.addItem(key, "!EditUsers");
                    ctxMenu.addItem(key, "!Copy");
                    ctxMenu.addItem(key, "!Delete");
                }
            }
        } else if (d instanceof DeployedObjectDescriptor) {
            key = CONTEXT_DEPLOYED;
            if (!ctxMenu.hasPopupMenu(key)) {
                ctxMenu.addItem(key, "!Undeploy");
            }
        } else if (d instanceof EjbDescriptor) {
            key = CONTEXT_EJBCOMP;
            if (!ctxMenu.hasPopupMenu(key)) {
                ctxMenu.addItem(key, "!Delete");
            }
        } else if (d instanceof WebComponentDescriptor) {
            key = CONTEXT_WEBCOMP;
            if (!ctxMenu.hasPopupMenu(key)) {
                ctxMenu.addItem(key, "!Delete");
            }
        } else if (d instanceof NodeDescriptors.FilesRootDescriptor && !ctxMenu.hasPopupMenu(key = CONTEXT_FILES)) {
            ctxMenu.addItem(key, "Refresh", new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    UIDescriptorTree.this.refresh();
                }
            });
        }
        return key;
    }

    public void expandPath(TreePath tp) {
        super.expandPath(tp);
    }

    public void expandTreeRootDescriptors() {
        this.expandDescriptors(this.getRootNode(), NodeDescriptors.TreeRootDescriptor.class);
    }

    public void expandAllDescriptors() {
        this.expandDescriptors(this.getRootNode(), null);
    }

    public void expandAllDescriptors(DescriptorTreeNode node) {
        this.expandDescriptors(node, null);
    }

    private void expandDescriptors(DescriptorTreeNode node, Class type) {
        Descriptor d = (Descriptor)node.getUserObject();
        if (type == null || type.isInstance(d)) {
            this.expandPath(node.getTreePath());
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                this.expandDescriptors((DescriptorTreeNode)e.nextElement(), type);
            }
        }
    }

    protected void fireValueChanged(TreeSelectionEvent e) {
        if (this.fireValueChanged_Event == null || UIEventQueue.isFocusLostPending()) {
            if (this.fireValueChanged_Event != null) {
                this.fireValueChanged_Event = e;
                return;
            }
            if (this.fireValueChanged_Run == null) {
                this.fireValueChanged_Run = new Runnable(){

                    public void run() {
                        UIDescriptorTree.this.fireValueChanged(UIDescriptorTree.this.fireValueChanged_Event);
                        UIDescriptorTree.this.fireValueChanged_Event = null;
                    }
                };
            }
            this.fireValueChanged_Event = e;
            UIEventQueue.invokeLater(this.fireValueChanged_Run);
            return;
        }
        super.fireValueChanged(e);
    }

    protected boolean setActiveDescriptor(Descriptor d) {
        if (d instanceof RootDeploymentDescriptor) {
            DT.getModuleManager().setActiveModule(d);
            return true;
        }
        if (d instanceof ServerDescriptor) {
            DeploymentPlatform.setSelectedManagerURI(((ServerDescriptor)d).getServer());
            this.repaint();
            return true;
        }
        return false;
    }

    public void setSelectedDescriptor(Descriptor d, boolean expand) {
        TreePath treePath = this.getTreePathFor(d);
        Descriptor mainDesc = this.getTopDescriptorFor(treePath);
        if (mainDesc != null) {
            this.setActiveDescriptor(d);
            if (expand) {
                this.expandPath(treePath);
            }
            this.setSelectionPath(treePath);
        } else {
            this.clearSelection();
        }
    }

    public Descriptor getSelectedDescriptor(Class descClass) {
        return this.getSelectedDescriptor(new Class[]{descClass});
    }

    public Descriptor getSelectedDescriptor(Class[] descClass) {
        TreePath sel = this.getSelectionPath();
        if (sel != null) {
            for (int i = sel.getPathCount() - 1; i > 1; --i) {
                Descriptor desc = ((DescriptorTreeNode)sel.getPathComponent(i)).getDescriptor();
                if (desc == null) continue;
                Class<?> dc = desc.getClass();
                for (int j = 0; j < descClass.length; ++j) {
                    if (!descClass[j].isAssignableFrom(dc)) continue;
                    return desc;
                }
            }
        }
        return null;
    }

    public Descriptor getSelectedDescriptor() {
        TreePath sel = this.getSelectionPath();
        if (sel != null) {
            Object[] p = sel.getPath();
            DescriptorTreeNode tn = (DescriptorTreeNode)p[p.length - 1];
            return tn.getDescriptor();
        }
        return null;
    }

    public Descriptor getSelectedParent() {
        TreePath sel = this.getSelectionPath();
        if (sel != null) {
            Object[] p = sel.getPath();
            DescriptorTreeNode n = p.length >= 2 ? (DescriptorTreeNode)p[p.length - 2] : (DescriptorTreeNode)p[p.length - 1];
            return (Descriptor)n.getUserObject();
        }
        return null;
    }

    public String getSelectionString() {
        StringBuffer sb = new StringBuffer("");
        TreePath sel = this.getSelectionPath();
        if (sel != null) {
            Object[] e = sel.getPath();
            for (int i = 1; i < e.length; ++i) {
                if (i > 1) {
                    sb.append(".");
                }
                sb.append(e[i].toString());
            }
        }
        return sb.toString();
    }

    public Descriptor getTopDescriptorFor(TreePath tp) {
        if (tp != null) {
            int cnt = tp.getPathCount();
            for (int i = 1; i < cnt; ++i) {
                DescriptorTreeNode node = (DescriptorTreeNode)tp.getPathComponent(i);
                Object obj = node.getUserObject();
                if (obj instanceof EEServerDescriptor) {
                    if (++i < cnt) {
                        obj = (Descriptor)((DescriptorTreeNode)tp.getPathComponent(i)).getUserObject();
                        return (Descriptor)obj;
                    }
                    return (Descriptor)obj;
                }
                if (obj instanceof ServerDescriptor) {
                    return (Descriptor)obj;
                }
                if (obj instanceof Application) {
                    return (Descriptor)obj;
                }
                if (!(obj instanceof BundleDescriptor)) continue;
                return (Descriptor)obj;
            }
        }
        return null;
    }

    public DescriptorTreeNode getNodeFor(Descriptor d) {
        return this.getRootNode().getNodeFor(d);
    }

    public DescriptorTreeNode getNodeFor(String n) {
        return this.getRootNode().getNodeFor(n);
    }

    public TreePath getTreePathFor(Descriptor d) {
        return this.getRootNode().getTreePathFor(d);
    }

    public TreePath getTreePathFor(String n) {
        return this.getRootNode().getTreePathFor(n);
    }

    public Descriptor getDescriptorAtLocation(int x, int y) {
        TreePath tp = this.getPathForLocation(x, y);
        if (tp != null) {
            DescriptorTreeNode tn = (DescriptorTreeNode)tp.getLastPathComponent();
            return tn.getDescriptor();
        }
        return null;
    }

    public boolean replaceDescriptor(Descriptor oldVal, Descriptor newVal) {
        return this.getRootNode().replaceDescriptor(oldVal, newVal);
    }

    public synchronized void notification(NotificationEvent ne) {
        if (!this.getRootNode().notification(this, ne)) {
            // empty if block
        }
    }

    private class DescriptorTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private DescriptorTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
            if (value instanceof DescriptorTreeNode) {
                DescriptorTreeNode dtn = (DescriptorTreeNode)value;
                Descriptor desc = dtn.getDescriptor();
                if (desc == null) {
                    Print.dprintStackTrace((String)"Descriptor is null");
                }
                label.setIcon(UIIcons.getIconFor(desc));
                if (dtn.hasErrors()) {
                    label.setForeground(Color.red);
                } else if (dtn instanceof FixedTreeNode || dtn instanceof ServerTreeNode) {
                    label.setForeground(Color.black);
                } else {
                    label.setForeground(Color.black);
                }
            } else {
                label.setIcon(null);
                label.setForeground(Color.red);
            }
            Dimension d = label.getPreferredSize();
            if (d.height > 20) {
                Print.dprintln((String)("Resetting preferred size, was " + d.height));
                d.width = 300;
                d.height = 20;
                label.setMaximumSize(d);
            }
            return label;
        }
    }

    private class DescriptorTreeCellEditor
    implements TreeCellEditor {
        private DescriptorTreeCellEditor() {
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            return UIDescriptorTree.this.getCellRenderer().getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, false);
        }

        public Object getCellEditorValue() {
            return UIDescriptorTree.FAKE_EDITOR_OBJECT;
        }

        public boolean isCellEditable(EventObject evt) {
            return true;
        }

        public boolean shouldSelectCell(EventObject event) {
            return false;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public void cancelCellEditing() {
        }

        public void addCellEditorListener(CellEditorListener l) {
        }

        public void removeCellEditorListener(CellEditorListener l) {
        }
    }
}

