/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.dtv;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.dtv.ApplicationTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeModel;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.NodeDescriptors;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public class TreeCombo
extends UITitledComboBox {
    public static int ComboType_NONE = 0;
    public static int ComboType_Client = 2;
    public static int ComboType_EJB = 8;
    public static int ComboType_WAR = 32;
    public static int ComboType_RAR = 128;
    public static int ComboType_Apps = 256;
    public static int ComboType_AppsEjbsWars = ComboType_Apps | ComboType_EJB | ComboType_WAR;
    public static int ComboType_Deployables = 61441;
    public static String LIST_SELECTION = "list";
    public static String TREE_SELECTION = "tree";
    private int appTypeModel = ComboType_NONE;
    private static Border MTBorder = new EmptyBorder(0, 0, 0, 0);
    private static int INDENT_TAB = 16;

    private static int ConvertComboToAppType(int type) {
        int appType = ApplicationTreeNode.AppType_NONE;
        if ((type & ComboType_Client) != 0) {
            appType |= ApplicationTreeNode.AppType_Client;
        }
        if ((type & ComboType_EJB) != 0) {
            appType |= ApplicationTreeNode.AppType_EJB;
        }
        if ((type & ComboType_WAR) != 0) {
            appType |= ApplicationTreeNode.AppType_WAR;
        }
        if ((type & ComboType_RAR) != 0) {
            appType |= ApplicationTreeNode.AppType_ResAdapt;
        }
        if ((type & ComboType_Apps) != 0) {
            appType |= ApplicationTreeNode.AppType_Apps;
        }
        return appType;
    }

    protected static boolean UseAppListCombo() {
        return UIConfig.getConfigValue("ui.Wizard.treeComboSelectionType").equals(LIST_SELECTION);
    }

    public static TreeCombo newTreeCombo(String title, boolean frame, int type) {
        return new TreeCombo(title, frame, type);
    }

    public static TreeCombo newTreeCombo(String title, boolean frame) {
        return new TreeCombo(title, frame, ComboType_NONE);
    }

    public static TreeCombo newAppCombo(String title, boolean frame) {
        return TreeCombo.newTreeCombo(title, frame, ComboType_Apps);
    }

    public static TreeCombo newWarCombo(String title, boolean frame) {
        return TreeCombo.newTreeCombo(title, frame, ComboType_WAR);
    }

    public static TreeCombo newEjbCombo(String title, boolean frame) {
        return TreeCombo.newTreeCombo(title, frame, ComboType_EJB);
    }

    public static TreeCombo newAppEjbWarCombo(String title, boolean frame) {
        return TreeCombo.newTreeCombo(title, frame, ComboType_AppsEjbsWars);
    }

    public static TreeCombo newDeployablesCombo(String title, boolean frame) {
        return TreeCombo.newTreeCombo(title, frame, ComboType_Deployables);
    }

    private TreeCombo() {
        super((String)null, false);
    }

    private TreeCombo(String title, boolean showBorder) {
        super(title, showBorder);
    }

    private TreeCombo(TreeModel model) {
        this();
        this.setModel(model);
    }

    private TreeCombo(String title, boolean showBorder, TreeModel model) {
        super(title, showBorder);
        this.setModel(model);
    }

    private TreeCombo(int comboType) {
        this();
        this.setModel(comboType);
    }

    private TreeCombo(String title, boolean showBorder, int comboType) {
        this(title, showBorder);
        this.setModel(comboType);
    }

    public void setModel(int comboType) {
        this.appTypeModel = comboType;
        this.refreshModel();
    }

    public void setModel(TreeModel aTreeModel) {
        super.setModel(new TreeToListModel(aTreeModel));
    }

    public void refreshModel() {
        if (this.appTypeModel != ComboType_NONE) {
            if (this.appTypeModel == ComboType_Deployables) {
                DescriptorTreeNode deployable = new DescriptorTreeNode(new NodeDescriptors.FilesRootDescriptor(), true);
                Enumeration e = DT.getModuleManager().getApplications().elements();
                while (e.hasMoreElements()) {
                    Application app = (Application)e.nextElement();
                    DescriptorTreeNode appNode = new DescriptorTreeNode((Descriptor)app, false);
                    appNode.update(null);
                    deployable.addNode(null, appNode);
                }
                e = DT.getModuleManager().getStandAlones().elements();
                while (e.hasMoreElements()) {
                    Descriptor d = (Descriptor)e.nextElement();
                    DescriptorTreeNode saNode = new DescriptorTreeNode(d, false);
                    saNode.update(null);
                    deployable.addNode(null, saNode);
                }
                this.setModel(new DescriptorTreeModel(deployable));
            } else if (this.appTypeModel == ComboType_Apps) {
                DescriptorTreeNode comboRoot = new DescriptorTreeNode(new NodeDescriptors.ApplicationsRootDescriptor(), true);
                Enumeration e = DT.getModuleManager().getApplications().elements();
                while (e.hasMoreElements()) {
                    Application app = (Application)e.nextElement();
                    DescriptorTreeNode appNode = new DescriptorTreeNode((Descriptor)app, false);
                    appNode.update(null);
                    comboRoot.addNode(null, appNode);
                }
                this.setModel(new DescriptorTreeModel(comboRoot));
            } else {
                DescriptorTreeNode comboRoot = new DescriptorTreeNode(new NodeDescriptors.FilesRootDescriptor(), true);
                boolean omitApps = (this.appTypeModel & ComboType_Apps) == 0;
                int appType = TreeCombo.ConvertComboToAppType(this.appTypeModel);
                boolean listCombo = TreeCombo.UseAppListCombo();
                Enumeration e = DT.getModuleManager().getApplications().elements();
                while (e.hasMoreElements()) {
                    Application app = (Application)e.nextElement();
                    if (listCombo && omitApps) {
                        ApplicationTreeNode.populateNode(null, comboRoot, app, appType);
                        continue;
                    }
                    ApplicationTreeNode appNode = new ApplicationTreeNode(app, appType);
                    appNode.update(null);
                    if (!appNode.hasChildren()) continue;
                    comboRoot.addNode(null, appNode);
                }
                if (omitApps) {
                    int saType = this.appTypeModel;
                    Enumeration e2 = DT.getModuleManager().getStandAlones().elements();
                    while (e2.hasMoreElements()) {
                        Descriptor d = (Descriptor)e2.nextElement();
                        if (!((saType & ComboType_WAR) != 0 && d instanceof WebBundleDescriptor || (saType & ComboType_EJB) != 0 && d instanceof EjbBundleDescriptor) && ((saType & ComboType_RAR) == 0 || !(d instanceof ConnectorDescriptor))) continue;
                        DescriptorTreeNode saNode = new DescriptorTreeNode(d, false);
                        comboRoot.addNode(null, saNode);
                    }
                }
                this.setModel(new DescriptorTreeModel(comboRoot));
            }
        }
    }

    public Object getSelectedItem() {
        Object obj = super.getSelectedItem();
        if (obj instanceof ListEntry) {
            if (this.appTypeModel == ComboType_Deployables) {
                return obj;
            }
            DefaultMutableTreeNode entry = ((ListEntry)obj).getNode();
            if (entry instanceof ApplicationTreeNode && (this.appTypeModel & ComboType_Apps) == 0) {
                Print.dprintln((String)"App selected & Apps not allowed");
                return null;
            }
        }
        return obj;
    }

    public Object getSelectedDescriptor() {
        Object obj = this.getSelectedItem();
        return obj instanceof ListEntry ? ((ListEntry)obj).getNode().getUserObject() : null;
    }

    public void setSelectedDescriptor(Descriptor d) {
        this.setSelectedItem(d);
    }

    public void setSelectedItem(Object item) {
        super.setSelectedItem(((TreeToListModel)this.getModel()).getListEntry(item));
    }

    public void selectActiveModule() {
        this.setSelectedDescriptor(DT.getSelectedModule());
    }

    public void selectActiveBundle() {
        this.setSelectedDescriptor((Descriptor)DT.getSelectedBundle());
    }

    public void selectActiveDescriptor() {
        this.setSelectedDescriptor(DT.getSelectedDescriptor());
    }

    public boolean isEmpty() {
        return this.getModel().getSize() <= 0;
    }

    protected JComboBox createPrivateComboBox() {
        return new PrivateTreeComboBox();
    }

    private class ListEntry {
        private DefaultMutableTreeNode node = null;
        private int level = 0;

        public ListEntry(DefaultMutableTreeNode node, int aLevel) {
            this.node = node;
            this.level = aLevel;
        }

        public DefaultMutableTreeNode getNode() {
            return this.node;
        }

        public int level() {
            return this.level;
        }

        public String toString() {
            return this.getNode().toString();
        }
    }

    private class TreeToListModel
    extends DefaultComboBoxModel
    implements TreeModelListener {
        private TreeModel source;
        private boolean invalid = true;

        public TreeToListModel(TreeModel aTreeModel) {
            this.source = aTreeModel;
            if (!(this.source.getRoot() instanceof DefaultMutableTreeNode)) {
                Print.printStackTrace((String)("Not a DefaultMutableTreeNode: " + UIUtils.debugClassName(this.source.getRoot())));
            }
            this.source.addTreeModelListener(this);
        }

        public void setSelectedItem(Object obj) {
            super.setSelectedItem(obj instanceof ListEntry ? obj : null);
        }

        public int getSize() {
            this.validate();
            return super.getSize();
        }

        private void validate() {
            if (this.invalid) {
                this.invalid = false;
                this.removeAllElements();
                this.cacheTree((DefaultMutableTreeNode)this.source.getRoot(), 0);
            }
        }

        private void cacheTree(DefaultMutableTreeNode node, int level) {
            if (node == null) {
                Print.printStackTrace((String)"Node is 'null'");
            } else if (node != this.source.getRoot() && this.source.isLeaf(node)) {
                this.addElement(new ListEntry(node, level));
            } else {
                if (level > 0) {
                    this.addElement(new ListEntry(node, level));
                }
                int c = this.source.getChildCount(node);
                for (int i = 0; i < c; ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.source.getChild(node, i);
                    if (child != null) {
                        this.cacheTree(child, level + 1);
                        continue;
                    }
                    Print.printStackTrace((String)("Child is 'null': " + i + "/" + c + " [" + node + "]"));
                }
            }
        }

        public ListEntry getListEntry(Object item) {
            block4: {
                block3: {
                    if (item instanceof ListEntry) {
                        return (ListEntry)item;
                    }
                    if (!(item instanceof String)) break block3;
                    int len = this.getSize();
                    for (int i = 0; i < len; ++i) {
                        Object listObj = this.getElementAt(i);
                        if (!(listObj instanceof ListEntry) || !listObj.toString().equals(item)) continue;
                        return (ListEntry)listObj;
                    }
                    break block4;
                }
                if (!(item instanceof Descriptor)) break block4;
                int len = this.getSize();
                for (int i = 0; i < len; ++i) {
                    Object listObj = this.getElementAt(i);
                    if (!(listObj instanceof ListEntry) || ((ListEntry)listObj).getNode().getUserObject() != item) continue;
                    return (ListEntry)listObj;
                }
            }
            return null;
        }

        public void treeNodesChanged(TreeModelEvent e) {
            this.invalid = true;
        }

        public void treeNodesInserted(TreeModelEvent e) {
            this.invalid = true;
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            this.invalid = true;
        }

        public void treeStructureChanged(TreeModelEvent e) {
            this.invalid = true;
        }
    }

    protected class PrivateTreeComboBox
    extends UITitledComboBox.PrivateComboBox {
        private int resetSelection;

        public PrivateTreeComboBox() {
            super(TreeCombo.this);
            this.resetSelection = 0;
            this.setRenderer(new PopupTreeCellRenderer());
        }

        public void setSelectedItem(Object obj) {
            if (obj instanceof ListEntry) {
                ListEntry item = (ListEntry)obj;
                if (item.getNode() instanceof ApplicationTreeNode && (TreeCombo.this.appTypeModel & ComboType_Apps) == 0) {
                    int sel = -1;
                    int c = this.getItemCount();
                    for (int i = 0; i < c; ++i) {
                        if (!this.getItemAt(i).equals(obj)) continue;
                        sel = i;
                        break;
                    }
                    if (sel >= 0 && sel + 1 < this.getItemCount() && !((item = (ListEntry)this.getItemAt(sel + 1)).getNode() instanceof ApplicationTreeNode)) {
                        Print.dprintln((String)("Replacing selected item " + item));
                        obj = item;
                    }
                }
                super.setSelectedItem(obj);
            } else {
                super.setSelectedItem(null);
            }
        }

        public class PopupTreeCellRenderer
        extends UITitledComboBox.PrivateComboBox.PopupListCellRenderer {
            public PopupTreeCellRenderer() {
                super(PrivateTreeComboBox.this);
            }

            public Component getListCellRendererComponent(JList list, Object v, int ndx, boolean sel, boolean focus) {
                Component comp;
                if (v instanceof JSeparator) {
                    return (Component)v;
                }
                Object titleObj = v;
                Icon icon = null;
                int indent = 0;
                if (v instanceof ListEntry) {
                    titleObj = v.toString();
                    icon = UIIcons.getIconFor(((ListEntry)v).getNode().getUserObject());
                    int n = indent = ndx < 0 ? 0 : INDENT_TAB * (((ListEntry)v).level() - 1);
                }
                if ((comp = super.getListCellRendererComponent(list, titleObj, ndx, sel, focus)) instanceof JLabel) {
                    ((JLabel)comp).setIcon(icon);
                    ((JLabel)comp).setBorder(indent <= 0 ? MTBorder : new EmptyBorder(0, indent, 0, 0));
                }
                return comp;
            }
        }
    }
}

