/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.dtv;

import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentPlatform;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeModel;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.EEServerTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.FixedTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.NodeDescriptors;
import com.sun.enterprise.tools.deployment.ui.dtv.ServerTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.UIDescriptorTree;
import com.sun.enterprise.tools.deployment.ui.server.DTServerManager;
import com.sun.enterprise.tools.deployment.ui.server.EEServerDescriptor;
import com.sun.enterprise.util.NotificationEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class ServerRootTreeNode
extends FixedTreeNode {
    public ServerRootTreeNode() {
        super(new NodeDescriptors.ServersRootDescriptor(), true);
    }

    protected ServerTreeNode addServerNode(DescriptorTreeModel treeModel, DeploymentPlatform.ManagerURI server) {
        EEServerTreeNode serverNode = null;
        server.setTarget(null);
        serverNode = new EEServerTreeNode(new EEServerDescriptor(server));
        this.addNode(treeModel, serverNode);
        ((ServerTreeNode)serverNode).update(treeModel);
        return serverNode;
    }

    protected boolean removeServerNode(DescriptorTreeModel treeModel, DeploymentPlatform.ManagerURI server) {
        DescriptorTreeNode node = this.getNodeFor(server);
        if (node != null) {
            this.removeNode(treeModel, node);
            return true;
        }
        return false;
    }

    public void update(DescriptorTreeModel treeModel) {
        Vector delNodes = this.getChildrenCopy();
        Iterator i = DeploymentPlatform.getManagerURIs().iterator();
        while (i.hasNext()) {
            DeploymentPlatform.ManagerURI server = (DeploymentPlatform.ManagerURI)i.next();
            DescriptorTreeNode node = this.getNodeFor(server);
            if (node != null) {
                node.update(treeModel);
                delNodes.remove(node);
                continue;
            }
            this.addServerNode(treeModel, server);
        }
        this.removeNodes(treeModel, delNodes);
    }

    public DescriptorTreeNode getNodeFor(DeploymentPlatform.ManagerURI server) {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            ServerTreeNode sn = (ServerTreeNode)e.nextElement();
            if (!sn.getServer().equals(server)) continue;
            return sn;
        }
        return null;
    }

    public boolean notification(UIDescriptorTree uiTree, NotificationEvent ne) {
        String type = ne.getType();
        if (type == null) {
            return false;
        }
        Object srcObj = ne.getSource();
        if (!(srcObj instanceof DTServerManager)) {
            return false;
        }
        Object name = ne.getValue("ServerPropertyValue");
        DescriptorTreeModel treeModel = (DescriptorTreeModel)uiTree.getModel();
        if (type.equals("ServerRefresh")) {
            this.update(treeModel);
            this.resizeDisplayNames(uiTree);
        } else if (type.equals("ServerChanged")) {
            this.update(treeModel);
            uiTree.expandPath(this.getTreePath());
        } else if (type.equals("ServerAdded")) {
            this.update(treeModel);
            uiTree.expandPath(this.getTreePath());
        } else if (type.equals("ServerRemoved")) {
            this.update(treeModel);
        } else if (!type.equals("ServerSelected") && !type.equals("ServerTargeted")) {
            if (type.equals("ModuleDeployed") || type.equals("ModuleUndeployed")) {
                this.update(treeModel);
            } else {
                return false;
            }
        }
        return true;
    }
}

