/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.deploy;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentPlatform;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentURISelector;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIDivider;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextArea;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class DeploymentManagerSettings
extends UIDialog {
    protected static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeploymentManagerSettings.class);
    protected static String WINDOW_TITLE = localStrings.getLocalString("ui.deploymentmanagersettings.connect_to_server", "Connect to Server");
    protected static String CONNECTION_SETTINGS = localStrings.getLocalString("ui.deploymentmanagersettings.connection_settings", "Connection Settings");
    protected static String USERNAME = localStrings.getLocalString("ui.deploymentmanagersettings.user_name", "User Name:");
    protected static String PASSWORD = localStrings.getLocalString("ui.deploymentmanagersettings.password", "Password:");
    protected static String WARN_REQUIRED_USER_PASSWORD = localStrings.getLocalString("ui.deploymentmanagersettings.require_user_password", "You must connect to the deployment manager to perform this function.\nPlease provide a user name and password, then click OK");
    private static String NO_USERNAME_PASSWORD_ERROR_MSG = localStrings.getLocalString("ui.deploymoduledialog.please_set_username_password", "The user name and password to the Deployment Manager is not set");
    private static String NO_PLATFORMS = localStrings.getLocalString("ui.deploymoduledialog.no_platforms", "No available servers found");
    private static DeploymentManagerSettings dialog = null;
    private UITitledBox warningBox = null;
    private UITitledTextArea warningMessage = null;
    private DeploymentURISelector uriSelector = null;
    private boolean okSelected = false;

    private static String UNABLE_TO_CONNECT(Object v0) {
        return localStrings.getLocalString("ui.deploymoduledialog.unable_to_connect_to_server", "The server could not be contacted.\nPlease confirm that the server is running,\nand that a valid user/password has been entered.\n{0}", new Object[]{v0});
    }

    public static boolean showDialog() {
        return DeploymentManagerSettings.showDialog(null, null, false);
    }

    public static boolean showDialog(DeploymentPlatform.ManagerURI mu, boolean userReq) {
        return DeploymentManagerSettings.showDialog(mu.getDeploymentPlatform(), mu, userReq);
    }

    public static boolean showDialog(DeploymentPlatform dp, DeploymentPlatform.ManagerURI mu, boolean userReq) {
        if (dialog == null) {
            dialog = new DeploymentManagerSettings(DT.getApplicationFrame());
        }
        DeploymentManagerSettings.dialog.okSelected = false;
        dialog.refresh(dp, mu);
        dialog.setWarnMode(userReq ? 1 : 0);
        dialog.setLocationRelativeToOwner();
        dialog.show();
        return DeploymentManagerSettings.dialog.okSelected;
    }

    public static DeploymentPlatform.ManagerURI getManagerURI(boolean showErrors) {
        DeploymentPlatform.ManagerURI mu = DeploymentPlatform.getTargetManagerURI();
        if (mu == null) {
            List mulist = DeploymentPlatform.getManagerURIs();
            if (mulist.size() > 0) {
                mu = (DeploymentPlatform.ManagerURI)mulist.get(0);
            } else if (showErrors) {
                UIOptionPane.showErrorDialog(null, NO_PLATFORMS);
            }
        }
        return mu;
    }

    public static DeploymentPlatform.ManagerURI getConnectedManagerURI() {
        try {
            DeploymentPlatform.ManagerURI mu = DeploymentManagerSettings.getManagerURI(true);
            if (mu != null) {
                boolean okSel;
                DeploymentPlatform dp = mu.getDeploymentPlatform();
                if (!(dp.hasCurrentUserPassword() && dp.isConnected() && dp.isServerRunning() || (okSel = DeploymentManagerSettings.showDialog(dp, mu, true)))) {
                    return null;
                }
                if (dp.isConnected() && dp.isServerRunning()) {
                    return mu;
                }
                UIOptionPane.showErrorDialog(null, DeploymentManagerSettings.UNABLE_TO_CONNECT(mu));
            }
        }
        catch (Throwable t) {
            Print.dprintStackTrace((String)"Unexpected Exception", (Throwable)t);
        }
        return null;
    }

    protected DeploymentManagerSettings(Frame parentFrame) {
        super(parentFrame, true);
        this.setTitle(WINDOW_TITLE);
        this._initLayout();
    }

    protected void _initLayout() {
        UITitledBox content = (UITitledBox)this.getContentPane();
        UIControlButtonBox control = new UIControlButtonBox(null, false);
        control.setControlButtonLocation(101);
        content.addWithGBConstraints(control);
        UITitledBox box = new UITitledBox(null, false);
        box.getGBConstraints().weighty = 0.0;
        box.getGBConstraints().fill = 2;
        box.getGBConstraints().anchor = 11;
        box.getGBConstraints().insets.top = 5;
        control.setView(box);
        UIButton okBtn = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DeploymentManagerSettings.this.okAction();
            }
        });
        control.addControlButton(okBtn);
        UIButton cancelBtn = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DeploymentManagerSettings.this.cancelAction();
            }
        });
        control.addControlButton(cancelBtn);
        control.addControlButton(new UIHelpButton("DepMgrSettings"));
        box.addWithGBConstraints(this._createWarningBox());
        this.uriSelector = new DeploymentURISelector(true);
        box.addWithGBConstraints(this.uriSelector);
    }

    private UITitledBox _createWarningBox() {
        this.warningBox = new UITitledBox(null, false);
        GridBagConstraints c = this.warningBox.getGBConstraints();
        JLabel warnIcon = new JLabel(UIManager.getIcon("OptionPane.warningIcon"));
        warnIcon.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.deplmgrsettings.label_name", "Warning Label"));
        warnIcon.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.deplmgrsettings.label_desc", "Warning Label"));
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.warningBox.add((Component)warnIcon, c);
        this.warningMessage = new UITitledTextArea(null, false, false);
        this.warningMessage.setFont(new Font("SansSerif", 1, 12));
        this.warningMessage.setText("");
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.warningBox.add((Component)this.warningMessage, c);
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(7, 0, 7, 0);
        this.warningBox.add((Component)new UIDivider(1), c);
        return this.warningBox;
    }

    protected void refresh(DeploymentPlatform dp, DeploymentPlatform.ManagerURI mu) {
        this.uriSelector.refreshPlatforms();
        if (dp != null) {
            Print.dprintln((String)("Default platform: " + dp + " [" + mu + "]"));
            this.uriSelector.setSelectedPlatform(dp);
            this.uriSelector.setSelectedURI(mu);
            this.uriSelector.setEnabled(false);
        } else {
            this.uriSelector.setEnabled(true);
        }
    }

    protected void setWarnMode(int mode) {
        switch (mode) {
            case 0: {
                this.warningMessage.setText("");
                this.warningBox.setVisible(false);
                this.setSize(325, 370);
                break;
            }
            case 1: {
                this.warningMessage.setText(WARN_REQUIRED_USER_PASSWORD);
                this.warningBox.setVisible(true);
                this.setSize(325, 340);
                break;
            }
            default: {
                Print.dprintStackTrace((String)("Unsupported warning mode: " + mode));
            }
        }
    }

    private void applyAction() {
        this.uriSelector.applySelections();
    }

    private void okAction() {
        if (this.warningBox.isVisible() && !this.uriSelector.isValidUsernamePassword()) {
            UIOptionPane.showErrorDialog(this, NO_USERNAME_PASSWORD_ERROR_MSG);
            return;
        }
        this.uriSelector.applySelections();
        this.okSelected = true;
        this.hide();
    }

    protected void cancelAction() {
        this.okSelected = false;
        this.hide();
    }
}

