/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.appc;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.io.AppClientDeploymentDescriptorFile;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.appc.AppClientGeneralInspector;
import com.sun.enterprise.tools.deployment.ui.appc.AppClientJarFileInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorViewer;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleContent;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIJarPackager;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.tools.deployment.ui.utils.Wizard;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;

public class NewAppClientWizard
extends Wizard {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(NewAppClientWizard.class);
    private static String WIZARD_TITLE_NEW = localStrings.getLocalString("ui.newappclientwizard.title.new", "New Application Client Wizard");
    private static String DEFAULT_NAME = localStrings.getLocalString("ui.newappclientwizard.client", "client");
    private static String INTRO_HELP = localStrings.getLocalString("ui.newappclientwizard.intro_help.new_appc", "<HTML><HEADER><BODY><P>This wizard will help you to create a new client for your application.<P>Creating this application client requires the following steps:<UL><LI>Identify the JAR file that will contain the application client<LI>Identify the main class for the application client</UL></BODY></HTML>");
    protected static String NEXT_STEPS_HELP = localStrings.getLocalString("ui.newappclientwizard.next_steps", "<HTML><BODY>That is all the information needed to create a basic application client.<br>When you click Finish, an application client will be created and added to the tree control<P>Next steps:<UL><LI>Use the tabbed controls to further edit the standard deployment descriptor, if necessary</LI><LI>Provide any required Sun-specific Settings, if necessary</LI><LI>Click the File-Deploy menu to deploy the application to the server</LI></UL><P></BODY></HTML>");
    private static String JAR_FILE_TITLE = localStrings.getLocalString("ui.newappclientwizard.jar_file.title", "JAR File Contents");
    private static String JAR_FILE_HELP = localStrings.getLocalString("ui.newappclientwizard.jar_file.help", "A JAR archive will be created to package the files needed for this application client.  You can choose to have a stand-alone JAR file created or to have the JAR file created within an existing application. After you have selected the JAR file, click the Edit button and add the application client class and any other files needed in the archive.");
    private static String GENERAL_TITLE = localStrings.getLocalString("ui.newappclientwizard.general.title", "General");
    private static String GENERAL_HELP = localStrings.getLocalString("ui.newappclientwizard.general.help", "Select the application client's main class and provide a display name for it. Optionally, you also identify a callback handler for authentication, provide a description, define the manifest classpath for the JAR file, and select the icons for the application client.");
    private static String ENV_TITLE = localStrings.getLocalString("ui.newappclientwizard.env.title", "Environment Entries");
    private static String ENV_HELP = localStrings.getLocalString("ui.newappclientwizard.env.help", "Please list any environment entries that are referenced in the code of the application client. as well as their Java types. \nOptionally, you can provide descriptions and default values to be used for these entries.");
    private static String EJB_REFS_TITLE = localStrings.getLocalString("ui.newappclientwizard.ejb_refs.title", "Enterprise Bean References");
    private static String EJB_REFS_HELP = localStrings.getLocalString("ui.newappclientwizard.ejb_refs.help", "Please list any Enterprise Beans that are referenced in the code of this application client.  In addition to the coded name that appears in the source, indicate the type of bean expected, the type of interface that will be used to access the bean, and the interface classes (including package).\n Optionally, you can provide the name of the enterprise bean referenced, and a description of the enterprise bean referenced.");
    private static String MSG_DEST_REFS_TITLE = localStrings.getLocalString("ui.newappclientwizard.msg_dest_refs.title", "Message Destination References");
    private static String MSG_DEST_REFS_HELP = localStrings.getLocalString("ui.newappclientwizard.msg_dest_refs.help", "If this application client is going to send or receive messages from any message destinations, you will need to provide a reference to these destinations.\n You must provide the name of the destination as it appears in your code, as well as the logical destination name that is used for the destination.\n You must also identity the type of destination required and whether the application client will be producing or consuming messages.\n Optionally, you can provide a description of this reference.");
    private static String JMS_REFS_TITLE = localStrings.getLocalString("ui.newappclientwizard.res_env_refs.title", "Resource Environment References");
    private static String JMS_REFS_HELP = localStrings.getLocalString("ui.newappclientwizard.res_env_refs.help", "Please list any resource environment references in the code of this application client. For each reference you must provide the fully qualified name of a class or interface that specifies the type of the reference\n Optionally, you can also provide a description of the reference.");
    private static String RES_FACT_REFS_TITLE = localStrings.getLocalString("ui.newappclientwizard.res_fact_refs.title", "Resource References");
    private static String RES_FACT_REFS_HELP = localStrings.getLocalString("ui.newappclientwizard.res_fact_refs.help", "Please list any resource factories referenced by this application client.\nFor each of these, indicate the type of resource required, and how the authentication of resource users will be handled (application-managed or container-managed).\nAlso, please provide a description of the expected structure of each resource referenced.");
    protected static String WEBSERVICE_REFS_TITLE = localStrings.getLocalString("ui.newappclientwizard.web_service_ref.title", "Web Service References");
    protected static String WEBSERVICE_REFS_HELP = localStrings.getLocalString("ui.newappclientwizard.web_service_ref.help", "If this application client is going to interact with any web services, you will need to provide a reference to those services.  You must provide the name of the service as it appears in your code and the service interface that it implements.  Optionally, you can identify the WSDL file and JAX-RPC mapping file for the service, and identify a set of endpoints in the service.");
    private static NewAppClientWizard wizardDialog = null;
    protected String currentAddMode = null;
    private ApplicationClientDescriptor applicationClientDescriptor = null;
    private AppClientJarFileInspector appClientJarFileInspector = null;
    private AppClientGeneralInspector appClientGeneralInspector = null;
    private static String savedStartingDirectory = null;

    private static String ERROR_LOADING_CLASS(String v0) {
        return localStrings.getLocalString("ui.newappclientwizard.error_loading_class", "Unable to load class specified in the module.\nPlease consult online help for assistance.\n  {0}", new Object[]{v0});
    }

    public static Descriptor newModule(Frame owner) throws IOException {
        return NewAppClientWizard._showWizard(owner, "New");
    }

    public static Descriptor editModule(Frame owner) throws IOException {
        Print.printStackTrace((String)"AppClients can't be edited!");
        return null;
    }

    private static Descriptor _showWizard(Frame owner, String addMode) throws IOException {
        wizardDialog = new NewAppClientWizard(owner);
        wizardDialog.show(addMode);
        if (wizardDialog.didComplete()) {
            return NewAppClientWizard._completedWizard(wizardDialog);
        }
        return null;
    }

    protected static Descriptor _completedWizard(NewAppClientWizard wizard) throws IOException {
        ApplicationClientDescriptor acd = wizard.getApplicationClientDescriptor();
        ModuleContent fcd = wizard.getModuleContent();
        Application target = wizard.isStandAlone() ? null : wizard.getTargetApplication();
        String archFile = wizard.isStandAlone() ? wizard.getStandAloneArchiveFileName() : null;
        Descriptor desc = NewAppClientWizard.newComponent(acd, fcd, (Descriptor)target, archFile);
        return desc;
    }

    private static Descriptor newComponent(ApplicationClientDescriptor acd, ModuleContent fcd, Descriptor target, String archFileName) throws IOException {
        if (acd == null) {
            throw new RuntimeException("AppClient Descriptor is null");
        }
        if (target instanceof Application) {
            Application app = (Application)target;
            Set acdList = app.getApplicationClientDescriptors();
            String newName = DescriptorTools.createUniqueName(acd.getDisplayName(), acdList);
            if (!newName.equals(acd.getDisplayName())) {
                acd.setDisplayName(newName);
            }
            ModuleArchive modArch = ModuleArchive.newModuleArchive((Descriptor)acd, null, fcd.getEntryNameMap());
            Descriptor md = modArch.addToApplication(app);
            return md;
        }
        ModuleArchive modArch = ModuleArchive.newModuleArchive((Descriptor)acd, archFileName, fcd.getEntryNameMap());
        modArch.save();
        DT.getModuleManager().addModule((Descriptor)acd);
        UIProject.resetProject((Descriptor)acd);
        return acd;
    }

    public String getHelpGroup() {
        return "CW";
    }

    public NewAppClientWizard(Frame owner) {
        super(owner);
        super.setTitle(WIZARD_TITLE_NEW);
        this.addInspectors();
    }

    private void addInspectors() {
        String mode = "WizardMode";
        String UI = UIConfig.UI_PACKAGE;
        super.addIntroPanel(INTRO_HELP);
        this.appClientJarFileInspector = (AppClientJarFileInspector)this.addInspectorPane(UI + "appc.AppClientJarFileInspector", JAR_FILE_TITLE, JAR_FILE_HELP).getPane();
        this.appClientGeneralInspector = (AppClientGeneralInspector)this.addInspectorPane(UI + "appc.AppClientGeneralInspector", GENERAL_TITLE, GENERAL_HELP).getPane();
        this.addNextStepsPanel(NEXT_STEPS_HELP);
    }

    public void show(String addMode) {
        this.currentAddMode = addMode;
        if ("New".equals(addMode)) {
            super.setTitle(WIZARD_TITLE_NEW);
        } else {
            Print.printStackTrace((String)"AppClients can't be edited!");
        }
        this.appClientJarFileInspector.setWizardComponentMode(addMode);
        this.applicationClientDescriptor = null;
        super.show(addMode);
    }

    protected void descriptorChanged() {
        this.delegateNotification(this.getCurrentComponent());
    }

    void delegateNotification(Object insp) {
        if (insp instanceof DescriptorInspector) {
            ((DescriptorInspector)insp).setDescriptor((Descriptor)this.getApplicationClientDescriptor());
            if (insp instanceof InspectorPane) {
                ((InspectorPane)insp).invokeRefresh();
            }
        }
    }

    public Set getLibraryJars() {
        return this.getModuleContent().getLibraryJars();
    }

    public ApplicationClientDescriptor getApplicationClientDescriptor() {
        if (this.applicationClientDescriptor == null) {
            this.applicationClientDescriptor = new ApplicationClientDescriptor();
            this.addDescriptorListener((Descriptor)this.applicationClientDescriptor, new NotificationListener(){

                public void notification(NotificationEvent ae) {
                    NewAppClientWizard.this.descriptorChanged();
                }
            });
        }
        return this.applicationClientDescriptor;
    }

    private Application getTargetApplication() {
        Descriptor d = this.getSelectedParentDescriptor();
        return d instanceof Application ? (Application)d : null;
    }

    public Descriptor getSelectedParentDescriptor() {
        return this.appClientJarFileInspector.getSelectedParentDescriptor();
    }

    public ModuleContent getModuleContent() {
        return this.appClientJarFileInspector.getModuleContent();
    }

    private String getMainClass() {
        return this.appClientGeneralInspector.getMainClass();
    }

    private File writeDescriptorAction() throws Exception {
        File descriptorFile = File.createTempFile("application-client", ".xml");
        AppClientDeploymentDescriptorFile acddf = new AppClientDeploymentDescriptorFile();
        acddf.write((Descriptor)this.getApplicationClientDescriptor(), descriptorFile);
        Print.println((String)localStrings.getLocalString("ui.newappclientwizard.done", "Done {0}", new Object[]{descriptorFile.getAbsolutePath()}));
        return descriptorFile;
    }

    private String convertToFilename(String classname) {
        return classname.replace('.', '/') + ".class";
    }

    private void badClassAction(Throwable ex) {
        StringBuffer dirList = new StringBuffer("");
        Iterator itr = this.getModuleContent().getDirectories();
        while (itr.hasNext()) {
            dirList.append("\n").append(itr.next().toString());
        }
        Print.dprintStackTrace((String)("Unable to load class: " + this.getMainClass()), (Throwable)ex);
        UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.newappclientwizard.cant_load_class", "The class ({0}) could not be loaded from {1}\n{2}", new Object[]{this.getMainClass(), dirList.toString(), ex.toString()}));
    }

    public boolean validateComponent(Component currentComponent) {
        if (currentComponent instanceof AppClientJarFileInspector) {
            if (!this.appClientJarFileInspector.validateTargetLocation()) {
                return false;
            }
            if (this.getModuleContent().getEntryNameMap().isEmpty()) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.newappclientwizard.choose_content", "Please choose the content files for your application client."));
                return false;
            }
            this.appClientGeneralInspector.setModuleContent(this.getModuleContent());
        } else if (currentComponent instanceof AppClientGeneralInspector) {
            String mainClassName = this.getMainClass();
            if (mainClassName == null || mainClassName.equals("")) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.newappclientwizard.add_main_class", "Please add the name of the Main class for your application client."));
                return false;
            }
            try {
                this.getModuleContent().getClassLoader().loadClass(mainClassName);
            }
            catch (Throwable t) {
                this.badClassAction(t);
                return false;
            }
            if (this.getApplicationClientDescriptor().getDisplayName().equals("")) {
                this.getApplicationClientDescriptor().setDisplayName(DEFAULT_NAME);
            }
        }
        return true;
    }

    public void goForward() {
        JComponent currentComponent = super.getCurrentComponent();
        if (currentComponent instanceof AppClientJarFileInspector) {
            this.appClientGeneralInspector.setTargetApplication(this.getTargetApplication());
        } else if (currentComponent instanceof AppClientGeneralInspector) {
            super.okToEnableFinish(currentComponent, true);
        }
        super.goForward();
        currentComponent = super.getCurrentComponent();
        if (currentComponent instanceof DescriptorViewer.UpdateXMLTextArea) {
            ApplicationClientDescriptor acd = this.getApplicationClientDescriptor();
            ((DescriptorViewer.UpdateXMLTextArea)((Object)currentComponent)).updateXMLText((Descriptor)acd);
        }
        this.delegateNotification(currentComponent);
    }

    public String getStandAloneArchiveFileName() {
        return this.appClientJarFileInspector.getFileLocation();
    }

    public boolean isStandAlone() {
        return this.appClientJarFileInspector.isCreateNewStandAlone();
    }

    public void goBackward() {
        super.goBackward();
    }

    public void finishAction() {
        super.finishAction();
        if (this.isStandAlone()) {
            savedStartingDirectory = new File(this.getStandAloneArchiveFileName()).getParent();
            Print.dprint((String)("app client starting directory set to" + savedStartingDirectory));
        }
    }

    public static String getSavedStartingDirectory() {
        return savedStartingDirectory == null ? UIConfig.getStartingDirectory().getAbsolutePath() : savedStartingDirectory;
    }

    public ModuleContent getArchiveModuleContent() {
        return this.appClientGeneralInspector.getModuleContent();
    }

    public Vector getArchiveContents() {
        ModuleContent fcd = this.getArchiveModuleContent();
        return ListTools.toList(fcd.getEntryNameMap().keys());
    }

    public Vector getArchiveClasses() {
        ModuleContent fcd = this.getArchiveModuleContent();
        return this._getArchiveClasses(fcd);
    }

    private Vector _getArchiveClasses(ModuleContent fcd) {
        ClassLoader fcdClassLoader = null;
        try {
            fcdClassLoader = fcd.getClassLoader();
        }
        catch (IOException ioe) {
            Print.println((String)"Unable to obtain ClassLoader");
            return null;
        }
        Vector classList = null;
        try {
            classList = UIJarPackager.getClassNames(fcd, fcdClassLoader);
            if (classList.size() == 0) {
                Print.dprintln((String)"No classes in list");
            }
        }
        catch (Throwable t) {
            Print.dprintStackTrace((String)"Loading class", (Throwable)t);
            UIOptionPane.showErrorDialog(this, NewAppClientWizard.ERROR_LOADING_CLASS(t.toString()));
            return null;
        }
        return classList;
    }
}

