/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.appc;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.appc.NewAppClientWizard;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleContent;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.StringTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIDisplayNameBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIJarPackagerBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.help.CSH;

public class AppClientJarFileInspector
extends InspectorPane
implements UIJarPackagerBox.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AppClientJarFileInspector.class);
    private static String CONTENTS_ACC_DSC = localStrings.getLocalString("ui.appclientgeneralinspector.contents.acc_dsc", "Contents of the Application Client. User can add or delete files.");
    private static String TABNAME = localStrings.getLocalString("ui.appclientjarfileinspector.tabname", "JAR File");
    private static String wizardHelpID = "JAR";
    private static String deployHelpID = "JAR";
    ApplicationClientDescriptor descriptor = null;
    private UIJarPackagerBox contentsPanel = null;
    private UIDisplayNameBox fileDisplayBox = null;
    private ModuleContent contentsMap = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new AppClientJarFileInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return ApplicationClientDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof ApplicationClientDescriptor) {
            this.descriptor = (ApplicationClientDescriptor)obj;
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private AppClientJarFileInspector(String mode) {
        this.setInspectorMode(mode);
        if (this.isWizardMode()) {
            this.contentsMap = new ModuleContent();
        }
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        CSH.setHelpIDString((Component)this, (String)"AppClientJar");
        this.fileDisplayBox = new UIDisplayNameBox(4, this.isWizardMode());
        if (this.isWizardMode()) {
            this.fileDisplayBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    AppClientJarFileInspector.this.descriptor.setDisplayName(AppClientJarFileInspector.this.fileDisplayBox.getDisplayName());
                    AppClientJarFileInspector.this.invokeRefresh();
                }
            });
        } else {
            this.fileDisplayBox.setFileLocation(new File("appClient.jar").getAbsolutePath());
            this.fileDisplayBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    AppClientJarFileInspector.this.descriptor.setDisplayName(AppClientJarFileInspector.this.fileDisplayBox.getDisplayName());
                    AppClientJarFileInspector.this.invokeRefresh();
                }
            });
        }
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 25);
        c.fill = 2;
        c.anchor = 10;
        this.add((Component)this.fileDisplayBox, c);
        this.contentsPanel = new UIJarPackagerBox(this, "appcli", true);
        this.contentsPanel.getAccessibleContext().setAccessibleDescription(CONTENTS_ACC_DSC);
        c.weightx = 1.0;
        c.weighty = 0.7;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 5, 5, 5);
        c.fill = 1;
        c.anchor = 10;
        this.add((Component)this.contentsPanel, c);
    }

    public void setWizardComponentMode(String addMode) {
        this.fileDisplayBox.setWizardComponentMode(addMode);
        this.fileDisplayBox.setSavedStartingDirectory(NewAppClientWizard.getSavedStartingDirectory());
    }

    public void addContentsAction(ModuleContent clsFcd, ModuleContent conFcd, Vector delCon) throws IOException {
        if (this.isWizardMode()) {
            this.contentsMap.removeEntries(delCon);
        } else {
            ModuleArchive.getModuleArchive((Descriptor)this.descriptor).removeArchiveEntries(delCon);
        }
        if (this.isWizardMode()) {
            this.contentsMap.addAll(conFcd);
            UIProject.addArchivePaths((Descriptor)this.descriptor, conFcd);
        } else {
            ModuleArchive.getModuleArchive((Descriptor)this.descriptor).addArchiveEntries(conFcd.getEntryNameMap());
        }
        this.invokeRefresh();
    }

    public Descriptor getSelectedParentDescriptor() {
        return this.fileDisplayBox.getSelectedParentDescriptor();
    }

    public Vector getSelectedBundleContents() {
        if (!this.isWizardMode()) {
            return null;
        }
        Vector<String> contents = new Vector<String>();
        Descriptor sel = this.getSelectedParentDescriptor();
        if (sel instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor appC = (ApplicationClientDescriptor)sel;
            try {
                List v = ModuleArchive.getModuleArchive((Descriptor)appC).getEntryNames();
                Iterator i = v.iterator();
                while (i.hasNext()) {
                    String entry = i.next().toString();
                    contents.addElement(entry);
                }
            }
            catch (Throwable t) {
                Print.printStackTrace((String)"Updating Contents", (Throwable)t);
            }
        }
        return contents;
    }

    public String getFileLocation() {
        return this.fileDisplayBox.getFileLocation();
    }

    public boolean validateTargetLocation() {
        if (!StringTools.isEmpty(this.fileDisplayBox.getDisplayName())) {
            this.descriptor.setDisplayName(this.fileDisplayBox.getDisplayName());
        }
        return this.fileDisplayBox.validateTargetLocation();
    }

    public boolean isCreateNewStandAlone() {
        return this.fileDisplayBox.isCreateNewStandAlone();
    }

    public boolean isCreateNewInApp() {
        return this.fileDisplayBox.isCreateNewInApp();
    }

    public ModuleContent getModuleContent() {
        if (!this.isWizardMode()) {
            return null;
        }
        this.contentsMap.addEntries(UIProject.getProjectFileEntry((Descriptor)this.descriptor));
        return this.contentsMap;
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        if (this.isDeploymentMode()) {
            this.fileDisplayBox.setFileLocation(ModuleArchive.getArchiveUri((Descriptor)this.descriptor));
            this.fileDisplayBox.setDisplayName(this.descriptor.getDisplayName());
            this.contentsPanel.setContents((BundleDescriptor)this.descriptor);
        } else {
            Descriptor d = this.getSelectedParentDescriptor();
            Application app = d instanceof Application ? (Application)d : null;
            this.contentsPanel.setContents((BundleDescriptor)this.descriptor, app, null, this.contentsMap);
        }
        this.invalidate();
        this.validate();
    }
}

